/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/library","sap/ui/core/Element","sap/ui/core/util/File","sap/ui/Device","sap/m/upload/UploaderHttpRequestMethod","sap/m/upload/UploadItem","sap/ui/export/ExportUtils"],function(e,t,a,s,r,o,n,i){"use strict";var d=a.extend("sap.m.upload.UploaderTableItem",{metadata:{library:"sap.m",publicMethods:["uploadItem","downloadItem"],properties:{uploadUrl:{type:"string",defaultValue:null},downloadUrl:{type:"string",defaultValue:null},httpRequestMethod:{type:"sap.m.upload.UploaderHttpRequestMethod",defaultValue:o.Post},useMultipart:{type:"boolean",defaultValue:false}},events:{uploadStarted:{parameters:{item:{type:"any"}}},uploadProgressed:{parameters:{item:{type:"any"},loaded:{type:"int"},total:{type:"int"}}},uploadCompleted:{parameters:{item:{type:"any"},responseXHR:{type:"object"}}},uploadTerminated:{parameters:{item:{type:"sap.m.upload.UploadItem"}}}}}});d.prototype.init=function(){this._mRequestHandlers={}};d.uploadFile=function(e,t,a){var s=new window.XMLHttpRequest;var o=this.getHttpRequestMethod();return new Promise(function(n,i){s.open(o,t,true);if((r.browser.edge||r.browser.internet_explorer)&&e.type&&s.readyState===1){s.setRequestHeader("Content-Type",e.type)}if(a){a.forEach(function(e){s.setRequestHeader(e.getKey(),e.getText())})}s.onreadystatechange=function(){if(this.readyState===window.XMLHttpRequest.DONE){if(this.status===200){n(this)}else{i(this)}}};s.send(e)})};d.prototype.uploadItem=function(e,t){var a=new window.XMLHttpRequest,s=e.getFileObject(),o=this,n={xhr:a,item:e},i=this.getHttpRequestMethod(),d=e.getUploadUrl()||this.getUploadUrl();const p=()=>!window.navigator.onLine;const l=()=>{o.fireUploadCompleted({item:e,responseXHR:{response:null,responseXML:null,responseText:JSON.stringify({error:"Internet is offline. Please check your connection and try again."}),readyState:4,status:0,headers:""}})};a.open(i,d,true);if((r.browser.edge||r.browser.internet_explorer)&&s.type&&a.readyState===1){a.setRequestHeader("Content-Type",s.type)}if(t){t.forEach(function(e){a.setRequestHeader(e.getKey(),e.getText())})}a.upload.addEventListener("progress",function(t){o.fireUploadProgressed({item:e,loaded:t.loaded,total:t.total,aborted:false})});a.onreadystatechange=function(){var t=o._mRequestHandlers[e.getId()],a={};if(this.readyState===window.XMLHttpRequest.DONE&&!t.aborted){a={response:this.response,responseXML:this.responseXML,responseText:this.responseText,readyState:this.readyState,status:this.status,headers:this.getAllResponseHeaders()};o.fireUploadCompleted({item:e,responseXHR:a})}};if(this.getUseMultipart()){var u=new window.FormData;var f=s?s.name:null;if(s instanceof window.Blob&&f){u.append(f,s,s.name)}else{u.append(f,s)}u.append("_charset_","UTF-8");s=u;this._mRequestHandlers[e.getId()]=n;if(p()){this.fireUploadStarted({item:e});l()}else{a.send(s);this.fireUploadStarted({item:e})}}else{this._mRequestHandlers[e.getId()]=n;if(p()){this.fireUploadStarted({item:e});l()}else{a.send(s);this.fireUploadStarted({item:e})}}};d.prototype.download=function(a,o,d){var p=this.getDownloadUrl()||a.getUrl();if(r.browser.name==="sf"){d=false}if(!a.getUrl()){e.warning("Items to download do not have a URL.");return false}else if(d){var l=null,u=new window.XMLHttpRequest;u.open("GET",p);o.forEach(function(e){u.setRequestHeader(e.getKey(),e.getText())});u.responseType="blob";u.onload=function(){let e=n;if(a instanceof n){e=n}var t=a.getFileName(),r=e._splitFileName(t,false);l=u.response;if(l instanceof window.Blob){const e=`${r.name}.${r.extension}`;i.saveAsFile(l,e)}else if(typeof l==="string"){s.save(l,r.name,r.extension,a.getMediaType(),"utf-8")}};u.send();return true}else{t.URLHelper.redirect(p,true);return true}};d.prototype.terminateItem=function(e){var t=this._mRequestHandlers[e.getId()],a=this;t.xhr.onabort=function(){t.aborted=false;a.fireUploadTerminated({item:e})};t.aborted=true;t.xhr.abort()};return d});
//# sourceMappingURL=UploaderTableItem.js.map