/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/Popup","sap/m/Popover","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","./NavigationListItem","./NavigationListMenuItem","./NavigationListRenderer","sap/m/Menu","sap/m/MenuItem","sap/base/Log"],function(e,t,i,o,s,n,a,r,l,p,d,c,g,m,u,f){"use strict";const h=s.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItemBase",multiple:true,singularName:"item"},_overflowItem:{type:"sap.tnt.NavigationListItem",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}},itemPress:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:g});h.prototype.init=function(){this._oItemNavigation=new l;this._oItemNavigation.setCycling(false).setPageSize(10).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._handleThemeAppliedBound=this._handleThemeApplied.bind(this)};h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}this._deregisterResizeHandler();i.detachApplied(this._handleThemeAppliedBound)};h.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();const e=this.getSelectedKey();this.setSelectedKey(e)};h.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());this._updateNavItems();if(this.getExpanded()){return}this.getDomRef().scrollTop=0;this._sResizeListenerId=n.register(this.getDomRef().parentNode,this._resize.bind(this));i.attachApplied(this._handleThemeAppliedBound)};h.prototype._deregisterResizeHandler=function(){if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};h.prototype._handleThemeApplied=function(){i.detachApplied(this._handleThemeAppliedBound);this._updateOverflowItems()};h.prototype._resize=function(){this._updateOverflowItems()};h.prototype._updateOverflowItems=function(){var e=this.getDomRef();if(this.getExpanded()||!e){return}const t=e.querySelector(".sapTntNLOverflow");if(!t){return}t.classList.add("sapTntNLIHidden");const i=[...e.querySelectorAll("ul > :not(.sapTntNLOverflow)")];let o=i.reduce((e,t)=>{t.classList.remove("sapTntNLIHidden");return e+t.offsetHeight},0);const{paddingTop:s,paddingBottom:n}=window.getComputedStyle(e);const a=e.offsetHeight-parseFloat(s)-parseFloat(n);if(a>=o){return}t.classList.remove("sapTntNLIHidden");o=t.offsetHeight;let r=e.querySelector(".sapTntNLISelected");if(r){r=r.parentNode;const{marginTop:e,marginBottom:t}=window.getComputedStyle(r);o+=r.offsetHeight+parseFloat(e)+parseFloat(t)}i.forEach(e=>{if(e===r){return}const{marginTop:t,marginBottom:i}=window.getComputedStyle(e);o+=e.offsetHeight+parseFloat(t)+parseFloat(i);if(o>=a){e.classList.add("sapTntNLIHidden")}})};h.prototype._getOverflowItem=function(){let e=this.getAggregation("_overflowItem");if(!e){e=new d({text:t.getResourceBundleFor("sap.tnt").getText("NAVIGATION_LIST_NAVIGATION_OVERFLOW"),icon:"sap-icon://overflow",selectable:false,select:this._overflowPress.bind(this)});e._isOverflow=true;this.setAggregation("_overflowItem",e)}return e};h.prototype._overflowPress=function(e){const t=e.getSource();t.getDomRef().querySelector(".sapTntNLI").classList.add("sapTntNLIActive");const i=this._createOverflowMenu(t);i.openBy(t,false,a.Dock.EndCenter)};h.prototype._createOverflowMenu=function(e){const t=new m({items:this._createNavigationMenuItems(),itemSelected:e=>{const i=e.getParameter("item");const o=i._navItem;o._firePress({item:o});if(o.getSelectable()){this._selectItem({item:o});const e=this.getDomRef().querySelector(".sapTntNLISelected [tabindex]");e?.focus()}if(o.getSelectable()||!i.getItems().length){t.close();t.destroy()}},closed:function(){e.getDomRef().querySelector(".sapTntNLI").classList.remove("sapTntNLIActive")}});t.addStyleClass("sapTntNLMenu");t._handleMenuItemSelect=function(e){const t=e.getParameter("item");if(!t){return}const i=this._findMenuItemByUnfdMenuItem(t);if(i){this.fireItemSelected({item:i})}}.bind(t);t._createVisualMenuItemFromItem=function(e){var t=this._generateUnifiedMenuItemId(e.getId()),i=o.getElementById(t),s=e.getCustomData(),n;if(i){return i}i=new c({id:t,icon:e.getIcon(),text:e.getText(),startsSection:e.getStartsSection(),tooltip:e.getTooltip(),visible:e.getVisible(),enabled:e.getEnabled(),href:e._navItem.getHref(),target:e._navItem.getTarget()});for(n=0;n<s.length;n++){e._addCustomData(i,s[n])}e.aDelegates.forEach(function(e){i.addEventDelegate(e.oDelegate,e.vThis)});return i}.bind(t);this.addDependent(t);return t};h.prototype._createNavigationMenuItems=function(){var e=[],t=[];this.getItems().forEach(t=>{if(t.isA("sap.tnt.NavigationListGroup")){e.push(...t.getItems())}else{e.push(t)}});e.forEach(function(e){if(!e.getVisible()||!e.getDomRef().classList.contains("sapTntNLIHidden")){return}var i=new u({icon:e.getIcon(),text:e.getText(),tooltip:e.getTooltip_AsString()||e.getText(),enabled:e.getEnabled()});i._navItem=e;e.getItems().forEach(function(e){var t=new u({icon:e.getIcon(),text:e.getText(),tooltip:e.getTooltip_AsString()||e.getText(),enabled:e.getEnabled()});t._navItem=e;i.addItem(t)});t.push(i)});return t};h.prototype._updateNavItems=function(){const e=this._getFocusDomRefs();this._oItemNavigation.setItemDomRefs(e)};h.prototype._getFocusDomRefs=function(){const e=this.getItems().flatMap(e=>e._getFocusDomRefs()),t=this._getOverflowItem().getDomRef("a");if(!this.getExpanded()&&t){e.push(t)}return e};h.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=8;this._offsets=["0 -8","8 0","0 8","-8 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"]}};h.prototype._selectItem=function(e){this.fireItemSelect(e);this.setSelectedItem(e.item)};h.prototype._findItemByKey=function(e){const t=this.findAggregatedObjects(true,e=>e.isA("sap.tnt.NavigationListItem"));return t.find(t=>t._getUniqueKey()===e)};h.prototype.setSelectedKey=function(e){const t=this._findItemByKey(e);this.setSelectedItem(t);return this.setProperty("selectedKey",e,true)};h.prototype.getSelectedItem=function(){return o.getElementById(this.getAssociation("selectedItem"))||null};h.prototype.setSelectedItem=function(e){let t;if(this._selectedItem){this._selectedItem._toggle(false)}if(!e){this._selectedItem=null}const i=e&&e.isA&&e.isA("sap.tnt.NavigationListItem");if(typeof e!="string"&&!i){this.setAssociation("selectedItem",null,true);this._updateOverflowItems();e=null}this.setAssociation("selectedItem",e,true);if(typeof e=="string"){t=o.getElementById(e)}else if(i){t=e}else{f.warning("Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.");return this}this.setProperty("selectedKey",t._getUniqueKey(),true);t._toggle(true);this._selectedItem=t;this._updateOverflowItems();return this};h.prototype._openPopover=function(e,t){const i=e.getDomRef().querySelector(".sapTntNLI");i.classList.add("sapTntNLIActive");let o=t.getSelectedItem();if(o&&t.isGroupSelected){o=null}this._oPopover=new r({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:o,afterClose:()=>{if(this._oPopover){this._oPopover.destroy();this._oPopover=null;i.classList.remove("sapTntNLIActive")}},content:t,ariaLabelledBy:p.getStaticId("sap.tnt","NAVIGATION_LIST_DIALOG_TITLE")}).addStyleClass("sapContrast sapContrastPlus sapTntNLPopover");this._oPopover._adaptPositionParams=this._adaptPopoverPositionParams;this._oPopover.openBy(e.getDomRef("a"))};h.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close()}};h.prototype._containsIcon=function(){const e=this.findAggregatedObjects(true,e=>e.isA("sap.tnt.NavigationListItem")&&!e._isOverflow&&e.getProperty("icon"));return!!e.length};return h});
//# sourceMappingURL=NavigationList.js.map