/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/util/openWindow","sap/ui/util/defaultLinkTypes","./NavigationListItemBase"],function(e,t,s,i,n,o,r,a,l,p){"use strict";var c=o.TextAlign;var g=o.TextDirection;var d=e.NavigationListItemDesign;var f=o.aria.HasPopup;const h="sap-icon://navigation-right-arrow";const u="sap-icon://navigation-down-arrow";const I=p.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Appearance",defaultValue:true},selectable:{type:"boolean",group:"Behavior",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null},design:{type:"sap.tnt.NavigationListItemDesign",group:"Behavior",defaultValue:d.Default},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:f.None}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});I._getInvisibleText=function(){if(!this._invisibleText){this._invisibleText=(new s).toStatic()}return this._invisibleText};I.prototype.createListForPopup=function(){const e=this.getItems(),t=this.getNavigationList(),s=t.getSelectedItem();let i;const n=e.filter(e=>e.getVisible()).map(e=>{const t=new I({key:e.getId(),text:e.getText(),textDirection:e.getTextDirection(),enabled:e.getEnabled(),selectable:e.getSelectable(),href:e.getHref(),target:e.getTarget(),tooltip:e.getTooltip()});if(s===e){i=t}return t});const o=new I({expanded:true,hasExpander:false,selectable:this.getSelectable(),key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),tooltip:this.getTooltip(),items:n});const r=t.getMetadata().getClass().prototype.constructor;const a=new r({itemSelect:this.onPopupItemSelect.bind(this),itemPress:this.onPopupItemPress.bind(this),items:o}).addStyleClass("sapTntNLPopup");if(s==this){i=o;a.isGroupSelected=true}a.setSelectedItem(i);return a};I.prototype.onPopupItemSelect=function(e){const s=e.getParameter("item"),i=t.getElementById(s.getKey());i._selectItem()};I.prototype.onPopupItemPress=function(e){const s=e.getParameter("item"),i=t.getElementById(s.getKey());i._firePress({item:i})};I.prototype._selectItem=function(){const e={item:this};this.fireSelect(e);if(this.getSelectable()){this.getNavigationList()._selectItem(e)}this._openUrl()};I.prototype._openUrl=function(){const e=this.getHref();if(e){a(e,this.getTarget()||"_self")}};I.prototype._getAccessibilityRef=function(){return this.getDomRef().querySelector(".sapTntNLIFirstLevel")};I.prototype.ontap=function(e){if(p.prototype.ontap.apply(this,arguments)){return}e.preventDefault();if(this.getLevel()>0){if(this.getEnabled()&&this.getAllParentsEnabled()){this._selectItem()}return}const t=this.getNavigationList();if(t.getExpanded()||!this.getItems().length){this._selectItem()}else{const e=this.createListForPopup();t._openPopover(this,e)}};I.prototype.onkeydown=function(e){if(e.isMarked("subItem")){return}const t=this._hasModifierKey(e);if((e.key?e.key==="Enter":e.keyCode===r.ENTER)&&!t){this.getDomRef().classList.add("sapTntNLIActive");this.ontap(e)}else if((e.key?e.key===" ":e.keyCode===r.SPACE)&&!t){this.getDomRef().classList.add("sapTntNLIActive")}if(this.getHref()&&this.getTarget()==="_blank"){this.getDomRef().classList.remove("sapTntNLIActive")}p.prototype.onkeydown.apply(this,arguments)};I.prototype.onkeyup=function(e){if(e.isMarked("subItem")){return}const t=this._hasModifierKey(e);if((e.key?e.key==="Enter":e.keyCode===r.ENTER)&&!t){this.getDomRef().classList.remove("sapTntNLIActive")}else if(e.key?e.key===" ":e.keyCode===r.SPACE){this.getDomRef().classList.remove("sapTntNLIActive");if(!t){this.ontap(e)}}if(e.srcControl.getLevel()===1){e.setMarked("subItem")}};I.prototype.render=function(e,t){if(!this.getVisible()){return}if(this.getLevel()===0){this.renderFirstLevelNavItem(e,t)}else{this.renderSecondLevelNavItem(e,t)}};I.prototype.renderFirstLevelNavItem=function(e,t){const s=this._getVisibleItems(this),i=this._isListExpanded(),n=this.getEnabled()||this.getAllParentsEnabled();e.openStart("li",this).attr("role","none");if(!i){if(s.length&&n){e.class("sapTntNLINotExpandedTriangle")}if(this._isOverflow){e.class("sapTntNLOverflow").class("sapTntNLIHidden")}}e.openEnd();const o=`${this.getId()}-subtree`;this.renderMainElement(e,t,o);if(i&&s.length){e.openStart("ul",o).class("sapTntNLIItemsContainer").accessibilityState({role:"group",label:this.getText()});if(!this.getExpanded()){e.class("sapTntNLIItemsContainerHidden")}e.openEnd();s.forEach(s=>s.render(e,t));e.close("ul")}e.close("li")};I.prototype._renderExternalLinkIcon=function(e){if(!(this.getHref()&&this.getTarget()==="_blank")){return}const t=this._getExternalIcon();e.renderControl(t)};I.prototype.renderMainElement=function(e,t,s){const i=this._isListExpanded(),n=this._getVisibleItems(this),o=!this.getEnabled()||!this.getAllParentsEnabled(),r=this.getExpanded(),a=this.getSelectable(),l=this.getDesign(),p=!!n.length&&this.getHasExpander();e.openStart("div").class("sapTntNLI").class("sapTntNLIFirstLevel");if(o){e.class("sapTntNLIDisabled")}let c=false;if(a&&t._selectedItem===this){e.class("sapTntNLISelected");c=true}if(!i&&n.includes(t._selectedItem)){e.class("sapTntNLISelected");c=true}if(p){e.class("sapTntNLIWithExpander")}if(a&&n.length){e.class("sapTntNLITwoClickAreas")}const g={};if(this.getAriaHasPopup()!==f.None){g.haspopup=this.getAriaHasPopup()}if(l===d.Action){e.class("sapTntNLIAction")}if(!a){e.class("sapTntNLIUnselectable")}if(this._isInsidePopover()){e.class("sapTntNLIInPopover")}if(!i){g.role=a?"menuitemradio":"menuitem";if(n.length){g.haspopup="tree"}if(this._isOverflow){g.haspopup="menu"}if(a){g.checked=t._selectedItem===this;g.selected=c}else{g.selected=false}g.roledescription=this._resourceBundleTnt.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")}else{g.role="treeitem";if(a){g.selected=c}else{g.selected=false}if(c){g.current="page"}if(n.length){g.owns=s;g.expanded=r}}e.openEnd();this._renderStartLink(e,g,o);this._renderIcon(e);this._renderText(e);this._renderExternalLinkIcon(e);if(i){const t=this._getExpandIconControl();t.setVisible(p).setSrc(r?u:h).setTooltip(this._getExpandIconTooltip(!r));e.renderControl(t)}if(!i&&this.getItems().length){const t=this._getExpandIconControl().setSrc(h);e.renderControl(t)}this._renderCloseLink(e);e.close("div")};I.prototype.renderSecondLevelNavItem=function(e,t){const s=!this.getEnabled()||!this.getAllParentsEnabled();e.openStart("li",this).class("sapTntNLI").class("sapTntNLISecondLevel").attr("role","none");let i=false;if(this.getSelectable()&&t._selectedItem===this){e.class("sapTntNLISelected");i=true}if(s){e.class("sapTntNLIDisabled")}if(this._isInsidePopover()){e.class("sapTntNLIInPopover")}e.openEnd();const n={role:"treeitem",current:this._isListExpanded()&&i?"page":undefined,selected:i};this._renderStartLink(e,n,s);this._renderIcon(e);this._renderText(e);this._renderExternalLinkIcon(e);this._renderCloseLink(e);e.close("li")};I.prototype._renderStartLink=function(e,t,s){const i=this.getHref(),n=this.getTarget();e.openStart("a",`${this.getId()}-a`).accessibilityState(this,{...t});const o=this.getTooltip_AsString()||this.getText();if(o){e.attr("title",o)}if(!s){e.attr("tabindex","-1")}if(i){e.attr("href",i)}if(n){e.attr("target",n).attr("rel",l("",n))}e.openEnd()};I.prototype._renderCloseLink=function(e){e.close("a")};I.prototype._renderIcon=function(e){const t=this.getIcon(),s=n.getIconInfo(t);e.openStart("span").class("sapUiIcon").class("sapTntNLIIcon").attr("aria-hidden","true");if(t){if(s&&!s.suppressMirroring){e.class("sapUiIconMirrorInRTL")}if(s){e.attr("data-sap-ui-icon-content",s.content).style("font-family",`'${s.fontFamily}'`)}}e.openEnd().close("span")};I.prototype._renderText=function(e){e.openStart("span").class("sapMText").class("sapTntNLIText").class("sapMTextNoWrap");const t=this.getTextDirection();if(t!==g.Inherit){e.attr("dir",t.toLowerCase())}const s=i.getTextAlign(c.Begin,t);if(s){e.style("text-align",s)}e.openEnd().text(this.getText()).close("span")};I.prototype._toggle=function(e){const t=this.getNavigationList(),s=this._isListExpanded();if(!t||!t.getDomRef()){return}const i=this.getDomRef();if(this.getLevel()===0){const t=i?.querySelector(".sapTntNLIFirstLevel");t?.classList.toggle("sapTntNLISelected",e)}if(this.getLevel()!==0){if(s){i?.classList.toggle("sapTntNLISelected",e)}else{const t=this.getParent().getDomRef()?.querySelector(".sapTntNLIFirstLevel");t?.classList.toggle("sapTntNLISelected",e);if(e){t?.classList.toggle("sapTntNLINoHoverEffect",e)}}}this._syncAriaAttributes(this.getFocusDomRef(),e,s);t._closePopover()};I.prototype._syncAriaAttributes=function(e,t,s){if(!e){return}if(s){if(t){e.setAttribute("aria-current","page");e.setAttribute("aria-selected","true")}else{e.removeAttribute("aria-current");e.setAttribute("aria-selected","false")}}else{e.setAttribute("aria-checked",t?"true":"false")}};I.prototype._getFocusDomRefs=function(){const e=[];if(!this.getEnabled()||!this.getVisible()){return e}if(!this._isInsidePopover()||this.getSelectable()&&this.getLevel()===0){e.push(this.getDomRef("a"))}if(this._isListExpanded()&&this.getExpanded()){e.push(...this.getDomRef().querySelectorAll(".sapTntNLISecondLevel:not(.sapTntNLIDisabled) a"))}return e};I.prototype._getVisibleItems=function(e){return e.getItems().filter(e=>e.getVisible())};I.prototype.onclick=function(e){if(this.getHref()){e.preventDefault()}};I.prototype.onmousedown=function(e){if(this.getHref()){e.preventDefault()}};I.prototype.onfocusout=function(){var e=this.getDomRef()?.querySelector(".sapTntNLIFirstLevel");if(e){e.classList.remove("sapTntNLINoHoverEffect")}};I.prototype.onmouseout=function(){const e=this.getDomRef()?.querySelector(".sapTntNLIFirstLevel");const t=this.getNavigationList();const s=this.getItems().find(e=>e===t.getSelectedItem());if(e&&(this===t.getSelectedItem()||s)){e.classList.add("sapTntNLINoHoverEffect")}};I.prototype.onmouseover=I.prototype.onfocusout;I.prototype._hasModifierKey=function e(t){return t.shiftKey||t.altKey||t.ctrlKey||t.metaKey};return I});
//# sourceMappingURL=NavigationListItem.js.map