/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/events/KeyCodes","sap/base/i18n/Localization"],function(t,e,i,n,s,o){"use strict";const r="sap-icon://navigation-right-arrow";const a="sap-icon://navigation-down-arrow";const p="sap-icon://arrow-right";const l=e.extend("sap.tnt.NavigationListItemBase",{metadata:{library:"sap.tnt",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_externalLinkIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});l.prototype.init=function(){this._resourceBundleCore=n.getResourceBundleFor("sap.ui.core");this._resourceBundleTnt=n.getResourceBundleFor("sap.tnt")};l.prototype.exit=function(){this._resourceBundleCore=null;this._resourceBundleTnt=null};l.prototype.getLevel=function(){const t=0;const e=this.getParent();if(e&&e.isA("sap.tnt.NavigationListItem")){return e.getLevel()+1}return t};l.prototype.getNavigationList=function(){let t=this.getParent();while(t&&!t.isA("sap.tnt.NavigationList")){t=t.getParent()}return t};l.prototype.getAllParentsEnabled=function(){let t=this.getParent();while(t&&!t.isA("sap.tnt.NavigationList")){if(!t.getEnabled()){return false}t=t.getParent()}return true};l.prototype._isListExpanded=function(){const t=this.getNavigationList();if(!t){return false}return t.getExpanded()||t.hasStyleClass("sapTntNLPopup")};l.prototype._getUniqueKey=function(){const t=this.getKey();return t?t:this.getId()};l.prototype._getFocusDomRefs=function(){};l.prototype._getAccessibilityRef=function(){};l.prototype._getExpandIconControl=function(){let t=this.getAggregation("_expandIconControl");if(!t){const e=this.getExpanded();t=new i({src:e?a:r,visible:!!this.getItems()?.length&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!e)}).addStyleClass(`sapTntNLIExpandIcon ${this._getExpandIconStyleClass()}`);this.setAggregation("_expandIconControl",t,true)}return t};l.prototype._getExternalIcon=function(){var t=this.getAggregation("_externalLinkIconControl");if(!t){t=new i({src:p}).addStyleClass(`sapTntNLIExternalLinkIcon`);this.setAggregation("_externalLinkIconControl",t)}return t};l.prototype._getExpandIconStyleClass=function(){return""};l.prototype._getExpandIconTooltip=function(t){if(!this.getEnabled()||!this.getAllParentsEnabled()){return""}const e=t?"Icon.expand":"Icon.collapse";return this._resourceBundleCore.getText(e)};l.prototype.getFocusDomRef=function(){const t=this.getDomRef()?.querySelector("[tabindex]");if(!t){return null}return t};l.prototype.onkeydown=function(t){if(t.key?t.key===" ":t.keyCode===s.SPACE){t.preventDefault()}if(!this._isListExpanded()){return}if(t.isMarked("subItem")){return}if(t.srcControl.getLevel()===1){t.setMarked("subItem")}if(this.getLevel()!==0){return}const e=o.getRTL();if(t.shiftKey&&t.which==189||t.which==s.NUMPAD_MINUS||t.which==s.ARROW_RIGHT&&e||t.which==s.ARROW_LEFT&&!e){if(this.collapse()){t.preventDefault();t.stopPropagation()}}else if(t.which==s.NUMPAD_PLUS||t.shiftKey&&t.which==s.PLUS||t.which==s.ARROW_LEFT&&e||t.which==s.ARROW_RIGHT&&!e){if(this.expand()){t.preventDefault();t.stopPropagation()}}};l.prototype.ontap=function(t){const e={item:this};if(this.getEnabled()&&!t.srcControl.isA("sap.ui.core.Icon")&&!this._isOverflow&&!(!this.getNavigationList().getExpanded()&&this.getItems().length)){this._firePress(e);t.stopPropagation()}if(t.isMarked("subItem")){return true}t.setMarked("subItem");if(!this.getEnabled()||!this.getAllParentsEnabled()){return true}if(this._handleExpanderClick(t)){return true}return false};l.prototype._firePress=function(t){const e=this.getNavigationList();e?.fireItemPress({item:this});this.firePress(t)};l.prototype._handleExpanderClick=function(t){const e=this._getExpanderActivationTarget(),i=t.target.closest(e);if(!this._isListExpanded()||this.getLevel()!==0||!i){return false}if(this.getExpanded()){this.collapse()}else{this.expand()}return true};l.prototype._getExpanderActivationTarget=function(){if(!this.getSelectable()&&!(this.getHref()&&this.getTarget()==="_blank")){return".sapTntNLIFirstLevel"}return".sapTntNLIExpandIcon"};l.prototype.expand=function(){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()!==0){return false}this.setProperty("expanded",true,true);this._getExpandIconControl().setSrc(a).setTooltip(this._getExpandIconTooltip(false));this._getAccessibilityRef().setAttribute("aria-expanded","true");const t=this.$().find(".sapTntNLIItemsContainer").first();t.stop(true,true).slideDown("fast",()=>{this._updateContainerVisibility();this.getNavigationList()?._updateNavItems()});return true};l.prototype._updateContainerVisibility=function(){const t=this.getDomRef()?.querySelector(".sapTntNLIItemsContainer");if(t){if(this.getExpanded()){t.classList.remove("sapTntNLIItemsContainerHidden")}else{t.classList.add("sapTntNLIItemsContainerHidden")}}};l.prototype.collapse=function(){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()!==0){return false}this.setProperty("expanded",false,true);this._getExpandIconControl().setSrc(r).setTooltip(this._getExpandIconTooltip(true));this._getAccessibilityRef().setAttribute("aria-expanded","false");const t=this.$().find(".sapTntNLIItemsContainer").first();t.stop(true,true).slideUp("fast",()=>{this._updateContainerVisibility();this.getNavigationList()?._updateNavItems()});return true};l.prototype._isInsidePopover=function(){return!!this.getNavigationList()?.hasStyleClass("sapTntNLPopup")};return l});
//# sourceMappingURL=NavigationListItemBase.js.map