//@ui5-bundle sap/tnt/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/IllustratedMessageType", ["sap/ui/base/DataType"],function(t){"use strict";var n={Avatar:"tnt-Avatar",Calculator:"tnt-Calculator",ChartArea:"tnt-ChartArea",ChartArea2:"tnt-ChartArea2",ChartBar:"tnt-ChartBar",ChartBPMNFlow:"tnt-ChartBPMNFlow",ChartBullet:"tnt-ChartBullet",ChartDoughnut:"tnt-ChartDoughnut",ChartFlow:"tnt-ChartFlow",ChartGantt:"tnt-ChartGantt",ChartOrg:"tnt-ChartOrg",ChartPie:"tnt-ChartPie",CodePlaceholder:"tnt-CodePlaceholder",Company:"tnt-Company",Compass:"tnt-Compass",Components:"tnt-Components",Dialog:"tnt-Dialog",ExternalLink:"tnt-ExternalLink",FaceID:"tnt-FaceID",Fingerprint:"tnt-Fingerprint",Handshake:"tnt-Handshake",Help:"tnt-Help",Lock:"tnt-Lock",Mission:"tnt-Mission",MissionFailed:"tnt-MissionFailed",NoApplications:"tnt-NoApplications",NoFlows:"tnt-NoFlows",NoUsers:"tnt-NoUsers",Radar:"tnt-Radar",RoadMap:"tnt-RoadMap",Secrets:"tnt-Secrets",Services:"tnt-Services",SessionExpired:"tnt-SessionExpired",SessionExpiring:"tnt-SessionExpiring",Settings:"tnt-Settings",Success:"tnt-Success",SuccessfulAuth:"tnt-SuccessfulAuth",Systems:"tnt-Systems",Teams:"tnt-Teams",Tools:"tnt-Tools",Tutorials:"tnt-Tutorials",UnableToLoad:"tnt-UnableToLoad",Unlock:"tnt-Unlock",UnsuccessfulAuth:"tnt-UnsuccessfulAuth",User2:"tnt-User2"};t.registerEnum("sap.tnt.IllustratedMessageType",n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/InfoLabel", ["./library","sap/ui/core/ControlBehavior","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Control","./InfoLabelRenderer"],function(e,t,r,a,o,i){"use strict";var n=e.RenderMode;var p=a.TextDirection;var u=o.extend("sap.tnt.InfoLabel",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.tnt",properties:{text:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"},renderMode:{type:"sap.tnt.RenderMode",defaultValue:n.Loose,group:"Appearance"},colorScheme:{type:"int",group:"Misc",defaultValue:7},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:p.Inherit},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""}}},renderer:i});u.prototype.init=function(){if(t.isAccessibilityEnabled()&&!i._sAriaText){var e=r.getResourceBundleFor("sap.tnt");i._sAriaText=e.getText("INFOLABEL_DEFAULT");i._sAriaTextEmpty=e.getText("INFOLABEL_EMPTY")}};u.prototype.getFormDoNotAdjustWidth=function(){return true};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/InfoLabelRenderer", ["./library","sap/ui/core/library","sap/base/Log","sap/ui/core/IconPool"],function(e,t,n,a){"use strict";var o=e.RenderMode;var s=t.TextDirection;var i={apiVersion:2};i.render=function(e,t){var r=t.getColorScheme(),l=t.getText(),c=t.getTextDirection(),p=t.getWidth(),f=t.getTooltip(),d=t.getIcon();if(r<1||r>10){r=7;n.warning("sap.tnt.InfoLabel: colorScheme value is set to the default value of 7. Provided value should be between 1 and 10")}e.openStart("div",t).class("sapTntInfoLabel");if(t.getRenderMode()===o.Narrow){e.class("sapTntInfoLabelRenderModeNarrow")}if(t.getDisplayOnly()){e.class("sapTntInfoLabelDisplayOnly")}if(l===""){e.class("sapTntInfoLabelNoText")}if(p){e.style("width",p)}if(d){e.class("sapTntInfoLabelWithIcon")}if(f){e.attr("title",f)}e.class("backgroundColor"+r).openEnd();e.openStart("span").class("sapTntInfoLabelInner");if(c!==s.Inherit){e.attr("dir",c.toLowerCase())}e.openEnd();if(d){if(l&&d){e.icon(d,[],{title:""})}else{e.icon(d)}}e.openStart("span").class("sapTntInfoLabelText").openEnd();e.text(l);e.close("span");e.close("span");if(i._sAriaText){e.openStart("span").class("sapUiPseudoInvisibleText").openEnd();if(l){e.text(i._sAriaText)}else if(!d){e.text(i._sAriaTextEmpty)}else{if(f){e.text(f+" "+i._sAriaText)}else if(a.getIconInfo(t.getIcon()).text){e.text(a.getIconInfo(t.getIcon()).text+" "+i._sAriaText)}else{e.text(a.getIconInfo(t.getIcon()).name+" "+i._sAriaText)}}e.close("span")}e.close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationList", ["./library","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/Popup","sap/m/Popover","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","./NavigationListItem","./NavigationListMenuItem","./NavigationListRenderer","sap/m/Menu","sap/m/MenuItem","sap/base/Log"],function(e,t,i,o,s,n,a,r,l,p,d,c,g,m,u,f){"use strict";const h=s.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItemBase",multiple:true,singularName:"item"},_overflowItem:{type:"sap.tnt.NavigationListItem",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}},itemPress:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:g});h.prototype.init=function(){this._oItemNavigation=new l;this._oItemNavigation.setCycling(false).setPageSize(10).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._handleThemeAppliedBound=this._handleThemeApplied.bind(this)};h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}this._deregisterResizeHandler();i.detachApplied(this._handleThemeAppliedBound)};h.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();const e=this.getSelectedKey();this.setSelectedKey(e)};h.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());this._updateNavItems();if(this.getExpanded()){return}this.getDomRef().scrollTop=0;this._sResizeListenerId=n.register(this.getDomRef().parentNode,this._resize.bind(this));i.attachApplied(this._handleThemeAppliedBound)};h.prototype._deregisterResizeHandler=function(){if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};h.prototype._handleThemeApplied=function(){i.detachApplied(this._handleThemeAppliedBound);this._updateOverflowItems()};h.prototype._resize=function(){this._updateOverflowItems()};h.prototype._updateOverflowItems=function(){var e=this.getDomRef();if(this.getExpanded()||!e){return}const t=e.querySelector(".sapTntNLOverflow");if(!t){return}t.classList.add("sapTntNLIHidden");const i=[...e.querySelectorAll("ul > :not(.sapTntNLOverflow)")];let o=i.reduce((e,t)=>{t.classList.remove("sapTntNLIHidden");return e+t.offsetHeight},0);const{paddingTop:s,paddingBottom:n}=window.getComputedStyle(e);const a=e.offsetHeight-parseFloat(s)-parseFloat(n);if(a>=o){return}t.classList.remove("sapTntNLIHidden");o=t.offsetHeight;let r=e.querySelector(".sapTntNLISelected");if(r){r=r.parentNode;const{marginTop:e,marginBottom:t}=window.getComputedStyle(r);o+=r.offsetHeight+parseFloat(e)+parseFloat(t)}i.forEach(e=>{if(e===r){return}const{marginTop:t,marginBottom:i}=window.getComputedStyle(e);o+=e.offsetHeight+parseFloat(t)+parseFloat(i);if(o>=a){e.classList.add("sapTntNLIHidden")}})};h.prototype._getOverflowItem=function(){let e=this.getAggregation("_overflowItem");if(!e){e=new d({text:t.getResourceBundleFor("sap.tnt").getText("NAVIGATION_LIST_NAVIGATION_OVERFLOW"),icon:"sap-icon://overflow",selectable:false,select:this._overflowPress.bind(this)});e._isOverflow=true;this.setAggregation("_overflowItem",e)}return e};h.prototype._overflowPress=function(e){const t=e.getSource();t.getDomRef().querySelector(".sapTntNLI").classList.add("sapTntNLIActive");const i=this._createOverflowMenu(t);i.openBy(t,false,a.Dock.EndCenter)};h.prototype._createOverflowMenu=function(e){const t=new m({items:this._createNavigationMenuItems(),itemSelected:e=>{const i=e.getParameter("item");const o=i._navItem;o._firePress({item:o});if(o.getSelectable()){this._selectItem({item:o});const e=this.getDomRef().querySelector(".sapTntNLISelected [tabindex]");e?.focus()}if(o.getSelectable()||!i.getItems().length){t.close();t.destroy()}},closed:function(){e.getDomRef().querySelector(".sapTntNLI").classList.remove("sapTntNLIActive")}});t.addStyleClass("sapTntNLMenu");t._handleMenuItemSelect=function(e){const t=e.getParameter("item");if(!t){return}const i=this._findMenuItemByUnfdMenuItem(t);if(i){this.fireItemSelected({item:i})}}.bind(t);t._createVisualMenuItemFromItem=function(e){var t=this._generateUnifiedMenuItemId(e.getId()),i=o.getElementById(t),s=e.getCustomData(),n;if(i){return i}i=new c({id:t,icon:e.getIcon(),text:e.getText(),startsSection:e.getStartsSection(),tooltip:e.getTooltip(),visible:e.getVisible(),enabled:e.getEnabled(),href:e._navItem.getHref(),target:e._navItem.getTarget()});for(n=0;n<s.length;n++){e._addCustomData(i,s[n])}e.aDelegates.forEach(function(e){i.addEventDelegate(e.oDelegate,e.vThis)});return i}.bind(t);this.addDependent(t);return t};h.prototype._createNavigationMenuItems=function(){var e=[],t=[];this.getItems().forEach(t=>{if(t.isA("sap.tnt.NavigationListGroup")){e.push(...t.getItems())}else{e.push(t)}});e.forEach(function(e){if(!e.getVisible()||!e.getDomRef().classList.contains("sapTntNLIHidden")){return}var i=new u({icon:e.getIcon(),text:e.getText(),tooltip:e.getTooltip_AsString()||e.getText(),enabled:e.getEnabled()});i._navItem=e;e.getItems().forEach(function(e){var t=new u({icon:e.getIcon(),text:e.getText(),tooltip:e.getTooltip_AsString()||e.getText(),enabled:e.getEnabled()});t._navItem=e;i.addItem(t)});t.push(i)});return t};h.prototype._updateNavItems=function(){const e=this._getFocusDomRefs();this._oItemNavigation.setItemDomRefs(e)};h.prototype._getFocusDomRefs=function(){const e=this.getItems().flatMap(e=>e._getFocusDomRefs()),t=this._getOverflowItem().getDomRef("a");if(!this.getExpanded()&&t){e.push(t)}return e};h.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=8;this._offsets=["0 -8","8 0","0 8","-8 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"]}};h.prototype._selectItem=function(e){this.fireItemSelect(e);this.setSelectedItem(e.item)};h.prototype._findItemByKey=function(e){const t=this.findAggregatedObjects(true,e=>e.isA("sap.tnt.NavigationListItem"));return t.find(t=>t._getUniqueKey()===e)};h.prototype.setSelectedKey=function(e){const t=this._findItemByKey(e);this.setSelectedItem(t);return this.setProperty("selectedKey",e,true)};h.prototype.getSelectedItem=function(){return o.getElementById(this.getAssociation("selectedItem"))||null};h.prototype.setSelectedItem=function(e){let t;if(this._selectedItem){this._selectedItem._toggle(false)}if(!e){this._selectedItem=null}const i=e&&e.isA&&e.isA("sap.tnt.NavigationListItem");if(typeof e!="string"&&!i){this.setAssociation("selectedItem",null,true);this._updateOverflowItems();e=null}this.setAssociation("selectedItem",e,true);if(typeof e=="string"){t=o.getElementById(e)}else if(i){t=e}else{f.warning("Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.");return this}this.setProperty("selectedKey",t._getUniqueKey(),true);t._toggle(true);this._selectedItem=t;this._updateOverflowItems();return this};h.prototype._openPopover=function(e,t){const i=e.getDomRef().querySelector(".sapTntNLI");i.classList.add("sapTntNLIActive");let o=t.getSelectedItem();if(o&&t.isGroupSelected){o=null}this._oPopover=new r({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:o,afterClose:()=>{if(this._oPopover){this._oPopover.destroy();this._oPopover=null;i.classList.remove("sapTntNLIActive")}},content:t,ariaLabelledBy:p.getStaticId("sap.tnt","NAVIGATION_LIST_DIALOG_TITLE")}).addStyleClass("sapContrast sapContrastPlus sapTntNLPopover");this._oPopover._adaptPositionParams=this._adaptPopoverPositionParams;this._oPopover.openBy(e.getDomRef("a"))};h.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close()}};h.prototype._containsIcon=function(){const e=this.findAggregatedObjects(true,e=>e.isA("sap.tnt.NavigationListItem")&&!e._isOverflow&&e.getProperty("icon"));return!!e.length};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListGroup", ["./library","./NavigationListItemBase"],function(t,e){"use strict";const n=e.extend("sap.tnt.NavigationListGroup",{metadata:{library:"sap.tnt",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},defaultAggregation:"items"}});n.prototype.render=function(t,e,n){if(!this.getVisible()||!e){return}const s=this.getItems(),i=this.getEnabled();if(n){this._renderSeparator(t)}if(!e.getExpanded()){s.forEach(n=>{if(!i){n.setEnabled(false)}n.render(t,e)});this._renderSeparator(t);return}t.openStart("li",this).attr("role","none").openEnd();t.openStart("div").class("sapTntNLI").class("sapTntNLGroup");if(!i){t.class("sapTntNLIDisabled")}const r=`${this.getId()}-subtree`;if(i){t.attr("tabindex","-1").accessibilityState({role:"treeitem",owns:r,expanded:e.getExpanded()&&this.getExpanded()?"true":"false"})}const a=this.getTooltip_AsString()||this.getText();if(a){t.attr("title",a)}t.openEnd();t.openStart("span").class("sapTntNLGroupText").openEnd().text(this.getText()).close("span");t.renderControl(this._getExpandIconControl());t.close("div");t.openStart("ul",r).class("sapTntNLIItemsContainer").accessibilityState({role:"group",label:this.getText()});if(!this.getExpanded()){t.class("sapTntNLIItemsContainerHidden")}t.openEnd();s.forEach(n=>{n.render(t,e)});t.close("ul").close("li");this._renderSeparator(t)};n.prototype._renderSeparator=function(t){t.openStart("li").class("sapTntNLSeparator").attr("role","none").openEnd().close("li")};n.prototype._getFocusDomRefs=function(){const t=this.getFocusDomRef(),e=this.getItems().flatMap(t=>t._getFocusDomRefs());if(!this.getEnabled()||!this.getVisible()){return[]}if(this._isListExpanded()){e.unshift(t)}return e};n.prototype._getAccessibilityRef=function(){return this.getDomRef().querySelector(".sapTntNLGroup")};n.prototype._getExpandIconStyleClass=function(){return"sapTntNLGroupIcon"};n.prototype._getExpanderActivationTarget=function(){return".sapTntNLGroup"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListItem", ["./library","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/util/openWindow","sap/ui/util/defaultLinkTypes","./NavigationListItemBase"],function(e,t,s,i,n,o,r,a,l,p){"use strict";var c=o.TextAlign;var g=o.TextDirection;var d=e.NavigationListItemDesign;var f=o.aria.HasPopup;const h="sap-icon://navigation-right-arrow";const u="sap-icon://navigation-down-arrow";const I=p.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Appearance",defaultValue:true},selectable:{type:"boolean",group:"Behavior",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null},design:{type:"sap.tnt.NavigationListItemDesign",group:"Behavior",defaultValue:d.Default},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:f.None}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});I._getInvisibleText=function(){if(!this._invisibleText){this._invisibleText=(new s).toStatic()}return this._invisibleText};I.prototype.createListForPopup=function(){const e=this.getItems(),t=this.getNavigationList(),s=t.getSelectedItem();let i;const n=e.filter(e=>e.getVisible()).map(e=>{const t=new I({key:e.getId(),text:e.getText(),textDirection:e.getTextDirection(),enabled:e.getEnabled(),selectable:e.getSelectable(),href:e.getHref(),target:e.getTarget(),tooltip:e.getTooltip()});if(s===e){i=t}return t});const o=new I({expanded:true,hasExpander:false,selectable:this.getSelectable(),key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),tooltip:this.getTooltip(),items:n});const r=t.getMetadata().getClass().prototype.constructor;const a=new r({itemSelect:this.onPopupItemSelect.bind(this),itemPress:this.onPopupItemPress.bind(this),items:o}).addStyleClass("sapTntNLPopup");if(s==this){i=o;a.isGroupSelected=true}a.setSelectedItem(i);return a};I.prototype.onPopupItemSelect=function(e){const s=e.getParameter("item"),i=t.getElementById(s.getKey());i._selectItem()};I.prototype.onPopupItemPress=function(e){const s=e.getParameter("item"),i=t.getElementById(s.getKey());i._firePress({item:i})};I.prototype._selectItem=function(){const e={item:this};this.fireSelect(e);if(this.getSelectable()){this.getNavigationList()._selectItem(e)}this._openUrl()};I.prototype._openUrl=function(){const e=this.getHref();if(e){a(e,this.getTarget()||"_self")}};I.prototype._getAccessibilityRef=function(){return this.getDomRef().querySelector(".sapTntNLIFirstLevel")};I.prototype.ontap=function(e){if(p.prototype.ontap.apply(this,arguments)){return}e.preventDefault();if(this.getLevel()>0){if(this.getEnabled()&&this.getAllParentsEnabled()){this._selectItem()}return}const t=this.getNavigationList();if(t.getExpanded()||!this.getItems().length){this._selectItem()}else{const e=this.createListForPopup();t._openPopover(this,e)}};I.prototype.onkeydown=function(e){if(e.isMarked("subItem")){return}const t=this._hasModifierKey(e);if((e.key?e.key==="Enter":e.keyCode===r.ENTER)&&!t){this.getDomRef().classList.add("sapTntNLIActive");this.ontap(e)}else if((e.key?e.key===" ":e.keyCode===r.SPACE)&&!t){this.getDomRef().classList.add("sapTntNLIActive")}if(this.getHref()&&this.getTarget()==="_blank"){this.getDomRef().classList.remove("sapTntNLIActive")}p.prototype.onkeydown.apply(this,arguments)};I.prototype.onkeyup=function(e){if(e.isMarked("subItem")){return}const t=this._hasModifierKey(e);if((e.key?e.key==="Enter":e.keyCode===r.ENTER)&&!t){this.getDomRef().classList.remove("sapTntNLIActive")}else if(e.key?e.key===" ":e.keyCode===r.SPACE){this.getDomRef().classList.remove("sapTntNLIActive");if(!t){this.ontap(e)}}if(e.srcControl.getLevel()===1){e.setMarked("subItem")}};I.prototype.render=function(e,t){if(!this.getVisible()){return}if(this.getLevel()===0){this.renderFirstLevelNavItem(e,t)}else{this.renderSecondLevelNavItem(e,t)}};I.prototype.renderFirstLevelNavItem=function(e,t){const s=this._getVisibleItems(this),i=this._isListExpanded(),n=this.getEnabled()||this.getAllParentsEnabled();e.openStart("li",this).attr("role","none");if(!i){if(s.length&&n){e.class("sapTntNLINotExpandedTriangle")}if(this._isOverflow){e.class("sapTntNLOverflow").class("sapTntNLIHidden")}}e.openEnd();const o=`${this.getId()}-subtree`;this.renderMainElement(e,t,o);if(i&&s.length){e.openStart("ul",o).class("sapTntNLIItemsContainer").accessibilityState({role:"group",label:this.getText()});if(!this.getExpanded()){e.class("sapTntNLIItemsContainerHidden")}e.openEnd();s.forEach(s=>s.render(e,t));e.close("ul")}e.close("li")};I.prototype._renderExternalLinkIcon=function(e){if(!(this.getHref()&&this.getTarget()==="_blank")){return}const t=this._getExternalIcon();e.renderControl(t)};I.prototype.renderMainElement=function(e,t,s){const i=this._isListExpanded(),n=this._getVisibleItems(this),o=!this.getEnabled()||!this.getAllParentsEnabled(),r=this.getExpanded(),a=this.getSelectable(),l=this.getDesign(),p=!!n.length&&this.getHasExpander();e.openStart("div").class("sapTntNLI").class("sapTntNLIFirstLevel");if(o){e.class("sapTntNLIDisabled")}let c=false;if(a&&t._selectedItem===this){e.class("sapTntNLISelected");c=true}if(!i&&n.includes(t._selectedItem)){e.class("sapTntNLISelected");c=true}if(p){e.class("sapTntNLIWithExpander")}if(a&&n.length){e.class("sapTntNLITwoClickAreas")}const g={};if(this.getAriaHasPopup()!==f.None){g.haspopup=this.getAriaHasPopup()}if(l===d.Action){e.class("sapTntNLIAction")}if(!a){e.class("sapTntNLIUnselectable")}if(this._isInsidePopover()){e.class("sapTntNLIInPopover")}if(!i){g.role=a?"menuitemradio":"menuitem";if(n.length){g.haspopup="tree"}if(this._isOverflow){g.haspopup="menu"}if(a){g.checked=t._selectedItem===this;g.selected=c}else{g.selected=false}g.roledescription=this._resourceBundleTnt.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")}else{g.role="treeitem";if(a){g.selected=c}else{g.selected=false}if(c){g.current="page"}if(n.length){g.owns=s;g.expanded=r}}e.openEnd();this._renderStartLink(e,g,o);this._renderIcon(e);this._renderText(e);this._renderExternalLinkIcon(e);if(i){const t=this._getExpandIconControl();t.setVisible(p).setSrc(r?u:h).setTooltip(this._getExpandIconTooltip(!r));e.renderControl(t)}if(!i&&this.getItems().length){const t=this._getExpandIconControl().setSrc(h);e.renderControl(t)}this._renderCloseLink(e);e.close("div")};I.prototype.renderSecondLevelNavItem=function(e,t){const s=!this.getEnabled()||!this.getAllParentsEnabled();e.openStart("li",this).class("sapTntNLI").class("sapTntNLISecondLevel").attr("role","none");let i=false;if(this.getSelectable()&&t._selectedItem===this){e.class("sapTntNLISelected");i=true}if(s){e.class("sapTntNLIDisabled")}if(this._isInsidePopover()){e.class("sapTntNLIInPopover")}e.openEnd();const n={role:"treeitem",current:this._isListExpanded()&&i?"page":undefined,selected:i};this._renderStartLink(e,n,s);this._renderIcon(e);this._renderText(e);this._renderExternalLinkIcon(e);this._renderCloseLink(e);e.close("li")};I.prototype._renderStartLink=function(e,t,s){const i=this.getHref(),n=this.getTarget();e.openStart("a",`${this.getId()}-a`).accessibilityState(this,{...t});const o=this.getTooltip_AsString()||this.getText();if(o){e.attr("title",o)}if(!s){e.attr("tabindex","-1")}if(i){e.attr("href",i)}if(n){e.attr("target",n).attr("rel",l("",n))}e.openEnd()};I.prototype._renderCloseLink=function(e){e.close("a")};I.prototype._renderIcon=function(e){const t=this.getIcon(),s=n.getIconInfo(t);e.openStart("span").class("sapUiIcon").class("sapTntNLIIcon").attr("aria-hidden","true");if(t){if(s&&!s.suppressMirroring){e.class("sapUiIconMirrorInRTL")}if(s){e.attr("data-sap-ui-icon-content",s.content).style("font-family",`'${s.fontFamily}'`)}}e.openEnd().close("span")};I.prototype._renderText=function(e){e.openStart("span").class("sapMText").class("sapTntNLIText").class("sapMTextNoWrap");const t=this.getTextDirection();if(t!==g.Inherit){e.attr("dir",t.toLowerCase())}const s=i.getTextAlign(c.Begin,t);if(s){e.style("text-align",s)}e.openEnd().text(this.getText()).close("span")};I.prototype._toggle=function(e){const t=this.getNavigationList(),s=this._isListExpanded();if(!t||!t.getDomRef()){return}const i=this.getDomRef();if(this.getLevel()===0){const t=i?.querySelector(".sapTntNLIFirstLevel");t?.classList.toggle("sapTntNLISelected",e)}if(this.getLevel()!==0){if(s){i?.classList.toggle("sapTntNLISelected",e)}else{const t=this.getParent().getDomRef()?.querySelector(".sapTntNLIFirstLevel");t?.classList.toggle("sapTntNLISelected",e);if(e){t?.classList.toggle("sapTntNLINoHoverEffect",e)}}}this._syncAriaAttributes(this.getFocusDomRef(),e,s);t._closePopover()};I.prototype._syncAriaAttributes=function(e,t,s){if(!e){return}if(s){if(t){e.setAttribute("aria-current","page");e.setAttribute("aria-selected","true")}else{e.removeAttribute("aria-current");e.setAttribute("aria-selected","false")}}else{e.setAttribute("aria-checked",t?"true":"false")}};I.prototype._getFocusDomRefs=function(){const e=[];if(!this.getEnabled()||!this.getVisible()){return e}if(!this._isInsidePopover()||this.getSelectable()&&this.getLevel()===0){e.push(this.getDomRef("a"))}if(this._isListExpanded()&&this.getExpanded()){e.push(...this.getDomRef().querySelectorAll(".sapTntNLISecondLevel:not(.sapTntNLIDisabled) a"))}return e};I.prototype._getVisibleItems=function(e){return e.getItems().filter(e=>e.getVisible())};I.prototype.onclick=function(e){if(this.getHref()){e.preventDefault()}};I.prototype.onmousedown=function(e){if(this.getHref()){e.preventDefault()}};I.prototype.onfocusout=function(){var e=this.getDomRef()?.querySelector(".sapTntNLIFirstLevel");if(e){e.classList.remove("sapTntNLINoHoverEffect")}};I.prototype.onmouseout=function(){const e=this.getDomRef()?.querySelector(".sapTntNLIFirstLevel");const t=this.getNavigationList();const s=this.getItems().find(e=>e===t.getSelectedItem());if(e&&(this===t.getSelectedItem()||s)){e.classList.add("sapTntNLINoHoverEffect")}};I.prototype.onmouseover=I.prototype.onfocusout;I.prototype._hasModifierKey=function e(t){return t.shiftKey||t.altKey||t.ctrlKey||t.metaKey};return I});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListItemBase", ["./library","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/events/KeyCodes","sap/base/i18n/Localization"],function(t,e,i,n,s,o){"use strict";const r="sap-icon://navigation-right-arrow";const a="sap-icon://navigation-down-arrow";const p="sap-icon://arrow-right";const l=e.extend("sap.tnt.NavigationListItemBase",{metadata:{library:"sap.tnt",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_externalLinkIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});l.prototype.init=function(){this._resourceBundleCore=n.getResourceBundleFor("sap.ui.core");this._resourceBundleTnt=n.getResourceBundleFor("sap.tnt")};l.prototype.exit=function(){this._resourceBundleCore=null;this._resourceBundleTnt=null};l.prototype.getLevel=function(){const t=0;const e=this.getParent();if(e&&e.isA("sap.tnt.NavigationListItem")){return e.getLevel()+1}return t};l.prototype.getNavigationList=function(){let t=this.getParent();while(t&&!t.isA("sap.tnt.NavigationList")){t=t.getParent()}return t};l.prototype.getAllParentsEnabled=function(){let t=this.getParent();while(t&&!t.isA("sap.tnt.NavigationList")){if(!t.getEnabled()){return false}t=t.getParent()}return true};l.prototype._isListExpanded=function(){const t=this.getNavigationList();if(!t){return false}return t.getExpanded()||t.hasStyleClass("sapTntNLPopup")};l.prototype._getUniqueKey=function(){const t=this.getKey();return t?t:this.getId()};l.prototype._getFocusDomRefs=function(){};l.prototype._getAccessibilityRef=function(){};l.prototype._getExpandIconControl=function(){let t=this.getAggregation("_expandIconControl");if(!t){const e=this.getExpanded();t=new i({src:e?a:r,visible:!!this.getItems()?.length&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!e)}).addStyleClass(`sapTntNLIExpandIcon ${this._getExpandIconStyleClass()}`);this.setAggregation("_expandIconControl",t,true)}return t};l.prototype._getExternalIcon=function(){var t=this.getAggregation("_externalLinkIconControl");if(!t){t=new i({src:p}).addStyleClass(`sapTntNLIExternalLinkIcon`);this.setAggregation("_externalLinkIconControl",t)}return t};l.prototype._getExpandIconStyleClass=function(){return""};l.prototype._getExpandIconTooltip=function(t){if(!this.getEnabled()||!this.getAllParentsEnabled()){return""}const e=t?"Icon.expand":"Icon.collapse";return this._resourceBundleCore.getText(e)};l.prototype.getFocusDomRef=function(){const t=this.getDomRef()?.querySelector("[tabindex]");if(!t){return null}return t};l.prototype.onkeydown=function(t){if(t.key?t.key===" ":t.keyCode===s.SPACE){t.preventDefault()}if(!this._isListExpanded()){return}if(t.isMarked("subItem")){return}if(t.srcControl.getLevel()===1){t.setMarked("subItem")}if(this.getLevel()!==0){return}const e=o.getRTL();if(t.shiftKey&&t.which==189||t.which==s.NUMPAD_MINUS||t.which==s.ARROW_RIGHT&&e||t.which==s.ARROW_LEFT&&!e){if(this.collapse()){t.preventDefault();t.stopPropagation()}}else if(t.which==s.NUMPAD_PLUS||t.shiftKey&&t.which==s.PLUS||t.which==s.ARROW_LEFT&&e||t.which==s.ARROW_RIGHT&&!e){if(this.expand()){t.preventDefault();t.stopPropagation()}}};l.prototype.ontap=function(t){const e={item:this};if(this.getEnabled()&&!t.srcControl.isA("sap.ui.core.Icon")&&!this._isOverflow&&!(!this.getNavigationList().getExpanded()&&this.getItems().length)){this._firePress(e);t.stopPropagation()}if(t.isMarked("subItem")){return true}t.setMarked("subItem");if(!this.getEnabled()||!this.getAllParentsEnabled()){return true}if(this._handleExpanderClick(t)){return true}return false};l.prototype._firePress=function(t){const e=this.getNavigationList();e?.fireItemPress({item:this});this.firePress(t)};l.prototype._handleExpanderClick=function(t){const e=this._getExpanderActivationTarget(),i=t.target.closest(e);if(!this._isListExpanded()||this.getLevel()!==0||!i){return false}if(this.getExpanded()){this.collapse()}else{this.expand()}return true};l.prototype._getExpanderActivationTarget=function(){if(!this.getSelectable()&&!(this.getHref()&&this.getTarget()==="_blank")){return".sapTntNLIFirstLevel"}return".sapTntNLIExpandIcon"};l.prototype.expand=function(){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()!==0){return false}this.setProperty("expanded",true,true);this._getExpandIconControl().setSrc(a).setTooltip(this._getExpandIconTooltip(false));this._getAccessibilityRef().setAttribute("aria-expanded","true");const t=this.$().find(".sapTntNLIItemsContainer").first();t.stop(true,true).slideDown("fast",()=>{this._updateContainerVisibility();this.getNavigationList()?._updateNavItems()});return true};l.prototype._updateContainerVisibility=function(){const t=this.getDomRef()?.querySelector(".sapTntNLIItemsContainer");if(t){if(this.getExpanded()){t.classList.remove("sapTntNLIItemsContainerHidden")}else{t.classList.add("sapTntNLIItemsContainerHidden")}}};l.prototype.collapse=function(){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()!==0){return false}this.setProperty("expanded",false,true);this._getExpandIconControl().setSrc(r).setTooltip(this._getExpandIconTooltip(true));this._getAccessibilityRef().setAttribute("aria-expanded","false");const t=this.$().find(".sapTntNLIItemsContainer").first();t.stop(true,true).slideUp("fast",()=>{this._updateContainerVisibility();this.getNavigationList()?._updateNavItems()});return true};l.prototype._isInsidePopover=function(){return!!this.getNavigationList()?.hasStyleClass("sapTntNLPopup")};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListMenuItem", ["sap/ui/core/IconPool","sap/ui/unified/MenuItem","sap/ui/unified/library","sap/ui/core/library","sap/ui/core/Icon","sap/ui/util/defaultLinkTypes","sap/ui/util/openWindow","sap/ui/events/KeyCodes"],function(t,e,i,n,s,a,o,r){"use strict";const p="sap-icon://arrow-right";var l=e.extend("sap.tnt.NavigationListMenuItem",{metadata:{library:"sap.tnt",properties:{text:{type:"string",group:"Appearance",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{_externalLinkIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});t.insertFontFaceStyle();l.prototype.render=function(t,e,i,s){var a=t,o=e.getSubmenu(),r=e.getEnabled(),p,l=this.getHref()&&this.getTarget()==="_blank";a.openStart("li",e);if(this.getHref()){a.class("sapUiMnuItmExternalLink")}if(e.getVisible()){a.attr("tabindex","0")}a.class("sapUiMnuItm");if(s.iItemNo==1){a.class("sapUiMnuItmFirst")}else if(s.iItemNo==s.iTotalItems){a.class("sapUiMnuItmLast")}if(!i.checkEnabled(e)){a.class("sapUiMnuItmDsbl")}if(e.getStartsSection()){a.class("sapUiMnuItmSepBefore")}if(e.getTooltip_AsString()){a.attr("title",e.getTooltip_AsString())}if(s.bAccessible){a.accessibilityState(e,{role:"menuitem",disabled:!r,posinset:s.iItemNo,setsize:s.iTotalItems,labelledby:{value:this.getId()+"-txt",append:true}});if(o){a.attr("aria-haspopup",n.aria.HasPopup.Menu.toLowerCase());a.attr("aria-owns",o.getId())}}a.openEnd();if(this.getHref()){this._renderLinkTag(a)}if(e.getIcon()&&e._getIcon){a.openStart("div");a.class("sapUiMnuItmIco");a.openEnd();p=e._getIcon(e);a.renderControl(p);a.close("div")}a.openStart("div",this.getId()+"-txt");a.class("sapUiMnuItmTxt");a.openEnd();a.text(e.getText());a.close("div");a.openStart("div",this.getId()+"-scuttxt");a.class("sapUiMnuItmSCut");a.openEnd();a.close("div");a.openStart("div");a.class("sapUiMnuItmSbMnu");if(o){a.class("sapTntNLIExpandIcon")}a.openEnd();if(o){a.openStart("div");a.class("sapUiIconMirrorInRTL");a.openEnd();a.close("div")}a.close("div");if(l){const t=this._getExternalLinkIcon();a.renderControl(t)}if(this.getHref()){a.close("a")}a.close("li")};l.prototype.hover=function(t,e){this.$().toggleClass("sapUiMnuItmHov",t)};l.prototype.focus=function(t){if(this.getVisible()){this.$().trigger("focus")}else{t.focus()}};l.prototype.onclick=function(t){t.preventDefault();this._openUrl()};l.prototype.onkeyup=function(t){if(t.which===r.SPACE||t.which===r.ENTER){this._openUrl()}};l.prototype._openUrl=function(){const t=this.getHref();if(t){o(t,this.getTarget()||"_self")}};l.prototype._getExternalLinkIcon=function(){var t=this.getAggregation("_externalLinkIcon");if(!t){t=new s({src:p}).addStyleClass(`sapTntNLIExternalLinkIcon`);this.setAggregation("_externalLinkIcon",t)}return t};l.prototype._renderLinkTag=function(t){const e=this.getHref(),i=this.getTarget(),n=this.getEnabled();t.openStart("a",`${this.getId()}-a`);const s=this.getTooltip_AsString()||this.getText();if(s){t.attr("title",s)}if(!n){t.attr("tabindex","-1")}if(e){t.attr("href",e)}if(i){t.attr("target",i).attr("rel",a("",i))}t.openEnd()};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListRenderer", ["sap/ui/core/Lib"],function(e){"use strict";const t={apiVersion:2};t.render=function(t,n){const s=n.getExpanded(),i=n._containsIcon(),a=n.getItems().filter(e=>e.getVisible());t.openStart("ul",n).class("sapTntNL");if(!s){t.class("sapTntNLCollapsed")}if(!i){t.class("sapTntNLNoIcons")}var r=n.getWidth();if(r&&s){t.style("width",r)}const o=!s&&!n.hasStyleClass("sapTntNLPopup")?"menubar":"tree";t.accessibilityState(n,{role:o,orientation:o==="menubar"?"vertical":undefined,roledescription:e.getResourceBundleFor("sap.tnt").getText(o==="menubar"?"NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUBAR":"NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE")});t.openEnd();const c=a.find(e=>e.isA("sap.tnt.NavigationListGroup"));a.forEach(e=>{e.render(t,n,e===c)});if(!s){n._getOverflowItem().render(t,n)}t.close("ul")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/SideNavigation", ["./library","sap/ui/core/Control","sap/ui/core/Element","./SideNavigationRenderer"],function(e,t,i,s){"use strict";const n=e.SideNavigationDesign;const a=t.extend("sap.tnt.SideNavigation",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null},design:{type:"sap.tnt.SideNavigationDesign",group:"Appearance",defaultValue:n.Decorated}},defaultAggregation:"item",aggregations:{item:{type:"sap.tnt.NavigationList",multiple:false,bindable:"bindable"},fixedItem:{type:"sap.tnt.NavigationList",multiple:false},footer:{type:"sap.tnt.NavigationList",multiple:false}},associations:{selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}},itemPress:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:s});a.prototype.setAggregation=function(e,i){if(i&&i.attachItemSelect){i.attachItemSelect(this._itemSelectionHandler.bind(this))}if(i&&i.attachItemPress){i.attachItemPress(this._itemPressHandler.bind(this))}return t.prototype.setAggregation.apply(this,arguments)};a.prototype.setExpanded=function(e){if(this.getExpanded()===e){return this}this.setProperty("expanded",e);e=this.getExpanded();const t=this.getItem(),i=this.getFixedItem();if(t){t.setExpanded(e)}if(i){i.setExpanded(e)}return this};a.prototype.onBeforeRendering=function(){const e=this.getSelectedItem(),t=this.getSelectedKey(),i=this.getItem(),s=this.getFixedItem(),n=this.getExpanded();if(t){this.setSelectedKey(t)}else if(e){this.setSelectedItem(e)}if(!n&&i){i.setExpanded(false)}if(!n&&s){s.setExpanded(false)}};a.prototype.setSelectedKey=function(e){const t=this.getItem(),i=this.getFixedItem();let s;if(e&&t){s=t._findItemByKey(e);if(!s&&i){s=i._findItemByKey(e)}}if(s){this.setSelectedItem(s)}this.setProperty("selectedKey",e,true);return this};a.prototype.setSelectedItem=function(e){const t=this.getItem(),s=this.getFixedItem();if(!e){t?.setSelectedItem(null);s?.setSelectedItem(null)}let n;if(typeof e=="string"){n=i.getElementById(e)}else{n=e}const a=n?n._getUniqueKey():"";this.setProperty("selectedKey",a,true);const r=n?.getNavigationList&&n.getNavigationList()===t,o=n?.getNavigationList&&n.getNavigationList()===s;if(r){t.setSelectedItem(n);s?.setSelectedKey(null)}if(o){s.setSelectedItem(n);t?.setSelectedKey(null)}return this.setAssociation("selectedItem",n,true)};a.prototype._itemSelectionHandler=function(e){const t=e.getParameter("item");this.setSelectedItem(t);this.fireItemSelect({item:t})};a.prototype._itemPressHandler=function(e){const t=e.getParameter("item");this.fireItemPress({item:t})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/SideNavigationRenderer", ["sap/ui/core/Lib","sap/tnt/library"],function(e,t){"use strict";const i=t.SideNavigationDesign;const n={apiVersion:2};const a=e.getResourceBundleFor("sap.tnt");n.render=function(e,t){this.startSideNavigation(e,t);this.renderFlexibleList(e,t);this.renderFixedList(e,t);this.renderFooter(e,t);this.endSideNavigation(e)};n.startSideNavigation=function(e,t){const n=t.getExpanded(),o=t.getAriaLabel(),s=t.getDesign();e.openStart("nav",t).class("sapTntSideNavigation").class("sapContrast").class("sapContrastPlus").accessibilityState(t,{roledescription:a.getText("SIDENAVIGATION_ROLE_DESCRIPTION")}).attr("data-sap-ui-fastnavgroup","true");if(o){e.accessibilityState(t,{label:o})}if(!n){e.class("sapTntSideNavigationNotExpanded").class("sapTntSideNavigationNotExpandedWidth")}if(s!==i.Decorated){e.class("sapTntSideNavigationDesignPlain")}const r=t.getWidth();if(r&&n){e.style("width",r)}e.openEnd()};n.endSideNavigation=function(e){e.close("nav")};n.renderFlexibleList=function(e,t){var i=t.getItem();e.openStart("div",`${t.getId()}-Flexible`).class("sapTntSideNavigationFlexible").openEnd();e.openStart("div",`${t.getId()}-Flexible-Content`).class("sapTntSideNavigationFlexibleContent").openEnd();e.renderControl(i);e.close("div").close("div")};n.renderFixedList=function(e,t){var i=t.getFixedItem();if(!i){return}e.openStart("div").class("sapTntSideNavigationSeparator").accessibilityState({role:"separator",roledescription:a.getText("SIDENAVIGATION_ROLE_DESCRIPTION_SEPARATOR"),orientation:"horizontal"}).openEnd().close("div");e.openStart("div").class("sapTntSideNavigationFixed").openEnd();e.renderControl(i);e.close("div")};n.renderFooter=function(e,t){const i=t.getAggregation("footer");if(!i){return}e.openStart("footer").class("sapTntSideNavigationFooter").openEnd().renderControl(i).close("footer")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeader", ["./library","sap/m/OverflowToolbar","sap/m/OverflowToolbarAssociativePopover","./ToolHeaderRenderer","sap/ui/Device","sap/m/library"],function(t,e,o,a,r,s){"use strict";var p=s.PlacementType;var n=e.extend("sap.tnt.ToolHeader",{metadata:{library:"sap.tnt",properties:{},aggregations:{}},renderer:a});n.prototype.init=function(){e.prototype.init.apply(this,arguments);this.addStyleClass("sapTntToolHeader sapContrast sapContrastPlus")};n.prototype._getPopover=function(){var t=this.getAggregation("_popover");if(!t){t=new o(this.getId()+"-popover",{showHeader:false,showArrow:r.system.phone?false:true,modal:false,horizontalScrolling:r.system.phone?false:true,contentWidth:r.system.phone?"100%":"auto"}).addStyleClass("sapTntToolHeaderPopover sapContrast sapContrastPlus");if(r.system.phone){t.attachBeforeOpen(this._shiftPopupShadow,this);t.attachAfterOpen(this._shiftPopupShadow,this)}t.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",t,true)}return t};n.prototype._getBestActionSheetPlacement=function(){return p.Bottom};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeaderRenderer", ["sap/m/library","sap/ui/core/Renderer","sap/m/OverflowToolbarRenderer","sap/m/BarInPageEnabler"],function(e,r,t,n){"use strict";var o=e.OverflowToolbarPriority;var i=r.extend(t);i.apiVersion=2;i.renderBarContent=function(e,r){var t=false,i=null,l;if(r.getActive()){e.renderControl(r._getActiveButton())}r._getVisibleContent().forEach(function(a){n.addChildClassTo(a,r);l=a.isA("sap.tnt.ToolHeaderUtilitySeparator");if(l&&!t){this._renderOverflowButton(e,r);t=true}if(r._getControlPriority(a)!==o.AlwaysOverflow){if(!i&&a.getVisible()){a.addStyleClass("sapMBarChildFirstChild");i=a}else{a.removeStyleClass("sapMBarChildFirstChild")}e.renderControl(a)}}.bind(this));if(t){return}this._renderOverflowButton(e,r)};i._renderOverflowButton=function(e,r){var n=r.getContent().some(function(e){return e.getVisible()&&r._getControlPriority(e)===o.AlwaysOverflow}),i=r.getContent().some(function(e){return e.getVisible()});if(n||r._getOverflowButtonNeeded()){t.renderOverflowButton(e,r)}if(i){t.renderOverflowButtonClone(e,r)}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeaderUtilitySeparator", ["./library","sap/ui/core/Control"],function(r,e){"use strict";var t=e.extend("sap.tnt.ToolHeaderUtilitySeparator",{metadata:{library:"sap.tnt",properties:{}},renderer:{apiVersion:2,render:function(){}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolPage", ["./library","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","./ToolPageRenderer"],function(e,t,i,n,r,s,o){"use strict";var a=t.PageBackgroundDesign;var d=n.extend("sap.tnt.ToolPage",{metadata:{library:"sap.tnt",properties:{sideExpanded:{type:"boolean",group:"Misc",defaultValue:true},contentBackgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:a.Standard}},aggregations:{header:{type:"sap.ui.core.Control",multiple:false},subHeader:{type:"sap.ui.core.Control",multiple:false},sideContent:{type:"sap.tnt.SideNavigation",multiple:false},mainContents:{type:"sap.ui.core.Control",multiple:true,singularName:"mainContent"}},events:{}},renderer:o});d.prototype.init=function(){this._oContentObserver=new i(this._onContentChange.bind(this));this._oContentObserver.observe(this,{aggregations:["subHeader","sideContent"]});this._oContentVisibilityObserver=new i(this._onContentVisibilityChange.bind(this));this._deregisterControl()};d.prototype.exit=function(){this._deregisterControl();if(this._oContentObserver){this._oContentObserver.disconnect();this._oContentObserver=null}if(this._oContentVisibilityObserver){this._oContentVisibilityObserver.disconnect();this._oContentVisibilityObserver=null}};d.prototype.onBeforeRendering=function(){this._deregisterControl()};d.prototype.onAfterRendering=function(){this._ResizeHandler=s.register(this.getDomRef(),this._mediaQueryHandler.bind(this));this._updateLastMediaQuery()};d.prototype.toggleSideContentMode=function(){return this.setSideExpanded(!this.getSideExpanded())};d.prototype.setSideExpanded=function(e){this.setProperty("sideExpanded",e,true);var t=this.getSideContent();if(t){var i=r.system.phone?true:e;t.setExpanded(i)}else{return this}var n=this.getDomRef();if(!n){return this}if(e){n.querySelector(".sapTntToolPageContentWrapper").classList.remove("sapTntToolPageAsideCollapsed")}else{n.querySelector(".sapTntToolPageContentWrapper").classList.add("sapTntToolPageAsideCollapsed")}return this};d.prototype._deregisterControl=function(){if(this._ResizeHandler){s.deregister(this._ResizeHandler);this._ResizeHandler=null}};d.prototype._mediaQueryHandler=function(){var e=this.getSideContent();if(e===null){return}this._currentMediaQuery=this._getDeviceAsString();if(this._getLastMediaQuery()===this._currentMediaQuery){return}switch(this._currentMediaQuery){case"Combi":this.setSideExpanded(true);break;case"Tablet":this.setSideExpanded(false);break;case"Phone":this.setSideExpanded(false);e.setExpanded(true);break;default:this.setSideExpanded(true)}this._updateLastMediaQuery()};d.prototype._getLastMediaQuery=function(){return this._lastMediaQuery};d.prototype._updateLastMediaQuery=function(){this._lastMediaQuery=this._getDeviceAsString();return this};d.prototype._getDeviceAsString=function(){if(r.system.combi){return"Combi"}if(r.system.phone){return"Phone"}if(r.system.tablet){return"Tablet"}return"Desktop"};d.prototype._onContentChange=function(e){switch(e.mutation){case"insert":this._oContentVisibilityObserver.observe(e.child,{properties:["visible"]});break;case"remove":this._oContentVisibilityObserver.unobserve(e.child,{properties:["visible"]});break}};d.prototype._onContentVisibilityChange=function(e){this.invalidate()};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolPageRenderer", ["sap/ui/Device"],function(e){"use strict";var n={apiVersion:2};n.render=function(e,n){e.openStart("div",n).class("sapTntToolPage").openEnd();this.renderHeader(e,n);this.renderContent(e,n);e.close("div")};n.renderHeader=function(e,n){var t=n.getHeader(),a=n.getSubHeader();if(t||a){e.openStart("div").class("sapTntToolPageHeaderWrapper");if(t&&a&&a.getVisible()){e.class("sapTntToolPageHeaderWithSubHeaderWrapper")}e.openEnd();e.openStart("header").openEnd()}if(t){e.openStart("div",n.getId()+"-header").class("sapTntToolPageHeader").openEnd();e.renderControl(t);e.close("div")}if(a&&a.getVisible()){e.openStart("div",n.getId()+"-subHeader").class("sapTntToolPageHeader").openEnd();e.renderControl(a);e.close("div")}if(t||a){e.close("header");e.close("div")}};n.renderContent=function(n,t){n.openStart("div").class("sapTntToolPageContentWrapper");if(!e.system.desktop||!t.getSideExpanded()){n.class("sapTntToolPageAsideCollapsed")}n.openEnd();this.renderAsideContent(n,t);this.renderMainContent(n,t);n.close("div")};n.renderAsideContent=function(n,t){var a=t.getSideContent();if(!a||!a.getVisible()){return}n.openStart("aside",t.getId()+"-aside").class("sapTntToolPageAside").openEnd();n.openStart("div").class("sapTntToolPageAsideContent").openEnd();var o=t.getSideExpanded();if(a&&a.getExpanded()!==o){a.setExpanded(o)}if(!e.system.desktop){t.setSideExpanded(false)}n.renderControl(a);n.close("div");n.close("aside")};n.renderMainContent=function(e,n){var t=n.getMainContents();if(!t){return}e.openStart("div",n.getId()+"-main").class("sapTntToolPageMain").class("sapTntToolPageMainBackground-"+n.getContentBackgroundDesign()).openEnd();e.openStart("div").class("sapTntToolPageMainContent").openEnd();e.openStart("div").class("sapTntToolPageMainContentWrapper").openEnd();t.forEach(e.renderControl,e);e.close("div");e.close("div");e.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationList.flexibility", [],function(){"use strict";return{moveControls:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationListGroup.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XTIT"}),unhideControl:"default",moveControls:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationListItem.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XTIT"}),unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/library", ["./IllustratedMessageType","sap/ui/base/DataType","sap/ui/core/Lib","sap/ui/core/library","sap/m/library"],function(t,i,e){"use strict";var a=e.init({apiVersion:2,name:"sap.tnt",version:"1.136.0",dependencies:["sap.ui.core","sap.m"],designtime:"sap/tnt/designtime/library.designtime",types:["sap.tnt.IllustratedMessageType","sap.tnt.RenderMode","sap.tnt.NavigationListItemDesign","sap.tnt.SideNavigationDesign"],interfaces:["sap.tnt.IToolHeader"],controls:["sap.tnt.NavigationList","sap.tnt.ToolHeaderUtilitySeparator","sap.tnt.ToolHeader","sap.tnt.SideNavigation","sap.tnt.ToolPage","sap.tnt.InfoLabel"],elements:["sap.tnt.NavigationListItem","sap.tnt.NavigationListGroup"],extensions:{flChangeHandlers:{"sap.tnt.NavigationList":"sap/tnt/flexibility/NavigationList","sap.tnt.NavigationListItem":"sap/tnt/flexibility/NavigationListItem","sap.tnt.NavigationListGroup":"sap/tnt/flexibility/NavigationListGroup"}}});a.IllustratedMessageType=t;a.RenderMode={Narrow:"Narrow",Loose:"Loose"};a.NavigationListItemDesign={Default:"Default",Action:"Action"};a.SideNavigationDesign={Decorated:"Decorated",Plain:"Plain"};i.registerEnum("sap.tnt.RenderMode",a.RenderMode);i.registerEnum("sap.tnt.NavigationListItemDesign",a.NavigationListItemDesign);i.registerEnum("sap.tnt.SideNavigationDesign",a.SideNavigationDesign);return a});
sap.ui.require.preload({
	"sap/tnt/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.tnt","type":"library","embeds":[],"applicationVersion":{"version":"1.136.0"},"title":"SAPUI5 library with responsive controls.","description":"SAPUI5 library with responsive controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.136","libs":{"sap.ui.core":{"minVersion":"1.136.0"},"sap.m":{"minVersion":"1.136.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.tnt.NavigationList","sap.tnt.ToolHeaderUtilitySeparator","sap.tnt.ToolHeader","sap.tnt.SideNavigation","sap.tnt.ToolPage","sap.tnt.InfoLabel"],"elements":["sap.tnt.NavigationListItem","sap.tnt.NavigationListGroup"],"types":["sap.tnt.IllustratedMessageType","sap.tnt.RenderMode","sap.tnt.NavigationListItemDesign","sap.tnt.SideNavigationDesign"],"interfaces":["sap.tnt.IToolHeader"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
