/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/future","sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/resolveReference","sap/base/i18n/date/_EnumHelper"],function(e,t,n,r,a,i,u){"use strict";var o=function(){throw new Error};o.prototype.getName=function(){return undefined};o.prototype.getBaseType=function(){return undefined};o.prototype.getPrimitiveType=function(){var e=this;while(e.getBaseType()){e=e.getBaseType()}return e};o.prototype.getComponentType=function(){return undefined};o.prototype.getDefaultValue=function(){return undefined};o.prototype.isArrayType=function(){return false};o.prototype.isEnumType=function(){return false};o.prototype.getEnumValues=function(){return undefined};o.prototype.parseValue=function(e){return e};o.prototype.isValid=undefined;o.prototype.setNormalizer=function(e){n(typeof e==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof e==="function"?e:undefined};o.prototype.normalize=function(e){return this._fnNormalizer?this._fnNormalizer(e):e};function s(e,t,n){t=t||{};var r=n||o.prototype;var a=Object.create(r);a.getName=function(){return e};if(t.hasOwnProperty("defaultValue")){var i=t.defaultValue;a.getDefaultValue=function(){return i}}if(t.isValid){var u=t.isValid;a.isValid=r.isValid?function(e){if(!r.isValid(e)){return false}return u(e)}:u}if(t.parseValue){a.parseValue=t.parseValue}a.getBaseType=function(){return n};return a}var f={any:s("any",{defaultValue:null,isValid:function(e){return true}}),boolean:s("boolean",{defaultValue:false,isValid:function(e){return typeof e==="boolean"},parseValue:function(e){return e=="true"}}),int:s("int",{defaultValue:0,isValid:function(e){return typeof e==="number"&&(isNaN(e)||Math.floor(e)==e)},parseValue:function(e){return parseInt(e)}}),float:s("float",{defaultValue:0,isValid:function(e){return typeof e==="number"},parseValue:function(e){return parseFloat(e)}}),string:s("string",{defaultValue:"",isValid:function(e){return typeof e==="string"||e instanceof String},parseValue:function(e){return e}}),object:s("object",{defaultValue:null,isValid:function(e){return typeof e==="object"||typeof e==="function"},parseValue:function(e){return e?JSON.parse(e):null}}),function:s("function",{defaultValue:null,isValid:function(e){return e==null||typeof e==="function"},parseValue:function(e,t){if(e===""){return undefined}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(e)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+e+"'")}var n,r=t&&t.context,a=t&&t.locals;n=i(e,Object.assign({".":r},a));if(n&&this.isValid(n)){return n}throw new TypeError("The string '"+e+"' couldn't be resolved to a function")}})};var p=s("array",{defaultValue:[]});function l(e){n(e instanceof o,"DataType.<createArrayType>: componentType must be a DataType");var t=Object.create(o.prototype);t.getName=function(){return e.getName()+"[]"};t.getComponentType=function(){return e};t.isValid=function(t){if(t===null){return true}if(Array.isArray(t)){for(var n=0;n<t.length;n++){if(!e.isValid(t[n])){return false}}return true}return false};t.parseValue=function(t){var n=t.split(",");for(var r=0;r<n.length;r++){n[r]=e.parseValue(n[r])}return n};t.isArrayType=function(){return true};t.getBaseType=function(){return p};return t}const c=Object.create(null);function y(e,t){var n={},r;for(var a in t){var i=t[a];if(!r){r=i}if(typeof i!=="string"){throw new Error("Value "+i+" for enum type "+e+" is not a string")}if(!n.hasOwnProperty(i)||a==i){n[i]=a}}var u=Object.create(o.prototype);u.getName=function(){return e};u.isValid=function(e){return typeof e==="string"&&n.hasOwnProperty(e)};u.parseValue=function(e){return t[e]};u.getDefaultValue=function(){return r};u.getBaseType=function(){return f.string};u.isEnumType=function(){return true};u.getEnumValues=function(){return t};return u}o.getType=function(i){n(i&&typeof i==="string","sTypeName must be a non-empty string");var u=f[i];if(!(u instanceof o)){if(i.indexOf("[]",i.length-2)>0){var s=i.slice(0,-2),p=this.getType(s);u=p&&l(p);if(u){f[i]=u}}else if(i!=="array"){u=c[i];if(u==null){u=t.get(i);if(u!=null){r.error(`[DEPRECATED] The type '${i}' was accessed via globals. Defining types via globals is deprecated. `+`In case the referenced type is an enum: require the module 'sap/ui/base/DataType' and call the static 'DataType.registerEnum' API. `+`In case the referenced type is non-primitive, please note that only primitive types (and those derived from them) are supported for ManagedObject properties. `+`If the given type is an interface or a subclass of ManagedObject, you can define a "0..1" aggregation instead of a property`)}}if(u instanceof o){f[i]=u}else if(a(u)){u=f[i]=y(i,u);delete c[i]}else if(u){e.warningThrows("'"+i+"' is not a valid data type. Falling back to type 'any'.");u=f.any}else{e.errorThrows("data type '"+i+"' could not be found.");u=undefined}}}return u};o.createType=function(t,r,a){n(typeof t==="string"&&t,"DataType.createType: type name must be a non-empty string");n(a==null||a instanceof o||typeof a==="string"&&a,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(t)){e.errorThrows("DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType")}if(typeof a==="string"){a=o.getType(a)}a=a||f.any;if(a.isArrayType()||a.isEnumType()){e.errorThrows("DataType.createType: base type must not be an array- or enum-type")}if(t==="array"||f[t]instanceof o){if(t==="array"||f[t].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+t+" can't be re-defined")}e.warningThrows("DataTypes.createType: type "+t+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.")}var i=f[t]=s(t,r,a);return i};var d=new Set;o.registerInterfaceTypes=function(e){e.forEach(function(e){d.add(e);(()=>{t.set(e,e)})()})};o.registerEnum=function(e,t){c[e]=t};o._isEnumCandidate=function(e){return!Object.keys(e).some(t=>{const n=typeof e[t];return n==="object"||n==="function"})};o.isInterfaceType=function(e){return d.has(e)};o.createType("sap.ui.core.ID",{isValid:function(e){return/^([A-Za-z_][-A-Za-z0-9_.:]*)$/.test(e)}},o.getType("string"));u.inject(o.registerEnum);return o},true);
//# sourceMappingURL=DataType.js.map