/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./DataType","./EventProvider","./ManagedObjectMetadata","./Object","./BindingInfo","sap/ui/util/ActivityDetection","sap/ui/util/_enforceNoReturnValue","sap/base/future","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/uid","sap/base/util/extend","sap/base/util/isEmptyObject"],function(t,e,i,n,r,s,o,a,g,p,f,d,h,l,u,c){"use strict";const y=t.getType("sap.ui.core.ID");const b=Symbol("bindingInfoFactory");var m=e.extend("sap.ui.base.ManagedObject",{metadata:{abstract:true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{validationSuccess:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"}}},validationError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"},message:{type:"string"}}},parseError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"},message:{type:"string"}}},formatError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"}}},modelContextChange:{}},specialSettings:{id:"sap.ui.core.ID",models:"object",bindingContexts:"object",objectBindings:"object",metadataContexts:"object",Type:{type:"string",visibility:"hidden"}}},constructor:function(t,i,n){e.call(this);const r=this;if(typeof t!=="string"&&t!==undefined){n=i;i=t;t=i&&i.id}if(!t){t=this.getMetadata().uid()}else{t=_?_.call(this,t):t;if(!y.isValid(t)){throw new Error(`"${t}" is not a valid ID.`)}}this.sId=t;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=j;this.mSkipPropagation={};this._bIsOwnerActive=true;this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=S;this._sOwnerId=m._sOwnerId;(function(){var t=false;if(r.register){r.register()}try{if(r._initCompositeSupport){r._initCompositeSupport(i)}if(r.init){o(r.init(),{name:"init",component:r.getId()})}r.applySettings(i,n);t=true}finally{if(!t&&r.deregister){r.deregister()}}})()}},i);Object.defineProperty(m,"bindingParser",{set:function(t){r.parse=t},get:function(){return r.parse}});function v(t){f(t===undefined||typeof t==="string"&&!/^(undefined|null)?$/.test(t),"sModelName must be a string or omitted")}var P=false;function A(t){if(!P){var e=Object.values(t)[0];if(e&&e.mixinBindingSupport){e.mixinBindingSupport(m.prototype);P=true}}}function I(t,e,i){if(!t||t instanceof m||typeof t!=="object"||t instanceof String){return t}function n(t){if(typeof t==="function"){return t}if(typeof t==="string"){const e=g.get(t);if(e!=null){p.error(`Defining the object type ('${t}') via its string name is deprecated, since it leads to accesses to the global namespace. `+`The object type either stems from an explicitly given 'Type' value or was inferred from the default aggregation type. `+`Please require the respective object type module beforehand. `+`For control development, please also refer to the runtime metadata property 'defaultClass', which allows you to specify a default aggregation class type via constructor reference.`)}return e}}let r;r=n(t.Type);r??=e?.defaultClass;r??=n(e?.type);if(typeof r==="function"){return new r(t,i)}var s="Don't know how to create a ManagedObject from "+t+" ("+typeof t+")";p.fatal(s);throw new Error(s)}m.create=I;let _=null;let B=null;m.runWithPreprocessors=function(t,e,i){f(typeof t==="function","fn must be a function");f(!e||typeof e==="object","oPreprocessors must be an object");const n=[_,B];_=e?.id;B=e?.settings;try{return t.call(i)}finally{[_,B]=n}};m.runWithOwner=function(t,e,i){f(typeof t==="function","fn must be a function");var n=m._sOwnerId;try{m._sOwnerId=e;return t.call(i)}finally{m._sOwnerId=n}};m.prototype.applySettings=function(e,i){if(!e||c(e)){return this}var r=this,s=this.getMetadata(),o=s.getJSONKeys(),g,p,d;function h(t){for(var e=0,n=t.length;e<n;e++){var s=t[e];if(Array.isArray(s)){h(s)}else{r[d._sMutator](I(s,d,i))}}}function l(t){r[d._sMutator](t[0],t[1],t[2])}function u(e){var i=t.getType(e),n=i&&i.getPrimitiveType().getName();return n==="object"||n==="any"}B?.call(this,e);if(e.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(e.metadataContexts,e)}if(e.models){if(typeof e.models!=="object"){throw new Error("models must be a simple object")}if(n.isObjectA(e.models,"sap.ui.model.Model")){this.setModel(e.models)}else{for(g in e.models){this.setModel(e.models[g],g==="undefined"?undefined:g)}}}if(e.bindingContexts){if(typeof e.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object")}var y=e.bindingContexts;if(n.isObjectA(y,"sap.ui.model.Context")){this.setBindingContext(e.bindingContexts)}else{for(g in e.bindingContexts){this.setBindingContext(e.bindingContexts[g],g==="undefined"?undefined:g)}}}if(e.objectBindings){if(typeof e.objectBindings!=="string"&&typeof e.objectBindings!=="object"){throw new Error("binding must be a string or simple object")}if(typeof e.objectBindings==="string"||e.objectBindings.path){this.bindObject(e.objectBindings)}else{for(g in e.objectBindings){e.objectBindings[g].model=g==="undefined"?undefined:g;this.bindObject(e.objectBindings[g])}}}for(g in e){p=e[g];if((d=o[g])!==undefined){var b;switch(d._iKind){case 0:b=this.extractBindingInfo(p,i,!u(d.type));if(b&&typeof b==="object"){this.bindProperty(g,b)}else{this[d._sMutator](typeof b==="string"?b:p)}break;case 1:b=d.altTypes&&this.extractBindingInfo(p,i,!d.altTypes.some(u));if(b&&typeof b==="object"){this.bindProperty(g,b)}else{if(Array.isArray(p)){if(p.length>1){a.errorThrows("Tried to add an array of controls to a single aggregation")}p=p[0]}this[d._sMutator](I(typeof b==="string"?b:p,d,i))}break;case 2:b=this.extractBindingInfo(p,i);if(b&&typeof b==="object"){this.bindAggregation(g,b)}else{p=typeof b==="string"?b:p;if(p){if(Array.isArray(p)){h(p)}else{r[d._sMutator](I(p,d,i))}}}break;case 3:this[d._sMutator](p);break;case 4:if(p){if(Array.isArray(p)){for(var m=0,v=p.length;m<v;m++){this[d._sMutator](p[m])}}else{this[d._sMutator](p)}}break;case 5:if(typeof p=="function"){this[d._sMutator](p)}else if(Array.isArray(p[0])&&(p.length<=1||Array.isArray(p[1]))){p.forEach(l)}else{l(p)}break;case-1:break;default:break}}else{f(false,"ManagedObject.apply: encountered unknown setting '"+g+"' for class '"+s.getName()+"' (value:'"+p+"')")}}return this};m.escapeSettingsValue=function(t){return typeof t==="string"?r.escape(t):t};m.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId()};m.prototype.getId=function(){return this.sId};m.prototype.setProperty=function(t,i,n){var r=this.mProperties[t];i=this.validateProperty(t,i);if(h(r,i)){this.mProperties[t]=i;return this}if(n){s.refresh()}this.mProperties[t]=i;if(!n&&!this.isInvalidateSuppressed()){this.invalidate()}this.updateModelProperty(t,i,r);i=this.mProperties[t];if(this.mEventRegistry["_change"]){e.prototype.fireEvent.call(this,"_change",{id:this.getId(),name:t,oldValue:r,newValue:i})}if(this._observer){this._observer.propertyChange(this,t,r,i)}return this};m.prototype.getProperty=function(e){var i=this.mProperties[e],n=this.getMetadata().getManagedProperty(e),r;if(!n){throw new Error('Property "'+e+'" does not exist in '+this)}r=t.getType(n.type);if(r instanceof t&&r.isArrayType()&&Array.isArray(i)){i=i.slice(0)}if(i instanceof String){i=i.valueOf()}if(n.byValue){i=d(i)}return i};m.prototype.validateProperty=function(e,i){var n=this.getMetadata().getManagedProperty(e),r;if(!n){throw new Error('Property "'+e+'" does not exist in '+this)}r=t.getType(n.type);if(r instanceof t&&r.isArrayType()&&Array.isArray(i)){i=i.slice(0)}if(i==null){i=n.getDefaultValue()}else if(r instanceof t){if(r.getName()=="string"){if(!(typeof i=="string"||i instanceof String)){i=""+i}}else if(r.getName()=="string[]"){if(typeof i=="string"){i=[i]}if(!Array.isArray(i)){throw new Error('"'+i+'" is of type '+typeof i+", expected string[]"+' for property "'+e+'" of '+this)}for(var s=0;s<i.length;s++){if(typeof i[s]!=="string"){i[s]=""+i[s]}}}else if(!r.isValid(i)){throw new Error('"'+i+'" is of type '+typeof i+", expected "+r.getName()+' for property "'+e+'" of '+this)}}if(n.byValue){i=d(i)}if(r&&r.normalize&&typeof r.normalize==="function"){i=r.normalize(i)}return i};m.prototype.isPropertyInitial=function(t){return!Object.hasOwn(this.mProperties,t)&&!this.isBound(t)};m.prototype.resetProperty=function(t){if(this.mProperties.hasOwnProperty(t)){var e=this.getMetadata().getManagedProperty(t);e.set(this,null);if(this.mProperties[t]===e.getDefaultValue()){delete this.mProperties[t]}}return this};m.prototype.getOriginInfo=function(t){var e=this.mProperties[t];if(!(e instanceof String&&e.originInfo)){return null}return e.originInfo};m.prototype.setAssociation=function(t,e,i){if(e instanceof m){e=e.getId()}else if(e!=null&&typeof e!=="string"){f(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this}if(this.mAssociations[t]===e){return this}if(i){this.iSuppressInvalidate++}if(this._observer&&this.mAssociations[t]!=null){this._observer.associationChange(this,t,"remove",this.mAssociations[t])}this.mAssociations[t]=e;if(this._observer&&this.mAssociations[t]!=null){this._observer.associationChange(this,t,"insert",e)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(i){this.iSuppressInvalidate--}return this};m.prototype.getAssociation=function(t,e){var i=this.mAssociations[t];if(!i){i=this.mAssociations[t]=e||null}else{if(typeof i.length==="number"&&!i.propertyIsEnumerable("length")){return i.slice()}return i}return i};m.prototype.addAssociation=function(t,e,i){if(e instanceof m){e=e.getId()}else if(typeof e!=="string"){f(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this}if(i){this.iSuppressInvalidate++}var n=this.mAssociations[t];if(!n){n=this.mAssociations[t]=[e]}else{n.push(e)}if(this._observer){this._observer.associationChange(this,t,"insert",e)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(i){this.iSuppressInvalidate--}return this};m.prototype.removeAssociation=function(t,e,i){var n=this.mAssociations[t];var r=null;if(!n){return null}if(i){this.iSuppressInvalidate++}if(typeof e=="object"&&e.getId){e=e.getId()}if(typeof e=="string"){for(var s=0;s<n.length;s++){if(n[s]==e){e=s;break}}}if(typeof e=="number"){if(e>=0&&e<n.length){r=n[e];n.splice(e,1);if(this._observer){this._observer.associationChange(this,t,"remove",r)}if(!this.isInvalidateSuppressed()){this.invalidate()}}}if(i){this.iSuppressInvalidate--}return r};m.prototype.removeAllAssociation=function(t,e){var i=this.mAssociations[t];if(!i){return[]}delete this.mAssociations[t];if(!i.length){return i}if(e){this.iSuppressInvalidate++}if(this._observer){this._observer.associationChange(this,t,"remove",i)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return i};m.prototype.validateAggregation=function(e,i,r,s){var o=this.getMetadata(),a=o.getManagedAggregation(e),p,d,h,l;if(!a){throw new Error('Aggregation "'+e+'" does not exist in '+this)}if(a.multiple!==r){throw new Error("Aggregation '"+e+"' of "+this+" used with wrong cardinality (declared as "+(a.multiple?"0..n":"0..1")+")")}var u=o.getAggregationForwarder(e);if(u&&!s){u.getTarget(this).validateAggregation(u.targetAggregationName,i,r)}if(!a.multiple&&!i){return i}if(n.isObjectA(i,a.type)){return i}p=a.altTypes;if(p&&p.length){if(i==null){return i}for(h=0;h<p.length;h++){d=t.getType(p[h]);if(d instanceof t){if(d.isValid(i)){return i}}}}if((()=>{d=g.get(a.type);if(typeof d==="function"&&i instanceof d){return true}return false})()){return i}l='"'+i+'" is not valid for aggregation "'+e+'" of '+this;if(t.isInterfaceType(a.type)){f(false,l);return i}else{throw new Error(l)}};m.prototype.setAggregation=function(t,e,i){var n=this.getMetadata().getAggregationForwarder(t);if(n){e=this.validateAggregation(t,e,false,true);return n.set(this,e)}var r=this.mAggregations[t];if(r===e){return this}e=this.validateAggregation(t,e,false);if(i){this.iSuppressInvalidate++}this.mAggregations[t]=null;if(r instanceof m){r.setParent(null)}else{if(this._observer!=null&&r!=null){this._observer.aggregationChange(this,t,"remove",r)}}this.mAggregations[t]=e;if(e instanceof m){e.setParent(this,t,i)}else{if(!this.isInvalidateSuppressed()){this.invalidate()}if(this._observer!=null&&e!=null){this._observer.aggregationChange(this,t,"insert",e)}}if(i){this.iSuppressInvalidate--}return this};m.prototype.getAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.get(this)}var n=this.mAggregations[t];if(!n){n=this.mAggregations[t]=e||null}if(n){if(typeof n.length==="number"&&!n.propertyIsEnumerable("length")){return n.slice()}return n}else{return null}};m.prototype.indexOfAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.indexOf(this,e)}var n=this.mAggregations[t];if(n){if(n.length==undefined){return-2}for(var r=0;r<n.length;r++){if(n[r]==e){return r}}}return-1};m.prototype.insertAggregation=function(t,e,i,n){if(!e){return this}e=this.validateAggregation(t,e,true,true);var r=this.getMetadata().getAggregationForwarder(t);if(r){return r.insert(this,e,i)}var s=this.mAggregations[t]||(this.mAggregations[t]=[]);var o;if(i<0){o=0}else if(i>s.length){o=s.length}else{o=i}s.splice(o,0,e);e.setParent(this,t,n);return this};m.prototype.addAggregation=function(t,e,i){if(!e){return this}e=this.validateAggregation(t,e,true,true);var n=this.getMetadata().getAggregationForwarder(t);if(n){return n.add(this,e)}var r=this.mAggregations[t];if(!r){r=this.mAggregations[t]=[e]}else{r.push(e)}e.setParent(this,t,i);return this};m.prototype.removeAggregation=function(t,e,i){var n=this.getMetadata().getAggregationForwarder(t);if(n){return n.remove(this,e)}var r=this.mAggregations[t],s=null,o;if(!r){return null}if(i){this.iSuppressInvalidate++}if(typeof e=="string"){for(o=0;o<r.length;o++){if(r[o]&&r[o].getId()===e){e=o;break}}}if(typeof e=="object"){for(o=0;o<r.length;o++){if(r[o]==e){e=o;break}}}if(typeof e=="number"){if(e>=0&&e<r.length){s=r[e];r.splice(e,1);s.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate()}}}if(i){this.iSuppressInvalidate--}return s};m.prototype.removeAllAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.removeAll(this)}var n=this.mAggregations[t];if(!n){return[]}delete this.mAggregations[t];if(!n.length){return n}if(e){this.iSuppressInvalidate++}for(var r=0;r<n.length;r++){n[r].setParent(null)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return n};m.prototype.destroyAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.destroy(this)}var n=this.mAggregations[t],r,s;if(!n){return this}delete this.mAggregations[t];if(Array.isArray(n)&&!n.length){return this}if(e){this.iSuppressInvalidate++}if(n instanceof m){n.destroy(e);if(this._observer){this._observer.aggregationChange(this,t,"remove",n)}}else if(Array.isArray(n)){for(r=n.length-1;r>=0;r--){s=n[r];if(s){s.destroy(e);if(this._observer){this._observer.aggregationChange(this,t,"remove",s)}}}}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return this};m.prototype.invalidate=function(){if(this.oParent&&this.oParent.isInvalidateSuppressed&&!this.oParent.isInvalidateSuppressed()){this.oParent.invalidate(this)}};m.prototype.isInvalidateSuppressed=function(){return this.iSuppressInvalidate>0};m.prototype._removeChild=function(t,e,i){if(!e){a.errorThrows(`${this}: Cannot remove aggregated child without aggregation name.`)}else{if(i){this.iSuppressInvalidate++}var n=this.indexOfAggregation(e,t);var r=this.getMetadata().getAggregation(e);if(n==-2){if(r&&this[r._sMutator]){this[r._sMutator](null)}else{this.setAggregation(e,null,i)}}else if(n>-1){if(r&&this[r._sRemoveMutator]){this[r._sRemoveMutator](n)}else{this.removeAggregation(e,n,i)}}if(i){this.iSuppressInvalidate--}}};function C(t,e){while(t&&t!==e){t=t.oParent}return!!t}m.prototype.setParent=function(t,e,i){f(t==null||t instanceof m,"oParent either must be null, undefined or a ManagedObject");var n;if(!t){if(this.oParent){n=this._observer||this.oParent._observer;if(n){n.parentChange(this,this.sParentAggregationName,"unset",this.oParent)}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos}}this.oParent=null;this.sParentAggregationName=null;var r=j;if(r!==this.oPropagatedProperties){this.oPropagatedProperties=r;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange()}}.bind(this))}}this._oContextualSettings=S;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this._propagateContextualSettings()}}.bind(this))}s.refresh();return}if(C(t,this)){throw new Error("Cycle detected: new parent '"+t+"' is already a descendant of (or equal to) '"+this+"'")}if(i){s.refresh();t.iSuppressInvalidate++}var o=this.getParent();if(o){o._removeChild(this,this.sParentAggregationName)}this.oParent=t;this.sParentAggregationName=e;if(!t.mSkipPropagation[e]){var r=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():t._getPropertiesToPropagate();if(r!==this.oPropagatedProperties){this.oPropagatedProperties=r;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true)}this._callPropagationListener();this.fireModelContextChange()}}this._applyContextualSettings(t._oContextualSettings);if(t&&!t.isInvalidateSuppressed()){t.invalidate(this)}if(i){t.iSuppressInvalidate--}n=this._observer||this.oParent._observer;if(n){n.parentChange(this,e,"set",this.oParent)}return this};m.prototype._applyContextualSettings=function(t){t=t||S;if(this._oContextualSettings!==t){this._oContextualSettings=t;this._propagateContextualSettings();if(this._bIsOwnerActive){this._onContextualSettingsChanged()}}};m.prototype._onContextualSettingsChanged=function(){};m.prototype._propagateContextualSettings=function(){var t=this._oContextualSettings,e,i,n;for(e in this.mAggregations){i=this.mAggregations[e];if(i instanceof m){i._applyContextualSettings(t)}else if(i instanceof Array){for(n=0;n<i.length;n++){if(i[n]instanceof m){i[n]._applyContextualSettings(t)}}}}};m.prototype._getContextualSettings=function(){return this._oContextualSettings};m.prototype.getParent=function(){return this.oParent};m.prototype.destroy=function(t){var i,n;if(this.bIsDestroyed){return}var r=this;this._bIsBeingDestroyed=true;if(t){this.iSuppressInvalidate++}for(i in this.mBindingInfos){n=this.mBindingInfos[i];if(n.binding){if(n.factory){this._detachAggregationBindingHandlers(i)}else{this._detachPropertyBindingHandlers(i)}}}for(i in this.mObjectBindingInfos){n=this.mObjectBindingInfos[i];if(n.binding){this._detachObjectBindingHandlers(n)}}if(this.exit){o(this.exit(),{name:"exit",component:this.getId()})}if(this._exitCompositeSupport){this._exitCompositeSupport()}for(var s in this.mAggregations){this.destroyAggregation(s,t)}if(this.deregister){this.deregister()}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,t)}delete this.oParent;for(i in this.mBindingInfos){if(this.mBindingInfos[i].factory){this.unbindAggregation(i,true)}else{this.unbindProperty(i,true)}}for(i in this.mObjectBindingInfos){this.unbindObject(i,true)}if(t){this.iSuppressInvalidate--}if(this._observer){this._observer.objectDestroyed(this)}if(this.aAPIParentInfos){this.aAPIParentInfos=null}e.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+r.getId()+" was destroyed and cannot be used anymore.")};this.bIsDestroyed=true};m.prototype.isBinding=function(t,e){return typeof this.extractBindingInfo(t)==="object"};m.prototype.extractBindingInfo=function(t,e,i){var n=r.extract(t,e,i);if(typeof t==="object"&&n&&n.template){n.template=I(n.template)}return n};m.prototype.getBindingInfo=function(t){var e=this.getMetadata().getAggregationForwarder(t);if(e&&e.forwardBinding){return e.getTarget(this).getBindingInfo(e.targetAggregationName)}return this.mBindingInfos[t]};m.prototype._getObjectBindingInfo=function(t){return this.mObjectBindingInfos[t]};m.prototype.bindObject=function(t){var e;if(arguments[1]){a.fatalThrows(`${this}.bindObject: Providing 'parameters' as positional parameter is deprecated as of 1.135.0. Provide an sap.ui.base.ManagedObject.ObjectBindingInfo instead.`)}if(typeof t=="string"){t={path:t,parameters:arguments[1]}}t=r.createObject(t);e=t.model;if(this.getObjectBinding(e)){this.unbindObject(e,true)}this.mObjectBindingInfos[e]=t;if(r.isReady(t,this)){this._bindObject(t)}return this};function M(t){a.errorThrows("Unexpected call of '"+t+"'.")}m.prototype._bindObject=M.bind(null,"_bindObject");m.prototype._detachObjectBindingHandlers=M.bind(null,"_detachObjectBindingHandlers");m.prototype.unbindObject=function(t,e){var i=this.mObjectBindingInfos[t];if(i){delete this.mObjectBindingInfos[t];if(i.binding){this._unbindObject(i,t,e)}}return this};m.prototype._unbindObject=M.bind(null,"_unbindObject");m.prototype.bindContext=function(t){return this.bindObject(t)};m.prototype.unbindContext=function(t){return this.unbindObject(t)};m.prototype.bindProperty=function(t,e){var i=this.getMetadata().getPropertyLikeSetting(t);if(!i){throw new Error('Property "'+t+'" does not exist in '+this)}if(arguments[2]||arguments[3]){a.fatalThrows(`${this}.bindProperty: Providing a type, formatter, or bindingMode as a positional parameter is deprecated as of 1.135.0. Provide an sap.ui.base.ManagedObject.PropertyBindingInfo instead.`)}if(typeof e=="string"){e={parts:[{path:e,type:n.isObjectA(arguments[2],"sap.ui.model.Type")?arguments[2]:undefined,mode:arguments[3]}],formatter:typeof arguments[2]==="function"?arguments[2]:undefined}}if(this.isBound(t)){this.unbindProperty(t,true)}e=r.createProperty(e);this.mBindingInfos[t]=e;if(this._observer){this._observer.bindingChange(this,t,"prepare",e,"property")}if(r.isReady(e,this)){this._bindProperty(t,e)}return this};m.prototype._bindProperty=function(t,e){var i=true;for(var n=0;n<e.parts.length;n++){if(e.parts[n].value===undefined){i=false;break}}if(i){var r=[];e.parts.forEach(function(t){r.push(t.formatter?t.formatter(t.value):t.value)});var s=e.formatter?e.formatter(r):r.join(" ");var o=this.getMetadata().getPropertyLikeSetting(t);this[o._sMutator](s)}else{M.call(this,"_bindProperty")}};m.prototype._detachPropertyBindingHandlers=function(t){};m.prototype.unbindProperty=function(t,e){var i=this.mBindingInfos[t];if(i){if(i.binding){this._unbindProperty(i,t)}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,t,"remove",this.mBindingInfos[t],"property")}delete this.mBindingInfos[t];if(!e){this.resetProperty(t)}}return this};m.prototype._unbindProperty=M.bind(null,"_unbindProperty");m.prototype.isPropertyBeingUpdated=function(t){const e=this.getBindingInfo(t);return!!e?.skipModelUpdate};m.prototype.updateProperty=function(t){};m.prototype.updateModelProperty=function(t,e,i){};var w=1;m.prototype.bindAggregation=function(t,e,i){var n=this.getMetadata(),s=n.getAggregation(t);if(!s){throw new Error('Aggregation "'+t+'" does not exist in '+this)}if(!s.multiple){a.errorThrows('Binding of single aggregation "'+t+'" of '+this+" is not supported!")}if(arguments[3]||arguments[4]){a.fatalThrows(`${this}.bindAggregation: Providing sorters and/or filters as positional parameters is deprecated as of 1.135.0. Provide an sap.ui.base.ManagedObject.AggregationBindingInfo instead.`)}if(typeof e=="string"){e={path:e,sorter:arguments[3],filters:arguments[4]};if(i instanceof m){e.template=i}else if(typeof i==="function"){e.factory=i}}e[r.OriginalParent]??=this;var o=n.getAggregationForwarder(t);if(o&&o.forwardBinding){o.getTarget(this).bindAggregation(o.targetAggregationName,e);return this}if(this.isBound(t)){this.unbindAggregation(t)}if(e.template){if(e.template._sapui_candidateForDestroy){a.warningThrows("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+t+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete e.template._sapui_candidateForDestroy}if(e.templateShareable===undefined){e.templateShareable=w}else if(typeof e.templateShareable==="string"){a.warningThrows(`Parameter 'templateShareable' is defined with type boolean but is set for binding template ${e.template.toString()} with string value "${e.templateShareable}". This can easily lead to errors. To avoid unintended behavior, always set the parameter to true or false`);if(e.templateShareable==="true"){e.templateShareable=true}else if(e.templateShareable==="false"){e.templateShareable=false}}}e=r.createAggregation(e,s._doesNotRequireFactory);this.mBindingInfos[t]=e;if(!(e.template||e.factory)){throw new Error("Missing template or factory function for aggregation "+t+" of "+this+" !")}if(e.factory){var g=e.factory[b]||e.factory;var p=this._sOwnerId;e.factory=function(t,e){return m.runWithOwner(g.bind(null,t,e),p)};e.factory[b]=g}if(this._observer){this._observer.bindingChange(this,t,"prepare",e,"aggregation")}if(r.isReady(e,this)){this._bindAggregation(t,e)}return this};m.prototype._bindAggregation=M.bind(null,"_bindAggregation");m.prototype._detachAggregationBindingHandlers=M.bind(null,"_detachAggregationBindingHandlers");m.prototype.unbindAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i&&i.forwardBinding){i.getTarget(this).unbindAggregation(i.targetAggregationName,e);return this}var n=this.mBindingInfos[t],r=this.getMetadata().getAggregation(t);if(n){if(n.binding){this._unbindAggregation(n,t)}if(n.template){if(!n.templateShareable&&n.template.destroy){n.template.destroy()}if(n.templateShareable===w){n.template._sapui_candidateForDestroy=true}}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,t,"remove",this.mBindingInfos[t],"aggregation")}delete this.mBindingInfos[t];if(!e){this[r._sDestructor]()}}return this};m.prototype._unbindAggregation=M.bind(null,"_unbindAggregation");m.prototype.updateAggregation=function(t,e,i){};m.prototype.refreshAggregation=function(t){};m.prototype.propagateMessages=function(t,e){a.warningThrows("Message for "+this+", Property "+t+" received. Control "+this.getMetadata().getName()+" does not support messaging without using data binding.")};m.prototype.isTreeBinding=function(t){return false};m.prototype.updateBindings=function(t,e){};m.prototype.isBound=function(t){return!!this.getBindingInfo(t)};m.prototype.getObjectBinding=function(t){v(t);var e=this._getObjectBindingInfo(t);return e&&e.binding};m.prototype.getEventingParent=function(){return this.oParent};m.prototype.getBinding=function(t){var e=this.getBindingInfo(t);return e&&e.binding};m.prototype.getBindingPath=function(t){var e=this.getBindingInfo(t);return e&&(e.path||e.parts&&e.parts[0]&&e.parts[0].path)};m.prototype.setBindingContext=function(t,e){v(e);var i=this.oBindingContexts[e];if(i!==t||t&&t.hasChanged()){if(t===undefined){delete this.oBindingContexts[e]}else{this.oBindingContexts[e]=t}this.updateBindingContext(false,e);this.propagateProperties(e);this.fireModelContextChange()}return this};m.prototype.setElementBindingContext=function(t,e){};m.prototype.updateBindingContext=function(t,e,i){};m.prototype.getBindingContext=function(t){var e=this.getModel(t),i=this.mElementBindingContexts[t];if(i&&!e){return i}else if(i&&e&&i.getModel()===e){return i}else if(i===null){return i}else{return this._getBindingContext(t)}};m.prototype._getBindingContext=function(t){var e=this.getModel(t),i=this.oBindingContexts[t],n=this.oPropagatedProperties.oBindingContexts[t];if(i&&!e){return this.oBindingContexts[t]}else if(i&&e&&i.getModel()===e){return this.oBindingContexts[t]}else if(i===null){return i}else if(n&&e&&n.getModel()!==e){return undefined}else{return n}};m.prototype.setModel=function(t,e){f(t==null||n.isObjectA(t,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");f(e===undefined||typeof e==="string"&&!/^(undefined|null)?$/.test(e),"sName must be a string or omitted");if(!t&&this.oModels[e]){delete this.oModels[e];this.propagateProperties(e);this.updateBindings(false,e);this.fireModelContextChange()}else if(t&&t!==this.oModels[e]){this.oModels[e]=t;this.propagateProperties(e);this.updateBindingContext(false,e);this.updateBindings(false,e);this.fireModelContextChange()}return this};m.prototype.addPropagationListener=function(t){f(typeof t==="function","listener must be a function");this.aPropagationListeners.push(t);this.propagateProperties(false);this._callPropagationListener(t);return this};m.prototype.removePropagationListener=function(t){f(typeof t==="function","listener must be a function");var e=this.aPropagationListeners;var i=e.indexOf(t);if(i>=0){e.splice(i,1);this.propagateProperties(false)}return this};m.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners)};m.prototype._callPropagationListener=function(t){var e;if(t){t(this)}else{e=this.getPropagationListeners();for(var i=0;i<e.length;i++){t=e[i];t(this)}}return this};const j={oModels:{},oBindingContexts:{},aPropagationListeners:[]};function x(t,e){return!e.aAPIParentInfos||e.aAPIParentInfos[0].parent===t}m.prototype.propagateProperties=function(t){var e=this._getPropertiesToPropagate(),i=t===true,n=t===false,r=i?undefined:t,s,o,a,g=Object.assign({},this.mAggregations,this.mForwardedAggregations);A(e.oModels);for(s in g){if(this.mSkipPropagation[s]){continue}o=g[s];if(o instanceof m){if(x(this,o)){this._propagateProperties(t,o,e,i,r,n)}}else if(o instanceof Array){for(a=0;a<o.length;a++){if(o[a]instanceof m){if(x(this,o[a])){this._propagateProperties(t,o[a],e,i,r,n)}}}}}};m.prototype._propagateProperties=function(t,e,i,n,r,s){if(!i){i=this._getPropertiesToPropagate();n=t===true;s=t===false;r=n?undefined:t}A(i.oModels);if(e.oPropagatedProperties!==i){e.oPropagatedProperties=i;if(s!==true){e.updateBindings(n,r);e.updateBindingContext(false,r,n)}e.propagateProperties(t);if(s||n){e._callPropagationListener()}e.fireModelContextChange()}};m.prototype._getPropertiesToPropagate=function(){var t=c(this.oModels),e=c(this.oBindingContexts),i=this.aPropagationListeners.length===0,n=c(this.mElementBindingContexts);function r(t,e,i,n){return t?e:u({},e,i,n)}function s(t,e,i){return t?e:e.concat(i)}if(e&&t&&n&&i){return this.oPropagatedProperties}else{return{oModels:r(t,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:r(e&&n,this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:s(i,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)}}};m.prototype.getModel=function(t){v(t);return this.oModels[t]||this.oPropagatedProperties.oModels[t]};m.prototype.getOwnModels=function(){return this.oModels};m.prototype.hasModel=function(){return!(c(this.oModels)&&c(this.oPropagatedProperties.oModels))};m.prototype.clone=function(t,e,n){var s=true,o=true;if(n){s=!!n.cloneChildren;o=!!n.cloneBindings}if(!t){t=i.uid("clone")||l()}if(!e&&s){e=this.findAggregatedObjects(true,null,true).map(function(t){return t.getId()});e.push(this.getId())}var g=this.getMetadata(),p=g._oClass,f=this.getId()+"-"+t,h={},u,c=this.mProperties,y,b,v,P=r.escape,A,I;var _=Object.keys(c);var B;A=_.length;while(A>0){y=_[--A];u=g.getProperty(y);if(u&&!(this.isBound(y)&&o)){if(typeof c[y]==="string"){h[y]=P(c[y])}else{B=u.byValue?d(c[y]):c[y];if(B&&typeof B==="object"&&!Object.isFrozen(B)){B[r.UI5ObjectMarker]=true}h[y]=B}}}h["models"]=this.oModels;h["bindingContexts"]=this.oBindingContexts;if(s){var C=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(b in C){var M=C[b];if(g.hasAggregation(b)&&!(this.isBound(b)&&o)){if(M instanceof m){h[b]=M.clone(t,e)}else if(Array.isArray(M)){h[b]=[];for(var A=0;A<M.length;A++){h[b].push(M[A].clone(t,e))}}else{h[b]=typeof M==="string"?P(M):M}}}for(b in this.mAssociations){if(!g.hasAssociation(b)){continue}var j=this.mAssociations[b];if(Array.isArray(j)){j=j.slice(0);for(var A=0;A<j.length;A++){if(e.indexOf(j[A])>=0){j[A]+="-"+t}}}else if(e.indexOf(j)>=0){j+="-"+t}h[b]=j}}v=new p(f,h);function x(i,n,r,s,o){var g=!r;var p=Object.assign({},i);if(!i.templateShareable&&i.template&&i.template.clone){p.template=i.template.clone(t,e);delete p.factory}else if(i.templateShareable===w){i.templateShareable=p.templateShareable=true;a.errorThrows("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+o+"' of object '"+s.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.")}delete p.binding;delete p.modelChangeHandler;delete p.dataStateChangeHandler;delete p.modelRefreshHandler;if(g){n.bindObject(p)}else if(i.factory){n.bindAggregation(r,p)}else{n.bindProperty(r,p)}}for(b in this.mEventRegistry){v.mEventRegistry[b]=this.mEventRegistry[b].slice()}if(o){for(b in this.mObjectBindingInfos){x(this.mObjectBindingInfos[b],v)}for(b in this.mBindingInfos){x(this.mBindingInfos[b],v,b,this,b)}}if(m._supportInfo){m._supportInfo.addSupportInfo(v.getId(),m._supportInfo.byId(this.getId()))}if(this._cloneMetadataContexts){this._cloneMetadataContexts(v)}if(this.mForwardedAggregations){for(b in this.mForwardedAggregations){var S=v.getMetadata().getAggregationForwarder(b);if(S){I=S.getTarget(v,true);if(S.forwardBinding&&this.isBound(b)){x(this.getBindingInfo(b),I,S.targetAggregationName,this,b)}}}}return v};m.prototype.findAggregatedObjects=function(t,e,i){var n=[];if(e&&typeof e!=="function"){e=null}function r(s){var o,a,g;if(i){for(g in s.mBindingInfos){o=s.mBindingInfos[g].template;if(o){if(!e||e(o)){n.push(o)}if(t){r(o)}}}}for(g in s.mAggregations){o=s.mAggregations[g];if(Array.isArray(o)){for(a=0;a<o.length;a++){if(!e||e(o[a])){n.push(o[a])}if(t){r(o[a])}}}else if(o instanceof m){if(!e||e(o)){n.push(o)}if(t){r(o)}}}}r(this);return n};m.prototype.onOwnerDeactivation=function(){this._bIsOwnerActive=false};m.prototype.onOwnerActivation=function(){this._bIsOwnerActive=true;this._onContextualSettingsChanged()};m.prototype.isDestroyStarted=function(){return!!this._bIsBeingDestroyed};m.prototype.isDestroyed=function(){return!!this.bIsDestroyed};m.prototype.updateFieldHelp=undefined;const S={};return m});
//# sourceMappingURL=ManagedObject.js.map