ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("../virtual_renderer").VirtualRenderer;var o=e("../editor").Editor;var r=e("../range").Range;var s=e("../lib/event");var a=e("../lib/lang");var l=e("../lib/dom");var c=e("../config").nls;var p=e("./../lib/useragent");var u=function(e){return"suggest-aria-id:".concat(e)};var h=p.isSafari?"menu":"listbox";var d=p.isSafari?"menuitem":"option";var f=p.isSafari?"aria-current":"aria-selected";var m=function(e){var t=new n(e);t.$maxLines=4;var i=new o(t);i.setHighlightActiveLine(false);i.setShowPrintMargin(false);i.renderer.setShowGutter(false);i.renderer.setHighlightGutterLine(false);i.$mouseHandler.$focusTimeout=0;i.$highlightTagPending=true;return i};var g=function(){function e(e){var t=l.createElement("div");var i=m(t);if(e){e.appendChild(t)}t.style.display="none";i.renderer.content.style.cursor="default";i.renderer.setStyle("ace_autocomplete");i.renderer.$textLayer.element.setAttribute("role",h);i.renderer.$textLayer.element.setAttribute("aria-roledescription",c("autocomplete.popup.aria-roledescription","Autocomplete suggestions"));i.renderer.$textLayer.element.setAttribute("aria-label",c("autocomplete.popup.aria-label","Autocomplete suggestions"));i.renderer.textarea.setAttribute("aria-hidden","true");i.setOption("displayIndentGuides",false);i.setOption("dragDelay",150);var n=function(){};i.focus=n;i.$isFocused=true;i.renderer.$cursorLayer.restartTimer=n;i.renderer.$cursorLayer.element.style.opacity="0";i.renderer.$maxLines=8;i.renderer.$keepTextAreaAtCursor=false;i.setHighlightActiveLine(false);i.session.highlight("");i.session.$searchHighlight.clazz="ace_highlight-marker";i.on("mousedown",function(e){var t=e.getDocumentPosition();i.selection.moveToPosition(t);g.start.row=g.end.row=t.row;e.stop()});var o;var p=new r(-1,0,-1,Infinity);var g=new r(-1,0,-1,Infinity);g.id=i.session.addMarker(g,"ace_active-line","fullLine");i.setSelectOnHover=function(e){if(!e){p.id=i.session.addMarker(p,"ace_line-hover","fullLine")}else if(p.id){i.session.removeMarker(p.id);p.id=null}};i.setSelectOnHover(false);i.on("mousemove",function(e){if(!o){o=e;return}if(o.x==e.x&&o.y==e.y){return}o=e;o.scrollTop=i.renderer.scrollTop;i.isMouseOver=true;var t=o.getDocumentPosition().row;if(p.start.row!=t){if(!p.id)i.setRow(t);b(t)}});i.renderer.on("beforeRender",function(){if(o&&p.start.row!=-1){o.$pos=null;var e=o.getDocumentPosition().row;if(!p.id)i.setRow(e);b(e,true)}});i.renderer.on("afterRender",function(){var e=i.getRow();var t=i.renderer.$textLayer;var n=t.element.childNodes[e-t.config.firstRow];var o=document.activeElement;if(n!==i.selectedNode&&i.selectedNode){l.removeCssClass(i.selectedNode,"ace_selected");o.removeAttribute("aria-activedescendant");i.selectedNode.removeAttribute(f);i.selectedNode.removeAttribute("id")}i.selectedNode=n;if(n){l.addCssClass(n,"ace_selected");var r=u(e);n.id=r;t.element.setAttribute("aria-activedescendant",r);o.setAttribute("aria-activedescendant",r);n.setAttribute("role",d);n.setAttribute("aria-roledescription",c("autocomplete.popup.item.aria-roledescription","item"));n.setAttribute("aria-label",i.getData(e).caption||i.getData(e).value);n.setAttribute("aria-setsize",i.data.length);n.setAttribute("aria-posinset",e+1);n.setAttribute("aria-describedby","doc-tooltip");n.setAttribute(f,"true")}});var v=function(){b(-1)};var b=function(e,t){if(e!==p.start.row){p.start.row=p.end.row=e;if(!t)i.session._emit("changeBackMarker");i._emit("changeHoverMarker")}};i.getHoveredRow=function(){return p.start.row};s.addListener(i.container,"mouseout",function(){i.isMouseOver=false;v()});i.on("hide",v);i.on("changeSelection",v);i.session.doc.getLength=function(){return i.data.length};i.session.doc.getLine=function(e){var t=i.data[e];if(typeof t=="string")return t;return t&&t.value||""};var y=i.session.bgTokenizer;y.$tokenizeRow=function(e){var t=i.data[e];var n=[];if(!t)return n;if(typeof t=="string")t={value:t};var o=t.caption||t.value||t.name;function r(e,i){e&&n.push({type:(t.className||"")+(i||""),value:e})}var s=o.toLowerCase();var a=(i.filterText||"").toLowerCase();var l=0;var c=0;for(var p=0;p<=a.length;p++){if(p!=c&&(t.matchMask&1<<p||p==a.length)){var u=a.slice(c,p);c=p;var h=s.indexOf(u,l);if(h==-1)continue;r(o.slice(l,h),"");l=h+u.length;r(o.slice(h,l),"completion-highlight")}}r(o.slice(l,o.length),"");n.push({type:"completion-spacer",value:" "});if(t.meta)n.push({type:"completion-meta",value:t.meta});if(t.message)n.push({type:"completion-message",value:t.message});return n};y.$updateOnChange=n;y.start=n;i.session.$computeWidth=function(){return this.screenWidth=0};i.isOpen=false;i.isTopdown=false;i.autoSelect=true;i.filterText="";i.isMouseOver=false;i.data=[];i.setData=function(e,t){i.filterText=t||"";i.setValue(a.stringRepeat("\n",e.length),-1);i.data=e||[];i.setRow(0)};i.getData=function(e){return i.data[e]};i.getRow=function(){return g.start.row};i.setRow=function(e){e=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,e));if(g.start.row!=e){i.selection.clearSelection();g.start.row=g.end.row=e||0;i.session._emit("changeBackMarker");i.moveCursorTo(e||0,0);if(i.isOpen)i._signal("select")}};i.on("changeSelection",function(){if(i.isOpen)i.setRow(i.selection.lead.row);i.renderer.scrollCursorIntoView()});i.hide=function(){this.container.style.display="none";i.anchorPos=null;i.anchor=null;if(i.isOpen){i.isOpen=false;this._signal("hide")}};i.tryShow=function(e,t,n,r){if(!r&&i.isOpen&&i.anchorPos&&i.anchor&&i.anchorPos.top===e.top&&i.anchorPos.left===e.left&&i.anchor===n){return true}var s=this.container;var a=window.innerHeight;var l=window.innerWidth;var c=this.renderer;var p=c.$maxLines*t*1.4;var u={top:0,bottom:0,left:0};var h=a-e.top-3*this.$borderSize-t;var d=e.top-3*this.$borderSize;if(!n){if(d<=h||h>=p){n="bottom"}else{n="top"}}if(n==="top"){u.bottom=e.top-this.$borderSize;u.top=u.bottom-p}else if(n==="bottom"){u.top=e.top+t+this.$borderSize;u.bottom=u.top+p}var f=u.top>=0&&u.bottom<=a;if(!r&&!f){return false}if(!f){if(n==="top"){c.$maxPixelHeight=d}else{c.$maxPixelHeight=h}}else{c.$maxPixelHeight=null}if(n==="top"){s.style.top="";s.style.bottom=a-u.bottom+"px";i.isTopdown=false}else{s.style.top=u.top+"px";s.style.bottom="";i.isTopdown=true}s.style.display="";var m=e.left;if(m+s.offsetWidth>l)m=l-s.offsetWidth;s.style.left=m+"px";s.style.right="";if(!i.isOpen){i.isOpen=true;this._signal("show");o=null}i.anchorPos=e;i.anchor=n;return true};i.show=function(e,t,i){this.tryShow(e,t,i?"bottom":undefined,true)};i.goTo=function(e){var t=this.getRow();var i=this.session.getLength()-1;switch(e){case"up":t=t<=0?i:t-1;break;case"down":t=t>=i?-1:t+1;break;case"start":t=0;break;case"end":t=i;break}this.setRow(t)};i.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize};i.$imageSize=0;i.$borderSize=1;return i}return e}();l.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",false);t.AcePopup=g;t.$singleLineEditor=m;t.getAriaId=u});ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(e,t,i){"use strict";var n=e("./lib/dom");var o=e("./lib/oop");var r=e("./lib/event_emitter").EventEmitter;var s=e("./lib/lang");var a=e("./range").Range;var l=e("./range_list").RangeList;var c=e("./keyboard/hash_handler").HashHandler;var p=e("./tokenizer").Tokenizer;var u=e("./clipboard");var h={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,i){var n=e.session.getTextRange();if(i)return n.replace(/\n\r?([ \t]*\S)/g,"\n"+i+"$1");return n},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return u.getText&&u.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(e){var t=e.session.$mode||{};return t.lineCommentStart||""},CURRENT_YEAR:d.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:d.bind(null,{year:"2-digit"}),CURRENT_MONTH:d.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:d.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:d.bind(null,{month:"short"}),CURRENT_DATE:d.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:d.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:d.bind(null,{weekday:"short"}),CURRENT_HOUR:d.bind(null,{hour:"2-digit",hour12:false}),CURRENT_MINUTE:d.bind(null,{minute:"2-digit"}),CURRENT_SECOND:d.bind(null,{second:"2-digit"})};h.SELECTED_TEXT=h.SELECTION;function d(e){var t=(new Date).toLocaleString("en-us",e);return t.length==1?"0"+t:t}var f=function(){function e(){this.snippetMap={};this.snippetNameMap={};this.variables=h}e.prototype.getTokenizer=function(){return e["$tokenizer"]||this.createTokenizer()};e.prototype.createTokenizer=function(){function t(e){e=e.substr(1);if(/^\d+$/.test(e))return[{tabstopId:parseInt(e,10)}];return[{text:e}]}function i(e){return"(?:[^\\\\"+e+"]|\\\\.)"}var n={regex:"/("+i("/")+"+)/",onMatch:function(e,t,i){var n=i[0];n.fmtString=true;n.guard=e.slice(1,-1);n.flag="";return""},next:"formatString"};e["$tokenizer"]=new p({start:[{regex:/\\./,onMatch:function(e,t,i){var n=e[1];if(n=="}"&&i.length){e=n}else if("`$\\".indexOf(n)!=-1){e=n}return[e]}},{regex:/}/,onMatch:function(e,t,i){return[i.length?i.shift():e]}},{regex:/\$(?:\d+|\w+)/,onMatch:t},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(e,i,n){var o=t(e.substr(1));n.unshift(o[0]);return o},next:"snippetVar"},{regex:/\n/,token:"newline",merge:false}],snippetVar:[{regex:"\\|"+i("\\|")+"*\\|",onMatch:function(e,t,i){var n=e.slice(1,-1).replace(/\\[,|\\]|,/g,function(e){return e.length==2?e[1]:"\0"}).split("\0").map(function(e){return{value:e}});i[0].choices=n;return[n[0]]},next:"start"},n,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(e,t,i){if(i.length&&i[0].expectElse){i[0].expectElse=false;i[0].ifEnd={elseEnd:i[0]};return[i[0].ifEnd]}return":"}},{regex:/\\./,onMatch:function(e,t,i){var n=e[1];if(n=="}"&&i.length)e=n;else if("`$\\".indexOf(n)!=-1)e=n;else if(n=="n")e="\n";else if(n=="t")e="\t";else if("ulULE".indexOf(n)!=-1)e={changeCase:n,local:n>"a"};return[e]}},{regex:"/\\w*}",onMatch:function(e,t,i){var n=i.shift();if(n)n.flag=e.slice(1,-1);this.next=n&&n.tabstopId?"start":"";return[n||e]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(e,t,i){return[{text:e.slice(1)}]}},{regex:/\${\w+/,onMatch:function(e,t,i){var n={text:e.slice(2)};i.unshift(n);return[n]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:false},{regex:/}/,onMatch:function(e,t,i){var n=i.shift();this.next=n&&n.tabstopId?"start":"";return[n||e]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(e,t,i){var n=i[0];n.formatFunction=e.slice(2,-1);return[i.shift()]},next:"formatString"},n,{regex:/:[\?\-+]?/,onMatch:function(e,t,i){if(e[1]=="+")i[0].ifEnd=i[0];if(e[1]=="?")i[0].expectElse=true},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]});return e["$tokenizer"]};e.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(e){return e.value||e})};e.prototype.getVariableValue=function(e,t,i){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";t=t.replace(/^TM_/,"");if(!this.variables.hasOwnProperty(t))return"";var n=this.variables[t];if(typeof n=="function")n=this.variables[t](e,t,i);return n==null?"":n};e.prototype.tmStrFormat=function(e,t,i){if(!t.fmt)return e;var n=t.flag||"";var o=t.guard;o=new RegExp(o,n.replace(/[^gim]/g,""));var r=typeof t.fmt=="string"?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt;var s=this;var a=e.replace(o,function(){var e=s.variables.__;s.variables.__=[].slice.call(arguments);var t=s.resolveVariables(r,i);var n="E";for(var o=0;o<t.length;o++){var a=t[o];if(typeof a=="object"){t[o]="";if(a.changeCase&&a.local){var l=t[o+1];if(l&&typeof l=="string"){if(a.changeCase=="u")t[o]=l[0].toUpperCase();else t[o]=l[0].toLowerCase();t[o+1]=l.substr(1)}}else if(a.changeCase){n=a.changeCase}}else if(n=="U"){t[o]=a.toUpperCase()}else if(n=="L"){t[o]=a.toLowerCase()}}s.variables.__=e;return t.join("")});return a};e.prototype.tmFormatFunction=function(e,t,i){if(t.formatFunction=="upcase")return e.toUpperCase();if(t.formatFunction=="downcase")return e.toLowerCase();return e};e.prototype.resolveVariables=function(e,t){var i=[];var n="";var o=true;for(var r=0;r<e.length;r++){var s=e[r];if(typeof s=="string"){i.push(s);if(s=="\n"){o=true;n=""}else if(o){n=/^\t*/.exec(s)[0];o=/\S/.test(s)}continue}if(!s)continue;o=false;if(s.fmtString){var a=e.indexOf(s,r+1);if(a==-1)a=e.length;s.fmt=e.slice(r+1,a);r=a}if(s.text){var l=this.getVariableValue(t,s.text,n)+"";if(s.fmtString)l=this.tmStrFormat(l,s,t);if(s.formatFunction)l=this.tmFormatFunction(l,s,t);if(l&&!s.ifEnd){i.push(l);c(s)}else if(!l&&s.ifEnd){c(s.ifEnd)}}else if(s.elseEnd){c(s.elseEnd)}else if(s.tabstopId!=null){i.push(s)}else if(s.changeCase!=null){i.push(s)}}function c(t){var i=e.indexOf(t,r+1);if(i!=-1)r=i}return i};e.prototype.getDisplayTextForSnippet=function(e,t){var i=m.call(this,e,t);return i.text};e.prototype.insertSnippetForSelection=function(e,t,i){if(i===void 0){i={}}var n=m.call(this,e,t,i);var o=e.getSelectionRange();var r=e.session.replace(o,n.text);var s=new g(e);var a=e.inVirtualSelectionMode&&e.selection.index;s.addTabstops(n.tabstops,o.start,r,a)};e.prototype.insertSnippet=function(e,t,i){if(i===void 0){i={}}var n=this;if(e.inVirtualSelectionMode)return n.insertSnippetForSelection(e,t,i);e.forEachSelection(function(){n.insertSnippetForSelection(e,t,i)},null,{keepOrder:true});if(e.tabstopManager)e.tabstopManager.tabNext()};e.prototype.$getScope=function(e){var t=e.session.$mode.$id||"";t=t.split("/").pop();if(t==="html"||t==="php"){if(t==="php"&&!e.session.$mode.inlinePhp)t="html";var i=e.getCursorPosition();var n=e.session.getState(i.row);if(typeof n==="object"){n=n[0]}if(n.substring){if(n.substring(0,3)=="js-")t="javascript";else if(n.substring(0,4)=="css-")t="css";else if(n.substring(0,4)=="php-")t="php"}}return t};e.prototype.getActiveScopes=function(e){var t=this.$getScope(e);var i=[t];var n=this.snippetMap;if(n[t]&&n[t].includeScopes){i.push.apply(i,n[t].includeScopes)}i.push("_");return i};e.prototype.expandWithTab=function(e,t){var i=this;var n=e.forEachSelection(function(){return i.expandSnippetForSelection(e,t)},null,{keepOrder:true});if(n&&e.tabstopManager)e.tabstopManager.tabNext();return n};e.prototype.expandSnippetForSelection=function(e,t){var i=e.getCursorPosition();var n=e.session.getLine(i.row);var o=n.substring(0,i.column);var r=n.substr(i.column);var s=this.snippetMap;var a;this.getActiveScopes(e).some(function(e){var t=s[e];if(t)a=this.findMatchingSnippet(t,o,r);return!!a},this);if(!a)return false;if(t&&t.dryRun)return true;e.session.doc.removeInLine(i.row,i.column-a.replaceBefore.length,i.column+a.replaceAfter.length);this.variables.M__=a.matchBefore;this.variables.T__=a.matchAfter;this.insertSnippetForSelection(e,a.content);this.variables.M__=this.variables.T__=null;return true};e.prototype.findMatchingSnippet=function(e,t,i){for(var n=e.length;n--;){var o=e[n];if(o.startRe&&!o.startRe.test(t))continue;if(o.endRe&&!o.endRe.test(i))continue;if(!o.startRe&&!o.endRe)continue;o.matchBefore=o.startRe?o.startRe.exec(t):[""];o.matchAfter=o.endRe?o.endRe.exec(i):[""];o.replaceBefore=o.triggerRe?o.triggerRe.exec(t)[0]:"";o.replaceAfter=o.endTriggerRe?o.endTriggerRe.exec(i)[0]:"";return o}};e.prototype.register=function(e,t){var i=this.snippetMap;var n=this.snippetNameMap;var o=this;if(!e)e=[];function r(e){if(e&&!/^\^?\(.*\)\$?$|^\\b$/.test(e))e="(?:"+e+")";return e||""}function a(e,t,i){e=r(e);t=r(t);if(i){e=t+e;if(e&&e[e.length-1]!="$")e=e+"$"}else{e=e+t;if(e&&e[0]!="^")e="^"+e}return new RegExp(e)}function l(e){if(!e.scope)e.scope=t||"_";t=e.scope;if(!i[t]){i[t]=[];n[t]={}}var r=n[t];if(e.name){var l=r[e.name];if(l)o.unregister(l);r[e.name]=e}i[t].push(e);if(e.prefix)e.tabTrigger=e.prefix;if(!e.content&&e.body)e.content=Array.isArray(e.body)?e.body.join("\n"):e.body;if(e.tabTrigger&&!e.trigger){if(!e.guard&&/^\w/.test(e.tabTrigger))e.guard="\\b";e.trigger=s.escapeRegExp(e.tabTrigger)}if(!e.trigger&&!e.guard&&!e.endTrigger&&!e.endGuard)return;e.startRe=a(e.trigger,e.guard,true);e.triggerRe=new RegExp(e.trigger);e.endRe=a(e.endTrigger,e.endGuard,true);e.endTriggerRe=new RegExp(e.endTrigger)}if(Array.isArray(e)){e.forEach(l)}else{Object.keys(e).forEach(function(t){l(e[t])})}this._signal("registerSnippets",{scope:t})};e.prototype.unregister=function(e,t){var i=this.snippetMap;var n=this.snippetNameMap;function o(e){var o=n[e.scope||t];if(o&&o[e.name]){delete o[e.name];var r=i[e.scope||t];var s=r&&r.indexOf(e);if(s>=0)r.splice(s,1)}}if(e.content)o(e);else if(Array.isArray(e))e.forEach(o)};e.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");var t=[],i={};var n=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;var o;while(o=n.exec(e)){if(o[1]){try{i=JSON.parse(o[1]);t.push(i)}catch(e){}}if(o[4]){i.content=o[4].replace(/^\t/gm,"");t.push(i);i={}}else{var r=o[2],s=o[3];if(r=="regex"){var a=/\/((?:[^\/\\]|\\.)*)|$/g;i.guard=a.exec(s)[1];i.trigger=a.exec(s)[1];i.endTrigger=a.exec(s)[1];i.endGuard=a.exec(s)[1]}else if(r=="snippet"){i.tabTrigger=s.match(/^\S*/)[0];if(!i.name)i.name=s}else if(r){i[r]=s}}}return t};e.prototype.getSnippetByName=function(e,t){var i=this.snippetNameMap;var n;this.getActiveScopes(t).some(function(t){var o=i[t];if(o)n=o[e];return!!n},this);return n};return e}();o.implement(f.prototype,r);var m=function(e,t,i){if(i===void 0){i={}}var n=e.getCursorPosition();var o=e.session.getLine(n.row);var r=e.session.getTabString();var s=o.match(/^\s*/)[0];if(n.column<s.length)s=s.slice(0,n.column);t=t.replace(/\r/g,"");var a=this.tokenizeTmSnippet(t);a=this.resolveVariables(a,e);a=a.map(function(e){if(e=="\n"&&!i.excludeExtraIndent)return e+s;if(typeof e=="string")return e.replace(/\t/g,r);return e});var l=[];a.forEach(function(e,t){if(typeof e!="object")return;var i=e.tabstopId;var n=l[i];if(!n){n=l[i]=[];n.index=i;n.value="";n.parents={}}if(n.indexOf(e)!==-1)return;if(e.choices&&!n.choices)n.choices=e.choices;n.push(e);var o=a.indexOf(e,t+1);if(o===-1)return;var r=a.slice(t+1,o);var s=r.some(function(e){return typeof e==="object"});if(s&&!n.value){n.value=r}else if(r.length&&(!n.value||typeof n.value!=="string")){n.value=r.join("")}});l.forEach(function(e){e.length=0});var c={};function p(e){var t=[];for(var i=0;i<e.length;i++){var n=e[i];if(typeof n=="object"){if(c[n.tabstopId])continue;var o=e.lastIndexOf(n,i-1);n=t[o]||{tabstopId:n.tabstopId}}t[i]=n}return t}for(var u=0;u<a.length;u++){var h=a[u];if(typeof h!="object")continue;var d=h.tabstopId;var f=l[d];var m=a.indexOf(h,u+1);if(c[d]){if(c[d]===h){delete c[d];Object.keys(c).forEach(function(e){f.parents[e]=true})}continue}c[d]=h;var g=f.value;if(typeof g!=="string")g=p(g);else if(h.fmt)g=this.tmStrFormat(g,h,e);a.splice.apply(a,[u+1,Math.max(0,m-u)].concat(g,h));if(f.indexOf(h)===-1)f.push(h)}var v=0,b=0;var y="";a.forEach(function(e){if(typeof e==="string"){var t=e.split("\n");if(t.length>1){b=t[t.length-1].length;v+=t.length-1}else b+=e.length;y+=e}else if(e){if(!e.start)e.start={row:v,column:b};else e.end={row:v,column:b}}});return{text:y,tabstops:l,tokens:a}};var g=function(){function e(e){this.index=0;this.ranges=[];this.tabstops=[];if(e.tabstopManager)return e.tabstopManager;e.tabstopManager=this;this.$onChange=this.onChange.bind(this);this.$onChangeSelection=s.delayedCall(this.onChangeSelection.bind(this)).schedule;this.$onChangeSession=this.onChangeSession.bind(this);this.$onAfterExec=this.onAfterExec.bind(this);this.attach(e)}e.prototype.attach=function(e){this.$openTabstops=null;this.selectedTabstop=null;this.editor=e;this.session=e.session;this.editor.on("change",this.$onChange);this.editor.on("changeSelection",this.$onChangeSelection);this.editor.on("changeSession",this.$onChangeSession);this.editor.commands.on("afterExec",this.$onAfterExec);this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)};e.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this);this.ranges.length=0;this.tabstops.length=0;this.selectedTabstop=null;this.editor.off("change",this.$onChange);this.editor.off("changeSelection",this.$onChangeSelection);this.editor.off("changeSession",this.$onChangeSession);this.editor.commands.off("afterExec",this.$onAfterExec);this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);this.editor.tabstopManager=null;this.session=null;this.editor=null};e.prototype.onChange=function(e){var t=e.action[0]=="r";var i=this.selectedTabstop||{};var n=i.parents||{};var o=this.tabstops.slice();for(var r=0;r<o.length;r++){var s=o[r];var a=s==i||n[s.index];s.rangeList.$bias=a?0:1;if(e.action=="remove"&&s!==i){var l=s.parents&&s.parents[i.index];var c=s.rangeList.pointIndex(e.start,l);c=c<0?-c-1:c+1;var p=s.rangeList.pointIndex(e.end,l);p=p<0?-p-1:p-1;var u=s.rangeList.ranges.slice(c,p);for(var h=0;h<u.length;h++)this.removeRange(u[h])}s.rangeList.$onChange(e)}var d=this.session;if(!this.$inChange&&t&&d.getLength()==1&&!d.getValue())this.detach()};e.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(!e||!e.hasLinkedRanges||!e.firstNonLinked)return;this.$inChange=true;var i=this.session;var n=i.getTextRange(e.firstNonLinked);for(var o=0;o<e.length;o++){var r=e[o];if(!r.linked)continue;var s=r.original;var a=t.snippetManager.tmStrFormat(n,s,this.editor);i.replace(r,a)}this.$inChange=false};e.prototype.onAfterExec=function(e){if(e.command&&!e.command.readOnly)this.updateLinkedFields()};e.prototype.onChangeSelection=function(){if(!this.editor)return;var e=this.editor.selection.lead;var t=this.editor.selection.anchor;var i=this.editor.selection.isEmpty();for(var n=0;n<this.ranges.length;n++){if(this.ranges[n].linked)continue;var o=this.ranges[n].contains(e.row,e.column);var r=i||this.ranges[n].contains(t.row,t.column);if(o&&r)return}this.detach()};e.prototype.onChangeSession=function(){this.detach()};e.prototype.tabNext=function(e){var t=this.tabstops.length;var i=this.index+(e||1);i=Math.min(Math.max(i,1),t);if(i==t)i=0;this.selectTabstop(i);this.updateTabstopMarkers();if(i===0){this.detach()}};e.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t)this.addTabstopMarkers(t);this.index=e;t=this.tabstops[this.index];if(!t||!t.length)return;this.selectedTabstop=t;var i=t.firstNonLinked||t;if(t.choices)i.cursor=i.start;if(!this.editor.inVirtualSelectionMode){var n=this.editor.multiSelect;n.toSingleRange(i);for(var o=0;o<t.length;o++){if(t.hasLinkedRanges&&t[o].linked)continue;n.addRange(t[o].clone(),true)}}else{this.editor.selection.fromOrientedRange(i)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler);if(this.selectedTabstop&&this.selectedTabstop.choices)this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})};e.prototype.addTabstops=function(e,t,i){var n=this.useLink||!this.editor.getOption("enableMultiselect");if(!this.$openTabstops)this.$openTabstops=[];if(!e[0]){var o=a.fromPoints(i,i);b(o.start,t);b(o.end,t);e[0]=[o];e[0].index=0}var r=this.index;var s=[r+1,0];var c=this.ranges;var p=this.snippetId=(this.snippetId||0)+1;e.forEach(function(e,i){var o=this.$openTabstops[i]||e;o.snippetId=p;for(var r=0;r<e.length;r++){var u=e[r];var h=a.fromPoints(u.start,u.end||u.start);v(h.start,t);v(h.end,t);h.original=u;h.tabstop=o;c.push(h);if(o!=e)o.unshift(h);else o[r]=h;if(u.fmtString||o.firstNonLinked&&n){h.linked=true;o.hasLinkedRanges=true}else if(!o.firstNonLinked)o.firstNonLinked=h}if(!o.firstNonLinked)o.hasLinkedRanges=false;if(o===e){s.push(o);this.$openTabstops[i]=o}this.addTabstopMarkers(o);o.rangeList=o.rangeList||new l;o.rangeList.$bias=0;o.rangeList.addList(o)},this);if(s.length>2){if(this.tabstops.length)s.push(s.splice(2,1)[0]);this.tabstops.splice.apply(this.tabstops,s)}};e.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){if(!e.markerId)e.markerId=t.addMarker(e,"ace_snippet-marker","text")})};e.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){t.removeMarker(e.markerId);e.markerId=null})};e.prototype.updateTabstopMarkers=function(){if(!this.selectedTabstop)return;var e=this.selectedTabstop.snippetId;if(this.selectedTabstop.index===0){e--}this.tabstops.forEach(function(t){if(t.snippetId===e)this.addTabstopMarkers(t);else this.removeTabstopMarkers(t)},this)};e.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);if(t!=-1)e.tabstop.splice(t,1);t=this.ranges.indexOf(e);if(t!=-1)this.ranges.splice(t,1);t=e.tabstop.rangeList.ranges.indexOf(e);if(t!=-1)e.tabstop.splice(t,1);this.session.removeMarker(e.markerId);if(!e.tabstop.length){t=this.tabstops.indexOf(e.tabstop);if(t!=-1)this.tabstops.splice(t,1);if(!this.tabstops.length)this.detach()}};return e}();g.prototype.keyboardHandler=new c;g.prototype.keyboardHandler.bindKeys({Tab:function(e){if(t.snippetManager&&t.snippetManager.expandWithTab(e))return;e.tabstopManager.tabNext(1);e.renderer.scrollCursorIntoView()},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1);e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var v=function(e,t){if(e.row==0)e.column+=t.column;e.row+=t.row};var b=function(e,t){if(e.row==t.row)e.column-=t.column;e.row-=t.row};n.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",false);t.snippetManager=new f;var y=e("./editor").Editor;(function(){this.insertSnippet=function(e,i){return t.snippetManager.insertSnippet(this,e,i)};this.expandSnippet=function(e){return t.snippetManager.expandWithTab(this,e)}}).call(y.prototype)});ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(e,t,i){"use strict";var n=function(){function e(e){this.editor=e;this.screenReaderDiv=document.createElement("div");this.screenReaderDiv.classList.add("ace_screenreader-only");this.editor.container.appendChild(this.screenReaderDiv)}e.prototype.setScreenReaderContent=function(e){if(!this.popup&&this.editor.completer&&this.editor.completer.popup){this.popup=this.editor.completer.popup;this.popup.renderer.on("afterRender",function(){var e=this.popup.getRow();var t=this.popup.renderer.$textLayer;var i=t.element.childNodes[e-t.config.firstRow];if(i){var n="doc-tooltip ";for(var o=0;o<this._lines.length;o++){n+="ace-inline-screenreader-line-".concat(o," ")}i.setAttribute("aria-describedby",n)}}.bind(this))}while(this.screenReaderDiv.firstChild){this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild)}this._lines=e.split(/\r\n|\r|\n/);var t=this.createCodeBlock();this.screenReaderDiv.appendChild(t)};e.prototype.destroy=function(){this.screenReaderDiv.remove()};e.prototype.createCodeBlock=function(){var e=document.createElement("pre");e.setAttribute("id","ace-inline-screenreader");for(var t=0;t<this._lines.length;t++){var i=document.createElement("code");i.setAttribute("id","ace-inline-screenreader-line-".concat(t));var n=document.createTextNode(this._lines[t]);i.appendChild(n);e.appendChild(i)}return e};return e}();t.AceInlineScreenReader=n});ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(e,t,i){"use strict";var n=e("../snippets").snippetManager;var o=e("./inline_screenreader").AceInlineScreenReader;var r=function(){function e(){this.editor=null}e.prototype.show=function(e,t,i){i=i||"";if(e&&this.editor&&this.editor!==e){this.hide();this.editor=null;this.inlineScreenReader=null}if(!e||!t){return false}if(!this.inlineScreenReader){this.inlineScreenReader=new o(e)}var r=t.snippet?n.getDisplayTextForSnippet(e,t.snippet):t.value;if(t.hideInlinePreview||!r||!r.startsWith(i)){return false}this.editor=e;this.inlineScreenReader.setScreenReaderContent(r);r=r.slice(i.length);if(r===""){e.removeGhostText()}else{e.setGhostText(r)}return true};e.prototype.isOpen=function(){if(!this.editor){return false}return!!this.editor.renderer.$ghostText};e.prototype.hide=function(){if(!this.editor){return false}this.editor.removeGhostText();return true};e.prototype.destroy=function(){this.hide();this.editor=null;if(this.inlineScreenReader){this.inlineScreenReader.destroy();this.inlineScreenReader=null}};return e}();t.AceInline=r});ace.define("ace/autocomplete/util",["require","exports","module"],function(e,t,i){"use strict";t.parForEach=function(e,t,i){var n=0;var o=e.length;if(o===0)i();for(var r=0;r<o;r++){t(e[r],function(e,t){n++;if(n===o)i(e,t)})}};var n=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;t.retrievePrecedingIdentifier=function(e,t,i){i=i||n;var o=[];for(var r=t-1;r>=0;r--){if(i.test(e[r]))o.push(e[r]);else break}return o.reverse().join("")};t.retrieveFollowingIdentifier=function(e,t,i){i=i||n;var o=[];for(var r=t;r<e.length;r++){if(i.test(e[r]))o.push(e[r]);else break}return o};t.getCompletionPrefix=function(e){var t=e.getCursorPosition();var i=e.session.getLine(t.row);var n;e.completers.forEach(function(e){if(e.identifierRegexps){e.identifierRegexps.forEach(function(e){if(!n&&e)n=this.retrievePrecedingIdentifier(i,t.column,e)}.bind(this))}}.bind(this));return n||this.retrievePrecedingIdentifier(i,t.column)};t.triggerAutocomplete=function(e,t){var t=t==null?e.session.getPrecedingCharacter():t;return e.completers.some(function(e){if(e.triggerCharacters&&Array.isArray(e.triggerCharacters)){return e.triggerCharacters.includes(t)}})}});ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event","ace/lib/scroll"],function(e,t,i){"use strict";var n=e("./keyboard/hash_handler").HashHandler;var o=e("./autocomplete/popup").AcePopup;var r=e("./autocomplete/inline").AceInline;var s=e("./autocomplete/popup").getAriaId;var a=e("./autocomplete/util");var l=e("./lib/lang");var c=e("./lib/dom");var p=e("./snippets").snippetManager;var u=e("./config");var h=e("./lib/event");var d=e("./lib/scroll").preventParentScroll;var f=function(e,t){t.completer&&t.completer.destroy()};var m=function(){function e(){this.autoInsert=false;this.autoSelect=true;this.autoShown=false;this.exactMatch=false;this.inlineEnabled=false;this.keyboardHandler=new n;this.keyboardHandler.bindKeys(this.commands);this.parentNode=null;this.setSelectOnHover=false;this.hasSeen=new Set;this.showLoadingState=false;this.stickySelectionDelay=500;this.blurListener=this.blurListener.bind(this);this.changeListener=this.changeListener.bind(this);this.mousedownListener=this.mousedownListener.bind(this);this.mousewheelListener=this.mousewheelListener.bind(this);this.onLayoutChange=this.onLayoutChange.bind(this);this.changeTimer=l.delayedCall(function(){this.updateCompletions(true)}.bind(this));this.tooltipTimer=l.delayedCall(this.updateDocTooltip.bind(this),50);this.popupTimer=l.delayedCall(this.$updatePopupPosition.bind(this),50);this.stickySelectionTimer=l.delayedCall(function(){this.stickySelection=true}.bind(this),this.stickySelectionDelay);this.$firstOpenTimer=l.delayedCall(function(){var t=this.completionProvider&&this.completionProvider.initialPosition;if(this.autoShown||this.popup&&this.popup.isOpen||!t||this.editor.completers.length===0)return;this.completions=new v(e.completionsForLoading);this.openPopup(this.editor,t.prefix,false);this.popup.renderer.setStyle("ace_loading",true)}.bind(this),this.stickySelectionDelay)}Object.defineProperty(e,"completionsForLoading",{get:function(){return[{caption:u.nls("autocomplete.loading","Loading..."),value:""}]},enumerable:false,configurable:true});e.prototype.$init=function(){this.popup=new o(this.parentNode||document.body||document.documentElement);this.popup.on("click",function(e){this.insertMatch();e.stop()}.bind(this));this.popup.focus=this.editor.focus.bind(this.editor);this.popup.on("show",this.$onPopupShow.bind(this));this.popup.on("hide",this.$onHidePopup.bind(this));this.popup.on("select",this.$onPopupChange.bind(this));h.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this));this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null));this.popup.renderer.on("afterRender",this.$onPopupRender.bind(this));return this.popup};e.prototype.$initInline=function(){if(!this.inlineEnabled||this.inlineRenderer)return;this.inlineRenderer=new r;return this.inlineRenderer};e.prototype.getPopup=function(){return this.popup||this.$init()};e.prototype.$onHidePopup=function(){if(this.inlineRenderer){this.inlineRenderer.hide()}this.hideDocTooltip();this.stickySelectionTimer.cancel();this.popupTimer.cancel();this.stickySelection=false};e.prototype.$seen=function(e){if(!this.hasSeen.has(e)&&e&&e.completer&&e.completer.onSeen&&typeof e.completer.onSeen==="function"){e.completer.onSeen(this.editor,e);this.hasSeen.add(e)}};e.prototype.$onPopupChange=function(e){if(this.inlineRenderer&&this.inlineEnabled){var t=e?null:this.popup.getData(this.popup.getRow());this.$updateGhostText(t);if(this.popup.isMouseOver&&this.setSelectOnHover){this.tooltipTimer.call(null,null);return}this.popupTimer.schedule();this.tooltipTimer.schedule()}else{this.popupTimer.call(null,null);this.tooltipTimer.call(null,null)}};e.prototype.$updateGhostText=function(e){var t=this.base.row;var i=this.base.column;var n=this.editor.getCursorPosition().column;var o=this.editor.session.getLine(t).slice(i,n);if(!this.inlineRenderer.show(this.editor,e,o)){this.inlineRenderer.hide()}else{this.$seen(e)}};e.prototype.$onPopupRender=function(){var e=this.inlineRenderer&&this.inlineEnabled;if(this.completions&&this.completions.filtered&&this.completions.filtered.length>0){for(var t=this.popup.getFirstVisibleRow();t<=this.popup.getLastVisibleRow();t++){var i=this.popup.getData(t);if(i&&(!e||i.hideInlinePreview)){this.$seen(i)}}}};e.prototype.$onPopupShow=function(e){this.$onPopupChange(e);this.stickySelection=false;if(this.stickySelectionDelay>=0)this.stickySelectionTimer.schedule(this.stickySelectionDelay)};e.prototype.observeLayoutChanges=function(){if(this.$elements||!this.editor)return;window.addEventListener("resize",this.onLayoutChange,{passive:true});window.addEventListener("wheel",this.mousewheelListener);var e=this.editor.container.parentNode;var t=[];while(e){t.push(e);e.addEventListener("scroll",this.onLayoutChange,{passive:true});e=e.parentNode}this.$elements=t};e.prototype.unObserveLayoutChanges=function(){var e=this;window.removeEventListener("resize",this.onLayoutChange,{passive:true});window.removeEventListener("wheel",this.mousewheelListener);this.$elements&&this.$elements.forEach(function(t){t.removeEventListener("scroll",e.onLayoutChange,{passive:true})});this.$elements=null};e.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition();this.updateDocTooltip()};e.prototype.$updatePopupPosition=function(){var e=this.editor;var t=e.renderer;var i=t.layerConfig.lineHeight;var n=t.$cursorLayer.getPixelPosition(this.base,true);n.left-=this.popup.getTextLeftOffset();var o=e.container.getBoundingClientRect();n.top+=o.top-t.layerConfig.offset;n.left+=o.left-e.renderer.scrollLeft;n.left+=t.gutterWidth;var r={top:n.top,left:n.left};if(t.$ghostText&&t.$ghostTextWidget){if(this.base.row===t.$ghostText.position.row){r.top+=t.$ghostTextWidget.el.offsetHeight}}var s=e.container.getBoundingClientRect().bottom-i;var a=s<r.top?{top:s,left:r.left}:r;if(this.popup.tryShow(a,i,"bottom")){return}if(this.popup.tryShow(n,i,"top")){return}this.popup.show(n,i)};e.prototype.openPopup=function(e,t,i){this.$firstOpenTimer.cancel();if(!this.popup)this.$init();if(this.inlineEnabled&&!this.inlineRenderer)this.$initInline();this.popup.autoSelect=this.autoSelect;this.popup.setSelectOnHover(this.setSelectOnHover);var n=this.popup.getRow();var o=this.popup.data[n];this.popup.setData(this.completions.filtered,this.completions.filterText);if(this.editor.textInput.setAriaOptions){this.editor.textInput.setAriaOptions({activeDescendant:s(this.popup.getRow()),inline:this.inlineEnabled})}e.keyBinding.addKeyboardHandler(this.keyboardHandler);var r;if(this.stickySelection)r=this.popup.data.indexOf(o);if(!r||r===-1)r=0;this.popup.setRow(this.autoSelect?r:-1);if(r===n&&o!==this.completions.filtered[r])this.$onPopupChange();var a=this.inlineRenderer&&this.inlineEnabled;if(r===n&&a){var l=this.popup.getData(this.popup.getRow());this.$updateGhostText(l)}if(!i){this.popup.setTheme(e.getTheme());this.popup.setFontSize(e.getFontSize());this.$updatePopupPosition();if(this.tooltipNode){this.updateDocTooltip()}}this.changeTimer.cancel();this.observeLayoutChanges()};e.prototype.detach=function(){if(this.editor){this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);this.editor.off("changeSelection",this.changeListener);this.editor.off("blur",this.blurListener);this.editor.off("mousedown",this.mousedownListener);this.editor.off("mousewheel",this.mousewheelListener)}this.$firstOpenTimer.cancel();this.changeTimer.cancel();this.hideDocTooltip();if(this.completionProvider){this.completionProvider.detach()}if(this.popup&&this.popup.isOpen)this.popup.hide();if(this.popup&&this.popup.renderer){this.popup.renderer.off("afterRender",this.$onPopupRender)}if(this.base)this.base.detach();this.activated=false;this.completionProvider=this.completions=this.base=null;this.unObserveLayoutChanges()};e.prototype.changeListener=function(e){var t=this.editor.selection.lead;if(t.row!=this.base.row||t.column<this.base.column){this.detach()}if(this.activated)this.changeTimer.schedule();else this.detach()};e.prototype.blurListener=function(e){var t=document.activeElement;var i=this.editor.textInput.getElement();var n=e.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(e.relatedTarget);var o=this.popup&&this.popup.container;if(t!=i&&t.parentNode!=o&&!n&&t!=this.tooltipNode&&e.relatedTarget!=i){this.detach()}};e.prototype.mousedownListener=function(e){this.detach()};e.prototype.mousewheelListener=function(e){if(this.popup&&!this.popup.isMouseOver)this.detach()};e.prototype.mouseOutListener=function(e){if(this.popup.isOpen)this.$updatePopupPosition()};e.prototype.goTo=function(e){this.popup.goTo(e)};e.prototype.insertMatch=function(e,t){if(!e)e=this.popup.getData(this.popup.getRow());if(!e)return false;if(e.value==="")return this.detach();var i=this.completions;var n=this.getCompletionProvider().insertMatch(this.editor,e,i.filterText,t);if(this.completions==i)this.detach();return n};e.prototype.showPopup=function(e,t){if(this.editor)this.detach();this.activated=true;this.editor=e;if(e.completer!=this){if(e.completer)e.completer.detach();e.completer=this}e.on("changeSelection",this.changeListener);e.on("blur",this.blurListener);e.on("mousedown",this.mousedownListener);e.on("mousewheel",this.mousewheelListener);this.updateCompletions(false,t)};e.prototype.getCompletionProvider=function(e){if(!this.completionProvider)this.completionProvider=new g(e);return this.completionProvider};e.prototype.gatherCompletions=function(e,t){return this.getCompletionProvider().gatherCompletions(e,t)};e.prototype.updateCompletions=function(t,i){if(t&&this.base&&this.completions){var n=this.editor.getCursorPosition();var o=this.editor.session.getTextRange({start:this.base,end:n});if(o==this.completions.filterText)return;this.completions.setFilter(o);if(!this.completions.filtered.length)return this.detach();if(this.completions.filtered.length==1&&this.completions.filtered[0].value==o&&!this.completions.filtered[0].snippet)return this.detach();this.openPopup(this.editor,o,t);return}if(i&&i.matches){var n=this.editor.getSelectionRange().start;this.base=this.editor.session.doc.createAnchor(n.row,n.column);this.base.$insertRight=true;this.completions=new v(i.matches);this.getCompletionProvider().completions=this.completions;return this.openPopup(this.editor,"",t)}var r=this.editor.getSession();var n=this.editor.getCursorPosition();var o=a.getCompletionPrefix(this.editor);this.base=r.doc.createAnchor(n.row,n.column-o.length);this.base.$insertRight=true;var s={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:o,pos:n}).provideCompletions(this.editor,s,function(i,n,o){var r=n.filtered;var s=a.getCompletionPrefix(this.editor);this.$firstOpenTimer.cancel();if(o){if(!r.length){var l=!this.autoShown&&this.emptyMessage;if(typeof l=="function")l=this.emptyMessage(s);if(l){var c=[{caption:l,value:""}];this.completions=new v(c);this.openPopup(this.editor,s,t);this.popup.renderer.setStyle("ace_loading",false);this.popup.renderer.setStyle("ace_empty-message",true);return}return this.detach()}if(r.length==1&&r[0].value==s&&!r[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&r.length==1)return this.insertMatch(r[0])}this.completions=!o&&this.showLoadingState?new v(e.completionsForLoading.concat(r),n.filterText):n;this.openPopup(this.editor,s,t);this.popup.renderer.setStyle("ace_empty-message",false);this.popup.renderer.setStyle("ace_loading",!o)}.bind(this));if(this.showLoadingState&&!this.autoShown&&!(this.popup&&this.popup.isOpen)){this.$firstOpenTimer.delay(this.stickySelectionDelay/2)}};e.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()};e.prototype.updateDocTooltip=function(){var e=this.popup;var t=this.completions.filtered;var i=t&&(t[e.getHoveredRow()]||t[e.getRow()]);var n=null;if(!i||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();var o=this.editor.completers.length;for(var r=0;r<o;r++){var s=this.editor.completers[r];if(s.getDocTooltip&&i.completerId===s.id){n=s.getDocTooltip(i);break}}if(!n&&typeof i!="string")n=i;if(typeof n=="string")n={docText:n};if(!n||!(n.docHTML||n.docText))return this.hideDocTooltip();this.showDocTooltip(n)};e.prototype.showDocTooltip=function(e){if(!this.tooltipNode){this.tooltipNode=c.createElement("div");this.tooltipNode.style.margin="0";this.tooltipNode.style.pointerEvents="auto";this.tooltipNode.style.overscrollBehavior="contain";this.tooltipNode.tabIndex=-1;this.tooltipNode.onblur=this.blurListener.bind(this);this.tooltipNode.onclick=this.onTooltipClick.bind(this);this.tooltipNode.id="doc-tooltip";this.tooltipNode.setAttribute("role","tooltip");this.tooltipNode.addEventListener("wheel",d)}var t=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(t.isDark?"ace_dark ":"")+(t.cssClass||"");var i=this.tooltipNode;if(e.docHTML){i.innerHTML=e.docHTML}else if(e.docText){i.textContent=e.docText}if(!i.parentNode)this.popup.container.appendChild(this.tooltipNode);var n=this.popup;var o=n.container.getBoundingClientRect();i.style.top=n.container.style.top;i.style.bottom=n.container.style.bottom;i.style.display="block";if(window.innerWidth-o.right<320){if(o.left<320){if(n.isTopdown){i.style.top=o.bottom+"px";i.style.left=o.left+"px";i.style.right="";i.style.bottom=""}else{i.style.top=n.container.offsetTop-i.offsetHeight+"px";i.style.left=o.left+"px";i.style.right="";i.style.bottom=""}}else{i.style.right=window.innerWidth-o.left+"px";i.style.left=""}}else{i.style.left=o.right+1+"px";i.style.right=""}};e.prototype.hideDocTooltip=function(){this.tooltipTimer.cancel();if(!this.tooltipNode)return;var e=this.tooltipNode;if(!this.editor.isFocused()&&document.activeElement==e)this.editor.focus();this.tooltipNode=null;if(e.parentNode)e.parentNode.removeChild(e)};e.prototype.onTooltipClick=function(e){var t=e.target;while(t&&t!=this.tooltipNode){if(t.nodeName=="A"&&t.href){t.rel="noreferrer";t.target="_blank";break}t=t.parentNode}};e.prototype.destroy=function(){this.detach();if(this.popup){this.popup.destroy();var e=this.popup.container;if(e&&e.parentNode)e.parentNode.removeChild(e)}if(this.editor&&this.editor.completer==this){this.editor.off("destroy",f);this.editor.completer=null}this.inlineRenderer=this.popup=this.editor=null};e.for=function(t){if(t.completer instanceof e){return t.completer}if(t.completer){t.completer.destroy();t.completer=null}if(u.get("sharedPopups")){if(!e["$sharedInstance"])e["$sharedInstance"]=new e;t.completer=e["$sharedInstance"]}else{t.completer=new e;t.once("destroy",f)}return t.completer};return e}();m.prototype.commands={Up:function(e){e.completer.goTo("up")},Down:function(e){e.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(e){e.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(e){e.completer.goTo("end")},Esc:function(e){e.completer.detach()},Return:function(e){return e.completer.insertMatch()},"Shift-Return":function(e){e.completer.insertMatch(null,{deleteSuffix:true})},Tab:function(e){var t=e.completer.insertMatch();if(!t&&!e.tabstopManager)e.completer.goTo("down");else return t},Backspace:function(e){e.execCommand("backspace");var t=a.getCompletionPrefix(e);if(!t&&e.completer)e.completer.detach()},PageUp:function(e){e.completer.popup.gotoPageUp()},PageDown:function(e){e.completer.popup.gotoPageDown()}};m.startCommand={name:"startAutocomplete",exec:function(e,t){var i=m.for(e);i.autoInsert=false;i.autoSelect=true;i.autoShown=false;i.showPopup(e,t);i.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var g=function(){function e(e){this.initialPosition=e;this.active=true}e.prototype.insertByIndex=function(e,t,i){if(!this.completions||!this.completions.filtered){return false}return this.insertMatch(e,this.completions.filtered[t],i)};e.prototype.insertMatch=function(e,t,i){if(!t)return false;e.startOperation({command:{name:"insertMatch"}});if(t.completer&&t.completer.insertMatch){t.completer.insertMatch(e,t)}else{if(!this.completions)return false;var n=this.completions.filterText.length;var o=0;if(t.range&&t.range.start.row===t.range.end.row){n-=this.initialPosition.prefix.length;n+=this.initialPosition.pos.column-t.range.start.column;o+=t.range.end.column-this.initialPosition.pos.column}if(n||o){var r;if(e.selection.getAllRanges){r=e.selection.getAllRanges()}else{r=[e.getSelectionRange()]}for(var s=0,a;a=r[s];s++){a.start.column-=n;a.end.column+=o;e.session.remove(a)}}if(t.snippet){p.insertSnippet(e,t.snippet)}else{this.$insertString(e,t)}if(t.completer&&t.completer.onInsert&&typeof t.completer.onInsert=="function"){t.completer.onInsert(e,t)}if(t.command&&t.command==="startAutocomplete"){e.execCommand(t.command)}}e.endOperation();return true};e.prototype.$insertString=function(e,t){var i=t.value||t;e.execCommand("insertstring",i)};e.prototype.gatherCompletions=function(e,t){var i=e.getSession();var n=e.getCursorPosition();var o=a.getCompletionPrefix(e);var r=[];this.completers=e.completers;var s=e.completers.length;e.completers.forEach(function(l,c){l.getCompletions(e,i,n,o,function(i,n){if(l.hideInlinePreview)n=n.map(function(e){return Object.assign(e,{hideInlinePreview:l.hideInlinePreview})});if(!i&&n)r=r.concat(n);t(null,{prefix:a.getCompletionPrefix(e),matches:r,finished:--s===0})})});return true};e.prototype.provideCompletions=function(e,t,i){var n=function(e){var n=e.prefix;var o=e.matches;this.completions=new v(o);if(t.exactMatch)this.completions.exactMatch=true;if(t.ignoreCaption)this.completions.ignoreCaption=true;this.completions.setFilter(n);if(e.finished||this.completions.filtered.length)i(null,this.completions,e.finished)}.bind(this);var o=true;var r=null;this.gatherCompletions(e,function(e,t){if(!this.active){return}if(e){i(e,[],true);this.detach()}var s=t.prefix;if(s.indexOf(t.prefix)!==0)return;if(o){r=t;return}n(t)}.bind(this));o=false;if(r){var s=r;r=null;n(s)}};e.prototype.detach=function(){this.active=false;this.completers&&this.completers.forEach(function(e){if(typeof e.cancel==="function"){e.cancel()}})};return e}();var v=function(){function e(e,t){this.all=e;this.filtered=e;this.filterText=t||"";this.exactMatch=false;this.ignoreCaption=false}e.prototype.setFilter=function(e){if(e.length>this.filterText&&e.lastIndexOf(this.filterText,0)===0)var t=this.filtered;else var t=this.all;this.filterText=e;t=this.filterCompletions(t,this.filterText);t=t.sort(function(e,t){return t.exactMatch-e.exactMatch||t.$score-e.$score||(e.caption||e.value).localeCompare(t.caption||t.value)});var i=null;t=t.filter(function(e){var t=e.snippet||e.caption||e.value;if(t===i)return false;i=t;return true});this.filtered=t};e.prototype.filterCompletions=function(e,t){var i=[];var n=t.toUpperCase();var o=t.toLowerCase();e:for(var r=0,s;s=e[r];r++){var a=!this.ignoreCaption&&s.caption||s.value||s.snippet;if(!a)continue;var l=-1;var c=0;var p=0;var u,h;if(this.exactMatch){if(t!==a.substr(0,t.length))continue e}else{var d=a.toLowerCase().indexOf(o);if(d>-1){p=d}else{for(var f=0;f<t.length;f++){var m=a.indexOf(o[f],l+1);var g=a.indexOf(n[f],l+1);u=m>=0?g<0||m<g?m:g:g;if(u<0)continue e;h=u-l-1;if(h>0){if(l===-1)p+=10;p+=h;c=c|1<<f}l=u}}}s.matchMask=c;s.exactMatch=p?0:1;s.$score=(s.score||0)-p;i.push(s)}return i};return e}();t.Autocomplete=m;t.CompletionProvider=g;t.FilteredList=v});ace.define("ace/ext/menu_tools/settings_menu.css",["require","exports","module"],function(e,t,i){i.exports="#ace_settingsmenu, #kbshortcutmenu {\n    background-color: #F7F7F7;\n    color: black;\n    box-shadow: -5px 4px 5px rgba(126, 126, 126, 0.55);\n    padding: 1em 0.5em 2em 1em;\n    overflow: auto;\n    position: absolute;\n    margin: 0;\n    bottom: 0;\n    right: 0;\n    top: 0;\n    z-index: 9991;\n    cursor: default;\n}\n\n.ace_dark #ace_settingsmenu, .ace_dark #kbshortcutmenu {\n    box-shadow: -20px 10px 25px rgba(126, 126, 126, 0.25);\n    background-color: rgba(255, 255, 255, 0.6);\n    color: black;\n}\n\n.ace_optionsMenuEntry:hover {\n    background-color: rgba(100, 100, 100, 0.1);\n    transition: all 0.3s\n}\n\n.ace_closeButton {\n    background: rgba(245, 146, 146, 0.5);\n    border: 1px solid #F48A8A;\n    border-radius: 50%;\n    padding: 7px;\n    position: absolute;\n    right: -8px;\n    top: -8px;\n    z-index: 100000;\n}\n.ace_closeButton{\n    background: rgba(245, 146, 146, 0.9);\n}\n.ace_optionsMenuKey {\n    color: darkslateblue;\n    font-weight: bold;\n}\n.ace_optionsMenuCommand {\n    color: darkcyan;\n    font-weight: normal;\n}\n.ace_optionsMenuEntry input, .ace_optionsMenuEntry button {\n    vertical-align: middle;\n}\n\n.ace_optionsMenuEntry button[ace_selected_button=true] {\n    background: #e7e7e7;\n    box-shadow: 1px 0px 2px 0px #adadad inset;\n    border-color: #adadad;\n}\n.ace_optionsMenuEntry button {\n    background: white;\n    border: 1px solid lightgray;\n    margin: 0px;\n}\n.ace_optionsMenuEntry button:hover{\n    background: #f0f0f0;\n}"});ace.define("ace/ext/menu_tools/overlay_page",["require","exports","module","ace/lib/dom","ace/ext/menu_tools/settings_menu.css"],function(e,t,i){"use strict";var n=e("../../lib/dom");var o=e("./settings_menu.css");n.importCssString(o,"settings_menu.css",false);i.exports.overlayPage=function e(t,i,n){var o=document.createElement("div");var r=false;function s(e){if(e.keyCode===27){a()}}function a(){if(!o)return;document.removeEventListener("keydown",s);o.parentNode.removeChild(o);if(t){t.focus()}o=null;n&&n()}function l(e){r=e;if(e){o.style.pointerEvents="none";i.style.pointerEvents="auto"}}o.style.cssText="margin: 0; padding: 0; "+"position: fixed; top:0; bottom:0; left:0; right:0;"+"z-index: 9990; "+(t?"background-color: rgba(0, 0, 0, 0.3);":"");o.addEventListener("click",function(e){if(!r){a()}});document.addEventListener("keydown",s);i.addEventListener("click",function(e){e.stopPropagation()});o.appendChild(i);document.body.appendChild(o);if(t){t.blur()}return{close:a,setIgnoreFocusOut:l}}});ace.define("ace/ext/modelist",["require","exports","module"],function(e,t,i){"use strict";var n=[];function o(e){var t=l.text;var i=e.split(/[\/\\]/).pop();for(var o=0;o<n.length;o++){if(n[o].supportsFile(i)){t=n[o];break}}return t}var r=function(){function e(e,t,i){this.name=e;this.caption=t;this.mode="ace/mode/"+e;this.extensions=i;var n;if(/\^/.test(i)){n=i.replace(/\|(\^)?/g,function(e,t){return"$|"+(t?"^":"^.*\\.")})+"$"}else{n="^.*\\.("+i+")$"}this.extRe=new RegExp(n,"gi")}e.prototype.supportsFile=function(e){return e.match(this.extRe)};return e}();var s={ABAP:["abap"],ABC:["abc"],ActionScript:["as"],ADA:["ada|adb"],Alda:["alda"],Apache_Conf:["^htaccess|^htgroups|^htpasswd|^conf|htaccess|htgroups|htpasswd"],Apex:["apex|cls|trigger|tgr"],AQL:["aql"],AsciiDoc:["asciidoc|adoc"],ASL:["dsl|asl|asl.json"],Assembly_ARM32:["s"],Assembly_x86:["asm|a"],Astro:["astro"],AutoHotKey:["ahk"],BatchFile:["bat|cmd"],Basic:["bas|bak"],BibTeX:["bib"],C_Cpp:["cpp|c|cc|cxx|h|hh|hpp|ino"],C9Search:["c9search_results"],Cirru:["cirru|cr"],Clojure:["clj|cljs"],Cobol:["CBL|COB"],coffee:["coffee|cf|cson|^Cakefile"],ColdFusion:["cfm|cfc"],Crystal:["cr"],CSharp:["cs"],Csound_Document:["csd"],Csound_Orchestra:["orc"],Csound_Score:["sco"],CSS:["css"],Curly:["curly"],Cuttlefish:["conf"],D:["d|di"],Dart:["dart"],Diff:["diff|patch"],Django:["djt|html.djt|dj.html|djhtml"],Dockerfile:["^Dockerfile"],Dot:["dot"],Drools:["drl"],Edifact:["edi"],Eiffel:["e|ge"],EJS:["ejs"],Elixir:["ex|exs"],Elm:["elm"],Erlang:["erl|hrl"],Flix:["flix"],Forth:["frt|fs|ldr|fth|4th"],Fortran:["f|f90"],FSharp:["fsi|fs|ml|mli|fsx|fsscript"],FSL:["fsl"],FTL:["ftl"],Gcode:["gcode"],Gherkin:["feature"],Gitignore:["^.gitignore"],Glsl:["glsl|frag|vert"],Gobstones:["gbs"],golang:["go"],GraphQLSchema:["gql"],Groovy:["groovy"],HAML:["haml"],Handlebars:["hbs|handlebars|tpl|mustache"],Haskell:["hs"],Haskell_Cabal:["cabal"],haXe:["hx"],Hjson:["hjson"],HTML:["html|htm|xhtml|we|wpy"],HTML_Elixir:["eex|html.eex"],HTML_Ruby:["erb|rhtml|html.erb"],INI:["ini|conf|cfg|prefs"],Io:["io"],Ion:["ion"],Jack:["jack"],Jade:["jade|pug"],Java:["java"],JavaScript:["js|jsm|cjs|mjs"],JEXL:["jexl"],JSON:["json"],JSON5:["json5"],JSONiq:["jq"],JSP:["jsp"],JSSM:["jssm|jssm_state"],JSX:["jsx"],Julia:["jl"],Kotlin:["kt|kts"],LaTeX:["tex|latex|ltx|bib"],Latte:["latte"],LESS:["less"],Liquid:["liquid"],Lisp:["lisp"],LiveScript:["ls"],Log:["log"],LogiQL:["logic|lql"],Logtalk:["lgt"],LSL:["lsl"],Lua:["lua"],LuaPage:["lp"],Lucene:["lucene"],Makefile:["^Makefile|^GNUmakefile|^makefile|^OCamlMakefile|make"],Markdown:["md|markdown"],Mask:["mask"],MATLAB:["matlab"],Maze:["mz"],MediaWiki:["wiki|mediawiki"],MEL:["mel"],MIPS:["s|asm"],MIXAL:["mixal"],MUSHCode:["mc|mush"],MySQL:["mysql"],Nasal:["nas"],Nginx:["nginx|conf"],Nim:["nim"],Nix:["nix"],NSIS:["nsi|nsh"],Nunjucks:["nunjucks|nunjs|nj|njk"],ObjectiveC:["m|mm"],OCaml:["ml|mli"],Odin:["odin"],PartiQL:["partiql|pql"],Pascal:["pas|p"],Perl:["pl|pm"],pgSQL:["pgsql"],PHP:["php|inc|phtml|shtml|php3|php4|php5|phps|phpt|aw|ctp|module"],PHP_Laravel_blade:["blade.php"],Pig:["pig"],PLSQL:["plsql"],Powershell:["ps1"],Praat:["praat|praatscript|psc|proc"],Prisma:["prisma"],Prolog:["plg|prolog"],Properties:["properties"],Protobuf:["proto"],PRQL:["prql"],Puppet:["epp|pp"],Python:["py"],QML:["qml"],R:["r"],Raku:["raku|rakumod|rakutest|p6|pl6|pm6"],Razor:["cshtml|asp"],RDoc:["Rd"],Red:["red|reds"],RHTML:["Rhtml"],Robot:["robot|resource"],RST:["rst"],Ruby:["rb|ru|gemspec|rake|^Guardfile|^Rakefile|^Gemfile"],Rust:["rs"],SaC:["sac"],SASS:["sass"],SCAD:["scad"],Scala:["scala|sbt"],Scheme:["scm|sm|rkt|oak|scheme"],Scrypt:["scrypt"],SCSS:["scss"],SH:["sh|bash|^.bashrc"],SJS:["sjs"],Slim:["slim|skim"],Smarty:["smarty|tpl"],Smithy:["smithy"],snippets:["snippets"],Soy_Template:["soy"],Space:["space"],SPARQL:["rq"],SQL:["sql"],SQLServer:["sqlserver"],Stylus:["styl|stylus"],SVG:["svg"],Swift:["swift"],Tcl:["tcl"],Terraform:["tf","tfvars","terragrunt"],Tex:["tex"],Text:["txt"],Textile:["textile"],Toml:["toml"],TSX:["tsx"],Turtle:["ttl"],Twig:["twig|swig"],Typescript:["ts|mts|cts|typescript|str"],Vala:["vala"],VBScript:["vbs|vb"],Velocity:["vm"],Verilog:["v|vh|sv|svh"],VHDL:["vhd|vhdl"],Visualforce:["vfp|component|page"],Vue:["vue"],Wollok:["wlk|wpgm|wtest"],XML:["xml|rdf|rss|wsdl|xslt|atom|mathml|mml|xul|xbl|xaml"],XQuery:["xq"],YAML:["yaml|yml"],Zeek:["zeek|bro"],Zig:["zig"]};var a={ObjectiveC:"Objective-C",CSharp:"C#",golang:"Go",C_Cpp:"C and C++",Csound_Document:"Csound Document",Csound_Orchestra:"Csound",Csound_Score:"Csound Score",coffee:"CoffeeScript",HTML_Ruby:"HTML (Ruby)",HTML_Elixir:"HTML (Elixir)",FTL:"FreeMarker",PHP_Laravel_blade:"PHP (Blade Template)",Perl6:"Perl 6",AutoHotKey:"AutoHotkey / AutoIt"};var l={};for(var c in s){var p=s[c];var u=(a[c]||c).replace(/_/g," ");var h=c.toLowerCase();var d=new r(h,u,p[0]);l[h]=d;n.push(d)}i.exports={getModeForPath:o,modes:n,modesByName:l}});ace.define("ace/ext/prompt",["require","exports","module","ace/config","ace/range","ace/lib/dom","ace/autocomplete","ace/autocomplete/popup","ace/autocomplete/popup","ace/undomanager","ace/tokenizer","ace/ext/menu_tools/overlay_page","ace/ext/modelist"],function(e,t,i){"use strict";var n=e("../config").nls;var o=e("../range").Range;var r=e("../lib/dom");var s=e("../autocomplete").FilteredList;var a=e("../autocomplete/popup").AcePopup;var l=e("../autocomplete/popup").$singleLineEditor;var c=e("../undomanager").UndoManager;var p=e("../tokenizer").Tokenizer;var u=e("./menu_tools/overlay_page").overlayPage;var h=e("./modelist");var d;function f(e,t,i,n){if(typeof t=="object"){return f(e,"",t,i)}if(d){var o=d;e=o.editor;o.close();if(o.name&&o.name==i.name)return}if(i.$type)return f[i.$type](e,n);var s=l();s.session.setUndoManager(new c);var h=r.buildDom(["div",{class:"ace_prompt_container"+(i.hasDescription?" input-box-with-description":"")}]);var m=u(e,h,S);h.appendChild(s.container);if(e){e.cmdLine=s;s.setOption("fontSize",e.getOption("fontSize"))}if(t){s.setValue(t,1)}if(i.selection){s.selection.setRange({start:s.session.doc.indexToPosition(i.selection[0]),end:s.session.doc.indexToPosition(i.selection[1])})}if(i.getCompletions){var g=new a;g.renderer.setStyle("ace_autocomplete_inline");g.container.style.display="block";g.container.style.maxWidth="600px";g.container.style.width="100%";g.container.style.marginTop="3px";g.renderer.setScrollMargin(2,2,0,0);g.autoSelect=false;g.renderer.$maxLines=15;g.setRow(-1);g.on("click",function(e){var t=g.getData(g.getRow());if(!t["error"]){s.setValue(t.value||t["name"]||t);y();e.stop()}});h.appendChild(g.container);w()}if(i.$rules){var v=new p(i.$rules);s.session.bgTokenizer.setTokenizer(v)}if(i.placeholder){s.setOption("placeholder",i.placeholder)}if(i.hasDescription){var b=r.buildDom(["div",{class:"ace_prompt_text_container"}]);r.buildDom(i.prompt||"Press 'Enter' to confirm or 'Escape' to cancel",b);h.appendChild(b)}m.setIgnoreFocusOut(i.ignoreFocusOut);function y(){var e;if(g&&g.getCursorPosition().row>0){e=C()}else{e=s.getValue()}var t=g?g.getData(g.getRow()):e;if(t&&!t["error"]){S();i.onAccept&&i.onAccept({value:e,item:t},s)}}var x={Enter:y,"Esc|Shift-Esc":function(){i.onCancel&&i.onCancel(s.getValue(),s);S()}};if(g){Object.assign(x,{Up:function(e){g.goTo("up");C()},Down:function(e){g.goTo("down");C()},"Ctrl-Up|Ctrl-Home":function(e){g.goTo("start");C()},"Ctrl-Down|Ctrl-End":function(e){g.goTo("end");C()},Tab:function(e){g.goTo("down");C()},PageUp:function(e){g.gotoPageUp();C()},PageDown:function(e){g.gotoPageDown();C()}})}s.commands.bindKeys(x);function S(){m.close();n&&n();d=null}s.on("input",function(){i.onInput&&i.onInput();w()});function w(){if(i.getCompletions){var e;if(i.getPrefix){e=i.getPrefix(s)}var t=i.getCompletions(s);g.setData(t,e);g.resize(true)}}function C(){var e=g.getData(g.getRow());if(e&&!e["error"])return e.value||e.caption||e}s.resize(true);if(g){g.resize(true)}s.focus();d={close:S,name:i.name,editor:e}}f.gotoLine=function(e,t){function i(e){if(!Array.isArray(e))e=[e];return e.map(function(e){var t=e.isBackwards?e.start:e.end;var i=e.isBackwards?e.end:e.start;var n=i.row;var o=n+1+":"+i.column;if(i.row==t.row){if(i.column!=t.column)o+=">"+":"+t.column}else{o+=">"+(t.row+1)+":"+t.column}return o}).reverse().join(", ")}f(e,":"+i(e.selection.toJSON()),{name:"gotoLine",selection:[1,Number.MAX_VALUE],onAccept:function(t){var i=t.value;var n=f.gotoLine["_history"];if(!n)f.gotoLine["_history"]=n=[];if(n.indexOf(i)!=-1)n.splice(n.indexOf(i),1);n.unshift(i);if(n.length>20)n.length=20;var r=e.getCursorPosition();var s=[];i.replace(/^:/,"").split(/,/).map(function(t){var i=t.split(/([<>:+-]|c?\d+)|[^c\d<>:+-]+/).filter(Boolean);var n=0;function a(){var t=i[n++];if(!t)return;if(t[0]=="c"){var o=parseInt(t.slice(1))||0;return e.session.doc.indexToPosition(o)}var s=r.row;var a=0;if(/\d/.test(t)){s=parseInt(t)-1;t=i[n++]}if(t==":"){t=i[n++];if(/\d/.test(t)){a=parseInt(t)||0}}return{row:s,column:a}}r=a();var l=o.fromPoints(r,r);if(i[n]==">"){n++;l.end=a()}else if(i[n]=="<"){n++;l.start=a()}s.unshift(l)});e.selection.fromJSON(s);var a=e.renderer.scrollTop;e.renderer.scrollSelectionIntoView(e.selection.anchor,e.selection.cursor,.5);e.renderer.animateScrolling(a)},history:function(){if(!f.gotoLine["_history"])return[];return f.gotoLine["_history"]},getCompletions:function(t){var i=t.getValue();var n=i.replace(/^:/,"").split(":");var o=Math.min(parseInt(n[0])||1,e.session.getLength())-1;var r=e.session.getLine(o);var s=i+"  "+r;return[s].concat(this.history())},$rules:{start:[{regex:/\d+/,token:"string"},{regex:/[:,><+\-c]/,token:"keyword"}]}})};f.commands=function(e,t){function i(e){return(e||"").replace(/^./,function(e){return e.toUpperCase(e)}).replace(/[a-z][A-Z]/g,function(e){return e[0]+" "+e[1].toLowerCase(e)})}function o(t){var n=[];var o={};e.keyBinding.$handlers.forEach(function(e){var r=e["platform"];var s=e["byName"];for(var a in s){var l=s[a].bindKey;if(typeof l!=="string"){l=l&&l[r]||""}var c=s[a];var p=c.description||i(c.name);if(!Array.isArray(c))c=[c];c.forEach(function(e){if(typeof e!="string")e=e.name;var i=t.find(function(t){return t===e});if(!i){if(o[e]){o[e].key+="|"+l}else{o[e]={key:l,command:e,description:p};n.push(o[e])}}})}});return n}var r=["insertstring","inserttext","setIndentation","paste"];var a=o(r);a=a.map(function(e){return{value:e.description,meta:e.key,command:e.command}});f(e,"",{name:"commands",selection:[0,Number.MAX_VALUE],maxHistoryCount:5,onAccept:function(t){if(t.item){var i=t.item.command;this.addToHistory(t.item);e.execCommand(i)}},addToHistory:function(e){var t=this.history();t.unshift(e);delete e.message;for(var i=1;i<t.length;i++){if(t[i]["command"]==e.command){t.splice(i,1);break}}if(this.maxHistoryCount>0&&t.length>this.maxHistoryCount){t.splice(t.length-1,1)}f.commands["history"]=t},history:function(){return f.commands["history"]||[]},getPrefix:function(e){var t=e.getCursorPosition();var i=e.getValue();return i.substring(0,t.column)},getCompletions:function(e){function t(e,t){var i=JSON.parse(JSON.stringify(e));var n=new s(i);return n.filterCompletions(i,t)}function i(e,t){if(!t||!t.length){return e}var i=[];t.forEach(function(e){i.push(e.command)});var n=[];e.forEach(function(e){if(i.indexOf(e.command)===-1){n.push(e)}});return n}var o=this.getPrefix(e);var r=t(this.history(),o);var l=i(a,r);l=t(l,o);if(r.length&&l.length){r[0].message=n("prompt.recently-used","Recently used");l[0].message=n("prompt.other-commands","Other commands")}var c=r.concat(l);return c.length>0?c:[{value:n("prompt.no-matching-commands","No matching commands"),error:1}]}})};f.modes=function(e,t){var i=h.modes;i=i.map(function(e){return{value:e.caption,mode:e.name}});f(e,"",{name:"modes",selection:[0,Number.MAX_VALUE],onAccept:function(t){if(t.item){var i="ace/mode/"+t.item.mode;e.session.setMode(i)}},getPrefix:function(e){var t=e.getCursorPosition();var i=e.getValue();return i.substring(0,t.column)},getCompletions:function(e){function t(e,t){var i=JSON.parse(JSON.stringify(e));var n=new s(i);return n.filterCompletions(i,t)}var n=this.getPrefix(e);var o=t(i,n);return o.length>0?o:[{caption:"No mode matching",value:"No mode matching",error:1}]}})};r.importCssString(".ace_prompt_container {\n    max-width: 603px;\n    width: 100%;\n    margin: 20px auto;\n    padding: 3px;\n    background: white;\n    border-radius: 2px;\n    box-shadow: 0px 2px 3px 0px #555;\n}","promtp.css",false);t.prompt=f});(function(){ace.require(["ace/ext/prompt"],function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}})})();
//# sourceMappingURL=ext-prompt.js.map