ace.define("ace/mode/jsdoc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=function(){this.$rules={start:[{token:["comment.doc.tag","comment.doc.text","lparen.doc"],regex:"(@(?:param|member|typedef|property|namespace|var|const|callback))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:["rparen.doc","text.doc","variable.parameter.doc","lparen.doc","variable.parameter.doc","rparen.doc"],regex:/(})(\s*)(?:([\w=:\/\.]+)|(?:(\[)([\w=:\/\.\-\'\" ]+)(\])))/,next:"pop"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","lparen.doc"],regex:"(@(?:returns?|yields|type|this|suppress|public|protected|private|package|modifies|"+"implements|external|exception|throws|enum|define|extends))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:"(@(?:alias|memberof|instance|module|name|lends|namespace|external|this|template|"+"requires|param|implements|function|extends|typedef|mixes|constructor|var|"+"memberof\\!|event|listens|exports|class|constructs|interface|emits|fires|"+'throws|const|callback|borrows|augments))(\\s+)(\\w[\\w#.:/~"\\-]*)?'},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:"(@method)(\\s+)(\\w[\\w.\\(\\)]*)"},{token:"comment.doc.tag",regex:"@access\\s+(?:private|public|protected)"},{token:"comment.doc.tag",regex:"@kind\\s+(?:class|constant|event|external|file|function|member|mixin|module|namespace|typedef)"},{token:"comment.doc.tag",regex:"@\\w+(?=\\s|$)"},a.getTagRule(),{defaultToken:"comment.doc.body",caseInsensitive:true}],"doc-syntax":[{token:"operator.doc",regex:/[|:]/},{token:"paren.doc",regex:/[\[\]]/}]};this.normalizeRules()};n.inherits(a,o);a.getTagRule=function(e){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}};a.getStartRule=function(e){return{token:"comment.doc",regex:/\/\*\*(?!\/)/,next:e}};a.getEndRule=function(e){return{token:"comment.doc",regex:"\\*\\/",next:e}};t.JsDocCommentHighlightRules=a});ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/jsdoc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("./jsdoc_comment_highlight_rules").JsDocCommentHighlightRules;var a=e("./text_highlight_rules").TextHighlightRules;var i="[a-zA-Z\\$_¡-￿][a-zA-Z\\d\\$_¡-￿]*";var s=function(e){var t={"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|"+"Namespace|QName|XML|XMLList|"+"ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|"+"Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|"+"Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|"+"SyntaxError|TypeError|URIError|"+"decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|"+"isNaN|parseFloat|parseInt|"+"JSON|Math|"+"this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|"+"break|case|catch|continue|default|delete|do|else|finally|for|"+"if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|"+"__parent__|__count__|escape|unescape|with|__proto__|"+"class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"};var r=this.createKeywordMapper(t,"identifier");var n="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void";var a="\\\\(?:x[0-9a-fA-F]{2}|"+"u[0-9a-fA-F]{4}|"+"u{[0-9a-fA-F]{1,6}}|"+"[0-2][0-7]{0,2}|"+"3[0-7][0-7]?|"+"[4-7][0-7]?|"+".)";var s="(function)(\\s*)(\\*?)";var u={token:["identifier","text","paren.lparen"],regex:"(\\b(?!"+Object.values(t).join("|")+"\\b)"+i+")(\\s*)(\\()"};this.$rules={no_regex:[o.getStartRule("doc-start"),c("no_regex"),u,{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(=)(\\s*)"+s+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))("+i+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(:)(\\s*)"+s+"(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)"+s+"(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:"+n+")\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|debug|time|trace|timeEnd|assert)\b/},{token:r,regex:i},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:"keyword.operator",regex:/=/},{token:["storage.type","text","storage.type","text","paren.lparen"],regex:s+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:"prototype"},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:i},{regex:"",token:"empty",next:"no_regex"}],start:[o.getStartRule("doc-start"),c("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[c("function_arguments"),{token:"variable.parameter",regex:i},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:a},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:a},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]};if(!e||!e.noES6){this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,t,r){this.next=e=="{"?this.nextState:"";if(e=="{"&&r.length){r.unshift("start",t)}else if(e=="}"&&r.length){r.shift();this.next=r.shift();if(this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1)return"paren.quasi.end"}return e=="{"?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:a},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+i+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=[^\\(]+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"});this.$rules["function_arguments"].unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"});this.$rules["property"].unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|"+"finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"});if(!e||e.jsx!=false)l.call(this)}this.embedRules(o,"doc-",[o.getEndRule("no_regex")]);this.normalizeRules()};n.inherits(s,a);function l(){var e=i.replace("\\d","\\d\\-");var t={onMatch:function(e,t,r){var n=e.charAt(1)=="/"?2:1;if(n==1){if(t!=this.nextState)r.unshift(this.next,this.nextState,0);else r.unshift(this.next);r[2]++}else if(n==2){if(t==this.nextState){r[1]--;if(!r[1]||r[1]<0){r.shift();r.shift()}}}return[{type:"meta.tag.punctuation."+(n==1?"":"end-")+"tag-open.xml",value:e.slice(0,n)},{type:"meta.tag.tag-name.xml",value:e.substr(n)}]},regex:"</?(?:"+e+"|(?=>))",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(t);var r={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[r,t,{include:"reference"},{defaultToken:"string.xml"}];this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(e,t,r){if(t==r[0])r.shift();if(e.length==2){if(r[0]==this.nextState)r[1]--;if(!r[1]||r[1]<0){r.splice(0,2)}}this.next=r[0]||"start";return[{type:this.token,value:e}]},nextState:"jsx"},r,c("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:e},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},t];this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function c(e){return[{token:"comment",regex:/\/\*/,next:[o.getTagRule(),{token:"comment",regex:"\\*\\/",next:e||"pop"},{defaultToken:"comment",caseInsensitive:true}]},{token:"comment",regex:"\\/\\/",next:[o.getTagRule(),{token:"comment",regex:"$|^",next:e||"pop"},{defaultToken:"comment",caseInsensitive:true}]}]}t.JavaScriptHighlightRules=s});ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,r){"use strict";var n=e("../range").Range;var o=function(){};(function(){this.checkOutdent=function(e,t){if(!/^\s+$/.test(e))return false;return/^\s*\}/.test(t)};this.autoOutdent=function(e,t){var r=e.getLine(t);var o=r.match(/^(\s*\})/);if(!o)return 0;var a=o[1].length;var i=e.findMatchingBracket({row:t,column:a});if(!i||i.row==t)return 0;var s=this.$getIndent(e.getLine(i.row));e.replace(new n(t,0,t,a-1),s)};this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(o.prototype);t.MatchingBraceOutdent=o});ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("../behaviour").Behaviour;var a=e("../../token_iterator").TokenIterator;function i(e,t){return e&&e.type.lastIndexOf(t+".xml")>-1}var s=function(){this.add("string_dquotes","insertion",function(e,t,r,n,o){if(o=='"'||o=="'"){var s=o;var l=n.doc.getTextRange(r.getSelectionRange());if(l!==""&&l!=="'"&&l!='"'&&r.getWrapBehavioursEnabled()){return{text:s+l+s,selection:false}}var c=r.getCursorPosition();var u=n.doc.getLine(c.row);var d=u.substring(c.column,c.column+1);var g=new a(n,c.row,c.column);var m=g.getCurrentToken();if(d==s&&(i(m,"attribute-value")||i(m,"string"))){return{text:"",selection:[1,1]}}if(!m)m=g.stepBackward();if(!m)return;while(i(m,"tag-whitespace")||i(m,"whitespace")){m=g.stepBackward()}var p=!d||d.match(/\s/);if(i(m,"attribute-equals")&&(p||d==">")||i(m,"decl-attribute-equals")&&(p||d=="?")){return{text:s+s,selection:[1,1]}}}});this.add("string_dquotes","deletion",function(e,t,r,n,o){var a=n.doc.getTextRange(o);if(!o.isMultiLine()&&(a=='"'||a=="'")){var i=n.doc.getLine(o.start.row);var s=i.substring(o.start.column+1,o.start.column+2);if(s==a){o.end.column++;return o}}});this.add("autoclosing","insertion",function(e,t,r,n,o){if(o==">"){var s=r.getSelectionRange().start;var l=new a(n,s.row,s.column);var c=l.getCurrentToken()||l.stepBackward();if(!c||!(i(c,"tag-name")||i(c,"tag-whitespace")||i(c,"attribute-name")||i(c,"attribute-equals")||i(c,"attribute-value")))return;if(i(c,"reference.attribute-value"))return;if(i(c,"attribute-value")){var u=l.getCurrentTokenColumn()+c.value.length;if(s.column<u)return;if(s.column==u){var d=l.stepForward();if(d&&i(d,"attribute-value"))return;l.stepBackward()}}if(/^\s*>/.test(n.getLine(s.row).slice(s.column)))return;while(!i(c,"tag-name")){c=l.stepBackward();if(c.value=="<"){c=l.stepForward();break}}var g=l.getCurrentTokenRow();var m=l.getCurrentTokenColumn();if(i(l.stepBackward(),"end-tag-open"))return;var p=c.value;if(g==s.row)p=p.substring(0,s.column-m);if(this.voidElements&&this.voidElements.hasOwnProperty(p.toLowerCase()))return;return{text:">"+"</"+p+">",selection:[1,1]}}});this.add("autoindent","insertion",function(e,t,r,n,o){if(o=="\n"){var s=r.getCursorPosition();var l=n.getLine(s.row);var c=new a(n,s.row,s.column);var u=c.getCurrentToken();if(i(u,"")&&u.type.indexOf("tag-close")!==-1){if(u.value=="/>")return;while(u&&u.type.indexOf("tag-name")===-1){u=c.stepBackward()}if(!u){return}var d=u.value;var g=c.getCurrentTokenRow();u=c.stepBackward();if(!u||u.type.indexOf("end-tag")!==-1){return}if(this.voidElements&&!this.voidElements[d]||!this.voidElements){var m=n.getTokenAt(s.row,s.column+1);var l=n.getLine(g);var p=this.$getIndent(l);var h=p+n.getTabString();if(m&&m.value==="</"){return{text:"\n"+h+"\n"+p,selection:[1,h.length,1,h.length]}}else{return{text:"\n"+h}}}}}})};n.inherits(s,o);t.XmlBehaviour=s});ace.define("ace/mode/behaviour/javascript",["require","exports","module","ace/lib/oop","ace/token_iterator","ace/mode/behaviour/cstyle","ace/mode/behaviour/xml"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("../../token_iterator").TokenIterator;var a=e("../behaviour/cstyle").CstyleBehaviour;var i=e("../behaviour/xml").XmlBehaviour;var s=function(){var e=new i({closeCurlyBraces:true}).getBehaviours();this.addBehaviours(e);this.inherit(a);this.add("autoclosing-fragment","insertion",function(e,t,r,n,a){if(a==">"){var i=r.getSelectionRange().start;var s=new o(n,i.row,i.column);var l=s.getCurrentToken()||s.stepBackward();if(!l)return;if(l.value=="<"){return{text:"></>",selection:[1,1]}}}})};n.inherits(s,a);t.JavaScriptBehaviour=s});ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("../../range").Range;var a=e("./fold_mode").FoldMode;var i=t.FoldMode=function(e,t){a.call(this);this.voidElements=e||{};this.optionalEndTags=n.mixin({},this.voidElements);if(t)n.mixin(this.optionalEndTags,t)};n.inherits(i,a);var s=function(){this.tagName="";this.closing=false;this.selfClosing=false;this.start={row:0,column:0};this.end={row:0,column:0}};function l(e,t){return e.type.lastIndexOf(t+".xml")>-1}(function(){this.getFoldWidget=function(e,t,r){var n=this._getFirstTagInLine(e,r);if(!n)return this.getCommentFoldWidget(e,r);if(n.closing||!n.tagName&&n.selfClosing)return t==="markbeginend"?"end":"";if(!n.tagName||n.selfClosing||this.voidElements.hasOwnProperty(n.tagName.toLowerCase()))return"";if(this._findEndTagInLine(e,r,n.tagName,n.end.column))return"";return"start"};this.getCommentFoldWidget=function(e,t){if(/comment/.test(e.getState(t))&&/<!-/.test(e.getLine(t)))return"start";return""};this._getFirstTagInLine=function(e,t){var r=e.getTokens(t);var n=new s;for(var o=0;o<r.length;o++){var a=r[o];if(l(a,"tag-open")){n.end.column=n.start.column+a.value.length;n.closing=l(a,"end-tag-open");a=r[++o];if(!a)return null;n.tagName=a.value;if(a.value===""){a=r[++o];if(!a)return null;n.tagName=a.value}n.end.column+=a.value.length;for(o++;o<r.length;o++){a=r[o];n.end.column+=a.value.length;if(l(a,"tag-close")){n.selfClosing=a.value=="/>";break}}return n}else if(l(a,"tag-close")){n.selfClosing=a.value=="/>";return n}n.start.column+=a.value.length}return null};this._findEndTagInLine=function(e,t,r,n){var o=e.getTokens(t);var a=0;for(var i=0;i<o.length;i++){var s=o[i];a+=s.value.length;if(a<n-1)continue;if(l(s,"end-tag-open")){s=o[i+1];if(l(s,"tag-name")&&s.value===""){s=o[i+2]}if(s&&s.value==r)return true}}return false};this.getFoldWidgetRange=function(e,t,r){var n=this._getFirstTagInLine(e,r);if(!n){return this.getCommentFoldWidget(e,r)&&e.getCommentFoldRange(r,e.getLine(r).length)}var a=e.getMatchingTags({row:r,column:0});if(a){return new o(a.openTag.end.row,a.openTag.end.column,a.closeTag.start.row,a.closeTag.start.column)}}}).call(i.prototype)});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("../../range").Range;var a=e("./fold_mode").FoldMode;var i=t.FoldMode=function(e){if(e){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end))}};n.inherits(i,a);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(e,t,r){var n=e.getLine(r);if(this.singleLineBlockCommentRe.test(n)){if(!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return""}var o=this._getFoldWidgetBase(e,t,r);if(!o&&this.startRegionRe.test(n))return"start";return o};this.getFoldWidgetRange=function(e,t,r,n){var o=e.getLine(r);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,r);var a=o.match(this.foldingStartMarker);if(a){var i=a.index;if(a[1])return this.openingBracketBlock(e,a[1],r,i);var s=e.getCommentFoldRange(r,i+a[0].length,1);if(s&&!s.isMultiLine()){if(n){s=this.getSectionRange(e,r)}else if(t!="all")s=null}return s}if(t==="markbegin")return;var a=o.match(this.foldingStopMarker);if(a){var i=a.index+a[0].length;if(a[1])return this.closingBracketBlock(e,a[1],r,i);return e.getCommentFoldRange(r,i,-1)}};this.getSectionRange=function(e,t){var r=e.getLine(t);var n=r.search(/\S/);var a=t;var i=r.length;t=t+1;var s=t;var l=e.getLength();while(++t<l){r=e.getLine(t);var c=r.search(/\S/);if(c===-1)continue;if(n>c)break;var u=this.getFoldWidgetRange(e,"all",t);if(u){if(u.start.row<=a){break}else if(u.isMultiLine()){t=u.end.row}else if(n==c){break}}s=t}return new o(a,i,s,e.getLine(s).length)};this.getCommentRegionBlock=function(e,t,r){var n=t.search(/\s*$/);var a=e.getLength();var i=r;var s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var l=1;while(++r<a){t=e.getLine(r);var c=s.exec(t);if(!c)continue;if(c[1])l--;else l++;if(!l)break}var u=r;if(u>i){return new o(i,n,u,t.length)}}}).call(i.prototype)});ace.define("ace/mode/folding/javascript",["require","exports","module","ace/lib/oop","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("./xml").FoldMode;var a=e("./cstyle").FoldMode;var i=t.FoldMode=function(e){if(e){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end))}this.xmlFoldMode=new o};n.inherits(i,a);(function(){this.getFoldWidgetRangeBase=this.getFoldWidgetRange;this.getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(e,t,r){var n=this.getFoldWidgetBase(e,t,r);if(!n){return this.xmlFoldMode.getFoldWidget(e,t,r)}return n};this.getFoldWidgetRange=function(e,t,r,n){var o=this.getFoldWidgetRangeBase(e,t,r,n);if(o)return o;return this.xmlFoldMode.getFoldWidgetRange(e,t,r)}}).call(i.prototype)});ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/javascript","ace/mode/folding/javascript"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("./text").Mode;var a=e("./javascript_highlight_rules").JavaScriptHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../worker/worker_client").WorkerClient;var l=e("./behaviour/javascript").JavaScriptBehaviour;var c=e("./folding/javascript").FoldMode;var u=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new l;this.foldingRules=new c};n.inherits(u,o);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.$quotes={'"':'"',"'":"'","`":"`"};this.$pairQuotesAfter={"`":/\w/};this.getNextLineIndent=function(e,t,r){var n=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e);var a=o.tokens;var i=o.state;if(a.length&&a[a.length-1].type=="comment"){return n}if(e=="start"||e=="no_regex"){var s=t.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);if(s){n+=r}}else if(e=="doc-start"){if(i=="start"||i=="no_regex"){return""}}return n};this.checkOutdent=function(e,t,r){return this.$outdent.checkOutdent(t,r)};this.autoOutdent=function(e,t,r){this.$outdent.autoOutdent(t,r)};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");t.attachToDocument(e.getDocument());t.on("annotate",function(t){e.setAnnotations(t.data)});t.on("terminate",function(){e.clearAnnotations()});return t};this.$id="ace/mode/javascript";this.snippetFileId="ace/snippets/javascript"}).call(u.prototype);t.Mode=u});ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("../lib/lang");var a=e("./text_highlight_rules").TextHighlightRules;var i=t.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index";var s=t.supportFunction="rgb|rgba|url|attr|counter|counters";var l=t.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom";var c=t.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen";var u=t.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";var d=t.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))";var g=t.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var m=t.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";var p=function(){var e=this.createKeywordMapper({"support.function":s,"support.constant":l,"support.type":i,"support.constant.color":c,"support.constant.fonts":u},"text",true);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:d},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:true}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document"+"|page|font|keyframes|viewport|counter-style|font-feature-values"+"|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+d+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:d},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:g},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:m},{include:"url"},{token:e,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{token:"paren.lparen",regex:"\\{"},{caseInsensitive:true}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]};this.normalizeRules()};n.inherits(p,a);t.CssHighlightRules=p});ace.define("ace/mode/css_completions",["require","exports","module"],function(e,t,r){"use strict";var n={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}};var o=function(){};(function(){this.completionsDefined=false;this.defineCompletions=function(){if(document){var e=document.createElement("c").style;for(var t in e){if(typeof e[t]!=="string")continue;var r=t.replace(/[A-Z]/g,function(e){return"-"+e.toLowerCase()});if(!n.hasOwnProperty(r))n[r]=1}}this.completionsDefined=true};this.getCompletions=function(e,t,r,n){if(!this.completionsDefined){this.defineCompletions()}if(e==="ruleset"||t.$mode.$id=="ace/mode/scss"){var o=t.getLine(r.row).substr(0,r.column);var a=/\([^)]*$/.test(o);if(a){o=o.substr(o.lastIndexOf("(")+1)}if(/:[^;]+$/.test(o)){/([\w\-]+):[^:]*$/.test(o);return this.getPropertyValueCompletions(e,t,r,n)}else{return this.getPropertyCompletions(e,t,r,n,a)}}return[]};this.getPropertyCompletions=function(e,t,r,o,a){a=a||false;var i=Object.keys(n);return i.map(function(e){return{caption:e,snippet:e+": $0"+(a?"":";"),meta:"property",score:1e6}})};this.getPropertyValueCompletions=function(e,t,r,o){var a=t.getLine(r.row).substr(0,r.column);var i=(/([\w\-]+):[^:]*$/.exec(a)||{})[1];if(!i)return[];var s=[];if(i in n&&typeof n[i]==="object"){s=Object.keys(n[i])}return s.map(function(e){return{caption:e,snippet:e,meta:"property value",score:1e6}})}}).call(o.prototype);t.CssCompletions=o});ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("../behaviour").Behaviour;var a=e("./cstyle").CstyleBehaviour;var i=e("../../token_iterator").TokenIterator;var s=function(){this.inherit(a);this.add("colon","insertion",function(e,t,r,n,o){if(o===":"&&r.selection.isEmpty()){var a=r.getCursorPosition();var s=new i(n,a.row,a.column);var l=s.getCurrentToken();if(l&&l.value.match(/\s+/)){l=s.stepBackward()}if(l&&l.type==="support.type"){var c=n.doc.getLine(a.row);var u=c.substring(a.column,a.column+1);if(u===":"){return{text:"",selection:[1,1]}}if(/^(\s+[^;]|\s*$)/.test(c.substring(a.column))){return{text:":;",selection:[1,1]}}}}});this.add("colon","deletion",function(e,t,r,n,o){var a=n.doc.getTextRange(o);if(!o.isMultiLine()&&a===":"){var s=r.getCursorPosition();var l=new i(n,s.row,s.column);var c=l.getCurrentToken();if(c&&c.value.match(/\s+/)){c=l.stepBackward()}if(c&&c.type==="support.type"){var u=n.doc.getLine(o.start.row);var d=u.substring(o.end.column,o.end.column+1);if(d===";"){o.end.column++;return o}}}});this.add("semicolon","insertion",function(e,t,r,n,o){if(o===";"&&r.selection.isEmpty()){var a=r.getCursorPosition();var i=n.doc.getLine(a.row);var s=i.substring(a.column,a.column+1);if(s===";"){return{text:"",selection:[1,1]}}}});this.add("!important","insertion",function(e,t,r,n,o){if(o==="!"&&r.selection.isEmpty()){var a=r.getCursorPosition();var i=n.doc.getLine(a.row);if(/^\s*(;|}|$)/.test(i.substring(a.column))){return{text:"!important",selection:[10,10]}}}})};n.inherits(s,a);t.CssBehaviour=s});ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("./text").Mode;var a=e("./css_highlight_rules").CssHighlightRules;var i=e("./matching_brace_outdent").MatchingBraceOutdent;var s=e("../worker/worker_client").WorkerClient;var l=e("./css_completions").CssCompletions;var c=e("./behaviour/css").CssBehaviour;var u=e("./folding/cstyle").FoldMode;var d=function(){this.HighlightRules=a;this.$outdent=new i;this.$behaviour=new c;this.$completer=new l;this.foldingRules=new u};n.inherits(d,o);(function(){this.foldingRules="cStyle";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(e,t,r){var n=this.$getIndent(t);var o=this.getTokenizer().getLineTokens(t,e).tokens;if(o.length&&o[o.length-1].type=="comment"){return n}var a=t.match(/^.*\{\s*$/);if(a){n+=r}return n};this.checkOutdent=function(e,t,r){return this.$outdent.checkOutdent(t,r)};this.autoOutdent=function(e,t,r){this.$outdent.autoOutdent(t,r)};this.getCompletions=function(e,t,r,n){return this.$completer.getCompletions(e,t,r,n)};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/css_worker","Worker");t.attachToDocument(e.getDocument());t.on("annotate",function(t){e.setAnnotations(t.data)});t.on("terminate",function(){e.clearAnnotations()});return t};this.$id="ace/mode/css";this.snippetFileId="ace/snippets/css"}).call(d.prototype);t.Mode=d});ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var a=function(e){var t="[_:a-zA-ZÀ-￿][-_:.a-zA-Z0-9À-￿]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+t+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:true},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:t},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+t+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+t+":)?"+t+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:t},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]};if(this.constructor===a)this.normalizeRules()};(function(){this.embedTagRules=function(e,t,r){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+r+".tag-name.xml"],regex:"(<)("+r+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:t+"start"}]});this.$rules[r+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(e,t,r){r.splice(0);return this.token}}];this.embedRules(e,t,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+r+".tag-name.xml"],regex:"(</)("+r+"(?=\\s|>|$))",next:r+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(o.prototype);n.inherits(a,o);t.XmlHighlightRules=a});ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("../lib/lang");var a=e("./css_highlight_rules").CssHighlightRules;var i=e("./javascript_highlight_rules").JavaScriptHighlightRules;var s=e("./xml_highlight_rules").XmlHighlightRules;var l=o.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"});var c=function(){s.call(this);this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(e,t){var r=l[t];return["meta.tag.punctuation."+(e=="<"?"":"end-")+"tag-open.xml","meta.tag"+(r?"."+r:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]});this.embedTagRules(a,"css-","style");this.embedTagRules(new i({jsx:false}).getRules(),"js-","script");if(this.constructor===c)this.normalizeRules()};n.inherits(c,s);t.HtmlHighlightRules=c});ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("./fold_mode").FoldMode;var a=t.FoldMode=function(e,t){this.defaultMode=e;this.subModes=t};n.inherits(a,o);(function(){this.$getMode=function(e){if(typeof e!="string")e=e[0];for(var t in this.subModes){if(e.indexOf(t)===0)return this.subModes[t]}return null};this.$tryMode=function(e,t,r,n){var o=this.$getMode(e);return o?o.getFoldWidget(t,r,n):""};this.getFoldWidget=function(e,t,r){return this.$tryMode(e.getState(r-1),e,t,r)||this.$tryMode(e.getState(r),e,t,r)||this.defaultMode.getFoldWidget(e,t,r)};this.getFoldWidgetRange=function(e,t,r){var n=this.$getMode(e.getState(r-1));if(!n||!n.getFoldWidget(e,t,r))n=this.$getMode(e.getState(r));if(!n||!n.getFoldWidget(e,t,r))n=this.defaultMode;return n.getFoldWidgetRange(e,t,r)}}).call(a.prototype)});ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(e,t,r){"use strict";var n=e("../../lib/oop");var o=e("./mixed").FoldMode;var a=e("./xml").FoldMode;var i=e("./cstyle").FoldMode;var s=t.FoldMode=function(e,t){o.call(this,new a(e,t),{"js-":new i,"css-":new i})};n.inherits(s,o)});ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(e,t,r){"use strict";var n=e("../token_iterator").TokenIterator;var o=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"];var a=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"];var i=o.concat(a);var s={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}};var l=Object.keys(s);function c(e,t){return e.type.lastIndexOf(t+".xml")>-1}function u(e,t){var r=new n(e,t.row,t.column);var o=r.getCurrentToken();while(o&&!c(o,"tag-name")){o=r.stepBackward()}if(o)return o.value}function d(e,t){var r=new n(e,t.row,t.column);var o=r.getCurrentToken();while(o&&!c(o,"attribute-name")){o=r.stepBackward()}if(o)return o.value}var g=function(){};(function(){this.getCompletions=function(e,t,r,n){var o=t.getTokenAt(r.row,r.column);if(!o)return[];if(c(o,"tag-name")||c(o,"tag-open")||c(o,"end-tag-open"))return this.getTagCompletions(e,t,r,n);if(c(o,"tag-whitespace")||c(o,"attribute-name"))return this.getAttributeCompletions(e,t,r,n);if(c(o,"attribute-value"))return this.getAttributeValueCompletions(e,t,r,n);var a=t.getLine(r.row).substr(0,r.column);if(/&[a-z]*$/i.test(a))return this.getHTMLEntityCompletions(e,t,r,n);return[]};this.getTagCompletions=function(e,t,r,n){return l.map(function(e){return{value:e,meta:"tag",score:1e6}})};this.getAttributeCompletions=function(e,t,r,n){var o=u(t,r);if(!o)return[];var a=i;if(o in s){a=a.concat(Object.keys(s[o]))}return a.map(function(e){return{caption:e,snippet:e+'="$0"',meta:"attribute",score:1e6}})};this.getAttributeValueCompletions=function(e,t,r,n){var o=u(t,r);var a=d(t,r);if(!o)return[];var i=[];if(o in s&&a in s[o]&&typeof s[o][a]==="object"){i=Object.keys(s[o][a])}return i.map(function(e){return{caption:e,snippet:e,meta:"attribute value",score:1e6}})};this.getHTMLEntityCompletions=function(e,t,r,n){var o=["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"];return o.map(function(e){return{caption:e,snippet:e,meta:"html entity",score:1e6}})}}).call(g.prototype);t.HtmlCompletions=g});ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("../lib/lang");var a=e("./text").Mode;var i=e("./javascript").Mode;var s=e("./css").Mode;var l=e("./html_highlight_rules").HtmlHighlightRules;var c=e("./behaviour/xml").XmlBehaviour;var u=e("./folding/html").FoldMode;var d=e("./html_completions").HtmlCompletions;var g=e("../worker/worker_client").WorkerClient;var m=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"];var p=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"];var h=function(e){this.fragmentContext=e&&e.fragmentContext;this.HighlightRules=l;this.$behaviour=new c;this.$completer=new d;this.createModeDelegates({"js-":i,"css-":s});this.foldingRules=new u(this.voidElements,o.arrayToMap(p))};n.inherits(h,a);(function(){this.blockComment={start:"\x3c!--",end:"--\x3e"};this.voidElements=o.arrayToMap(m);this.getNextLineIndent=function(e,t,r){return this.$getIndent(t)};this.checkOutdent=function(e,t,r){return false};this.getCompletions=function(e,t,r,n){return this.$completer.getCompletions(e,t,r,n)};this.createWorker=function(e){if(this.constructor!=h)return;var t=new g(["ace"],"ace/mode/html_worker","Worker");t.attachToDocument(e.getDocument());if(this.fragmentContext)t.call("setOptions",[{context:this.fragmentContext}]);t.on("error",function(t){e.setAnnotations(t.data)});t.on("terminate",function(){e.clearAnnotations()});return t};this.$id="ace/mode/html";this.snippetFileId="ace/snippets/html"}).call(h.prototype);t.Mode=h});ace.define("ace/mode/coldfusion_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/javascript_highlight_rules","ace/mode/html_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("./javascript_highlight_rules").JavaScriptHighlightRules;var a=e("./html_highlight_rules").HtmlHighlightRules;var i=function(){a.call(this);this.$rules.tag[2].token=function(e,t){var r=t.slice(0,2)=="cf"?"keyword":"meta.tag";return["meta.tag.punctuation."+(e=="<"?"":"end-")+"tag-open.xml",r+".tag-name.xml"]};var e=Object.keys(this.$rules).filter(function(e){return/^(js|css)-/.test(e)});this.embedRules({cfmlComment:[{regex:"\x3c!---",token:"comment.start",push:"cfmlComment"},{regex:"---\x3e",token:"comment.end",next:"pop"},{defaultToken:"comment"}]},"",[{regex:"\x3c!---",token:"comment.start",push:"cfmlComment"}],["comment","start","tag_whitespace","cdata"].concat(e));this.$rules.cfTag=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"pop"}];var t={token:function(e,t){return["meta.tag.punctuation."+(e=="<"?"":"end-")+"tag-open.xml","keyword.tag-name.xml"]},regex:"(</?)(cf[-_a-zA-Z0-9:.]+)",push:"cfTag"};e.forEach(function(e){this.$rules[e].unshift(t)},this);this.embedTagRules(new o({jsx:false}).getRules(),"cfjs-","cfscript");this.normalizeRules()};n.inherits(i,a);t.ColdfusionHighlightRules=i});ace.define("ace/mode/coldfusion",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/html","ace/mode/coldfusion_highlight_rules"],function(e,t,r){"use strict";var n=e("../lib/oop");var o=e("../lib/lang");var a=e("./html").Mode;var i=e("./coldfusion_highlight_rules").ColdfusionHighlightRules;var s="cfabort|cfapplication|cfargument|cfassociate|cfbreak|cfcache|cfcollection|cfcookie|cfdbinfo|cfdirectory|cfdump|cfelse|cfelseif|cferror|cfexchangecalendar|cfexchangeconnection|cfexchangecontact|cfexchangefilter|cfexchangetask|cfexit|cffeed|cffile|cfflush|cfftp|cfheader|cfhtmlhead|cfhttpparam|cfimage|cfimport|cfinclude|cfindex|cfinsert|cfinvokeargument|cflocation|cflog|cfmailparam|cfNTauthenticate|cfobject|cfobjectcache|cfparam|cfpdfformparam|cfprint|cfprocparam|cfprocresult|cfproperty|cfqueryparam|cfregistry|cfreportparam|cfrethrow|cfreturn|cfschedule|cfsearch|cfset|cfsetting|cfthrow|cfzipparam)".split("|");var l=function(){a.call(this);this.HighlightRules=i};n.inherits(l,a);(function(){this.voidElements=n.mixin(o.arrayToMap(s),this.voidElements);this.getNextLineIndent=function(e,t,r){return this.$getIndent(t)};this.$id="ace/mode/coldfusion"}).call(l.prototype);t.Mode=l});(function(){ace.require(["ace/mode/coldfusion"],function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}})})();
//# sourceMappingURL=mode-coldfusion.js.map