ace.define("ace/mode/kotlin_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text_highlight_rules").TextHighlightRules;var i=function(){var e=this.$keywords=this.createKeywordMapper({"storage.modifier.kotlin":"var|val|public|private|protected|abstract|final|enum|open|attribute|"+"annotation|override|inline|var|val|vararg|lazy|in|out|internal|data|tailrec|operator|infix|const|"+"yield|typealias|typeof|sealed|inner|value|lateinit|external|suspend|noinline|crossinline|reified|"+"expect|actual",keyword:"companion|class|object|interface|namespace|type|fun|constructor|if|else|while|for|do|return|when|"+"where|break|continue|try|catch|finally|throw|in|is|as|assert|constructor","constant.language.kotlin":"true|false|null|this|super","entity.name.function.kotlin":"get|set"},"identifier");this.$rules={start:[{include:"#comments"},{token:["text","keyword.other.kotlin","text","entity.name.package.kotlin","text"],regex:/^(\s*)(package)\b(?:(\s*)([^ ;$]+)(\s*))?/},{token:"comment",regex:/^\s*#!.*$/},{include:"#imports"},{include:"#expressions"},{token:"string",regex:/@[a-zA-Z][a-zA-Z:]*\b/},{token:["keyword.other.kotlin","text","entity.name.variable.kotlin"],regex:/\b(var|val)(\s+)([a-zA-Z_][\w]*)\b/},{token:["keyword.other.kotlin","text","entity.name.variable.kotlin","paren.lparen"],regex:/(fun)(\s+)(\w+)(\()/,push:[{token:["variable.parameter.function.kotlin","text","keyword.operator"],regex:/(\w+)(\s*)(:)/},{token:"paren.rparen",regex:/\)/,next:"pop"},{include:"#comments"},{include:"#types"},{include:"#expressions"}]},{token:["text","keyword","text","identifier"],regex:/^(\s*)(class)(\s*)([a-zA-Z]+)/,next:"#classes"},{token:["identifier","punctuaction"],regex:/([a-zA-Z_][\w]*)(<)/,push:[{include:"#generics"},{include:"#defaultTypes"},{token:"punctuation",regex:/>/,next:"pop"}]},{token:e,regex:/[a-zA-Z_][\w]*\b/},{token:"paren.lparen",regex:/[{(\[]/},{token:"paren.rparen",regex:/[})\]]/}],"#comments":[{token:"comment",regex:/\/\*/,push:[{token:"comment",regex:/\*\//,next:"pop"},{defaultToken:"comment"}]},{token:["text","comment"],regex:/(\s*)(\/\/.*$)/}],"#constants":[{token:"constant.numeric.kotlin",regex:/\b(?:0(?:x|X)[0-9a-fA-F]*|(?:[0-9]+\.?[0-9]*|\.[0-9]+)(?:(?:e|E)(?:\+|-)?[0-9]+)?)(?:[LlFfUuDd]|UL|ul)?\b/},{token:"constant.other.kotlin",regex:/\b[A-Z][A-Z0-9_]+\b/}],"#expressions":[{include:"#strings"},{include:"#constants"},{include:"#keywords"}],"#imports":[{token:["text","keyword.other.kotlin","text","keyword.other.kotlin"],regex:/^(\s*)(import)(\s+[^ $]+\s+)((?:as)?)/}],"#generics":[{token:"punctuation",regex:/</,push:[{token:"punctuation",regex:/>/,next:"pop"},{token:"storage.type.generic.kotlin",regex:/\w+/},{token:"keyword.operator",regex:/:/},{token:"punctuation",regex:/,/},{include:"#generics"}]}],"#classes":[{include:"#generics"},{token:"keyword",regex:/public|private|constructor/},{token:"string",regex:/@[a-zA-Z][a-zA-Z:]*\b/},{token:"text",regex:/(?=$|\(|{)/,next:"start"}],"#keywords":[{token:"keyword.operator.kotlin",regex:/==|!=|===|!==|<=|>=|<|>|=>|->|::|\?:/},{token:"keyword.operator.assignment.kotlin",regex:/=/},{token:"keyword.operator.declaration.kotlin",regex:/:/,push:[{token:"text",regex:/(?=$|{|=|,)/,next:"pop"},{include:"#types"}]},{token:"keyword.operator.dot.kotlin",regex:/\./},{token:"keyword.operator.increment-decrement.kotlin",regex:/\-\-|\+\+/},{token:"keyword.operator.arithmetic.kotlin",regex:/\-|\+|\*|\/|%/},{token:"keyword.operator.arithmetic.assign.kotlin",regex:/\+=|\-=|\*=|\/=/},{token:"keyword.operator.logical.kotlin",regex:/!|&&|\|\|/},{token:"keyword.operator.range.kotlin",regex:/\.\./},{token:"punctuation.kotlin",regex:/[;,]/}],"#types":[{include:"#defaultTypes"},{token:"paren.lparen",regex:/\(/,push:[{token:"paren.rparen",regex:/\)/,next:"pop"},{include:"#defaultTypes"},{token:"punctuation",regex:/,/}]},{include:"#generics"},{token:"keyword.operator.declaration.kotlin",regex:/->/},{token:"paren.rparen",regex:/\)/},{token:"keyword.operator.declaration.kotlin",regex:/:/,push:[{token:"text",regex:/(?=$|{|=|,)/,next:"pop"},{include:"#types"}]}],"#defaultTypes":[{token:"storage.type.buildin.kotlin",regex:/\b(Any|Unit|String|Int|Boolean|Char|Long|Double|Float|Short|Byte|dynamic|IntArray|BooleanArray|CharArray|LongArray|DoubleArray|FloatArray|ShortArray|ByteArray|Array|List|Map|Nothing|Enum|Throwable|Comparable)\b/}],"#strings":[{token:"string",regex:/"""/,push:[{token:"string",regex:/"""/,next:"pop"},{token:"variable.parameter.template.kotlin",regex:/\$\w+|\${[^}]+}/},{token:"constant.character.escape.kotlin",regex:/\\./},{defaultToken:"string"}]},{token:"string",regex:/"/,push:[{token:"string",regex:/"/,next:"pop"},{token:"variable.parameter.template.kotlin",regex:/\$\w+|\$\{[^\}]+\}/},{token:"constant.character.escape.kotlin",regex:/\\./},{defaultToken:"string"}]},{token:"string",regex:/'/,push:[{token:"string",regex:/'/,next:"pop"},{token:"constant.character.escape.kotlin",regex:/\\./},{defaultToken:"string"}]},{token:"string",regex:/`/,push:[{token:"string",regex:/`/,next:"pop"},{defaultToken:"string"}]}]};this.normalizeRules()};i.metaData={fileTypes:["kt","kts"],name:"Kotlin",scopeName:"source.Kotlin"};r.inherits(i,o);t.KotlinHighlightRules=i});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,n){"use strict";var r=e("../../lib/oop");var o=e("../../range").Range;var i=e("./fold_mode").FoldMode;var a=t.FoldMode=function(e){if(e){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end))}};r.inherits(a,i);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);if(this.singleLineBlockCommentRe.test(r)){if(!this.startRegionRe.test(r)&&!this.tripleStarBlockCommentRe.test(r))return""}var o=this._getFoldWidgetBase(e,t,n);if(!o&&this.startRegionRe.test(r))return"start";return o};this.getFoldWidgetRange=function(e,t,n,r){var o=e.getLine(n);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,n);var i=o.match(this.foldingStartMarker);if(i){var a=i.index;if(i[1])return this.openingBracketBlock(e,i[1],n,a);var s=e.getCommentFoldRange(n,a+i[0].length,1);if(s&&!s.isMultiLine()){if(r){s=this.getSectionRange(e,n)}else if(t!="all")s=null}return s}if(t==="markbegin")return;var i=o.match(this.foldingStopMarker);if(i){var a=i.index+i[0].length;if(i[1])return this.closingBracketBlock(e,i[1],n,a);return e.getCommentFoldRange(n,a,-1)}};this.getSectionRange=function(e,t){var n=e.getLine(t);var r=n.search(/\S/);var i=t;var a=n.length;t=t+1;var s=t;var l=e.getLength();while(++t<l){n=e.getLine(t);var g=n.search(/\S/);if(g===-1)continue;if(r>g)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=i){break}else if(c.isMultiLine()){t=c.end.row}else if(r==g){break}}s=t}return new o(i,a,s,e.getLine(s).length)};this.getCommentRegionBlock=function(e,t,n){var r=t.search(/\s*$/);var i=e.getLength();var a=n;var s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var l=1;while(++n<i){t=e.getLine(n);var g=s.exec(t);if(!g)continue;if(g[1])l--;else l++;if(!l)break}var c=n;if(c>a){return new o(a,r,c,t.length)}}}).call(a.prototype)});ace.define("ace/mode/kotlin",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/kotlin_highlight_rules","ace/mode/folding/cstyle"],function(e,t,n){"use strict";var r=e("../lib/oop");var o=e("./text").Mode;var i=e("./kotlin_highlight_rules").KotlinHighlightRules;var a=e("./folding/cstyle").FoldMode;var s=function(){this.HighlightRules=i;this.foldingRules=new a;this.$behaviour=this.$defaultBehaviour};r.inherits(s,o);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.$id="ace/mode/kotlin"}).call(s.prototype);t.Mode=s});(function(){ace.require(["ace/mode/kotlin"],function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}})})();
//# sourceMappingURL=mode-kotlin.js.map