ace.define("ace/mode/lua_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text_highlight_rules").TextHighlightRules;var i=function(){var e="break|do|else|elseif|end|for|function|if|in|local|repeat|"+"return|then|until|while|or|and|not";var t="true|false|nil|_G|_VERSION";var n="string|xpcall|package|tostring|print|os|unpack|require|"+"getfenv|setmetatable|next|assert|tonumber|io|rawequal|"+"collectgarbage|getmetatable|module|rawset|math|debug|"+"pcall|table|newproxy|type|coroutine|_G|select|gcinfo|"+"pairs|rawget|loadstring|ipairs|_VERSION|dofile|setfenv|"+"load|error|loadfile|"+"sub|upper|len|gfind|rep|find|match|char|dump|gmatch|"+"reverse|byte|format|gsub|lower|preload|loadlib|loaded|"+"loaders|cpath|config|path|seeall|exit|setlocale|date|"+"getenv|difftime|remove|time|clock|tmpname|rename|execute|"+"lines|write|close|flush|open|output|type|read|stderr|"+"stdin|input|stdout|popen|tmpfile|log|max|acos|huge|"+"ldexp|pi|cos|tanh|pow|deg|tan|cosh|sinh|random|randomseed|"+"frexp|ceil|floor|rad|abs|sqrt|modf|asin|min|mod|fmod|log10|"+"atan2|exp|sin|atan|getupvalue|debug|sethook|getmetatable|"+"gethook|setmetatable|setlocal|traceback|setfenv|getinfo|"+"setupvalue|getlocal|getregistry|getfenv|setn|insert|getn|"+"foreachi|maxn|foreach|concat|sort|remove|resume|yield|"+"status|wrap|create|running|"+"__add|__sub|__mod|__unm|__concat|__lt|__index|__call|__gc|__metatable|"+"__mul|__div|__pow|__len|__eq|__le|__newindex|__tostring|__mode|__tonumber";var r="string|package|os|io|math|debug|table|coroutine";var a="setn|foreach|foreachi|gcinfo|log10|maxn";var i=this.createKeywordMapper({keyword:e,"support.function":n,"keyword.deprecated":a,"constant.library":r,"constant.language":t,"variable.language":"self"},"identifier");var o="(?:(?:[1-9]\\d*)|(?:0))";var l="(?:0[xX][\\dA-Fa-f]+)";var s="(?:"+o+"|"+l+")";var u="(?:\\.\\d+)";var g="(?:\\d+)";var d="(?:(?:"+g+"?"+u+")|(?:"+g+"\\.))";var c="(?:"+d+")";this.$rules={start:[{stateName:"bracketedComment",onMatch:function(e,t,n){n.unshift(this.next,e.length-2,t);return"comment"},regex:/\-\-\[=*\[/,next:[{onMatch:function(e,t,n){if(e.length==n[1]){n.shift();n.shift();this.next=n.shift()}else{this.next=""}return"comment"},regex:/\]=*\]/,next:"start"},{defaultToken:"comment.body"}]},{token:"comment",regex:"\\-\\-.*$"},{stateName:"bracketedString",onMatch:function(e,t,n){n.unshift(this.next,e.length,t);return"string.start"},regex:/\[=*\[/,next:[{onMatch:function(e,t,n){if(e.length==n[1]){n.shift();n.shift();this.next=n.shift()}else{this.next=""}return"string.end"},regex:/\]=*\]/,next:"start"},{defaultToken:"string"}]},{token:"string",regex:'"(?:[^\\\\]|\\\\.)*?"'},{token:"string",regex:"'(?:[^\\\\]|\\\\.)*?'"},{token:"constant.numeric",regex:c},{token:"constant.numeric",regex:s+"\\b"},{token:i,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\/|%|\\#|\\^|~|<|>|<=|=>|==|~=|=|\\:|\\.\\.\\.|\\.\\."},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]\\)\\}]"},{token:"text",regex:"\\s+|\\w+"}]};this.normalizeRules()};r.inherits(i,a);t.LuaHighlightRules=i});ace.define("ace/mode/folding/lua",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],function(e,t,n){"use strict";var r=e("../../lib/oop");var a=e("./fold_mode").FoldMode;var i=e("../../range").Range;var o=e("../../token_iterator").TokenIterator;var l=t.FoldMode=function(){};r.inherits(l,a);(function(){this.foldingStartMarker=/\b(function|then|do|repeat)\b|{\s*$|(\[=*\[)/;this.foldingStopMarker=/\bend\b|^\s*}|\]=*\]/;this.getFoldWidget=function(e,t,n){var r=e.getLine(n);var a=this.foldingStartMarker.test(r);var i=this.foldingStopMarker.test(r);if(a&&!i){var o=r.match(this.foldingStartMarker);if(o[1]=="then"&&/\belseif\b/.test(r))return;if(o[1]){if(e.getTokenAt(n,o.index+1).type==="keyword")return"start"}else if(o[2]){var l=e.bgTokenizer.getState(n)||"";if(l[0]=="bracketedComment"||l[0]=="bracketedString")return"start"}else{return"start"}}if(t!="markbeginend"||!i||a&&i)return"";var o=r.match(this.foldingStopMarker);if(o[0]==="end"){if(e.getTokenAt(n,o.index+1).type==="keyword")return"end"}else if(o[0][0]==="]"){var l=e.bgTokenizer.getState(n-1)||"";if(l[0]=="bracketedComment"||l[0]=="bracketedString")return"end"}else return"end"};this.getFoldWidgetRange=function(e,t,n){var r=e.doc.getLine(n);var a=this.foldingStartMarker.exec(r);if(a){if(a[1])return this.luaBlock(e,n,a.index+1);if(a[2])return e.getCommentFoldRange(n,a.index+1);return this.openingBracketBlock(e,"{",n,a.index)}var a=this.foldingStopMarker.exec(r);if(a){if(a[0]==="end"){if(e.getTokenAt(n,a.index+1).type==="keyword")return this.luaBlock(e,n,a.index+1)}if(a[0][0]==="]")return e.getCommentFoldRange(n,a.index+1);return this.closingBracketBlock(e,"}",n,a.index+a[0].length)}};this.luaBlock=function(e,t,n,r){var a=new o(e,t,n);var l={function:1,do:1,then:1,elseif:-1,end:-1,repeat:1,until:-1};var s=a.getCurrentToken();if(!s||s.type!="keyword")return;var u=s.value;var g=[u];var d=l[u];if(!d)return;var c=d===-1?a.getCurrentTokenColumn():e.getLine(t).length;var f=t;a.step=d===-1?a.stepBackward:a.stepForward;while(s=a.step()){if(s.type!=="keyword")continue;var h=d*l[s.value];if(h>0){g.unshift(s.value)}else if(h<=0){g.shift();if(!g.length&&s.value!="elseif")break;if(h===0)g.unshift(s.value)}}if(!s)return null;if(r)return a.getCurrentTokenRange();var t=a.getCurrentTokenRow();if(d===-1)return new i(t,e.getLine(t).length,f,c);else return new i(f,c,t,a.getCurrentTokenColumn())}}).call(l.prototype)});ace.define("ace/mode/lua",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/lua_highlight_rules","ace/mode/folding/lua","ace/range","ace/worker/worker_client"],function(e,t,n){"use strict";var r=e("../lib/oop");var a=e("./text").Mode;var i=e("./lua_highlight_rules").LuaHighlightRules;var o=e("./folding/lua").FoldMode;var l=e("../range").Range;var s=e("../worker/worker_client").WorkerClient;var u=function(){this.HighlightRules=i;this.foldingRules=new o;this.$behaviour=this.$defaultBehaviour};r.inherits(u,a);(function(){this.lineCommentStart="--";this.blockComment={start:"--[[",end:"--]]"};var e={function:1,then:1,do:1,else:1,elseif:1,repeat:1,end:-1,until:-1};var t=["else","elseif","end","until"];function n(t){var n=0;for(var r=0;r<t.length;r++){var a=t[r];if(a.type=="keyword"){if(a.value in e){n+=e[a.value]}}else if(a.type=="paren.lparen"){n+=a.value.length}else if(a.type=="paren.rparen"){n-=a.value.length}}if(n<0){return-1}else if(n>0){return 1}else{return 0}}this.getNextLineIndent=function(e,t,r){var a=this.$getIndent(t);var i=0;var o=this.getTokenizer().getLineTokens(t,e);var l=o.tokens;if(e=="start"){i=n(l)}if(i>0){return a+r}else if(i<0&&a.substr(a.length-r.length)==r){if(!this.checkOutdent(e,t,"\n")){return a.substr(0,a.length-r.length)}}return a};this.checkOutdent=function(e,n,r){if(r!="\n"&&r!="\r"&&r!="\r\n")return false;if(n.match(/^\s*[\)\}\]]$/))return true;var a=this.getTokenizer().getLineTokens(n.trim(),e).tokens;if(!a||!a.length)return false;return a[0].type=="keyword"&&t.indexOf(a[0].value)!=-1};this.getMatching=function(t,n,r){if(n==undefined){var a=t.selection.lead;r=a.column;n=a.row}var i=t.getTokenAt(n,r);if(i&&i.value in e)return this.foldingRules.luaBlock(t,n,r,true)};this.autoOutdent=function(e,t,n){var r=t.getLine(n);var a=r.match(/^\s*/)[0].length;if(!a||!n)return;var i=this.getMatching(t,n,a+1);if(!i||i.start.row==n)return;var o=this.$getIndent(t.getLine(i.start.row));if(o.length!=a){t.replace(new l(n,0,n,a),o);t.outdentRows(new l(n+1,0,n+1,0))}};this.createWorker=function(e){var t=new s(["ace"],"ace/mode/lua_worker","Worker");t.attachToDocument(e.getDocument());t.on("annotate",function(t){e.setAnnotations(t.data)});t.on("terminate",function(){e.clearAnnotations()});return t};this.$id="ace/mode/lua";this.snippetFileId="ace/snippets/lua"}).call(u.prototype);t.Mode=u});(function(){ace.require(["ace/mode/lua"],function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}})})();
//# sourceMappingURL=mode-lua.js.map