/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Slider","./library","./RangeSliderRenderer"],function(t,i,e){"use strict";var s=t.extend("sap.ui.commons.RangeSlider",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{value2:{type:"float",group:"Appearance",defaultValue:80}}}});s.prototype.onAfterRendering=function(){this.oGrip2=this.getDomRef("grip2");t.prototype.onAfterRendering.apply(this);var i=this.getValue();var e=this.getValue2();if(e>=this.getMax()){e=this.getMax()}else if(e<i){e=i}var s=(e-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){s=this.getBarWidth()-s}this.changeGrip(e,s,this.oGrip2)};s.prototype.onresize=function(i){var e=this.getValue2();var s=(e-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){s=this.getBarWidth()-s}this.changeGrip(e,s,this.oGrip2);t.prototype.onresize.apply(this,arguments)};s.prototype.onfocusin=function(t){this.oMovingGrip=t.target};s.prototype.onsaphome=function(t){if(this.getEditable()&&this.getEnabled()){var i=0;var e=0;if(this.oMovingGrip==this.oGrip){i=this.getMin();if(this.getVertical()||this.bRtl&&!this.getVertical()){e=this.getBarWidth()}}else if(this.oMovingGrip==this.oGrip2){i=this.getValue();e=this.getOffsetLeft(this.oGrip)+this.iShiftGrip}this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};s.prototype.onsapend=function(t){if(this.getEditable()&&this.getEnabled()){var i=0;var e=0;if(this.oMovingGrip==this.oGrip){i=this.getValue2();e=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip}else if(this.oMovingGrip==this.oGrip2){i=this.getMax();if(this.getVertical()||this.bRtl&&!this.getVertical()){e=0}else{e=this.getBarWidth()}}this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};s.prototype.fireLiveChangeForGrip=function(t,i,e){if(t==this.oGrip){if(e!=i){this.fireLiveChange({value:i,value2:this.getValue2()})}}else if(t==this.oGrip2){if(e!=i){this.fireLiveChange({value2:i,value:this.getValue()})}}};s.prototype.adjustHighlightBar=function(t,i){if(t<0||isNaN(t)){t=0}var e=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;var s=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;var h;if(this.getVertical()){this.setLeft(s,this.oHiLi);this.setRight(this.getBarWidth()-e,this.oHiLi);h=Math.round(e-s)}else{if(this.bRtl){this.setLeft(s,this.oHiLi);this.setRight(this.getBarWidth()-e,this.oHiLi)}else{this.setLeft(e,this.oHiLi);this.setRight(this.getBarWidth()-s,this.oHiLi)}h=Math.abs(Math.round(s-e))}if(h<0){h=0}this.setObjectWidth(h+"px",this.oHiLi)};s.prototype.setRight=function(t,i){if(i==undefined){return}if(this.getVertical()){i.style.bottom=t+"px"}else{i.style.right=t+"px"}};s.prototype.updateValueProperty=function(t,i){if(i==this.oGrip){this.setProperty("value",t,true)}else{this.setProperty("value2",t,true)}};s.prototype.setValue=function(t){this.setProperty("value",t,true);this._oldValue1=t;if(isNaN(t)){return this}if(!this.oBar){return this}var i=parseFloat(t);var e;if(i>=this.getValue2()){i=this.getValue2();e=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}}else if(i<=this.getMin()){i=this.getMin();if(this.getVertical()){e=this.getBarWidth()}else{e=0}}else{e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth()}if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}this.changeGrip(i,e,this.oGrip);this._oldValue1=i;return this};s.prototype.setValue2=function(t){this.setProperty("value2",t,true);this._oldValue2=t;if(isNaN(t)){return this}if(!this.oBar){return this}var i=parseFloat(t);var e;if(i>=this.getMax()){i=this.getMax();if(this.getVertical()){e=0}else{e=this.getBarWidth()}}else if(i<=this.getValue()){i=this.getValue();e=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}}else{e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth()}if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}this.changeGrip(i,e,this.oGrip2);this._oldValue2=i;return this};s.prototype.getLeftGrip=function(){return this.oGrip};s.prototype.getRightGrip=function(){return this.oGrip2};s.prototype.getValueForGrip=function(t){if(t==this.oGrip){return this.getValue()}else{return this.getValue2()}};s.prototype.validateNewPosition=function(t,i,e,s){if(!this.bRtl&&!this.getVertical()){if(e==this.oGrip){if(s){if(t<=this.getMin()||i<=0){t=this.getMin();i=0}}else{if(t>=this.getValue2()){t=this.getValue2();i=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip}}}else{if(s){if(t<=this.getValue()){t=this.getValue();i=this.getOffsetLeft(this.oGrip)+this.iShiftGrip}}else{if(t>=this.getMax()||i>=this.getBarWidth()){t=this.getMax();i=this.getBarWidth()}}}}else{if(e==this.oGrip){if(s){if(t<=this.getMin()||i>=this.getBarWidth()){t=this.getMin();i=this.getBarWidth()}}else{if(t>=this.getValue2()){t=this.getValue2();i=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip}}}else{if(s){if(t<=this.getValue()){t=this.getValue();i=this.getOffsetLeft(this.oGrip)+this.iShiftGrip}}else{if(t>=this.getMax()||i<=0){t=this.getMax();i=0}}}}this.oGrip.setAttribute("aria-valuemax",this.getValue2());this.oGrip2.setAttribute("aria-valuemin",this.getValue());return{fNewValue:t,iNewPos:i}};s.prototype.handleMove=function(i){var e=Math.abs(this.getOffsetLeft(this.oGrip2)-this.getOffsetLeft(this.oGrip));if(!this.bRtl){if(this.oMovingGrip==this.oGrip2&&this.getValue2()==this.getMax()&&e<2){this.oMovingGrip=this.oGrip;this.oGrip.focus()}else if(this.oMovingGrip==this.oGrip&&this.getValue()==this.getMin()&&e<2){this.oMovingGrip=this.oGrip2;this.oGrip2.focus()}}else{if(this.oMovingGrip==this.oGrip&&this.getValue2()==this.getMin()&&e<2){this.oMovingGrip=this.oGrip2;this.oGrip2.focus()}else if(this.oMovingGrip==this.oGrip2&&this.getValue()==this.getMax()&&e<2){this.oMovingGrip=this.oGrip;this.oGrip.focus()}}t.prototype.handleMove.apply(this,[i])};s.prototype.handleFireChange=function(t){var i=this.getValue();var e=this.getValue2();if(i!==this._oldValue1||e!==this._oldValue2){this._oldValue1=i;this._oldValue2=e;this.fireChange({value2:e,value:i});if(!t){this.fireLiveChange({value:i,value2:e})}}};s.prototype.getNearestGrip=function(t){var i;var e=0;var s=0;if(this.getVertical()){e=Math.abs(t-this.getOffsetLeft(this.oGrip2));s=Math.abs(this.getOffsetLeft(this.oGrip)-t);if(e==s){if(t>s){i=this.oGrip}else{i=this.oGrip2}}else if(e>=s){i=this.oGrip}else{i=this.oGrip2}}else{e=Math.abs(t-this.getOffsetLeft(this.oGrip));s=Math.abs(this.getOffsetLeft(this.oGrip2)-t);if(e==s){if(t>s&&!this.bRtl||t<s&&this.bRtl){i=this.oGrip2}else{i=this.oGrip}}else if(e<=s){i=this.oGrip}else{i=this.oGrip2}}return i};s.prototype.setObjectWidth=function(t,i){if(this.getVertical()){i.style.height=t}else{i.style.width=t}};s.prototype.targetIsGrip=function(t){if(t==this.oGrip.id||t==this.oGrip2.id){return true}return false};s.prototype.setAriaState=function(){t.prototype.setAriaState.apply(this);var i=this.getValue2();if(this.bTextLabels){i=this.getNearestLabel(i)}this.oGrip2.setAttribute("aria-valuenow",i)};return s});
//# sourceMappingURL=RangeSlider.js.map