/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RowRepeaterRenderer","./Toolbar","./Paginator","./Button","sap/ui/model/FilterType","sap/ui/core/Configuration"],function(jQuery,t,e,i,r,s,o,n,a){"use strict";var g=t.PaginatorEvent;var h=t.ToolbarDesign;var u=t.RowRepeaterDesign;var p=e.extend("sap.ui.commons.RowRepeater",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{numberOfRows:{type:"int",group:"Dimension",defaultValue:5},currentPage:{type:"int",group:"Data",defaultValue:1},showMoreSteps:{type:"int",group:"Behavior",defaultValue:0},fixedRowHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},design:{type:"sap.ui.commons.RowRepeaterDesign",group:"Appearance",defaultValue:u.Standard},threshold:{type:"int",defaultValue:null}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.core.Control",multiple:true,singularName:"row",bindable:"bindable"},title:{type:"sap.ui.core.Title",multiple:false},filters:{type:"sap.ui.commons.RowRepeaterFilter",multiple:true,singularName:"filter"},sorters:{type:"sap.ui.commons.RowRepeaterSorter",multiple:true,singularName:"sorter"},noData:{type:"sap.ui.core.Control",multiple:false},filterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},sorterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},headerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerPager:{type:"sap.ui.commons.Paginator",multiple:false,visibility:"hidden"}},events:{filter:{parameters:{filterId:{type:"string"}}},sort:{parameters:{sorterId:{type:"string"}}},page:{parameters:{currentPage:{type:"int"},previousPage:{type:"int"}}},resize:{parameters:{numberOfRows:{type:"int"},previousNumberOfRows:{type:"int"}}}}}});p.prototype.bPagingMode=true;p.prototype.bShowAnimation=true;p.SHOW_MORE="show_more";p.RESIZE="resize";p.FIRST_PAGE="first_page";p.LAST_PAGE="last_page";p.PREVIOUS_PAGE="previous_page";p.NEXT_PAGE="next_page";p.GOTO_PAGE="goto_page";p.prototype.init=function(){var t=this.getId();this.oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.sCurrentAnimation=null;this.aAnimationQueue=[];this.aRemoveBuffer=[];this.iPreviousPage=this.getCurrentPage();this.iPreviousNumberOfRows=this.getNumberOfRows();this.setAggregation("filterToolbar",new r(t+"-ftb",{standalone:false,design:h.Transparent}));this.setAggregation("sorterToolbar",new r(t+"-stb",{standalone:false}));var e=new s(t+"-fp",{page:[this.paging,this]});this.setAggregation("footerPager",e);var i=this.oResourceBundle.getText("SHOW_MORE");this.setAggregation("headerShowMoreButton",new o(t+"-hsm",{text:i,tooltip:i,press:[this.triggerShowMore,this]}));this.setAggregation("footerShowMoreButton",new o(t+"-fsm",{text:i,tooltip:i,press:[this.triggerShowMore,this]}));this._bSecondPage=false};p.prototype.triggerShowMore=function(){if(this.getShowMoreSteps()<=0){return this}var t=this.getShowMoreSteps();var e=this.getNumberOfRows();var i=Math.min(this._getRowCount(),e+t);if(e===i){return this}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.SHOW_MORE,animationFunction:this.triggerShowMore,args:arguments});return this}else{this.sCurrentAnimation=p.SHOW_MORE}this.iPreviousNumberOfRows=e;this.setProperty("numberOfRows",i,true);this.startResizeAnimation()}else{this.setNumberOfRows(i)}this.fireResize({numberOfRows:i,previousNumberOfRows:e});return this};p.prototype.resize=function(t){if(this.getShowMoreSteps()<=0){return this}var e=this.getNumberOfRows();if(t<=0||t>this._getRowCount()||t===e){return this}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.RESIZE,animationFunction:this.resize,args:arguments});return this}else{this.sCurrentAnimation=p.RESIZE}this.iPreviousNumberOfRows=e;this.setProperty("numberOfRows",t,true);this.startResizeAnimation()}else{this.setNumberOfRows(t)}this.fireResize({numberOfRows:t,previousNumberOfRows:e});return this};p.prototype.applyFilter=function(t){var e=this.getFilters();var i=this.getBinding("rows");var r,s;if(e.length===0||i===null){return this}for(s=0;s<e.length;s++){if(e[s].getId()===t){r=e[s];break}}if(r){i.filter(r.getFilters(),n.Control);this.fireFilter({filterId:t});this.firstPage()}return this};p.prototype.triggerSort=function(t){var e=this.getSorters();var i=this.getBinding("rows");var r,s;if(e.length===0||i===null){return this}for(s=0;s<e.length;s++){if(e[s].getId()===t){r=e[s];break}}if(r){i.sort(r.getSorter());this.fireSort({sorterId:t});this.firstPage()}return this};p.prototype.firstPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();if(t===1){return this}this.getAggregation("footerPager").setCurrentPage(1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.FIRST_PAGE,animationFunction:this.firstPage,args:arguments});return this}else{this.sCurrentAnimation=p.FIRST_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",1,true);this.startPagingAnimation()}else{this.setCurrentPage(1)}this.firePage({currentPage:1,previousPage:t});return this};p.prototype.lastPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();var e=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(t===e){return this}this.getAggregation("footerPager").setCurrentPage(e);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.LAST_PAGE,animationFunction:this.lastPage,args:arguments});return this}else{this.sCurrentAnimation=p.LAST_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",e,true);this.startPagingAnimation()}else{this.setCurrentPage(e)}this.firePage({currentPage:e,previousPage:t});return this};p.prototype.previousPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();if(t<=1){return this}this.getAggregation("footerPager").setCurrentPage(t-1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.PREVIOUS_PAGE,animationFunction:this.previousPage,args:arguments});return this}else{this.sCurrentAnimation=p.PREVIOUS_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",t-1,true);this.startPagingAnimation()}else{this.setCurrentPage(t-1)}this.firePage({currentPage:t-1,previousPage:t});return this};p.prototype.nextPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();var e=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(t>=e){return this}this.getAggregation("footerPager").setCurrentPage(t+1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.NEXT_PAGE,animationFunction:this.nextPage,args:arguments});return this}else{this.sCurrentAnimation=p.NEXT_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",t+1,true);this.startPagingAnimation()}else{this.setCurrentPage(t+1)}this.firePage({currentPage:t+1,previousPage:t});return this};p.prototype.gotoPage=function(t){if(this.getShowMoreSteps()>0){return this}var e=this.getCurrentPage();var i=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(t<1||t>i||e===t){return this}this.getAggregation("footerPager").setCurrentPage(t);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.GOTO_PAGE,animationFunction:this.gotoPage,args:arguments});return this}else{this.sCurrentAnimation=p.GOTO_PAGE}this.iPreviousPage=e;this.setProperty("currentPage",t,true);this.startPagingAnimation()}else{this.setCurrentPage(t)}this.firePage({currentPage:t,previousPage:e});return this};p.prototype.setNumberOfRows=function(t){this.setProperty("numberOfRows",t);if(this.getBinding("rows")){this.updateRows(true)}this.updateChildControls();return this};p.prototype.setCurrentPage=function(t){if(this.getCurrentPage()!=t){this.setProperty("currentPage",t);if(this.getBinding("rows")){this.updateRows(true)}this.updateChildControls()}return this};p.prototype.setShowMoreSteps=function(t){var e=t>0?false:true,i=this.getBinding("rows");if(e!==this.bPagingMode){this.bPagingMode=e;this.setCurrentPage(1)}this.setProperty("showMoreSteps",t);if(i){this._bSecondPage=false;this.updateRows(true)}return this};p.prototype.insertRow=function(t,e){this.insertAggregation("rows",t,e);this.updateChildControls();return this};p.prototype.addRow=function(t){this.addAggregation("rows",t);this.updateChildControls();return this};p.prototype.removeRow=function(t){this.removeAggregation("rows",t);this.updateChildControls();return this};p.prototype.removeAllRows=function(){this.removeAllAggregation("rows");this.updateChildControls();return this};p.prototype.destroyRows=function(){this.destroyAggregation("rows");this.updateChildControls();return this};p.prototype.setThreshhold=function(t){this.setProperty("threshold",t,true);return this};p.prototype.insertFilter=function(t,e){var i=this.getAggregation("filterToolbar");var r=t.getId();var s=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.applyFilter(r)},this]});i.insertItem(s,e);this.insertAggregation("filters",t,e);return this};p.prototype.addFilter=function(t){var e=this.getAggregation("filterToolbar");var i=t.getId();var r=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.applyFilter(i)},this]});e.addItem(r);this.addAggregation("filters",t);return this};p.prototype.removeFilter=function(t){var e=this.getAggregation("filterToolbar");e.removeItem(t);return this.removeAggregation("filters",t)};p.prototype.removeAllFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();return this.removeAllAggregation("filters")};p.prototype.destroyFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();this.destroyAggregation("filters");return this};p.prototype.insertSorter=function(t,e){var i=this.getAggregation("sorterToolbar");var r=t.getId();var s=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.triggerSort(r)},this]});i.insertItem(s,e);this.insertAggregation("sorters",t,e);return this};p.prototype.addSorter=function(t){var e=this.getAggregation("sorterToolbar");var i=t.getId();var r=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.triggerSort(i)},this]});e.addItem(r);this.addAggregation("sorters",t);return this};p.prototype.removeSorter=function(t){var e=this.getAggregation("sorterToolbar");e.removeItem(t);return this.removeAggregation("sorters",t)};p.prototype.removeAllSorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();return this.removeAllAggregation("sorters")};p.prototype.destroySorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();this.destroyAggregation("sorters");return this};p.prototype.startPagingAnimation=function(){var t=sap.ui.getCore(),e=t.getRenderManager(),i=this.getId(),r=this.iPreviousPage,s=this.getCurrentPage(),o=this.getNumberOfRows(),n=(s-1)*o,g=this.getRows(),h=this._getRowCount()>o*s?o:this._getRowCount()-o*(s-1),u,p=this.getBinding("rows");var l,f=this.$("page_"+r),m=this.getDomRef("body"),d=jQuery(m);d.css("height",d.outerHeight());var P;if(sap.ui.getCore()&&a&&a.getRTL()){P=s<r?"left":"right"}else{P=s<r?"right":"left"}if(p){this._bSecondPage=!this._bSecondPage;this.updateRows(true);g=this.getRows();n=(this._bSecondPage?1:0)*o}var w='"top:-'+f.outerHeight(true)+"px;"+P+":"+f.outerWidth(true)+'px;"';jQuery('<ul id="'+i+"-page_"+s+'" class="sapUiRrPage" style='+w+"></ul>").appendTo(m);var c=m.lastChild;var v=jQuery(c);for(u=n;u<n+h;u++){jQuery('<li id="'+i+"-row_"+u+'" class="sapUiRrRow"></li>').appendTo(c);l=c.lastChild;e.render(g[u],l)}if(P==="right"){f.animate({right:-f.outerWidth(true)},"slow");v.animate({right:0},"slow")}else{f.animate({left:-f.outerWidth(true)},"slow");v.animate({left:0},"slow")}d.animate({height:v.outerHeight(true)},"slow",jQuery.proxy(this.endPagingAnimation,this))};p.prototype.endPagingAnimation=function(){var t=this.getDomRef("body");var e=this.getDomRef("page_"+this.iPreviousPage);var i=this.getDomRef("page_"+this.getCurrentPage());var r=jQuery(i);jQuery(t).css("height","");jQuery(e).remove();var s;if(sap.ui.getCore()&&a&&a.getRTL()){s=this.getCurrentPage()<this.iPreviousPage?"left":"right"}else{s=this.getCurrentPage()<this.iPreviousPage?"right":"left"}r.css("top","");r.css(s,"");this.sCurrentAnimation=null;this.nextQueuedAnimation()};p.prototype.startResizeAnimation=function(){var t=sap.ui.getCore().getRenderManager(),e=this.getNumberOfRows(),i=this.iPreviousNumberOfRows,r=this.getId(),s=0,o,n=this.getBinding("rows");var a,g=this.getDomRef("body"),h=jQuery(g),u=this.getDomRef("page_"+this.getCurrentPage());h.css("height",h.outerHeight());if(n){this.updateRows(true)}o=this.getRows();if(e>i){for(var p=i;p<e;p++){jQuery('<li id="'+r+"-row_"+p+'" class="sapUiRrRow"></li>').appendTo(u);a=u.lastChild;t.render(o[p],a)}}else{for(var p=e;p<i;p++){a=this.getDomRef("row_"+p);s-=jQuery(a).outerHeight(true);this.aRemoveBuffer.push(a)}}h.animate({height:jQuery(u).outerHeight(true)+s},"slow",jQuery.proxy(this.endResizeAnimation,this))};p.prototype.endResizeAnimation=function(){var t=this.getDomRef("body");while(this.aRemoveBuffer.length>0){jQuery(this.aRemoveBuffer.pop()).remove()}jQuery(t).css("height","");this.sCurrentAnimation=null;this.nextQueuedAnimation()};p.prototype.nextQueuedAnimation=function(){var t,e;var i=1;var r=this.aAnimationQueue;var s,o;if(r.length>0){t=r.shift()}if(t&&r.length>0){while(r[0]&&r[0].name===t.name){i++;e=r.shift()}if(i>0){switch(t.name){case p.SHOW_MORE:o=Math.min(this._getRowCount(),this.getNumberOfRows()+this.getShowMoreSteps()*i);t={name:p.RESIZE,animationFunction:this.resize,args:[o]};break;case p.RESIZE:t=e;break;case p.FIRST_PAGE:break;case p.LAST_PAGE:break;case p.PREVIOUS_PAGE:s=Math.max(1,this.getCurrentPage()-i);t={name:p.GOTO_PAGE,animationFunction:this.gotoPage,args:[s]};break;case p.NEXT_PAGE:s=Math.min(Math.ceil(this._getRowCount()/this.getNumberOfRows()),this.getCurrentPage()+i);t={name:p.GOTO_PAGE,animationFunction:this.gotoPage,args:[s]};break;case p.GOTO_PAGE:t=e;break}}}if(t){t.animationFunction.apply(this,t.args)}};p.prototype.paging=function(t){switch(t.getParameter("type")){case g.First:this.firstPage();break;case g.Last:this.lastPage();break;case g.Previous:this.previousPage();break;case g.Next:this.nextPage();break;case g.Goto:this.gotoPage(t.getParameter("targetPage"));break}};p.prototype.updateChildControls=function(){var t,e;var i;if(this.bPagingMode){var r=this.getCurrentPage();var s=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(this._getRowCount()==0){s=1}e=this.getAggregation("footerPager");if(e){e.setCurrentPage(r);e.setNumberOfPages(s)}}else{i=this._getRowCount()>this.getNumberOfRows();t=this.getAggregation("headerShowMoreButton");if(t){t.setEnabled(i)}t=this.getAggregation("footerShowMoreButton");if(t){t.setEnabled(i)}}};p.prototype.isBound=function(t){return e.prototype.isBound.call(this,t||"rows")};p.prototype._getRowCount=function(){var t=this.getBinding("rows");if(t){return t.getLength()}else{return this.getRows().length}};p.prototype.unbindAggregation=function(t){e.prototype.unbindAggregation.apply(this,arguments);if(t==="rows"){this.destroyRows()}return this};p.prototype.refreshRows=function(){var t=this.getBindingInfo("rows"),e=t.binding,i=this._getRowCount(),r=this.getNumberOfRows(),s=Math.min(i,r),o=this.getThreshold();this.setProperty("currentPage",1,true);e.getContexts(0,s,o)};p.prototype.updateRows=function(t){var e=this.getBindingInfo("rows"),i=e.factory,r=e.binding,s=this.getShowMoreSteps(),o=s>0,n=this.getCurrentPage(),a=this._getRowCount(),g=this.getNumberOfRows(),h=Math.min(a,g),u=Math.ceil(a/g)||1;if(n>u){n=u;this.setProperty("currentPage",n);this._bSecondPage=false}var p=o?0:(n-1)*h,l=(this._bSecondPage?1:0)*h,f=this.getThreshold(),m=r?r.getContexts(p,h,f):[];if(t!==true){this._bSecondPage=false;this.destroyRows();for(var d=0,P=h;d<P;d++){var w=this.getId()+"-"+d,c=i(w,m[d]);c.setBindingContext(m[d],e.model);this.addRow(c)}}else{this._bSuppressInvalidate=true;for(var d=0,P=h;d<P;d++){var v=l+d;var R=this.getRows()[v];if(!o){if(R){this.removeAggregation("rows",R,true);R.destroy()}R=undefined}if(!R){var w=this.getId()+"-"+v;R=i(w,m[d]);R.setBindingContext(m[d],e.model);this.insertAggregation("rows",R,v,true)}else{R.setBindingContext(m[d],e.model)}}this._bSuppressInvalidate=false}this.updateChildControls()};p.prototype.invalidate=function(t){if(this._bSuppressInvalidate){return}e.prototype.invalidate.apply(this,arguments)};return p});
//# sourceMappingURL=RowRepeater.js.map