/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./ComboBox","./ComboBoxRenderer","./ListBox","./TextField","./TextFieldRenderer","./library","sap/ui/core/Control","sap/ui/core/History","sap/ui/core/Renderer","./SearchFieldRenderer","sap/ui/core/library","./Button","sap/ui/Device","sap/ui/core/SeparatorItem","sap/ui/core/ListItem","sap/ui/events/KeyCodes","sap/ui/dom/containsOrEquals","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/getSelectedText"],function(jQuery,e,t,i,r,s,a,o,n,u,l,h,g,p,c,d,f,b,y){"use strict";var _=h.TextAlign;var m=h.ValueState;var v=o.extend("sap.ui.commons.SearchField",{metadata:{deprecated:true,interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",properties:{enableListSuggest:{type:"boolean",group:"Behavior",defaultValue:true},showListExpander:{type:"boolean",group:"Behavior",defaultValue:true},enableClear:{type:"boolean",group:"Behavior",defaultValue:false},showExternalButton:{type:"boolean",group:"Behavior",defaultValue:false},enableCache:{type:"boolean",group:"Behavior",defaultValue:true},enableFilterMode:{type:"boolean",group:"Behavior",defaultValue:false},value:{type:"string",group:"Data",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:m.None},placeholder:{type:"string",group:"Appearance",defaultValue:""},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:_.Begin},visibleItemCount:{type:"int",group:"Behavior",defaultValue:20},startSuggestion:{type:"int",group:"Behavior",defaultValue:3},maxSuggestionItems:{type:"int",group:"Behavior",defaultValue:10},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},aggregations:{searchProvider:{type:"sap.ui.core.search.SearchProvider",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{search:{parameters:{query:{type:"string"}}},suggest:{parameters:{value:{type:"string"}}}}}});var S=20;v.prototype.init=function(){I(this,this.getEnableListSuggest());this._oHistory=new n(this.getId());this._clearTooltipText=C("SEARCHFIELD_CLEAR_TOOLTIP")};v.prototype.exit=function(){if(this._ctrl){this._ctrl.destroy()}if(this._lb){this._lb.destroy()}if(this._btn){this._btn.destroy()}this._ctrl=null;this._lb=null;this._btn=null;this._oHistory=null};v.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};v.prototype.onAfterRendering=function(){if(this.getShowExternalButton()){var e=this._btn.$().outerWidth(true);this._ctrl.$().css(y.getRTL()?"left":"right",e+"px")}E(this)};v.prototype.getFocusDomRef=function(){return this._ctrl.getFocusDomRef()};v.prototype.getIdForLabel=function(){return this._ctrl.getId()+"-input"};v.prototype.onpaste=function(e){var t=this;setTimeout(function(){t._ctrl._triggerValueHelp=true;t._ctrl.onkeyup()},0)};v.prototype.oncut=v.prototype.onpaste;v.prototype.fireSearch=function(e){var t=jQuery(this._ctrl.getInputDomRef()).val();if(!this.getEditable()||!this.getEnabled()){return this}this.setValue(t);if(!t&&!this.getEnableFilterMode()){return this}if(!e){e={}}if(!e.noFocus){t=this.getValue();this.focus();if(t&&this.getMaxHistoryItems()>0){this._oHistory.add(t)}this.fireEvent("search",{query:t})}return this};v.prototype.hasListExpander=function(){return x()?false:this.getShowListExpander()};v.prototype.clearHistory=function(){this._oHistory.clear()};v.prototype.suggest=function(e,t){if(!this.getEnableListSuggest()||!e||!t){return}this._ctrl.updateSuggestions(e,t)};v.prototype.setEnableListSuggest=function(e){if(this.getEnableListSuggest()&&e||!this.getEnableListSuggest()&&!e){return this}I(this,e);this.setProperty("enableListSuggest",e);return this};v.prototype.getValue=function(){return A(this,"Value")};v.prototype.setValue=function(e){var t=P(this,"Value",e,!!this.getDomRef(),true);if(this.getEnableClear()&&this.getDomRef()){this.$().toggleClass("sapUiSearchFieldVal",!!e);E(this)}return t};v.prototype.setEnableCache=function(e){return this.setProperty("enableCache",e,true)};v.prototype.getEnabled=function(){return A(this,"Enabled")};v.prototype.setEnabled=function(e){if(this._btn){this._btn.setEnabled(e&&this.getEditable())}return P(this,"Enabled",e,false,true)};v.prototype.getEditable=function(){return A(this,"Editable")};v.prototype.setEditable=function(e){if(this._btn){this._btn.setEnabled(e&&this.getEnabled())}return P(this,"Editable",e,false,true)};v.prototype.getMaxLength=function(){return A(this,"MaxLength")};v.prototype.setMaxLength=function(e){return P(this,"MaxLength",e,false,true)};v.prototype.getValueState=function(){return A(this,"ValueState")};v.prototype.setValueState=function(e){return P(this,"ValueState",e,false,true)};v.prototype.getPlaceholder=function(){return A(this,"Placeholder")};v.prototype.setPlaceholder=function(e){return P(this,"Placeholder",e,false,true)};v.prototype.getTextAlign=function(){return A(this,"TextAlign")};v.prototype.setTextAlign=function(e){return P(this,"TextAlign",e,false,true)};v.prototype.getTooltip=function(){return A(this,"Tooltip")};v.prototype.setTooltip=function(e){return P(this,"Tooltip",e,true,false)};v.prototype.getVisibleItemCount=function(){return A(this,"MaxPopupItems")};v.prototype.setVisibleItemCount=function(e){return P(this,"MaxPopupItems",e,false,true)};v.prototype.setShowExternalButton=function(e){if(!this._btn){var t=this;this._btn=new g(this.getId()+"-btn",{text:C("SEARCHFIELD_BUTTONTEXT"),enabled:this.getEditable()&&this.getEnabled(),press:function(){t.fireSearch()}});this._btn.setParent(this)}this.setProperty("showExternalButton",e);return this};v.prototype.getAriaDescribedBy=function(){return this._ctrl.getAriaDescribedBy()};v.prototype.getAriaLabelledBy=function(){return this._ctrl.getAriaLabelledBy()};v.prototype.removeAllAriaDescribedBy=function(){return this._ctrl.removeAllAriaDescribedBy()};v.prototype.removeAllAriaLabelledBy=function(){return this._ctrl.removeAllAriaLabelledBy()};v.prototype.removeAriaDescribedBy=function(e){return this._ctrl.removeAriaDescribedBy(e)};v.prototype.removeAriaLabelledBy=function(e){return this._ctrl.removeAriaLabelledBy(e)};v.prototype.addAriaDescribedBy=function(e){this._ctrl.addAriaDescribedBy(e);return this};v.prototype.addAriaLabelledBy=function(e){this._ctrl.addAriaLabelledBy(e);return this};var E=function(e){var t=e.$(),i=e._ctrl.$("searchico");if(t.hasClass("sapUiSearchFieldClear")&&t.hasClass("sapUiSearchFieldVal")){i.attr("title",e._clearTooltipText)}else{i.removeAttr("title")}};var P=function(e,t,i,r,s){var a=A(e,t);e._ctrl["set"+t](i);if(!r){e.invalidate()}if(s){e.updateModelProperty(t.toLowerCase(),i,a)}return e};var A=function(e,t){return e._ctrl["get"+t]()};var I=function(e,t){if(!e._lb){e._lb=new i(e.getId()+"-lb")}var r=e._ctrl;var s=null;if(t){s=new v.CB(e.getId()+"-cb",{listBox:e._lb,maxPopupItems:S});s.addDependent(e._lb)}else{s=new v.TF(e.getId()+"-tf")}s.setParent(e);s.addEventDelegate({onAfterRendering:function(){E(e);var t=jQuery(s.getFocusDomRef());var i=t.attr("aria-labelledby")||"";if(i){i=" "+i}t.attr("aria-labelledby",e.getId()+"-label"+i)}});if(r){s.setValue(r.getValue());s.setEnabled(r.getEnabled());s.setEditable(r.getEditable());s.setMaxLength(r.getMaxLength());s.setValueState(r.getValueState());s.setPlaceholder(r.getPlaceholder());s.setTextAlign(r.getTextAlign());s.setTooltip(r.getTooltip());s.setMaxPopupItems(r.getMaxPopupItems());var a=r.getAriaDescribedBy();for(var o=0;o<a.length;o++){s.addAriaDescribedBy(a[o])}r.removeAllAriaDescribedBy();a=r.getAriaLabelledBy();for(var o=0;o<a.length;o++){s.addAriaLabelledBy(a[o])}r.removeAllAriaLabelledBy();r.removeAllDependents();r.destroy()}e._ctrl=s};var C=function(e,t){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(i){return i.getText(e,t)}return e};var x=function(){return p.browser.mobile&&!p.system.desktop};var V=function(e,t){e.write("<div");e.writeAttributeEscaped("id",t.getId()+"-searchico");e.writeAttribute("unselectable","on");if(y.getAccessibility()){e.writeAttribute("role","presentation")}e.addClass("sapUiSearchFieldIco");e.writeClasses();e.write("></div>")};r.extend("sap.ui.commons.SearchField.TF",{metadata:{library:"sap.ui.commons"},constructor:function(e,t){r.apply(this,arguments)},getInputDomRef:function(){return this.getDomRef("input")},onkeyup:function(e){v.CB.prototype.onkeyup.apply(this,arguments)},_triggerSuggest:function(e){this._sSuggest=null;if(e&&e.length>=this.getParent().getStartSuggestion()||!e&&this.getParent().getStartSuggestion()==0){this.getParent().fireSuggest({value:e})}},_checkChange:function(e,t){this.getParent().fireSearch({noFocus:t})},onsapfocusleave:function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur&&e.relatedControlId!=this.getId()){this.getRenderer().onblur(this)}this._checkChange(e,true)},onclick:function(e){if(e.target===this.getDomRef("searchico")){if(this.oPopup&&this.oPopup.isOpen()){this.oPopup.close()}if(this.getEditable()&&this.getEnabled()){this.focus()}if(!this.getParent().getEnableClear()){this._checkChange(e)}else{if(!jQuery(this.getInputDomRef()).val()||!this.getEditable()||!this.getEnabled()){return}this.setValue("");this._triggerValueHelp=true;this.onkeyup();if(this.getParent().getEnableFilterMode()){jQuery(this.getInputDomRef()).val("");this.getParent().fireSearch()}}}},getMaxPopupItems:function(){return this._iVisibleItemCount?this._iVisibleItemCount:S},setMaxPopupItems:function(e){this._iVisibleItemCount=e},renderer:{renderOuterContentBefore:V,renderOuterAttributes:function(e,t){e.addClass("sapUiSearchFieldTf")},renderInnerAttributes:function(e,t){if(!p.os.ios){e.writeAttribute("type","search")}if(x()){e.writeAttribute("autocapitalize","off");e.writeAttribute("autocorrect","off")}}}});v.TF.prototype.getFocusDomRef=v.TF.prototype.getInputDomRef;e.extend("sap.ui.commons.SearchField.CB",{metadata:{library:"sap.ui.commons"},constructor:function(t,i){e.apply(this,arguments);this._mSuggestions={};this._aSuggestValues=[];this.mobile=false},updateSuggestions:function(e,t){this._mSuggestions[e]=t;if(this.getInputDomRef()&&jQuery(this.getInputDomRef()).val()===e&&this._hasSuggestValue(e)){this._doUpdateList(e)}},applyFocusInfo:function(e){jQuery(this.getInputDomRef()).val(e.sTypedChars);return this},_getListBox:function(){return this.getParent()._lb},_hasSuggestValue:function(e){return this._aSuggestValues.length>0&&e==this._aSuggestValues[this._aSuggestValues.length-1]},_doUpdateList:function(e,t){var i=this._updateList(e);this._aSuggestValues=[e];if((!this.oPopup||!this.oPopup.isOpen())&&!t&&!i){this._open()}else if(this.oPopup&&this.oPopup.isOpen()&&i){this._close()}if(!i&&!this._lastKeyIsDel&&e===jQuery(this.getInputDomRef()).val()){this._doTypeAhead()}},onclick:function(t){e.prototype.onclick.apply(this,arguments);if(t.target===this.getDomRef("searchico")){if(this.oPopup&&this.oPopup.isOpen()){this.oPopup.close()}if(!this.getParent().getEnableClear()){this.getParent().fireSearch()}else if(jQuery(this.getInputDomRef()).val()&&this.getEditable()&&this.getEnabled()){this.setValue("");this._triggerValueHelp=true;this.onkeyup();this._aSuggestValues=[];if(this.getParent().getEnableFilterMode()){jQuery(this.getInputDomRef()).val("");this.getParent().fireSearch()}}if(this.getEditable()&&this.getEnabled()){this.focus()}}else if(b(this.getDomRef("providerico"),t.target)){if(this.getEditable()&&this.getEnabled()){this.focus()}}},onkeypress:v.TF.prototype.onkeypress,onkeyup:function(t){var i=jQuery(this.getInputDomRef());var r=i.val();this.getParent().$().toggleClass("sapUiSearchFieldVal",!!r);E(this.getParent());if(t){if(t.keyCode===f.F2){var s=jQuery(this.getFocusDomRef());var a=s.data("sap.InNavArea");if(typeof a==="boolean"){s.data("sap.InNavArea",!a)}}if(e._isHotKey(t)||t.keyCode===f.F4&&t.which===0){return}if(r&&r==i.getSelectedText()){return}var o=t.which||t.keyCode;if(o!==f.ESCAPE||this instanceof v.TF){this._triggerValueHelp=true;this._lastKeyIsDel=o==f.DELETE||o==f.BACKSPACE}}if(this._triggerValueHelp){this._triggerValueHelp=false;if(this._sSuggest){clearTimeout(this._sSuggest);this._sSuggest=null}var n=jQuery(this.getInputDomRef()).val();if(n&&n.length>=this.getParent().getStartSuggestion()||!n&&this.getParent().getStartSuggestion()==0){this._sSuggest=setTimeout(function(){this._triggerSuggest(n)}.bind(this),200)}else if(this._doUpdateList){this._doUpdateList(n,true)}}},_triggerSuggest:function(e){this._sSuggest=null;if(!this._mSuggestions[e]||!this.getParent().getEnableCache()){this._aSuggestValues.push(e);var t=this.getParent().getSearchProvider();if(t){var i=this.getParent();t.suggest(e,function(e,t){if(i){i.suggest(e,t)}})}else{this.getParent().fireSuggest({value:e})}}else{this._doUpdateList(e)}},_updateList:function(e){var t=false;var i=this._getListBox();i.destroyAggregation("items",true);var r=function(e,t,i,r){t=t?t:[];var s=Math.min(t.length,i);if(r&&s>0){e.addItem(new c)}for(var a=0;a<s;a++){e.addItem(new d({text:t[a]}))}return s};var s=r(i,this.getParent()._oHistory.get(e),this.getParent().getMaxHistoryItems(),false);var a=r(i,e&&e.length>=this.getParent().getStartSuggestion()?this._mSuggestions[e]:[],this.getParent().getMaxSuggestionItems(),s>0);if(s<=0&&a==0){i.addItem(new d({text:C("SEARCHFIELD_NO_ITEMS"),enabled:false}));t=true}var o=i.getItems().length;var n=this.getMaxPopupItems();i.setVisibleItems(n<o?n:o);i.setSelectedIndex(-1);i.setMinWidth(jQuery(this.getDomRef()).rect().width+"px");i.rerender();return t},_prepareOpen:function(){},_open:function(){e.prototype._open.apply(this,[0])},_rerenderListBox:function(){return this._updateList(this._aSuggestValues.length>0?this._aSuggestValues[this._aSuggestValues.length-1]:null)&&!this._forceOpen},_checkChange:function(e,t,i){this.getParent().fireSearch({noFocus:i})},onsapfocusleave:function(e){if(e.relatedControlId===this._getListBox().getId()){this.focus();return}this._checkChange(e,true,true)},onfocusout:function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this)}this._checkChange(e,true,true)},onsapshow:function(t){if(this.getParent().hasListExpander()){e.prototype.onsapshow.apply(this,arguments)}else{t.preventDefault();t.stopImmediatePropagation()}},_handleSelect:function(t){var i=e.prototype._handleSelect.apply(this,arguments);if(i&&i.getEnabled()){this.getParent().fireSearch()}},renderer:{renderOuterContentBefore:function(e,i){if(i.getParent().hasListExpander()){t.renderOuterContentBefore.apply(this,arguments)}V.apply(this,arguments);if(i.getParent().getSearchProvider()&&i.getParent().getSearchProvider().getIcon()){e.write("<div");e.writeAttributeEscaped("id",i.getId()+"-providerico");e.writeAttribute("unselectable","on");if(y.getAccessibility()){e.writeAttribute("role","presentation")}e.addClass("sapUiSearchFieldProvIco");e.writeClasses();e.write('><img src="'+i.getParent().getSearchProvider().getIcon()+'"></div>')}},renderOuterAttributes:function(e,i){t.renderOuterAttributes.apply(this,arguments);e.addClass("sapUiSearchFieldCb");if(i.getParent().getSearchProvider()&&i.getParent().getSearchProvider().getIcon()){e.addClass("sapUiSearchFieldCbProv")}},renderInnerAttributes:function(e,t){if(!p.os.ios){e.writeAttribute("type","search")}if(x()){e.writeAttribute("autocapitalize","off");e.writeAttribute("autocorrect","off")}}}});return v});
//# sourceMappingURL=SearchField.js.map