/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/base/Log","./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Icon","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","./TabStripRenderer","sap/ui/core/ResizeHandler","sap/ui/core/Title","./Tab","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/parentByAttribute","sap/ui/dom/jquery/zIndex","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(jQuery,e,t,i,s,r,a,o,n,l,h,f,p,d){"use strict";var g=i.extend("sap.ui.commons.TabStrip",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},selectedIndex:{type:"int",group:"Misc",defaultValue:0},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"tabs",aggregations:{tabs:{type:"sap.ui.commons.Tab",multiple:true,singularName:"tab"},_leftArrowControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_rightArrowControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{index:{type:"int"}}},close:{parameters:{index:{type:"int"}}}}}});g.SCROLL_SIZE=320;g.ANIMATION_DURATION=d.getAnimation()?200:0;g.SCROLL_ANIMATION_DURATION=d.getAnimation()?500:0;g.prototype.init=function(){this._bInitialized=true;this._bRtl=d.getRTL();this._iCurrentScrollLeft=0;this._iMaxOffsetLeft=null;this._scrollable=null;this._oScroller=new a(this,this.getId()+"-tablist",{horizontal:!this.getEnableTabReordering(),vertical:false,nonTouchScrolling:true});this.data("sap-ui-fastnavgroup","true",true)};g.prototype.setEnableTabReordering=function(e){this.setProperty("enableTabReordering",e,true);if(this._oScroller){this._oScroller.setHorizontal(!e)}return this};g.prototype.onBeforeRendering=function(){if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};g.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,jQuery.proxy(this._updateScrollingAppearance,this),null)}this._initItemNavigation();this._updateScrollingAppearance();this._sResizeListenerId=l.register(this.getDomRef(),jQuery.proxy(this._updateScrollingAppearance,this));var e=this.getTabs();var t=this.getSelectedIndex();var i=e[t];if(this._oScroller&&i&&i.$().length>0){if(!this._oScroller._$Container){this._oScroller.onAfterRendering()}this._scrollIntoView(i.$(),g.SCROLL_ANIMATION_DURATION)}for(var s=0;s<e.length;s++){e[s].onAfterRendering()}};g.prototype.createTab=function(e,t){var i=new h({text:e}),s=new f;s.setTitle(i);s.addContent(t);this.addTab(s);return s};g.prototype.selectTabByDomRef=function(e){var t=this.getItemIndex(e);if(t>-1){if(t!=this.getSelectedIndex()&&this.getTabs()[t].getEnabled()){var i=this.getSelectedIndex();this.setProperty("selectedIndex",t,true);this.rerenderPanel(i,true);this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex())}}};g.prototype.onsapspace=function(e){var t=e.target;this.selectTabByDomRef(t)};g.prototype.onsapspacemodifiers=g.prototype.onsapspace;g.prototype.onsapenter=g.prototype.onsapspace;g.prototype.onsapentermodifiers=g.prototype.onsapspace;g.prototype.onsapdelete=function(e){var t=e.target;var i=this.getItemIndex(t);if(i>-1&&this.getTabs()[i].getClosable()){this.fireClose({index:i})}};g.prototype.getFocusDomRef=function(){return this.getDomRef().firstChild};g.prototype.exit=function(){this._bInitialized=false;this._iCurrentScrollLeft=null;this._iMaxOffsetLeft=null;this._scrollable=null;if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}};g.prototype.getItemIndex=function(e){var t;if(!e.id||e.id.search("-close")!=-1){var i=jQuery(e).parentByAttribute("id");t=i.id}else{t=e.id}for(var s=0,r=this.getTabs();s<r.length;s++){if(t==r[s].getId()){return s}}return-1};g.prototype.removeTab=function(e){var t=e;if(typeof e=="string"){e=sap.ui.getCore().byId(e)}if(typeof e=="object"){t=this.indexOfTab(e)}var i=this.getTabs()[t];if(i.getVisible()){i.setProperty("visible",false,true);this.hideTab(t);i.setProperty("visible",true,true)}if(this.getSelectedIndex()>t){this.setProperty("selectedIndex",this.getSelectedIndex()-1,true)}return this.removeAggregation("tabs",t,true)};g.prototype.setSelectedIndex=function(e){var t=this.getSelectedIndex();if(e==t){return this}var i=this.getTabs();var s=i[e];if(this._oScroller&&s&&s.$().length>0){this._scrollIntoView(s.$(),g.SCROLL_ANIMATION_DURATION)}if(!s&&!this.getDomRef()){this.setProperty("selectedIndex",e,false)}else if(s&&s.getEnabled()&&s.getVisible()){this.setProperty("selectedIndex",e,true);if(this.getDomRef()&&!this.invalidated){this.rerenderPanel(t);if(this.oItemNavigation){var r=0;var a=-1;for(var o=0;o<i.length;o++){s=i[o];if(s.getVisible()===false){continue}if(o==e){a=r;break}r++}this.oItemNavigation.setSelectedIndex(a)}}}else{this._warningInvalidSelectedIndex(e,s)}return this};g.prototype.closeTab=function(e){var t=this.getTabs()[e];if(!t||!t.getClosable()||!t.getVisible()){return}t.setProperty("visible",false,true);this.hideTab(e)};g.prototype.hideTab=function(e){var t=this.getTabs()[e];if(!this.getDomRef()){return}var i=this.oItemNavigation.getFocusedIndex();var s=parseInt(t.$().attr("aria-posinset"))-1;var r=sap.ui.getCore().getCurrentFocusedControlId();t.$().remove();if(this.iVisibleTabs==1){this.setProperty("selectedIndex",-1,true);t.$("panel").remove()}else if(e==this.getSelectedIndex()){var a=e+1;while(a<this.getTabs().length&&(!this.getTabs()[a].getEnabled()||!this.getTabs()[a].getVisible())){a++}if(a==this.getTabs().length){a=e-1;while(a>=0&&(!this.getTabs()[a].getEnabled()||!this.getTabs()[a].getVisible())){a--}}this.setProperty("selectedIndex",a,true);this.rerenderPanel(e)}else{this.toggleTabClasses(this.getSelectedIndex(),this.getSelectedIndex())}this.iVisibleTabs--;var s=0;var o=[];var n=-1;var l=false;for(var h=0;h<this.getTabs().length;h++){var t=this.getTabs()[h];if(r==t.getId()){l=true}if(t.getVisible()===false){continue}if(h==this.getSelectedIndex()){n=s}s++;t.$().attr("aria-posinset",s).attr("aria-setsize",this.iVisibleTabs);o.push(t.getDomRef())}if(s<=i){i--}this.oItemNavigation.setItemDomRefs(o);this.oItemNavigation.setSelectedIndex(n);this.oItemNavigation.setFocusedIndex(i);if(l){this.oItemNavigation.focusItem(i)}this._updateScrollingAppearance()};g.prototype.rerenderPanel=function(e,t){var i=this.getTabs();var s=this.getSelectedIndex();var r=i[s];var a=i[e];setTimeout(function(){if(!this._bInitialized){return}var e=this.$().find(".sapUiTabPanel");if(r){if(e.length>0){var i=sap.ui.getCore().createRenderManager();this.getRenderer().renderTabContents(i,r);i.flush(e[0]);i.destroy()}var o=r.getId();e.attr("id",o+"-panel").attr("aria-labelledby",o)}else{e.empty()}a.setProperty("scrollTop",e.scrollTop(),true);a.setProperty("scrollLeft",e.scrollLeft(),true);if(r){r.onAfterRendering()}if(t){this.fireSelect({index:s})}}.bind(this),0);if(r){this.toggleTabClasses(e,s)}};g.prototype.toggleTabClasses=function(e,t){var i=this.getTabs();var s=i[e];if(s){s.$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false)}var r=e-1;while(r>=0&&!i[r].getVisible()){r--}if(r>=0){i[r].$().removeClass("sapUiTabBeforeSel")}var a=e+1;while(a<i.length&&!i[a].getVisible()){a++}if(a<i.length){i[a].$().removeClass("sapUiTabAfterSel")}s=i[t];if(s){s.$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true)}r=t-1;while(r>=0&&!i[r].getVisible()){r--}if(r>=0){i[r].$().addClass("sapUiTabBeforeSel")}a=t+1;while(a<i.length&&!i[a].getVisible()){a++}if(a<i.length){i[a].$().addClass("sapUiTabAfterSel")}};g.prototype.invalidate=function(){this.invalidated=true;i.prototype.invalidate.apply(this,arguments)};g.prototype._warningInvalidSelectedIndex=function(t,i){var s="";if(!i){s="Tab not exists"}else if(!i.getEnabled()){s="Tab disabled"}else if(!i.getVisible()){s="Tab not visible"}e.warning("SelectedIndex "+t+" can not be set",s,"sap.ui.commons.TabStrip")};g.prototype.onkeydown=function(e){if(e.which===p.ESCAPE){this._stopMoving()}};g.prototype.onclick=function(e){var t=e.target;var i=jQuery(t);if(t.className=="sapUiTabClose"){var s=this.getItemIndex(i.parentByAttribute("id"));if(s>-1){this.fireClose({index:s})}}};g.prototype.onmousedown=function(e){var t=!e.button;var i=this._isTouchMode(e);if(!i&&!t){return}var s=e.target;var r=jQuery(s);if(s.className=="sapUiTabClose"){e.preventDefault();e.stopPropagation();e.target=null;return}this.selectTabByDomRef(s);if(!this.getEnableTabReordering()){return}var a=r.closest(".sapUiTab, .sapUiTabSel, .sapUiTabDsbl");if(a.length===1){this._onTabMoveStart(a,e,i)}};g.prototype._onTabMoveStart=function(e,t,i){this._disableTextSelection();t.preventDefault();e.zIndex(this.$().zIndex()+10);var s=this.getItemIndex(t.target);var r=this.getTabs()[s];var a=this.$().find(".sapUiTabBarCnt").children();var o=jQuery.inArray(e[0],a);var n=e.outerWidth();this._dragContext={index:o,tabIndex:s,isTouchMode:i,startX:i?t.originalEvent.targetTouches[0].pageX:t.pageX,tab:r,tabWidth:n,tabCenter:e.position().left+n/2};this._aMovedTabIndexes=[];var l=jQuery(document);if(i){l.on("touchmove",jQuery.proxy(this._onTabMove,this));l.on("touchend",jQuery.proxy(this._onTabMoved,this))}else{l.on("mousemove",jQuery.proxy(this._onTabMove,this));l.on("mouseup",jQuery.proxy(this._onTabMoved,this))}};g.prototype._onTabMove=function(e){var t=this._dragContext;if(!t){return}var i=this._isTouchMode(e);if(i){e.preventDefault()}var s=i?e.targetTouches[0].pageX:e.pageX;var r=s-t.startX;t.tab.$().css({left:r});var a,o,n,l,h=this.$().find(".sapUiTabBarCnt").children(),f=this._aMovedTabIndexes,p=d.getRTL();for(var g=0;g<h.length;g++){if(g==t.index){continue}a=jQuery(h[g]);o=a.position().left;n=parseFloat(a.css("left"));if(!isNaN(n)){o-=n}if(g<t.index!=p){l=o+a.outerWidth()>t.tabCenter+r;this._onAnimateTab(a,t.tabWidth,l,f,g)}else{l=o<t.tabCenter+r;this._onAnimateTab(a,-t.tabWidth,l,f,g)}}};g.prototype._onAnimateTab=function(e,t,i,s,r){var a=jQuery.inArray(r,s);var o=a!=-1;if(i&&!o){e.stop(true,true);e.animate({left:t},g.ANIMATION_DURATION);s.push(r)}else if(!i&&o){e.stop(true,true);e.animate({left:0},g.ANIMATION_DURATION);s.splice(a,1)}};g.prototype._onTabMoved=function(e){var t=this._dragContext;if(!t){return}this._stopMoving();var i=this._aMovedTabIndexes;if(i.length==0){return}var s=t.tab.$(),r,a=this.$().find(".sapUiTabBarCnt").children();var o=i[i.length-1],n=o,l=this.getItemIndex(a[o]);this.removeAggregation("tabs",t.tab,true);this.insertAggregation("tabs",t.tab,l,true);if(o>t.index){s.insertAfter(jQuery(a[o]))}else{s.insertBefore(jQuery(a[o]))}a=this.$().find(".sapUiTabBarCnt").children();if(!t.tab.getEnabled()){for(var h=0;h<a.length;h++){r=jQuery(a[h]);if(r.hasClass("sapUiTabSel")){n=h;l=this.getItemIndex(r[0]);break}}}this.setProperty("selectedIndex",l,true);a.removeClass("sapUiTabAfterSel");a.removeClass("sapUiTabBeforeSel");for(var h=0;h<a.length;h++){r=jQuery(a[h]);r.attr("aria-posinset",h+1);if(h==n-1){r.addClass("sapUiTabBeforeSel")}else if(h==n+1){r.addClass("sapUiTabAfterSel")}}s.trigger("focus");this._initItemNavigation()};g.prototype._stopMoving=function(){var e=this._dragContext;if(!e){return}var t=e.tab.$();t.css("z-index","");var i=this.$().find(".sapUiTabBarCnt").children();i.stop(true,true);i.css("left","");this._dragContext=null;var s=jQuery(document);if(e.isTouchMode){s.off("touchmove",this._onTabMove);s.off("touchend",this._onTabMoved)}else{s.off("mousemove",this._onTabMove);s.off("mouseup",this._onTabMoved)}this._enableTextSelection()};g.prototype._isTouchMode=function(e){return!!e.originalEvent["touches"]};g.prototype._initItemNavigation=function(){var e=this.getDomRef("tablist"),t=e.childNodes,i=[],r=-1;for(var a=0;a<t.length;a++){i.push(t[a]);if(jQuery(t[a]).hasClass("sapUiTabSel")){r=a}}if(!this.oItemNavigation){this.oItemNavigation=new s;this.oItemNavigation.attachEvent(s.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.oItemNavigation.setCycling(false);this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(e);this.oItemNavigation.setItemDomRefs(i);this.oItemNavigation.setSelectedIndex(r)};g.prototype._disableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","on").addClass("sapUiTabStripNoSelection").bind("selectstart",function(e){e.preventDefault();return false})};g.prototype._enableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","off").removeClass("sapUiTabStripNoSelection").unbind("selectstart")};g.prototype._getActualSelectedIndex=function(){var e=Math.max(0,this.getSelectedIndex());var t=this.getTabs();var i=t[e];if(i&&i.getVisible()&&i.getEnabled()){return e}for(var s=0;s<t.length;s++){var r=t[s];if(r.getVisible()&&r.getEnabled()){return s}}return 0};g.prototype._getLeftArrowControl=function(){var e=this.getAggregation("_leftArrowControl");var t=this;if(!e){e=new r({src:"sap-icon://navigation-left-arrow",noTabStop:true,useIconTooltip:false,tooltip:"",press:function(e){t._scroll(-g.SCROLL_SIZE,g.SCROLL_ANIMATION_DURATION)}}).addStyleClass("sapUiTabStripScrollIcon sapUiTabStripLeftScrollIcon");this.setAggregation("_leftArrowControl",e,true)}return e};g.prototype._getRightArrowControl=function(){var e=this.getAggregation("_rightArrowControl");var t=this;if(!e){e=new r({src:"sap-icon://navigation-right-arrow",noTabStop:true,useIconTooltip:false,tooltip:"",press:function(e){t._scroll(g.SCROLL_SIZE,g.SCROLL_ANIMATION_DURATION)}}).addStyleClass("sapUiTabStripScrollIcon sapUiTabStripRightScrollIcon");this.setAggregation("_rightArrowControl",e,true)}return e};g.prototype._scroll=function(e,t){var i=this.getDomRef("scrollCont").scrollLeft,s;if(this._bRtl&&o.browser.firefox){s=i-e;if(s<-this._iMaxOffsetLeft){s=-this._iMaxOffsetLeft}if(s>0){s=0}}else{s=i+e;if(s<0){s=0}if(s>this._iMaxOffsetLeft){s=this._iMaxOffsetLeft}}if(this._oScroller){this._oScroller.scrollTo(s,0,t)}this._iCurrentScrollLeft=s};g.prototype._scrollIntoView=function(e,t){var i=this.$("tablist"),s=i.innerWidth()-i.width(),r=e.outerWidth(true),a=e.position().left-s/2,n=this.getDomRef("scrollCont"),l=n.scrollLeft,h=this.$("scrollCont").width(),f=l;if(a<0||a>h-r){if(this._bRtl&&o.browser.firefox){if(a<0){f+=a+r-h}else{f+=a}}else{if(a<0){f+=a}else{f+=a+r-h}}this._iCurrentScrollLeft=f;if(this._oScroller){this._oScroller.scrollTo(f,0,t)}}};g.prototype._hasScrolling=function(){var e=this.getDomRef("tablist"),t=this.getDomRef("scrollCont"),i=e&&e.scrollWidth>t.clientWidth;this.$().toggleClass("sapUiTabStripScrollable",i);return i};g.prototype._updateScrollingAppearance=function(){var e=this.getDomRef("tablist"),t=this.getDomRef("scrollCont"),i,s,r,a=false,n=false;if(this._hasScrolling()&&e&&t){if(this._bRtl&&o.browser.firefox){i=-t.scrollLeft}else{i=t.scrollLeft}s=e.scrollWidth;r=t.clientWidth;if(Math.abs(s-r)===1){s=r}if(i>0){a=true}if(s>r&&i+r<s){n=true}}this.$().toggleClass("sapUiTabStripScrollBack",a).toggleClass("sapUiTabStripScrollForward",n);this._iMaxOffsetLeft=Math.abs(jQuery(t).width()-jQuery(e).width())};g.prototype._onItemNavigationAfterFocus=function(e){var t=e.getParameter("index"),i=e.getParameter("event");if(!i){return}var s=jQuery(i.target);if(!s||i.keyCode===undefined){return}if(t!==null&&t!==undefined){var r=jQuery(s.parent().children()[t]);if(r&&r.length){this._scrollIntoView(r,0)}}};return g});
//# sourceMappingURL=TabStrip.js.map