/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Manifest","./ComponentHooks","./ComponentMetadata","./ElementRegistry","sap/base/config","sap/base/future","sap/base/i18n/Localization","sap/base/util/extend","sap/base/util/deepExtend","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/thirdparty/URI","sap/ui/performance/trace/Interaction","sap/ui/util/_enforceNoReturnValue","sap/base/assert","sap/base/Log","sap/base/util/Deferred","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/strings/camelize","sap/ui/core/_UrlResolver","sap/ui/VersionInfo","sap/ui/core/mvc/ViewType","sap/ui/core/ComponentRegistry","sap/ui/core/util/_LocalizationHelper"],function(e,t,n,o,i,a,r,s,u,c,f,p,d,l,g,m,h,v,y,M,_,C,w,b,S,O,E,T){"use strict";var A={lazy:"lazy",eager:"eager",waitFor:"waitFor"};function I(e){return{name:e,type:i.Type.String,external:true}}function U(e){["sap-client","sap-server"].forEach(function(t){if(!e.hasSearch(t)){var n=i.get(I(w(t)));if(n){e.addSearch(t,n)}}})}function P(e,t,n,o){if(n){for(var i in e){if(!t[i]&&n[i]&&n[i].uri){t[i]=o}}}}function j(e,t,o,i){var a=t.getEntry(o);if(a!==undefined&&!_(a)){return a}var r,s;if(i&&(r=e.getParent())instanceof n){s=r._getManifestEntry(o,i)}if(s||a){a=u({},s,a)}return a}function x(e,t){var n=Object.create(Object.getPrototypeOf(e));n._oMetadata=e;n._oManifest=t;for(var o in e){if(!/^(getManifest|_getManifest|getManifestObject|getManifestEntry|_getManifestEntry|getMetadataVersion)$/.test(o)&&typeof e[o]==="function"){n[o]=e[o].bind(e)}}n.getManifest=function(){return this._getManifest()};n.getManifestEntry=function(e,t){return this._getManifestEntry(e,t)};n._getManifest=function(){return t&&t.getJson()};n.getManifestObject=function(){return t};n._getManifestEntry=function(n,o){return j(e,t,n,o)};n.getMetadataVersion=function(){return 2};n[Symbol("isProxy")]=true;return n}let D;const k=()=>{D??=new Promise((e,t)=>{sap.ui.require(["sap/ui/core/_CommandPool"],e,t)});return D};const N=async e=>{if(e?.getEntry("/sap.ui5/commands")){const t=await k();t.resolve(e)}};const B=e=>{if(e?.getEntry("/sap.ui5/commands")){const t=sap.ui.requireSync("sap/ui/core/_CommandPool");t.resolve(e)}};var R=f.extend("sap.ui.core.Component",{constructor:function(e,t){var n=Array.prototype.slice.call(arguments);if(typeof e!=="string"){t=e;e=undefined}if(t&&typeof t._metadataProxy==="object"){this._oMetadataProxy=t._metadataProxy;this._oManifest=t._metadataProxy._oManifest;delete t._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy}}if(t&&typeof t._cacheTokens==="object"){this._mCacheTokens=t._cacheTokens;delete t._cacheTokens}if(t&&Array.isArray(t._activeTerminologies)){this._aActiveTerminologies=t._activeTerminologies;delete t._activeTerminologies}if(t&&typeof t._componentConfig==="object"){this._componentConfig=t._componentConfig;delete t._componentConfig}(()=>{this._bSyncCreation=t?._syncCreation??true;delete t?._syncCreation})();if(t&&typeof t._manifestModels==="object"){this._mManifestModels=t._manifestModels;delete t._manifestModels}else{this._mManifestModels={}}this._mServices={};this._oKeepAliveConfig=this.getManifestEntry("/sap.ui5/keepAlive");if(this._oKeepAliveConfig){this._oKeepAliveConfig.supported=!!this._oKeepAliveConfig.supported}this._bIsActive=true;this._aDestroyables=[];f.apply(this,n)},metadata:{stereotype:"component",abstract:true,specialSettings:{componentData:"any"},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},n);E.init(R);function $(e,t){o.forEach(function(n,o){var i=R.getOwnerIdFor(n);if(i===t&&!n.getParent()){e(n,o)}})}function F(e){var t,n;if(i.get({name:"sapUiXxDisableCustomizing",type:i.Type.Boolean})){return t}if(typeof e==="string"){n=e}else if(e&&typeof e.isA==="function"&&!e.isA("sap.ui.core.Component")){n=R.getOwnerIdFor(e)}else{t=e}if(n){t=R.getComponentById(n)}if(t){if(t.getExtensionComponent){t=t.getExtensionComponent();if(!t){throw new Error("getExtensionComponent() must return an instance.")}}}return t}R.getCustomizing=function(e,t){var n=t.type,o=t.name?"/"+t.name:"",i="/sap.ui5/extends/extensions/"+n+o;if(n==="sap.ui.viewExtensions"){i+="/"+t.extensionName}var a=F(e);return a?a._getManifestEntry(i,true):undefined};R.getComponentPreloadMode=function(){return i.get({name:"sapUiXxComponentPreload",type:i.Type.String,external:true})||p.getPreloadMode()};R.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata()._getManifest()}else{return this._oManifest.getJson()}};R.prototype.getManifestEntry=function(e){return this._getManifestEntry(e)};R.prototype._getManifestEntry=function(e,t){if(!this._oManifest){return this.getMetadata()._getManifestEntry(e,t)}else{return j(this.getMetadata(),this._oManifest,e,t)}};R.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject()}else{return this._oManifest}};R.prototype._isVariant=function(){if(this._oManifest){var e=this.getManifestEntry("/sap.ui5/componentName");return e&&e!==this.getManifestEntry("/sap.app/id")}else{return false}};R.activateCustomizing=function(e){};R.deactivateCustomizing=function(e){};R.getOwnerIdFor=function(e){h(e instanceof f,"oObject must be given and must be a ManagedObject");var t=e instanceof f&&e._sOwnerId;return t||undefined};R.getOwnerComponentFor=function(e){return R.getComponentById(R.getOwnerIdFor(e))};R.prototype.runAsOwner=function(e){if(!this.isActive()){throw new Error("Execute 'runAsOwner' on an inactive owner component is not supported. Component: '"+this.getMetadata().getName()+"' with id '"+this.getId()+"'.")}return f.runWithOwner(e,this.getId())};R.prototype.getInterface=function(){return this};R.prototype._initCompositeSupport=function(e){this.oComponentData=e&&e.componentData;if(this._oManifest){this._oManifest.init(this)}else{this.getMetadata().init()}if(this._isVariant()){var t=this._oManifest.getEntry("/sap.app/id");if(t){q(t,this._oManifest.resolveUri("./","manifest"))}}this.initComponentModels();(()=>{if(this.onWindowError){this._fnWindowErrorHandler=function(e){var t=e.originalEvent;this.onWindowError(t.message,t.filename,t.lineno)}.bind(this);window.addEventListener("error",this._fnWindowErrorHandler)}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=function(e){var t=this.onWindowBeforeUnload.apply(this,arguments);if(typeof t==="string"){e.returnValue=t;e.preventDefault();return t}}.bind(this);window.addEventListener("beforeunload",this._fnWindowBeforeUnloadHandler)}if(this.onWindowUnload){this._fnWindowUnloadHandler=this.onWindowUnload.bind(this);window.addEventListener("unload",this._fnWindowUnloadHandler)}})()};R.prototype._getDestroyables=function(){if(!this._aDestroyables){a.errorThrows(`${this.getManifestObject().getComponentName()}: A sub-class of sap.ui.core.Component which overrides the constructor must apply the super constructor as well.`,null,"sap.ui.support",function(){return{type:"missingSuperConstructor"}});this._aDestroyables=[]}return this._aDestroyables};R.prototype.destroy=function(){var e,t=false;for(var n in this._mServices){if(this._mServices[n].instance){this._mServices[n].instance.destroy()}}delete this._mServices;for(var o in this._mManifestModels){this._mManifestModels[o].destroy()}delete this._mManifestModels;(()=>{if(this._fnWindowErrorHandler){window.removeEventListener("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler}if(this._fnWindowBeforeUnloadHandler){window.removeEventListener("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler}if(this._fnWindowUnloadHandler){window.removeEventListener("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler}})();if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus}function i(e){if(e&&!e._bIsBeingDestroyed){e.destroy()}}function a(e){t=true}var r=this._getDestroyables();for(var s=0;s<r.length;s++){r[s]=r[s].then(i,a)}if(r.length>0){e=Promise.all(r).then(function(){if(t){$(function(e){e.destroy()},this.getId())}}.bind(this))}f.prototype.destroy.apply(this,arguments);const u=sap.ui.require("sap/ui/core/Messaging");u?.unregisterObject(this);if(this._oManifest){this._oManifest.exit(this);delete this._oManifest}else{this.getMetadata().exit()}return e};R.prototype.getComponentData=function(){return this.oComponentData};R.prototype.getEventBus=function(){if(!this._oEventBus){var e=sap.ui.require("sap/ui/core/EventBus");if(!e){var t=this.getMetadata().getName();a.warningThrows("The module 'sap/ui/core/EventBus' needs to be required before calling #getEventBus() on Component '"+t+"'.");(()=>{v.warning("Synchronous loading of EventBus, due to #getEventBus() call on Component '"+t+"'.","SyncXHR",null,function(){return{type:"SyncXHR",name:t}});e=sap.ui.requireSync("sap/ui/core/EventBus")})()}this._oEventBus=new e;if(!this.isActive()){this._oEventBus.suspend()}}return this._oEventBus};R.prototype.isActive=function(){return this._bIsActive};R.prototype.initComponentModels=function(){var e=this.getMetadata();if(e.isBaseClass()){return}var t=this._getManifestEntry("/sap.app/dataSources",true)||{};var n=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(n,t,this._mCacheTokens)};R.prototype._initComponentModels=function(e,t,n){var o=this.getManifestObject().getComponentName();var i=R._findManifestModelClasses({models:e,dataSources:t,componentName:o});if(this._bSyncCreation){R._loadManifestModelClasses(i,o,this._bSyncCreation)}var a=R._createManifestModelConfigurations({models:i,dataSources:t,component:this,mergeParent:true,cacheTokens:n,activeTerminologies:this.getActiveTerminologies()}),r={},s;if(!a){return}for(s in a){if(!this._mManifestModels[s]){r[s]=a[s]}}var u=R._createManifestModels(r,this._componentConfig,this.getManifestObject());for(s in u){this._mManifestModels[s]=u[s]}for(s in this._mManifestModels){var c=this._mManifestModels[s];this.setModel(c,s||undefined)}};R.prototype.getService=function(e){if(!this._mServices[e]){this._mServices[e]={};this._mServices[e].promise=new Promise(function(t,n){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(o){var i=this._getManifestEntry("/sap.ui5/services/"+e,true);var a=i&&i.factoryName;if(!a){n(new Error("Service "+e+" not declared!"));return}var r=o.get(a);if(r){r.createInstance({scopeObject:this,scopeType:"component",settings:i.settings||{}}).then(function(o){if(!this.bIsDestroyed){this._mServices[e].instance=o;this._mServices[e].interface=o.getInterface();t(this._mServices[e].interface)}else{n(new Error("Service "+e+" could not be loaded as its Component was destroyed."))}}.bind(this)).catch(n)}else{var s="The ServiceFactory "+a+" for Service "+e+" not found in ServiceFactoryRegistry!";var u=this._getManifestEntry("/sap.ui5/services/"+e+"/optional",true);if(!u){v.error(s)}n(new Error(s))}}.bind(this),n)}.bind(this))}return this._mServices[e].promise};function H(e,t){var n=e._getManifestEntry("/sap.ui5/services",true);var o=t?[]:null;if(!n){return o}var i=Object.keys(n);if(!t&&i.some(function(e){return n[e].startup===A.waitFor})){throw new Error('The specified component "'+e.getMetadata().getName()+'" cannot be loaded in sync mode since it has some services declared with "startup" set to "waitFor"')}return i.reduce(function(t,o){if(n[o].lazy===false||n[o].startup===A.waitFor||n[o].startup===A.eager){var i=e.getService(o);if(n[o].startup===A.waitFor){t.push(i)}}return t},o)}R.prototype.createComponent=function(e){h(typeof e==="string"&&e||typeof e==="object"&&typeof e.usage==="string"&&e.usage,"vUsage either must be a non-empty string or an object with a non-empty usage id");var t={async:true};if(e){var n;if(typeof e==="object"){n=e.usage;["id","async","settings","componentData"].forEach(function(n){if(e[n]!==undefined){t[n]=e[n]}})}else if(typeof e==="string"){n=e}t=this._enhanceWithUsageConfig(n,t)}var o=R._createComponent(t,this);if(o instanceof Promise){this.registerForDestroy(o)}return o};R.prototype._enhanceWithUsageConfig=function(e,t){var n=this.getManifestEntry("/sap.ui5/componentUsages/"+e);if(!n){throw new Error('Component usage "'+e+'" not declared in Component "'+this.getManifestObject().getComponentName()+'"!')}if(n.activeTerminologies){throw new Error("Terminologies vector can't be used in component usages")}return u(n,t)};R.prototype.getActiveTerminologies=function(){return this._aActiveTerminologies?this._aActiveTerminologies.slice():undefined};R._createComponent=function(e,t){function n(){if(e.async===true){return R.create(e)}else{return sap.ui.component(e)}}if(t){if(!t.isActive()){throw new Error("Creation of component '"+e.name+"' is not possible due to inactive owner component '"+t.getId()+"'")}return t.runAsOwner(n)}else{return n()}};R._applyCacheToken=function(e,t,n){var o=n?"Model":"DataSource";var a=n?'["sap.ui5"]["models"]':'["sap.app"]["dataSources"]';var r=n&&n["sap-language"]||e.search(true)["sap-language"];var s=n&&n["sap-client"]||e.search(true)["sap-client"];if(!r){v.warning('Component Manifest: Ignoring provided "sap-context-token='+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+"). "+'Missing "sap-language" URI parameter',a+'["'+t.dataSource+'"]',t.componentName);return}if(!s){v.warning('Component Manifest: Ignoring provided "sap-context-token='+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+"). "+'Missing "sap-client" URI parameter',a+'["'+t.dataSource+'"]',t.componentName);return}var u=i.get(I("sapClient"));if(s!==u){v.warning('Component Manifest: Ignoring provided "sap-context-token='+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+"). "+'URI parameter "sap-client='+s+'" must be identical with configuration "sap-client='+u+'"',a+'["'+t.dataSource+'"]',t.componentName);return}if(e.hasQuery("sap-context-token")&&!e.hasQuery("sap-context-token",t.cacheToken)||n&&n["sap-context-token"]&&n["sap-context-token"]!==t.cacheToken){v.warning('Component Manifest: Overriding existing "sap-context-token='+(e.query(true)["sap-context-token"]||n["sap-context-token"])+'" with provided value "'+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+").",a+'["'+t.dataSource+'"]',t.componentName)}if(n){if(e.hasQuery("sap-context-token")){v.warning('Component Manifest: Move existing "sap-context-token='+e.query(true)["sap-context-token"]+'" to metadataUrlParams for '+o+' "'+t.dataSource+'" ('+e.toString()+").",a+'["'+t.dataSource+'"]',t.componentName)}e.removeQuery("sap-context-token");n["sap-context-token"]=t.cacheToken}else{e.setQuery("sap-context-token",t.cacheToken)}};R._findManifestModelClasses=function(e){if(!e.models){return null}var t={models:e.models,dataSources:e.dataSources||{},origin:{dataSources:{},models:{}}};var n=e.componentName;var o={};for(var i in t.models){var r=t.models[i];if(typeof r==="string"){r={dataSource:r}}if(r.dataSource){var s=t.dataSources&&t.dataSources[r.dataSource];if(typeof s==="object"){if(s.type===undefined){s.type="OData"}var u;if(!r.type){switch(s.type){case"OData":u=s.settings&&s.settings.odataVersion;if(u==="4.0"){r.type="sap.ui.model.odata.v4.ODataModel"}else if(!u||u==="2.0"){r.type="sap.ui.model.odata.v2.ODataModel"}else{a.errorThrows(`${n}: Component Manifest: Provided OData version "${u}" in dataSource "${r.dataSource}" for model "${i}" is unknown. ["sap.app"]["dataSources"]["${r.dataSource}"].`,{suffix:'Falling back to default model type "sap.ui.model.odata.v2.ODataModel".'});r.type="sap.ui.model.odata.v2.ODataModel"}break;case"JSON":r.type="sap.ui.model.json.JSONModel";break;case"XML":r.type="sap.ui.model.xml.XMLModel";break;default:}}}}if(!r.type){a.errorThrows(`${n}: Component Manifest: Missing "type" for model "${i}". ["sap.ui5"]["models"]["${i}"].`);continue}o[i]=r}return o};R._createManifestModelConfigurations=function(e){var t=e.component;var o=e.manifest||t.getManifestObject();var s=e.mergeParent;var u=e.cacheTokens||{};var c=t?t.getMetadata().getComponentName():o.getComponentName();var f=e.activeTerminologies;if(!e.models){return null}var p={models:e.models,dataSources:e.dataSources||{},origin:{dataSources:{},models:{}}};if(t&&s){var d=t.getMetadata();while(d instanceof n){var g=d.getManifestObject();var m=d._getManifestEntry("/sap.app/dataSources");P(p.dataSources,p.origin.dataSources,m,g);var h=d._getManifestEntry("/sap.ui5/models");P(p.models,p.origin.models,h,g);d=d.getParent()}}var y={};for(var _ in p.models){var C=p.models[_];var w=sap.ui.require(C.type.replace(/\./g,"/"));if(!w){w=M.get(C.type)}if(!w?.getMetadata){a.errorThrows(`${c}: Component Manifest: Class "${C.type}" for model "${_}" could not be found. ["sap.ui5"]["models"]["${_}"].`);continue}var S=w.getMetadata();var O=S.isA("sap.ui.model.odata.ODataModel");var E=S.isA("sap.ui.model.odata.v2.ODataModel");var T=S.isA("sap.ui.model.odata.v4.ODataModel");var A=S.isA("sap.ui.model.resource.ResourceModel");var j=false;var x=null;if(typeof C==="string"){C={dataSource:C}}if(C.dataSource){var D=p.dataSources&&p.dataSources[C.dataSource];if(typeof D==="object"){if(D.type===undefined){D.type="OData"}if(T&&D.settings&&D.settings.odataVersion){C.settings=C.settings||{};C.settings.odataVersion=D.settings.odataVersion}if(!C.uri){C.uri=D.uri;j=true}if(D.type==="OData"&&D.settings){C.settings=C.settings||{};if(typeof D.settings.maxAge==="number"){C.settings.headers=C.settings.headers||{};C.settings.headers["Cache-Control"]="max-age="+D.settings.maxAge}if("ignoreAnnotationsFromMetadata"in D.settings){C.settings.ignoreAnnotationsFromMetadata=D.settings.ignoreAnnotationsFromMetadata}if(D.settings.annotations){var k=D.settings.annotations;for(var N=0;N<k.length;N++){var B=k[N];var $=p.dataSources[B];if(!$){a.errorThrows(`${c}: Component Manifest: ODataAnnotation "${B}" for dataSource "${C.dataSource}" could not be found in manifest. ["sap.app"]["dataSources"]["${B}"].`);continue}if($.type!=="ODataAnnotation"){a.errorThrows(`${c}: Component Manifest: dataSource "${B}" was expected to have type "ODataAnnotation" but was "${$.type}". ["sap.app"]["dataSources"]["${B}"].`);continue}if(!$.uri){a.errorThrows(`${c}: Component Manifest: Missing "uri" for ODataAnnotation "${B}". ["sap.app"]["dataSources"]["${B}"].`);continue}var F=new l($.uri);if(E||T){var H=r.getSAPLogonLanguage();if(!F.hasQuery("sap-language")&&H){F.setQuery("sap-language",H)}H=i.get(I("sapClient"));if(!F.hasQuery("sap-client")&&H){F.setQuery("sap-client",H)}var L=u.dataSources&&u.dataSources[$.uri];if(L){R._applyCacheToken(F,{cacheToken:L,componentName:c,dataSource:B})}}var W=p.origin.dataSources[k[N]]||o;var q=W.resolveUri(F.toString());C.settings.annotationURI=C.settings.annotationURI||[];C.settings.annotationURI.push(q)}}}}else{a.errorThrows(`${c}: Component Manifest: dataSource "${C.dataSource}" for model "${_}" not found or invalid. ["sap.app"]["dataSources"]["${C.dataSource}"].`);continue}}if(O&&(!C.settings||C.settings.json===undefined)){C.settings=C.settings||{};C.settings.json=true}if(A){if(C.uri&&C.settings&&C.settings.bundleUrl){v.warning("Defining both model uri and bundleUrl is not supported. Only model uri will be resolved.")}if(!C.uri&&C.settings&&C.settings.terminologies){if(C.bundleUrl||C.settings.bundleUrl){C.uri=C.bundleUrl||C.settings.bundleUrl;delete C.settings.bundleUrl}}}if(C.uri){var z=new l(C.uri);var J=(j?p.origin.dataSources[C.dataSource]:p.origin.models[_])||o;z=new l(J.resolveUri(C.uri));if(C.dataSource){U(z);if(E||T){var V=p.dataSources&&p.dataSources[C.dataSource];var K=u.dataSources&&u.dataSources[V.uri];x=C.settings&&C.settings.metadataUrlParams;var Q=(!x||typeof x["sap-language"]==="undefined")&&!z.hasQuery("sap-language")&&r.getSAPLogonLanguage();if(Q||K){C.settings=C.settings||{};x=C.settings.metadataUrlParams=C.settings.metadataUrlParams||{};if(Q){x["sap-language"]=r.getSAPLogonLanguage()}}if(K){R._applyCacheToken(z,{cacheToken:K,componentName:c,dataSource:_},x)}}}C.uri=z.toString()}if(C.uriSettingName===undefined){if(O||E||T){C.uriSettingName="serviceUrl"}else if(A){C.uriSettingName="bundleUrl"}else{}}var X;var G;if(t){G=t.getComponentData()}else{G=e.componentData}X=G&&G.startupParameters&&G.startupParameters["sap-system"];if(!X){X=i.get(I("sapSystem"))}var Y=false;var Z;if(X&&(O||E||T)){Y=true;Z=sap.ui.require("sap/ui/model/odata/ODataUtils")}if(C.uri){if(Y){C.preOriginBaseUri=C.uri.split("?")[0];C.uri=Z.setOrigin(C.uri,{alias:X});C.postOriginBaseUri=C.uri.split("?")[0]}if(C.uriSettingName!==undefined){C.settings=C.settings||{};if(!C.settings[C.uriSettingName]){C.settings[C.uriSettingName]=C.uri}}else if(C.settings){C.settings=[C.uri,C.settings]}else{C.settings=[C.uri]}}else if(Y&&C.uriSettingName!==undefined&&C.settings&&C.settings[C.uriSettingName]){C.preOriginBaseUri=C.settings[C.uriSettingName].split("?")[0];C.settings[C.uriSettingName]=Z.setOrigin(C.settings[C.uriSettingName],{alias:X});C.postOriginUri=C.settings[C.uriSettingName].split("?")[0]}if(Y&&C.settings&&C.settings.annotationURI){var ee=[].concat(C.settings.annotationURI);var te=[];for(var ne=0;ne<ee.length;ne++){te.push(Z.setAnnotationOrigin(ee[ne],{alias:X,preOriginBaseUri:C.preOriginBaseUri,postOriginBaseUri:C.postOriginBaseUri}))}C.settings.annotationURI=te}if(A&&C.settings){if(f){C.settings.activeTerminologies=f}b._processResourceConfiguration(C.settings,{alreadyResolvedOnRoot:true,baseURI:o._oBaseUri,manifestBaseURI:o._oManifestBaseUri,relativeTo:undefined})}if(C.settings&&!Array.isArray(C.settings)){C.settings=[C.settings]}y[_]=C}if(o.getEntry("/sap.ui5/commands")||t&&t._getManifestEntry("/sap.ui5/commands",true)){y["$cmd"]={type:"sap.ui.model.json.JSONModel"}}return y};R._loadManifestModelClasses=function(e,t,n){const o=[];function i(e,n,o){a.errorThrows(`${t}: Component Manifest: Class "${e}" for model "${n}" could not be loaded. ["sap.ui5"]["models"]["${n}"].`,{cause:o})}for(const t in e){const a=e[t];const r=a.type.replace(/\./g,"/");if(n){try{sap.ui.requireSync(r)}catch(e){i(a.type,t,e)}continue}o.push(new Promise((e,t)=>{sap.ui.require([r],e,t)}).catch(i.bind(null,a.type,t)))}return Promise.all(o)};R._createManifestModels=function(e,n,o){var i={};for(var a in e){var r=e[a];let p;p=M.get(r.type);if(!p){p=sap.ui.require(r.type.replace(/\./g,"/"))}var s=[null].concat(r.settings||[]);var u=p.bind.apply(p,s);var c=new u;if(c.isA("sap.ui.model.odata.v2.ODataModel")||c.isA("sap.ui.model.odata.v4.ODataModel")){const e={factoryConfig:n,manifest:o,model:c,modelId:a};const i=R.getComponentById(f._sOwnerId);if(i){e.owner={id:f._sOwnerId,config:i._componentConfig}}t.onModelCreated.execute(e)}i[a]=c}return i};function L(e){var t={afterManifest:{},afterPreload:{}};var n=c({},e.getEntry("/sap.app/dataSources"));var o=c({},e.getEntry("/sap.ui5/models"));var i=e.getComponentName();var a=R._findManifestModelClasses({models:o,dataSources:n,componentName:i});var r=new URLSearchParams(window.location.search).get("sap-ui-xx-preload-component-models-"+e.getComponentName());var s=r&&r.split(",");for(var u in a){var f=a[u];if(!f.preload&&s&&s.indexOf(u)>-1){f.preload=true;v.warning('FOR TESTING ONLY!!! Activating preload for model "'+u+'" ('+f.type+")",i,"sap.ui.core.Component")}if(f.type==="sap.ui.model.resource.ResourceModel"&&(!f.settings||f.settings.async!==true)){t.afterPreload[u]=f}else if(f.preload){if(sap.ui.loader._.getModuleState(f.type.replace(/\./g,"/")+".js")){t.afterManifest[u]=f}else{v.warning('Can not preload model "'+u+'" as required class has not been loaded: "'+f.type+'"',i,"sap.ui.core.Component")}}}return t}function W(e){return sap.ui.require.toUrl(e.replace(/\./g,"/")+"/manifest.json")}function q(e,t){C.registerResourcePath(e.replace(/\./g,"/"),t)}function z(e){var t=[];function o(e){if(!e._oManifest){var i=e.getComponentName();var a=W(i);var r=C.loadResource({url:a,dataType:"json",async:true}).catch(function(e){v.error('Failed to load component manifest from "'+a+'" (component '+i+")! Reason: "+e);return{}}).then(async function(t){if(t){e._applyManifest(t,true);await N(e.getManifestObject());return e.getManifestObject()._processI18n(true)}});t.push(r)}var s=e.getParent();if(s&&s instanceof n&&!s.isBaseClass()){o(s)}}o(e);return Promise.all(t)}R.create=function(e){if(e==null||typeof e!=="object"){throw new TypeError("Component.create() must be called with a configuration object.")}var t=c({},e);t.async=true;if(t.manifest===undefined){t.manifest=true}return K(t)};sap.ui.component=function(e){if(!e){throw new Error("sap.ui.component cannot be called without parameter!")}var t=function(e){return{type:"sap.ui.component",name:e}};if(typeof e==="string"){v.warning("Do not use deprecated function 'sap.ui.component' ("+e+") + for Component instance lookup. "+"Use 'Component.get' instead","sap.ui.component",null,t.bind(null,e));return R.getComponentById(e)}if(e.async){v.info("Do not use deprecated factory function 'sap.ui.component' ("+e["name"]+"). "+"Use 'Component.create' instead","sap.ui.component",null,t.bind(null,e["name"]))}else{v.warning("Do not use synchronous component creation ("+e["name"]+")! "+"Use the new asynchronous factory 'Component.create' instead","sap.ui.component",null,t.bind(null,e["name"]))}return K(e,true)};function J(e,t){const n=new y;e=e.replace("module:","");sap.ui.require([e],n.resolve,o=>{a.warningRejects(n.resolve,n.reject,`sap.ui.core.Component: Cannot load module '${e}' during creation of component: "${t}".`);v.warning(o)});return n.promise}function V(e){const t=e.getStaticProperty("collectRoutingClasses");const n=typeof t=="function"?t.call(e.getClass()):{};return Object.values(n)}function K(e,o){var i=R.getComponentById(f._sOwnerId);if(Array.isArray(e.activeTerminologies)&&e.activeTerminologies.length&&Array.isArray(r.getActiveTerminologies())&&r.getActiveTerminologies().length){if(JSON.stringify(e.activeTerminologies)!==JSON.stringify(r.getActiveTerminologies())){v.warning(o?"sap.ui.component: ":"Component.create: "+"The 'activeTerminolgies' passed to the component factory differ from the ones defined on the global 'sap/base/i18n/Localization.getActiveTerminologies';"+"This might lead to inconsistencies; ResourceModels that are not defined in the manifest and created by the component will use the globally configured terminologies.")}}var a=e.activeTerminologies||i&&i.getActiveTerminologies()||r.getActiveTerminologies();if(!e.asyncHints||!e.asyncHints.cacheTokens){var u=i&&i._mCacheTokens;if(typeof u==="object"){e.asyncHints=e.asyncHints||{};e.asyncHints.cacheTokens=u}}function c(e,n){if(n.async){var o=e.rootControlLoaded?e.rootControlLoaded():Promise.resolve();var i=t.onInstanceCreated.execute(e,n)||[];i.push(o);return Promise.all(i)}else{t.onInstanceCreated.execute(e,n)}return e}function p(t){if(o&&t.getMetadata().isA("sap.ui.core.IAsyncContentCreation")){throw new Error("Do not use deprecated factory function 'sap.ui.component' in combination with IAsyncContentCreation ("+e["name"]+"). "+"Use 'Component.create' instead")}var n=e.name,i=e.id,r=e.componentData,u=n+".Component",f=e.settings;var p=new t(s({},f,{id:i,componentData:r,_cacheTokens:e.asyncHints&&e.asyncHints.cacheTokens,_activeTerminologies:a,_componentConfig:e,_syncCreation:!e.async}));h(p instanceof R,'The specified component "'+u+'" must be an instance of sap.ui.core.Component!');v.info("Component instance Id = "+p.getId());var d=p.getMetadata()._getManifestEntry("/sap.ui5/handleValidation");if(d!==undefined||e.handleValidation){const t=sap.ui.require("sap/ui/core/Messaging");if(t){t.registerObject(p,d===undefined?e.handleValidation:d)}else{sap.ui.require(["sap/ui/core/Messaging"],function(t){if(!p.isDestroyed()){t.registerObject(p,d===undefined?e.handleValidation:d)}})}}var l=H(p,e.async);if(e.async){return c(p,e).then(function(){return Promise.all(l)}).then(function(){return p})}else{return c(p,e)}}var d=Q(e,{failOnError:true,createModels:true,waitFor:e.asyncHints&&e.asyncHints.waitFor,activeTerminologies:a});if(e.async){var l=f._sOwnerId;return d.then(function(e){var t=function(e){var o=e.getParent();var i=Promise.resolve();if(o instanceof n){i=i.then(function(){return t(o)})}return i.then(function(){return e.getManifestObject().loadDependenciesAndIncludes(true)})};return t(e.getMetadata()).then(async function(){const t=e.getMetadata();const n=t.getManifestObject();const o=n.getComponentName();const i=V(t);const a=i.map(e=>{let t;if(typeof e==="function"){t=Promise.resolve(e)}else{t=J(e,o)}return t});const r=j(t,n,"/sap.app/dataSources",true)||{};const s=j(t,n,"/sap.ui5/models",true)||{};const u=R._findManifestModelClasses({models:s,dataSources:r,componentName:o});const c=R._loadManifestModelClasses(u,o);await Promise.all([...a,c]);return f.runWithOwner(function(){return p(e)},l)})})}else{return p(d)}}R.load=function(e){var t=c({},e);t.async=true;if(t.manifest===undefined){t.manifest=true}return Q(t,{preloadOnly:t.asyncHints&&t.asyncHints.preloadOnly})};R.get=function(e){return R.getComponentById(e)};R.getComponentById=function(e){return E.get(e)};sap.ui.component.load=function(e,t){v.warning("Do not use deprecated function 'sap.ui.component.load'! Use 'Component.load' instead");return Q(e,{failOnError:t,preloadOnly:e.asyncHints&&e.asyncHints.preloadOnly})};function Q(n,o){var r=o.activeTerminologies,s=n.name,f=n.url,d=/^(sync|async)$/.test(R.getComponentPreloadMode()),l=n.manifest,m,y,M,_,C,w;function b(t,o){var i=JSON.parse(JSON.stringify(t));if(n.async){return O(i).then(function(t){return new e(t,o)})}else{return new e(i,o)}}function O(e){if(t.onPreprocessManifest.isRegistered()&&e!=null){try{var o=u({},n);return t.onPreprocessManifest.execute(e,o)}catch(e){v.error("Failed to execute flexibility hook for manifest preprocessing.",e);return Promise.reject(e)}}else{return Promise.resolve(e)}}h(!f||typeof f==="string","sUrl must be a string or undefined");if(s&&typeof f==="string"){q(s,f)}g.setStepComponent(s);if(l===undefined){m=n.manifestFirst===undefined?i.get({name:"sapUiManifestFirst",type:i.Type.Boolean,external:true}):!!n.manifestFirst;y=n.manifestUrl}if(l!==undefined){if(n.async===undefined){n.async=true}m=!!l;y=l&&typeof l==="string"?l:undefined;M=l&&typeof l==="object"?b(l,{url:n&&n.altManifestUrl,activeTerminologies:r,process:!n.async}):undefined}if(!M&&y){M=e.load({activeTerminologies:r,manifestUrl:y,componentName:s,processJson:O,async:n.async,failOnError:true})}if(M&&!n.async){s=M.getComponentName();if(s&&typeof f==="string"){q(s,f)}}if(!(M&&n.async)){if(!s){throw new Error("The name of the component is undefined.")}h(typeof s==="string","sName must be a string")}if(m&&!M){M=e.load({activeTerminologies:r,manifestUrl:W(s),componentName:s,async:n.async,processJson:O,failOnError:false})}function E(){return(s+".Component").replace(/\./g,"/")}function T(e){var t=s+".Component";if(!e){var n="The specified component controller '"+t+"' could not be found!";if(o.failOnError){throw new Error(n)}else{a.warningThrows(n)}}if(M){var i=x(e.getMetadata(),M);var r=function(){var t=Array.prototype.slice.call(arguments);var n;if(t.length===0||typeof t[0]==="object"){n=t[0]=t[0]||{}}else if(typeof t[0]==="string"){n=t[1]=t[1]||{}}n._metadataProxy=i;if(_){n._manifestModels=_}var o=Object.create(e.prototype);e.apply(o,t);return o};i.getClass=function(){return r};r[Symbol("isProxy")]=true;r.getMetadata=function(){return i};r.extend=function(){throw new Error("Extending Components created by Manifest is not supported!")};return r}else{return e}}function A(e,t){h(typeof e==="string"&&e||typeof e==="object"&&typeof e.name==="string"&&e.name,"reference either must be a non-empty string or an object with a non-empty 'name' and an optional 'url' property");if(typeof e==="object"){if(e.url){q(e.name,e.url)}return e.lazy&&t!==true?undefined:e.name}return e}function I(e,t){var n=e+".Component",o=p.isDepCacheEnabled(),i,a,r,s=function(e,t){return function(n){var o="Component-preload for this component does not exist.";v.warning("Couldn't preload component from "+e+": "+(n&&n.message||n),!t?o:o+" If the component is part of a library or another component, the configuration 'sap.app/embeddedBy' is not maintained. "+" The 'sap.app/embeddedBy' property must be relative path inside the deployment unit (library or component).","sap.ui.core.Component#preload")}};if(d&&e!=null&&!sap.ui.loader._.getModuleState(n.replace(/\./g,"/")+".js")){if(t){a=S._getTransitiveDependencyForComponent(e);if(a&&!a.hasOwnPreload){r=[a.library];Array.prototype.push.apply(r,a.dependencies);return p._load(r,{preloadOnly:true}).catch(s(a.library,true))}else{i=n.replace(/\./g,"/")+(o?"-h2-preload.js":"-preload.js");return sap.ui.loader._.loadJSResourceAsync(i).catch(s(i,true))}}else{try{i=n+"-preload";sap.ui.requireSync(i.replace(/\./g,"/"))}catch(e){s(i,false)(e)}}}else if(t){return Promise.resolve()}}function U(e,t,n){var o=[];var i=n?function(e){o.push(e)}:function(){};var a=t.getEntry("/sap.ui5/dependencies/libs");if(a){var r=[];for(var s in a){if(!a[s].lazy){r.push(s)}}if(r.length>0){v.info('Component "'+e+'" is loading libraries: "'+r.join(", ")+'"');i(p._load(r,{sync:!n}))}}var u=t.getEntry("/sap.ui5/extends/component");if(u){i(I(u,n))}var c=[];var f=t.getEntry("/sap.ui5/dependencies/components");if(f){for(var d in f){if(!f[d].lazy){c.push(d)}}}var l=t.getEntry("/sap.ui5/componentUsages");if(l){for(var g in l){if(l[g].lazy===false&&c.indexOf(l[g].name)===-1){c.push(l[g].name)}}}if(c.length>0){c.forEach(function(e){i(I(e,n))})}return n?Promise.all(o):undefined}if(n.async){var P=n.asyncHints||{},j=[],D=function(e){e=e.then(function(e){return{result:e,rejected:false}},function(e){return{result:e,rejected:true}});return e},k=function(e){if(e){j.push(D(e))}},$=function(e){return e},F,H;F=[];if(Array.isArray(P.preloadBundles)){P.preloadBundles.forEach(function(e){F.push(sap.ui.loader._.loadJSResourceAsync(A(e,true),true))})}if(Array.isArray(P.libs)){H=P.libs.map(A).filter($);F.push(p._load(H,{preloadOnly:true}))}F=Promise.all(F);if(H&&!o.preloadOnly){F=F.then(function(){return p._load(H)})}k(F);if(P.components){Object.keys(P.components).forEach(function(e){k(I(A(P.components[e]),true))})}if(!M){k(I(s,true))}else{var K=[];M=M.then(async function(e){var t=e.getComponentName();if(typeof f==="string"){q(t,f)}e.defineResourceRoots();await N(e);e._preprocess({resolveUI5Urls:true,i18nProperties:K});return e});if(o.createModels){k(M.then(async function(e){var t=e.getComponentName();C=L(e);if(Object.keys(C.afterManifest).length>0){await R._loadManifestModelClasses(C.afterManifest,t);var o=c({},e.getEntry("/sap.app/dataSources"));var i=R._createManifestModelConfigurations({models:C.afterManifest,dataSources:o,manifest:e,componentData:n.componentData,cacheTokens:P.cacheTokens,activeTerminologies:r});_=R._createManifestModels(i,n,e)}return e}))}k(M.then(function(e){var t=Promise.resolve();var i=e.getEntry("/sap.app/embeddedBy");var a=e.getComponentName();if(!i){t=I(a,true)}else if(!sap.ui.loader._.getModuleState(E()+".js")){v.warning("Component '"+a+"' is defined to be embedded in a library or another component"+"The relatively given preload for the embedding resource was not loaded before hand. "+"Please make sure to load the embedding resource containing this Component before instantiating.",undefined,"sap.ui.core.Component#embeddedBy")}return t.then(function(){return e._processI18n(true,K)}).then(function(){if(!o.createModels){return null}var t=Object.keys(C.afterPreload);if(t.length===0){return null}return new Promise(function(e,t){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(t){e(t)},t)}).then(function(i){var a=c({},e.getEntry("/sap.app/dataSources"));var s=R._createManifestModelConfigurations({models:C.afterPreload,dataSources:a,manifest:e,componentData:n.componentData,cacheTokens:P.cacheTokens,activeTerminologies:r});function u(t){var n=s[t];if(Array.isArray(n.settings)&&n.settings.length>0){var a=n.settings[0];a.activeTerminologies=o.activeTerminologies;return i.loadResourceBundle(a,true).then(function(e){a.bundle=e;delete a.terminologies;delete a.activeTerminologies;delete a.enhanceWith},function(n){v.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.",'["sap.ui5"]["models"]["'+t+'"]',e.getComponentName());v.error(n);delete s[t]})}else{return Promise.resolve()}}return Promise.all(t.map(u)).then(function(){if(Object.keys(s).length>0){var e=R._createManifestModels(s);if(!_){_={}}for(var t in e){_[t]=e[t]}}})})})}));w=function(e){if(t.onComponentLoaded.isRegistered()){var o=u({},n);try{return t.onComponentLoaded.execute(o,e)}catch(t){a.errorThrows('sap.ui.core.Component: Callback for loading the component "'+e.getComponentName()+'" run into an error.',{cause:t,suffix:"The callback was skipped and the component loading resumed."})}}}}return Promise.all(j).then(function(e){var t=[],n=false,o;n=e.some(function(e){if(e&&e.rejected){o=e.result;return true}t.push(e.result);return false});if(n){return Promise.reject(o)}return t}).then(function(e){if(M&&w){return M.then(w).then(function(){return e})}return e}).then(function(e){v.debug("Component.load: all promises fulfilled, then "+e);if(M){return M.then(function(e){if(!e._bLoadManifestRequestFailed){M=e;s=M.getComponentName();return U(s,M,true)}else{M=undefined;return M}})}else{return e}}).then(function(){if(o.preloadOnly){return true}return new Promise(function(e,t){sap.ui.require([E()],function(t){e(t)},t)}).then(function(t){var n=t.getMetadata();var i=n.getComponentName();var a=W(i);var s=[];if(M&&typeof l!=="object"&&(typeof y==="undefined"||y===a)){n._applyManifest(JSON.parse(JSON.stringify(M.getRawJson())),true);const e=N(n.getManifestObject()).then(()=>n.getManifestObject()._processI18n(true));s.push(e)}s.push(z(n));return Promise.all(s).then(function(){var i=Promise.resolve();if(!M&&Array.isArray(o.activeTerminologies)&&o.activeTerminologies.length>0){M=new e(n.getManifestObject().getRawJson(),{process:false,activeTerminologies:r});i=N(n.getManifestObject()).then(()=>M._processI18n(true))}return i.then(T.bind(undefined,t))})})}).then(function(e){if(!M){return e}const t=e.getMetadata();const n=V(t);var o=c({},M.getEntry("/sap.ui5/models"));var i=c({},M.getEntry("/sap.app/dataSources"));var a=R._findManifestModelClasses({models:o,dataSources:i,componentName:M.getComponentName()});for(var r in a){if(!a.hasOwnProperty(r)){continue}var s=a[r];if(!s.type){continue}var u=s.type.replace(/\./g,"/");if(n.indexOf(u)===-1){n.push(u)}}if(n.length>0){const t=M.getComponentName();return Promise.all(n.map(function(e){return J(e,t)})).then(function(){return e})}else{return e}}).then(function(e){var t=o.waitFor;if(t){var n=Array.isArray(t)?t:[t];return Promise.all(n).then(function(){return e})}return e}).catch(function(e){if(_){for(var t in _){var n=_[t];if(n&&typeof n.destroy==="function"){n.destroy()}}}throw e})}if(M){M.defineResourceRoots();B(M);M._preprocess({resolveUI5Urls:true});U(s,M)}I(s);return T(sap.ui.requireSync(E()))}R.registry=E;R.prototype.getCommand=function(e){if(!this._mComputedCommands){var t=R.getCustomizing(this,{type:"sap.ui.commands"})||{},n=this._getManifestEntry("/sap.ui5/commands",true)||{},o=this.getMetadata().getComponentName(),i="",a=this.getExtensionComponent&&this.getExtensionComponent();if(a&&a.getLocalId){i="#"+(a.getLocalId(this.getId())||this.getId())}this._mComputedCommands=c({},n,t[o],t[o+i])}return e?this._mComputedCommands[e]:this._mComputedCommands};R.prototype.deactivate=function(){var e=R.getOwnerComponentFor(this);if(e&&e.isActive()){throw new Error("Component.deactivate must not be called on nested components.")}if(!this.isKeepAliveSupported()){v.warning("Deactivation of component failed. Component '"+this.getId()+"' does not support 'keepAlive'.");return}if(!this.isActive()){v.warning("Deactivation of component failed. Component '"+this.getId()+"' is already inactive.");return}this.onOwnerDeactivation();this._bIsActive=false;$(function(e){d.suspend(e.getDomRef());e.onOwnerDeactivation()},this.getId());E.forEach(function(e){var t=R.getOwnerIdFor(e);if(t===this.getId()){e.deactivate()}},this);if(this._oEventBus){this._oEventBus.suspend()}if(this.getRouter()){this.getRouter().stop()}if(typeof this.onDeactivate==="function"){m(this.onDeactivate(),{name:"onDeactivate",component:this.getId()})}};R.prototype.activate=function(){if(!this.isKeepAliveSupported()){v.warning("Activation of component failed. Component '"+this.getId()+"' does not support 'keepAlive'.");return}if(this.isActive()){v.warning("Activation of component failed. Component '"+this.getId()+"' is already active.");return}this.onOwnerActivation();this._bIsActive=true;$(function(e){d.resume(e.getDomRef());e.onOwnerActivation()},this.getId());E.forEach(function(e){var t=R.getOwnerIdFor(e);if(t===this.getId()){e.activate()}},this);if(this._oEventBus){this._oEventBus.resume()}if(this.getRouter()){this.getRouter().initialize()}if(typeof this.onActivate==="function"){m(this.onActivate(),{name:"onActivate",component:this.getId()})}};R.prototype.isKeepAliveSupported=function(){var e=this._oKeepAliveConfig&&this._oKeepAliveConfig.supported;if(e){e=E.filter(function(e){var t=R.getOwnerIdFor(e);return t===this.getId()},this).every(function(e){return e.isKeepAliveSupported()},this)}return!!e};R.prototype.registerForDestroy=function(e){var t=this._getDestroyables();e=e.then(function(n){t.splice(t.indexOf(e),1);return n});t.push(e)};T.registerForUpdate("Components",E.all);return R});
//# sourceMappingURL=Component.js.map