/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/future","sap/ui/base/ManagedObject","./Control","./Component","./library","./ComponentContainerRenderer"],function(e,t,n,o,i,a){"use strict";var r=i.ComponentLifecycle;const{oPropagatedProperties:s}=new t;var p=n.extend("sap.ui.core.ComponentContainer",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],library:"sap.ui.core",properties:{name:{type:"string",defaultValue:null},url:{type:"sap.ui.core.URI",defaultValue:null},async:{type:"boolean",defaultValue:false},handleValidation:{type:"boolean",defaultValue:false},settings:{type:"object",defaultValue:null},propagateModel:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},lifecycle:{type:"sap.ui.core.ComponentLifecycle",defaultValue:r.Legacy},autoPrefixId:{type:"boolean",defaultValue:false},usage:{type:"string",defaultValue:null},manifest:{type:"any",defaultValue:null}},associations:{component:{type:"sap.ui.core.UIComponent",multiple:false}},events:{componentCreated:{parameters:{component:{type:"sap.ui.core.UIComponent"}}},componentFailed:{allowPreventDefault:true,parameters:{reason:{type:"object"}}}},designtime:"sap/ui/core/designtime/ComponentContainer.designtime"},renderer:a});function l(e,t,n,i){var a=typeof t==="string"?o.getComponentById(t):t;var r=e.getComponentInstance();if(r!==a){if(r){r.setContainer(undefined);if(i){r.destroy()}else{e._propagateProperties(true,r,s,true)}}e.setAssociation("component",a,n);a=e.getComponentInstance();if(a){a.setContainer(e);e.propagateProperties(true)}}}p.prototype.getComponentInstance=function(){var e=this.getComponent();return e&&o.getComponentById(e)};var u={onAfterRendering:function(){if(this._placeholder){this._placeholder.show(this)}}};p.prototype.showPlaceholder=function(e){var t,n=sap.ui.require("sap/ui/core/Placeholder");if(!n||!n.isEnabled()){return}if(this._placeholder){this.hidePlaceholder()}if(e.placeholder){this._placeholder=e.placeholder;t=this._placeholder._load()}else{t=Promise.resolve()}if(this.getDomRef()&&this._placeholder){this._placeholder.show(this)}this.addEventDelegate(u,this);return t};p.prototype.hidePlaceholder=function(){if(this._placeholder){this._placeholder.hide();this.removeEventDelegate(u);this._placeholder=undefined}};p.prototype.setComponent=function(e,t){l(this,e,t,this.getLifecycle()===r.Container||typeof this.getUsage()==="string"&&this.getUsage()&&this.getLifecycle()===r.Legacy);return this};p.prototype.applySettings=function(e,t){if(e){if(e.manifest==="true"||e.manifest==="false"){e.manifest=e.manifest==="true"}if(e.manifest&&e.async===undefined){e.async=true}}n.prototype.applySettings.apply(this,arguments)};function f(e){var t=e.getName();var n=e.getManifest();var o=e.getUrl();var i=e.getSettings();var a={name:t?t:undefined,manifest:n!==null?n:false,async:e.getAsync(),url:o?o:undefined,handleValidation:e.getHandleValidation(),settings:i!==null?i:undefined};return a}p.prototype._createComponent=function(){var t=o.getOwnerComponentFor(this),n=this.getUsage(),i=f(this);if(n){if(t){i=t._enhanceWithUsageConfig(n,i)}else{e.errorThrows('ComponentContainer "'+this.getId()+'" does have a "usage", but no owner component!')}}if(this.getAutoPrefixId()){if(i.id){i.id=this.getId()+"-"+i.id}if(i.settings&&i.settings.id){i.settings.id=this.getId()+"-"+i.settings.id}}return o._createComponent(i,t)};p.prototype.onBeforeRendering=function(){var t=this.getComponentInstance(),n=this.getUsage(),o=this.getName(),i=this.getManifest();if(!this._oComponentPromise&&!t&&(n||o||i)){t=this._createComponent();if(t instanceof Promise){this._oComponentPromise=t;t.then(function(e){delete this._oComponentPromise;this.setComponent(e);this.fireComponentCreated({component:e})}.bind(this),function(t){delete this._oComponentPromise;if(this.fireComponentFailed({reason:t})){e.errorThrows("Failed to load component for container "+this.getId(),{cause:t})}}.bind(this))}else if(t){this.setComponent(t,true);this.fireComponentCreated({component:t})}else{this.fireComponentFailed({reason:new Error("The component could not be created.")})}}if(t&&t.onBeforeRendering){t.onBeforeRendering()}};p.prototype.onAfterRendering=function(){var e=this.getComponentInstance();if(e&&e.onAfterRendering){e.onAfterRendering()}};p.prototype.exit=function(){l(this,undefined,true,this.getLifecycle()!==r.Application)};p.prototype.propagateProperties=function(e){var t=this.getComponentInstance();if(t&&this.getPropagateModel()){this._propagateProperties(e,t)}n.prototype.propagateProperties.apply(this,arguments)};p.prototype._propagateContextualSettings=function(){var e=this.getComponentInstance();if(e){e._applyContextualSettings(this._getContextualSettings())}};return p});
//# sourceMappingURL=ComponentContainer.js.map