/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObjectMetadata","sap/ui/core/Manifest","sap/base/future","sap/base/Log","sap/base/util/extend","sap/base/util/deepExtend","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions"],function(e,t,n,a,i,o,s,r){"use strict";var p=sap.ui.loader._.getSyncCallBehavior();var c=function(t,n){e.apply(this,arguments)};c.prototype=Object.create(e.prototype);c.prototype.constructor=c;c.preprocessClassInfo=function(e){if(e&&typeof e.metadata==="string"){e.metadata={_src:e.metadata}}return e};c.prototype.applySettings=function(t){var o=this._oStaticInfo=t.metadata;var s=this.getName(),p=s.replace(/\.\w+?$/,"");const c=!!o._src;if(c||t&&typeof t.metadata==="string"){n.errorThrows("Component Metadata must not be a string. Please use \"metadata: { manifest: 'json' }\" instead.");(()=>{var e=p.replace(/\./g,"/")+"/component.json";a.info("The metadata of the component "+s+" is loaded from file "+e+".");try{var t=r.loadResource(e,{dataType:"json"});i(o,t)}catch(t){a.error('Failed to load component metadata from "'+e+'" (component '+s+")! Reason: "+t)}})()}e.prototype.applySettings.call(this,t);this._sComponentName=p;this._bInitialized=false;this._iInstanceCount=0;var f=o["manifest"];if(f){o.__metadataVersion=2;if(typeof f==="string"&&f==="json"){return}}else{o.__metadataVersion=1;f={}}this._applyManifest(f)};c.prototype._applyManifest=function(e,n=false){if(this._oManifest){a.info("Can't apply manifest to ComponentMetadata as it has already been created.",this.getName(),"sap.ui.core.ComponentMetadata");return}e["name"]=e["name"]||this.getName();e["sap.app"]=e["sap.app"]||{id:this.getComponentName()};e["sap.ui5"]=e["sap.ui5"]||{};if(!this.isBaseClass()){e["sap.ui5"]["extends"]=e["sap.ui5"]["extends"]||{}}this._convertLegacyMetadata(this._oStaticInfo,e);this._oManifest=new t(e,{componentName:this.getComponentName(),baseUrl:sap.ui.require.toUrl(this.getComponentName().replace(/\./g,"/"))+"/",process:!n&&this._oStaticInfo.__metadataVersion===2})};c.prototype.init=function(){if(this._iInstanceCount===0){var e=this.getParent();if(e instanceof c){e.init()}this.getManifestObject().init();this._bInitialized=true}this._iInstanceCount++};c.prototype.exit=function(){var e=Math.max(this._iInstanceCount-1,0);if(e===0){this.getManifestObject().exit();var t=this.getParent();if(t instanceof c){t.exit()}this._bInitialized=false}this._iInstanceCount=e};c.prototype.onInitComponent=function(e){a.error("The function ComponentMetadata#onInitComponent will be removed soon!")};c.prototype.onExitComponent=function(e){a.error("The function ComponentMetadata#onExitComponent will be removed soon!")};c.prototype.isBaseClass=function(){return/^sap\.ui\.core\.(UI)?Component$/.test(this.getName())};c.prototype.getMetadataVersion=function(){return this._oStaticInfo.__metadataVersion};c.prototype.getManifestObject=function(){if(!this._oManifest){var e=this._oStaticInfo["manifest"];if(typeof e==="string"&&e==="json"){var t=this.getName();var n=this.getComponentName();var i=n.replace(/\./g,"/")+"/manifest.json";var o=!!sap.ui.loader._.getModuleState(i);if(!o&&p===2){a.error("[nosync] Loading manifest of the component "+t+" ignored.",i,"sap.ui.core.ComponentMetadata");e={}}else{if(!o&&p===1){a.error("[nosync] The manifest of the component "+t+" is loaded with sync XHR.",i,"sap.ui.core.ComponentMetadata")}else{a.info("The manifest of the component "+t+" is loaded from file "+i+".")}try{var s=r.loadResource(i,{dataType:"json"});e=s}catch(n){a.error('Failed to load component manifest from "'+i+'" (component '+t+")! Reason: "+n);e={}}}this._applyManifest(e)}}return this._oManifest};c.prototype.getManifest=function(){return this._getManifest()};c.prototype._getManifest=function(){if(this.getMetadataVersion()===1){return this.getManifestObject().getRawJson()}return this.getManifestObject().getJson()};c.prototype.getRawManifest=function(){return this.getManifestObject().getRawJson()};c.prototype._getRawManifest=function(){a.warning("ComponentMetadata#_getRawManifest: do not use deprecated functions anymore!");return this.getManifestObject().getRawJson()};c.prototype.getManifestEntry=function(e,t){return this._getManifestEntry(e,t)};c.prototype._getManifestEntry=function(e,t){var n=this.getManifestObject().getEntry(e);if(n!==undefined&&!s(n)){return n}var a,i;if(t&&(a=this.getParent())instanceof c){i=a._getManifestEntry(e,t)}if(i||n){n=o({},i,n)}return n};c.prototype.getCustomEntry=function(e,t){if(!e||e.indexOf(".")<=0){a.warning("Component Metadata entries with keys without namespace prefix can not be read via getCustomEntry. Key: "+e+", Component: "+this.getName());return null}var n,i=this._oStaticInfo[e]||{};if(!s(i)){a.warning("Custom Component Metadata entry with key '"+e+"' must be an object. Component: "+this.getName());return null}if(t&&(n=this.getParent())instanceof c){return o({},n.getCustomEntry(e,t),i)}return o({},i)};c.prototype.getComponentName=function(){return this._sComponentName};c.prototype.getDependencies=function(){if(!this._oLegacyDependencies){var e=this.getManifestEntry("/sap.ui5/dependencies"),t=e&&e.minUI5Version||null,n=e&&e.libs||{},a=e&&e.components||{};var i={ui5version:t,libs:[],components:[]};for(var o in n){i.libs.push(o)}for(var s in a){i.components.push(s)}this._oLegacyDependencies=i}return this._oLegacyDependencies};c.prototype.getIncludes=function(){a.warning("Usage of sap.ui.core.ComponentMetadata.prototype.getIncludes() is deprecated. "+"For CSS files, please use the '/sap.ui5/resources/css' section in your 'manifest.json'. ","Deprecation",null,function(){return{type:"sap.ui.core.ComponentMetadata",name:this.getName()}}.bind(this));if(!this._aLegacyIncludes){var e=[],t=this.getManifestEntry("/sap.ui5/resources")||{},n=t&&t.css||[],i=t&&t.js||[];for(var o=0,s=n.length;o<s;o++){if(n[o]&&n[o].uri){e.push(n[o].uri)}}for(var o=0,s=i.length;o<s;o++){if(i[o]&&i[o].uri){e.push(i[o].uri)}}this._aLegacyIncludes=e.length>0?e:null}return this._aLegacyIncludes};c.prototype.getUI5Version=function(){return this.getManifestEntry("/sap.ui5/dependencies/minUI5Version")};c.prototype.getComponents=function(){return this.getDependencies().components};c.prototype.getLibs=function(){return this.getDependencies().libs};c.prototype.getVersion=function(){return this.getManifestEntry("/sap.app/applicationVersion/version")};c.prototype.getConfig=function(e,t){var n=this.getManifestEntry("/sap.ui5/config",!t);if(!n){return{}}if(!e){return n}return n.hasOwnProperty(e)?n[e]:{}};c.prototype.getCustomizing=function(e){return this.getManifestEntry("/sap.ui5/extends/extensions",!e)};c.prototype.getModels=function(e){if(!this._oLegacyModels){this._oLegacyModels={};var t=this.getManifestEntry("/sap.ui5/models")||{};for(var n in t){var a=t[n];this._oLegacyModels[n]=a.settings||{};this._oLegacyModels[n].type=a.type;this._oLegacyModels[n].uri=a.uri}}var i,s=o({},this._oLegacyModels);if(!e&&(i=this.getParent())instanceof c){s=o({},i.getModels(),s)}return s};c.prototype.handleValidation=function(){return this.getManifestEntry("/sap.ui5/handleValidation")};c.prototype.getServices=function(){a.warning("Usage of sap.ui.core.ComponentMetadata.prototype.getServices is deprecated!");return this._oStaticInfo.services||{}};c.prototype._convertLegacyMetadata=function(e,t){var n=function(e,t){var n={};if(e){for(var a=0,i=e.length;a<i;a++){var o=e[a];if(typeof o==="string"){n[o]=typeof t==="function"&&t(o)||{}}}}return n};var a=t["sap.app"];var i=t["sap.ui5"];for(var o in e){var s=e[o];if(s!==undefined){switch(o){case"name":t[o]=t[o]||s;a["id"]=a["id"]||s;break;case"description":case"keywords":a[o]=a[o]||s;break;case"version":var r=a.applicationVersion=a.applicationVersion||{};r.version=r.version||s;break;case"config":i[o]=i[o]||s;break;case"customizing":var p=i["extends"]=i["extends"]||{};p.extensions=p.extensions||s;break;case"dependencies":if(!i[o]){i[o]={};i[o].minUI5Version=s.ui5version;i[o].libs=n(s.libs);i[o].components=n(s.components)}break;case"includes":if(!i["resources"]){i["resources"]={};if(s&&s.length>0){for(var c=0,f=s.length;c<f;c++){var u=s[c];var d=u.match(/\.(css|js)$/i);if(d){i["resources"][d[1]]=i["resources"][d[1]]||[];i["resources"][d[1]].push({uri:u})}}}}break;case"handleValidation":if(i[o]===undefined){i[o]=s}break;case"models":if(!i["models"]){var g={};for(var h in s){var m=s[h];var l={};for(var y in m){var v=m[y];switch(y){case"type":case"uri":l[y]=v;break;default:l.settings=l.settings||{};l.settings[y]=v}}g[h]=l}i["models"]=g}break}}}};return c},true);
//# sourceMappingURL=ComponentMetadata.js.map