/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/config","sap/base/i18n/Localization","sap/base/i18n/ResourceBundle","sap/base/future","sap/base/Log","sap/base/util/deepExtend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/util/fetch","sap/base/util/mixedFetch","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/ui/Global","sap/ui/VersionInfo","sap/ui/base/DataType","sap/ui/base/EventProvider","sap/ui/base/Object","sap/ui/base/SyncPromise","sap/ui/core/_UrlResolver","sap/ui/core/Supportability"],function(e,n,t,r,i,a,s,o,u,l,c,f,d,p,h,y,g,m,b,v,_,S,j){"use strict";var L={};var w={};var T=new Set(["sap.suite.ui.generic.template","sap.ui.comp","sap.ui.layout","sap.ui.unified"]);function P(e,n){return sap.ui.require.toUrl(e.replace(/\./g,"/")+n)}function O(e,n){l.registerResourcePath(e.replace(/\./g,"/"),n)}function E(e,n){var t=e.modules,r=function(e){return/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/")};if(p(e.version||"1.0").compareTo("2.0")<0){t={};for(var i in e.modules){t[r(i)+".js"]=e.modules[i]}}sap.ui.require.preload(t,e.name,n)}var C={};n.get({name:"sapUiXxLibraryPreloadFiles",type:n.Type.StringArray,external:true}).forEach(function(e){var n=String(e).trim().split(/\s*:\s*/),t=n[0],r=n[1];if(n.length===1){r=t;t=""}if(/^(?:none|js|json|both)$/.test(r)){C[t]=r}});var x=[];var B;function M(e){var n=sap.ui.require("sap/ui/core/theming/ThemeManager");if(!B){if(!n){B=new Promise(function(e,n){sap.ui.require(["sap/ui/core/theming/ThemeManager"],function(n){e(n)},n)})}else{B=Promise.resolve(n)}}if(n&&e){n.reset()}return B}var R=Symbol("sap.ui.core.Lib");var z={configurable:true,enumerable:true,writable:false};function A(e){z.value=e;return z}function F(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var n in e){if(Object.hasOwn(e,n)){F(e[n])}}}}function q(){var e=n.get({name:"sapUiPreloadLibCss",type:n.Type.StringArray,external:true});if(e.length>0){if(e[0].startsWith("!")){e[0]=e[0].slice(1)}if(e[0]==="*"){e.shift();Object.keys(L).forEach(function(n){if(!e.includes(n)){e.unshift(n)}})}}return e}var k=v.extend("sap.ui.core.Lib",{constructor:function(n){v.call(this);e(typeof n==="object","A settings object must be given to the constructor of sap/ui/core/Lib");e(typeof n.name==="string"&&n.name,"The settings object that is given to the constructor of sap/ui/core/Lib must contain a 'name' property which is a non-empty string");if(n._key!==R){throw new Error("The constructor of sap/ui/core/Lib is restricted to the internal usage. To get an instance of Library with name '"+n.name+"', use the static method 'get' from sap/ui/core/Lib instead.")}this.name=n.name;var t=["dependencies","types","interfaces","controls","elements"];t.forEach(function(e){Object.defineProperty(this,e,A([]))}.bind(this));Object.defineProperty(this,"_resourceBundles",{value:{},writable:true});Object.defineProperty(this,"_loadingStatus",{value:null,writable:true});Object.defineProperty(this,"_settingsEnhanced",{value:false,writable:true});Object.defineProperty(this,"_manifestFailed",{value:false,writable:true})},getInterface:function(){return this},isSettingsEnhanced:function(){return this._settingsEnhanced},enhanceSettings:function(e){if(this._settingsEnhanced){return this}this._settingsEnhanced=true;var n,t,r;for(n in e){t=e[n];r=undefined;if(t!==undefined){if(Array.isArray(this[n])){if(this[n].length===0){r=t}else{r=h(this[n].concat(t))}}else if(this[n]===undefined){r=t}else if(n!="name"){i.warningThrows("library info setting ignored: "+n+"="+t)}if(r!==undefined){Object.defineProperty(this,n,A(r))}}}return this},_getFileType:function(e){var n;var t=C[this.name]||C[""]||"both";if(e===true){n="json"}else if(e===false){n="js"}else{n=t}if(t!=="both"&&n!=="both"&&t!==n){n="none"}return n},preload:function(e){if(e&&(e.hasOwnProperty("async")||e.hasOwnProperty("sync"))){i.errorThrows("The 'preload' function of class sap/ui/core/Lib only supports preloading a library asynchronously.",{suffix:"The given 'async' or 'sync' setting is ignored."})}if(e&&e.hasOwnProperty("json")){i.errorThrows("The 'preload' function of class sap/ui/core/Lib only supports preloading in JS Format.",{suffix:"The given 'json' setting is ignored."})}return this._preload(["url","lazy"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{}))},_preload:function(e){e=e||{};var n=this._getFileType(e.json),t=this.name.replace(/\./g,"/"),r=!!sap.ui.loader._.getModuleState(t+"/library.js"),i=k.isDepCacheEnabled();if(n==="none"){return e.sync?this:Promise.resolve(this)}if(this._loadingStatus==null&&e.url){O(this.name,e.url)}this._loadingStatus=this._loadingStatus||{};if(this._loadingStatus.pending){if(e.sync){if(e.lazy){return this}else if(this._loadingStatus.async){a.warning("request to load "+this.name+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller")}else{a.warning("request to load "+this.name+" synchronously while sync loading is pending (cycle, ignored)");return this}}else if(this._loadingStatus.preloadFinished){return Promise.resolve(this)}}if(e.sync&&this._loadingStatus.pending===false||!e.sync&&this._loadingStatus.promise){return e.sync?this:this._loadingStatus.promise}if(e.lazy){a.debug("Lazy dependency to '"+this.name+"' encountered, loading library-preload-lazy.js");if(e.sync){try{sap.ui.requireSync(t+"/library-preload-lazy")}catch(e){a.error("failed to load '"+t+"/library-preload-lazy.js"+"' synchronously ("+(e&&e.message||e)+")")}return this}return sap.ui.loader._.loadJSResourceAsync(t+"/library-preload-lazy.js",true)}this._loadingStatus.pending=true;this._loadingStatus.async=!e.sync;var s;if(r){s=(e.sync?_:Promise).resolve()}else{s=n!=="json"?this._preloadJSFormat({fallbackToJSON:n!=="js",http2:i,sync:e.sync}):this._preloadJSONFormat({sync:e.sync})}this._loadingStatus.promise=s.then(function(n){n=n||this._getDependencies();this._loadingStatus.preloadFinished=true;var t=this.getManifest(),r;if(n&&n.length){if(!e.sync){n=g._getTransitiveDependencyForLibraries(n)}r=n.map(function(n){var t=k._get(n.name,true);return t._preload({sync:e.sync,lazy:n.lazy})})}else{r=[]}if(!e.sync&&t&&p(t._version).compareTo("1.9.0")>=0){r.push(this.loadResourceBundle())}var i=e.sync?_.all(r):Promise.all(r);return i.then(function(){this._loadingStatus.pending=false;return this}.bind(this))}.bind(this));return e.sync?this._loadingStatus.promise.unwrap():this._loadingStatus.promise},_preloadJSFormat:function(e){e=e||{};var n=this;var t=this.name.replace(/\./g,"/")+(e.http2?"/library-h2-preload":"/library-preload")+(e.sync?"":".js");var r;if(e.sync){r=_.resolve().then(function(){sap.ui.requireSync(t)})}else{r=sap.ui.loader._.loadJSResourceAsync(t)}return r.catch(function(r){if(e.fallbackToJSON){var i;if(e.sync){var s=r;while(s&&s.cause){s=s.cause}i=s&&s.name==="XHRLoadError"}else{i=true}if(i){a.error("failed to load '"+t+"' ("+(r&&r.message||r)+"), falling back to library-preload.json");return n._preloadJSONFormat({sync:e.sync})}}})},_preloadJSONFormat:function(e){e=e||{};var n=P(this.name,"/library-preload.json");c=f?f:c;return c(n,{headers:{Accept:c.ContentTypes.JSON}},e.sync).then(function(e){if(e.ok){return e.json().then(function(e){if(e){E(e,n);if(Array.isArray(e.dependencies)){return e.dependencies.map(function(e){return{name:e.replace(/\.library-preload$/,"")}})}else{return e.dependencies}}})}else{throw Error(e.statusText||e.status)}}).catch(function(e){a.error("failed to load '"+n+"': "+e.message)})},getManifest:function(e){if(!this.oManifest){var n=this.name.replace(/\./g,"/")+"/manifest.json";if(sap.ui.loader._.getModuleState(n)||e&&!this._manifestFailed){try{this.oManifest=l.loadResource(n,{dataType:"json",async:false,failOnError:!this.isSettingsEnhanced()});if(this._oManifest){F(this.oManifest)}else{this._manifestFailed=true}}catch(e){this._manifestFailed=true}}}return this.oManifest},_getDependencies:function(){var e=this.getManifest();var n=[];var t=e&&e["sap.ui5"]&&e["sap.ui5"].dependencies&&e["sap.ui5"].dependencies.libs;if(t){return Object.keys(t).reduce(function(e,n){if(!t[n].lazy){e.push({name:n})}else if(T.has(n)){e.push({name:n,lazy:true})}return e},n)}else{return n}},_getI18nSettings:function(){var e=this.getManifest(),n;if(e&&p(e._version).compareTo("1.9.0")>=0){n=e["sap.ui5"]&&e["sap.ui5"].library&&e["sap.ui5"].library.i18n}n=this._normalizeI18nSettings(n);return n},_normalizeI18nSettings:function(e){if(e==null||e===true){e={bundleUrl:"messagebundle.properties"}}else if(typeof e==="string"){e={bundleUrl:e}}else if(typeof e==="object"){e=s({},e)}return e},_includeTheme:function(e,n){var t=this.name,r=q().indexOf(t)!==-1;x.push({name:t,version:this.version,variant:e,preloadedCss:r});M().then(function(r){r.includeLibraryTheme(t,e,n)})},getResourceBundle:function(e){return this._loadResourceBundle(e,true)},loadResourceBundle:function(e){return this._loadResourceBundle(e)},_loadResourceBundle:function(n,i){var a=this,s=this.getManifest(i),o=!!s,u,l,c,f;e(n===undefined||typeof n==="string","sLocale must be a string or omitted");n=n||t.getLanguage();c=n+"/manifest-not-available";if(o){f=n;delete this._resourceBundles[c]}else{f=c}u=this._resourceBundles[f];if(!u||i&&u instanceof Promise){l=this._getI18nSettings();if(l){var d=P(this.name+"/",l.bundleUrl);w[d]=this;u=r.create({bundleUrl:d,supportedLocales:l.supportedLocales,fallbackLocale:l.fallbackLocale,locale:n,async:!i,activeTerminologies:t.getActiveTerminologies()});if(u instanceof Promise){u=u.then(function(e){a._resourceBundles[f]=e;return e})}this._resourceBundles[f]=u}}return i?u:Promise.resolve(u)}});k.getAllInstancesRequiringCss=function(){return x.slice()};k.isLoaded=function(e){return L[e]?true:false};k._get=function(e,n){var t=L[e];if(!t&&n){L[e]=t=new k({name:e,_key:R})}return t};k._getByBundleUrl=function(e){if(e){if(w[e]){return w[e]}var n=sap.ui.loader._.guessResourceName(e);if(n){for(var t in L){if(!L[t].isSettingsEnhanced()){continue}var r=t.replace(/\./g,"/");var i=L[t];if(r!==""&&n.startsWith(r+"/")){var a=n.replace(r+"/","");var s=i._getI18nSettings();if(s){var o=P(r,"/"+s.bundleUrl);a=P(r,"/"+a);if(a===o){w[e]=i;return i}w[e]=false}}}}}};k.all=function(){return k._all(false)};k._all=function(e){var n={};Object.keys(L).forEach(function(t){if(e||L[t].isSettingsEnhanced()){n[t]=L[t]}});return n};const U=Symbol("isProxy");function $(e,n){const t=new WeakMap;t.set(n,`${e}.`);const r={set(e,n,i){if(u(i)&&!i[U]){const s=o(i);let u=s;if(!s){if(m._isEnumCandidate(i)){e[n]=i;const r=t.get(e);m.registerEnum(`${r}${n}`,i);a.debug(`[Library API-Version 2] If you intend to use API-Version 2 in your library, make sure to call 'sap/ui/base/DataType.registerEnum' for ${r}${n}.`)}else{const t=n.charAt(0);if(t===t.toLowerCase()&&t!==t.toUpperCase()){u=true}else{e[n]=i}}}if(u){e[n]=new Proxy(i,r);const a=`${t.get(e)}${n}.`;t.set(i,a)}}else{e[n]=i}return true},get(e,n){if(n===U){return true}return e[n]}};return r}k.init=function(n){if(!sap.ui.require("sap/ui/core/Core")){throw new Error("Library "+n.name+": Library must not be used before the core is ready!")}e(typeof n==="object","mSettings given to 'sap/ui/core/Lib.init' must be an object");e(typeof n.name==="string"&&n.name,"mSettings given to 'sap/ui/core/Lib.init' must have the 'name' property set");var t="sap/ui/core/Lib.init";a.debug("Analyzing Library "+n.name,null,t);var r=k._get(n.name,true);r.enhanceSettings(n);var i=Object.create(null),s;i=d.create(n.name);const o=n.apiVersion??1;if(![1,2].includes(o)){throw new TypeError(`The library '${n.name}' has defined 'apiVersion: ${o}', which is an unsupported value. The supported values are: 1, 2 and undefined (defaults to 1).`)}if(o<2){const e=$(n.name,i);i=new Proxy(i,e);d.set(n.name,i)}for(s=0;s<r.dependencies.length;s++){var l=r.dependencies[s];var c=k._get(l,true);a.debug("resolve Dependencies to "+l,null,t);if(!c.isSettingsEnhanced()){a.warning("Dependency from "+n.name+" to "+l+" has not been resolved by library itself",null,t);k._load({name:l},{sync:true})}}m.registerInterfaceTypes(r.interfaces);function f(e){const n=d.get(e);if(n instanceof m){return` to ensure that the type is defined. You can then access it by calling 'DataType.getType("${e}")'.`}else if(u(n)){return`. You can then reference this type via the library's module export.`}else{return`.`}}for(s=0;s<r.types.length;s++){if(!/^(any|boolean|float|int|string|object|void)$/.test(r.types[s])){const e=r.types[s];sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".js",()=>`Importing the pseudo module '${e.replace(/\./g,"/")}' is deprecated.`+` To access the type '${e}', please import '${r.name.replace(/\./g,"/")}/library'`+f(e)+` For more information, see documentation under 'Best Practices for Loading Modules'.`);var p=e.substring(0,e.lastIndexOf("."));if(d.get(p)===undefined){d.create(p)}}}(()=>{var e=r.controls.concat(r.elements);for(s=0;s<e.length;s++){sap.ui.lazyRequire(e[s],"new extend getMetadata")}})();if(!r.noLibraryCSS){var h={name:r.name,version:r.version,preloadedCss:q().indexOf(r.name)!==-1};x.push(h);M(!h.preloadedCss).then(function(e){e._includeLibraryThemeAndEnsureThemeRoot(h)})}r.sName=r.name;r.aControls=r.controls;k.fireLibraryChanged({name:n.name,stereotype:"library",operation:"add",metadata:r});return i};function I(e){return e.map(function(e){return e.name.replace(/\./g,"/")+"/library"})}function D(e){var n=I(e);return new Promise(function(t,r){sap.ui.require(n,function(){t(e)},r)})}k.load=function(e){if(typeof e==="string"){e={name:e}}else{e=["name","url"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{})}return k._load(e).then(function(e){return e[0]})};k._load=function(e,n){n=n||{};if(!Array.isArray(e)){e=[e]}var t={};var r=[];e.forEach(function(e){if(typeof e==="object"){if(e.hasOwnProperty("url")||e.hasOwnProperty("json")){t[e.name]=e}r.push(e)}else{r.push({name:e})}});var i=k.getPreloadMode()==="sync"||k.getPreloadMode()==="async",s=!n.preloadOnly;if(!n.sync){r=g._getTransitiveDependencyForLibraries(r)}var o=r.map(function(e){var n=k._get(e.name,true);if(n._loadingStatus==null&&t[e.name]&&t[e.name].url){O(e.name,t[e.name].url)}return n});if(n.sync){if(i){o.forEach(function(e){var n={sync:true};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}e._preload(n)})}if(s){I(o).forEach(function(e,n){if(o[n].isSettingsEnhanced()){return}sap.ui.requireSync(e);if(!o[n].isSettingsEnhanced()){a.warning("library "+o[n].name+" didn't initialize itself");k.init({name:o[n].name})}})}return o}const u=i?Promise.all(o.map(function(e){const n={};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}return e._preload(n)})):Promise.resolve(o);return s?u.then(D):u};k.getResourceBundleFor=function(e,n){var t=k._get(e,true);return t.getResourceBundle(n)};k._registerElement=function(e){var n=e.getName(),t=e.getLibraryName()||"";if(!t&&!n.includes(".")){return}let r=k._get(t);const i=e.isA("sap.ui.core.Control")?"controls":"elements";if(!r){d.create(t);r=k._get(t,true)}if(r[i].indexOf(n)<0){r[i].push(n);a.debug("Class "+n+" registered for library "+t);k.fireLibraryChanged({name:n,stereotype:e.getStereotype(),operation:"add",metadata:e})}};var J=new b;k.attachLibraryChanged=function(e,n){J.attachEvent("LibraryChanged",e,n)};k.detachLibraryChanged=function(e,n){J.detachEvent("LibraryChanged",e,n)};k.fireLibraryChanged=function(e){J.fireEvent("LibraryChanged",e)};r._enrichBundleConfig=function(e){if(!e.terminologies||!e.enhanceWith){var n=k._getByBundleUrl(e.url);if(n){var r=n._getI18nSettings();if(r){var i=n.name.replace(/\./g,"/");i=i.endsWith("/")?i:i+"/";i=sap.ui.require.toUrl(i);S._processResourceConfiguration(r,{alreadyResolvedOnRoot:true,relativeTo:i});e.fallbackLocale=e.fallbackLocale||r.fallbackLocale;e.supportedLocales=e.supportedLocales||r.supportedLocales;e.terminologies=e.terminologies||r.terminologies;e.enhanceWith=e.enhanceWith||r.enhanceWith;e.activeTerminologies=e.activeTerminologies||t.getActiveTerminologies()}}}return e};k.getVersionedLibCss=function(){return n.get({name:"sapUiVersionedLibCss",type:n.Type.Boolean,external:true})};k.isDepCacheEnabled=function(){return n.get({name:"sapUiXxDepCache",type:n.Type.Boolean,external:true})};k.getPreloadMode=function(){if(j.isDebugModeEnabled()===true){return""}let e=n.get({name:"sapUiPreload",type:n.Type.String,defaultValue:"auto",external:true});if(e==="auto"){if(window["sap-ui-optimized"]){e=sap.ui.loader.config().async?"async":"sync"}else{e=""}}return e};return k});
//# sourceMappingURL=Lib.js.map