/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Locale","sap/base/assert","sap/base/i18n/Formatting","sap/base/i18n/LanguageTag","sap/base/i18n/Localization","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/util/extend","sap/base/util/LoaderExtensions","sap/ui/base/Object","sap/ui/base/SyncPromise"],function(e,t,r,n,i,a,o,s,u,l,c){"use strict";var f=/c/i,g=/e/i,m=/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/,h=/0+$/;const d=/(.*)?\{[0|1]}(.*)?\{[0|1]}(.*)?/;const p=/^0+$/;const _=["narrow","abbreviated","wide"];const y={"acceleration-meter-per-second-squared":"acceleration-meter-per-square-second","concentr-milligram-per-deciliter":"concentr-milligram-ofglucose-per-deciliter","concentr-part-per-million":"concentr-permillion","consumption-liter-per-100kilometers":"consumption-liter-per-100-kilometer","mass-metric-ton":"mass-tonne","pressure-millimeter-of-mercury":"pressure-millimeter-ofhg","pressure-pound-per-square-inch":"pressure-pound-force-per-square-inch","pressure-inch-hg":"pressure-inch-ofhg","torque-pound-foot":"torque-pound-force-foot"};let v={};var b=l.extend("sap.ui.core.LocaleData",{constructor:function(t,r){l.apply(this);this.oLocale=e._getCoreLocale(t);this.loaded=T(this.oLocale,r).then(e=>{this.mData=e.mData;this.sCLDRLocaleId=e.sCLDRLocaleId;return this});this.loaded.finally(()=>{delete this.loaded})},_get:function(){return this._getDeep(this.mData,arguments)},_getMerged:function(){return this._get.apply(this,arguments)},_getMonthsWithAlternatives:function(e,t){return this._get(k(t),"months","format",e)},_getMonthsStandAloneWithAlternatives:function(e,t){return this._get(k(t),"months","stand-alone",e)},_getDeep:function(e,t){var r=e;for(var n=0;n<t.length;n++){r=r[t[n]];if(r===undefined){break}}return r},getOrientation:function(){return this._get("orientation")},getCurrentLanguageName:function(){return this.getLanguageName(this.oLocale.toString())},getLanguageName:function(e){const t=new n(e);let r=i.getModernLanguage(t.language);let a=t.script;if(r==="sr"&&a==="Latn"){r="sh";a=null}const o=t.region;const s=this._get("languages");const u=s[r];if(!a&&!o||!u){return u}const l=s[r+"_"+o]||s[r+"_"+a];if(l){return l}if(a){const e=this._get("scripts")[a];if(e){return u+" ("+e+")"}}if(o){const e=this._get("territories")[o];if(e){return u+" ("+e+")"}}return u},getLanguages:function(){const e=this._get("languages");["ar_001","de_AT","de_CH","en_AU","en_CA","en_GB","en_US","es_419","es_ES","es_MX","fa_AF","fr_CA","fr_CH","nds_NL","nl_BE","pt_BR","pt_PT","ro_MD","sw_CD","zh_Hans","zh_Hant"].forEach(t=>{if(!e[t]){e[t]=this.getLanguageName(t)}});return e},getScripts:function(){return this._get("scripts")},getTerritories:function(){return this._get("territories")},getMonths:function(e,r){t(_.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(k(r),"months","format",e).map(e=>Array.isArray(e)?e[0]:e)},getMonthsStandAlone:function(e,r){t(_.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(k(r),"months","stand-alone",e).map(e=>Array.isArray(e)?e[0]:e)},getDays:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(k(r),"days","format",e)},getDaysStandAlone:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(k(r),"days","stand-alone",e)},getQuarters:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"quarters","format",e)},getQuartersStandAlone:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"quarters","stand-alone",e)},getDayPeriods:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"dayPeriods","format",e)},getDayPeriodsStandAlone:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"dayPeriods","stand-alone",e)},getDatePattern:function(e,r){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(k(r),"dateFormats",e)},getFlexibleDayPeriods:function(e,t){return this._get(k(t),"flexibleDayPeriods","format",e)},getFlexibleDayPeriodsStandAlone:function(e,t){return this._get(k(t),"flexibleDayPeriods","stand-alone",e)},getFlexibleDayPeriodOfTime:function(e,t){var r,n,i;r=(e*60+t)%1440;n=this._get("dayPeriodRules");function a(e){var t=e.split(":"),r=t[0],n=t[1];return parseInt(r)*60+parseInt(n)}i=Object.keys(n).find(function(e){var t=n[e];return t["_at"]&&a(t["_at"])===r});if(i){return i}return Object.keys(n).find(function(e){var t,i,o,s=n[e];if(s["_at"]){return false}o=a(s["_from"]);t=a(s["_before"]);if(o>t){i=[{start:o,end:1440},{start:0,end:t}]}else{i=[{start:o,end:t}]}return i.some(function(e){return e.start<=r&&e.end>r})})},getTimePattern:function(e,r){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(k(r),"timeFormats",e)},getDateTimePattern:function(e,r){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(k(r),"dateTimeFormats",e)},getCombinedDateTimePattern:function(e,r,n){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");t(r=="short"||r=="medium"||r=="long"||r=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(e,n),a=this.getDatePattern(e,n),o=this.getTimePattern(r,n);return i.replace("{0}",o).replace("{1}",a)},getCombinedDateTimeWithTimezonePattern:function(e,t,r){return this.applyTimezonePattern(this.getCombinedDateTimePattern(e,t,r))},applyTimezonePattern:function(e){var t=[e];var r=[{group:"Timezone",length:2,field:"zone",symbol:"V"}];this._appendItems(t,r);return t[0]},getTimezoneTranslations:function(){var e=this.oLocale.toString();var t=b._mTimezoneTranslations[e];if(!t){b._mTimezoneTranslations[e]=t=P(this._get("timezoneNames"))}return Object.assign({},t)},getCustomDateTimePattern:function(e,t){var r=this._get(k(t),"dateTimeFormats","availableFormats");return this._getFormatPattern(e,r,t)},getIntervalPattern:function(e,t){var r=this._get(k(t),"dateTimeFormats","intervalFormats"),n,i,a,o,s;if(e){n=e.split("-");i=n[0];a=n[1];o=r[i];if(o){s=o[a];if(s){return s}}}return r.intervalFormatFallback},getCombinedIntervalPattern:function(e,t){const r=this._get(k(t),"dateTimeFormats","intervalFormats");const[,n,i,a]=d.exec(r.intervalFormatFallback);return b._escapeIfNeeded(n)+e+b._escapeIfNeeded(i)+e+b._escapeIfNeeded(a)},getCustomIntervalPattern:function(e,t,r){var n=this._get(k(r),"dateTimeFormats","intervalFormats");return this._getFormatPattern(e,n,r,t)},_getFormatPattern:function(e,t,r,n){var i,a,o;if(!n){i=t[e]}else if(typeof n==="string"){if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}o=t[e];i=o&&o[n]}if(i){if(typeof i==="object"){a=Object.keys(i).map(function(e){return i[e]})}else{return i}}if(!a){a=this._createFormatPattern(e,t,r,n)}if(a&&a.length===1){return a[0]}return a},_createFormatPattern:function(e,t,r,n){var i=this._parseSkeletonFormat(e),a,o=this._findBestMatch(i,e,t),s,u,l,c,f,g,m,h,d=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,p,_;if(n){if(typeof n==="string"){h=w[n]?w[n].group:"";if(h){p=C[h].index>i[i.length-1].index}m=n}else{p=true;if(i[0].symbol==="y"&&o&&o.pattern.G){l=w["G"];c=C[l.group];i.splice(0,0,{symbol:"G",group:l.group,match:l.match,index:c.index,field:c.field,length:1})}for(_=i.length-1;_>=0;_--){s=i[_];if(n[s.group]){p=false;break}}for(_=0;_<i.length;_++){s=i[_];if(n[s.group]){m=s.symbol;break}}if((m=="h"||m=="K")&&n.DayPeriod){m="a"}}if(p){return[this.getCustomDateTimePattern(e,r)]}if(o&&o.missingTokens.length===0){f=o.pattern[m];if(f&&o.distance>0){f=this._expandFields(f,o.patternTokens,i)}}if(!f){u=this._get(k(r),"dateTimeFormats","availableFormats");if(d.test(e)&&"ahHkKjJms".indexOf(m)>=0){f=this._getMixedFormatPattern(e,u,r,n)}else{g=this._getFormatPattern(e,u,r);f=this.getCombinedIntervalPattern(g,r)}}a=[f]}else if(!o){f=e;a=[f]}else{if(typeof o.pattern==="string"){a=[o.pattern]}else if(typeof o.pattern==="object"){a=[];for(var y in o.pattern){f=o.pattern[y];a.push(f)}}if(o.distance>0){if(o.missingTokens.length>0){if(d.test(e)){a=[this._getMixedFormatPattern(e,t,r)]}else{a=this._expandFields(a,o.patternTokens,i);a=this._appendItems(a,o.missingTokens,r)}}else{a=this._expandFields(a,o.patternTokens,i)}}}if(e.indexOf("J")>=0){a.forEach(function(e,t){a[t]=e.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"")})}return a},_parseSkeletonFormat:function(e){var t=[],r={index:-1},n,i,a;for(var o=0;o<e.length;o++){n=e.charAt(o);if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}if(n==r.symbol){r.length++;continue}i=w[n];a=C[i.group];if(i.group=="Other"||a.diffOnly){throw new Error("Symbol '"+n+"' is not allowed in skeleton format '"+e+"'")}if(a.index<=r.index){throw new Error("Symbol '"+n+"' at wrong position or duplicate in skeleton format '"+e+"'")}r={symbol:n,group:i.group,match:i.match,index:a.index,field:a.field,length:1};t.push(r)}return t},_findBestMatch:function(e,t,r){var n,i,a,o,s,u,l,c,f,g,m={distance:1e4,firstDiffPos:-1};for(var h in r){if(h==="intervalFormatFallback"||h.indexOf("B")>-1){continue}n=this._parseSkeletonFormat(h);u=0;i=[];l=true;if(e.length<n.length){continue}s=0;c=e.length;for(var d=0;d<e.length;d++){a=e[d];o=n[s];if(c===e.length){c=d}if(o){f=w[a.symbol];g=w[o.symbol];if(a.symbol===o.symbol){if(a.length===o.length){if(c===d){c=e.length}}else{if(a.length<f.numericCeiling?o.length<g.numericCeiling:o.length>=g.numericCeiling){u+=Math.abs(a.length-o.length)}else{u+=5}}s++;continue}else{if(a.match==o.match){u+=Math.abs(a.length-o.length)+10;s++;continue}}}i.push(a);u+=50-d}if(s<n.length){l=false}if(l&&(u<m.distance||u===m.distance&&c>m.firstDiffPos)){m.distance=u;m.firstDiffPos=c;m.missingTokens=i;m.pattern=r[h];m.patternTokens=n}}if(m.pattern){return m}},_expandFields:function(e,t,r){var n=typeof e==="string";var i;if(n){i=[e]}else{i=e}var a=i.map(function(e){var n={},i={},a="",o=false,s=0,u,l,c,f,g,m,h,d;r.forEach(function(e){n[e.group]=e});t.forEach(function(e){i[e.group]=e});while(s<e.length){d=e.charAt(s);if(o){a+=d;if(d=="'"){o=false}}else{h=w[d];if(h&&n[h.group]&&i[h.group]){g=n[h.group];m=i[h.group];u=g.length;c=m.length;l=1;while(e.charAt(s+1)==d){s++;l++}if(u===c||(u<h.numericCeiling?l>=h.numericCeiling:l<h.numericCeiling)){f=l}else{f=Math.max(l,u)}for(var p=0;p<f;p++){a+=d}}else{a+=d;if(d=="'"){o=true}}}s++}return a});return n?a[0]:a},_appendItems:function(e,t,r){var n=this._get(k(r),"dateTimeFormats","appendItems");e.forEach(function(r,i){var a,o,s;t.forEach(function(t){o=n[t.group];a="'"+this.getDisplayName(t.field)+"'";s="";for(var u=0;u<t.length;u++){s+=t.symbol}e[i]=o.replace(/\{0\}/,r).replace(/\{1\}/,s).replace(/\{2\}/,a)}.bind(this))}.bind(this));return e},_getMixedFormatPattern:function(e,t,r,n){var i=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,a=/MMMM|LLLL/,o=/MMM|LLL/,s=/E|e|c/,u,l,c,f,g,m,h,d;u=i.exec(e);l=u[1];c=u[2];g=this._getFormatPattern(l,t,r);if(n){m=this.getCustomIntervalPattern(c,n,r)}else{m=this._getFormatPattern(c,t,r)}if(a.test(l)){f=s.test(l)?"full":"long"}else if(o.test(l)){f="medium"}else{f="short"}h=this.getDateTimePattern(f,r);d=h.replace(/\{1\}/,g).replace(/\{0\}/,m);return d},getNumberSymbol:function(e){t(e=="decimal"||e=="group"||e=="plusSign"||e=="minusSign"||e=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+e)},getLenientNumberSymbols:function(e){t(e=="plusSign"||e=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[e]},getDecimalPattern:function(){return this._get("decimalFormat").standard},getCurrencyPattern:function(e,t){return this._get("currencyFormat")[t?e+"-"+t:e]},getPercentPattern:function(){return this._get("percentFormat").standard},getMiscPattern:function(e){t(e=="approximately"||e=="atLeast"||e=="atMost"||e=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[e]},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays")},getFirstDayOfWeek:function(){return this._get("weekData-firstDay")},getWeekendStart:function(){return this._get("weekData-weekendStart")},getWeekendEnd:function(){return this._get("weekData-weekendEnd")},getCustomCurrencyCodes:function(){var e=this._get("currency")||{},t={};Object.keys(e).forEach(function(e){t[e]=e});return t},getCurrencyDigits:function(e){const t=this.getAllCurrencyDigits();return t[e]??t["DEFAULT"]},getAllCurrencyDigits(){const e={...this._get("currencyDigits")};const t=this._get("currency");if(t){for(const r in t){if(t[r].digits!==undefined){e[r]=t[r].digits}}}return e},getCurrencySymbol:function(e){var t=this.getCurrencySymbols();return t&&t[e]||e},getCurrencyCodeBySymbol:function(e){var t=this._get("currencySymbols"),r;for(r in t){if(t[r]===e){return r}}return e},getCurrencySymbols:function(){var e=this._get("currency"),t={},r;for(var n in e){r=e[n].isoCode;if(e[n].symbol){t[n]=e[n].symbol}else if(r){t[n]=this._get("currencySymbols")[r]}}return Object.assign({},this._get("currencySymbols"),t)},getUnitDisplayName:function(e){var t=this.getUnitFormat(e);return t&&t["displayName"]||""},getRelativePatterns:function(e,r){if(r===undefined){r="wide"}t(r==="wide"||r==="short"||r==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=[],i=this.getPluralCategories(),a,o,s,u;if(!e){e=["year","month","week","day","hour","minute","second"]}e.forEach(function(e){a=this._get("dateFields",e+"-"+r);for(var t in a){if(t.indexOf("relative-type-")===0){s=parseInt(t.substr(14));n.push({scale:e,value:s,pattern:a[t]})}else if(t.indexOf("relativeTime-type-")==0){o=a[t];u=t.substr(18)==="past"?-1:1;i.forEach(function(t){var r=o["relativeTimePattern-count-"+t];if(r){n.push({scale:e,sign:u,pattern:r})}})}}}.bind(this));return n},getRelativePattern:function(e,r,n,i){var a,o,s,u;if(typeof n==="string"){i=n;n=undefined}if(n===undefined){n=r>0}if(i===undefined){i="wide"}t(i==="wide"||i==="short"||i==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");s=e+"-"+i;if(r===0||r===-2||r===2){a=this._get("dateFields",s,"relative-type-"+r)}if(!a){o=this._get("dateFields",s,"relativeTime-type-"+(n?"future":"past"));u=this.getPluralCategory(Math.abs(r).toString());a=o["relativeTimePattern-count-"+u]}return a},getRelativeSecond:function(e,t){return this.getRelativePattern("second",e,t)},getRelativeMinute:function(e,t){if(e==0){return null}return this.getRelativePattern("minute",e,t)},getRelativeHour:function(e,t){if(e==0){return null}return this.getRelativePattern("hour",e,t)},getRelativeDay:function(e,t){return this.getRelativePattern("day",e,t)},getRelativeWeek:function(e,t){return this.getRelativePattern("week",e,t)},getRelativeMonth:function(e,t){return this.getRelativePattern("month",e,t)},getDisplayName:function(e,r){t(e=="second"||e=="minute"||e=="hour"||e=="zone"||e=="day"||e=="weekday"||e=="week"||e=="month"||e=="quarter"||e=="year"||e=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(r===undefined){r="wide"}t(r==="wide"||r==="short"||r==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=["era","weekday","zone"],i=n.indexOf(e)===-1?e+"-"+r:e;return this._get("dateFields",i,"displayName")},getRelativeYear:function(e,t){return this.getRelativePattern("year",e,t)},getCompactDecimalPattern:function(e,t,r="other"){const n=this._get("decimalFormat-"+e);return n&&(n[t+"-"+r]||n[t+"-other"])},getCompactCurrencyPattern:function(e,t,r="other",n=undefined){const i=this._get("currencyFormat-"+e);const a=n?"-"+n:"";return i&&(i[t+"-"+r+a]||i[t+"-other"+a])},getListFormat:function(e,t){var r=this._get("listPattern-"+(e||"standard")+"-"+(t||"wide"));if(r){return r}return{}},getResolvedUnitFormat:function(e){e=this.getUnitFromMapping(e)||e;return this.getUnitFormat(e)},getUnitFormat:function(e){var t=this._get("units","short",e);if(!t&&y[e]){t=this._get("units","short",y[e])}return t},getUnitFormats:function(){return this._getMerged("units","short")},getUnitFromMapping:function(e){return this._get("unitMappings",e)},getEras:function(e,r){t(e=="wide"||e=="abbreviated"||e=="narrow","sWidth must be wide, abbreviate or narrow");var n=this._get(k(r),"era-"+e),i=[];for(var a in n){i[parseInt(a)]=n[a]}return i},getEraDates:function(e=r.getCalendarType()){var t=this._get("eras-"+e.toLowerCase()),n=[];for(var i in t){n[parseInt(i)]=t[i]}return n},getCalendarWeek:function(e,r){t(e=="wide"||e=="narrow","sStyle must be wide or narrow");const n=this._get("sap-calendarWeek")[e];return r?n.replace("{0}",r):n},firstDayStartsFirstWeek:function(){return this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="US"},getPreferredCalendarType:function(){var e,t,r,n=this._get("calendarPreference")||[];for(r=0;r<n.length;r++){e=n[r].split("-")[0];for(t in a){if(e===t.toLowerCase()){return t}}}return a.Gregorian},getPreferredHourSymbol:function(){return this._get("timeData","_preferred")},getPluralCategories:function(){var e=this._get("plurals"),t=Object.keys(e);t.push("other");return t},getPluralCategory:function(e){var t=typeof e==="number"?e.toString():e,r=this._get("plurals");if(!this._pluralTest){this._pluralTest={}}for(var n in r){var i=this._pluralTest[n];if(!i){i=this._parsePluralRule(r[n]);this._pluralTest[n]=i}if(i(t).bMatch){return n}}return"other"},_parsePluralRule:function(e){var t="or",r="and",n="%",i="=",a="!=",o="n",s="i",u="f",l="t",c="v",m="w",d="c",p="e",_="..",y=",";var v=0,C;C=e.split(" ");function w(e){if(C[v]===e){v++;return true}return false}function D(){var e=C[v];v++;return e}function P(){var e,r;e=k();if(w(t)){r=P();return function(t){return e(t)||r(t)}}return e}function k(){var e,t;e=T();if(w(r)){t=k();return function(r){return e(r)&&t(r)}}return e}function T(){var e,t,r;e=F();if(w(i)){r=true}else if(w(a)){r=false}else{throw new Error("Expected '=' or '!='")}t=L();if(r){return function(r){return t(r).indexOf(e(r))>=0}}else{return function(r){return t(r).indexOf(e(r))===-1}}}function F(){var e;e=S();if(w(n)){var t=parseInt(D());return function(r){return e(r)%t}}return e}function S(){if(w(o)){return function(e){return e.n}}else if(w(s)){return function(e){return e.i}}else if(w(u)){return function(e){return e.f}}else if(w(l)){return function(e){return e.t}}else if(w(c)){return function(e){return e.v}}else if(w(m)){return function(e){return e.w}}else if(w(d)){return function(e){return e.c}}else if(w(p)){return function(e){return e.c}}else{throw new Error("Unknown operand: "+D())}}function L(){var e=[],t=D(),r=t.split(y),n,i,a;r.forEach(function(t){n=t.split(_);if(n.length===1){e.push(parseInt(t))}else{i=parseInt(n[0]);a=parseInt(n[1]);for(var r=i;r<=a;r++){e.push(r)}}});return function(t){return e}}var x=P();if(v!=C.length){throw new Error("Not completely parsed")}return function(e){var t,r,n,i,a,o,s;e=e.replace(f,"e");n=e.search(g);r=n<0?0:parseInt(e.slice(n+1));e=b.convertToDecimal(e);t=e.indexOf(".");if(t===-1){o=e;i="";a=""}else{o=e.slice(0,t);i=e.slice(t+1);a=i.replace(h,"")}s={n:parseFloat(e),i:parseInt(o),v:i.length,w:a.length,f:i===""?0:parseInt(i),t:a===""?0:parseInt(a),c:r};return{bMatch:x(s),oOperands:s}}}});b.convertToDecimal=function(e){var t,r,n,i,a,o,s=String(e);if(!s.includes("e")&&!s.includes("E")){return s}o=s.match(m);i=o[1]==="-";s=o[2].replace(".","");if(p.test(s)){return"0"}t=o[3]?o[3].length:0;n=o[4]?o[4].length:0;r=parseInt(o[5]);a=t+r;if(r>0){s=r<n?s.slice(0,a)+"."+s.slice(a):s=s.padEnd(a,"0")}else{s=-r<t?s=s.slice(0,a)+"."+s.slice(a):s="0."+s.padStart(n-r,"0")}if(i){s="-"+s}return s};var C={Era:{field:"era",index:0},Year:{field:"year",index:1},Quarter:{field:"quarter",index:2},Month:{field:"month",index:3},Week:{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},Day:{field:"day",index:6},DayPeriod:{field:"hour",index:7,diffOnly:true},Hour:{field:"hour",index:8},Minute:{field:"minute",index:9},Second:{field:"second",index:10},Timezone:{field:"zone",index:11}};var w={G:{group:"Era",match:"Era",numericCeiling:1},y:{group:"Year",match:"Year",numericCeiling:100},Y:{group:"Year",match:"Year",numericCeiling:100},Q:{group:"Quarter",match:"Quarter",numericCeiling:3},q:{group:"Quarter",match:"Quarter",numericCeiling:3},M:{group:"Month",match:"Month",numericCeiling:3},L:{group:"Month",match:"Month",numericCeiling:3},w:{group:"Week",match:"Week",numericCeiling:100},W:{group:"Week",match:"Week",numericCeiling:100},d:{group:"Day",match:"Day",numericCeiling:100},D:{group:"Day",match:"Day",numericCeiling:100},E:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},e:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},c:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},h:{group:"Hour",match:"Hour12",numericCeiling:100},H:{group:"Hour",match:"Hour24",numericCeiling:100},k:{group:"Hour",match:"Hour24",numericCeiling:100},K:{group:"Hour",match:"Hour12",numericCeiling:100},m:{group:"Minute",match:"Minute",numericCeiling:100},s:{group:"Second",match:"Second",numericCeiling:100},z:{group:"Timezone",match:"Timezone",numericCeiling:1},Z:{group:"Timezone",match:"Timezone",numericCeiling:1},O:{group:"Timezone",match:"Timezone",numericCeiling:1},v:{group:"Timezone",match:"Timezone",numericCeiling:1},V:{group:"Timezone",match:"Timezone",numericCeiling:1},X:{group:"Timezone",match:"Timezone",numericCeiling:1},x:{group:"Timezone",match:"Timezone",numericCeiling:1},S:{group:"Other",numericCeiling:100},u:{group:"Other",numericCeiling:100},U:{group:"Other",numericCeiling:1},r:{group:"Other",numericCeiling:100},F:{group:"Other",numericCeiling:100},g:{group:"Other",numericCeiling:100},a:{group:"DayPeriod",numericCeiling:1},b:{group:"Other",numericCeiling:1},B:{group:"Other",numericCeiling:1},A:{group:"Other",numericCeiling:100}};const D=["ar","ar_EG","ar_SA","bg","ca","cnr","cs","cy","da","de","de_AT","de_CH","el","el_CY","en","en_AU","en_GB","en_HK","en_IE","en_IN","en_NZ","en_PG","en_SG","en_ZA","es","es_AR","es_BO","es_CL","es_CO","es_MX","es_PE","es_UY","es_VE","et","fa","fi","fr","fr_BE","fr_CA","fr_CH","fr_LU","he","hi","hr","hu","id","it","it_CH","ja","kk","ko","lt","lv","mk","ms","nb","nl","nl_BE","pl","pt","pt_PT","ro","ru","ru_UA","sk","sl","sr","sr_Latn","sv","th","tr","uk","vi","zh_CN","zh_HK","zh_SG","zh_TW"];function P(e,t,r,n){n=n?n.slice():[];r=r||{};t=t||"";Object.keys(e).forEach(function(i){var a=e[i];if(typeof a==="object"){var o=n.slice();var s=a["_parent"];if(s){o.push(s)}P(a,t+i+"/",r,o)}else if(typeof a==="string"&&i!=="_parent"){var u=n.length?n.join(", ")+", ":"";r[t+i]=u+a}});return r}function k(e){if(!e){e=r.getCalendarType()}return"ca-"+e.toLowerCase()}function T(e,t){var r=e.getLanguage()||"",n=e.getRegion()||"",a=e.getScript()||"";function o(e,t){var r,n,i;if(!t){return}for(r in t){if(t.hasOwnProperty(r)){n=e[r];i=t[r];if(n===undefined){e[r]=i}else if(n===null){delete e[r]}else if(typeof n==="object"&&typeof i==="object"&&!Array.isArray(n)){o(n,i)}}}}function s(e){if(!v[e]&&D.includes(e)||v[e]instanceof Promise&&!t){v[e]=c.resolve(u.loadResource(`sap/ui/core/cldr/${e}.json`,{async:t,dataType:"json",failOnError:false})).then(t=>{if(t){return s(t.__fallbackLocale).then(r=>{o(t,r);v[e]=t;delete t.__fallbackLocale;return t})}return t}).unwrap()}return c.resolve(v[e])}r=r&&i.getModernLanguage(r)||r;if(r==="no"){r="nb"}if(r==="zh"&&!n){if(a==="Hans"){n="CN"}else if(a==="Hant"){n="TW"}}if(r==="sh"||r==="sr"&&a==="Latn"){r="sr_Latn"}const l=r+"_"+n;let f=l;return s(l).then(e=>{if(!e){f=r;return s(r)}return e}).then(e=>{if(!e){f="en";return s("en")}return e}).then(e=>({mData:e,sCLDRLocaleId:f.replace(/_/g,"-")}))}var F=b.extend("sap.ui.core.CustomLocaleData",{constructor:function(e){b.apply(this,arguments);this.mCustomData=r.getCustomLocaleData()},_get:function(){var e=Array.prototype.slice.call(arguments),t,r;if(e[0].indexOf("ca-")==0){t=e[0];if(t==k()){e=e.slice(1)}}r=e.join("-");var n=this.mCustomData[r];if(n==null){n=this._getDeep(this.mCustomData,arguments);if(n==null){n=this._getDeep(this.mData,arguments)}}return n},_getMerged:function(){var e=this._getDeep(this.mData,arguments);var t=this._getDeep(this.mCustomData,arguments);return s({},e,t)},getFirstDayOfWeek:function(){var e=r.getCalendarWeekNumbering();if(e===o.Default){return b.prototype.getFirstDayOfWeek.call(this)}return o.getWeekConfigurationValues(e).firstDayOfWeek},getMinimalDaysInFirstWeek:function(){var e=r.getCalendarWeekNumbering();if(e===o.Default){return b.prototype.getMinimalDaysInFirstWeek.call(this)}return o.getWeekConfigurationValues(e).minimalDaysInFirstWeek}});b._resetLocaleDataCache=function(){v={}};b.getInstance=function(t){t=e._getCoreLocale(t);return t.hasPrivateUseSubtag("sapufmt")?new F(t):new b(t)};b.requestInstance=function(t){const r=e._getCoreLocale(t);const n=r.hasPrivateUseSubtag("sapufmt")?new F(r,true):new b(r,true);return Promise.resolve(n.loaded)};b._cldrLocales=D;b._mTimezoneTranslations={};const S=new RegExp("["+Object.keys(w).join("")+"]");const L=/^(\s)?(.*?)(\s)?$/;b._escapeIfNeeded=function(e){if(e===undefined){return""}if(S.test(e)){return e.replace(L,"$1'$2'$3")}return e};b.prototype.getCurrencyFormat=b.prototype.getCompactCurrencyPattern;b.prototype.getDecimalFormat=b.prototype.getCompactDecimalPattern;return b});
//# sourceMappingURL=LocaleData.js.map