/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/base/DataType","sap/ui/base/Event","sap/ui/base/ManagedObject","sap/ui/base/Object","sap/ui/base/ObjectPool","./Control","./Element","./EventBus","./FocusHandler","./IntervalTrigger","./RenderManager","./ResizeHandler","./library","./StaticArea","sap/base/assert","sap/base/Log","sap/base/i18n/Localization","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/each","sap/base/util/deepExtend","sap/ui/events/F6Navigation","sap/ui/base/EventProvider","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jqueryui/jquery-ui-position","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(t,e,o,i,s,n,r,a,l,u,f,p,h,c,d,_,g,b,m,v,y,C,E,P,S,jQuery){"use strict";var O=c.CSSSize;var I=c.OpenState;var w=c.Collision;var L;var x;var F;var k="sapUiPopupResize";var A=new l;if(window.ResizeObserver){F=new window.ResizeObserver(function(t){N(jQuery("#sap-ui-blocklayer-popup"),t[0].target)})}else{F={observe:function(t){var e=t.dataset[k];if(!e){e=h.register(t,function(t){N(jQuery("#sap-ui-blocklayer-popup"),t.target)});t.dataset[k]=e}},unobserve:function(t){var e=t.dataset[k];if(e){h.deregister(e);delete t.dataset[k]}}}}function R(){if(L){return L}var t;try{L=d.getUIArea()}catch(t){g.error(t);throw new Error("Popup cannot be opened because static UIArea cannot be determined.")}t=new r;L.addDependent(t);L=t.getUIArea();t.destroy();return L}function D(t){var e;if(typeof t==="string"){e=document.querySelector(t)}else if(t instanceof a){e=t.getDomRef()}else{e=t}return e||window}function B(t){var e=["left","top","width","height"];if(t[0]){t[0].classList.remove("sapUiBLyWithin");e.forEach(function(e){t[0].style.removeProperty(e)})}}function N(t,e){var o=e.getBoundingClientRect();t.css({width:o.width,height:o.height}).addClass("sapUiBLyWithin").position({my:"left top",at:"left top",of:e})}var T=i.extend("sap.ui.core.Popup",{constructor:function(t,e,o,s){_(arguments.length==0||t&&typeof t==="object","oContent must be an object or there may be no arguments at all");_(e===undefined||e===true||e===false,"bModal must be true, false, or undefined");_(o===undefined||o===true||o===false,"bShadow must be true, false, or undefined");_(s===undefined||s===true||s===false,"bAutoClose must be true, false, or undefined");i.apply(this);this._popupUID=v();this.bOpen=false;this.eOpenState=I.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;this._mEvents["sap.ui.core.Popup.extendFocusInfo-"+this._popupUID]=this._extendFocusInfoEventBusWrapper;if(t){this.setContent(t)}this._oDefaultPosition={my:T.Dock.CenterCenter,at:T.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!e;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof o==="boolean"?o:true;this._bAutoClose=!!s;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(t){if(t.isMarked("delayedMouseEvent")||t.isMarked("cancelAutoClose")){return}if(this.eOpenState===I.CLOSING||this.eOpenState===I.CLOSED){return}if(!this._contains(t.target)){this.close()}}.bind(this)}this._F6NavigationHandler=function(t){var e={},o=this._sF6NavMode,i;if(o=="DOCK"){if(this._bModal){o="NONE"}else if(this._oLastPosition&&this._oLastPosition.of){i=this._getOfDom(this._oLastPosition.of);if(!i||i===document){i=null;o="NONE"}}}switch(o){case"SCOPE":e.scope=this._$()[0];break;case"DOCK":e.target=i;var s=jQuery(i).parents("[data-sap-ui-popup]");e.scope=s.length?s[0]:null;break;default:e.skip=true}P.handleF6GroupNavigation(t,e)}.bind(this)},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{childPopups:{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{opened:{},closed:{}}}});T.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[])};T.prototype.addChildPopup=function(t){return this.addAssociation("childPopups",t)};T.prototype.removeChildPopup=function(t){return this.removeAssociation("childPopups",t)};T.blStack=[];T.Dock={BeginTop:"BeginTop",BeginCenter:"BeginCenter",BeginBottom:"BeginBottom",LeftTop:"LeftTop",LeftCenter:"LeftCenter",LeftBottom:"LeftBottom",CenterTop:"CenterTop",CenterCenter:"CenterCenter",CenterBottom:"CenterBottom",RightTop:"RightTop",RightCenter:"RightCenter",RightBottom:"RightBottom",EndTop:"EndTop",EndCenter:"EndCenter",EndBottom:"EndBottom"};e.registerEnum("sap.ui.core.Popup.Dock",T.Dock);T.prototype.touchEnabled=t.support.touch&&(t.browser.safari||!t.system.combi);T.prototype.preventBrowserFocus=t.support.touch&&!t.system.combi;var U=s.extend("sap.ui.core.Popup.Layer",{constructor:function(){s.call(this);var t=this.getDomString();this._$Ref=jQuery(t).appendTo(d.getDomRef())}});U.prototype.init=function(t,e){this._$Ref.css({visibility:"visible","z-index":e});this.update(t,e);this._$Ref.insertAfter(t).show()};U.prototype.update=function(t,e){if(t.length){var o=t.rect();this._$Ref.css({left:o.left,top:o.top});if(t.css("right")!="auto"&&t.css("right")!="inherit"){this._$Ref.css({right:t.css("right"),width:"auto"})}else{this._$Ref.css({width:o.width,right:"auto"})}if(t.css("bottom")!="auto"&&t.css("bottom")!="inherit"){this._$Ref.css({bottom:t.css("bottom"),height:"auto"})}else{this._$Ref.css({height:o.height,bottom:"auto"})}if(typeof e==="number"){this._$Ref.css("z-index",e)}}};U.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(d.getDomRef())}};U.prototype.getDomString=function(){g.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return""};var M=U.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){U.apply(this)}});M.prototype.getDomString=function(){return'<div class="sapUiPopupShield" id="sap-ui-shieldlayer-'+v()+'"></div>'};T.prototype.oShieldLayerPool=new n(M);(function(){var t=0;var e=Math.pow(2,32)-1;T.setInitialZIndex=function(o){if(o>=e){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER")}t=Math.max(o,this.getLastZIndex())};T.getLastZIndex=function(){return t};T.prototype.getLastZIndex=function(){return T.getLastZIndex()};T.getNextZIndex=function(){t+=10;if(t>=e){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER")}return t};T.prototype.getNextZIndex=function(){return T.getNextZIndex()}})();var $=function(t,e){if(!t&&e||t&&!e){return false}if(!t&&!e){return true}var o=3;var i=Math.abs(t.left-e.left);var s=Math.abs(t.top-e.top);var n=Math.abs(t.width-e.width);var r=Math.abs(t.height-e.height);if(i>o||s>o||n>o||r>o){return false}return true};T.prototype.open=function(t,e,o,i,s,n,l,u){_(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=I.CLOSED){return}if(typeof t=="string"){u=l;l=n;n=s;s=i;i=o;o=e;e=t;t=-1}if(typeof l==="boolean"||typeof l==="function"||l===T.CLOSE_ON_SCROLL){u=l;l=undefined}if(t===undefined){t=-1}_(t===-1||typeof t==="number"&&t%1==0,"iDuration must be an integer (or omitted)");_(e===undefined||typeof e==="string","my must be a string or empty");_(o===undefined||typeof o==="string","at must be a string or empty");_(!i||typeof i==="object"||typeof i==="function","of must be empty or an object");_(!s||typeof s==="string","offset must be empty or a string");_(!n||w.isValid(n),"collision must be empty or of type sap.ui.core.Collision");_(!l||l===window||typeof l==="string"||l instanceof a||l instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");_(!u||typeof u==="boolean"||typeof u==="function"||u===T.CLOSE_ON_SCROLL,"followOf must be either empty or a boolean");this.eOpenState=I.OPENING;var f=R(),p;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof r){if(!this.oContent.getParent()){f.addContent(this.oContent,true);this._bContentAddedToStatic=true}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return f};this._bUIAreaPatched=true}p=this.oContent.getUIArea();if(T._bEnableUIAreaCheck&&p.getRootNode().id!==f.getRootNode().id){g.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!")}}this._oPreviousFocus=T.getCurrentFocusInfo();if(this.isInPopup(i)||this.isInPopup(this._oPosition.of)){var h=this.getParentPopupId(i)||this.getParentPopupId(this._oPosition.of);var c="";var b=this.getContent();if(b instanceof a){c=b.getId()}else if(typeof b==="object"){c=b.id}this.addChildToPopup(h,c);this.addChildToPopup(h,this._popupUID)}var m=this._$(true);m.addClass("sapUiPopupInitial");m.css({position:"absolute",display:"block",visibility:"visible",opacity:""});var v="fast";if(t===0||t>0){v=t}else if(this._durations.open===0||this._durations.open>0){v=this._durations.open}var y;if(e||o||i||s||n||l){y=this._createPosition(e,o,i,s,n,l);this._oPosition=y}else{y=this._oPosition;if(!this._bOwnWithin&&x){this._oPosition.within=x}}if(!y.of){y.of=this._oPosition.of||document}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var C=d.getDomRef();if(!(m[0].parentNode==C)){m.appendTo(C)}m.css("z-index",this._iZIndex);g.debug("position popup content "+m.attr("id")+" at "+JSON.stringify(y.at));this._applyPosition(y);if(u!==undefined){this.setFollowOf(u)}m.toggleClass("sapUiShd",this._bShadow);var E=v==0;this._duringOpen(!E);if(E){this._opened()}else if(this._animations.open){this._animations.open.call(null,m,v,this._opened.bind(this))}else{m.fadeTo(v,1,this._opened.bind(this))}};T.prototype._getDomRefToFocus=function(){var t=this._$(false,true),e,o;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){o=a.getElementById(this._sInitialFocusId);if(o){e=o.getFocusDomRef()}e=e||window.document.getElementById(this._sInitialFocusId)}e=e||t.firstFocusableDomRef()}return e};T.prototype._opened=function(){if(this.eOpenState!==I.OPENING){return}this.bOpen=true;var t=this._$(false,true);t.removeClass("sapUiPopupInitial");this._activateFocusHandle();this._$(false,true).on("keydown",this._F6NavigationHandler);if(this.getFollowOf()){T.DockTrigger.addListener(T.checkDocking,this)}this.eOpenState=I.OPEN;this.fireOpened()};T.prototype._duringOpen=function(t){T._clearSelection();this._setupUserSelection();if(this._bModal){this._showBlockLayer()}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus()}var o=this._getOfDom(this._oLastPosition.of);var i=jQuery(o).rect();if(this._oLastOfRect&&i&&!$(this._oLastOfRect,i)){this._applyPosition(this._oLastPosition)}}if(this.oContent instanceof a){this.oContent.addDelegate(this)}this.bOpen=true};T.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId};T.prototype._contains=function(t){var e=this._$().get(0);if(!e){return false}var o=e.contains(t);var i;if(!o){i=this.getChildPopups();o=i.some(function(e){var o=e?window.document.getElementById(e):null;var i=o&&o.contains(t);if(!i){var s="sap.ui.core.Popup.contains-"+e;var n={domRef:t};A.publish("sap.ui",s,n);i=n.contains}return i})}if(!o){W.forEach(function(e){o=o||jQuery(t).closest(e).length>0})}return o};T.prototype._containsEventBusWrapper=function(t,e,o){o.contains=this._contains(o.domRef)};T.prototype.onFocusEvent=function(e){var o=jQuery.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){o=jQuery.event.fix(arguments[2])}var i=o.type=="focus"||o.type=="activate"?"focus":"blur";var s=false;if(i=="focus"){var n=this._$().get(0);if(n){s=this._contains(o.target);g.debug("focus event on "+o.target.id+", contains: "+s);if(this._bModal&&!s){var r=T.blStack.length>0&&T.blStack[T.blStack.length-1].popup===this;if(r){if(t.system.desktop||jQuery(o.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus()}}.bind(this),0)}else{n.focus()}}}}else if(this._bAutoClose&&s&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null}}}else if(i=="blur"){g.debug("blur event on "+o.target.id);if(this._bModal){this.oLastBlurredElement=o.target}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(o.target===document.activeElement){return}var a=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(a,"autocloseBlur");var t=this._oLastPosition&&this._oLastPosition.of;if(t){var e=this.getParentPopupId(t);if(e){var i="sap.ui.core.Popup.onFocusEvent-"+e;A.publish("sap.ui",i,o)}}}.bind(this),a)}}}};T.prototype.setInitialFocusId=function(t){_(!t||typeof t==="string","sId must be a string or empty");this._sInitialFocusId=t};T.prototype.close=function(t){if(T._autoCloseDebug){return}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null}_(t===undefined||typeof t==="number"&&t%1==0,"iDuration must be empty or an integer");if(this.eOpenState==I.CLOSED||this.eOpenState==I.CLOSING){return}var e="fast";if(t===0||t>0){e=t}else if(this._durations.close===0||this._durations.close>0){e=this._durations.close}this.eOpenState=I.CLOSING;if(this.getFollowOf()){T.DockTrigger.removeListener(T.checkDocking,this)}if(this.oContent){if(this._bContentAddedToStatic){A.publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var o=d.getUIArea();const t=o.indexOfContent(this.oContent);if(t>=0){o.removeContent(t,true)}}else if(this._bUIAreaPatched){delete this.oContent.getUIArea}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof a){this.oContent.removeDelegate(this)}var i=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents()}if(this.isInPopup(this._oLastPosition.of)){var s=this.getParentPopupId(this._oLastPosition.of);var n="";var r=this.getContent();if(r instanceof a){n=r.getId()}else if(typeof r==="object"){n=r.id}this.removeChildFromPopup(s,n);this.removeChildFromPopup(s,this._popupUID)}if(this._bModal&&this.preventBrowserFocus){i.one("mousedown",function(t){t.preventDefault()})}this._duringClose();if(e==0){this._closed()}else if(this._animations.close){this._animations.close.call(null,i,e,this._closed.bind(this))}else{i.fadeOut(e,this._closed.bind(this))}};T.prototype._closed=function(){var t=this._$(false,true);if(this._bModal){this._hideBlockLayer()}T._clearSelection();this._restoreUserSelection();if(t.length){var e=t.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right=""}t=this._$(false,true);e=t.length?t[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right=""}}if(this._bModal){T.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null}this.bOpen=false;this.eOpenState=I.CLOSED;var o=this.getChildPopups();for(var i=0,s=o.length;i<s;i++){this.closePopup(o[i])}this.fireClosed()};T.prototype._duringClose=function(){if(this._resizeListenerId){h.deregister(this._resizeListenerId);this._resizeListenerId=null}};T.getCurrentFocusInfo=function(){var t=null;var e=a.closestTo(document.activeElement);if(e){t={sFocusId:e.getId(),oFocusInfo:e.getFocusInfo()}}else{t={sFocusId:document.activeElement.id,oFocusedElement:document.activeElement,oFocusInfo:{}}}if(t){t.popup=this}return t};T.applyFocusInfo=function(t){var e={preventScroll:true};if(t){var o=a.getElementById(t.sFocusId);if(o){o.applyFocusInfo(Object.assign(e,t.oFocusInfo))}else{var i=(t.sFocusId?window.document.getElementById(t.sFocusId):null)||t.oFocusedElement;if(i){i.focus(e)}}}};T.prototype.setContent=function(t){_(typeof t==="object","oContent must be an object");this.oContent=t;return this};T.prototype.getContent=function(){return this.oContent};T.prototype.setPosition=function(t,e,o,i,s,n){_(typeof t==="string","my must be a string");_(typeof e==="string"||typeof e==="object"&&typeof e.left==="number"&&typeof e.top==="number","my must be a string or an object with 'left' and 'top' properties");_(!o||typeof o==="object"||typeof o==="function","of must be empty or an object");_(!i||typeof i==="string","offset must be empty or a string");_(!s||w.isValid(s),"collision must be empty or of type sap.ui.core.Collision");_(!n||n===window||typeof n==="string"||n instanceof a||n instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");this._oPosition=this._createPosition(t,e,o,i,s,n);if(this.eOpenState!=I.CLOSED){this._applyPosition(this._oPosition)}return this};function H(t){const e=/^([A-Z][a-z]+){2}$/;if(e.test(t)){return t.replace(/([a-z])([A-Z])/g,"$1 $2").toLowerCase()}else{return t}}function Z(t){if(!jQuery.ui.version){if(T._bNewOffset==null){T._bNewOffset=true;var e=jQuery(document.createElement("div"));e.position({of:window,using:function(t,e){T._bNewOffset=e!==undefined}})}}const o=Object.assign({},t);if(typeof o.my==="string"){o.my=H(o.my)}if(typeof o.at==="string"){o.at=H(o.at)}if(T._bNewOffset||m(jQuery.ui.version).compareTo("1.8.23")>0){if(o.offset&&o.offset!="0 0"){const t=o.my.split(" ");const e=o.offset.split(" ");var i=[parseInt(e[0])<0?"":"+",parseInt(e[1])<0?"":"+"];o.my=t[0]+i[0]+e[0]+" "+t[1]+i[1]+e[1];delete o.offset}}return o}T.prototype._createPosition=function(t,e,o,i,s,n){var r=y({},this._oDefaultPosition,{my:t||this._oDefaultPosition.my,at:e||this._oDefaultPosition.at,of:o,offset:i,collision:s});if(n||x){r.within=n||x}this._bOwnWithin=!!n;return r};T.prototype._getPositionOffset=function(){var t=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var e=this._oPosition.my.split(" ");var o=e[0].indexOf("+");if(o<0){o=e[0].indexOf("-")}if(o>=0){t[0]=e[0].slice(o)}o=e[1].indexOf("+");if(o<0){o=e[1].indexOf("-")}if(o>=0){t[1]=e[1].slice(o)}}else if(this._oPosition.offset){t=this._oPosition.offset.split(" ")}return t};T.prototype._applyPosition=function(t){var e=b.getRTL();var o=this._$();const i=Z(t);if(o.length){var s=i.at;var n=o.get(0);if(typeof s==="string"){n.style.display="block";n.style.left="";n.style.right="";o.position(this._resolveReference(this._convertPositionRTL(i,e)));this._fixPositioning(i,e)}else if(O.isValid(s.left)&&O.isValid(s.top)){o.css({left:s.left,top:s.top})}else if(O.isValid(s.right)&&O.isValid(s.top)){o.css({right:s.right,top:s.top})}else if(typeof s.left==="number"&&typeof s.top==="number"){var r=o[0];if(r&&r.style.right){var a=o[0].getBoundingClientRect().width;o.css({right:document.documentElement.clientWidth-(s.left+a)+"px",top:s.top+"px"})}else{o.css({left:s.left+"px",top:s.top+"px"})}}this._oLastPosition=t;this._oLastOfRect=this._calcOfRect(i.of)}};T.prototype._calcOfRect=function(t){var e=this._getOfDom(t);if(e){return jQuery(e).rect()}return null};T.prototype._getOfDom=function(t){if(t instanceof jQuery.Event){return null}var e;if(typeof t==="string"){e=jQuery(document.getElementById(t))}else if(t instanceof jQuery){e=t}else{e=jQuery(t instanceof a?t.getDomRef():t)}return e[0]};T.prototype._convertPositionRTL=function(t,e){var o=Object.assign({},t);if(e){var i=false;if(o.my&&(o.my.indexOf("+")>=0||o.my.indexOf("-")>=0)){i=true}if((o.offset||i)&&(o.my.indexOf("begin")>-1||o.my.indexOf("end")>-1)&&(o.at.indexOf("begin")>-1||o.at.indexOf("end")>-1)){if(i){var s=o.my.split(" ");if(s.length==2){o.my="";if(s[0]){if(s[0].indexOf("begin")>-1||s[0].indexOf("end")>-1){if(s[0].indexOf("+")>-1){s[0]=s[0].replace("+","-")}else if(s[0].indexOf("-")>-1){s[0]=s[0].replace("-","+")}}o.my=s[0]}if(s[1]){if(s[1].indexOf("begin")>-1||s[1].indexOf("end")>-1){if(s[1].indexOf("+")>-1){s[1]=s[1].replace("+","-")}else if(s[1].indexOf("-")>-1){s[1]=s[1].replace("-","+")}}if(s[0]){o.my=o.my+" "}o.my=o.my+s[1]}}}else{o.offset=this._mirrorOffset(o.offset)}}o.my=o.my.replace("begin","right").replace("end","left");o.at=o.at.replace("begin","right").replace("end","left")}else{o.my=o.my.replace("end","right").replace("begin","left");o.at=o.at.replace("end","right").replace("begin","left")}return o};T.prototype._mirrorOffset=function(t){var e=String(t).trim().split(/\s/);var o=parseInt(e[0]);return-o+" "+e[e.length-1]};T.prototype._fixPositioning=function(t,e){var o=t.my;if(typeof o==="string"){if(T._isPositionFixingNeeded(o,e)){var i=this._$();var s=jQuery(window).width()-i[0].getBoundingClientRect().width-i.offset().left;i.css({right:s+"px",left:""})}}};T._isPositionFixingNeeded=function(t,e){return e&&(t.indexOf("right")>-1||t.indexOf("begin")>-1||t.indexOf("center")>-1)||!e&&(t.indexOf("right")>-1||t.indexOf("end")>-1)};T.prototype._resolveReference=function(t){var e,o=["of","within"];o.forEach(function(o){if(t[o]instanceof a){e=e||{};e[o]=t[o].getDomRef()}});return e?Object.assign({},t,e):t};T.prototype.setShadow=function(t){_(typeof t==="boolean","bShowShadow must be boolean");this._bShadow=t;if(this.eOpenState!=I.CLOSED){this._$().toggleClass("sapUiShd",t)}return this};T.prototype.setModal=function(t,e){_(typeof t==="boolean","bModal must be boolean");_(!e||typeof e==="string","sModalCSSClass must be empty or a string");var o=this._bModal;this._bModal=t;this._sModalCSSClass=e;if(this.isOpen()){if(o!==t){T._clearSelection();if(t){this._setupUserSelection();this._showBlockLayer()}else{this._hideBlockLayer();this._restoreUserSelection()}if(this.touchEnabled&&this._bAutoClose){if(!t){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}else{jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}}}}return this};T.prototype.getModal=function(){return this._bModal};T.prototype.setNavigationMode=function(t){if(t!="NONE"&&t!="DOCK"&&t!="SCOPE"){this._sF6NavMode="NONE"}this._sF6NavMode=t};T.prototype.setAutoClose=function(t){_(typeof t==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==t){if(!this._bModal){if(t){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}else{jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}}}this._bAutoClose=t;return this};T.prototype.setExtraContent=function(t){_(Array.isArray(t),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[]}var e=function(t){return{onBeforeRendering:function(){var e=t.getDomRef();if(e&&this.isOpen()){e.removeEventListener("blur",this.fnEventHandler,true)}},onAfterRendering:function(){var e=t.getDomRef();if(e&&this.isOpen()){e.addEventListener("blur",this.fnEventHandler,true)}}}};var o,i,s,n;for(var r=0,l=t.length;r<l;r++){i=t[r];if(i instanceof a){o=i.getId()}else if(typeof i==="object"){o=i.id}else if(typeof i==="string"){o=i}if(this.getChildPopups().indexOf(o)===-1){this.addChildPopup(o);n={id:o};if(i instanceof a){s=e(i);i.addEventDelegate(s,this);n.delegate=s}this._aExtraContent.push(n)}}return this};T.prototype.setAutoCloseAreas=T.prototype.setExtraContent;T.prototype.setAnimations=function(t,e){_(t===null||typeof t==="function","fnOpen must be a function");_(e===null||typeof e==="function","fnClose must be a function");if(t&&typeof t=="function"){this._animations.open=t}if(e&&typeof e=="function"){this._animations.close=e}return this};T.prototype.setDurations=function(t,e){_(t===null||typeof t==="number"&&t%1==0,"iOpenDuration must be null or an integer");_(!e||typeof e==="number"&&e%1==0,"iOpenDuration must be undefined or an integer");if(t>0||t===0){this._durations.open=t}if(e>0||e===0){this._durations.close=e}return this};T.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";T.prototype._fnCloseOnScroll=function(t){this.close()};T.prototype.setFollowOf=function(t){T.DockTrigger.removeListener(T.checkDocking,this);var e=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof t==="function"){this._followOfHandler=t;e=true}else if(typeof t==="boolean"){e=t}else if(t===T.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;e=true}else{this._bFollowOf=false;if(t!==null){g.error("Trying to set an invalid type to 'followOf: "+t)}}if(e&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of)}if(this._bFollowOf&&this.getOpenState()===I.OPEN){T.DockTrigger.addListener(T.checkDocking,this)}};T.prototype.getAutoClose=function(){return this._bAutoClose};T.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof this._followOfHandler==="function"?this._followOfHandler:true}return false};T.prototype.isOpen=function(){return this.bOpen};T.prototype.getOpenState=function(){return this.eOpenState};T.prototype.destroy=function(){if(this._resizeListenerId){h.deregister(this._resizeListenerId);this._resizeListenerId=null}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null)}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents()}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null}if(this._aExtraContent){var t;this._aExtraContent.forEach(function(e){if(e.delegate){t=a.closestTo(document.getElementById(e.id));if(t){t.removeEventDelegate(e.delegate)}}})}i.prototype.destroy.apply(this,arguments)};T.prototype.exit=function(){delete this._mEvents};T.prototype._addFocusEventListeners=function(){if(!this.fnEventHandler){this.fnEventHandler=this.onFocusEvent.bind(this)}var t=this._$();var e=this.getChildPopups();var o={};var i=0,s=0;if(t.length){document.addEventListener("focus",this.fnEventHandler,true);t.get(0).addEventListener("blur",this.fnEventHandler,true);for(i=0,s=e.length;i<s;i++){o=e[i]?window.document.getElementById(e[i]):null;if(o){o.addEventListener("blur",this.fnEventHandler,true)}}}};T.prototype._removeFocusEventListeners=function(){var t=this._$(false,true);if(!t.length){return}var e=this.getChildPopups();var o={};var i=0,s=0;document.removeEventListener("focus",this.fnEventHandler,true);t.get(0).removeEventListener("blur",this.fnEventHandler,true);for(i=0,s=e.length;i<s;i++){o=e[i]?window.document.getElementById(e[i]):null;if(o){o.removeEventListener("blur",this.fnEventHandler,true)}this.closePopup(e[i])}this.fnEventHandler=null};T.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners()}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}};T.prototype._deactivateFocusHandle=function(){if(this.fnEventHandler){this._removeFocusEventListeners()}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}};T.prototype._registerEventBusEvents=function(){var t=this;C(t._mEvents,function(e,o){A.subscribe("sap.ui",e,o,t)});this._bEventBusEventsRegistered=true};T.prototype._unregisterEventBusEvents=function(){var t=this;C(t._mEvents,function(e,o){A.unsubscribe("sap.ui",e,o,t)});delete this._bEventBusEventsRegistered};T.prototype._addFocusableArea=function(t,e,o){if(this.getChildPopups().indexOf(o.id)===-1){this.addChildPopup(o.id)}};T.prototype._removeFocusableArea=function(t,e,o){this.removeChildPopup(o.id)};T.prototype._closePopup=function(t,e,o){this.close(typeof this._durations.close==="string"?0:this._durations.close)};T.prototype._setIdentity=function(t){if(typeof t==="object"){t.attr("data-sap-ui-popup",this._popupUID)}else{g.warning("Incorrect DomRef-type for 'setIdentity': "+t,this);return}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents()}};T.prototype._$=function(t,e){var o;if(this.oContent instanceof r){o=this.oContent.$();if(t||o.length===0&&!e){g.info("Rendering of popup content: "+this.oContent.getId());if(o.length>0){p.preserveContent(o[0],true,false)}(new p).render(this.oContent,d.getDomRef());o=this.oContent.$()}}else if(this.oContent instanceof a){o=this.oContent.$()}else{o=jQuery(this.oContent)}this._setIdentity(o);return o};function j(t){if(T._blockLayerStateProvider){T._blockLayerStateProvider.fireEvent("blockLayerStateChange",t)}}T.attachBlockLayerStateChange=function(t,e,o){if(!T._blockLayerStateProvider){T._blockLayerStateProvider=new S}T._blockLayerStateProvider.attachEvent("blockLayerStateChange",t,e,o)};T.detachBlockLayerStateChange=function(t,e){if(T._blockLayerStateProvider){T._blockLayerStateProvider.detachEvent("blockLayerStateChange",t,e)}};function z(t,e){if(e===window){B(t);document.documentElement.classList.add("sapUiBLyBack")}else{N(t,e);e.classList.add("sapUiBLyBack");F.observe(e)}}function G(t){if(t===window){document.documentElement.classList.remove("sapUiBLyBack")}else{t.classList.remove("sapUiBLyBack");F.unobserve(t)}}T.prototype._extendFocusInfo=function(t,e){var i=false,s="sap.ui.core.Popup.extendFocusInfo-",n;if(t instanceof o){n={info:e.info,element:t.getParameter("domRef")}}else{n=t}var r=this.getContent();var l=r instanceof a?r.getDomRef():r;if(l&&l.contains(n.element)){n.info.preventScroll=true;i=true}else{var u=this.getChildPopups();i=u.some(function(t){var e=s+t;A.publish("sap.ui",e,n);return n.extended})}return i};T.prototype._extendFocusInfoEventBusWrapper=function(t,e,o){o.contains=this._extendFocusInfo(o)};T.prototype._showBlockLayer=function(){var t=jQuery("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:""),o;if(t.length===0){t=jQuery('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');t.appendTo(d.getDomRef())}else{t.removeClass().addClass(e)}var i=T.blStack[T.blStack.length-1];if(i){o=D(i.popup._oLastPosition.within);G(o)}o=D(this._oLastPosition.within);z(t,o);T.blStack.push({zIndex:this._iZIndex-2,popup:this});t.css({"z-index":this._iZIndex-2,visibility:"visible"}).show();if(!this.isInPopup(this._oLastPosition.of)){this._bFocusExtenderAdded=true;u.addFocusInfoExtender(this._extendFocusInfo,this)}if(T.blStack.length===1){j({visible:true,zIndex:T.blStack[0].zIndex})}};T.prototype._hideBlockLayer=function(){var t=jQuery("#sap-ui-blocklayer-popup"),e=t[0],o=this,i,s;s=D(this._oLastPosition.within);G(s);if(t.length){if(this._bFocusExtenderAdded){this._bFocusExtenderAdded=false;u.removeFocusInfoExtender(this._extendFocusInfo,this)}const n=this._sModalCSSClass?.split(" ")??[];n.forEach(t=>{e.classList.remove(t)});if(T.blStack.length>1){T.blStack=T.blStack.filter(function(t){return t.popup!==o});i=T.blStack[T.blStack.length-1];e.style.zIndex=i.zIndex;const n=i.popup._sModalCSSClass?.split(" ")??[];n.forEach(t=>{e.classList.add(t)});e.style.visibility="visible";e.style.display="block";s=D(i.popup._oLastPosition.within);z(t,s)}else{i=T.blStack.pop();e.style.visibility="hidden";e.style.display="none";j({visible:false,zIndex:i.zIndex})}}};T.prototype._isFocusInsidePopup=function(){var t=this._$(false,true).get(0);if(t&&t.contains(document.activeElement)){return true}return false};T.DockTrigger=f;T.checkDocking=function(){if(this.getOpenState()===I.OPEN||this.getOpenState()===I.OPENING){var t=this._getOfDom(this._oLastPosition.of),e;if(t){if(t===window||t===window.document||document.documentElement.contains(t)||t.getRootNode()instanceof ShadowRoot){e=jQuery(t).rect()}else if(t.id){var o=window.document.getElementById(t.id);var i=jQuery(o).rect();if(i&&!$(e,i)){e=i;this._oLastPosition.of=o}}}if(!e){this.close();return}else if(e.left===0&&e.top===0&&e.height===0&&e.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);t=this._getOfDom(this._oLastPosition.of);e=jQuery(t).rect();if(!e){this.close();return}}if(this._oLastOfRect){if(!$(this._oLastOfRect,e)){if(this._followOfHandler&&this.getOpenState()===I.OPEN){var s=E({},this._oLastPosition),n=E({},this._oLastOfRect);this._followOfHandler({lastPosition:s,lastOfRect:n,currentOfRect:e})}else{this._applyPosition(this._oLastPosition)}}}}};T.prototype.ontouchstart=function(t){this.onmousedown(t,true);this._bMousedownCalled=true};T.prototype.onmousedown=function(t,e){if(this._bMousedownCalled&&!e){this._bMousedownCalled=false;return}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return}this._increaseMyZIndex("","mousedown",t)};T.prototype._increaseMyZIndex=function(t,e,o){var i=this.getParentPopup(this._oLastPosition.of);if(o&&o.type==="mousedown"||o&&o.isFromParentPopup||i.length===0){this._iZIndex=this.getNextZIndex();var s=this._$(false,true);s.css("z-index",this._iZIndex);if(o&&!o.type||o&&o.type!="mousedown"||e==="mousedown"){var n=this.getChildPopups();for(var r=0,a=n.length;r<a;r++){this.increaseZIndex(n[r],true)}}}else if(i.length>0){var l=jQuery(i.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(l,false)}};T.prototype.onAfterRendering=function(){var t=this.getContent();var e=t instanceof a?t.$():jQuery(t);e.toggleClass("sapUiShd",this._bShadow);T._clearSelection();this._setupUserSelection();e.css("position","absolute");this._setIdentity(e);var o=e[0];var i=o.style.left;var s=o.style.right;var n=o.style.top;var r=o.style.bottom;if(!(i&&i!="auto"||s&&s!="auto"||n&&n!="auto"||r&&r!="auto")){g.debug("reposition popup content "+e.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition)}e.show().css({visibility:"visible","z-index":this._iZIndex});if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners()}this._$(false,true).on("keydown",this._F6NavigationHandler)};T.prototype.onBeforeRendering=function(){if(this._resizeListenerId){h.deregister(this._resizeListenerId);this._resizeListenerId=null}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners()}this._$(false,true).off("keydown",this._F6NavigationHandler)};T.prototype.isInPopup=function(t){var e=this.getParentPopup(t);return e&&e.length>0};T.prototype.getParentPopup=function(t){var e=t?t:this;var o=jQuery(e instanceof a?e.getDomRef():e);return o.closest("[data-sap-ui-popup]")};T.prototype.getParentPopupId=function(t){var e=this.getParentPopup(t);return e.attr("data-sap-ui-popup")};T.prototype.addChildToPopup=function(t,e){var o="sap.ui.core.Popup.addFocusableContent-"+t;A.publish("sap.ui",o,{id:e})};T.prototype.removeChildFromPopup=function(t,e){var o="sap.ui.core.Popup.removeFocusableContent-"+t;A.publish("sap.ui",o,{id:e})};T.prototype.closePopup=function(t){var e="sap.ui.core.Popup.closePopup-"+t;A.publish("sap.ui",e)};T.prototype.increaseZIndex=function(t,e){var o="sap.ui.core.Popup.increaseZIndex-"+t;A.publish("sap.ui",o,{isFromParentPopup:e?e:false})};T.prototype.focusTabChain=function(t){var e=t.event.target,o=t.that.getMetadata().getName(),i;if(!t.$FocusablesContent||!t.$FocusablesFooter||!t.$FocusablesContent.length&&!t.$FocusablesFooter.length){return}if(e.id===t.firstFocusable){g.debug("First dummy focus element was focused","",o);if(t.$FocusablesFooter.length>0){g.debug("Last footer element will be focused","",o);i=t.$FocusablesFooter[t.$FocusablesFooter.length-1]}else{g.debug("Last content element will be focused","",o);i=t.$FocusablesContent[t.$FocusablesContent.length-1]}}else if(e.id===t.lastFocusable){g.debug("Last dummy focus element was focues","",o);if(t.$FocusablesContent.length>0){g.debug("First content element will be focused","",o);i=t.$FocusablesContent[0]}else{g.debug("First footer element will be focused","",o);i=t.$FocusablesFooter[0]}}if(i){setTimeout(function(){var t=a.getElementById(i.id);if(t instanceof r){g.debug("Focus will be handled by "+t.getMetadata().getName(),"",o)}else{g.debug("oFocusDomRef will be focused","",o)}if(t){t.focus()}else if(i){i.focus()}return t?t.getId():i.id},0)}};T.prototype._setupUserSelection=function(){var t=this._$(false,true);T._markAsUserSelectable(t,this._bModal||T.blStack.length>0);if(this._bModal){if(T.blStack.length>0){var e=T.blStack[T.blStack.length-1];var o=function(t){return t.popup.getId()};if(T.blStack.map(o).indexOf(this.getId())===-1){T._markAsNotUserSelectable(e.popup._$(false,true),true)}else if(e.popup.getId()!==this.getId()){T._markAsNotUserSelectable(t,true)}}else{T._markAsNotUserSelectable(jQuery("html"),true);T._markExternalContentAsUserSelectable(true)}}};T.prototype._restoreUserSelection=function(){var t=this._$(false,true);T._markAsNotUserSelectable(t,false);if(T.blStack.length>0){T._markAsUserSelectable(T.blStack[T.blStack.length-1].popup._$(false,true),true)}else{T._markAsUserSelectable(jQuery("html"),false);T._markExternalContentAsNotUserSelectable(false)}};T.prototype.isTopmost=function(){return this._iZIndex===T.getLastZIndex()};T._clearSelection=function(){var t=document.getSelection();if(!t.isCollapsed){t.removeAllRanges()}};T._markAsUserSelectable=function(t,e){t.removeClass("sapUiNotUserSelectable");if(e){t.addClass("sapUiUserSelectable")}};T._markAsNotUserSelectable=function(t,e){t.removeClass("sapUiUserSelectable");if(e){t.addClass("sapUiNotUserSelectable")}};var W=new Set,q="[data-sap-ui-integration-popup-content]";W.add(q);T.addExternalContent=function(t,e){if(!Array.isArray(t)){t=[t]}t.forEach(Set.prototype.add.bind(W));if(e){T.markExternalContentAsSelectable()}};T.removeExternalContent=function(t,e){if(!Array.isArray(t)){t=[t]}if(e){T.markExternalContentAsNotSelectable()}t.forEach(function(t){if(t!==q){W.delete(t)}})};T.markExternalContentAsSelectable=function(){T._clearSelection();if(T.blStack.length>0){T._markExternalContentAsUserSelectable(true)}};T.markExternalContentAsNotSelectable=function(){T._clearSelection();if(T.blStack.length>0){T._markExternalContentAsNotUserSelectable(false)}};T._getExternalContent=function(){var t=[];if(W.size>0){W.forEach(function(e){var o=jQuery(e);if(o.length>0){t.push(o)}})}return t};T._markExternalContentAsUserSelectable=function(t){var e=T._getExternalContent();e.forEach(function(e){T._markAsUserSelectable(e,t)})};T._markExternalContentAsNotUserSelectable=function(t){var e=T._getExternalContent();e.forEach(function(e){T._markAsNotUserSelectable(e,t)})};T.setWithinArea=function(t){x=t};T.getWithinArea=function(){return x};T.getWithinAreaDomRef=function(){return D(x)};return T});
//# sourceMappingURL=Popup.js.map