/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ControlBehavior","./FocusHandler","./InvisibleRenderer","./LabelEnablement","./Patcher","sap/base/assert","sap/base/future","sap/base/Log","sap/base/security/encodeCSS","sap/base/security/encodeXML","sap/base/util/extend","sap/base/util/uid","sap/ui/base/Object","sap/ui/performance/Measurement","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery","sap/ui/util/ActivityDetection"],function(e,t,n,r,i,a,s,o,l,u,f,c,d,p,h,jQuery,g){"use strict";var m;var y=["renderControl","cleanupControlWithoutRendering","accessibilityState","icon"];var b=["write","writeEscaped","writeAcceleratorKey","writeControlData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","translate","getConfiguration","getHTML"];var v=["openStart","voidStart","attr","class","style","openEnd","voidEnd","text","unsafeHtml","close"];var C=["render","flush","destroy"];var S=document.createElement("template");var E="data-sap-ui-stylekey";var R="data-sap-ui-render";function A(){var e=this,r,s,l,f,c="",m=false,I,P="",O={},j={},T=[],N=new i,_=0,x,H;function F(){a(!(x=H=""));r=e.aBuffer=[];s=e.aRenderedControls=[];l=e.aStyleStack=[{}];I=undefined;m=false;_=0;c=""}function L(e,t){r.push(" ",e,'="',t,'"')}function V(e){var t=l[l.length-1];var n;if(e){n=e.aCustomStyleClasses}else if(e===false){n=[]}else{n=t.aCustomStyleClasses}if(t.aClasses||n){var r=[].concat(t.aClasses||[],n||[]);if(r.length){L("class",r.join(" "))}}if(!e){t.aCustomStyleClasses=null}t.aClasses=null}function q(){var e=l[l.length-1];if(e.aStyle&&e.aStyle.length){L(E,T.push(e.aStyle.join(" "))-1)}e.aStyle=null}function U(e,t){a(e&&typeof e=="string"&&/^[a-z_][a-zA-Z0-9_\-]*$/.test(e),"The "+t+" name provided '"+e+"' is not valid; it must contain alphanumeric characters, hyphens or underscores")}function W(e){a(c,"There is no open tag; '"+e+"' must not be called without an open tag")}function G(e){var t=e===undefined?!c:e;a(t,"There is an open tag; '"+c+"' tag has not yet ended with '"+(m?"voidEnd":"openEnd")+"'")}function X(e){U(e,"attr");a((e!="class"||H!="class"&&(H="attr"))&&(e!="style"||x!="style"&&(x="attr")),"Attributes 'class' and 'style' must not be written when the methods with the same name"+" have been called for the same element already")}function $(e){a(H!="attr"&&(H="class"),"Method class() must not be called after the 'class' attribute has been written for the same element");a(typeof e=="string"&&!/\s/.test(e)&&arguments.length===1,"Method 'class' must be called with exactly one class name")}function z(e){a(x!="attr"&&(x="style"),"Method style() must not be called after the 'style' attribute has been written for the same element");a(e&&typeof e=="string"&&!/\s/.test(e),"Method 'style' must be called with a non-empty string name")}this.write=function(e){a(typeof e==="string"||typeof e==="number","sText must be a string or number");r.push.apply(r,arguments);return this};this.writeEscaped=function(e,t){if(e!=null){e=u(String(e));if(t){e=e.replace(/&#xa;/g,"<br>")}r.push(e)}return this};this.writeAttribute=function(e,t){a(typeof e==="string","sName must be a string");a(typeof t==="string"||typeof t==="number"||typeof t==="boolean","value must be a string, number or boolean");r.push(" ",e,'="',t,'"');return this};this.writeAttributeEscaped=function(e,t){a(typeof e==="string","sName must be a string");r.push(" ",e,'="',u(String(t)),'"');return this};this.addStyle=function(e,t){a(typeof e==="string","sName must be a string");if(t!=null&&t!=""){a(typeof t==="string"||typeof t==="number","value must be a string or number");var n=l[l.length-1];if(!n.aStyle){n.aStyle=[]}n.aStyle.push(e+": "+t+";")}return this};this.writeStyles=function(){q();return this};this.addClass=function(e){if(e){a(typeof e==="string","sName must be a string");var t=l[l.length-1];if(!t.aClasses){t.aClasses=[]}t.aClasses.push(e)}return this};this.writeClasses=function(e){a(!e||typeof e==="boolean"||d.isObjectA(e,"sap.ui.core.Element"),"oElement must be empty, a boolean, or an sap.ui.core.Element");V(e);return this};this.openStart=function(e,t){U(e,"tag");G();a(!(x=H=""));c=e;_++;r.push("<"+e);if(t){if(typeof t=="string"){this.attr("id",t)}else{a(t&&d.isObjectA(t,"sap.ui.core.Element"),"vControlOrId must be an sap.ui.core.Element");this.attr("id",t.getId());M(this,t)}}return this};this.openEnd=function(e){W("openEnd");G(!m);a(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");c="";V(e===true?false:undefined);q();r.push(">");return this};this.close=function(e){U(e,"tag");G();_--;r.push("</"+e+">");return this};this.voidStart=function(e,t){this.openStart(e,t);m=true;return this};this.voidEnd=function(e){W("voidEnd");G(m||!c);m=false;_--;c="";V(e?false:undefined);q();r.push(">");return this};this.unsafeHtml=function(e){G();r.push(e);return this};this.text=function(e){G();if(e!=null){e=u(String(e));r.push(e)}return this};this.attr=function(e,t){X(e);if(e=="style"){l[l.length-1].aStyle=[t]}else{r.push(" ",e,'="',u(String(t)),'"')}return this};this.class=function(e){if(e){$.apply(this,arguments);var t=l[l.length-1];if(!t.aClasses){t.aClasses=[]}t.aClasses.push(u(e))}return this};this.style=function(e,t){z(e);if(t!=null&&t!=""){a(typeof t==="string"||typeof t==="number","value must be a string or number");var n=l[l.length-1];if(!n.aStyle){n.aStyle=[]}n.aStyle.push(e+": "+t+";")}return this};j.openStart=function(e,t){U(e,"tag");G();a(!(x=H=""));c=e;_++;if(!t){N.openStart(e)}else if(typeof t=="string"){N.openStart(e,t)}else{N.openStart(e,t.getId());M(this,t)}return this};j.voidStart=function(e,t){this.openStart(e,t);m=true;return this};j.attr=function(e,t){X(e);W("attr");N.attr(e,t);return this};j.class=function(e){if(e){$.apply(this,arguments);W("class");N.class(e)}return this};j.style=function(e,t){z(e);W("style");N.style(e,t);return this};j.openEnd=function(e){if(e!==true){var t=l[l.length-1];var n=t.aCustomStyleClasses;if(n){n.forEach(N.class,N);t.aCustomStyleClasses=null}}W("openEnd");G(!m);a(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");c="";N.openEnd();return this};j.voidEnd=function(e){if(!e){var t=l[l.length-1];var n=t.aCustomStyleClasses;if(n){n.forEach(N.class,N);t.aCustomStyleClasses=null}}W("voidEnd");G(m||!c);m=false;_--;c="";N.voidEnd();return this};j.text=function(e){G();if(e!=null){N.text(e)}return this};j.unsafeHtml=function(e){G();N.unsafeHtml(e);return this};j.close=function(e){U(e,"tag");G();_--;N.close(e);return this};function J(e){f=true;try{var t=new jQuery.Event("BeforeRendering");t.srcControl=e;e._bOnBeforeRenderingPhase=true;e._handleEvent(t)}finally{e._bOnBeforeRenderingPhase=false;f=false}}this.cleanupControlWithoutRendering=function(e){a(!e||d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control or empty");if(!e){return}var t=e.getDomRef();if(t){J(e);A.preserveContent(t,false,false);if(!t.hasAttribute(D)){e._bNeedsRendering=false;e.bOutput=false}}};function K(e,t){if(t){J(e)}if(e.bOutput==true){var i=e.aBindParameters;if(i&&i.length>0){var a=e.$();i.forEach(function(e){a.off(e.sEventType,e.fnProxy)})}}var u=B(e);if(u==n){n.render(I?j:O,e);e.bOutput="invisible"}else if(u&&typeof u.render==="function"){var f={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){f.aCustomStyleClasses=e.aCustomStyleClasses}l.push(f);e._bRenderingPhase=true;if(I){var c=N.getCurrentNode();u.render(j,e);if(N.getCurrentNode()==c){N.unsafeHtml("",e.getId());e.bOutput=false}else{e.bOutput=true}}else{var d=r.length;u.render(O,e);e.bOutput=r.length!=d}e._bRenderingPhase=false;l.pop()}else{o.error("The renderer for class "+e.getMetadata().getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!")}s.push(e);e._bNeedsRendering=false;var p=e.getUIArea();if(p){p._onControlRendered(e)}}this.renderControl=function(e){a(!e||d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control or empty");if(!e){return this}var i,s;var o=true;if(r.length){I=false}else if(I===undefined){J(e);o=false;s=B(e);if(A.getApiVersion(s)!=1){i=e.getDomRef()||n.getDomRef(e);if(A.isPreservedContent(i)){I=false}else{i&&t.storePatchingControlFocusInfo(i);N.setRootNode(i);I=true}}else{I=false}}else if(!P&&I){s=B(e);if(A.getApiVersion(s)==1){P=e.getId();I=false}}if(I){if(e._bNeedsRendering||!e.getParent()||N.isCreating()||!A.canSkipRendering(e)||!(i=i||e.getDomRef()||n.getDomRef(e))||i.hasAttribute(R)||i.querySelector("["+R+"]")){K(e,o)}else{N.alignWithDom(i)}}else{K(e,o);if(P&&P===e.getId()){N.unsafeHtml(r.join(""),P,ee);P="";I=true;r=[]}}return this};this.getHTML=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");var t=r;var n=r=this.aBuffer=[];this.renderControl(e);r=this.aBuffer=t;return n.join("")};function Z(e){a(!_,"RenderManager: Mismatched opening and closing tags. Verify renderers!");var n,r=s.length;for(n=0;n<r;n++){s[n]._sapui_bInAfterRenderingPhase=true}f=true;try{for(n=0;n<r;n++){var i=s[n];if(i.bOutput&&i.bOutput!=="invisible"){var l=new jQuery.Event("AfterRendering");l.srcControl=i;p.start(i.getId()+"---AfterRendering","AfterRendering of "+i.getMetadata().getName(),["rendering","after"]);i._handleEvent(l);p.end(i.getId()+"---AfterRendering")}}}finally{for(n=0;n<r;n++){delete s[n]._sapui_bInAfterRenderingPhase}f=false}try{t.restoreFocus(e)}catch(e){o.warning("Problems while restoring the focus after rendering: "+e,null)}for(n=0;n<r;n++){var i=s[n],u=i.aBindParameters,c;if(u&&u.length>0&&(c=i.getDomRef())){var d=jQuery(c);for(var h=0;h<u.length;h++){var g=u[h];d.on(g.sEventType,g.fnProxy)}}}}function Q(e,n,i){var a;if(!I){a=t.getControlFocusInfo();var s=r.join("");if(s&&T.length){if(i instanceof SVGElement&&i.localName!="foreignObject"){S.innerHTML="<svg>"+s+"</svg>";S.replaceWith.apply(S.content.firstChild,S.content.firstChild.childNodes)}else{S.innerHTML=s}ee(S.content.childNodes);e(S.content)}else{e(s)}}else{var o=N.getRootNode();if(o.nodeType==11){a=t.getControlFocusInfo();e(o.lastChild?o:"")}else{a=t.getPatchingControlFocusInfo()}N.reset()}Z(a);F();g.refresh();if(n){n()}}function Y(e,t){var n=e.getAttribute(E);if(n!=t){return 0}e.style=T[t];e.removeAttribute(E);return 1}function ee(e){if(!T.length){return}var t=0;e.forEach(function(e){if(e.nodeType==1){t+=Y(e,t);e.querySelectorAll("["+E+"]").forEach(function(e){t+=Y(e,t)})}});T=[]}this.flush=function(e,t,n){a(typeof e==="object"&&e.ownerDocument==document,"oTargetDomNode must be a DOM element");var r=h.notifyAsyncStep();if(!t&&typeof n!=="number"&&!n){A.preserveContent(e)}Q(function(t){for(var r=0;r<s.length;r++){var i=s[r].getDomRef();if(i&&!A.isPreservedContent(i)){if(A.isInlineTemplate(i)){jQuery(i).empty()}else{jQuery(i).remove()}}}if(typeof n==="number"){if(n<=0){k(e,"prepend",t)}else{var a=e.children[n-1];if(a){k(a,"after",t)}else{k(e,"append",t)}}}else if(!n){jQuery(e).html(t)}else{k(e,"append",t)}},r,e)};this.render=function(e,t){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be a control");a(typeof t==="object"&&t.ownerDocument==document,"oTargetDomNode must be a DOM element");if(f){o.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return}var r=h.notifyAsyncStep();F();this.renderControl(e);Q(function(r){if(e&&t){var i=e.getDomRef();if(!i||A.isPreservedContent(i)){i=n.getDomRef(e)||document.getElementById(w.Dummy+e.getId())}var a=i&&i.parentNode!=t;if(a){if(!A.isPreservedContent(i)){if(A.isInlineTemplate(i)){jQuery(i).empty()}else{jQuery(i).remove()}}if(r){k(t,"append",r)}}else{if(r){if(i){if(A.isInlineTemplate(i)){jQuery(i).html(r)}else{k(i,"after",r);jQuery(i).remove()}}else{k(t,"append",r)}}else{if(A.isInlineTemplate(i)){jQuery(i).empty()}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,i)){jQuery(i).remove()}}}}}},r,t)};this.destroy=function(){F()};var te={};y.forEach(function(e){O[e]=j[e]=te[e]=this[e]},this);v.forEach(function(e){O[e]=te[e]=this[e]},this);b.forEach(function(e){O[e]=te[e]=this[e]},this);C.forEach(function(e){te[e]=this[e]},this);this.getRendererInterface=function(){return O};this.getInterface=function(){return te};F()}A.prototype.getConfiguration=function(){return sap.ui.require("sap/ui/core/Configuration")};A.prototype.translate=function(e){};A.prototype.writeAcceleratorKey=function(){return this};A.prototype.writeControlData=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this};A.prototype.writeElementData=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Element"),"oElement must be an sap.ui.core.Element");this.attr("id",e.getId());M(this,e);return this};A.prototype.accessibilityState=function(t,n){if(!e.isAccessibilityEnabled()){return this}if(arguments.length==1&&!d.isObjectA(t,"sap.ui.core.Element")){n=t;t=null}var i={};if(t!=null){var a=t.getMetadata();var s=function(e,n,r){var s=a.getProperty(e);if(s&&t[s._sGetter]()===r){i[n]="true"}};var o=function(e,n){var s=a.getAssociation(e);if(s&&s.multiple){var o=t[s._sGetter]();if(e=="ariaLabelledBy"){var l=r.getReferencingLabels(t);var u=l.length;if(u){var f=[];for(var c=0;c<u;c++){if(o.indexOf(l[c])<0){f.push(l[c])}}o=f.concat(o)}}if(o.length>0){i[n]=o.join(" ")}}};s("editable","readonly",false);s("enabled","disabled",false);s("visible","hidden",false);if(r.isRequired(t)){i["required"]="true"}s("selected","selected",true);s("checked","checked",true);o("ariaDescribedBy","describedby");o("ariaLabelledBy","labelledby")}if(n){var l=function(e){var t=typeof e;return e===null||t==="number"||t==="string"||t==="boolean"};var u={};var f,c,p;for(f in n){c=n[f];if(l(c)){u[f]=c}else if(typeof c==="object"&&l(c.value)){p="";if(c.append&&(f==="describedby"||f==="labelledby")){p=i[f]?i[f]+" ":""}u[f]=p+c.value}}Object.assign(i,u)}if(d.isObjectA(t,"sap.ui.core.Element")){var h=t.getParent();if(h&&h.enhanceAccessibilityState){var g=Object.assign({},i);h.enhanceAccessibilityState(t,i);if(i.canSkipRendering==false||i.canSkipRendering==undefined&&d.isObjectA(t,"sap.ui.core.Control")&&A.canSkipRendering(t)&&JSON.stringify(g)!=JSON.stringify(i)){this.attr(R,"")}delete i.canSkipRendering}}for(var m in i){if(i[m]!=null&&i[m]!==""){this.attr(m==="role"?m:"aria-"+m,i[m])}}return this};A.prototype.writeAccessibilityState=A.prototype.accessibilityState;A.prototype.icon=function(e,t,n){var r=sap.ui.require("sap/ui/core/IconPool");if(!r){s.warningThrows("sap/ui/core/IconPool must be loaded before sap.ui.core.RenderManager#icon can be called.",{suffix:"Falling back to synchronous loading of IconPool"},"SyncXHR",null,function(){return{type:"SyncXHR",name:"rendermanager-icon"}});r=sap.ui.requireSync("sap/ui/core/IconPool")}var i=r.isIconURI(e),a=false,u,d,p,h,g;if(typeof t==="string"){t=[t]}if(i){d=r.getIconInfo(e);if(!d){o.error("An unregistered icon: "+e+" is used in sap.ui.core.RenderManager's writeIcon method.");return this}if(!t){t=[]}t.push("sapUiIcon");if(!d.suppressMirroring){t.push("sapUiIconMirrorInRTL")}}if(i){this.openStart("span")}else{this.voidStart("img")}if(Array.isArray(t)){t.forEach(function(e){this.class(e)},this)}if(i){p={"data-sap-ui-icon-content":d.content,role:"presentation",title:d.text||null};this.style("font-family","'"+l(d.fontFamily)+"'")}else{p={role:"presentation",alt:"",src:e}}n=f(p,n);if(!n.id){n.id=c()}if(n.role==="presentation"){n["aria-hidden"]=true}if(i){h=n.alt||n.title||d.text||d.name;g=n.id+"-label";if(n["aria-labelledby"]){a=true;n["aria-labelledby"]+=" "+g}else if(!n.hasOwnProperty("aria-label")){n["aria-label"]=h}}if(typeof n==="object"){for(u in n){if(n.hasOwnProperty(u)&&n[u]!==null){this.attr(u,n[u])}}}if(i){this.openEnd();if(a){this.openStart("span");this.style("display","none");this.attr("id",g);this.openEnd();this.text(h);this.close("span")}this.close("span")}else{this.voidEnd()}return this};A.prototype.writeIcon=A.prototype.icon;A.prototype.getRenderer=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");return A.getRenderer(e)};var w=A.RenderPrefixes={Invisible:n.PlaceholderPrefix,Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};A.getRenderer=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer()};A.forceRepaint=function(e){var t=e?window.document.getElementById(e):null;var n=typeof e=="string"?t:e;if(n){o.debug("forcing a repaint for "+(n.id||String(n)));var r=n.style.display;var i=document.activeElement;n.style.display="none";n.offsetHeight;n.style.display=r;if(document.activeElement!==i&&i){i.focus()}}};A.createInvisiblePlaceholderId=function(e){return n.createInvisiblePlaceholderId(e)};var I="sap-ui-preserve",P="sap-ui-static",D="data-sap-ui-preserve",O="data-sap-ui-area";function j(){var e=jQuery(document.getElementById(I));if(e.length===0){e=jQuery("<div></div>",{"aria-hidden":"true",id:I}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body)}return e}function T(e){var t=jQuery("<div></div>",{id:w.Dummy+e.id}).addClass("sapUiHidden");if(e.hasAttribute(R)){t.attr(R,"")}t.insertBefore(e)}var N=[];A.attachPreserveContent=function(e,t){A.detachPreserveContent(e);N.push({fn:e,context:t})};A.detachPreserveContent=function(e){N=N.filter(function(t){return t.fn!==e})};A.preserveContent=function(e,n,r,i){a(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");m=m?m:sap.ui.require("sap/ui/core/Element");N.forEach(function(t){t.fn.call(t.context||A,{domNode:e})});var s=j();function o(t){while(t&&t!=e&&t.parentNode){t=t.parentNode;if(t.hasAttribute(D)){return true}if(t.hasAttribute("data-sap-ui")){break}}}function l(e,t,n){if(e===t){return true}for(var r=t.getParent();r;r=r.isA("sap.ui.core.UIComponent")?r.oContainer:r.getParent()){if(r.isA("sap.ui.core.Control")){if(!r.getVisible()){return false}var i=r.getDomRef();if(i&&!i.contains(n)){return false}}if(r===e){return true}}}function u(n){if(n.id===I||n.id===P){return}var a=n.getAttribute(D);if(a){let r;if(i){r=m.getElementById(a);if(r&&l(i,r,n)){return}}if(n===e||o(n)){T(n)}else if(r&&n.hasAttribute(R)){T(n)}t.trackFocusForPreservedElement(n);s.append(n)}else if(r&&n.id){t.trackFocusForPreservedElement(n);A.markPreservableContent(jQuery(n),n.id);s.append(n);return}if(!n.hasAttribute(O)){var f=n.firstChild;while(f){n=f;f=f.nextSibling;if(n.nodeType===1){u(n)}}}}p.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(n){u(e)}else{jQuery(e).children().each(function(e,t){u(t)})}p.end(e.id+"---preserveContent")};A.findPreservedContent=function(e){a(typeof e==="string","sId must be a string");var t=j(),n=t.children("["+D+"='"+e.replace(/(:|\.)/g,"\\$1")+"']");return n};A.markPreservableContent=function(e,t){e.attr(D,t)};A.isPreservedContent=function(e){return e&&e.getAttribute(D)&&e.parentNode&&e.parentNode.id==I};A.getPreserveAreaRef=function(){return j()[0]};var _="data-sap-ui-template";A.markInlineTemplate=function(e){e.attr(_,"")};A.isInlineTemplate=function(e){return e&&e.hasAttribute(_)};A.getApiVersion=function(e){return e&&e.hasOwnProperty("apiVersion")?e.apiVersion:1};A.canSkipRendering=function(e,t){var n=this.getRenderer(e);var r=this.getApiVersion(n)==4;if(!r&&t!=2){return false}var i=r&&!e.hasRenderingDelegate();if(t){var a=e.getDomRef();if(a){a.toggleAttribute(R,!i)}}return i};function M(e,t){var n=t.getId();e.attr("data-sap-ui",n);if(d.isObjectA(t,"sap.ui.core.Control")&&!A.canSkipRendering(t)){e.attr(R,"")}if(t.__slot){e.attr("slot",t.__slot)}t.getCustomData().forEach(function(n){var r=n._checkWriteToDom(t);if(r){e.attr(r.key.toLowerCase(),r.value)}});var r=t.getDragDropConfig().some(function(e){return e.isDraggable(t)});if(!r){var i=t.getParent();if(i&&i.getDragDropConfig){r=i.getDragDropConfig().some(function(e){return e.isDraggable(t)})}}if(r){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}return this}var x={before:"beforebegin",prepend:"afterbegin",append:"beforeend",after:"afterend"};function k(e,t,n){if(typeof n=="string"){e.insertAdjacentHTML(x[t],n)}else{e[t](n)}}function B(e){var t=e.getMetadata();var r=!e.getVisible()&&t.getProperty("visible")._oParent.getName()=="sap.ui.core.Control";return r?n:t.getRenderer()}return A},true);
//# sourceMappingURL=RenderManager.js.map