/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/base/Object","sap/ui/core/IntervalTrigger","sap/ui/thirdparty/jquery","sap/ui/util/ActivityDetection"],function(e,t,i,jQuery,s){"use strict";var r=e.getLogger("sap.ui.core.ResizeHandler",e.Level.ERROR);var n;var o=t.extend("sap.ui.core.ResizeHandler",{constructor:function(){t.apply(this);this.aResizeListeners=[];this.aSuspendedDomRefs=[];this.bRegistered=false;this.mCallbacks=new Map;this.iIdCounter=0;window.addEventListener("unload",()=>{});s.attachActivate(d,this);if(n){r.error("ResizeHandler is designed as a singleton and should not be created manually! "+"Please require 'sap/ui/core/ResizeHandler' instead and use the module export directly without using 'new'.")}}});function a(){if(this.bRegistered){this.bRegistered=false;i.removeListener(this.checkSizes,this)}}function d(){if(!this.bRegistered&&this.aResizeListeners.length>0){this.bRegistered=true;i.addListener(this.checkSizes,this)}}o.prototype.attachListener=function(e,i){var s=t.isObjectA(e,"sap.ui.core.Control"),n=e instanceof jQuery,o=s?e.getDomRef():e,a=o?o.offsetWidth:0,u=o?o.offsetHeight:0,f="rs-"+Date.now()+"-"+this.iIdCounter++,l;if(s){l="Control "+e.getId()}else if(e.id){l=e.id}else{l=String(e)}this.aResizeListeners.push({sId:f,oDomRef:s?null:e,oControl:s?e:null,bIsJQuery:n,fHandler:i,iWidth:a,iHeight:u,dbg:l});r.debug("registered "+l);d.call(this);return f};o.prototype.detachListener=function(e){var t=this.aResizeListeners;for(var i=0;i<t.length;i++){if(t[i].sId===e){t.splice(i,1);r.debug("deregistered "+e);break}}if(t.length===0){a.call(this)}};o.prototype.checkSizes=function(){var e=r.isLoggable();if(e){r.debug("checkSizes:")}this.aResizeListeners.forEach(function(t){if(t){var i=!!t.oControl,s=i?t.oControl.getDomRef():t.oDomRef;s=t.bIsJQuery?s[0]:s;if(s&&document.documentElement.contains(s)&&!this._isSuspended(s)){var n=t.iWidth,o=t.iHeight,a=s.offsetWidth,d=s.offsetHeight;if(n!=a||o!=d){t.iWidth=a;t.iHeight=d;var u=jQuery.Event("resize");u.target=s;u.currentTarget=s;u.size={width:a,height:d};u.oldSize={width:n,height:o};u.control=i?t.oControl:null;if(e){r.debug("resize detected for '"+t.dbg+"': "+u.oldSize.width+"x"+u.oldSize.height+" -> "+u.size.width+"x"+u.size.height)}t.fHandler(u)}}}},this);if(o._keepActive!=true&&o._keepActive!=false){o._keepActive=false}if(!s.isActive()&&!o._keepActive){a.call(this)}};o.register=function(e,t){return n.attachListener(e,t)};o.deregister=function(e){n.detachListener(e)};o.deregisterAllForControl=function(e){n.aResizeListeners.filter(function(t){return t&&t.oControl&&t.oControl.getId()===e}).forEach(function(e){o.deregister(e.sId)})};o.suspend=function(e){if(!document.documentElement.contains(e)){return false}if(n.aSuspendedDomRefs.indexOf(e)===-1){n.aSuspendedDomRefs.push(e)}return true};o.resume=function(e){var t=n.aSuspendedDomRefs.indexOf(e);if(t===-1){return false}n.aSuspendedDomRefs.splice(t,1);n.checkSizes();var i=n.mCallbacks.get(e);if(i){for(var s=0;s<i.length;s++){i[s]()}n.mCallbacks.delete(e)}return true};o.prototype._isSuspended=function(e){var t=this.aSuspendedDomRefs,i;for(var s=0;s<t.length;s++){i=t[s];if(i.contains(e)){return i}}return false};o.isSuspended=function(e,t){var i=n._isSuspended(e);if(t&&i){var s=n.mCallbacks.get(i);if(!s){s=[];n.mCallbacks.set(i,s)}if(s.indexOf(t)===-1){s.push(t)}}return!!i};n=new o;return o});
//# sourceMappingURL=ResizeHandler.js.map