/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","./Element","./RenderManager","./UIAreaRegistry","./FocusHandler","sap/ui/performance/trace/Interaction","sap/ui/util/ActivityDetection","sap/ui/events/KeyCodes","sap/base/Log","sap/base/assert","sap/base/config","sap/ui/performance/Measurement","sap/base/util/uid","sap/base/util/isEmptyObject","sap/ui/core/Rendering","sap/ui/core/util/_LocalizationHelper","sap/ui/events/jquery/EventExtension","sap/ui/events/ControlEvents","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery"],function(e,t,r,o,n,i,s,a,d,u,l,p,f,g,c,h,v,m,y,jQuery){"use strict";var C=c.getLogger();var I=new r;var b;v.apply();jQuery(document).on("keydown",function(e){y.handleF6GroupNavigation(e,null)});var R=function(e){return e},E=function(){},A=function(){};if(C.isLoggable()){R=function(e){var t;try{throw new Error}catch(e){t=e.stack||e.stacktrace||(e.sourceURL?e.sourceURL+":"+e.line:null);t=t?t.split(/\n\s*/g).slice(2):undefined}return{obj:e,location:t}};E=function(e,r){var o={},n,i;for(n in r){i=t.getElementById(n);o[n]={type:i?i.getMetadata().getName():r[n].obj===e?"UIArea":"(no such control)",location:r[n].location,reason:r[n].reason}}C.debug("  UIArea '"+e.getId()+"', pending updates: "+JSON.stringify(o,null,"\t"))};A=function(e,t){var r;for(r in t){if(e[r]!=null){if(e[r].obj!==t[r].obj){t[r].reason="replaced during rendering"}else{t[r].reason="invalidated again during rendering"}}else{t[r].reason="invalidated during rendering"}}}}var N=e.extend("sap.ui.core.UIArea",{constructor:function(t){if(arguments.length===0){return}e.apply(this);this.bLocked=false;this.bInitial=true;this.aContentToRemove=[];this.bNeedsRerendering=false;if(t!=null){this._setRootNode(t);this.bNeedsRerendering=this.bNeedsRerendering&&!document.getElementById(t.id+"-Init")}this.mInvalidatedControls={};this.mSuppressedControls={};this.iSuppressedControlsLength=0;if(!this.bNeedsRerendering){this.bRenderSelf=false}else{c.invalidateUIArea(this)}},metadata:{publicMethods:["setRootNode","getRootNode","setRootControl","getRootControl","lock","unlock","isLocked"],aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},dependents:{type:"sap.ui.core.Control",multiple:true}}},insertDependent:function(e,t){return this.insertAggregation("dependents",e,t,true)},addDependent:function(e){return this.addAggregation("dependents",e,true)},removeDependent:function(e){return this.removeAggregation("dependents",e,true)},removeAllDependents:function(){return this.removeAllAggregation("dependents",true)},destroyDependents:function(){return this.destroyAggregation("dependents",true)}});N.prototype.getId=function(){return this.oRootNode?this.oRootNode.id:null};N.prototype.getUIArea=function(){return this};N.prototype.setRootNode=function(e){this._setRootNode(e)};N.prototype._setRootNode=function(e){if(this.oRootNode===e){return}u(!e||e.nodeType===1&&!jQuery(e).attr("data-sap-ui-area"),"UIArea root node must be a DOMElement");if(this.oRootNode){this._ondetach()}this.deregister();this.oRootNode=e;this.register();if(this.getContent().length>0){this.invalidate()}if(this.oRootNode){this._onattach()}};N.prototype.getRootNode=function(){return this.oRootNode};N.prototype.setRootControl=function(e){this.removeAllContent();this.addContent(e)};N.prototype.getRootControl=function(e){var t=this.getContent();if(t.length>0){if(e>=0&&e<t.length){return t[e]}return t[0]}return null};N.prototype._addRemovedContent=function(e){if(this.oRootNode&&e){this.aContentToRemove.push(e)}};N.prototype.addContent=function(e,t){this.addAggregation("content",e,t);if(t!==true){this.invalidate()}return this};N.prototype.removeContent=function(e,t){var r=this.removeAggregation("content",e,t);if(!t){var o;if(r&&r.getDomRef){o=r.getDomRef()}this._addRemovedContent(o)}return r};N.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content");for(var t=0;t<e.length;t++){var r;var o=e[t];if(o&&o.getDomRef){r=o.getDomRef()}this._addRemovedContent(r)}return e};N.prototype.destroyContent=function(){var e=this.getContent();for(var t=0;t<e.length;t++){var r;var o=e[t];if(o&&o.getDomRef){r=o.getDomRef()}this._addRemovedContent(r)}this.destroyAggregation("content");return this};N.prototype.lock=function(){this.bLocked=true};N.prototype.unlock=function(){if(this.bLocked&&this.bNeedsRerendering){c.invalidateUIArea(this)}this.bLocked=false};N.prototype.isLocked=function(){return this.bLocked};N.prototype.suppressInvalidationFor=function(e){if(!e||!e.isA||!e.isA("sap.ui.core.Control")){throw new TypeError("Invalid parameter: oControl must be Control instance.")}var t=e.getId();if(!this.mSuppressedControls[t]){this.mSuppressedControls[t]=new Set;this.iSuppressedControlsLength++;return true}return false};N.prototype.resumeInvalidationFor=function(e){if(!e||!e.isA||!e.isA("sap.ui.core.Control")){throw new TypeError("Invalid parameter: oControl must be Control instance.")}var r=e.getId();var o=this.mSuppressedControls[r];if(!o){throw new Error("The invalidation has not yet been suppressed for "+e)}this.iSuppressedControlsLength--;delete this.mSuppressedControls[r];o.forEach(function(e){var r=t.getElementById(e);if(r){this.addInvalidatedControl(r)}},this)};N.prototype.getBindingContext=function(){return null};N.prototype.getEventingParent=function(){return b?b._getEventProvider():undefined};N.prototype.isActive=function(){return!!this.getId()&&document.getElementById(this.getId())!=null};N.prototype.invalidate=function(){this.addInvalidatedControl(this)};N.prototype.addInvalidatedControl=function(e){if(this.bRenderSelf){return}if(!this.bNeedsRerendering){c.invalidateUIArea(this)}var t=e.getId();if(e===this){this.bRenderSelf=true;this.bNeedsRerendering=true;this.mInvalidatedControls={};this.mInvalidatedControls[t]=R(this);return}if(this.mInvalidatedControls[t]){return}if(this.iSuppressedControlsLength){for(var r=e;r;r=r.getParent()){var o=this.mSuppressedControls[r.getId()];if(o){o.add(t);return}}}this.mInvalidatedControls[t]=R(e);this.bNeedsRerendering=true};N.prototype.rerender=function(e){var o=this;function i(){o.bRenderSelf=false;o.aContentToRemove=[];o.mInvalidatedControls={};o.bNeedsRerendering=false}if(e){this.bNeedsRerendering=true}if(this.bLocked||!this.bNeedsRerendering){return false}var s=this.bRenderSelf,a=this.aContentToRemove,u=this.mInvalidatedControls,l=false;i();p.pause("renderPendingUIUpdates");p.start(this.getId()+"---rerender","Rerendering of "+this.getMetadata().getName());E(this,u);if(s){if(this.oRootNode){C.debug("Full Rendering of UIArea '"+this.getId()+"'");r.preserveContent(this.oRootNode,false,this.bInitial);this.bInitial=false;var f=function(e,t){var n=e.length;var i;for(var s=0;s<n;s++){i=t?e[s].getDomRef():e[s];if(i&&!r.isPreservedContent(i)&&o.oRootNode===i.parentNode){jQuery(i).remove()}}return n};var g=document.activeElement;var c=n.getControlFocusInfo();f(a);var h=this.getContent();var v=f(h,true);var m=document.activeElement;for(var y=0;y<v;y++){if(h[y]&&h[y].getParent()===this){I.render(h[y],this.oRootNode,true)}}l=true;if(g&&g!=m&&m===document.activeElement){try{n.restoreFocus(c)}catch(e){d.warning("Problems while restoring the focus after full UIArea rendering: "+e,null,this)}}}else{C.debug("Full Rendering of UIArea '"+this.getId()+"' postponed, no root node")}}else{var b=function(e){for(;;){if(e.getMetadata&&e.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){break}e=e.getParent();if(!e||e===o){return false}if(u.hasOwnProperty(e.getId())){return true}}};var R=[];for(var _ in u){var k=t.getElementById(_);if(k){if(!b(k)){k._bNeedsRendering=true;N.rerenderControl(k);l=true}else{R.push(k)}}}
/**
			 * Let us suppose that A is the parent of B, and B is the parent of C. The controls A and C are invalidated, but B isn't.
			 * Controls A and C will be added to the UIArea as invalidated controls. At the next tick, UIArea will be rendered again.
			 * Thanks to the isRenderedTogetherWithAncestor method above, C.rerender will never be executed but only A.rerender.
			 *
			 * In apiVersion 1 or 2:
			 * During the rendering of A, RM.renderControl(B) renders the control B, and during the rendering of B, RM.renderControl(C)
			 * renders the control C. At the end of the UIArea re-rendering, there shall be no control remaining in an invalidated state.
			 *
			 * In apiVersion 4:
			 * During the rendering of A when RM.renderControl(B) is called the RenderManager first checks whether control B is
			 * invalidated. Since it was not invalidated the RenderManager skips the rendering of control B. Consequently, there will be
			 * no RM.renderControl(C) call to render the control C, and it remains in an invalidated state.
			 *
			 * The implementation below re-renders the invalidated controls that are skipped and not rendered with their ancestor.
			 * The re-rendering here is only required for controls that already have DOM output.
			 */R.forEach(function(e){if(!e._bNeedsRendering||e.isDestroyed()){return}if(e.bOutput==true&&e.getDomRef()||e.bOutput=="invisible"&&document.getElementById(r.createInvisiblePlaceholderId(e))){e._bNeedsRendering=true;N.rerenderControl(e)}})}A(u,this.mInvalidatedControls);p.end(this.getId()+"---rerender");p.resume("renderPendingUIUpdates");return l};N.prototype._onControlRendered=function(e){var t=e.getId();if(this.mInvalidatedControls[t]){delete this.mInvalidatedControls[t]}if(this.iSuppressedControlsLength){Object.values(this.mSuppressedControls).forEach(function(e){e.delete(t)})}};N.rerenderControl=function(e){var t=null;if(e){t=e.getDomRef();if(!t||r.isPreservedContent(t)){t=document.getElementById(r.RenderPrefixes.Invisible+e.getId())}}var o=t&&t.parentNode;if(o){var n=e.getUIArea();var i=n?I:new r;C.debug("Rerender Control '"+e.getId()+"'"+(n?"":" (using a temp. RenderManager)"));r.preserveContent(t,true,false,e);i.render(e,o)}else{var n=e.getUIArea();n&&n._onControlRendered(e);C.info("Couldn't rerender '"+e.getId()+"', as its DOM location couldn't be determined")}};var _=/^(mousedown|mouseup|click|keydown|keyup|keypress|touchstart|touchend|tap)$/;var k=[],F=[];var D={mousemove:1,mouseover:1,mouseout:1,scroll:1,dragover:1,dragenter:1,dragleave:1};N.addEventPreprocessor=function(e){k.push(e)};N.getEventPreprocessors=function(){return k};N.addEventPostprocessor=function(e){F.push(e)};N.getEventPostprocessors=function(){return F};N.configureEventLogging=function(e){Object.assign(D,e);return Object.assign({},D)};N.prototype._handleEvent=function(e){var r,o,n;r=o=t.closestTo(e.target);s.refresh();if(r==null){return}if(e.isMarked("delayedMouseEvent")){return}var a=e.getMark("handledByUIArea"),u=this.getId();if(a&&a!==u){e.setMark("firstUIArea",false);return}e.setMarked("firstUIArea");e.srcControl=r;if(e.type==="contextmenu"&&e.shiftKey&&e.altKey&&(e.metaKey||e.ctrlKey)){d.info("Suppressed forwarding the contextmenu event as control event because CTRL+SHIFT+ALT is pressed!");return}k.forEach(function(t){t(e)});if(b){b._handleControlEvent(e,u)}if(this.bLocked){return}if(i.getActive()){n=e.type.match(_);if(n){i.notifyEventStart(e)}}var l=[];if(e.getPseudoTypes){l=e.getPseudoTypes()}l.push(e.type);var p=false;while(o instanceof t&&o.isActive()&&!e.isPropagationStopped()){var f=e.getMark("scopeCheckId"),g=f&&window.document.getElementById(f),c=o.getDomRef();if(!g||c&&c.contains(g)){for(var h=0,v=l.length;h<v;h++){var m=l[h];e.type=m;e.currentTarget=o.getDomRef();o._handleEvent(e);if(e.isImmediatePropagationStopped()){break}}if(!p&&!e.isMarked("enterKeyConsumedAsContent")){p=this._handleGroupChange(e,o)}if(e.isPropagationStopped()){break}if(o.bStopEventBubbling){break}c=o.getDomRef();if(!c){break}}c=c.parentNode;o=null;if(e.isMarked("fromMouseout")&&(c&&c.contains(e.relatedTarget))){break}while(c&&c!==this.getRootNode()){if(c.id){o=t.closestTo(c);if(o){break}}c=c.parentNode}}F.forEach(function(t){t(e)});if(n){i.notifyEventEnd(e)}e.currentTarget=this.getRootNode();e.setMark("handledByUIArea",u);if(e.isPropagationStopped()){d.debug("'"+e.type+"' propagation has been stopped")}var y=e.type;if(!D[y]){if(r){d.debug("Event fired: '"+y+"' on "+r,"","sap.ui.core.UIArea")}else{d.debug("Event fired: '"+y+"'","","sap.ui.core.UIArea")}}};N.prototype._onattach=function(){var e=this.getRootNode();if(e==null){return}jQuery(e).attr("data-sap-ui-area",e.id).on(m.events.join(" "),this._handleEvent.bind(this))};N.prototype._ondetach=function(){var e=this.getRootNode();if(e==null){return}jQuery(e).removeAttr("data-sap-ui-area").off()};N.prototype.clone=function(){throw new Error("UIArea can't be cloned")};N.prototype._handleGroupChange=function(e,r){var o=N._oFieldGroupValidationKey;if(e.type==="focusin"||e.type==="focusout"){if(e.type==="focusout"){r=t.closestTo(document.activeElement)}if(N._iFieldGroupDelayTimer){clearTimeout(N._iFieldGroupDelayTimer);N._iFieldGroupDelayTimer=null}N._iFieldGroupDelayTimer=setTimeout(this.setFieldGroupControl.bind(this,r),0);return true}else if(this.getFieldGroupControl()&&e.type==="keyup"&&e.keyCode===o.keyCode&&e.shiftKey===o.shiftKey&&e.altKey===o.altKey&&e.ctrlKey===o.ctrlKey){if(N._iFieldGroupTriggerDelay){clearTimeout(N._iFieldGroupTriggerDelay)}var n=this.getFieldGroupControl(),i=n?n._getFieldGroupIds():[];if(i.length>0){n.triggerValidateFieldGroup(i)}return true}return false};N.prototype.setFieldGroupControl=function(e){var r=e;while(r&&!(r instanceof t&&r.isA("sap.ui.core.Control"))){r=r.getParent()}var o=this.getFieldGroupControl();if(r!=o){var n=o?o._getFieldGroupIds():[],i=r?r._getFieldGroupIds():[],s=n.filter(function(e){return i.indexOf(e)<0});if(s.length>0){o.triggerValidateFieldGroup(s)}N._oFieldGroupControl=r}return this};N.prototype.getFieldGroupControl=function(){if(N._oFieldGroupControl&&!N._oFieldGroupControl.bIsDestroyed){return N._oFieldGroupControl}return null};o.init(N);N._oFieldGroupControl=null;N._iFieldGroupDelayTimer=null;N._oFieldGroupValidationKey={keyCode:a.ENTER,shiftKey:false,altKey:false,ctrlKey:false};N._oRenderLog=C;N.create=function(e){u(typeof e==="string"||typeof e==="object","vDomRef must be a string or object");if(!e){throw new Error("vDomRef must not be null")}var t;if(typeof e==="string"){var r=e;t=document.getElementById(r);if(!t){throw new Error("DOM element with ID '"+r+"' not found in page, but application tries to insert content.")}}else{t=e}if(!t.id||t.id.length==0){t.id=f()}var n=t.id;var i=o.get(n);if(!i){i=new N(t);if(b&&!g(b.oModels)){var s={oModels:Object.assign({},b.oModels),oBindingContexts:{},aPropagationListeners:[]};i._propagateProperties(true,i,s,true)}}else{i._setRootNode(t)}return i};N.setCore=function(e){b=e;var t=l.get({name:"sapUiAreas",type:l.Type.StringArray,defaultValue:null,freeze:true});if(t){for(var r=0,o=t.length;r<o;r++){N.create(t[r])}}};N.registry=o;h.registerForUpdate("UIAreas",o.all);return N});
//# sourceMappingURL=UIArea.js.map