/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../base/ManagedObject","./Component","./ComponentHooks","./Element","sap/ui/core/mvc/ViewType","sap/ui/core/mvc/XMLProcessingMode","./UIComponentMetadata","./mvc/Controller","./mvc/View","sap/base/util/ObjectPath","sap/base/future","sap/base/Log"],function(t,e,o,n,i,r,s,a,u,c,f,l){"use strict";var p=e.extend("sap.ui.core.UIComponent",{constructor:function(t,o){var n=false;try{if(typeof t!=="string"){o=t;t=undefined}if(o&&o.hasOwnProperty("_routerHashChanger")){this._oRouterHashChanger=o._routerHashChanger;delete o._routerHashChanger}if(o&&o.hasOwnProperty("_propagateTitle")){this._bRoutingPropagateTitle=o._propagateTitle;delete o._propagateTitle}e.apply(this,arguments);n=true}finally{if(!n){this._destroyCreatedInstances()}}},metadata:{abstract:true,rootView:null,publicMethods:["render"],aggregations:{rootControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},designtime:"sap/ui/core/designtime/UIComponent.designtime",routing:{}}},s);p._fnOnInstanceInitialized=null;p._fnOnInstanceDestroy=null;p.prototype.init=function(){var e=this;var n={};var i;if(this.getAutoPrefixId()){n.id=function(t){return e.createId(t)}}function r(t){var n=function(){o.onUIComponentInstanceInitialized.execute(e);if(typeof p._fnOnInstanceInitialized==="function"){p._fnOnInstanceInitialized(e)}};var i=function(t){e.setAggregation("rootControl",t)};if(t instanceof Promise){e.pRootControlLoaded=e.pRootControlLoaded.then(function(t){i(t);n();return t})}else if(t instanceof u&&t.oAsyncState&&t.oAsyncState.promise){i(t);e.pRootControlLoaded=e.pRootControlLoaded.then(function(t){n();return t})}else{i(t);n()}}function s(t,o){var n;if(t instanceof Promise){n=e.pRootControlLoaded.then(function(t){return t instanceof u?t.getId():undefined})}else if(t instanceof u){n=t.getId()}if(n){if(o.targetParent===undefined){o.targetParent=n}if(e._oTargets){e._oTargets._setRootViewId(n)}}}var a=this._getManifestEntry("/sap.ui5/routing",true)||{},c=a.config||{},f=a.routes;if(this.getManifestObject()?._getSchemaVersion()===2||this.isA("sap.ui.core.IAsyncContentCreation")){c.async=true}const l=p.collectRoutingClasses.call(this.getMetadata().getClass(),this)||{};if(l.routerClass){var g=l.routerClass;this._oRouter=new g(f,c,this,a.targets,this._oRouterHashChanger);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews()}else if(l.targetsClass){var d=l.views;this._oViews=new d({component:this});var h=l.targetsClass;this._oTargets=new h({targets:a.targets,config:c,views:this._oViews})}this.runAsOwner(function(){t.runWithPreprocessors(function(){i=e.createContent()},n)});if(i instanceof Promise){if(this.isA("sap.ui.core.IAsyncContentCreation")){this.pRootControlLoaded=i}else{throw new Error("Interface 'sap.ui.core.IAsyncContentCreation' must be implemented for component '"+this.getMetadata().getComponentName()+"' when 'createContent' is implemented asynchronously")}}else if(i instanceof u&&i.oAsyncState&&i.oAsyncState.promise){this.pRootControlLoaded=i.loaded()}else{this.pRootControlLoaded=Promise.resolve(i)}s(i,c);r(i)};function g(t){l.error(`The routing related class '${t}' was loaded synchronously as a result of a synchronous Component creation. Resolving a class in this fashion is deprecated. `+`Please use the asynchronous Component.create() factory instead and ensure all non-default routing relevant classes are maintained in the manifest.json.`)}function d(t){var e;if(typeof t==="string"){let o;if(t.startsWith("module:")){o=t.slice("module:".length)}else{o=t.replace(/\./g,"/")}e=sap.ui.require(o);if(!e){e=sap.ui.requireSync(o);g(o)}if(!e){e=c.get(t);if(e){l.error(`The class '${t}' was accessed via globals. `+"Retrieving routing classes via globals is deprecated and a result of synchronous Component creation, "+"please use the asynchronous sap.ui.core.Component.create() factory instead.")}}if(!e){f.errorThrows(`${this}: The specified class for router or targets "${t}" is undefined.`)}}else{e=t}return e}p.prototype.rootControlLoaded=function(){if(!this.pRootControlLoaded){f.errorThrows("Mandatory init() not called for UIComponent: '"+this.getManifestObject().getComponentName()+"'. A sub-class of sap.ui.core.UIComponent which overrides the init() function must apply the super init() function as well.",null,"sap.ui.support",function(){return{type:"missingInitInUIComponent"}})}return this.pRootControlLoaded||Promise.resolve(this.getRootControl())};p.prototype.destroy=function(){o.onUIComponentInstanceDestroy.execute(this);if(typeof p._fnOnInstanceDestroy==="function"){p._fnOnInstanceDestroy(this)}this._destroyCreatedInstances();return e.prototype.destroy.apply(this,arguments)};p.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter}else{if(this._oTargets){this._oTargets.destroy();this._oTargets=null}if(this._oViews){this._oViews.destroy();this._oViews=null}}};p.getRouterFor=function(t){var o=t;if(o instanceof a){o=o.getView()}if(o instanceof u){var n=e.getOwnerComponentFor(o);if(n){return n.getRouter()}else{return undefined}}};p.prototype.getRouter=function(){return this._oRouter};p.prototype.hasNativeRouter=function(){return this._oRouter===this.getRouter()};p.prototype.getTargets=function(){return this._oTargets};p.prototype.getAutoPrefixId=function(){return!!this.getManifestObject().getEntry("/sap.ui5/autoPrefixId")};p.prototype.byId=function(t){return n.getElementById(this.createId(t))};p.prototype.createId=function(t){if(!this.isPrefixedId(t)){t=this.getId()+"---"+t}return t};p.prototype.getLocalId=function(t){var e=this.getId()+"---";return t&&t.indexOf(e)===0?t.slice(e.length):null};p.prototype.isPrefixedId=function(t){return!!(t&&t.indexOf(this.getId()+"---")===0)};p.prototype.createContent=function(){var t=this._getManifestEntry("/sap.ui5/rootView",true);if(t&&typeof t==="string"){t={viewName:t}}if(t&&typeof t==="object"){if(!t.type&&!t.viewName?.startsWith("module:")){t.type=i.XML}if(t.id){t.id=this.createId(t.id)}if(this.getManifestObject()?._getSchemaVersion()===2){t.async=true}if(t.async&&t.type===i.XML){t.processingMode=r.Sequential}const e=this.isA("sap.ui.core.IAsyncContentCreation");if(e){return u.create(t)}else{return u._create(t)}}else if(t){throw new Error("Configuration option 'rootView' of component '"+this.getMetadata().getName()+"' is invalid! 'rootView' must be type of string or object!")}return null};p.prototype.getRootControl=function(){return this.getAggregation("rootControl")};p.prototype.render=function(t){var e=this.getRootControl();if(e&&t){t.renderControl(e)}};p.prototype.getUIArea=function(){return this.oContainer?this.oContainer.getUIArea():null};p.prototype.getEventingParent=function(){return this.getUIArea()};p.prototype.setContainer=function(t){this.oContainer=t;if(t){this._applyContextualSettings(t._getContextualSettings())}else{this._oContextualSettings=h;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oContainer){this._propagateContextualSettings()}}.bind(this),0)}}return this};p.prototype.onBeforeRendering=function(){};p.prototype.onAfterRendering=function(){};p.prototype._getRouterClassName=function(){var t=this._getManifestEntry("/sap.ui5/routing",true)||{},e=t.config||{};return e.routerClass};p.collectRoutingClasses=function(t){const e={};const o=this.getMetadata();const n=o._getManifestEntry("/sap.ui5/rootView");const r=typeof n==="string"?n:n?.viewName;if(r?.startsWith("module:")){e["viewClass"]=r}else if(r){const t=n.type||"XML";if(i[t]){const o="sap/ui/core/mvc/"+i[t]+"View";e["viewClass"]=o}}const s=o._getManifestEntry("/sap.ui5/routing",true);if(s){if(s.routes){let o;const n=this.getMetadata().getStaticProperty("_fnGetRouterClassName");if(typeof n==="function"){o=n(this.getMetadata().getManifestObject())}o??=t?._getRouterClassName()||s.config?.routerClass||"sap.ui.core.routing.Router";if(typeof o==="string"){o=o.replace(/\./g,"/")}e["routerClass"]=o}else if(s.targets){let t=s.config?.targetsClass||"sap.ui.core.routing.Targets";if(typeof t==="string"){t=t.replace(/\./g,"/")}e["targetsClass"]=t;e["views"]="sap/ui/core/routing/Views"}}if(t){for(const t in e){const o=e[t];e[t]=d(o)}}return e};const{_oContextualSettings:h}=new t;return p});
//# sourceMappingURL=UIComponent.js.map