/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/DataType","sap/ui/base/BindingInfo","sap/ui/core/CustomData","sap/ui/core/Component","sap/ui/core/ElementRegistry","./mvc/View","./mvc/ViewType","./mvc/XMLProcessingMode","./mvc/EventHandlerResolver","./ExtensionPoint","./StashedControlSupport","sap/ui/base/SyncPromise","sap/base/future","sap/base/Log","sap/base/util/ObjectPath","sap/base/assert","sap/base/util/LoaderExtensions","sap/base/util/JSTokenizer","sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/base/DesignTime","sap/ui/core/Lib"],function(e,t,n,r,i,a,o,s,u,l,c,f,d,p,g,m,v,h,w,b,y,C){"use strict";function A(n,r,i,a,o,s,u){var l=!!s;var c;var f=t.parse(r,a,true,false,false,false,o,l,u);if(l&&f){s.push(f.resolved);c=f.bindingInfo}else{c=f}if(c&&typeof c==="object"){return c}var p=r=typeof c==="string"?c:r;var g=e.getType(n);if(g){if(g instanceof e){p=g.parseValue(r,{context:a,locals:o});if(!g.isValid(p)){d.errorThrows("Value '"+r+"' is not valid for type '"+g.getName()+"'.")}}}else{throw new Error("Property "+i+" has unknown type "+n)}return typeof p==="string"?t.escape(p):p}function N(e){return e.localName||e.nodeName}var M="http://www.w3.org/1999/xhtml";var _="http://www.w3.org/2000/xmlns/";var x="http://www.w3.org/2000/svg";var V="sap.ui.core";var E="sap.ui.core.mvc";var I="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var T="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1";var P="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1";var S="http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1";var L="http://schemas.sap.com/sapui5/preprocessorextension/";var R=["controllerName","resourceBundleName","resourceBundleUrl","resourceBundleLocale","resourceBundleAlias"];var X=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/;function q(e,t){function n(t,n){var r,i=[];for(var a=0;a<t.childNodes.length;a++){r=e(t,t.childNodes[a],n);if(r){i.push(r.unwrap())}}return f.resolve(i)}function r(t,n){var r=Promise.resolve(),i=[n.chain];for(var a=0;a<t.childNodes.length;a++){r=r.then(e.bind(null,t,t.childNodes[a],n));i.push(r)}return Promise.all(i)}return t?r:n}var B={};B.loadTemplate=function(e,t){var n=e.replace(/\./g,"/")+("."+(t||"view")+".xml");return v.loadResource(n).documentElement};B.loadTemplatePromise=function(e,t){var n=e.replace(/\./g,"/")+("."+(t||"view")+".xml");return v.loadResource(n,{async:true}).then(function(e){return e.documentElement})};B.parseViewAttributes=function(e,t){var n,r;for(n=0;n<e.attributes.length;n++){r=e.attributes[n];if(R.includes(r.name)){if(r.name==="controllerName"&&r.value.startsWith("module:")){t["_controllerModuleName"]=r.value}else{t["_"+r.name]=r.value}}}};B.enrichTemplateIds=function(e,t){B.enrichTemplateIdsPromise(e,t,false);return e};B.enrichTemplateIdsPromise=function(e,t,n){return F(e,t,true,undefined,n).then(function(){return e})};B.parseTemplate=function(e,t,n){return B.parseTemplatePromise(e,t,false,{settings:n}).unwrap()};B.parseTemplatePromise=function(e,t,n,r){return F(e,t,false,r,n).then(function(e){if(t.isA("sap.ui.core.mvc.View")){var n,r;for(r=e.length-1;r>=0;r--){n=e[r];if(n&&n._isExtensionPoint){var i=[r,1].concat(n._aControls);Array.prototype.splice.apply(e,i)}}}return e})};function U(e,t){if(t instanceof Promise){throw new Error(`The module '${e}' returns a Promise where a control class was expected. Promises as module content are not supported. Please also refer to https://ui5.sap.com/#/topic/0cb44d7a147640a0890cefa5fd7c7f8e.`)}}function j(e){const t=/^[a-zA-Z_][a-zA-Z0-9_$]*$/;const n={throwError:false,errorMessage:""};if(!e||typeof e!=="object"){n.errorMessage="core:require in XMLView can't be parsed to a valid object";n.throwError=true;return n}for(const r of Object.keys(e)){if(!t.test(r)){n.errorMessage=`core:require in XMLView contains an invalid identifier: '${r}'`;if(!r.startsWith("$")){n.throwError=true}return n}const i=e[r];if(!i||typeof i!=="string"){n.errorMessage=`core:require in XMLView contains an invalid value '${i}' under key '${r}'`;n.throwError=true;return n}}return n}function k(e,t){var n=e.getAttributeNS(V,"require"),r,i,a;if(n){try{r=h.parseJS(n)}catch(t){p.error("Require attribute can't be parsed on Node: ",e.nodeName);throw t}a=j(r);if(a.errorMessage){const t=`${a.errorMessage} on Node: ${e.nodeName}`;if(a.throwError){throw new Error(t)}else{d.fatalThrows(`${t}. Keys that begin with '$' are reserved by the framework.`)}}if(!b(r)){i={};if(t){return new Promise(function(e,t){var n=Object.keys(r).reduce(function(e,t){i[t]=sap.ui.require(r[t]);return e&&i[t]!==undefined},true);if(n){e(i);return}sap.ui.require(Object.values(r),function(){var t=arguments;Object.keys(r).forEach(function(e,n){i[e]=t[n]});e(i)},t)})}else{Object.keys(r).forEach(function(e){i[e]=sap.ui.requireSync(r[e])});return f.resolve(i)}}}}function O(e,t,n){var r=f.resolve();if(!b(t)){var i=[];var a;if(n){r=new Promise(function(e){a=e})}Object.keys(t).forEach(function(n){var r=t[n];r.forEach(function(t){t.targetControl=e;var n=sap.ui.require(t.providerClass);if(n){i.push(n.applyExtensionPoint(t))}else{var r=new Promise(function(e,n){sap.ui.require([t.providerClass],function(t){e(t)},n)}).then(function(e){return e.applyExtensionPoint(t)});i.push(r)}})});if(n){Promise.all(i).then(a)}}return r}function $(e,t,n){var r=n;for(var i=0;i<100;i++){var a=e.lookupNamespaceURI(r);if(a==null||a===t){return r}r=n+i}throw new Error("Could not find an unused namespace prefix after 100 tries, giving up")}function F(e,v,h,j,F){var H=[],D=$(e,S,"__ui5"),K=k(e,F)||f.resolve(),W=e=>H.push(e);const z={$control:null,$controller:v._oContainingView.oController};const J={openStart:function(e,t){H.push(["openStart",[e,t]])},voidStart:function(e,t){H.push(["voidStart",[e,t]])},style:function(e,t){H.push(["style",[e,t]])},class:function(e){H.push(["class",[e]])},attr:function(e,t){H.push(["attr",[e,t]])},openEnd:function(){H.push(["openEnd"])},voidEnd:function(){H.push(["voidEnd"])},text:function(e){H.push(["text",[e]])},unsafeHtml:function(e){H.push(["unsafeHtml",[e]])},close:function(e){H.push(["close",[e]])}};if(j?.settings?.requireContext){K=K.then(e=>Object.assign({},j.settings.requireContext,e))}(()=>{F=F&&!!v._sProcessingMode;p.debug("XML processing mode is "+(v._sProcessingMode||"default")+".","","XMLTemplateProcessor")})();p.debug("XML will be processed "+(F?"asynchronously":"synchronously")+".","","XMLTemplateProcessor");var Z=y.isDesignModeEnabled();if(Z){v._sapui_declarativeSourceInfo={xmlNode:e,xmlRootNode:v._oContainingView===v?e:v._oContainingView._sapui_declarativeSourceInfo.xmlRootNode}}if(!v.isSubView()){e.setAttributeNS(_,"xmlns:"+D,S)}var G=ae(e,K);var Q=0;function Y(){for(;Q<H.length;Q++){var e=H[Q];if(e&&typeof e.then==="function"){return e.then(ee).then(Y)}}return H}function ee(e){var t=[Q,1].concat(e);Array.prototype.splice.apply(H,t)}return K.then(Y).then(function(t){if(G){var n=e.parentNode;n.removeChild(e);if(n.parentNode){n.parentNode.replaceChild(e,n)}}return t});function te(e){return e}function ne(e){return v._oContainingView.createId(e)}function re(e,t){var n=v.getMetadata().isA("sap.ui.core.mvc.View")?"View":"Fragment";var r=e.outerHTML?e.cloneNode(false).outerHTML:e.textContent;return"Error found in "+n+" (id: '"+v.getId()+"').\nXML node: '"+r+"':\n"+t}function ie(e){var t=N(e),n;const r=v.isA("sap.ui.core.mvc.XMLView")&&(e.namespaceURI===M||e.namespaceURI===x);if(r){n=e.ownerDocument.createElementNS(E,"View")}else if(v.isA("sap.ui.core.Fragment")&&(t!=="FragmentDefinition"||e.namespaceURI!==V)){n=e.ownerDocument.createElementNS(V,"FragmentDefinition")}if(n){var i=e.parentNode;if(i){i.replaceChild(n,e)}n.appendChild(e)}return n}function ae(e,t){var n=false,r=v.sViewName||v._sFragmentName,i,a;if(!r){var o=v;var s=0;while(++s<1e3&&o&&o!==o._oContainingView){o=o._oContainingView}r=o.sViewName}i=ie(e);if(i){e=i;n=true}a=N(e);if(v.isA("sap.ui.core.mvc.XMLView")){if(a!=="View"&&a!=="XMLView"||e.namespaceURI!==E){d.errorThrows("XMLView's root node must be 'View' or 'XMLView' and have the namespace 'sap.ui.core.mvc'"+(r?" (View name: "+r+")":""))}K=t.then(function(){return ce(e,v.getMetadata().getClass(),t,null,{rootArea:true,rootNode:true})})}else{var u=q(function(e,t,n){if(t.nodeType===1){return ue(t,n.chain,null,undefined,{rootArea:true})}},F);K=t.then(function(){return u(e,{chain:t})})}return n}function oe(e){if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(e)}else{return e()}}function se(e,t){var n;var r=C.all();w(r,function(r,i){if(e===i.namespace||e===i.name){n=i.name+"."+(i.tagNames&&i.tagNames[t]||t)}});n=n||e+"."+t;function i(e,t){if(!e){let t=`Control '${n}' did not return a class definition from sap.ui.define.`;(()=>{e=g.get(n);if(e){t+=" The control class was instead retrieved via a deprecated access to the global namespace. This fallback behavior will be removed in the next major version (2.0)."}})();d.errorThrows(`XMLTemplateProcessor: ${t}`)}U(t,e);return e}var a=n.replace(/\./g,"/");var o=sap.ui.require(a);if(!o){if(!F){o=sap.ui.requireSync(a);o=i(o,a);return o}return new Promise(function(e,t){sap.ui.require([a],function(n){try{n=i(n,a);e(n)}catch(e){t(e)}},t)})}else{U(a,o)}return o}function ue(e,t,n,r,i){var a=i&&i.rootArea,o=i&&i.rootNode&&v.isSubView(),s=N(e),u=a&&(v.isA("sap.ui.core.Fragment")||r&&r.name==="content"),l,c;const g=e.nodeType===3&&u;if(e.nodeType===1){if(e.namespaceURI===M||e.namespaceURI===x){d.warningThrows(`${v.getId()}: Using native HTML content in XMLViews is deprecated.`)}const g=e.namespaceURI===M||e.namespaceURI===x;if(g){if(a){if(r&&r.name!=="content"){p.error(re(e,"XHTML nodes can only be added to the 'content' aggregation and not to the '"+r.name+"' aggregation."));return f.resolve([])}if(i&&i.contentBound){throw new Error(re(e,"No XHTML or SVG node is allowed because the 'content' aggregation is bound."))}var m=e.namespaceURI===M;var w=e.getAttribute("id");if(w!=null){w=de(v,e)}else{w=o?v.getId():undefined}if(s==="style"){var b=e.attributes;var y=e.textContent;e=document.createElement(s);e.textContent=y;for(c=0;c<b.length;c++){var C=b[c];if(!C.prefix){e.setAttribute(C.name,C.value)}}if(w!=null){e.setAttribute("id",w)}if(o){e.setAttribute("data-sap-ui-preserve",v.getId())}J.unsafeHtml(e.outerHTML);return f.resolve([])}var A=X.test(s);if(A){J.voidStart(s,w)}else{J.openStart(s,w)}for(c=0;c<e.attributes.length;c++){var _=e.attributes[c];if(_.name!=="id"&&(_.localName!=="require"||_.namespaceURI!==V)){J.attr(m?_.name.toLowerCase():_.name,_.value)}}if(o){J.attr("data-sap-ui-preserve",v.getId())}if(A){J.voidEnd();if(e.firstChild){p.error("Content of void HTML element '"+s+"' will be ignored")}}else{J.openEnd();var E=k(e,F);if(E){t=f.all([t,E]).then(function(e){return Object.assign({},...e)})}var I=e instanceof HTMLTemplateElement?e.content:e;var T=q(function(e,t,n){return ue(t,n.chain,n.closestBinding,n.aggregation,n.config)},F);l=T(I,{chain:t,closestBinding:n,aggregation:r,config:{rootArea:a}});return l.then(function(e){J.close(s);return e.reduce(function(e,t){if(Array.isArray(t)){t.forEach(function(t){e.push(t)})}return e},[])})}}else{var P=e.attributes["id"]?e.attributes["id"].textContent||e.attributes["id"].text:null;if(h){return B.enrichTemplateIdsPromise(e,v,F).then(function(){return[]})}else{var S=function(t,n){var r={id:P?de(v,e,P):undefined,xmlNode:e,requireContext:n,containingView:v._oContainingView};r.processingMode=v._sProcessingMode;return oe(function(){return new t(r)})};return t.then(function(e){if(F){return new Promise(function(t,n){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(n){t([S(n,e)])},n)})}else{var t=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return[S(t,e)]}})}}}else{l=le(e,t,n);if(u){W(l)}return l}}else if(g){if(!i||!i.contentBound){J.text(e.textContent)}else if(e.textContent.trim()){throw new Error(re(e,"Text node isn't allowed because the 'content' aggregation is bound."))}}return f.resolve([])}function le(e,t,n){if(N(e)==="ExtensionPoint"&&e.namespaceURI===V){if(h){return f.resolve([])}else{var r=v instanceof a?v._oContainingView:v;var i=l._factory.bind(null,r,e.getAttribute("name"),function(){var r=f.resolve();var i=[];var a=e.childNodes;for(var o=0;o<a.length;o++){var s=a[o];if(s.nodeType===1){r=r.then(ue.bind(null,s,t,n));i.push(r)}}return f.all(i).then(function(e){var t=[];e.forEach(function(e){t=t.concat(e)});return t})},undefined,undefined,F);return f.resolve(oe(i))}}else{var o=N(e);var s=o;var u=o.lastIndexOf(".");if(u>=0){s=o.substring(u+1,o.length)}if(/^[a-z].*/.test(s)){var c=v.sViewName||v._sFragmentName||v.getId();p.warning("View or Fragment '"+c+"' contains a Control tag that starts with lower case '"+s+"'",v.getId(),"sap.ui.core.XMLTemplateProcessor#lowerCase")}var d=se(e.namespaceURI,o);if(d&&typeof d.then==="function"){return d.then(function(r){return ce(e,r,t,n)})}else{return ce(e,d,t,n)}}}function ce(e,l,g,w,y){var C=e.namespaceURI,M={},_={},x="",E=[],X=null,U=null,$=e.getAttribute("stashed")==="true",H=y&&y.rootArea,D=y&&y.rootNode,K;if(!h){e.removeAttribute("stashed")}if(!l){return f.resolve([])}if(D){M.id=v.getId()}var W=l.getMetadata();var J=W.getAllSettings();var G=!H?k(e,F):undefined;if(G){g=f.all([g,G]).then(function(e){return Object.assign({},e[0],e[1])})}g=g.then(function(r){if(b(r)){r=null}K=r;var i=F?[]:undefined;if(!h){for(var a=0;a<e.attributes.length;a++){var s=e.attributes[a],c=s.name,f=s.namespaceURI,g=J[c],m=s.value;if(D&&R.includes(c)){continue}if(c==="id"&&!D){M[c]=de(v,e,m)}else if(c==="class"){x+=m}else if(c==="viewName"){M[c]=m}else if(c==="fragmentName"){M[c]=m;M["containingView"]=v._oContainingView}else if(c==="binding"&&!g||c==="objectBindings"){if(!$){var w=t.parse(m,v._oContainingView.oController);if(w){M.objectBindings=M.objectBindings||{};M.objectBindings[w.model||undefined]=w}}}else if(c==="metadataContexts"){if(!$){var y=null;try{y=B._calculatedModelMapping(m,v._oContainingView.oController,true)}catch(e){d.errorThrows(`Failed to parse metadataContexts in view "${v}"`,{cause:e})}if(y){M.metadataContexts=y;if(B._preprocessMetadataContexts){B._preprocessMetadataContexts(l.getMetadata().getName(),M,v._oContainingView.oController)}}}}else if(c.indexOf(":")>-1){f=s.namespaceURI;if(f===I){var C=N(s);E.push(new n({key:C,value:A("any",m,C,v._oContainingView.oController,r,i)}))}else if(f===T){U=m}else if(f&&f.startsWith(L)){p.debug(v+": XMLView parser ignored preprocessor attribute '"+c+"' (value: '"+m+"')")}else if(f===S&&N(s)==="invisible"){g=J.visible;if(g&&g._iKind===0&&g.type==="boolean"){M.visible=false}}else if(f===V||f===S||c.startsWith("xmlns:")){}else{if(!X){X={}}if(!X.hasOwnProperty(s.namespaceURI)){X[s.namespaceURI]={}}X[s.namespaceURI][N(s)]=s.nodeValue;p.debug(v+": XMLView parser encountered unknown attribute '"+c+"' (value: '"+m+"') with unknown namespace, stored as sap-ui-custom-settings of customData")}}else if(g&&g._iKind===0){M[c]=A(g.type,m,c,v._oContainingView.oController,r,i,z)}else if(g&&g._iKind===1&&g.altTypes){if(!$){M[c]=A(g.altTypes[0],m,c,v._oContainingView.oController,r,null,z)}}else if(g&&g._iKind===2){if(!$){var w=t.parse(m,v._oContainingView.oController,false,false,false,false,r);if(w){M[c]=w}else{d.errorThrows(""+v+": aggregations with cardinality 0..n specifies a non valid BindingInfo (wrong value: "+c+"='"+m+"')")}}}else if(g&&g._iKind===3){if(!$){M[c]=ne(m)}}else if(g&&g._iKind===4){if(!$){M[c]=m.split(/[\s,]+/g).filter(te).map(ne)}}else if(g&&g._iKind===5){if(!$){var _=[];u.parse(m).forEach(function(e){var t=u.resolveEventHandler(e,v._oContainingView.oController,r);if(t){_.push(t)}else{d.warningThrows(""+v+': event handler function "'+e+'" is not a function or does not exist in the controller.')}});if(_.length){M[c]=_}}}else if(g&&g._iKind===-1){if(W.isA("sap.ui.core.mvc.View")&&(c=="async"||c=="type"&&o[m])){M[c]=A(g.type,m,c,v._oContainingView.oController,r)}else{d.warningThrows(""+v+": setting '"+c+"' for class "+W.getName()+" (value:'"+m+"') is not supported")}}else{d.assertThrows(c==="xmlns",v+": encountered unknown setting '"+c+"' for class "+W.getName()+" (value:'"+m+"')");if(B._supportInfo){B._supportInfo({context:e,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+c+"' for class "+W.getName()}})}}}if(X){E.push(new n({key:"sap-ui-custom-settings",value:X}))}if(E.length>0){M.customData=E}}if(Array.isArray(i)){return Promise.all(i).then(function(){return r})}return r}).catch(function(t){if(!t.isEnriched){t=new Error(re(e,t));t.isEnriched=true;p.error(t)}const n=v._sProcessingMode===s.SequentialLegacy;if(F&&!n){throw t}});var Q=q(Y,F);function Y(e,t,n){var r=n.aggregation,i=n.allAggregations,a=n.chain,o=n.closestBinding,s=n.config,u,l;if(t.nodeType===1){if(t.namespaceURI===P){M[N(t)]=t.querySelector("*");return undefined}u=t.namespaceURI===C&&i&&i[N(t)];if(u){return Q(t,{aggregation:u,allAggregations:null,chain:a,closestBinding:o,config:s})}else if(r){if(t.getAttribute("stashed")==="true"&&!h){var d=t;t=t.cloneNode();d.removeAttribute("stashed");l=function(){var n=de(v,t);c.createStashedControl({wrapperId:n,fnCreate:function(t){var n=F;if(F===false){t=true}F=!t;try{fe(d,"unstash");let n=Y(e,d,{aggregation:r,allAggregations:i,chain:f.resolve(K),closestBinding:o});if(t){n=n.unwrap()}return n}finally{F=n}}})};oe(l);t.removeAttribute("visible");fe(t,"invisible")}if(M[r.name]&&typeof M[r.name].path==="string"){o={aggregation:r.name,id:M.id};if(D&&r.name==="content"){s=s||{};s.contentBound=true}}return ue(t,a,o,r,s).then(function(e){for(var t=0;t<e.length;t++){var n=e[t];var i=r.name;if(n._isExtensionPoint){if(!M[i]){M[i]=[]}var a=_[i];if(!a){a=_[i]=[]}n.index=M[i].length;n.aggregationName=i;n.closestAggregationBindingCarrier=o&&o.id;n.closestAggregationBinding=o&&o.aggregation;var s=a[a.length-1];if(s){s._nextSibling=n}a.push(n)}else if(r.multiple){if(!M[i]){M[i]=[]}if(typeof M[i].path==="string"){m(!M[i].template,"list bindings support only a single template object");M[i].template=n}else{M[i].push(n)}}else{m(!M[i],"multiple aggregates defined for aggregation "+i+" with cardinality 0..1");M[i]=n}}return e})}else{throw new Error(re(t,"Cannot add direct child without default aggregation defined for control "+W.getElementName()))}}else if(t.nodeType===3){if(s&&s.rootArea){ue(t,a,o,r,s)}else{var p=t.textContent||t.text;if(p&&p.trim()){throw new Error(re(t,"Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed."))}}}}var ee=W.getDefaultAggregation();var ie=W.getAllAggregations();return Q(e,{aggregation:ee,allAggregations:ie,chain:g,closestBinding:w,config:y}).then(function(){var t;var n=f.resolve();var s=f.resolve();var u=e.getAttribute("type");var c=r.getOwnerComponentFor(v);var d=c?.getManifestObject()?._getSchemaVersion()===2||c?.isA("sap.ui.core.IAsyncContentCreation");if(h){if(!H&&e.hasAttribute("id")){pe(v,e)}}else if(!D&&l.getMetadata().isA("sap.ui.core.mvc.View")){if(!l._sType&&!M.viewName){M.viewName="module:"+l.getMetadata().getName().replace(/\./g,"/")}M.type=l._sType||u;if(F){if(d&&M.async===false){throw new Error("A nested view contained in a Component that uses manifest version 2 or implements 'sap.ui.core.IAsyncContentCreation' is processed asynchronously by default and cannot be processed synchronously.\n"+"Affected Component '"+c.getMetadata().getComponentName()+"' and View '"+M.viewName+"'.")}s=oe(function(){return a.create(M)})}else{if(l.getMetadata().isA("sap.ui.core.mvc.XMLView")&&v._sProcessingMode){M.processingMode=v._sProcessingMode}t=oe(function(){return a._create(M)})}}else if(l.getMetadata().isA("sap.ui.core.Fragment")&&F){if(u!==o.JS){M.processingMode=v._sProcessingMode}var p="sap/ui/core/Fragment";var g=sap.ui.require(p);M.name=M.name||M.fragmentName;if(g){s=g.load(M)}else{s=new Promise(function(e,t){sap.ui.require([p],function(t){t.load(M).then(function(t){e(t)})},t)})}}else{var m=function(){var t;if(D){t=v;if(!F){if(j&&j.settings){Object.keys(M).forEach(function(e){if(j.settings.hasOwnProperty(e)){j.settings[e]=M[e];delete M[e]}})}}v.applySettings(M)}else{t=oe(function(){var t;if(e.getAttributeNS(S,"unstash")==="true"){t=i.get(M.id);if(t.setVisible){t.setVisible(true)}t.applySettings(M)}else{t=new l(M)}return t})}n=O(t,_,F);return t};if(j&&j.fnRunWithPreprocessor){t=j.fnRunWithPreprocessor(m)}else{t=m()}}return s.then(function(e){return e||t}).then(function(t){if(x&&t.addStyleClass){t.addStyleClass(x)}if(!t){t=[]}else if(!Array.isArray(t)){t=[t]}if(B._supportInfo&&t){for(var r=0,i=t.length;r<i;r++){var a=t[r];if(a&&a.getId()){var o=B._supportInfo({context:e,env:{caller:"createRegularControls",nodeid:e.getAttribute("id"),controlid:a.getId()}}),s=U?U+",":"";s+=o;B._supportInfo.addSupportInfo(a.getId(),s)}}}if(Z){t.forEach(function(t){if(W.getCompositeAggregationName){var n=e.getElementsByTagName(t.getMetadata().getCompositeAggregationName());for(var r=0;r<n.length;r++){e.removeChild(n[0])}}t._sapui_declarativeSourceInfo={xmlNode:e,xmlRootNode:v._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:W.getName()==="sap.ui.core.Fragment"?M["fragmentName"]:null}})}return n.then(function(){return t})})})}function fe(e,t){var n=$(e,S,D);e.setAttributeNS(S,n+":"+t,"true")}function de(e,t,n){if(t.getAttributeNS(S,"id")){return t.getAttribute("id")}else{return ne(n?n:t.getAttribute("id"))}}function pe(e,t){t.setAttribute("id",ne(t.getAttribute("id")));fe(t,"id")}}B._preprocessMetadataContexts=null;B._calculatedModelMapping=function(e,n,r){var i,a={},o=t.parse(e,n);function s(e){if(e.length%2===0){throw new Error("The last entry is no binding")}for(var t=1;t<=e.length;t=t+2){if(typeof e[t-1]=="string"){throw new Error("Binding expected not a string")}if(e[t]){if(typeof e[t]!="string"||e[t]!=","){throw new Error("Missing delimiter ','")}}}}if(o){if(!o.formatter){i=o;o={parts:[i]}}else{s(o.formatter.textFragments)}for(var u=0;u<o.parts.length;u++){i=o.parts[u];a[i.model]=a[i.model]||(r?[]:null);if(Array.isArray(a[i.model])){a[i.model].push(i)}else{a[i.model]=i}}}return a};return B},true);
//# sourceMappingURL=XMLTemplateProcessor.js.map