/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./LRUPersistentCache","./CacheManagerNOP","sap/ui/Device","sap/base/config","sap/base/Log","sap/ui/performance/Measurement","sap/ui/performance/trace/Interaction"],function(e,n,t,s,r,i,a){"use strict";var o=s.getWritableInstance();function c(){return o.get({name:"sapUiXxCacheUse",type:s.Type.Boolean,defaultValue:true,external:true})}function u(e){o.set("sapUiXxCacheUse",e)}var h={_instance:null,_getInstance:function(){var e,n=b("_getInstance"),t=this;e=new Promise(function(e,s){var a;r.debug("Cache Manager: Initialization...");if(!h._instance){a=t._findImplementation();i.start(l,"CM",d);a.init().then(o,s);i.end(l,"CM")}else{o(h._instance)}function o(t){h._instance=t;n.endAsync();r.debug("Cache Manager initialized with implementation ["+h._instance.name+"], resolving _getInstance promise");e(t)}});n.endSync();return e},_findImplementation:function(){if(g()&&this._isSupportedEnvironment()){return e}else{r.debug("UI5 Cache Manager is switched off");return n}},set:function(e,n){var t,s=b("set",e);r.debug("Cache Manager: Setting value of type["+typeof n+"] with key ["+e+"]");t=this._callInstanceMethod("set",arguments).then(function e(){this.logResolved("set");s.endAsync()}.bind(this),function(n){r.error("Cache Manager: Setting key ["+e+"] failed. Error:"+n);s.endAsync();throw n});s.endSync();return t},get:function(e){var n,t=a.notifyAsyncStep(),s=b("get",e);r.debug("Cache Manager: Getting key ["+e+"]");n=this._callInstanceMethod("get",arguments).then(function e(n){this.logResolved("get");s.endAsync();return n}.bind(this),function(n){r.debug("Cache Manager: Getting key ["+e+"] failed. Error: "+n);s.endAsync();throw n}).finally(t);s.endSync();return n},has:function(e){var n,t=b("has",e);r.debug("Cache Manager: has key ["+e+"] called");n=this._callInstanceMethod("has",arguments).then(function e(n){this.logResolved("has");t.endAsync();return n}.bind(this));t.endSync();return n},del:function(e){var n,t=b("del",e);r.debug("Cache Manager: del called.");n=this._callInstanceMethod("del",arguments).then(function e(){this.logResolved("del");t.endAsync()}.bind(this),function(e){r.debug("Cache Manager: del failed. Error: "+e);t.endAsync();throw e});t.endSync();return n},delWithFilters:function(e){var n;r.debug("Cache Manager: delWithFilters called.");n=this._callInstanceMethod("delWithFilters",arguments).then(function e(){this.logResolved("delWithFilters")}.bind(this),function(e){r.debug("Cache Manager: delWithFilters failed. Error: "+e);throw e});return n},reset:function(){var e,n=b("reset");r.debug("Cache Manager: Reset called.");e=this._callInstanceMethod("reset",arguments).then(function e(){this.logResolved("reset");n.endAsync()}.bind(this),function(e){r.debug("Cache Manager: Reset failed. Error: "+e);n.endAsync();throw e});n.endSync();return e},_switchOff:function(){var e=this;return Promise.resolve().then(function(){y(e);u(false)})},_switchOn:function(){var e=this;return Promise.resolve().then(function(){if(!c()){y(e);u(true)}return Promise.resolve()})},_callInstanceMethod:function(e,n){var t,s="[sync ] _callInstanceMethod";i.start(s,"CM",d);if(this._instance){r.debug("Cache Manager: calling instance...");return this._instance[e].apply(this._instance,n)}r.debug("Cache Manager: getting instance...");t=this._getInstance().then(function t(s){return s[e].apply(s,n)});i.end(s);return t},_isSupportedEnvironment:function(){var e=[];if(this._bSupportedEnvironment==undefined){e.push({system:t.system.SYSTEMTYPE.DESKTOP,browserName:t.browser.BROWSER.CHROME,browserVersion:49});e.push({system:t.system.SYSTEMTYPE.DESKTOP,browserName:t.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:t.system.SYSTEMTYPE.TABLET,browserName:t.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:t.system.SYSTEMTYPE.PHONE,browserName:t.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:t.system.SYSTEMTYPE.TABLET,os:t.os.OS.ANDROID,browserName:t.browser.BROWSER.CHROME,browserVersion:80});e.push({system:t.system.SYSTEMTYPE.PHONE,os:t.os.OS.ANDROID,browserName:t.browser.BROWSER.CHROME,browserVersion:80});this._bSupportedEnvironment=e.some(function(e){var n=t.system[e.system],s=e.os?e.os===t.os.name:true,r=e.browserName===t.browser.name,i=t.browser.version>=e.browserVersion;try{return n&&s&&r&&i&&window.indexedDB}catch(e){return false}})}return this._bSupportedEnvironment},logResolved:function(e){this._instance.logResolved&&this._instance.logResolved(e)}};var d="CacheManager",l="[sync ] _initImplementation",f=0;function g(){return c()}function y(e){if(e._instance){e._instance._destroy();e._instance=null}}function b(e,n){f++;var t="[async]  "+e+"["+n+"]- #"+f,s="[sync ]  "+e+"["+n+"]- #"+f;i.start(t,"CM",[d,e]);i.start(s,"CM",[d,e]);return{sMeasureAsync:t,sMeasureSync:s,endAsync:function(){i.end(this.sMeasureAsync)},endSync:function(){i.end(this.sMeasureSync)}}}return h});
//# sourceMappingURL=CacheManager.js.map