/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/i18n/Localization","sap/base/i18n/date/TimezoneUtils"],function(t,e,n){"use strict";var o=["year","month","day","hour","minute","second","fractionalSecond"],r=/Z|GMT|:.*[\+|\-]|^([\+|\-]\d{2})?\d{4}(-\d{2}){0,2}$/,i=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],a=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],s={Sun:0,Mon:1,Tue:2,Wed:3,Thu:4,Fri:5,Sat:6};const u=/^(\d{1,4})-(\d{1,2})-(\d{1,2})(?:[T ](\d{1,2})(?::(\d{1,2})(?::(\d{1,2})(?:\.(\d{1,3}))?)?)?)?$/;function c(t,e){return(t<0?"-":"")+Math.abs(t).toString().padStart(e,"0")}function h(e,n){var i=h._createDateInstance(e);Object.defineProperties(this,{sTimezoneID:{value:n},oDate:{value:i,writable:true},oDateParts:{value:undefined,writable:true}});if(isNaN(i)){return}if(e.length>1||e.length===1&&typeof e[0]==="string"&&!r.test(e[0])){const n=[i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds()];const r=i.getTimezoneOffset();const a=new Date(i.getTime()-72e5).getTimezoneOffset();if(r<a){if(e.length>1){n[1]=e[1]||0;n[2]=e[2]!==undefined?e[2]:1;n[3]=e[3]!==undefined?e[3]:0;n[4]=e[4]!==undefined?e[4]:0}else{const o=u.exec(e[0]);if(o){n[1]=+o[2]-1;n[2]=o[3];n[3]=o[4]!==undefined?o[4]:0;n[4]=o[5]!==undefined?o[5]:0}else{t.warning("UI5Date for '"+e[0]+"' cannot be ensured to be correct as it is near"+" the change from standard time to daylight saving time in the current browser locale;"+" use the constructor with more than 1 arguments or use the ISO format instead",i,"sap.ui.core.date.UI5Date")}}}this._setParts(o,n)}}h.prototype=Object.create(Date.prototype,{constructor:{value:Date}});h.prototype[Symbol.toStringTag]="Date";h.prototype._getPart=function(t){var e;if(isNaN(this.oDate)){return NaN}this.oDateParts=this.oDateParts||n._getParts(this.oDate,this.sTimezoneID);if(t==="weekday"){return s[this.oDateParts.weekday]}e=parseInt(this.oDateParts[t]);if(t==="month"){e-=1}else if(t==="year"){if(this.oDateParts.era==="B"){e=1-e}}return e};h.prototype._setParts=function(t,e){var o,r,i,a,s,u,c={},h=Math.min(t.length,e.length);if(h===0){return this.setTime(NaN)}for(o=0;o<h;o+=1){u=parseInt(+e[o]);s=t[o];if(isNaN(u)){return this.setTime(NaN)}if(s==="month"){u+=1}else if(s==="year"){if(u<=0){u=1-u;c.era="B"}else{c.era="A"}}c[s]=u.toString()}if(this.oDateParts){r=this.oDateParts}else if(isNaN(this.oDate)){r={day:"1",fractionalSecond:"0",hour:"0",minute:"0",month:"1",second:"0"}}else{r=n._getParts(this.oDate,this.sTimezoneID)}c=Object.assign({},r,c);i=n._getDateFromParts(c);if(isNaN(i)){return this.setTime(NaN)}a=i.getTime()+n.calculateOffset(i,this.sTimezoneID)*1e3;return this.setTime(a)};h.prototype.clone=function(){return h.getInstance(this)};h.prototype.getDate=function(){return this._getPart("day")};h.prototype.getDay=function(){return this._getPart("weekday")};h.prototype.getFullYear=function(){return this._getPart("year")};h.prototype.getHours=function(){return this._getPart("hour")};h.prototype.getMilliseconds=function(){return this._getPart("fractionalSecond")};h.prototype.getMinutes=function(){return this._getPart("minute")};h.prototype.getMonth=function(){return this._getPart("month")};h.prototype.getSeconds=function(){return this._getPart("second")};h.prototype.getTimezoneOffset=function(){return n.calculateOffset(this.oDate,this.sTimezoneID)/60};h.prototype.getYear=function(){return this._getPart("year")-1900};h.prototype.setDate=function(t){return this._setParts(["day"],arguments)};h.prototype.setFullYear=function(t,e,n){return this._setParts(["year","month","day"],arguments)};h.prototype.setHours=function(t,e,n,o){return this._setParts(["hour","minute","second","fractionalSecond"],arguments)};h.prototype.setMilliseconds=function(t){return this._setParts(["fractionalSecond"],arguments)};h.prototype.setMinutes=function(t,e,n){return this._setParts(["minute","second","fractionalSecond"],arguments)};h.prototype.setMonth=function(t,e){return this._setParts(["month","day"],arguments)};h.prototype.setSeconds=function(t,e){return this._setParts(["second","fractionalSecond"],arguments)};h.prototype.setTime=function(t){this.oDateParts=undefined;return this.oDate.setTime(t)};h.prototype.setYear=function(t){var e=parseInt(t);e=e<0||e>99?e:e+1900;return this._setParts(["year"],[e])};h.prototype.toDateString=function(){if(isNaN(this.oDate)){return this.oDate.toDateString()}return i[this.getDay()]+" "+a[this.getMonth()]+" "+c(this.getDate(),2)+" "+c(this.getFullYear(),4)};h.prototype.toString=function(){if(isNaN(this.oDate)){return this.oDate.toString()}return this.toDateString()+" "+this.toTimeString()};h.prototype.toTimeString=function(){var t,e,n,o;if(isNaN(this.oDate)){return this.oDate.toTimeString()}o=this.getTimezoneOffset();n=o>0?"-":"+";t=Math.floor(Math.abs(o)/60);e=Math.abs(o)%60;return c(this.getHours(),2)+":"+c(this.getMinutes(),2)+":"+c(this.getSeconds(),2)+" GMT"+n+c(t,2)+c(e,2)};["getTime","getUTCDate","getUTCDay","getUTCFullYear","getUTCHours","getUTCMilliseconds","getUTCMinutes","getUTCMonth","getUTCSeconds","toGMTString","toISOString","toJSON","toUTCString","valueOf"].forEach(function(t){h.prototype[t]=function(){return this.oDate[t].apply(this.oDate,arguments)}});["toLocaleDateString","toLocaleString","toLocaleTimeString"].forEach(function(t){h.prototype[t]=function(n,o){return this.oDate[t](n||e.getLanguageTag().toString(),Object.assign({timeZone:this.sTimezoneID},o))}});["setUTCDate","setUTCFullYear","setUTCHours","setUTCMilliseconds","setUTCMinutes","setUTCMonth","setUTCSeconds"].forEach(function(t){h.prototype[t]=function(){this.oDateParts=undefined;return this.oDate[t].apply(this.oDate,arguments)}});h._createDateInstance=function(t){if(t[0]instanceof Date){t[0]=t[0].valueOf()}return new(Function.prototype.bind.apply(Date,[].concat.apply([null],t)))};h.getInstance=function(){var t=e.getTimezone();if(t!==n.getLocalTimezone()){return new h(arguments,t)}return h._createDateInstance(arguments)};h.checkDate=function(t){if(isNaN(t.getTime())){throw new Error("The given Date is not valid")}if(!(t instanceof h)&&e.getTimezone()!==n.getLocalTimezone()){throw new Error("Configured time zone requires the parameter 'oDate' to be an instance of"+" sap.ui.core.date.UI5Date")}};return h});
//# sourceMappingURL=UI5Date.js.map