/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarWeekNumbering","sap/ui/base/Object","sap/ui/core/Locale","sap/ui/core/LocaleData","./_Calendars","./CalendarUtils","./UI5Date"],function(e,t,r,a,n,i,o,s){"use strict";var u=r.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var e=u.getClass();return this.createDate(e,arguments)}});u.UTC=function(){var e=u.getClass();return e.UTC.apply(e,arguments)};u.now=function(){return Date.now()};u.prototype.createDate=function(e,t){if(e===Date){return s.getInstance.apply(null,t)}return new e(...t)};u.getInstance=function(t,r){var a,n;if(t instanceof u){t=t.getJSDate()}if(t&&isNaN(t.getTime())){throw new Error("The given date object is invalid")}if(!r){r=e.getCalendarType()}a=u.getClass(r);n=Object.create(a.prototype);n.oDate=t?s.getInstance(t):s.getInstance();n.sCalendarType=r;return n};u.getClass=function(t){if(!t){t=e.getCalendarType()}return i.get(t)};["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(e){u.prototype[e]=function(){return this.oDate[e].apply(this.oDate,arguments)}});u.prototype.getJSDate=function(){return this.oDate};u.prototype.getCalendarType=function(){return this.sCalendarType};u.prototype.getEra=function(){return u.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate())};u.prototype.setEra=function(e){};u.prototype.getUTCEra=function(){return u.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate())};u.prototype.setUTCEra=function(e){};u.prototype.getWeek=function(e,t){return u.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate(),e,t)};u.prototype.setWeek=function(e,t,r){var a=u.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setFullYear(a.year,a.month,a.day)};u.prototype.getUTCWeek=function(e,t){return u.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),e,t)};u.prototype.setUTCWeek=function(e,t,r){var a=u.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setUTCFullYear(a.year,a.month,a.day)};u.prototype.getQuarter=function(){return Math.floor(this.getMonth()/3)};u.prototype.getUTCQuarter=function(){return Math.floor(this.getUTCMonth()/3)};u.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0}else{return 1}};u.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0}else{return 1}};u.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort()}};u.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong()}};var g=7*24*60*60*1e3;u.getWeekByDate=function(t,r,n,i,o,s){s=s||e.getCalendarWeekNumbering();l(s);o=o||new a(e.getLanguageTag());var u=this.getClass(t);var g=c(u,r,o,s);var p=new u(u.UTC(r,n,i));var T,h,C,D,d;var U=f(s,o);if(U){T=y(g,p)}else{h=r-1;C=r+1;D=c(u,h,o,s);d=c(u,C,o,s);if(p>=d){r=C;T=0}else if(p<g){r=h;T=y(D,p)}else{T=y(g,p)}}return{year:r,week:T}};u.getFirstDateOfWeek=function(t,r,n,i,o){o=o||e.getCalendarWeekNumbering();l(o);i=i||new a(e.getLanguageTag());var s=this.getClass(t);var u=c(s,r,i,o);var p=new s(u.valueOf()+n*g);var y=f(o,i);if(y&&n===0&&u.getUTCFullYear()<r){return{year:r,month:0,day:1}}return{year:p.getUTCFullYear(),month:p.getUTCMonth(),day:p.getUTCDate()}};function f(e,r){var a=n.getInstance(r);return(e===t.Default||e===t.WesternTraditional)&&a.firstDayStartsFirstWeek()}function l(e){if(typeof e==="object"){if(typeof e.firstDayOfWeek!=="number"||typeof e.minimalDaysInFirstWeek!=="number"){throw new TypeError("Week config requires firstDayOfWeek and minimalDaysInFirstWeek to be set")}}else if(!Object.values(t).includes(e)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+e+"'")}}function p(e,t){if(typeof e==="object"&&typeof e.firstDayOfWeek==="number"&&typeof e.minimalDaysInFirstWeek==="number"){return e}return o.getWeekConfigurationValues(e,t)}function c(t,r,n,i){n=n||new a(e.getLanguageTag());var o=p(i,n);var s=o.minimalDaysInFirstWeek;var u=o.firstDayOfWeek;var g=new t(t.UTC(r,0,1));var f=7;if(isNaN(g.getTime())){throw new Error("Could not determine the first day of the week, because the date "+"object is invalid")}while(g.getUTCDay()!==u){g.setUTCDate(g.getUTCDate()-1);f--}if(f<s){g.setUTCDate(g.getUTCDate()+7)}return g}function y(e,t){return Math.floor((t.valueOf()-e.valueOf())/g)}var T={};u.getEraByDate=function(e,t,r,a){var n=h(e),i=new Date(0).setUTCFullYear(t,r,a),o;for(var s=n.length-1;s>=0;s--){o=n[s];if(!o){continue}if(o._start&&i>=o._startInfo.timestamp){return s}if(o._end&&i<o._endInfo.timestamp){return s}}};u.getCurrentEra=function(e){var t=s.getInstance();return this.getEraByDate(e,t.getFullYear(),t.getMonth(),t.getDate())};u.getEraStartDate=function(e,t){var r=h(e),a=r[t]||r[0];if(a._start){return a._startInfo}};function h(t){var r=new a(e.getLanguageTag()),i=n.getInstance(r),o=T[t];if(!o){var o=i.getEraDates(t);if(!o[0]){o[0]={_start:"1-1-1"}}for(var s=0;s<o.length;s++){var u=o[s];if(!u){continue}if(u._start){u._startInfo=C(u._start)}if(u._end){u._endInfo=C(u._end)}}T[t]=o}return o}function C(e){var t=e.split("-"),r,a,n;if(t[0]==""){r=-parseInt(t[1]);a=parseInt(t[2])-1;n=parseInt(t[3])}else{r=parseInt(t[0]);a=parseInt(t[1])-1;n=parseInt(t[2])}return{timestamp:new Date(0).setUTCFullYear(r,a,n),year:r,month:a,day:n}}return u});
//# sourceMappingURL=UniversalDate.js.map