/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/i18n/date/TimezoneUtils","sap/base/strings/formatMessage","sap/base/util/deepEqual","sap/base/util/extend","sap/ui/core/Lib","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Supportability","sap/ui/core/date/CalendarUtils","sap/ui/core/date/UI5Date","sap/ui/core/date/UniversalDate","sap/ui/core/format/FormatUtils"],function(e,t,a,r,n,i,o,s,l,u,f,d,c,h,m,g,p){"use strict";var y=function(){throw new Error};var v={DATE:"date",TIME:"time",DATETIME:"datetime",DATETIME_WITH_TIMEZONE:"datetimeWithTimezone"};var b={};var D=function(e){if(typeof e!=="string"&&!(e instanceof String)&&e!=null){throw new TypeError("The given timezone must be a string.")}};y.oDateInfo={type:v.DATE,oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(e,t,a){return e.getDatePattern(t,a)},oRequiredParts:{text:true,year:true,weekYear:true,month:true,day:true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date"]};y.oDateTimeInfo={type:v.DATETIME,oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(e,t,a){var r=t.indexOf("/");if(r>0){return e.getCombinedDateTimePattern(t.substr(0,r),t.substr(r+1),a)}else{return e.getCombinedDateTimePattern(t,t,a)}},oRequiredParts:{text:true,year:true,weekYear:true,month:true,day:true,hour0_23:true,hour1_24:true,hour0_11:true,hour1_12:true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};y._getDateTimeWithTimezoneInfo=function(e){var t=e.showDate===undefined||e.showDate;var a=e.showTime===undefined||e.showTime;var r=e.showTimezone===undefined||e.showTimezone;var n=y.oDateTimeInfo;if(t&&!a){n=y.oDateInfo}else if(!t&&a){n=y.oTimeInfo}return Object.assign({},n,{type:v.DATETIME_WITH_TIMEZONE,getTimezonePattern:function(e){if(!t&&!a&&r){return"VV"}else if(!r){return e}else{return e+" VV"}},getPattern:function(e,i,o){if(!t&&!a&&r){return"VV"}if(!r){return n.getPattern(e,i,o)}var s=n.getPattern(e,i,o);return e.applyTimezonePattern(s)}})};y.oTimeInfo={type:v.TIME,oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(e,t,a){return e.getTimePattern(t,a)},oRequiredParts:{text:true,hour0_23:true,hour1_24:true,hour0_11:true,hour1_12:true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};y.getInstance=function(e,t){return this.getDateInstance(e,t)};y.getDateInstance=function(e,t){return this.createInstance(e,t,this.oDateInfo)};y.getDateTimeInstance=function(e,t){return this.createInstance(e,t,this.oDateTimeInfo)};y.getDateTimeWithTimezoneInstance=function(e,t){if(e&&!(e instanceof f)){(function(){e=Object.assign({},e);if(typeof e.showTimezone==="string"){var t=e.showTimezone;if(e.showDate===undefined&&e.showTime===undefined){if(t==="Hide"){e.showTimezone=false}else if(t==="Only"){e.showDate=false;e.showTime=false}}e.showTimezone=t!=="Hide"}})();if(e.showDate===false&&e.showTime===false&&e.showTimezone===false){throw new TypeError("Invalid Configuration. One of the following format options must be true: "+"showDate, showTime or showTimezone.")}}return this.createInstance(e,t,y._getDateTimeWithTimezoneInfo(e||{}))};y.getTimeInstance=function(e,t){return this.createInstance(e,t,this.oTimeInfo)};y.createInstance=function(e,a,r,i){var o,s,u;s=Object.create(this.prototype);if(e instanceof f){a=e;e=undefined}if(!a){a=new f(t.getLanguageTag())}s.oLocale=a;s.oLocaleData=d.getInstance(a);s.oFormatOptions=l({},r.oDefaultFormatOptions,e);if(r.type===v.DATETIME_WITH_TIMEZONE){s.oFormatOptions.interval=false;s.oFormatOptions.singleIntervalValue=false;s.oFormatOptions.UTC=false}else{s.oFormatOptions.showTimezone=undefined;s.oFormatOptions.showDate=undefined;s.oFormatOptions.showTime=undefined}s.type=r.type;if(!s.oFormatOptions.calendarType){s.oFormatOptions.calendarType=t.getCalendarType()}if(s.oFormatOptions.firstDayOfWeek===undefined&&s.oFormatOptions.minimalDaysInFirstWeek!==undefined||s.oFormatOptions.firstDayOfWeek!==undefined&&s.oFormatOptions.minimalDaysInFirstWeek===undefined){throw new TypeError("Format options firstDayOfWeek and minimalDaysInFirstWeek need both to be set, but only one was provided.")}if(s.oFormatOptions.calendarWeekNumbering&&!Object.values(n).includes(s.oFormatOptions.calendarWeekNumbering)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+s.oFormatOptions.calendarWeekNumbering+"'")}if(!s.oFormatOptions.pattern){if(s.oFormatOptions.format){s.oFormatOptions.pattern=s.oLocaleData.getCustomDateTimePattern(s.oFormatOptions.format,s.oFormatOptions.calendarType)}else{s.oFormatOptions.pattern=r.getPattern(s.oLocaleData,s.oFormatOptions.style,s.oFormatOptions.calendarType)}}if(s.oFormatOptions.interval){var c,h=s.oFormatOptions.intervalDelimiter;if(s.oFormatOptions.format){s.intervalPatterns=s.oLocaleData.getCustomIntervalPattern(s.oFormatOptions.format,null,s.oFormatOptions.calendarType);if(typeof s.intervalPatterns==="string"){s.intervalPatterns=[s.intervalPatterns]}c=s.oLocaleData.getCustomDateTimePattern(s.oFormatOptions.format,s.oFormatOptions.calendarType);s.intervalPatterns.push(c)}else{c=s.oFormatOptions.pattern;s.intervalPatterns=[s.oLocaleData.getCombinedIntervalPattern(s.oFormatOptions.pattern,s.oFormatOptions.calendarType),s.oFormatOptions.pattern]}s.intervalPatterns.push(s.oFormatOptions.pattern+" - "+s.oFormatOptions.pattern);if(h){h=h.replace(/'/g,"''");h="'"+h+"'";s.intervalPatterns.unshift(c+h+c)}s.intervalPatterns=Array.from(new Set(s.intervalPatterns))}if(!i){o=r.aFallbackFormatOptions;if(r.bShortFallbackFormatOptions){u=r.getPattern(s.oLocaleData,"short");o=o.concat(y._createFallbackOptionsWithoutDelimiter(u))}if(s.oFormatOptions.pattern&&r.bPatternFallbackWithoutDelimiter){o=y._createFallbackOptionsWithoutDelimiter(s.oFormatOptions.pattern).concat(o)}o=o.reduce(function(e,t){var a=Object.keys(t),r=e.some(function(e){return Object.keys(e).length===a.length&&a.every(function(a){return e[a]===t[a]})});if(!r){e.push(t)}return e},[]);s.aFallbackFormats=y._createFallbackFormat(o,s.oFormatOptions.calendarType,a,r,s.oFormatOptions)}s.oRequiredParts=r.oRequiredParts;s.aRelativeScales=r.aRelativeScales;s.aRelativeParseScales=r.aRelativeParseScales;s.aIntervalCompareFields=r.aIntervalCompareFields;s.init();return s};y.prototype.init=function(){var e=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData._getMonthsWithAlternatives("abbreviated",e);this.aMonthsWide=this.oLocaleData.getMonths("wide",e);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",e);this.aMonthsAbbrevSt=this.oLocaleData._getMonthsStandAloneWithAlternatives("abbreviated",e);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",e);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",e);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",e);this.aDaysWide=this.oLocaleData.getDays("wide",e);this.aDaysNarrow=this.oLocaleData.getDays("narrow",e);this.aDaysShort=this.oLocaleData.getDays("short",e);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",e);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",e);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",e);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",e);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",e);this.aQuartersWide=this.oLocaleData.getQuarters("wide",e);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",e);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",e);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",e);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",e);this.aErasNarrow=this.oLocaleData.getEras("narrow",e);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",e);this.aErasWide=this.oLocaleData.getEras("wide",e);this.aDayPeriodsAbbrev=this.oLocaleData.getDayPeriods("abbreviated",e);this.aDayPeriodsNarrow=this.oLocaleData.getDayPeriods("narrow",e);this.aDayPeriodsWide=this.oLocaleData.getDayPeriods("wide",e);this.oFlexibleDayPeriodsAbbrev=this.oLocaleData.getFlexibleDayPeriods("abbreviated",e);this.oFlexibleDayPeriodsNarrow=this.oLocaleData.getFlexibleDayPeriods("narrow",e);this.oFlexibleDayPeriodsWide=this.oLocaleData.getFlexibleDayPeriods("wide",e);this.oFlexibleDayPeriodsAbbrevSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("abbreviated",e);this.oFlexibleDayPeriodsNarrowSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("narrow",e);this.oFlexibleDayPeriodsWideSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("wide",e);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray)};y._createFallbackFormat=function(e,t,a,r,n){return e.map(function(e){var i=Object.assign({},e);i.showDate=n.showDate;i.showTime=n.showTime;i.showTimezone=n.showTimezone;if(typeof r.getTimezonePattern==="function"&&i.pattern){i.pattern=r.getTimezonePattern(i.pattern)}if(n.interval){i.interval=true}i.calendarType=t;return y.createInstance(i,a,r,true)})};y._createFallbackOptionsWithoutDelimiter=function(e){var t=/[^dMyGU]/g,a={regex:/d+/g,replace:"dd"},r={regex:/M+/g,replace:"MM"},n={regex:/[yU]+/g,replace:["yyyy","yy"]};e=e.replace(t,"");e=e.replace(a.regex,a.replace);e=e.replace(r.regex,r.replace);return n.replace.map(function(t){return{pattern:e.replace(n.regex,t),strictParsing:true}})};var T={isNumber:function(e){return e>=48&&e<=57},findNumbers:function(e,t){var a=0;while(a<t&&this.isNumber(e.charCodeAt(a))){a++}return e.substr(0,a)},startsWithIgnoreCase:function(e,t,a){if(e.startsWith(t)){return true}try{var r=t.toLocaleUpperCase(a);var n=e.toLocaleUpperCase(a);if(r.length!==t.length||n.length!==e.length){return false}return n.startsWith(r)}catch(e){return false}},findEntry:function(e,t,a){let r=-1;let n=0;t.forEach((t,i)=>{(Array.isArray(t)?t:[t]).forEach(t=>{if(t.length>n&&this.startsWithIgnoreCase(e,t,a)){r=i;n=t.length}})});return{index:r,length:n}},parseTZ:function(e,t){var a=0;var r=e.charAt(0)==="+"?-1:1;var n;if(e[0]==="Z"){return{length:1,tzDiff:0}}a++;n=this.findNumbers(e.substr(a),2);var i=parseInt(n);a+=2;if(t){a++}n=this.findNumbers(e.substr(a),2);var o=0;if(n){a+=2;o=parseInt(n)}return{length:a,tzDiff:(o+60*i)*60*r}},checkValid:function(e,t,a){if(e in a.oRequiredParts&&t){return false}return true}};y._oParseHelper=T;y._createPatternSymbol=function(e){var t=typeof e.isNumeric==="function"&&e.isNumeric||function(){return e.isNumeric||false};return{name:e.name,format:e.format||function(){return""},parse:e.parse||function(){return{}},isNumeric:t}};y.prototype.oSymbols={"":y._createPatternSymbol({name:"text",format:function(e,t){return e.value},parse:function(e,t,a,r){var n;var i=true;var o=0;var s=0;var l="-~‐‑‒–—﹘﹣－～";const u=p.normalize(t.value);for(;s<u.length;s++){n=u.charAt(s);if(n===" "){while(e.charAt(o)===" "){o++}}else if(l.includes(n)){if(!l.includes(e.charAt(o))){i=false}o++}else{if(e.charAt(o)!==n){i=false}o++}if(!i){break}}if(i){return{length:o}}else{var f=false;if(r.index<r.formatArray.length-1){f=r.formatArray[r.index+1].type in a.oRequiredParts}return{valid:T.checkValid(t.type,f,a)}}}}),G:y._createPatternSymbol({name:"era",format:function(e,t,a,r){var n=t.getUTCEra();if(e.digits<=3){return r.aErasAbbrev[n]}else if(e.digits===4){return r.aErasWide[n]}else{return r.aErasNarrow[n]}},parse:function(e,t,a,r){var n=[a.aErasWide,a.aErasAbbrev,a.aErasNarrow];for(var i=0;i<n.length;i++){var o=n[i];var s=T.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{era:s.index,length:s.length}}}return{era:a.aErasWide.length-1,valid:T.checkValid(t.type,true,a)}}}),y:y._createPatternSymbol({name:"year",format:function(e,t,a,n){var i=t.getUTCFullYear();var o=String(i);var s=n.oFormatOptions.calendarType;if(e.digits===2&&o.length>2){o=o.substr(o.length-2)}if(s!==r.Japanese&&e.digits===1&&i<100){o=o.padStart(4,"0")}return o.padStart(e.digits,"0")},parse:function(e,t,a,n){var i,o,s,l=a.oFormatOptions.calendarType;if(t.digits===1){i=4}else if(t.digits===2){i=2}else{i=t.digits}o=T.findNumbers(e,i);s=o===""||n.exactLength&&o.length!==i;var u=parseInt(o);if(l!==r.Japanese&&o.length<=2){var f=g.getInstance(m.getInstance(),l),d=f.getUTCFullYear(),c=Math.floor(d/100),h=c*100+u-d;if(h<-70){u+=(c+1)*100}else if(h<30){u+=c*100}else{u+=(c-1)*100}}return{length:o.length,valid:T.checkValid(t.type,s,a),year:u}},isNumeric:true}),Y:y._createPatternSymbol({name:"weekYear",format:function(e,t,a,n){var i=t.getUTCWeek(n.oLocale,F(n.oFormatOptions));var o=i.year;var s=String(o);var l=n.oFormatOptions.calendarType;if(e.digits===2&&s.length>2){s=s.substr(s.length-2)}if(l!==r.Japanese&&e.digits===1&&o<100){s=s.padStart(4,"0")}return s.padStart(e.digits,"0")},parse:function(e,t,a,n){var i,o,s,l=a.oFormatOptions.calendarType;if(t.digits===1){i=4}else if(t.digits===2){i=2}else{i=t.digits}o=T.findNumbers(e,i);s=o===""||n.exactLength&&o.length!==i;var u=parseInt(o);var f=u;if(l!==r.Japanese&&o.length<=2){var d=g.getInstance(m.getInstance(),l),c=d.getUTCFullYear(),h=Math.floor(c/100),p=h*100+f-c;if(p<-70){f+=(h+1)*100}else if(p<30){f+=h*100}else{f+=(h-1)*100}}return{length:o.length,valid:T.checkValid(t.type,s,a),year:u,weekYear:f}},isNumeric:true}),M:y._createPatternSymbol({name:"month",format:function(e,t,a,r){var n=t.getUTCMonth();if(e.digits===3){const e=r.aMonthsAbbrev[n];return Array.isArray(e)?e[0]:e}else if(e.digits===4){return r.aMonthsWide[n]}else if(e.digits>4){return r.aMonthsNarrow[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s,l=[a.aMonthsWide,a.aMonthsWideSt,a.aMonthsAbbrev,a.aMonthsAbbrevSt,a.aMonthsNarrow,a.aMonthsNarrowSt];if(t.digits<3){i=T.findNumbers(e,Math.max(t.digits,2));o=i===""||r.exactLength&&i.length<2;s=T.checkValid(t.type,o,a);n=parseInt(i)-1;if(r.strict&&(n>11||n<0)){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var d=T.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(d.index!==-1){return{month:d.index,length:d.length}}}s=T.checkValid(t.type,true,a)}return{month:n,length:i?i.length:0,valid:s}},isNumeric:function(e){return e<3}}),L:y._createPatternSymbol({name:"monthStandalone",format:function(e,t,a,r){var n=t.getUTCMonth();if(e.digits===3){const e=r.aMonthsAbbrevSt[n];return Array.isArray(e)?e[0]:e}else if(e.digits===4){return r.aMonthsWideSt[n]}else if(e.digits>4){return r.aMonthsNarrowSt[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s,l=[a.aMonthsWide,a.aMonthsWideSt,a.aMonthsAbbrev,a.aMonthsAbbrevSt,a.aMonthsNarrow,a.aMonthsNarrowSt];if(t.digits<3){i=T.findNumbers(e,Math.max(t.digits,2));o=i===""||r.exactLength&&i.length<2;s=T.checkValid(t.type,o,a);n=parseInt(i)-1;if(r.strict&&(n>11||n<0)){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var d=T.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(d.index!==-1){return{month:d.index,length:d.length}}}s=T.checkValid(t.type,true,a)}return{month:n,length:i?i.length:0,valid:s}},isNumeric:function(e){return e<3}}),w:y._createPatternSymbol({name:"weekInYear",format:function(e,t,a,r){var n=t.getUTCWeek(r.oLocale,F(r.oFormatOptions));var i=n.week;var o=String(i+1);if(e.digits<3){o=o.padStart(e.digits,"0")}else{o=r.oLocaleData.getCalendarWeek(e.digits===3?"narrow":"wide",o.padStart(2,"0"))}return o},parse:function(e,t,a,r){var n,i,o,s,l=0;if(t.digits<3){n=T.findNumbers(e,2);l=n.length;s=parseInt(n)-1;i=!n||r.exactLength&&l<2;o=T.checkValid(t.type,i,a)}else{n=a.oLocaleData.getCalendarWeek(t.digits===3?"narrow":"wide");n=n.replace("{0}","([0-9]+)");var u=new RegExp(n),f=u.exec(e);if(f){l=f[0].length;s=parseInt(f[f.length-1])-1}else{o=T.checkValid(t.type,true,a)}}return{length:l,valid:o,week:s}},isNumeric:function(e){return e<3}}),W:y._createPatternSymbol({name:"weekInMonth"}),D:y._createPatternSymbol({name:"dayInYear"}),d:y._createPatternSymbol({name:"day",format:function(e,t){var a=t.getUTCDate();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=T.findNumbers(e,Math.max(t.digits,2)),i=n===""||r.exactLength&&n.length<2,o=T.checkValid(t.type,i,a),s=parseInt(n);if(r.strict&&(s>31||s<1)){o=false}return{day:s,length:n.length,valid:o}},isNumeric:true}),Q:y._createPatternSymbol({name:"quarter",format:function(e,t,a,r){var n=t.getUTCQuarter();if(e.digits===3){return r.aQuartersAbbrev[n]}else if(e.digits===4){return r.aQuartersWide[n]}else if(e.digits>4){return r.aQuartersNarrow[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s;var l=[a.aQuartersWide,a.aQuartersWideSt,a.aQuartersAbbrev,a.aQuartersAbbrevSt,a.aQuartersNarrow,a.aQuartersNarrowSt];if(t.digits<3){n=T.findNumbers(e,Math.max(t.digits,2));i=n===""||r.exactLength&&n.length<2;s=T.checkValid(t.type,i,a);o=parseInt(n)-1;if(r.strict&&o>3){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var d=T.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(d.index!==-1){return{quarter:d.index,length:d.length}}}s=T.checkValid(t.type,true,a)}return{length:n?n.length:0,quarter:o,valid:s}},isNumeric:function(e){return e<3}}),q:y._createPatternSymbol({name:"quarterStandalone",format:function(e,t,a,r){var n=t.getUTCQuarter();if(e.digits===3){return r.aQuartersAbbrevSt[n]}else if(e.digits===4){return r.aQuartersWideSt[n]}else if(e.digits>4){return r.aQuartersNarrowSt[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s;var l=[a.aQuartersWide,a.aQuartersWideSt,a.aQuartersAbbrev,a.aQuartersAbbrevSt,a.aQuartersNarrow,a.aQuartersNarrowSt];if(t.digits<3){n=T.findNumbers(e,Math.max(t.digits,2));i=n===""||r.exactLength&&n.length<2;s=T.checkValid(t.type,i,a);o=parseInt(n)-1;if(r.strict&&o>3){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var d=T.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(d.index!==-1){return{quarter:d.index,length:d.length}}}s=T.checkValid(t.type,true,a)}return{length:n?n.length:0,quarter:o,valid:s}},isNumeric:function(e){return e<3}}),F:y._createPatternSymbol({name:"dayOfWeekInMonth"}),E:y._createPatternSymbol({name:"dayNameInWeek",format:function(e,t,a,r){var n=t.getUTCDay();if(e.digits<4){return r.aDaysAbbrev[n]}else if(e.digits===4){return r.aDaysWide[n]}else if(e.digits===5){return r.aDaysNarrow[n]}else{return r.aDaysShort[n]}},parse:function(e,t,a,r){var n=[a.aDaysWide,a.aDaysWideSt,a.aDaysAbbrev,a.aDaysAbbrevSt,a.aDaysShort,a.aDaysShortSt,a.aDaysNarrow,a.aDaysNarrowSt];for(var i=0;i<n.length;i++){var o=n[i];var s=T.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{dayOfWeek:s.index,length:s.length}}}}}),c:y._createPatternSymbol({name:"dayNameInWeekStandalone",format:function(e,t,a,r){var n=t.getUTCDay();if(e.digits<4){return r.aDaysAbbrevSt[n]}else if(e.digits===4){return r.aDaysWideSt[n]}else if(e.digits===5){return r.aDaysNarrowSt[n]}else{return r.aDaysShortSt[n]}},parse:function(e,t,a,r){var n=[a.aDaysWide,a.aDaysWideSt,a.aDaysAbbrev,a.aDaysAbbrevSt,a.aDaysShort,a.aDaysShortSt,a.aDaysNarrow,a.aDaysNarrowSt];for(var i=0;i<n.length;i++){var o=n[i];var s=T.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{day:s.index,length:s.length}}}}}),u:y._createPatternSymbol({name:"dayNumberOfWeek",format:function(e,t,a,r){var n=t.getUTCDay();return r._adaptDayOfWeek(n)},parse:function(e,t,a,r){var n=T.findNumbers(e,t.digits),i=r.exactLength&&n.length!==t.digits;return{dayNumberOfWeek:parseInt(n),length:n.length,valid:T.checkValid(t.type,i,a)}},isNumeric:true}),a:y._createPatternSymbol({name:"amPmMarker",format:function(e,t,a,r){var n=t.getUTCDayPeriod();if(e.digits<=3){return r.aDayPeriodsAbbrev[n]}else if(e.digits===4){return r.aDayPeriodsWide[n]}else{return r.aDayPeriodsNarrow[n]}},parse:function(e,t,a,r,n){var i,o,s,l,u,f,d=[a.aDayPeriodsWide,a.aDayPeriodsAbbrev,a.aDayPeriodsNarrow];i=/[aApP](?:\.)?[\x20\xA0]?[mM](?:\.)?/;u=e.match(i);o=u&&u.index===0;function c(e){return e.replace(/[\x20\xA0]/g,"").replace(/\./g,"")}if(o){e=c(e)}for(l=0;l<d.length;l+=1){f=d[l].map(e=>p.normalize(e));if(o){f=f.map(c)}s=T.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{pm:s.index===1,length:o?u[0].length:s.length}}}return{valid:false}}}),B:y._createPatternSymbol({name:"flexibleDayPeriod",format:function(e,t,a,r){var n=r.aFormatArray.some(function(e){return"hHKk".includes(e.symbol)}),i=r.oLocaleData.getFlexibleDayPeriodOfTime(t.getUTCHours(),t.getUTCMinutes());if(n){if(e.digits<=3){return r.oFlexibleDayPeriodsAbbrev[i]}if(e.digits===4){return r.oFlexibleDayPeriodsWide[i]}return r.oFlexibleDayPeriodsNarrow[i]}if(e.digits<=3){return r.oFlexibleDayPeriodsAbbrevSt[i]}if(e.digits===4){return r.oFlexibleDayPeriodsWideSt[i]}return r.oFlexibleDayPeriodsNarrowSt[i]},parse:function(e,t,a,r){var n,i,o,s=a.aFormatArray.some(function(e){return"hHKk".includes(e.symbol)}),l=[a.oFlexibleDayPeriodsWide,a.oFlexibleDayPeriodsAbbrev,a.oFlexibleDayPeriodsNarrow];if(s){for(n=0;n<l.length;n++){o=l[n];i=T.findEntry(e,Object.values(o),a.oLocaleData.sCLDRLocaleId);if(i.index!==-1){return{flexDayPeriod:Object.keys(o)[i.index],length:i.length}}}}return{valid:false}}}),H:y._createPatternSymbol({name:"hour0_23",format:function(e,t){var a=t.getUTCHours();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=T.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=T.checkValid(t.type,o,a);if(r.strict&&i>23){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),k:y._createPatternSymbol({name:"hour1_24",format:function(e,t){var a=t.getUTCHours();var r=a===0?"24":String(a);return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=T.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=T.checkValid(t.type,o,a);if(i===24){i=0}if(r.strict&&i>23){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),K:y._createPatternSymbol({name:"hour0_11",format:function(e,t){var a=t.getUTCHours();var r=String(a>11?a-12:a);return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=T.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=T.checkValid(t.type,o,a);if(r.strict&&i>11){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),h:y._createPatternSymbol({name:"hour1_12",format:function(e,t){var a=t.getUTCHours();var r;if(a>12){r=String(a-12)}else if(a===0){r="12"}else{r=String(a)}return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=r.dateValue.pm,i=T.findNumbers(e,Math.max(t.digits,2)),o=parseInt(i),s=i===""||r.exactLength&&i.length<2,l=T.checkValid(t.type,s,a);if(o===12){o=0;n=n===undefined?true:n}if(r.strict&&o>11){l=false}return{hour:o,length:i.length,pm:n,valid:l}},isNumeric:true}),m:y._createPatternSymbol({name:"minute",format:function(e,t){var a=t.getUTCMinutes();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=T.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=T.checkValid(t.type,o,a);if(r.strict&&i>59){s=false}return{length:n.length,minute:i,valid:s}},isNumeric:true}),s:y._createPatternSymbol({name:"second",format:function(e,t){var a=t.getUTCSeconds();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=Math.max(t.digits,2),i=T.findNumbers(e,n),o=i===""||r.exactLength&&i.length<n,s=parseInt(i),l=T.checkValid(t.type,o,a);if(r.strict&&s>59){l=false}return{length:i.length,second:s,valid:l}},isNumeric:true}),S:y._createPatternSymbol({name:"fractionalsecond",format:function(e,t){var a=t.getUTCMilliseconds();var r=String(a);var n=r.padStart(3,"0");n=n.substr(0,e.digits);n=n.padEnd(e.digits,"0");return n},parse:function(e,t,a,r){var n=T.findNumbers(e,t.digits),i=n.length,o=r.exactLength&&i<t.digits;n=n.substr(0,3);n=n.padEnd(3,"0");var s=parseInt(n);return{length:i,millisecond:s,valid:T.checkValid(t.type,o,a)}},isNumeric:true}),z:y._createPatternSymbol({name:"timezoneGeneral",format:function(e,t,a,r,n){if(e.digits>3&&t.getTimezoneLong&&t.getTimezoneLong()){return t.getTimezoneLong()}else if(t.getTimezoneShort&&t.getTimezoneShort()){return t.getTimezoneShort()}var o=i.calculateOffset(t,n);var s="GMT";var l=Math.abs(o/60);var u=o>0;var f=Math.floor(l/60);var d=Math.floor(l%60);if(!a&&l!==0){s+=u?"-":"+";s+=String(f).padStart(2,"0");s+=":";s+=String(d).padStart(2,"0")}else{s+="Z"}return s},parse:function(e,t,a,r){var n=0;var i;var o=e.substring(0,3);if(o==="GMT"||o==="UTC"){n=3}else if(e.substring(0,2)==="UT"){n=2}else if(e.charAt(0)==="Z"){n=1;i=0}else{return{error:"cannot be parsed correctly by sap.ui.core.format.DateFormat: The given timezone is not supported!"}}if(e.charAt(0)!=="Z"){var s=T.parseTZ(e.substr(n),true);n+=s.length;i=s.tzDiff}return{length:n,tzDiff:i}}}),Z:y._createPatternSymbol({name:"timezoneRFC822",format:function(e,t,a,r,n){var o=i.calculateOffset(t,n);var s=Math.abs(o/60);var l=o>0;var u=Math.floor(s/60);var f=Math.floor(s%60);var d="";if(!a){d+=l?"-":"+";d+=String(u).padStart(2,"0");d+=String(f).padStart(2,"0")}return d},parse:function(e,t,a,r){return T.parseTZ(e,false)}}),X:y._createPatternSymbol({name:"timezoneISO8601",format:function(e,t,a,r,n){var o=i.calculateOffset(t,n);var s=Math.abs(o/60);var l=o>0;var u=Math.floor(s/60);var f=Math.floor(s%60);var d="";if(!a&&s!==0){d+=l?"-":"+";d+=String(u).padStart(2,"0");if(e.digits>1||f>0){if(e.digits===3||e.digits===5){d+=":"}d+=String(f).padStart(2,"0")}}else{d+="Z"}return d},parse:function(e,t,a,r){if(e.charAt(0)==="Z"){return{length:1,tzDiff:0}}else{return T.parseTZ(e,t.digits===3||t.digits===5)}}}),V:y._createPatternSymbol({name:"timezoneID",format:function(e,t,a,r,n){if(!a&&e.digits===2){return r.oLocaleData.getTimezoneTranslations()[n]||n}return""},parse:function(e,t,a,r,n){var o={timezone:"",length:0};if(t.digits===2){var s=a.oLocaleData.getTimezoneTranslations();n=i.getABAPTimezone(n);if(e===s[n]){return{timezone:n,length:e.length}}var l=Object.values(s);var u=T.findEntry(e,l,a.oLocaleData.sCLDRLocaleId);if(u.index!==-1){return{timezone:Object.keys(s)[u.index],length:u.length}}var f="";for(var d=e.length;d>0;d-=1){f=e.slice(0,d);if(i.isValidTimezone(f)){o.timezone=i.getABAPTimezone(f);o.length=f.length;break}}}return o}})};y.prototype._format=function(e,t,a){if(this.oFormatOptions.relative){var r=this.formatRelative(e,t,this.oFormatOptions.relativeRange,a);if(r){return r}}var n=this.oFormatOptions.calendarType;var i=g.getInstance(e,n);var o=[],s,l,u;for(var f=0;f<this.aFormatArray.length;f++){s=this.aFormatArray[f];u=s.symbol||"";o.push(this.oSymbols[u].format(s,i,t,this,a))}l=o.join("");if(c.collectOriginInfo()){l=new String(l);l.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern}}return l};y.prototype.format=function(t,n){var o;if(this.type===v.DATETIME_WITH_TIMEZONE){o=n;n=false;D(o);o=i.getABAPTimezone(o);if(o&&!i.isValidTimezone(o)){e.error("The given timezone isn't valid.");return""}}var s=this.oFormatOptions.calendarType,l;if(n===undefined){n=this.oFormatOptions.UTC}o=o||a.getTimezone();if(Array.isArray(t)){if(!this.oFormatOptions.interval){e.error("Non-interval DateFormat can't format more than one date instance.");return""}if(t.length!==2){e.error("Interval DateFormat can only format with 2 date instances but "+t.length+" is given.");return""}t=t.map(function(e){return O(e,o,n)});if(this.oFormatOptions.singleIntervalValue){if(t[0]===null){e.error("First date instance which is passed to the interval DateFormat shouldn't be null.");return""}if(t[1]===null){l=this._format(t[0],n,o)}}if(l===undefined){if(!t.every(P)){e.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return""}l=this._formatInterval(t,n)}}else{if(!P(t)){const a=t===undefined||t===null;if(a&&this.type===v.DATETIME_WITH_TIMEZONE&&this.oFormatOptions.pattern.includes("VV")){return this.oLocaleData.getTimezoneTranslations()[o]||o}e.error("The given date instance isn't valid.");return""}if(this.oFormatOptions.interval){e.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return""}t=O(t,o,n);l=this._format(t,n,o)}if(s===r.Japanese&&this.oLocale.getLanguage()==="ja"){l=l.replace(/(^|\D)1\u5e74/g,"$1元年")}return l};y.prototype._useCustomIntervalDelimiter=function(e){var t;if(!this.oFormatOptions.intervalDelimiter){return false}if(this.oFormatOptions.format){t=this.oLocaleData._parseSkeletonFormat(this.oFormatOptions.format);return t.some(function(t){return e[t.group]})}return true};y.prototype._formatInterval=function(e,t){var a,r,n,i,o=[],s=this.oFormatOptions.calendarType,l=[],u=g.getInstance(e[0],s),f=g.getInstance(e[1],s),d=this._getDiffFields([u,f]);if(!d){return this._format(e[0],t)}if(this._useCustomIntervalDelimiter(d)){n=this.intervalPatterns[0]}else if(this.oFormatOptions.format){n=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,d,s)}else{n=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s)}l=this.parseCldrDatePattern(n);a=u;for(var c=0;c<l.length;c++){r=l[c];i=r.symbol||"";if(r.repeat){a=f}o.push(this.oSymbols[i].format(r,a,t,this))}return o.join("")};var S={Era:"Era",FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};y.prototype._getDiffFields=function(e){var t=false,a={};this.aIntervalCompareFields.forEach(function(r){var n="getUTC",i=n+r,o=S[r],l=e[0][i].apply(e[0]),u=e[1][i].apply(e[1]);if(!s(l,u)){t=true;a[o]=true}});if(t){return a}return null};y.prototype._parse=function(e,t,a,r,n){var i,o,s,u,f,d,c,h={valid:true,lastTimezonePatternSymbol:""},m=0,g={formatArray:t,dateValue:h,strict:r},p=this;function y(e){return p.oSymbols[e.symbol||""]}function v(e){return!!e&&y(e).isNumeric(e.digits)}for(var b=0;b<t.length;b++){c=e.substr(m);s=t[b];f=t[b-1];o=t[b+1];g.index=b;g.exactLength=v(s)&&(v(f)||v(o));d=y(s).parse(c,s,this,g,n)||{};if(d.tzDiff!==undefined||d.timezone){d.lastTimezonePatternSymbol=s.symbol}h=l(h,d);if(d.valid===false){break}m+=d.length||0}h.index=m;u=h.pm;if(h.flexDayPeriod&&h.hour*60+(h.minute||0)<720){i=this.oLocaleData.getFlexibleDayPeriodOfTime(h.hour+12,h.minute||0);u=h.flexDayPeriod===i}if(u){h.hour+=12}if(h.dayNumberOfWeek===undefined&&h.dayOfWeek!==undefined){h.dayNumberOfWeek=this._adaptDayOfWeek(h.dayOfWeek)}if(h.quarter!==undefined&&h.month===undefined&&h.day===undefined){h.month=3*h.quarter;h.day=1}return h};y.prototype._parseInterval=function(e,t,a,r,n){var i,o,s;this.intervalPatterns.some(function(t){var l=this.parseCldrDatePattern(t);o=undefined;for(var u=0;u<l.length;u++){if(l[u].repeat){o=u;break}}if(o===undefined){s=this._parse(e,l,a,r,n);if(s.index===0||s.index<e.length){s.valid=false}if(s.valid===false){return}i=[s,s];return true}else{i=[];s=this._parse(e,l.slice(0,o),a,r,n);if(s.valid===false){return}i.push(s);var f=s.index;s=this._parse(e.substring(f),l.slice(o),a,r,n);if(s.index===0||s.index+f<e.length){s.valid=false}if(s.valid===false){return}i.push(s);return true}}.bind(this));return i};function F(e){if(e.calendarWeekNumbering){return e.calendarWeekNumbering}else if(e.firstDayOfWeek!==undefined&&e.minimalDaysInFirstWeek!==undefined){return{firstDayOfWeek:e.firstDayOfWeek,minimalDaysInFirstWeek:e.minimalDaysInFirstWeek}}return undefined}var O=function(e,t,a){if(!a&&P(e)){return i.convertToTimezone(e,t)}return e};var w=function(e,t,a,r,n,o,s){if(!e.valid){return null}var l,u=typeof e.year==="number"?e.year:1970;l=g.getInstance(new Date(0),t);l.setUTCEra(e.era||g.getCurrentEra(t));l.setUTCFullYear(u,e.month||0,e.day||1);l.setUTCHours(e.hour||0);l.setUTCMinutes(e.minute||0);l.setUTCSeconds(e.second||0);l.setUTCMilliseconds(e.millisecond||0);if(r&&(e.day||1)!==l.getUTCDate()){return null}if(e.week!==undefined&&(e.month===undefined||e.day===undefined)){l.setUTCWeek({year:e.weekYear||e.year,week:e.week},s,F(o));if(e.dayNumberOfWeek!==undefined){l.setUTCDate(l.getUTCDate()+e.dayNumberOfWeek-1)}}l=l.getJSDate();if(!a&&(e.lastTimezonePatternSymbol==="V"&&e.timezone||e.tzDiff===undefined)){if(e.timezone){n=e.timezone}if(n){e.tzDiff=i.calculateOffset(l,n)}}if(e.tzDiff){l.setUTCSeconds(l.getUTCSeconds()+e.tzDiff)}return l};function k(e,t){if(e===t){return e}var a={};Object.keys(e).forEach(function(t){a[t]=e[t]});Object.keys(t).forEach(function(e){if(!a.hasOwnProperty(e)){a[e]=t[e]}});return a}function I(e,t){if(e.getTime()>t.getTime()){return false}return true}function P(e){return e&&typeof e.getTime==="function"&&!isNaN(e.getTime())}y.prototype.parse=function(t,n,o){var s=this.oFormatOptions.showDate===undefined||this.oFormatOptions.showDate;var l=this.oFormatOptions.showTime===undefined||this.oFormatOptions.showTime;if(this.type===v.DATETIME_WITH_TIMEZONE&&(s&&!l||!s&&l)){throw new TypeError("The input can only be parsed back to date if both date and time are supplied.")}var u;if(n===undefined&&this.type!==v.DATETIME_WITH_TIMEZONE){n=this.oFormatOptions.UTC}var f=n;if(this.type===v.DATETIME_WITH_TIMEZONE){u=n;n=false;D(u);if(u&&!i.isValidTimezone(u)){e.error("The given timezone isn't valid.");return null}}t=t==null?"":String(t).trim();t=p.normalize(t);var d;var c=this.oFormatOptions.calendarType;u=u||a.getTimezone();if(o===undefined){o=this.oFormatOptions.strictParsing}if(c===r.Japanese&&this.oLocale.getLanguage()==="ja"){t=t.replace(/\u5143\u5e74/g,"1年")}if(!this.oFormatOptions.interval){var h=this.parseRelative(t,n);if(h){return h}d=this._parse(t,this.aFormatArray,n,o,u);if(d.index===0||d.index<t.length){d.valid=false}h=w(d,c,n,o,u,this.oFormatOptions,this.oLocale);if(h){if(this.type===v.DATETIME_WITH_TIMEZONE){var m=this.oFormatOptions.showTimezone===undefined||this.oFormatOptions.showTimezone;if(!m&&s&&l){return[h,undefined]}else if(m&&!s&&!l){return[undefined,d.timezone]}return[h,d.timezone||undefined]}return h}}else{var g=this._parseInterval(t,c,n,o,u);var y,b;if(g&&g.length===2){var T=k(g[0],g[1]);var S=k(g[1],g[0]);y=w(T,c,n,o,u,this.oFormatOptions,this.oLocale);b=w(S,c,n,o,u,this.oFormatOptions,this.oLocale);if(y&&b){if(this.oFormatOptions.singleIntervalValue&&y.getTime()===b.getTime()){return[y,null]}var F=I(y,b);if(o&&!F){e.error("StrictParsing: Invalid date range. The given end date is before the start date.");return[null,null]}return[y,b]}}}if(this.aFallbackFormats){var O;this.aFallbackFormats.every(function(e){O=e.parse(t,f,o);if(Array.isArray(O)){if(e.type===v.DATETIME_WITH_TIMEZONE){return false}return!(O[0]&&O[1])}else{return!O}});return O}if(!this.oFormatOptions.interval){return null}else{return[null,null]}};y.prototype.parseCldrDatePattern=function(e){if(b[e]){return b[e]}var t=[],a,r=false,n=null,i="",o="",s={},l=false;for(a=0;a<e.length;a++){var u=e.charAt(a),f,d,c;if(r){if(u==="'"){d=e.charAt(a-1);c=e.charAt(a-2);f=e.charAt(a+1);if(d==="'"&&c!=="'"){r=false}else if(f==="'"){a+=1}else{r=false;continue}}if(i==="text"){n.value+=u}else{n={type:"text",value:u};t.push(n);i="text"}}else{if(u==="'"){r=true}else if(this.oSymbols[u]){o=this.oSymbols[u].name;if(i===o){n.digits++}else{n={type:o,symbol:u,digits:1};t.push(n);i=o;if(!l){if(s[o]){n.repeat=true;l=true}else{s[o]=true}}}}else{if(i==="text"){n.value+=u}else{n={type:"text",value:u};t.push(n);i="text"}}}}b[e]=t;return t};y.prototype.parseRelative=function(e,t){var a,r,n,i,o;if(!e){return null}a=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var s=0;s<a.length;s++){r=a[s];n=new RegExp("^\\s*"+r.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");i=n.exec(e);if(i){if(r.value!==undefined){return l(r.value,r.scale)}else{o=parseInt(i[1]);return l(o*r.sign,r.scale)}}}function l(e,a){var r=m.getInstance();if(t){r.setUTCFullYear(r.getFullYear(),r.getMonth(),r.getDate());r.setUTCHours(r.getHours(),r.getMinutes(),r.getSeconds(),r.getMilliseconds());switch(a){case"second":r.setUTCSeconds(r.getUTCSeconds()+e);break;case"minute":r.setUTCMinutes(r.getUTCMinutes()+e);break;case"hour":r.setUTCHours(r.getUTCHours()+e);break;case"day":r.setUTCDate(r.getUTCDate()+e);break;case"week":r.setUTCDate(r.getUTCDate()+e*7);break;case"month":r.setUTCMonth(r.getUTCMonth()+e);break;case"quarter":r.setUTCMonth(r.getUTCMonth()+e*3);break;case"year":r.setUTCFullYear(r.getUTCFullYear()+e);break}}else{switch(a){case"second":r.setSeconds(r.getSeconds()+e);break;case"minute":r.setMinutes(r.getMinutes()+e);break;case"hour":r.setHours(r.getHours()+e);break;case"day":r.setDate(r.getDate()+e);break;case"week":r.setDate(r.getDate()+e*7);break;case"month":r.setMonth(r.getMonth()+e);break;case"quarter":r.setMonth(r.getMonth()+e*3);break;case"year":r.setFullYear(r.getFullYear()+e);break}}return r}};y.prototype.formatRelative=function(e,t,a,r){var n,i,s,l,u=O(new Date,r),f=this.oFormatOptions.relativeScale||"day";s=(e.getTime()-u.getTime())/1e3;if(this.oFormatOptions.relativeScale==="auto"){f=this._getScale(s,this.aRelativeScales);f=M(e,u,f,s)}if(!a){a=this._mRanges[f]}if(f==="year"||f==="month"||f==="day"){u=new Date(Date.UTC(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate()));n=new Date(0);n.setUTCFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e=n}i=this._getDifference(f,[u,e]);if(this.oFormatOptions.relativeScale!=="auto"&&(i<a[0]||i>a[1])){return null}l=this.oLocaleData.getRelativePattern(f,i,s>0,this.oFormatOptions.relativeStyle);return o(l,[Math.abs(i)])};y.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};y.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592e3,quarter:7776e3,year:31536e3};y.prototype._getScale=function(e,t){var a,r;e=Math.abs(e);for(var n=0;n<t.length;n++){r=t[n];if(e>=this._mScales[r]){a=r;break}}if(!a){a=t[t.length-1]}return a};function M(e,t,a,r){var n=Math.abs(e.getUTCMonth()-t.getUTCMonth());if(a==="week"&&n===2){return"month"}else if(a==="week"&&n===1){if(e.getUTCDate()===t.getUTCDate()||r<0&&e.getUTCDate()<t.getUTCDate()||r>0&&e.getUTCDate()>t.getUTCDate()){return"month"}}else if(a==="month"&&n===1){if(r>0&&e.getUTCDate()<t.getUTCDate()||r<0&&e.getUTCDate()>t.getUTCDate()){return"week"}}return a}function C(e,t){var a,r=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],n=new Date(e.getTime());for(var i=t;i<r.length;i++){a="setUTC"+r[t];n[a].apply(n,[0])}return n}var L={year:function(e,t){return t.getUTCFullYear()-e.getUTCFullYear()},month:function(e,t){return t.getUTCMonth()-e.getUTCMonth()+this.year(e,t)*12},week:function(e,t,a){var r=a._adaptDayOfWeek(e.getUTCDay());var n=a._adaptDayOfWeek(t.getUTCDay());e=C(e,3);t=C(t,3);return(t.getTime()-e.getTime()-(n-r)*a._mScales.day*1e3)/(a._mScales.week*1e3)},day:function(e,t,a){e=C(e,3);t=C(t,3);return(t.getTime()-e.getTime())/(a._mScales.day*1e3)},hour:function(e,t,a){e=C(e,4);t=C(t,4);return(t.getTime()-e.getTime())/(a._mScales.hour*1e3)},minute:function(e,t,a){e=C(e,5);t=C(t,5);return(t.getTime()-e.getTime())/(a._mScales.minute*1e3)},second:function(e,t,a){e=C(e,6);t=C(t,6);return(t.getTime()-e.getTime())/(a._mScales.second*1e3)}};y.prototype._adaptDayOfWeek=function(e){var t=F(this.oFormatOptions),a;if(typeof t==="object"){a=t.firstDayOfWeek}else{a=h.getWeekConfigurationValues(t,this.oLocale).firstDayOfWeek}var r=e-(a-1);if(r<=0){r+=7}return r};y.prototype._getDifference=function(e,t){var a=t[0];var r=t[1];return Math.round(L[e](a,r,this))};y.prototype.getAllowedCharacters=function(e){if(this.oFormatOptions.relative){return""}var t="";var a=false;var r=false;var n;for(var i=0;i<e.length;i++){n=e[i];switch(n.type){case"text":if(t.indexOf(n.value)<0){t+=n.value}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!a){t+="0123456789";a=true}break;case"month":case"monthStandalone":if(n.digits<3){if(!a){t+="0123456789";a=true}}else{r=true}break;default:r=true;break}}if(r){t=""}return t};y.prototype.getPlaceholderText=function(){var e=u.getResourceBundleFor("sap.ui.core");return e.getText("date.placeholder",[this.format.apply(this,this.getSampleValue())])};y.prototype.getSampleValue=function(){var e,t=m.getInstance().getFullYear(),r=this.oFormatOptions.UTC;function n(e,t,a,n,i,o,s){return r?m.getInstance(Date.UTC(e,t,a,n,i,o,s)):m.getInstance(e,t,a,n,i,o,s)}e=n(t,11,31,23,59,58,123);if(this.type===v.DATETIME_WITH_TIMEZONE){return[e,a.getTimezone()]}if(this.oFormatOptions.interval){return[[n(t,11,22,9,12,34,567),e]]}return[e]};return y},true);
//# sourceMappingURL=DateFormat.js.map