/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/ui/base/Object","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Supportability","sap/ui/core/format/FormatUtils","sap/base/Log","sap/base/assert","sap/base/util/extend"],function(e,t,r,i,n,a,o,s,u,c){"use strict";var l=r.extend("sap.ui.core.format.NumberFormat",{constructor:function(e){throw new Error}});const f=/[0#.,]+/;const g=/\s/g;const m=/\p{L}$/u;const p=/^\p{L}/u;const d=/([0#.,]*)([^0#.,]*)(¤)([^0#.,]*)([0#.,]*)/;const h=/^(-?)0+(\d)/;const y=/0+(\.0+)?/;const C=/^0+$/;const b=/^-(0(?:.0+)?)$/;const S=/0+$/;const F=/[\u061c\u200e\u200f\u202a\u202b\u202c]/g;const D=/\u200e/;var O=function(e,t,r){var i=U(e);return new RegExp("^\\d+"+"(?:"+i+"?"+"\\d{"+t+"}"+")*"+""+i+"?"+"\\d{"+r+"}"+"$")};var N={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"FLOOR",CEILING:"CEILING",TOWARDS_ZERO:"TOWARDS_ZERO",AWAY_FROM_ZERO:"AWAY_FROM_ZERO",HALF_FLOOR:"HALF_FLOOR",HALF_CEILING:"HALF_CEILING",HALF_TOWARDS_ZERO:"HALF_TOWARDS_ZERO",HALF_AWAY_FROM_ZERO:"HALF_AWAY_FROM_ZERO"};l.add=function(e,t){const r=e.split(".");let i=r[0];const n=r[1];const a=i[0]==="-";if(a){i=i.slice(1);t=-t}const o=i.split("").map(Number);const s=o.length-1;o[s]+=t;for(let e=s;e>=0;e-=1){if(o[e]>=10){o[e]=o[e]%10;if(e===0){o.unshift(1);break}o[e-1]+=1}else if(o[e]<0&&e>0){o[e]=10+o[e];o[e-1]-=1;if(e===1&&o[0]===0){o.shift();break}}else{break}}if(a){o[0]=-o[0]}let u=o.join("");if(!n){return u}u=u==="0"&&a?"-0":u;const c=u[0]==="-"?"-":"";if(a===!!c){return u+"."+n}const l=n.split("").map(Number);for(let e=l.length-1;e>=0;e-=1){l[e]=10-l[e];if(e>0){l[e-1]+=1}}return c+(Math.abs(o[0])-1)+"."+l.join("")};l.getMaximumDecimals=function({decimals:e,maxFractionDigits:t}){if(t>=0&&e>0&&t<e){return t}return e};function L(e){if(typeof e==="number"){return Math.ceil(e)}const[t,r="0"]=e.split(".");return C.test(r)||t[0]==="-"?t:l.add(t,1)}function v(e){if(typeof e==="number"){return Math.floor(e)}const[t,r="0"]=e.split(".");return C.test(r)||t[0]!=="-"?t:l.add(t,-1)}function w(e,t){if(typeof e==="number"){return t?e+.5:e-.5}e=l._shiftDecimalPoint(e,1);e=l.add(e,t?5:-5);return l._shiftDecimalPoint(e,-1)}const I={[R.FLOOR]:v,[R.CEILING]:L,[R.TOWARDS_ZERO]:e=>e>0?v(e):L(e),[R.AWAY_FROM_ZERO]:e=>e>0?L(e):v(e),[R.HALF_TOWARDS_ZERO]:e=>{const t=e>0;e=w(e,!t);return t?L(e):v(e)},[R.HALF_AWAY_FROM_ZERO]:e=>{const t=e>0;e=w(e,t);return t?v(e):L(e)},[R.HALF_FLOOR]:e=>L(w(e,false)),[R.HALF_CEILING]:e=>v(w(e,true))};l.RoundingMode=R;l.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,strictGroupingValidation:false,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:N.INTEGER,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:l.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};l.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:N.FLOAT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:l.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};l.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:N.PERCENT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:l.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};l.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:N.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:"standard",style:"standard",showNumber:true,customCurrencies:undefined,parseAsString:false,preserveDecimals:false,roundingMode:l.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};l.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,strictGroupingValidation:false,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:N.UNIT,showMeasure:true,style:"standard",showNumber:true,customUnits:undefined,allowedUnits:undefined,parseAsString:false,preserveDecimals:false,roundingMode:l.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};l.checkDecimalPadding=function(e,t=true,r=false){const i=e?.decimalPadding;if(!t&&i!==undefined){throw new Error("Unsupported format option: 'decimalPadding' cannot be used with an integer or percent"+" instance of sap.ui.core.format.NumberFormat")}if(r&&i&&e?.showMeasure!==false){throw new Error("The format option 'decimalPadding' can only be used if the format option"+" 'showMeasure' is set to false")}if(i<1){throw new Error("The format option 'decimalPadding' must have a value greater than 0")}if(i>0&&(e?.style==="short"||e?.style==="long")){throw new Error("The format option 'decimalPadding' can only be used if the format option"+" 'style' is not set to 'short' or 'long'")}};l.getInstance=function(e,t){return this.getFloatInstance(e,t)};l.getFloatInstance=function(e,t){l.checkDecimalPadding(e);const r=l.createInstance(e,t);const i=r.getLocaleFormatOptions(N.FLOAT);r.oFormatOptions=c({},this.oDefaultFloatFormat,i,r.oOriginalFormatOptions);return r};l.getIntegerInstance=function(e,t){l.checkDecimalPadding(e,false);const r=l.createInstance(e,t);const i=r.getLocaleFormatOptions(N.INTEGER);r.oFormatOptions=c({},l.oDefaultIntegerFormat,i,r.oOriginalFormatOptions);return r};l.getCurrencyInstance=function(e,t){l.checkDecimalPadding(e,true,true);const r=l.createInstance(e,t);const i=r.getLocaleFormatOptions(N.CURRENCY);r.oFormatOptions=c({},l.oDefaultCurrencyFormat,i,r.oOriginalFormatOptions);r.oFormatOptions.trailingCurrencyCode=r.showTrailingCurrencyCode();r._defineCustomCurrencySymbols();if(r.oFormatOptions.style==="long"){r.oFormatOptions.style="short"}return r};l.getUnitInstance=function(e,t){l.checkDecimalPadding(e,true,true);const r=l.createInstance(e,t);const i=r.getLocaleFormatOptions(N.UNIT);r.oFormatOptions=c({},l.oDefaultUnitFormat,i,r.oOriginalFormatOptions);return r};l.getPercentInstance=function(e,t){l.checkDecimalPadding(e,false);const r=l.createInstance(e,t);const i=r.getLocaleFormatOptions(N.PERCENT);r.oFormatOptions=c({},l.oDefaultPercentFormat,i,r.oOriginalFormatOptions);return r};l.createInstance=function(t,r){var a=Object.create(this.prototype),o;if(t instanceof i){r=t;t=undefined}if(!r){r=new i(e.getLanguageTag())}a.oLocale=r;a.oLocaleData=n.getInstance(r);a.oOriginalFormatOptions=t;if(t){if(t.pattern){o=this.parseNumberPattern(t.pattern);Object.keys(o).forEach(function(e){t[e]=o[e]})}if(t.emptyString!==undefined){u(t.emptyString===""||t.emptyString===0||t.emptyString===null||t.emptyString!==t.emptyString,"The format option 'emptyString' must be either '', 0, null, or NaN")}}return a};l.getDefaultUnitPattern=function(e){return"{0} "+e};l.prototype.getLocaleFormatOptions=function(e){const t=this.oLocaleData;let r;let i;switch(e){case N.PERCENT:r=t.getPercentPattern();break;case N.CURRENCY:i=this.oOriginalFormatOptions?.currencyContext||l.oDefaultCurrencyFormat.style;if(this.showTrailingCurrencyCode()){i="sap-"+i}r=t.getCurrencyPattern(i);break;default:r=t.getDecimalPattern()}const n=l.parseNumberPattern(r);n.plusSign=t.getNumberSymbol("plusSign");n.minusSign=t.getNumberSymbol("minusSign");n.decimalSeparator=t.getNumberSymbol("decimal");n.groupingSeparator=t.getNumberSymbol("group");n.percentSign=t.getNumberSymbol("percentSign");n.pattern=r;switch(e){case N.INTEGER:n.minFractionDigits=0;n.maxFractionDigits=0;n.groupingEnabled=false;break;case N.CURRENCY:n.minFractionDigits=undefined;n.maxFractionDigits=undefined;break;default:n.minFractionDigits=0;n.maxFractionDigits=99}return n};l.parseNumberPattern=function(e){var t=0,r=0,i=0,n=false,a=0,o=0,s=e.indexOf(";"),u={Integer:0,Fraction:1},c=u.Integer;if(s!==-1){e=e.substring(0,s)}for(var l=0;l<e.length;l++){var f=e[l];switch(f){case",":if(n){a=o;o=0}n=true;break;case".":c=u.Fraction;break;case"0":if(c===u.Integer){t++;if(n){o++}}else{r++;i++}break;case"#":if(c===u.Integer){if(n){o++}}else{i++}break}}if(!a){a=o;o=0}return{minIntegerDigits:t,minFractionDigits:r,maxFractionDigits:i,groupingEnabled:n,groupingSize:a,groupingBaseSize:o}};l.prototype._defineCustomCurrencySymbols=function(){var e=this.oFormatOptions;var t=this.oLocaleData.getCurrencySymbols();var r=function(e,t){var r=[];var i;for(var n in e){i=e[n];if(r.indexOf(i)===-1){r.push(i)}else if(i!==undefined){t[i]=true;s.error("Symbol '"+i+"' is defined multiple times in custom currencies.",undefined,"NumberFormat")}}};if(e.customCurrencies&&typeof e.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(e.customCurrencies).forEach(function(r){if(e.customCurrencies[r].symbol){this.mKnownCurrencySymbols[r]=e.customCurrencies[r].symbol}else{var i=e.customCurrencies[r].isoCode;if(i){this.mKnownCurrencySymbols[r]=t[i]}}this.mKnownCurrencyCodes[r]=r}.bind(this))}else{this.mKnownCurrencySymbols=t;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes()}this.mDuplicatedSymbols={};r(this.mKnownCurrencySymbols,this.mDuplicatedSymbols)};function E(e,t){if(e.indexOf(".")>=0&&e.endsWith("0")){var r=e.length-e.lastIndexOf(".")-1;var i=r-t;if(i>0){while(e.endsWith("0")&&i-- >0){e=e.substring(0,e.length-1)}if(e.endsWith(".")){e=e.substring(0,e.length-1)}}}return e}function _(e,t){var r=t.groupingSize,i=t.groupingBaseSize||r,n=e.length,a=Math.max(n-i,0)%r||r,o=e.slice(0,a);while(n-a>=i){o+=t.groupingSeparator;o+=e.slice(a,a+r);a+=r}o+=e.slice(a,n);return o}l.prototype.format=function(e,t){if(Array.isArray(e)){t=e[1];e=e[0]}var r="",i="",a="",o="",u="",c="",g=e<0,m=-1,p=Object.assign({},this.oFormatOptions),d=this.oOriginalFormatOptions,h=p.type===N.CURRENCY&&t==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",y,C,b,S,F,O=e===undefined||e===null;if(p.groupingEnabled&&p.groupingSize<=0){s.error("Grouping requires the 'groupingSize' format option to be a positive number, but it is '"+p.groupingSize+"' instead.");return""}if(p.showNumber&&(e===p.emptyString||isNaN(e)&&isNaN(p.emptyString))){return""}if(t!==undefined&&t!==null&&typeof t!=="string"&&!(t instanceof String)){return""}if(!p.showNumber&&!t){return""}if(O&&(!t||!p.showMeasure||p.showNumber)){return""}if(t&&p.customCurrencies&&!p.customCurrencies[t]){s.error("Currency '"+t+"' is unknown.");return""}if(!p.showNumber&&!p.showMeasure){return""}if(t&&p.type===N.UNIT){if(p.customUnits&&typeof p.customUnits==="object"){S=p.customUnits[t]}else{F=this.oLocaleData.getUnitFromMapping(t)||t;S=this.oLocaleData.getUnitFormat(F)}if(p.showMeasure){var R=!p.allowedUnits||p.allowedUnits.indexOf(t)>=0;if(!R){return""}}if(!S&&!p.showNumber){return this._addOriginInfo(t)}}if(p.type===N.UNIT){p.decimals=S&&(typeof S.decimals==="number"&&S.decimals>=0)?S.decimals:p.decimals;p.decimals=l.getMaximumDecimals(p);p.precision=S&&(typeof S.precision==="number"&&S.precision>=0)?S.precision:p.precision}let L;if(p.type===N.CURRENCY){L=this.getCurrencySymbolOrCode(t,p.currencyCode);if(t&&p.trailingCurrencyCode){if(!this.mKnownCurrencyCodes[t]&&!/(^[A-Z]{3}$)/.test(t)){p.trailingCurrencyCode=false}}if(!p.showNumber){return L}if(p.style==="long"||p.style==="short"){p.maxFractionDigits??=0}else{if(p.customCurrencies?.[t]?.decimals!==undefined){p.decimals=p.customCurrencies[t].decimals}else{p.decimals??=this.oLocaleData.getCurrencyDigits(t)}p.decimals=l.getMaximumDecimals(p)}}if(p.decimals!==undefined){p.minFractionDigits=p.decimals;p.maxFractionDigits=p.decimals}if(p.shortLimit===undefined||Math.abs(e)>=p.shortLimit){C=p.shortRefNumber===undefined?e:p.shortRefNumber;y=this.getShortenedFormat(C,p,h);if(y&&y.formatString!="0"){e=e/y.magnitude;if(p.shortDecimals!==undefined){p.minFractionDigits=p.shortDecimals;p.maxFractionDigits=p.shortDecimals}else{if(d.minFractionDigits===undefined&&d.maxFractionDigits===undefined&&d.decimals===undefined&&d.precision===undefined&&d.pattern===undefined){p.precision=2;p.minFractionDigits=0;p.maxFractionDigits=99}if(d.maxFractionDigits===undefined&&d.decimals===undefined){p.maxFractionDigits=99}}p.roundingMode=l.RoundingMode.HALF_AWAY_FROM_ZERO}}if((y||!p.ignorePrecision)&&p.precision!==undefined){p.maxFractionDigits=Math.min(p.maxFractionDigits,T(e,p.precision));p.minFractionDigits=Math.min(p.minFractionDigits,p.maxFractionDigits)}if(p.type==N.PERCENT){e=l._shiftDecimalPoint(e,2)}if((typeof e==="number"||typeof e==="string"&&typeof p.roundingMode!=="function")&&!p.preserveDecimals){e=M(e,p.maxFractionDigits,p.roundingMode)}if(e==0){g=false}if(!O){u=n.convertToDecimal(e)}if(u==="NaN"){return u}if(p.preserveDecimals){u=E(u,p.maxFractionDigits)}if(g){u=u.substr(1)}m=u.indexOf(".");if(m>-1){r=u.substr(0,m);i=u.substr(m+1)}else{r=u}if(r.length<p.minIntegerDigits){r=r.padStart(p.minIntegerDigits,"0")}else if(r.length>p.maxIntegerDigits){r="".padStart(p.maxIntegerDigits,"?")}if(i.length<p.minFractionDigits){i=i.padEnd(p.minFractionDigits,"0")}else if(i.length>p.maxFractionDigits&&!p.preserveDecimals){i=i.substr(0,p.maxFractionDigits)}if(p.type===N.UNIT&&!p.showNumber){if(S){b=this._getPluralCategory(r,i,y);c=S["unitPattern-count-"+b];if(!c){c=S["unitPattern-count-other"]}if(!c){return this._addOriginInfo(t)}if(b!=="other"&&c.indexOf("{0}")===-1){c=S["unitPattern-count-other"];if(!c){return this._addOriginInfo(t)}}if(c.indexOf("{0}")===-1){s.warning("Cannot separate the number from the unit because unitPattern-count-other '"+c+"' does not include the number placeholder '{0}' for unit '"+t+"'")}else{return this._addOriginInfo(c.replace("{0}","").trim())}}}if(p.groupingEnabled){a=_(r,p)}else{a=r}const v=p.decimalPadding||0;if(v){p.minusSign=p.minusSign.replace(D,"")}if(g){o=p.minusSign}o+=a;if(i){o+=p.decimalSeparator+i}const w=y&&y.formatString&&p.showScale;let I;if(w){b=this._getPluralCategory(r,i);I=this.getCompactPattern(p.type,p.style,y.key,b,p.trailingCurrencyCode,h,t&&p.showMeasure,L,g);if(p.type!==N.CURRENCY){o=I.replace(y.valueSubString,o)}}if(p.type===N.CURRENCY){c=w?I:this.getCurrencyPattern(p.currencyContext,p.trailingCurrencyCode,t&&p.showMeasure,L,g);o=l._composeCurrencyResult(c,o,L,p.minusSign,g)}if(p.type===N.PERCENT){c=p.pattern;o=c.replace(f,o);o=o.replace(/%/,p.percentSign)}if(p.showMeasure&&t&&p.type===N.UNIT){b=this._getPluralCategory(r,i,y);if(S){c=S["unitPattern-count-"+b];if(!c){c=S["unitPattern-count-other"]}if(!c){c=l.getDefaultUnitPattern(t)}}else{c=l.getDefaultUnitPattern(t)}o=c.replace("{0}",o)}let A=v-i.length;if(A>0){const e=o[o.length-1]===")";const t=" ";if(i){if(e){o+=t;A=A-1}}else if(!e){o+=t}o+=" ".repeat(A)}return this._addOriginInfo(o)};l.prototype.getCurrencySymbolOrCode=function(e,t){if(t){return e}return(typeof this.oFormatOptions.customCurrencies==="object"?this.mKnownCurrencySymbols[e]:this.oLocaleData.getCurrencySymbol(e))||e};l.prototype._getPluralCategory=function(e,t,r){var i=e;if(t){i+="."+t}if(r){i+="c"+r.magnitude.toExponential().slice(2)}return this.oLocaleData.getPluralCategory(i)};l.prototype._addOriginInfo=function(e){if(a.collectOriginInfo()){e=new String(e);e.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()}}return e};l._composeCurrencyResult=function(e,t,r,i,n){const a=e.split(";");if(a.length===2){e=a[n?1:0];if(n){t=t.slice(i.length)}}let o=e.replace("-",i).replace(f,t).replace("¤",r);if(n){o=o.replace(r+i,r+"\ufeff"+i)}return o};l.prototype.parse=function(e){var t=this.oFormatOptions,r=t.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),i=t.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),n=U(r+i),a=U(t.groupingSeparator),c=U(t.decimalSeparator),f="^\\s*(["+n+"]?(?:[0-9"+a+"]+|[0-9"+a+"]*"+c+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",m="^\\s*(["+n+"]?[0-9"+a+"]+)\\s*$",p=new RegExp(a,"g"),d=new RegExp(c,"g"),h=this.oLocaleData.getNumberSymbol("percentSign"),y=t.type===N.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",C,b,S,F,D=0,O,R;if(typeof e!=="string"&&!(e instanceof String)){return null}e=o.normalize(e).trim();if(e===""){const e=t.type===N.CURRENCY||t.type===N.UNIT;if(!t.showNumber&&!e){return null}R=t.emptyString;if(t.parseAsString&&(t.emptyString===0||isNaN(t.emptyString))){R=t.emptyString+""}if(e){if(!t.showNumber){return[undefined,R]}return[R,undefined]}else{return R}}if(t.groupingSeparator===t.decimalSeparator){s.error("The grouping and decimal separator both have the same value '"+t.groupingSeparator+"'. "+"They must be different from each other such that values can be parsed correctly.")}F=t.type===N.PERCENT?t.pattern:this.oLocaleData.getPercentPattern();if(F.charAt(0)==="%"){f=f.slice(0,1)+"%?"+f.slice(1)}else if(F.charAt(F.length-1)==="%"){f=f.slice(0,f.length-1)+"%?"+f.slice(f.length-1)}var L;if(t.type===N.UNIT&&t.showMeasure){var v;if(t.customUnits&&typeof t.customUnits==="object"){v=t.customUnits}else{v=this.oLocaleData.getUnitFormats()}u(v,"Unit patterns cannot be loaded");if(t.allowedUnits){var w={};for(var I=0;I<t.allowedUnits.length;I++){var E=t.allowedUnits[I];w[E]=v[E]}v=w}var _=W(v,e,t.showNumber,this.oLocaleData.sCLDRLocaleId);var M=false;L=_.cldrCode;if(L.length===1){S=L[0];if(!t.showNumber){return[undefined,S]}}else if(L.length===0){if(t.unitOptional){_.numberValue=e}else{return null}}else{u(L.length===1,"Ambiguous unit ["+L.join(", ")+"] for input: '"+e+"'");S=undefined;M=true}if(t.strictParsing){if(M){return null}}e=_.numberValue||e}var T;if(t.type===N.CURRENCY&&t.showMeasure){T=Y({value:e,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!t.customCurrencies});if(!T){return null}if(t.strictParsing){if(!T.currencyCode||T.duplicatedSymbolFound){return null}}e=T.numberValue;S=T.currencyCode;if(t.customCurrencies&&S===null){return null}if(!t.showNumber){if(e){return null}return[undefined,S]}}e=e.replace(g,"");O=A(e,this.oLocaleData,y);if(O){e=O.number}var z=P(e);if(t.isInteger&&!O&&!z){C=new RegExp(m)}else{C=new RegExp(f)}if(!C.test(e)){return t.type===N.CURRENCY||t.type===N.UNIT?null:NaN}var k=e.length;for(var G=0;G<k;G++){var Z=e[G];if(r.includes(Z)){e=e.replace(Z,"+");break}else if(i.includes(Z)){e=e.replace(Z,"-");break}}e=e.replace(/^\+/,"");if(!t.isInteger&&e.indexOf(h)!==-1){b=true;e=e.replace(h,"")}var $=e;e=e.replace(p,"");if(O){e=e.replace(d,".");e=l._shiftDecimalPoint(e,Math.round(Math.log(O.factor)/Math.LN10))}if(t.isInteger){var H;if(z){e=e.replace(d,".");H=x(e);if(H===undefined){return NaN}}else{H=parseInt(e)}D=t.parseAsString?e:H}else{e=e.replace(d,".");D=t.parseAsString?e:parseFloat(e);if(b){D=l._shiftDecimalPoint(D,-2)}}var V=this._checkGrouping($,t,z);if(!V){return t.type===N.CURRENCY||t.type===N.UNIT?null:NaN}if(t.parseAsString&&!b){D=l._shiftDecimalPoint(e,0)}if(t.type===N.CURRENCY||t.type===N.UNIT){return[D,S]}return D};l.prototype.getScale=function(){if(this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long"||this.oFormatOptions.shortRefNumber===undefined){return}var e=this.getShortenedFormat(this.oFormatOptions.shortRefNumber,this.oFormatOptions),t;if(e&&e.formatString){t=e.formatString.replace(y,"").replace(/'.'/g,".").trim();if(t){return t}}};l._shiftDecimalPoint=function(e,t,r){var i="";var n=e.toString().toLowerCase().split("e");if(typeof e==="number"){t=n[1]?+n[1]+t:t;return+(n[0]+"e"+t)}else if(typeof e==="string"){if(!r&&parseFloat(e)===0&&t>=0){return e.replace(h,"$1$2")}var a=n[0].charAt(0);i=a==="-"?a:"";if(i||a==="+"){n[0]=n[0].slice(1)}e=n[0];var o=e.indexOf("."),s,u,c;if(o===-1){e=e+".";o=e.length-1}if(n[1]){o+=+n[1]}s=o+t;if(s<=0){e=e.padStart(e.length-s+1,"0");s=1}else if(s>=e.length-1){e=e.padEnd(s+1,"0");s=e.length-1}e=e.replace(".","");u=e.substring(0,s);c=e.substring(s);u=u.replace(h,"$1$2");if(r){c=c.replace(S,"")}return i+u+(c?"."+c:"")}else{return null}};l.isAlphaNextToNumber=function(e,t,r){if(!e||!t){return false}const i=e.split(";");e=(i[r?1:0]||i[0]).replace(F,"");const n=d.exec(e);if(n[1]){return p.test(t)&&!n[2]}return!n[4]&&m.test(t)&&(!r||i.length!==1)};l.prototype.getCompactPattern=function(e,t,r,i,n,a,o,s,u){let c;if(e===N.CURRENCY){if(n){t="sap-short"}if(a){t+="-indian"}if(o){c=this.oLocaleData.getCompactCurrencyPattern(t,r,i);if(l.isAlphaNextToNumber(c,s,u)){c=this.oLocaleData.getCompactCurrencyPattern(t,r,i,"alphaNextToNumber")||c}}else{c=this.oLocaleData.getCompactCurrencyPattern(t,r,i,"noCurrency");if(!c){if(t.startsWith("sap-")){t=t.slice(4)}c=this.oLocaleData.getCompactDecimalPattern(t,r,i)}}}else{c=this.oLocaleData.getCompactDecimalPattern(t,r,i)}c=c?.replace(/'.'/g,".");return c};l.prototype.getCurrencyPattern=function(e,t,r,i,n){if(t){e="sap-"+e}let a=this.oLocaleData.getCurrencyPattern(e,r?undefined:"noCurrency");if(r&&l.isAlphaNextToNumber(a,i,n)){a=this.oLocaleData.getCurrencyPattern(e,"alphaNextToNumber")||a}return a};l.prototype.getShortenedFormat=function(e,t,r){var i,n,a,o=t.style,s=t.precision!==undefined?t.precision:2;if(o!="short"&&o!="long"){return undefined}for(var u=0;u<15;u++){n=Math.pow(10,u);if(M(Math.abs(e)/n,s-1)<10){break}}a=n.toString();const c=this.getCompactPattern(t.type,t.style,a,"other",t.trailingCurrencyCode,r,t.showMeasure);if(!c||c=="0"){return undefined}else{i={};i.key=a;i.formatString=c;var l=c.match(y);if(l){i.valueSubString=l[0];var f=i.valueSubString.indexOf(".");if(f==-1){i.decimals=0;i.magnitude=n*Math.pow(10,1-i.valueSubString.length)}else{i.decimals=i.valueSubString.length-f-1;i.magnitude=n*Math.pow(10,1-f)}}else{return undefined}}return i};function A(e,t,r){var i,n=1,a=10,s=t.getPluralCategories(),u,c={number:undefined,factor:n},l=function(r,a,s){u=t.getCompactDecimalPattern(s,a.toString(),r);if(u){u=o.normalize(u,true);u=u.replace(/'.'/g,".");var l=u.match(y);if(l){var f=l[0];var g=u.replace(f,"");if(!g){return}var m=e.indexOf(g);if(m>=0){i=e.replace(g,"");n=a;n*=Math.pow(10,1-f.length);if(c.number===undefined||i.length<c.number.length){c.number=i;c.factor=n}}}}};["long","short"].forEach(function(e){a=10;while(a<1e15){for(var t=0;t<s.length;t++){var r=s[t];l(r,a,e)}a=a*10}});if(r&&!i){a=10;while(a<1e15){for(var f=0;f<s.length;f++){var g=s[f];l(g,a,"short-indian")}a=a*10}}if(!i){return}return c}l.prototype.showTrailingCurrencyCode=function(){const t=this.oOriginalFormatOptions;if(t?.pattern||t?.currencyCode===false){return false}return t?.trailingCurrencyCode!==undefined?t.trailingCurrencyCode:e.getTrailingCurrencyCode()};l.prototype._checkGrouping=function(e,t,r){if(t.groupingSeparator&&e.includes(t.groupingSeparator)){e=e.replace(/^-/,"");e=e.replace(/^0+(\d)/,"$1");if(e.startsWith("0")||e.startsWith(t.groupingSeparator)){return false}if(r){e=e.replace(/[eE].*/,"")}var i=e.includes(t.decimalSeparator);if(t.decimalSeparator===t.groupingSeparator){i=false}else if(i){e=e.split(t.decimalSeparator)[0]}var n=e.split(t.groupingSeparator).length===2;if(n&&!i){var a=e.length-e.lastIndexOf(t.groupingSeparator);var o=t.groupingBaseSize||t.groupingSize;if(a!==o+t.groupingSeparator.length){return false}}if(t.strictGroupingValidation){if(!this._rGrouping){this._rGrouping=O(t.groupingSeparator,t.groupingSize,t.groupingBaseSize||t.groupingSize)}if(!this._rGrouping.test(e)){return false}}}return true};function P(e){return e.indexOf("e")>0||e.indexOf("E")>0}function x(e){var t=l._shiftDecimalPoint(e,0);if(t.indexOf(".")>0&&!C.test(t.split(".")[1])){return undefined}var r=parseFloat(t);var i=""+r;if(P(i)){i=l._shiftDecimalPoint(i,0)}var n=parseInt(i);if(n!==r){return undefined}return n}function M(e,t,r){r=r||l.RoundingMode.HALF_AWAY_FROM_ZERO;t=parseInt(t);var i=""+e;if(!P(i)){var n=i.indexOf(".");if(n<0){return e}if(i.substring(n+1).length<=t){if(typeof e==="string"){e=l._shiftDecimalPoint(e,0,true)}return e}}if(typeof r==="function"){e=r(e,t)}else{if(r.match(/^[a-z_]+$/)){r=r.toUpperCase()}e=l._shiftDecimalPoint(e,t,true);e=I[r](e);e=l._shiftDecimalPoint(e,-t,true);if(typeof e==="string"){e=e.replace(b,"$1")}}return e}function U(e){return e.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")}function T(e,t){var r=Math.floor(Math.log(Math.abs(e))/Math.LN10);return Math.max(0,t-r-1)}function W(e,t,r,i){var n,a,s,u,c,l,f,g,m,p,d,h={numberValue:undefined,cldrCode:[]},y=[],C=true,b=true,S=Number.POSITIVE_INFINITY,F=true,D=t.toLocaleLowerCase(i);for(m in e){for(a in e[m]){if(!a.startsWith("unitPattern")){continue}p=o.normalize(e[m][a]);u=p.indexOf("{0}");n=u>-1;if(n&&!r){p=p.replace("{0}","").trim();n=false}s=undefined;C=true;if(n){f=p.substring(0,u);g=f.toLocaleLowerCase(i);c=p.substring(u+"{0}".length);l=c.toLocaleLowerCase(i);if(t.startsWith(f)&&t.endsWith(c)){s=t.substring(f.length,t.length-c.length)}else if(D.startsWith(g)&&D.endsWith(l)){C=false;s=t.substring(g.length,D.length-l.length)}if(s){if(s.length<S){S=s.length;F=C;h.numberValue=s;h.cldrCode=[m]}else if(s.length===S&&h.cldrCode.indexOf(m)===-1){if(C&&!F){h.numberValue=s;h.cldrCode=[m];F=true}else if(C||!F){h.cldrCode.push(m)}}}}else{d=p.toLocaleLowerCase(i);if(p===t||d===D){if(r){if(a.endsWith("-zero")){s="0"}else if(a.endsWith("-one")){s="1"}else if(a.endsWith("-two")){s="2"}if(p===t){h.numberValue=s;h.cldrCode=[m];return h}else if(!h.cldrCode.includes(m)){b=false;h.numberValue=s;h.cldrCode.push(m)}}else if(h.cldrCode.indexOf(m)===-1){if(p===t){h.cldrCode.push(m)}else if(!y.includes(m)){y.push(m)}}}}}}if((!F||!b)&&h.cldrCode.length>1){h.numberValue=undefined}if(!r&&!h.cldrCode.length){h.cldrCode=y}return h}function z(e,r,i){var n,a,s,u,c,l,f,g,m=false,p=false,d="";for(a in r){s=r[a];if(!s){continue}s=o.normalize(s);if(e.indexOf(s)>=0&&d.length<=s.length){n=a;m=false;p=true;d=s;f=s}else if(i){l=t.getLanguageTag().toString();u=s.toLocaleUpperCase(l);c=e.toLocaleUpperCase(l).indexOf(u);if(c>=0){if(d.length===s.length&&!p){m=true}else if(d.length<s.length){g=e.substring(c,c+s.length);if(g.toLocaleUpperCase(l)===u){n=a;m=false;p=false;d=s;f=g}}}}}if(m||!n){return{}}return{code:n,recognizedCurrency:f,symbol:d}}function Y(e){var r,i=e.value;var n=z(i,e.currencySymbols);if(!n.code){n=z(i,e.customCurrencyCodes,true);if(!n.code&&!e.customCurrenciesAvailable){r=i.match(/(^[A-Z]{3}|[A-Z]{3}$)/i);n.code=r&&r[0].toLocaleUpperCase(t.getLanguageTag().toString());n.recognizedCurrency=r&&r[0]}}if(n.code){var a=n.recognizedCurrency.length-1;var o=n.recognizedCurrency.charAt(a);var u;var c=/[\-\s]+/;if(/\d$/.test(o)){if(i.startsWith(n.recognizedCurrency)){u=a+1;if(!c.test(i.charAt(u))){return undefined}}}else if(/^\d/.test(n.recognizedCurrency)){if(i.endsWith(n.recognizedCurrency)){u=i.indexOf(n.recognizedCurrency)-1;if(!c.test(i.charAt(u))){return undefined}}}i=i.replace(n.recognizedCurrency,"")}var l=false;if(e.duplicatedSymbols&&e.duplicatedSymbols[n.symbol]){n.code=undefined;l=true;s.error("The parsed currency symbol '"+n.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.")}return{numberValue:i,currencyCode:n.code||undefined,duplicatedSymbolFound:l}}return l});
//# sourceMappingURL=NumberFormat.js.map