/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./View","./ViewType","./XMLViewRenderer","sap/base/config","sap/base/future","sap/base/Log","sap/base/i18n/Localization","sap/base/strings/hash","sap/base/util/LoaderExtensions","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/RenderManager","sap/ui/core/XMLTemplateProcessor","sap/ui/core/cache/CacheManager","sap/ui/model/resource/ResourceModel","sap/ui/util/XMLHelper","sap/ui/VersionInfo","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery"],function(e,t,r,n,i,o,s,a,c,u,l,d,p,f,h,m,g,y,v,w,jQuery){"use strict";var C=f.RenderPrefixes,M="XMLViewCacheError",P={};var N=p.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:{apiVersion:2,render:function(e,t){e.text("")}}});var _=e.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:"sap.ui.core.mvc.XMLView",visibility:"hidden"},xmlNode:{type:"Element",visibility:"hidden"},cache:"Object",processingMode:{type:"sap.ui.core.mvc.XMLProcessingMode",visibility:"hidden"},requireContext:{type:"Object",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"},renderer:r});sap.ui.xmlview=function(e,r){return sap.ui.view(e,r,t.XML)};_.create=function(r){var n=u({},r);n.viewContent=n.definition;n.async=true;n.type=t.XML;return e.create(n)};_._sType=t.XML;_.asyncSupport=true;_._bUseCache=n.get({name:"sapUiXxViewCache",type:n.Type.Boolean,defaultValue:true,external:true})&&m._isSupportedEnvironment();function b(e){if(e.parseError.errorCode!==0){var t=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+t.url+" code: "+t.errorCode+" reason: "+t.reason+" src: "+t.srcText+" line: "+t.line+" linepos: "+t.linepos+" filepos: "+t.filepos)}}function x(e,t){if(!t){throw new Error("mSettings must be given")}else if(t.viewName&&t.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.")}else if((t.viewName||t.viewContent)&&t.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.")}else if(!(t.viewName||t.viewContent)&&!t.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.")}else if(t.cache&&!(t.cache.keys&&t.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.")}}function E(e,t){e.mProperties["viewContent"]=t.viewContent;var r=y.parse(t.viewContent);b(r);return r.documentElement}function V(e,t){if((e._resourceBundleName||e._resourceBundleUrl)&&(!t.models||!t.models[e._resourceBundleAlias])){var r=new g({bundleName:e._resourceBundleName,bundleUrl:e._resourceBundleUrl,bundleLocale:e._resourceBundleLocale,async:t.async});var n=r.getResourceBundle();if(n instanceof Promise){return n.then(function(){e.setModel(r,e._resourceBundleAlias)})}e.setModel(r,e._resourceBundleAlias)}}function L(e){e.oAfterRenderingNotifier=new N;e.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){e.onAfterRenderingBeforeChildren()}})}function R(e){var t=sap.ui.require("sap/ui/core/Component"),r;if(t){while(e){var n=t.getOwnerComponentFor(e);if(n){e=r=n}else{if(e instanceof t){r=e}e=e.getParent&&e.getParent()}}}return r}function A(e,t){var r=R(e),n=r?JSON.stringify(r.getManifest()):null,i=[];i=i.concat(X(e,r),S(),I(e),t.keys);return T(e,i).then(function(e){return{key:e+"("+a(n||"")+")",componentManifest:n,additionalData:t.additionalData}})}function D(e){return e}function T(e,t){return Promise.all(t).then(function(e){e=e.filter(function(e){return e!==P});if(e.every(D)){return e.join("_")}else{var t=new Error("Provided cache keys may not be empty or undefined.");t.name=M;return Promise.reject(t)}})}function X(e,t){var r=t&&t.getMetadata().getName();return[r||window.location.host+window.location.pathname,e.getId(),s.getLanguageTag().toString()].concat(t&&t.getActiveTerminologies()||[])}function I(e){var t=e.getPreprocessors(),r=e.getPreprocessorInfo(false),n=[];function i(e){n.push(e.preprocessor.then(function(e){if(e.getCacheKey){return e.getCacheKey(r)}else{return P}}))}for(var o in t){t[o].forEach(i)}return n}function S(){return v.load().then(function(e){var t="";if(!e.libraries){t=d.buildinfo.buildtime}else{e.libraries.forEach(function(e){t+=e.buildTimestamp})}return t}).catch(function(e){o.warning("version info could not be retrieved","sap.ui.core.mvc.XMLView");o.debug(e);return""})}function B(e,t){var r=e.key;delete e.key;var n=e.additionalData;e.xml=y.serialize(t);if(n&&n.setAdditionalCacheData&&n.getAdditionalCacheData){e.additionalData=n.getAdditionalCacheData()}return m.set(r,e)}function O(e){return m.get(e.key).then(function(t){if(t&&t.componentManifest==e.componentManifest){t.xml=y.parse(t.xml,"application/xml").documentElement;if(t.additionalData){var r=e.additionalData;if(r&&r.setAdditionalCacheData&&r.getAdditionalCacheData){r.setAdditionalCacheData(t.additionalData)}else{o.error("Deprecated: Don't use an object reference for caching additional Data! Use a CacheDataProvider instead!");u(e.additionalData,t.additionalData)}}return t}})}_.prototype.initViewSettings=function(t){var r=this,n;function i(n){r._xContent=n;if(e._supportInfo){e._supportInfo({context:r._xContent,env:{caller:"view",viewinfo:u({},r),settings:u({},t||{}),type:"xmlview"}})}if(!r.isSubView()){h.parseViewAttributes(n,r)}else{delete t.controller}const i=true;var o=V(r,t);if(o instanceof Promise){if(i){return o.then(function(){L(r)})}else{return o}}if(i){L(r)}}function s(e,t){if(r.hasPreprocessor("viewxml")){return h.enrichTemplateIdsPromise(e,r,t).then(function(){return r.runPreprocessor("viewxml",e,!t)})}return e}function a(e){var t=w.notifyAsyncStep("VIEW PREPROCESSING");return r.runPreprocessor("xml",e).then(function(e){return s(e,true)}).finally(t)}function l(e){return c.loadResource(e,{async:true}).then(function(e){return e.documentElement})}function d(e,t){return l(e).then(a).then(function(e){if(t){B(t,e)}return e})}function p(e,t){return A(r,t).then(function(t){return O(t).then(function(r){if(!r){return d(e,t)}else{return r.xml}})}).catch(function(t){if(t.name===M){o.error(t.message,t.name,"sap.ui.core.mvc.XMLView");o.error("Processing the View without caching.","sap.ui.core.mvc.XMLView");return d(e)}else{return Promise.reject(t)}})}this._oContainingView=t.containingView||this;this._sProcessingMode=t.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true}x(this,t);if(t.viewName){var f=t.viewName.replace(/\./g,"/")+".view.xml";if(t.async){if(t.cache&&_._bUseCache){return p(f,t.cache).then(i)}else{return l(f).then(a).then(i)}}else{n=c.loadResource(f).documentElement}}else if(t.viewContent){if(t.viewContent.nodeType===window.Node.DOCUMENT_NODE){n=t.viewContent.documentElement}else{n=E(this,t)}}else if(t.xmlNode){n=t.xmlNode}if(t.async){return a(n).then(i)}else{n=this.runPreprocessor("xml",n,true);n=s(n,false);if(n&&typeof n.getResult==="function"){if(n.isRejected()){throw n.getResult()}n=n.getResult()}i(n)}};_.prototype.onBeforeRendering=function(){var t=this.getDomRef();if(t&&!f.isPreservedContent(t)){f.preserveContent(t,true)}e.prototype.onBeforeRendering.apply(this,arguments)};_.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy()}e.prototype.exit.apply(this,arguments)};_.prototype.onControllerConnected=function(e,t){var r=this;function n(e){return l.runWithPreprocessors(e,{settings:r._fnSettingsPreprocessor})}if(!this.oAsyncState){this._aParsedContent=n(h.parseTemplate.bind(null,this._xContent,this,t))}else{var i=w.notifyAsyncStep("VIEW PROCESSING");return h.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:n}).then(function(e){r._aParsedContent=e;delete r.oAsyncState.suppressPreserve}).finally(i)}};_.prototype.getControllerName=function(){if(this._controllerModuleName){o.error(`Controller name is specified using module syntax: '${this._controllerModule}'. Use #getControllerModuleName() instead.`);return undefined}return this._controllerName};_.prototype._getControllerName=function(){return this._controllerName};_.prototype.getControllerModuleName=function(){if(typeof this._controllerName==="string"){return this._controllerName.replace(/\./g,"/")+".controller"}return typeof this._controllerModuleName==="string"?this._controllerModuleName.substring("module:".length):""};_.prototype._getControllerModuleName=function(){return this._controllerModuleName};_.prototype.isSubView=function(){return this._oContainingView!=this};_.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var t=0;t<e.length;t++){var r=document.getElementById(C.Temporary+e[t].getId())||e[t].getDomRef()||document.getElementById(C.Invisible+e[t].getId());if(r){jQuery(document.getElementById(C.Dummy+e[t].getId())).replaceWith(r)}}}jQuery(document.getElementById(C.Temporary+this.getId())).replaceWith(this._$oldContent)}this._$oldContent=undefined};_.prototype._onChildRerenderedEmpty=function(e,t){jQuery(t).replaceWith('<div id="'+C.Dummy+e.getId()+'" class="sapUiHidden"></div>');return true};_.registerPreprocessor=function(t,r,n,o,s,a){var c=this.getMetadata().getClass()._sType;if(typeof n==="string"){if(n!==c){throw new TypeError("View types other than "+c+" are not supported by XMLView.registerPreprocessor,"+" check View.registerPreprocessor instead")}}else{a=s;s=o;o=n}t=t.toUpperCase();if(_.PreprocessorType[t]){e.registerPreprocessor(_.PreprocessorType[t],r,c,o,s,a)}else{i.errorThrows(`${this.getMetadata().getName()}: Preprocessor could not be registered due to unknown sType "${t}"`)}};_.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};_.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return _});
//# sourceMappingURL=XMLView.js.map