/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/EventBus","sap/ui/core/Lib","sap/base/util/isPlainObject","sap/base/Log"],function(e,t,i,n){"use strict";var r;var s="______UI5______";var o=e.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(r){return r}r=this;e.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener("message",this._receiver)}});o.event={CONNECT:"______CONNECT______",READY:"______READY______",ACCEPTED:"______ACCEPTED______",DECLINED:"______DECLINED______"};o.prototype.destroy=function(){window.removeEventListener("message",this._receiver);this._aEventQueue=[];e.prototype.destroy.apply(this,arguments);r=undefined;this.bIsDestroyed=true};o.getInstance=function(){if(!r){r=new o}return r};o.prototype.publish=function(e){var t=e.target;var i=e.origin;var n=e.channelId;var r=e.eventId;var a=e.data;if(r===o.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener}else if(window.parent!==window){t=window.parent}else{return}}if(!i){i="*"}}if(typeof window==="undefined"||!(t!=null&&t===t.window)||t===window){throw TypeError("Target must be a window object and has to differ from current window")}if(typeof i!=="string"){throw TypeError("Origin must be a string")}if(typeof n!=="string"){throw TypeError("ChannelId must be a string")}if(typeof r!=="string"){throw TypeError("EventId must be a string")}if(![o.event.READY,o.event.ACCEPTED,o.event.DECLINED].includes(r)&&i!=="*"&&!this._aAcceptedOrigins.includes(i)){this._aAcceptedOrigins.push(i)}var c={origin:i,channelId:n,eventId:r,data:a};c[s]=true;t.postMessage(c,i)};o.prototype._callListener=function(e,t,i,n,r){e.call(t,r)};o.prototype._getText=function(e,i){var n=t.getResourceBundleFor("sap.ui.core");return Promise.resolve(n.getText(e,i))};o.prototype._receiver=function(e){var t=e.data;if(!i(t)||!t.hasOwnProperty(s)){return}if(this._oPendingProcess){this._aEventQueue.push(e)}else{this._oPendingProcess=this._processEvent(e)}};o.prototype._processEvent=function(e){return new Promise(function(t,i){var n=e.data;var r=e.origin;if(this._aDeclinedOrigins.includes(r)){t();return}switch(n.eventId){case o.event.CONNECT:{if(typeof n.data!=="string"){this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:o.event.DECLINED});t()}else if(this._aAcceptedOrigins.includes(r)){this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:o.event.ACCEPTED});t()}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(i){this._getText("PostMessage.Message",[n.data,r]).then(function(e){return i(e)}).then(function(){this.addAcceptedOrigin(r);this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:o.event.ACCEPTED})}.bind(this),function(){this.addDeclinedOrigin(r);this.publish({target:e.source,origin:e.origin,channelId:n.channelId,eventId:o.event.DECLINED})}.bind(this)).then(t)}.bind(this),i)}break}case o.event.ACCEPTED:case o.event.DECLINED:case o.event.READY:{e.data.data=undefined;this._emitMessage(e);t();break}default:{if(this._aAcceptedOrigins.includes(r)){this._emitMessage(e)}t()}}}.bind(this)).catch(function(e){var t;var i;if(typeof e==="string"){t=e}else if(e instanceof Error){t=e.message;i=e.stack}else{t="Some unexpected error happened during post message processing"}n.error(t,i,"sap.ui.core.postmessage.Bus")}).then(function(){this._oPendingProcess=this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null}.bind(this))};o.prototype._emitMessage=function(t){var i=t.data.channelId;var n=t.data.eventId;e.prototype.publish.call(this,i,n,{originalEvent:t,channelId:i,eventId:n,source:t.source,origin:t.origin,data:t.data.data})};o.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice()};o.prototype.setAcceptedOrigins=function(e){if(!Array.isArray(e)){throw new TypeError("Expected an array, but got "+typeof e)}this._aAcceptedOrigins=e.slice()};o.prototype.addAcceptedOrigin=function(e){if(typeof e!=="string"){throw new TypeError("Expected a string, but got "+typeof e)}if(!this._aAcceptedOrigins.includes(e)){this._aAcceptedOrigins.push(e)}};o.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([])};o.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice()};o.prototype.setDeclinedOrigins=function(e){if(!Array.isArray(e)){throw new TypeError("Expected an array, but got "+typeof e)}this._aDeclinedOrigins=e.slice()};o.prototype.addDeclinedOrigin=function(e){if(typeof e!=="string"){throw new TypeError("Expected a string, but got "+typeof e)}if(!this._aDeclinedOrigins.includes(e)){this._aDeclinedOrigins.push(e)}};o.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([])};return o});
//# sourceMappingURL=Bus.js.map