/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","./HashChanger","sap/base/future","sap/base/Log"],function(t,i,s,e){"use strict";var a=t.routing.HistoryDirection;var r="Direction_Unchanged";var n=function(t){var i=this;this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;function a(t){if(n._bUsePushState&&!n.getInstance()){var s=window.history.state===null?{}:window.history.state;if(typeof s==="object"){s.sap=s.sap?s.sap:{};if(s.sap.history&&Array.isArray(s.sap.history)&&s.sap.history[s.sap.history.length-1]===t){n._aStateHistory=s.sap.history}else{n._aStateHistory.push(t);s.sap.history=n._aStateHistory;window.history.replaceState(s,window.document.title)}}else{e.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History")}}i._reset()}if(!t){s.errorThrows("sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter")}this._setHashChanger(t);if(t._initialized){a(t.getHash())}else{t.attachEventOnce("hashChanged",function(t){a(t.getParameter("newHash"))})}};n._aStateHistory=[];n._bUsePushState=window.self===window.top;n.prototype.getHistoryStateOffset=function(){if(!n._bUsePushState){return undefined}var t=window.history.state?.sap?.history;if(!Array.isArray(t)){return undefined}return t.length-n._aStateHistory.length};n.prototype.destroy=function(){this._unRegisterHashChanger()};n.prototype.getDirection=function(t){if(t!==undefined&&this._bIsInitial){return undefined}if(t===undefined){return this._sCurrentDirection}return this._getDirection(t)};n.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1]};n.prototype._setHashChanger=function(t){if(this._oHashChanger){this._unRegisterHashChanger()}this._oHashChanger=t;this._mEventListeners={};t.getRelevantEventsInfo().forEach(function(t){var i=t.name,s=t.paramMapping||{},e=this._onHashChange.bind(this,s);this._mEventListeners[i]=e;this._oHashChanger.attachEvent(i,e,this)}.bind(this));this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this)};n.prototype._unRegisterHashChanger=function(){if(this._mEventListeners){var t=Object.keys(this._mEventListeners);t.forEach(function(t){this._oHashChanger.detachEvent(t,this._mEventListeners[t],this)}.bind(this));delete this._mEventListeners}this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null};n.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash()};n.prototype._getDirection=function(t,i,s){if(s&&this._oNextHash&&this._oNextHash.sHash===t){return a.NewEntry}if(i){return a.NewEntry}if(this._bUnknown){return a.Unknown}if(this.aHistory[this.iHistoryPosition+1]===t&&this.aHistory[this.iHistoryPosition-1]===t){return a.Unknown}if(this.aHistory[this.iHistoryPosition-1]===t){return a.Backwards}if(this.aHistory[this.iHistoryPosition+1]===t){return a.Forwards}return a.Unknown};n.prototype._getDirectionWithState=function(t){var i=window.history.state===null?{}:window.history.state,s,o;if(typeof i==="object"){if(i.sap===undefined){n._aStateHistory.push(t);i.sap={};i.sap.history=n._aStateHistory;window.history.replaceState(i,document.title);o=a.NewEntry}else{s=i.sap.history.every(function(t,i){return t===n._aStateHistory[i]});if(s&&i.sap.history.length===n._aStateHistory.length){o=r}else{o=s?a.Backwards:a.Forwards;n._aStateHistory=i.sap.history}}}else{e.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History")}return o};n.prototype._onHashChange=function(t,i){var s=t.newHash||"newHash",e=t.oldHash||"oldHash",a=t.fullHash||"fullHash";this._hashChange(i.getParameter(s),i.getParameter(e),i.getParameter(a))};n.prototype._hashChange=function(t,i,s){var e=window.history.length,o;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===t){if(this._oNextHash.sDirection){o=this._oNextHash.sDirection}else{this.aHistory[this.iHistoryPosition]=t;if(s!==undefined&&n._bUsePushState&&this===n.getInstance()){n._aStateHistory[n._aStateHistory.length-1]=s;window.history.replaceState({sap:{history:n._aStateHistory}},window.document.title)}this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown}return}}this._bIsInitial=false;if(o){this._adaptToDirection(o,{oldHash:i,newHash:t,fullHash:s})}else{if(!o&&s!==undefined&&n._bUsePushState&&this===n.getInstance()){o=this._getDirectionWithState(s)}if(o===r){return}if(!o){o=this._getDirection(t,this._iHistoryLength<window.history.length,true)}this._bUnknown=false;switch(o){case a.Unknown:this._reset();break;case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,t);this.iHistoryPosition++;break;case a.Forwards:this.iHistoryPosition++;break;case a.Backwards:this.iHistoryPosition--;break;default:break}}this._sCurrentDirection=o;this._iHistoryLength=e;if(this._oNextHash){this._oNextHash=null}};n.prototype._adaptToDirection=function(t,i){var s=i.fullHash,r=i.newHash,o,h;if(n._bUsePushState&&this===n.getInstance()&&s!==undefined){switch(t){case a.NewEntry:case a.Forwards:n._aStateHistory.push(s);break;case a.Backwards:o=n._aStateHistory.lastIndexOf(s);if(o!==-1){n._aStateHistory.splice(o+1)}else{n._aStateHistory=[s];e.debug("Can't find "+s+" in "+JSON.stringify(n._aStateHistory))}break;case a.Unknown:n._aStateHistory[n._aStateHistory.length-1]=s;break;default:break}h={};h.sap={};h.sap.history=n._aStateHistory;window.history.replaceState(h,document.title)}switch(t){case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,r);this.iHistoryPosition+=1;break;case a.Forwards:o=this.aHistory.indexOf(r,this.iHistoryPosition+1);if(o!==-1){this.iHistoryPosition=o}else{this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,r);this.iHistoryPosition++}break;case a.Backwards:o=this.aHistory.lastIndexOf(r,this.iHistoryPosition-1);if(o!==-1){this.iHistoryPosition=o}else{this.aHistory=[r];this.iHistoryPosition=0}break;case a.Unknown:this.aHistory[this.iHistoryPosition]=r;break;default:break}};n.prototype._hashSet=function(t){var i=t.getParameter("hash");if(i===undefined){i=t.getParameter("sHash")}this._hashChangedByApp(i,false)};n.prototype._hashReplaced=function(t){var i=t.getParameter("hash"),s=t.getParameter("direction");if(i===undefined){i=t.getParameter("sHash")}if(i===this._oHashChanger.getHash()&&s){this._sCurrentDirection=s}this._hashChangedByApp(i,true,s)};n.prototype._hashChangedByApp=function(t,i,s){this._oNextHash={sHash:t,bWasReplaced:i,sDirection:s}};var o;n.getInstance=function(){return o};o=new n(i.getInstance());return n},true);
//# sourceMappingURL=History.js.map