/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/EventProvider","./Target","./async/Targets","./sync/Targets","sap/base/future","sap/base/Log","sap/base/util/deepExtend"],function(t,e,i,n,a,r,s){"use strict";var o=t.extend("sap.ui.core.routing.Targets",{constructor:function(e){t.apply(this);this._mTargets={};this._oLastTitleTarget={};this._oConfig=e.config;this._oCache=e.cache||e.views;if(!this._oConfig){this._oConfig={_async:false}}function a(){if(new URLSearchParams(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){r.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Targets");return true}return false}if(this._oConfig._async===undefined){this._oConfig._async=this._oConfig.async===undefined?a():this._oConfig.async}var s=this._oConfig._async?i:n;for(var o in s){this[o]=s[o]}Object.keys(e.targets).forEach(function(t){this._createTarget(t,e.targets[t])}.bind(this));Object.keys(this._mTargets).forEach(function(t){this._addParentTo(this._mTargets[t])}.bind(this))},_setRouter:function(t){if(!this._oRouter){this._oRouter=t}else{r.warning("The Targets is already connected with a router and this call of _setRouter is ignored")}return this},destroy:function(){var e;t.prototype.destroy.apply(this);for(e in this._mTargets){if(this._mTargets.hasOwnProperty(e)){this._mTargets[e].destroy()}}this._mTargets=null;this._oCache=null;this._oConfig=null;this.bIsDestroyed=true;return this},getViews:function(){return this._oCache},getCache:function(){return this._oCache},getTarget:function(t,e){var i=this,n=this._alignTargetsInfo(t),a;a=n.reduce(function(t,n){var a=i._mTargets[n.name];if(a){t.push(a)}else if(!e){r.error('The target you tried to get "'+n.name+'" does not exist!',i)}return t},[]);return a.length<=1?a[0]:a},addTarget:function(t,e){var i=this.getTarget(t,true),n;if(i){a.errorThrows(`${this}: Target with name "${t}" already exists`)}else{n=this._createTarget(t,e);this._addParentTo(n)}return this},suspend:function(t){var e=this._alignTargetsInfo(t);e.forEach(function(t){var e=t.name;var i=this.getTarget(e);if(i){i.suspend()}}.bind(this));return this},resume:function(t){var e=this._alignTargetsInfo(t);e.forEach(function(t){var e=t.name;var i=this.getTarget(e);if(i){i.resume()}}.bind(this));return this},attachDisplay:function(t,e,i){return this.attachEvent(this.M_EVENTS.DISPLAY,t,e,i)},detachDisplay:function(t,e){return this.detachEvent(this.M_EVENTS.DISPLAY,t,e)},fireDisplay:function(t){return this.fireEvent(this.M_EVENTS.DISPLAY,t)},attachTitleChanged:function(t,e,i){this.attachEvent(this.M_EVENTS.TITLE_CHANGED,t,e,i);return this},detachTitleChanged:function(t,e){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,t,e)},fireTitleChanged:function(t){if(this._oLastTitleTarget.name!==t.name||this._oLastTitleTarget.title!==t.title){this._oLastTitleTarget.name=t.name;this._oLastTitleTarget.title=t.title;this.fireEvent(this.M_EVENTS.TITLE_CHANGED,t)}return this},M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"},_alignTargetsInfo:function(t){if(t===undefined){return[]}if(!Array.isArray(t)){return typeof t==="object"?[t]:[{name:t}]}return t.map(function(t){if(typeof t!=="object"){t={name:t}}return t})},_createTarget:function(t,e){var i,n,a={_name:t};if(this._vRootViewId){a.rootView=this._vRootViewId}n=s(a,this._oConfig,e);this._validateOptions(n);i=this._constructTarget(n);i.attachDisplay(function(e){var i=e.getParameters();this.fireDisplay({name:t,view:i.view,object:i.object,control:i.control,config:i.config,data:i.data,routeRelevant:i.routeRelevant})},this);this._mTargets[t]=i;return i},_getDeprecatedOptions:function(){return{viewPath:"path",viewName:"name",viewId:"id"}},_validateOptions:function(t){const e=this._oConfig?.router?._oOwner?.getManifestObject();if(e?._getSchemaVersion()===2){const i=this._getDeprecatedOptions();const n=e.getComponentName();Object.keys(i).forEach(e=>{if(Object.hasOwn(t,e)){throw new Error(`sap.ui5/routing/targets/${e} is deprecated and not supported with manifest version 2. Use the option '${i[e]}' instead (component '${n}').`)}})}},_addParentTo:function(t){var e,i=t._oOptions.parent;if(!i){return}e=this._mTargets[i];if(!e){a.errorThrows(`${this}: The target "${t._oOptions._name}" has a parent "${i}" defined, but it was not found in the other targets`);return}t._oParent=e},_constructTarget:function(t,i){return new e(t,this._oCache,i)},_setRootViewId:function(t){var e,i;for(e in this._mTargets){if(this._mTargets.hasOwnProperty(e)){i=this._mTargets[e]._oOptions;if(i.rootView===undefined){i.rootView=t}}}this._vRootViewId=t},_getTitleTargetName:function(t,e){var i,n;if(e){t=[e]}t=this._alignTargetsInfo(t);t.some(function(t){i=this.getTarget(t);while(i&&!i._oOptions.title){i=i._oParent}if(i){n=i._oOptions._name;return true}}.bind(this));return n},_forwardTitleChanged:function(t){this.fireTitleChanged({name:t.getParameter("name"),title:t.getParameter("title")})},_attachTitleChanged:function(t,e){var i,n;n=this._getTitleTargetName(t,e);if(n){i=this.getTarget(n)}if(this._oLastDisplayedTitleTarget){this._oLastDisplayedTitleTarget.detachTitleChanged(this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget._bIsDisplayed=false}if(i){i.attachTitleChanged({name:i._oOptions._name},this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget=i}else if(e){a.errorThrows(`${this}: The target with the name "${e}" where the titleChanged event should be fired does not exist!`)}}});return o});
//# sourceMappingURL=Targets.js.map