/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/core/Element","sap/ui/core/ElementMetadata","../Plugin","sap/base/util/LoaderExtensions"],function(e,t,a,i,n){"use strict";function r(e){return sap.ui.require(e.replace(/\./g,"/"))}var o=i.extend("sap.ui.core.support.plugins.Breakpoint",{constructor:function(e){i.apply(this,["sapUiSupportBreakpoint","",e]);this._methodType={clazz:1,proto:2};this._mBreakpointData={classes:{},instances:{}};this._idPrefix="id_";this._methodPrefix="method_";this._classPrefix="class_";this._bAlertNoDebugger=false;this._aEventIds=[this.getId()+"RequestInstanceMethods",this.getId()+"ChangeInstanceBreakpoint",this.getId()+"RequestClasses",this.getId()+"RequestClassMethods",this.getId()+"ChangeClassBreakpoint",this.getId()+"RemoveAllClassBreakpoints"]}});o.prototype.isToolPlugin=function(){return false};o.prototype.isAppPlugin=function(){return true};o.prototype.init=function(e){i.prototype.init.apply(this,arguments);window.bp=this;this.requestClasses("sapUiSupportDebuggingReceiveClasses")};o.prototype.onsapUiSupportBreakpointRequestInstanceMethods=function(e){var t=e.getParameter("callback"),a=e.getParameter("controlId");var i=this.getInstanceMethods(a);this._oStub.sendEvent(t,{methods:JSON.stringify(i),breakpointCount:JSON.stringify({active:i.filter(function(e,t){return e.active}).length,all:i.length}),controlId:a})};o.prototype.onsapUiSupportBreakpointChangeInstanceBreakpoint=function(e){var t={controlId:e.getParameter("controlId"),methodName:e.getParameter("methodName"),active:e.getParameter("active")},a=e.getParameter("callback");this.changeInstanceBreakpoint(t.controlId,t.methodName,t.active);var i=this.getInstanceMethods(t.controlId);t.breakpointCount=JSON.stringify({active:i.filter(function(e){return e.active}).length,all:i.length});t.methods=JSON.stringify(i);this._oStub.sendEvent(a,t)};o.prototype.requestClasses=function(e){this._oStub.sendEvent(e,{classes:JSON.stringify(this.getClasses())})};o.prototype.onsapUiSupportBreakpointRequestClasses=function(e){this.requestClasses(e.getParameter("callback"))};o.prototype.onsapUiSupportBreakpointRequestClassMethods=function(e){var t=e.getParameter("callback"),a=e.getParameter("className");var i=this.getClassMethods(a);this._oStub.sendEvent(t,{methods:JSON.stringify(i),breakpointCount:JSON.stringify({active:i.filter(function(e,t){return e.active}).length,all:i.length}),className:a})};o.prototype.onsapUiSupportBreakpointChangeClassBreakpoint=function(e){var t={className:e.getParameter("className"),methodName:e.getParameter("methodName"),active:e.getParameter("active"),type:e.getParameter("type")},a=e.getParameter("callback");this.changeClassBreakpoint(t.className,t.methodName,t.active,t.type);var i=this.getClassMethods(t.className);t.breakpointCount=JSON.stringify({active:i.filter(function(e,t){return e.active}).length,all:i.length});t.methods=JSON.stringify(i);this._oStub.sendEvent(a,t)};o.prototype.onsapUiSupportBreakpointRemoveAllClassBreakpoints=function(e){var t=e.getParameter("className");var a=this._mBreakpointData.classes[this._classPrefix+t];for(var i in a){this.changeClassBreakpoint(t,i.replace(this._methodPrefix,""),false)}};o.prototype.getInstanceMethods=function(e){var a=t.getElementById(e),i=[];if(!a){return i}for(var n in a){if(typeof a[n]!=="function"){continue}i.push({name:n,active:this.isInstanceBreakpointActive(a,n)})}return i.sort(function(e,t){if(e.name<t.name){return-1}else if(e.name>t.name){return 1}else{return 0}})};o.prototype.getClassMethods=function(e){var t=r(e);var a=[],i;if(!t){return a}for(i in t){if(typeof t[i]!=="function"){continue}a.push({name:i,type:this._methodType.clazz,active:this.isClassBreakpointActive(e,i)})}function n(e){return a.some(function(t){return t.name===e})}for(i in t.prototype){if(typeof t.prototype[i]!=="function"){continue}if(n(i)){continue}a.push({name:i,type:this._methodType.proto,active:this.isClassBreakpointActive(e,i)})}return a.sort(function(e,t){if(e.name<t.name){return-1}else if(e.name>t.name){return 1}else{return 0}})};o.prototype.getClasses=function(){function e(){var e=[];var t=n.getAllRequiredModules();for(var i=0;i<t.length;i++){if(e.indexOf(t[i])>-1){continue}var o=r(t[i]);if(typeof o==="undefined"||o===null){continue}if(typeof o.getMetadata==="function"&&o.getMetadata()instanceof a){e.push(o.getMetadata().getName())}}return e}return e().sort()};o.prototype.changeInstanceBreakpoint=function(e,a,i){var n=t.getElementById(e);if(!n||!a||!n[a]){return}if(this.isInstanceBreakpointActive(n,a)===i){return}if(i){this.applyInstanceMethodHook(e,n,a)}else{this.removeInstanceMethodHook(e,n,a)}};o.prototype.changeClassBreakpoint=function(e,t,a,i){var n=r(e);if(!n||!t){return}if(this.isClassBreakpointActive(e,t)===a){return}if(a){this.applyClassMethodHook(e,n,t,i)}else{this.removeClassMethodHook(e,n,t)}};o.prototype.getInstanceBreakpointData=function(e,t){if(typeof t==="undefined"){t=false}var a=this._mBreakpointData.instances[this._classPrefix+e.getMetadata().getName()];if(!a){if(t){this._mBreakpointData.instances[this._classPrefix+e.getMetadata().getName()]=a={}}else{return null}}var i=a[this._idPrefix+e.getId()];if(!i){if(t){a[this._idPrefix+e.getId()]=i={}}else{return null}}return i};o.prototype.getClassBreakpointData=function(e,t){if(typeof t==="undefined"){t=false}var a=this._mBreakpointData.classes[this._classPrefix+e];if(!a){if(t){this._mBreakpointData.classes[this._classPrefix+e]=a={}}else{return null}}return a};o.prototype.isInstanceBreakpointActive=function(e,t){var a=this.getInstanceBreakpointData(e);if(!a){return false}var i=a[this._methodPrefix+t];if(!i){return false}return i.active};o.prototype.isClassBreakpointActive=function(e,t){var a=this.getClassBreakpointData(e);if(!a){return false}var i=a[this._methodPrefix+t];if(!i){return false}return i.active};o.prototype.applyInstanceMethodHook=function(e,t,a){var i=this.getInstanceBreakpointData(t,true),n=i[this._methodPrefix+a]||(i[this._methodPrefix+a]={});n.originalMethod=t[a];n.active=true;t[a]=this.methodHook(n.originalMethod)};o.prototype.removeInstanceMethodHook=function(e,t,a){var i=this.getInstanceBreakpointData(t,true),n=i[this._methodPrefix+a];t[a]=n.originalMethod;delete n.originalMethod;n.active=false};o.prototype.applyClassMethodHook=function(e,t,a,i){var n=this.getClassBreakpointData(e,true),r=n[this._methodPrefix+a]||(n[this._methodPrefix+a]={});if(i===this._methodType.clazz){r.originalMethod=t[a];t[a]=this.methodHook(r.originalMethod)}else{r.originalMethod=t.prototype[a];t.prototype[a]=this.methodHook(r.originalMethod)}r.type=i;r.active=true};o.prototype.removeClassMethodHook=function(e,t,a){var i=this.getClassBreakpointData(e,true),n=i[this._methodPrefix+a];if(n.type===this._methodType.clazz){t[a]=n.originalMethod}else{t.prototype[a]=n.originalMethod}delete n.originalMethod;n.active=false};o.prototype.methodHook=function(e){var t=this;return function(){var a=Date.now();debugger;if(Date.now()-a<50){t._alertNoDebugger()}return e.apply(this,arguments)}};o.prototype._alertNoDebugger=function(){if(this._bAlertNoDebugger){return}var t=null;if(e.browser.chrome){t="Please open your debugger by pressing CTRL + SHIFT + I."}if(t==null){t="Please open your debugger."}this._bAlertNoDebugger=true;alert("There is no debugger attached.\n\n"+t)};return o});
//# sourceMappingURL=Breakpoint.js.map