/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/RenderManager","sap/ui/core/support/Plugin","sap/base/security/encodeXML","sap/base/util/each","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/selectText"],function(t,e,s,o,a,jQuery){"use strict";var n=e.extend("sap.ui.core.support.plugins.Debugging",{constructor:function(t){e.apply(this,["sapUiSupportDebugging","Debugging",t]);this._aEventIds=[this.getId()+"ReceiveClasses",this.getId()+"ReceiveClassMethods",this.getId()+"SaveUrlIfNew",this.getId()+"AppendUserUrls"];this._breakpointId="sapUiSupportBreakpoint";this._localStorageId="sapUiSupportLocalStorage";this._techInfoId="sapUiSupportTechInfo";this._aClasses=[];this._mAddedClasses={};this._sSelectedClass="";this._mRebootUrls={}}});n.prototype.isToolPlugin=function(){return true};n.prototype.isAppPlugin=function(){return false};n.prototype.init=function(t){e.prototype.init.apply(this,arguments);this.renderContainer();this._populateRebootUrls();this._oStub.sendEvent(this._breakpointId+"RequestClasses",{callback:this.getId()+"ReceiveClasses"})};n.prototype.exit=function(t){e.prototype.exit.apply(this,arguments)};n.prototype.renderContainer=function(){var e=(new t).getInterface();e.openStart("div",this.getId()+"-RebootContainer").class("sapUiSupportContainer").openEnd();e.openStart("div").class("sapUISupportLabel").class("sapUISupportLabelBold").openEnd().text("Note: Designed to work with apps loaded with the standard UI5 loading bootstrap script tag:").close("div");e.openStart("div").class("sapUISupportLabel").class("sapUISupportLabelBold").openEnd().text("<"+'script id="sap-ui-bootstrap" src="somepath/resources/sap-ui-core.js" ...');e.voidStart("br").voidEnd();e.voidStart("br").voidEnd();e.close("div");e.openStart("div").class("sapUISupportLabel").openEnd().text("Boot application with different UI5 version on next reload:").close("div");e.openStart("select",this.getId()+"-RebootSelect").class("sapUiSupportSelect").openEnd();e.openStart("option").attr("value","none").openEnd().text("Disabled (no custom reboot URL)").close("option");e.openStart("option",this.getId()+"-RebootOther").attr("value","other").openEnd().text("Other (enter URL to sap-ui-core.js below)...:").close("option");e.close("select");e.voidStart("input",this.getId()+"-RebootInput").attr("type","text").attr("disabled","disabled").voidEnd();e.openStart("button",this.getId()+"-Reboot").class("sapUiSupportRoundedButton").openEnd().text("Activate Reboot URL").close("button");e.close("div");e.openStart("div",this.getId()+"-ClassContainer").class("sapUiSupportContainer").openEnd().close("div");e.openStart("div",this.getId()+"-MethodContainer").class("sapUiSupportContainer").openEnd().close("div");e.flush(this.dom());e.destroy();this.dom("Reboot").addEventListener("click",this._onUseOtherUI5Version.bind(this));this.dom("RebootSelect").addEventListener("change",this._onUI5VersionDropdownChanged.bind(this))};n.prototype.renderClasses=function(){var e=this;var s=this._aClasses;var a=(new t).getInterface();a.openStart("div").class("sapUISupportLabel").openEnd().text("Select Class:").close("div");a.openStart("select",this.getId()+"-ClassSelect").class("sapUiSupportAutocomplete").class("sapUiSupportSelect").openEnd();a.openStart("option").openEnd().close("option");o(s,function(t,s){if(typeof e._mAddedClasses[s]==="undefined"){a.openStart("option").openEnd();a.text(s);a.close("option")}});a.close("select");a.voidStart("input",this.getId()+"-ClassInput").class("sapUiSupportAutocomplete").attr("type","text").voidEnd();a.openStart("button",this.getId()+"-AddClass").class("sapUiSupportRoundedButton").openEnd().text("Add class").close("button");a.voidStart("hr").class("no-border").voidEnd();a.openStart("ul",this.getId()+"-ClassList").class("sapUiSupportList").openEnd();o(s,function(t,s){if(typeof e._mAddedClasses[s]==="undefined"){return}var o=e._mAddedClasses[s].bpCount;var n="";if(o){n=o.active+" / "+o.all}a.openStart("li").attr("data-class-name",s);if(e._sSelectedClass===s){a.class("selected")}a.openEnd();a.openStart("div").openEnd().openStart("span").class("className").openEnd().text(s).close("span").openStart("span").class("breakpoints").openEnd().text(n).close("span").close("div").voidStart("img").class("remove-class").attr("src","../../debug/images/delete.gif").attr("alt","X").voidEnd();a.close("li")});a.close("ul");a.flush(this.dom("ClassContainer"));a.destroy();this.dom("ClassInput").addEventListener("keyup",this._autoComplete.bind(this));this.dom("ClassInput").addEventListener("blur",this._updateSelectOptions.bind(this));this.dom("ClassSelect").addEventListener("change",this._selectOptionsChanged.bind(this));this.dom("AddClass").addEventListener("click",this._onAddClassClicked.bind(this));this.dom("ClassList").addEventListener("click",this._onSelectOrRemoveClass.bind(this))};n.prototype.renderMethods=function(e){var s=(new t).getInterface();if(typeof e==="undefined"){s.openStart("p").openEnd().text("Select a class in the list on the left side to add breakpoint.").close("p");s.flush(this.dom("MethodContainer"));s.destroy();return}s.openStart("div").class("sapUISupportLabel").openEnd().text("Select Method").close("div");s.openStart("select",this.getId()+"-MethodSelect").class("sapUiSupportAutocomplete").class("sapUiSupportSelect").openEnd().openStart("option").openEnd().close("option");o(e,function(t,e){if(!e.active){s.openStart("option").attr("data-method-type",e.type).openEnd();s.text(e.name);s.close("option")}});s.close("select");s.voidStart("input",this.getId()+"-MethodInput").class("sapUiSupportAutocomplete").attr("type","text").voidEnd();s.openStart("button",this.getId()+"-AddBreakpoint").class("sapUiSupportRoundedButton").openEnd().text("Add breakpoint").close("button");s.voidStart("hr").class("no-border").voidEnd();s.openStart("ul",this.getId()+"-BreakpointList").class("sapUiSupportList").class("sapUiSupportBreakpointList").openEnd();o(e,function(t,e){if(!e.active){return}s.openStart("li").attr("data-method-name",e.name).attr("data-method-type",e.type).openEnd().openStart("span").openEnd().text(e.name).close("span").voidStart("img").class("remove-breakpoint").attr("src","../../debug/images/delete.gif").attr("alt","Remove").voidEnd().close("li")});s.close("ul");s.flush(this.dom("MethodContainer"));s.destroy();this.dom("MethodInput").addEventListener("keyup",this._autoComplete.bind(this));this.dom("MethodInput").addEventListener("blur",this._updateSelectOptions.bind(this));this.dom("MethodSelect").addEventListener("change",this._selectOptionsChanged.bind(this));this.dom("AddBreakpoint").addEventListener("click",this._onAddBreakpointClicked.bind(this));this.dom("BreakpointList").addEventListener("click",this._onRemoveBreakpoint.bind(this))};n.prototype.onsapUiSupportDebuggingReceiveClasses=function(t){this._aClasses=JSON.parse(t.getParameter("classes"));this.renderClasses();this.renderMethods();this.dom("ClassInput").focus()};n.prototype.onsapUiSupportDebuggingReceiveClassMethods=function(t){var e=JSON.parse(t.getParameter("methods"));this.renderMethods(e);var s=t.getParameter("className");var o=JSON.parse(t.getParameter("breakpointCount"));this._mAddedClasses[s]={bpCount:o};var a=this.dom('li[data-class-name="'+s+'"] span.breakpoints');a.textContent=o.active+" / "+o.all;this.dom("MethodInput").focus()};n.prototype._autoComplete=function(t){var e=t.target;if(t.keyCode==a.ENTER){this._updateSelectOptions(t);if(e.id===this.getId()+"-ClassInput"){this._onAddClassClicked()}else{this._onAddBreakpointClicked()}return}if(t.keyCode>=a.ARROW_LEFT&&t.keyCode<=a.ARROW_DOWN){return}var s=e.value,o=e.previousElementSibling;if(s==""){return}var n=Array.from(o.querySelectorAll("option")).map(function(t){return t.value});var i;for(var r=0;r<n.length;r++){i=n[r];if(i.toUpperCase().indexOf(s.toUpperCase())==0){var d=jQuery(e),p=d.cursorPos();if(t.keyCode==a.BACKSPACE){p--}e.value=i;d.selectText(p,i.length);break}}return};n.prototype._onAddClassClicked=function(){var t=this.dom("ClassInput").value;this._mAddedClasses[t]={};this.renderClasses();this.dom("ClassInput").focus()};n.prototype._onRemoveClass=function(t){var e=t.target.closest("li[data-class-name]");var s=e.dataset.className;delete this._mAddedClasses[s];var o=false;if(this._sSelectedClass===s){this._sSelectedClass="";o=true}this._oStub.sendEvent(this._breakpointId+"RemoveAllClassBreakpoints",{className:s});this.renderClasses();if(o){this.renderMethods()}this.dom("ClassInput").focus()};n.prototype._onAddBreakpointClicked=function(){this.changeBreakpoint(this.dom("ClassList").querySelector("li.selected").dataset.className,this.dom("MethodInput").value,this.dom("MethodSelect").querySelector("option:checked").dataset.methodType,true)};n.prototype._onRemoveBreakpoint=function(t){if(t.target.nodeName==="IMG"&&t.target.classList.contains("remove-breakpoint")){var e=t.target.closest("li");this.changeBreakpoint(this.dom("ClassList").querySelector("li.selected").dataset.className,e.dataset.methodName,e.dataset.methodType,false)}};n.prototype._updateSelectOptions=function(t){var e=t.srcElement||t.target;if(e.tagName=="INPUT"){var s=e.value;e=e.previousSibling;var o=e.options;for(var a=0;a<o.length;a++){var n=o[a].value||o[a].text;if(n.toUpperCase()==s.toUpperCase()){e.selectedIndex=a;break}}}var i=e.selectedIndex;var r=e.options[i].value||e.options[i].text;if(e.nextSibling&&e.nextSibling.tagName=="INPUT"){e.nextSibling.value=r}};n.prototype._selectOptionsChanged=function(t){var e=t.srcElement||t.target;var s=e.nextSibling;s.value=e.options[e.selectedIndex].value};n.prototype._onSelectOrRemoveClass=function(t){if(t.target.nodeName==="IMG"&&t.target.classList.contains("remove-class")){this._onRemoveClass(t)}else{this._onSelectClass(t)}};n.prototype._onSelectClass=function(t){var e=t.target.closest("li[data-class-name]");if(e==null||e.classList.contains("selected")){return}e.parentElement.querySelectorAll("li.selected").forEach(function(t){t.classList.remove("selected")});e.classList.add("selected");var s=this._sSelectedClass=e.dataset.className;this._oStub.sendEvent(this._breakpointId+"RequestClassMethods",{className:s,callback:this.getId()+"ReceiveClassMethods"})};n.prototype._isClassSelected=function(){var t=false;o(this._mClasses,function(e,s){if(s.selected===true){t=true}});return t};n.prototype.changeBreakpoint=function(t,e,s,o){this._oStub.sendEvent(this._breakpointId+"ChangeClassBreakpoint",{className:t,methodName:e,active:o,type:parseInt(s),callback:this.getId()+"ReceiveClassMethods"})};n.prototype._populateRebootUrls=function(){this._mRebootUrls={"https://sdk.openui5.org/resources/sap-ui-core.js":"Public OpenUI5 server","https://sdk.openui5.org/nightly/resources/sap-ui-core.js":"Public OpenUI5 PREVIEW server","https://ui5.sap.com/resources/sap-ui-core.js":"Public SAPUI5 server","http://localhost:8080/resources/sap-ui-core.js":"Localhost (port 8080)"};this._testAndAddUrls(this._mRebootUrls);var t=this;window.setTimeout(function(){t._oStub.sendEvent(t._localStorageId+"GetItem",{id:"sap-ui-reboot-URLs",callback:t.getId()+"AppendUserUrls"})},0)};n.prototype._testAndAddUrls=function(t){var e=this.dom("RebootOther");function o(o){return function(){var a="<option value='"+s(o)+"'>"+t[o]+"</option>";e.insertAdjacentHTML("beforebegin",a)}}for(var a in t){jQuery.ajax({type:"HEAD",url:a,success:o(a)})}};n.prototype.onsapUiSupportDebuggingAppendUserUrls=function(t){var e=t.getParameter("value"),o={},a=e.split(" ");for(var n=0;n<a.length;n++){var i=a[n];if(i&&!this._mRebootUrls[i]){o[i]=s(i)+" (user-defined URL)"}}this._testAndAddUrls(o)};n.prototype._onUI5VersionDropdownChanged=function(){var t=this.dom("RebootSelect").value,e=this.dom("RebootInput");if(t==="other"){e.disabled=false}else{e.disabled=true;if(t==="none"){e.value=""}else{e.value=t}}};n.prototype._onUseOtherUI5Version=function(){var t=this.dom("RebootSelect").value;if(t==="other"){t=this.dom("RebootInput").value}if(!t||t==="none"){this._oStub.sendEvent(this._techInfoId+"SetReboot",{rebootUrl:null});alert("Reboot URL cleared. App will start normally.")}else{if(!this._mRebootUrls[t]){this._oStub.sendEvent(this._localStorageId+"GetItem",{id:"sap-ui-reboot-URLs",passThroughData:t,callback:this.getId()+"SaveUrlIfNew"})}this.confirmReload(function(){this._oStub.sendEvent(this._techInfoId+"SetReboot",{rebootUrl:t});this._oStub.sendEvent(this._oStub.getMetadata().getClass().EventType.RELOAD)}.bind(this))}};n.prototype.onsapUiSupportDebuggingSaveUrlIfNew=function(t){var e=t.getParameter("value"),s=t.getParameter("passThroughData"),o=e.split(" ");if(o.indexOf(s)===-1){o.push(s.replace(/ /g,"%20"));this._oStub.sendEvent(this._localStorageId+"SetItem",{id:"sap-ui-reboot-URLs",value:o.join(" ")})}};return n});
//# sourceMappingURL=Debugging.js.map