/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/config","sap/ui/core/RenderManager","sap/ui/core/Supportability","sap/ui/core/support/Plugin","sap/ui/core/support/controls/InteractionSlider","sap/ui/core/support/controls/InteractionTree","sap/ui/core/support/controls/TimelineOverview","sap/m/MessageToast","sap/ui/thirdparty/jszip","sap/ui/core/util/File","sap/ui/performance/trace/Interaction","sap/ui/performance/Measurement","sap/ui/core/date/UI5Date"],function(t,e,r,i,n,s,o,a,p,c,d,u,h){"use strict";var l=i.extend("sap.ui.core.support.plugins.Interaction",{constructor:function(t){i.apply(this,["sapUiSupportInteraction","Interaction",t]);if(this.runsAsToolPlugin()){this._aEventIds=[this.getId()+"SetMeasurements",this.getId()+"SetActive",this.getId()+"Export",this.getId()+"Import",this.getId()+"SetQueryString"];var e=function(t,e){return("000"+String(t)).slice(-e)};this._fnFormatTime=function(t){var r=h.getInstance(t),i=Math.floor((t-Math.floor(t))*1e3);return e(r.getHours(),2)+":"+e(r.getMinutes(),2)+":"+e(r.getSeconds(),2)+"."+e(r.getMilliseconds(),3)+e(i,3)};this._oInteractionSlider=new n;this._oInteractionTree=new s({});this._oTimelineOverview=new o}else{this._aEventIds=[this.getId()+"Refresh",this.getId()+"Clear",this.getId()+"Start",this.getId()+"Stop",this.getId()+"Activate",this.getId()+"Export",this.getId()+"Import",this.getId()+"SetQueryString"]}}});l.prototype.init=function(t){i.prototype.init.apply(this,arguments);if(this.runsAsToolPlugin()){S.call(this,t)}else{f.call(this,t)}};l.prototype.exit=function(t){i.prototype.exit.apply(this,arguments)};function S(t){var r=(new e).getInterface();r.openStart("div").class("sapUiSupportToolbar").openEnd();r.openStart("button",this.getId()+"-record").class("sapUiSupportIntToggleRecordingBtn").openEnd().close("button");r.openStart("label").class("sapUiSupportIntODataLbl").openEnd();r.voidStart("input",this.getId()+"-odata").attr("type","checkbox").voidEnd();r.text("Enable OData Statistics");r.close("label");r.openStart("div").class("sapUiSupportIntFupInputMask").openEnd();r.voidStart("input",this.getId()+"-fileImport").attr("tabindex","-1").attr("size","1").attr("accept","application/zip").attr("type","file").voidEnd();r.close("div");r.openStart("button",this.getId()+"-import").class("sapUiSupportIntImportExportBtn").class("sapUiSupportIntImportBtn").class("sapUiSupportRoundedButton").openEnd().text("Import").close("button");r.openStart("button",this.getId()+"-export").class("sapUiSupportIntImportExportBtn").class("sapUiSupportIntExportBtn").class("sapUiSupportRoundedButton").class("sapUiSupportIntHidden").openEnd().text("Export").close("button");r.openStart("span",this.getId()+"-info").class("sapUiSupportIntRecordingInfo").openEnd().close("span");r.close("div");r.openStart("div").class("sapUiSupportInteractionCntnt").openEnd();r.close("div");r.openStart("div").class("sapUiPerformanceStatsDiv").class("sapUiSupportIntHidden").openEnd();r.openStart("div").class("sapUiPerformanceTimeline").openEnd().close("div");r.openStart("div").class("sapUiPerformanceTop").openEnd();r.close("div");r.openStart("div").class("sapUiPerformanceBottom").openEnd();r.close("div");r.close("div");r.flush(this.dom());r.destroy();r=(new e).getInterface();this._oTimelineOverview.render(r);r.flush(this.dom(".sapUiPerformanceStatsDiv .sapUiPerformanceTimeline"));r.destroy();r=(new e).getInterface();this._oInteractionSlider.render(r);r.flush(this.dom(".sapUiPerformanceStatsDiv .sapUiPerformanceTop"));r.destroy();this._oInteractionSlider._registerEventListeners();this.$().find(".sapUiPerformanceTop").on("InteractionSliderChange",{},function(t,e,r){this._oInteractionTree.setRange(e,r)}.bind(this));this.dom("export").addEventListener("click",function(t){this.onsapUiSupportInteractionExport()}.bind(this));this.dom("fileImport").addEventListener("change",function(t){this.onsapUiSupportInteractionImport()}.bind(this));this.dom("odata").checked=this._bODATA_Stats_On;this.dom("odata").addEventListener("click",function(t){this._bODATA_Stats_On=!this._bODATA_Stats_On;this.confirmReload(function(){this._oStub.sendEvent(this._oStub.getMetadata().getClass().EventType.RELOAD_WITH_PARAMETER,{parameterName:"sap-statistics",parameterValue:this._bODATA_Stats_On})}.bind(this))}.bind(this));this.dom("record").dataset.state=!this._bFesrActive?"Start recording":"Stop recording";this.dom("record").addEventListener("click",function(t){var e=this.dom("record");if(e.dataset.state==="Stop recording"){this._oStub.sendEvent(this.getId()+"Refresh");this._oStub.sendEvent(this.getId()+"Activate",{active:false});e.dataset.state="Start recording";this._showPerfData()}else if(this.dom("record").dataset.state==="Start recording"){this._hidePerfData();this._oStub.sendEvent(this.getId()+"Clear");this._oStub.sendEvent(this.getId()+"Activate",{active:true});e.dataset.state="Stop recording"}}.bind(this))}function f(e){var i=t.get({name:"sapUiFesr",type:t.Type.Boolean,external:true,freeze:true});var n=r.isStatisticsEnabled();this._oStub.sendEvent(this.getId()+"SetQueryString",{queryString:{bFesrActive:i,bODATA_Stats_On:n}});v.call(this)}function v(t,e){var r=d.getActive()||this._bFesrActive;var i=[];if(r||e){i=e||d.getAll(true);var n=performance.getEntriesByType("navigation")?.[0]?.fetchStart;for(var s=0;s<i.length;s++){var o=i[s];for(var a=0;a<o.requests.length;a++){var p=o.requests[a];o.requests[a]={connectEnd:p.connectEnd,connectStart:p.connectStart,domainLookupEnd:p.domainLookupEnd,domainLookupStart:p.domainLookupStart,duration:p.duration,entryType:p.entryType,fetchStart:p.fetchStart,initiatorType:p.initiatorType,name:p.name,redirectEnd:p.redirectEnd,redirectStart:p.redirectStart,requestStart:p.requestStart,responseEnd:p.responseEnd,responseStart:p.responseStart,secureConnectionStart:p.secureConnectionStart,startTime:p.startTime,workerStart:p.workerStart,fetchStartOffset:n}}}}this._oStub.sendEvent(this.getId()+"SetMeasurements",{measurements:i});this._oStub.sendEvent(this.getId()+"SetActive",{active:r})}l.prototype.onsapUiSupportInteractionSetQueryString=function(t){var e=t.getParameter("queryString");this._bFesrActive=e.bFesrActive;this._bODATA_Stats_On=e.bODATA_Stats_On;this.dom("odata").checked=this._bODATA_Stats_On;this.dom("record").dataset.state=!this._bFesrActive?"Start recording":"Stop recording"};l.prototype.onsapUiSupportInteractionSetMeasurements=function(t){this._setMeasurementsData(t.getParameter("measurements"))};l.prototype.onsapUiSupportInteractionSetActive=function(t){};l.prototype.onsapUiSupportInteractionRefresh=function(t){v.call(this)};l.prototype.onsapUiSupportInteractionClear=function(t){d.clear();this._oStub.sendEvent(this.getId()+"SetMeasurements",{measurements:[]})};l.prototype.onsapUiSupportInteractionStart=function(t){u.start(this.getId()+"-perf","Measurement by support tool")};l.prototype.onsapUiSupportInteractionEnd=function(t){l.end(true)};l.prototype.onsapUiSupportInteractionActivate=function(t){var e=t.getParameter("active");if(d.getActive()!=e){d.setActive(e)}};l.prototype.onsapUiSupportInteractionExport=function(t){var e=this.measurements||[];if(e.length>0){var r=new p;r.file("InteractionsSteps.json",JSON.stringify(e).replace(/,"isExpanded":true/g,""));var i=r.generate({type:"blob"});this._openGeneratedFile(i)}};l.prototype.onsapUiSupportInteractionImport=function(t){var e=this.dom("fileImport").files;if(e.length===0){a.show("Select a file for import first!",{autoClose:true,duration:3e3});return}if(!window.FileReader){a.show("Use a modern browser which supports FileReader!",{autoClose:true,duration:3e3});return}var r=new window.FileReader,i=e[0],n=this;r.onload=function(t){return function(t){var e=new p(t.target.result);var r=e.files["InteractionsSteps.json"]&&e.files["InteractionsSteps.json"].asText();if(r){n._setMeasurementsData(JSON.parse(r.replace(/,"isExpanded":true/g,"")))}else{a.show("Imported data does not contain interaction measures",{autoClose:true,duration:3e3})}}}(i);r.readAsArrayBuffer(i)};l.prototype._openGeneratedFile=function(t){c.save(t,"InteractionSteps","zip","application/zip")};l.prototype._setMeasurementsData=function(t){var r=0,i=100,n=function(t){var e=function(t,e){var r=0;if(t.length===0){return r}for(var i=t.length-1;i>=0;i--){if(t[i].startTime<e.startTime){r=i+1;break}}return r},r=function(t,e){return t.filter(function(t){return t.timing.startTime===e})},n=function(t,e){var r=0;if(t.length===0){return r}for(var i=t.length-1;i>=0;i--){if(t[i].start<e.fetchStartOffset+e.startTime){r=i;break}}return r},s=0;t.forEach(function(t,o,a){var p=t.requests;for(var c=p.length-1;c>=0;c--){var d=p[c];if(o>0&&t.start-i>d.fetchStartOffset+d.startTime){var u=n(a,d);var h=a[u].requests;s=e(h,d);h.splice(s,0,d);p.splice(c,1);var l=r(t.sapStatistics,d.startTime);if(l.length>0){a[u].sapStatistics=a[u].sapStatistics.concat(l)}}}})};n(t);this.measurements=t;for(var s=0;s<t.length;s++){r+=t[s].requests.length}if(t.length>0){this._showPerfData();this.dom("info").textContent="Total "+r+" Requests in "+t.length+" Interactions"}else{this._hidePerfData();this.dom("info").textContent=""}var o=this.dom(".sapUiPerformanceStatsDiv .sapUiPerformanceTimeline");var a=(new e).getInterface();this._oTimelineOverview.setInteractions(t);this._oTimelineOverview.render(a);a.flush(o);a.destroy();this._oInteractionSlider._initSlider();this._oInteractionSlider.setDuration(t);var p=this.dom(".sapUiPerformanceStatsDiv .sapUiPerformanceBottom");this._oInteractionTree.setInteractions(t);this._oInteractionTree.renderAt(p)};l.prototype._showPerfData=function(){this.dom(".sapUiPerformanceStatsDiv").classList.remove("sapUiSupportIntHidden");this.dom("export").classList.remove("sapUiSupportIntHidden")};l.prototype._hidePerfData=function(){this.dom(".sapUiPerformanceStatsDiv").classList.add("sapUiSupportIntHidden");this.dom("export").classList.add("sapUiSupportIntHidden")};return l});
//# sourceMappingURL=Interaction.js.map