/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/isEmptyObject","sap/ui/base/ManagedObject","sap/ui/core/util/DraftEnabledMockServer","sap/ui/model/odata/ODataMetadata","sap/ui/thirdparty/jquery","sap/ui/thirdparty/sinon"],function(e,t,r,n,s,jQuery,a){"use strict";const o=/T.*(\+|\-|Z)/;const i=/(\.\d{3})\d+/;var u=r.extend("sap.ui.core.util.MockServer",{constructor:function(e,t){r.apply(this,arguments);u._aServers.push(this)},metadata:{library:"sap.ui.core",properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},_oServer:null,_aFilter:null,_oMockdata:null,_oMetadata:null,_sMetadataUrl:null,_sMockdataBaseUrl:null,_mEntitySets:null,_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."},_oRandomSeed:{}});u.prototype._getPseudoRandomNumber=function(e){if(!this._oRandomSeed){this._oRandomSeed={}}if(!this._oRandomSeed.hasOwnProperty(e)){this._oRandomSeed[e]=0}this._oRandomSeed[e]=(this._oRandomSeed[e]+11)*25214903917%0xffffffffffff;return this._oRandomSeed[e]/0xffffffffffff};u.prototype._resetPseudoRandomNumberGenerator=function(){this._oRandomSeed={}};u.prototype.start=function(){this._oServer=u._getInstance();this._aFilters=[];var e=this.getRequests();var t=this;e.forEach(function(e){var r;if(t.getRecordRequests()===false&&e.response){r=function(){e.response.apply(this,arguments);t._oServer.requests=[]}}else{r=e.response}t._addRequestHandler(e.method,e.path,r)})};u.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null}};u.prototype.attachBefore=function(e,t,r){r=r?r:"";this.attachEvent(e+r+":before",t)};u.prototype.attachAfter=function(e,t,r){r=r?r:"";this.attachEvent(e+r+":after",t)};u.prototype.detachBefore=function(e,t,r){r=r?r:"";this.detachEvent(e+r+":before",t)};u.prototype.detachAfter=function(e,t,r){r=r?r:"";this.detachEvent(e+r+":after",t)};u.prototype.isStarted=function(){return!!this._oServer};u.prototype.getEntitySetData=function(t){var r=this;var n;if(this._oMockdata&&this._oMockdata.hasOwnProperty(t)){n=jQuery.extend(true,[],r._oMockdata[t])}else{e.error("Unrecognized EntitySet name: "+t)}return n};u.prototype.setEntitySetData=function(t,r){if(this._oMockdata&&this._oMockdata.hasOwnProperty(t)){this._oMockdata[t]=r}else{e.error("Unrecognized EntitySet name: "+t)}};u.prototype._applyQueryOnCollection=function(e,t,r,n){var s=t.split("=");var a=s[1];if(a===""){return}if(a.lastIndexOf(",")===a.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES)}switch(s[0]){case"$top":if(!new RegExp(/^\d+$/).test(a)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}e.results=e.results.slice(0,a);break;case"$skip":if(!new RegExp(/^\d+$/).test(a)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}e.results=e.results.slice(a,e.results.length);break;case"$orderby":e.results=this._getOdataQueryOrderby(e.results,a,r);break;case"$filter":e.results=this._recursiveOdataQueryFilter(e.results,a);break;case"search-focus":break;case"search":var o="";for(var i=0;i<n.length;i++){if(n[i].indexOf("search-focus")!=-1){o=n[i].split("=")[1];break}}e.results=this._recursiveOdataQuerySearch(e.results,a,o,r);break;case"$select":e.results=this._getOdataQuerySelect(e.results,a,r);break;case"$inlinecount":var u=this._getOdataInlineCount(e.results,a);if(u){e.__count=u}break;case"$expand":e.results=this._getOdataQueryExpand(e.results,a,r);break;case"$format":e.results=this._getOdataQueryFormat(e.results,a);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,s[0])}};u.prototype._applyQueryOnEntry=function(e,t,r){var n=t.split("=");var s=n[1];if(s===""){return}if(s.lastIndexOf(",")===s.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES)}switch(n[0]){case"$filter":return this._recursiveOdataQueryFilter([e],s)[0];case"$select":return this._getOdataQuerySelect([e],s,r)[0];case"$expand":return this._getOdataQueryExpand([e],s,r)[0];case"$format":return this._getOdataQueryFormat([e],s);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,n[0])}};u.prototype._getOdataQueryOrderby=function(e,t,r){var n=t.split(",");var s=this;jQuery.each(n,function(e,t){n[e]=s._trim(t)});var a=function e(t,a){for(var o=0;o<n.length;o++){var i=n[o].split(" ");var u=1;if(i.length>1){switch(i[1]){case"asc":u=1;break;case"desc":u=-1;break;default:s._logAndThrowMockServerCustomError(400,s._oErrorMessages.INVALID_SORTORDER_DETECTED,i[1])}}var f,c;var d=i[0].indexOf("/");if(d!==-1){f=i[0].substring(d+1);c=i[0].substring(0,d);if(!t[c].hasOwnProperty(f)){var p=false;var l=[];if(c){var h=s._mEntitySets[r].navprops[c].to.entitySet;l=s._mEntityTypes[s._mEntitySets[h].type].properties;for(var o=0;o<l.length;o++){if(l[o].name===f){p=true;break}}}if(!p){s._logAndThrowMockServerCustomError(400,s._oErrorMessages.PROPERTY_NOT_FOUND,f)}}if(t[c][f]<a[c][f]){return-1*u}if(t[c][f]>a[c][f]){return 1*u}}else{f=i[0];if(!t.hasOwnProperty(f)){s._logAndThrowMockServerCustomError(400,s._oErrorMessages.PROPERTY_NOT_FOUND,f)}if(t[f]<a[f]){return-1*u}if(t[f]>a[f]){return 1*u}}}return 0};return e.sort(a)};u.prototype._arrayUnique=function(e){var t=e.concat();for(var r=0;r<t.length;++r){for(var n=r+1;n<t.length;++n){if(t[r]===t[n]){t.splice(n--,1)}}}return t};u.prototype._getBracketIndices=function(e){var t=[];var r=0;var n,s=0;for(var a=0;a<e.length;a++){if(e[a]==="("){if(/[substringof|endswith|startswith]$/.test(e.substring(0,a))){++r}else{t.push(e[a]);if(n===undefined){n=a}}}else if(e[a]===")"){if(!r){t.pop();s=a;if(t.length===0){return{start:n,end:s}}}else{--r}}}return{start:n,end:s}};u.prototype._recursiveOdataQueryFilter=function(e,t){var r=this._getBracketIndices(t);if(r.start===0&&r.end===t.length-1){t=this._trim(t.substring(r.start+1,r.end));return this._recursiveOdataQueryFilter(e,t)}var n=/([^substringof|endswith|startswith]|^)\((.*)\)/,s,a;var o;if(n.test(t)){var i=t.substring(r.start,r.end+1);var u=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(i))+".*)");if(r.start===0){u=new RegExp("("+this._trim(this._escapeStringForRegExp(i))+") +(or|and) +(.*)")}var f=u.exec(t);if(f===null){return this._getOdataQueryFilter(e,this._trim(t))}var c=f[1];o=f[2];var d=f[3];var p=this._recursiveOdataQueryFilter(e,c);if(o==="or"){s=this._recursiveOdataQueryFilter(e,d);return this._arrayUnique(p.concat(s))}if(o==="and"){return this._recursiveOdataQueryFilter(p,d)}}else{a=t.split(/ +and | or +/);if(a.length===1){return this._getOdataQueryFilter(e,this._trim(t))}var l=this._recursiveOdataQueryFilter(e,a[0]);var h;for(var v=1;v<a.length;v++){h=new RegExp(this._trim(this._escapeStringForRegExp(a[v-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(a[v])));o=h.exec(t)[1];if(o==="or"){s=this._recursiveOdataQueryFilter(e,a[v]);l=this._arrayUnique(l.concat(s))}if(o==="and"){l=this._recursiveOdataQueryFilter(l,a[v])}}return l}};u.prototype._getOdataQueryFilter=function(t,r){if(t.length===0){return t}var n=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var s=new RegExp("(endswith|startswith|substringof)\\((.*)");var a=null;var o=n.exec(r);if(o){a=o[2]}else{o=s.exec(r);if(o){a=o[1]}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT)}}var i=this;var u=function(s,a,o,u){var f,c,d;if(!s){f=n.exec(r);c=i._trim(f[a+1]);d=i._trim(f[o+1])}else{var p=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");f=p.exec(r);c=i._trim(f[a+2]);d=i._trim(f[o+2])}if(/^\(.+\)$/.test(c)){c=c.replace(/^\(|\)$/g,"")}if(c.indexOf("datetime")===0){c=i._getJsonDate(c)}else if(c.indexOf("guid")===0){c=c.substring(5,c.length-1)}else if(c==="true"){c=true}else if(c==="false"){c=false}else if(i._isValidNumber(c)){c=parseFloat(c)}else if(c.charAt(0)==="'"&&c.charAt(c.length-1)==="'"){c=c.substr(1,c.length-2)}var l=d.indexOf("/");if(l!==-1){var h=d.substring(l+1);var v=d.substring(0,l);if(t[0][v]){if(!t[0][v].hasOwnProperty(h)){var _=i._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+h+"'");e.error("MockServer: navigation property '"+v+"' was not expanded, so "+_);return t}}else{i._logAndThrowMockServerCustomError(400,i._oErrorMessages.PROPERTY_NOT_FOUND,d)}return u(d,c,v,h)}else{if(!t[0].hasOwnProperty(d)){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.PROPERTY_NOT_FOUND,d)}return u(d,c)}};switch(a){case"substringof":return u(true,0,1,function(e,r,n,s){return t.filter(function(t){if(n&&s){return typeof t[n][s]==="string"&&t[n][s].indexOf(r)!==-1}return typeof t[e]==="string"&&t[e].indexOf(r)!==-1})});case"startswith":return u(true,1,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return typeof t[n][s]==="string"&&t[n][s].indexOf(r)===0}return typeof t[e]==="string"&&t[e].indexOf(r)===0})});case"endswith":return u(true,1,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return typeof t[n][s]==="string"&&t[n][s].indexOf(r)===t[n][s].length-r.length}return typeof t[e]==="string"&&t[e].indexOf(r)===t[e].length-r.length})});case"eq":return u(false,2,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return t[n][s]===r}return t[e]===r})});case"ne":return u(false,2,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return t[n][s]!==r}return t[e]!==r})});case"gt":return u(false,2,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return t[n][s]>r}return t[e]>r})});case"lt":return u(false,2,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return t[n][s]<r}return t[e]<r})});case"ge":return u(false,2,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return t[n][s]>=r}return t[e]>=r})});case"le":return u(false,2,0,function(e,r,n,s){return t.filter(function(t){if(n&&s){return t[n][s]<=r}return t[e]<=r})});default:this._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_FILTER_OPERATOR,a)}};u.prototype._recursiveOdataQuerySearch=function(e,t,r,n){var s="";if(r==""||r==undefined){for(var a=0;a<this._mEntitySets[n].keys.length;a++){if(a!=0){s=s+" or "}s=s+"startswith("+this._mEntitySets[n].keys[a]+",'"+t+"')"}}else{s="substringof('"+t+"',"+r+")"}return this._recursiveOdataQueryFilter(e,s)};u.prototype._getOdataQuerySelect=function(e,t,r){var n=this;var s=t.split(",");var a=[];var o=e[0]?e[0][s[0].split("/")[0]]:null;if(!(o!=null&&o.results&&o.results.length>0)){var i=function(e,t,s,a){jQuery.each(e,function(e,o){if(t["__metadata"]){s["__metadata"]=t["__metadata"]}if(o.indexOf("/")>-1){var u=o.split("/");var f=u[0];var c=u.splice(1).join("/");s[f]=s[f]||{};if(t[f]&&t[f].results){var d=s[f].results=s[f].results||[];jQuery.each(t[f].results,function(e,t){d[e]=i([c],t,d[e]||{},f)})}else{s[f]=i([c],t[f],s[f]||{},f)}}else{if(t&&!t.hasOwnProperty(o)){var p=false;var l=[];if(a){var h=n._mEntitySets[r].navprops[a].to.entitySet;l=n._mEntityTypes[n._mEntitySets[h].type].properties;for(var e=0;e<l.length;e++){if(l[e].name===o){p=true;break}}}if(!p){n._logAndThrowMockServerCustomError(404,n._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,o)}}s[o]=t[o]}});return s};if(s.indexOf("*")!==-1){return e}jQuery.each(s,function(e,t){s[e]=n._trim(t)});jQuery.each(e,function(e,t){a.push(i(s,t,{}))})}else{var u=function(e,t,r){var n={};r=r||"";if(typeof e!=="object"){return e}if(typeof e.slice==="function"){return e.map(function(e,n){return u(e,t,r)})}if(e.__metadata!==undefined&&r.length===0){n.__metadata=e.__metadata}t.filter(function(e){return(e+"/").indexOf(r)===0}).forEach(function(t,s,a){var o=t.substr(r.length).split("/")[0];if(e[o]!==undefined){n[o]=u(e[o],a,r+o+"/")}});if(e.results!==undefined){n.results=u(e.results,t,r)}return n};a=u(e,s)}return a};u.prototype._getOdataInlineCount=function(e,t){var r=t.split(",");if(r.length!==1||r[0]!=="none"&&r[0]!=="allpages"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}if(r[0]==="none"){return}return e.length};u.prototype._getOdataQueryFormat=function(e,t){if(t!=="json"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE)}return e};u.prototype._getOdataQueryExpand=function(e,t,r){var n=this;var s=t.split(",");jQuery.each(s,function(e,t){s[e]=n._trim(t)});var a=n._mEntitySets[r].navprops;jQuery.each(e,function(e,t){jQuery.each(s,function(e,s){var o=s.split("/");var i=o[0];if(!t[i]){n._logAndThrowMockServerCustomError(404,n._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,i)}var u=t[i].results||t[i];if(!u||u.__deferred){u=jQuery.extend(true,[],n._resolveNavigation(r,t,i,t))}else if(!Array.isArray(u)){u=[u]}if(u&&o.length>1){var f=o.splice(1,o.length).join("/");u=n._getOdataQueryExpand(u,f,a[i].to.entitySet)}if(a[i].to.multiplicity==="*"){t[i]={results:u}}else{t[i]=u[0]?u[0]:{}}})});return e};u.prototype._refreshData=function(){var e=this._loadMetadata(this._sMetadataString);if(!e){return}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata)}else{if(!this._sMockdataBaseUrl.endsWith("/")&&!this._sMockdataBaseUrl.endsWith(".json")){this._sMockdataBaseUrl+="/"}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl)}};u.prototype._getRootUri=function(){var e=this.getRootUri();e=e&&/([^?#]*)([?#].*)?/.exec(e)[1];return e};u.prototype._loadMetadata=function(t){var t;t=t.trim();if(t.substring(0,1)!=="<"){t=f({url:t,dataType:"text"}).data;if(!t){e.error('MockServer: The metadata for url "'+t+'" could not be found!')}}this._sMetadata=t;try{this._oMetadata=jQuery.parseXML(t)}catch(t){e.error("MockServer: Invalid metadata XML! Reason: "+t)}return this._oMetadata};u.prototype._findEntitySets=function(e){var t={};var r=jQuery(e).find("Principal");var n=jQuery(e).find("Dependent");jQuery(e).find("EntitySet").each(function(e,r){var n=jQuery(r);var s=/((.*)\.)?(.*)/.exec(n.attr("EntityType"));t[n.attr("Name")]={name:n.attr("Name"),schema:s[2],type:s[3],keys:[],keysType:{},navprops:{},props:{}}});var s=function(e,t,s,a){var o=jQuery(s).find("End[Role='"+e+"']").attr("EntitySet");var i=jQuery(t).find("End[Role='"+e+"']").attr("Multiplicity");var u=[];var f=jQuery(t).find("ReferentialConstraint > [Role='"+e+"']");if(f&&f.length>0){jQuery(f[0]).children("PropertyRef").each(function(e,t){u.push(jQuery(t).attr("Name"))})}else{var c=a?r:n;jQuery(c).each(function(t,r){if(e===jQuery(r).attr("Role")){jQuery(r).children("PropertyRef").each(function(e,t){u.push(jQuery(t).attr("Name"))});return false}})}return{role:e,entitySet:o,propRef:u,multiplicity:i}};jQuery.each(t,function(t,r){var n=jQuery(e).find("EntityType[Name='"+r.type+"']");var a=jQuery(n).find("PropertyRef");jQuery.each(a,function(e,t){var s=jQuery(t).attr("Name");r.keys.push(s);r.keysType[s]=jQuery(n).find("Property[Name='"+s+"']").attr("Type")});var o=jQuery(e).find("EntityType[Name='"+r.type+"'] Property");jQuery.each(o,function(e,t){var n=jQuery(t);r.props[n.attr("Name")]={name:n.attr("Name"),type:n.attr("Type")}});var i=jQuery(e).find("EntityType[Name='"+r.type+"'] NavigationProperty");jQuery.each(i,function(t,n){var a=jQuery(n);var o=a.attr("Relationship").split(".");var i=jQuery(e).find("AssociationSet[Association = '"+o.join(".")+"']");var u=o.pop();var f=jQuery(e).find("Association[Name = '"+u+"']");r.navprops[a.attr("Name")]={name:a.attr("Name"),from:s(a.attr("FromRole"),f,i,true),to:s(a.attr("ToRole"),f,i,false)}})});return t};u.prototype._findEntityTypes=function(e){var t={};jQuery(e).find("EntityType").each(function(e,r){var n=jQuery(r);t[n.attr("Name")]={name:n.attr("Name"),properties:[],keys:[]};n.find("Property").each(function(e,r){var s=jQuery(r);var a=s.attr("Type");t[n.attr("Name")].properties.push({schema:a.substring(0,a.lastIndexOf(".")),type:a.substring(a.lastIndexOf(".")+1),name:s.attr("Name"),precision:s.attr("Precision"),scale:s.attr("Scale")})});n.find("PropertyRef").each(function(e,r){var s=jQuery(r);var a=s.attr("Name");t[n.attr("Name")].keys.push(a)})});return t};u.prototype._findComplexTypes=function(e){var t={};jQuery(e).find("ComplexType").each(function(e,r){var n=jQuery(r);t[n.attr("Name")]={name:n.attr("Name"),properties:[]};n.find("Property").each(function(e,r){var s=jQuery(r);var a=s.attr("Type");t[n.attr("Name")].properties.push({schema:a.substring(0,a.lastIndexOf(".")),type:a.substring(a.lastIndexOf(".")+1),name:s.attr("Name"),precision:s.attr("Precision"),scale:s.attr("Scale")})})});return t};u.prototype._createKeysString=function(e,t){var r=this;var n="";if(t){jQuery.each(e.keys,function(s,a){if(n){n+=","}var o=t[a];if(e.keysType[a]==="Edm.String"){o=encodeURIComponent("'"+o+"'")}else if(e.keysType[a]==="Edm.DateTime"){o=r._getDateTime(o);o=encodeURIComponent(o)}else if(e.keysType[a]==="Edm.Guid"){o="guid'"+o+"'"}if(e.keys.length===1){n+=o;return n}n+=a+"="+o})}return n};u.prototype._loadMockdata=function(t,r){var n=this,s={};this._oMockdata={};var a=function(t,r){var n=f({url:t,dataType:"json"});if(n.success){if(n.data.d){if(n.data.d.results){s[r.name]=n.data.d.results}else{e.error('The mock data format for entity set "'+r.name+'" invalid')}}else{if(Array.isArray(n.data)){s[r.name]=n.data}else{e.error('The mock data for entity set "'+r.name+'" could not be loaded due to wrong format!');return false}}return true}else{if(n.status==="parsererror"){e.error('The mock data for entity set "'+r.name+'" could not be loaded due to a parsing error!')}return false}};if(r.endsWith(".json")){var o=f({url:r,dataType:"json"});if(o.success){s=o.data}else{e.warning('The mock data for all the entity types could not be found at "'+r+'"!')}}else{var i={};if(n._aEntitySetsNames&&n._aEntitySetsNames.length>0){var u;for(var c=0;c<n._aEntitySetsNames.length;c++){u=n._aEntitySetsNames[c];if(t[u]){i[u]=t[u]}}}else{i=t}jQuery.each(i,function(t,o){if(!s[o.type]||!s[o.name]){var i=r+o.name+".json";if(!a(i,o)){e.warning('The mock data for entity set "'+o.name+'" could not be found at "'+r+'"!');var u=r+o.type+".json";if(!a(u,o)){e.warning('The mock data for entity type "'+o.type+'" could not be found at "'+r+'"!');if(n._bGenerateMissingMockData){var f={};f[o.name]=o;s[o.type]=n._generateODataMockdataForEntitySet(f,n._oMetadata)[o.name]}}}}})}jQuery.each(t,function(e,t){n._oMockdata[e]=[];if(s[t.name]){jQuery.each(s[t.name],function(t,r){n._oMockdata[e].push(jQuery.extend(true,{},r))})}else if(s[t.type]){jQuery.each(s[t.type],function(t,r){n._oMockdata[e].push(jQuery.extend(true,{},r))})}});jQuery.each(t,function(e,t){if(n._oMockdata[e].length>0){n._enhanceWithMetadata(t,n._oMockdata[e]);n._oMockdata[e].forEach(function(e){Object.keys(t.props).forEach(function(r){switch(t.props[r].type){case"Edm.DateTime":case"Edm.DateTimeOffset":if(e[r]!=null){var n=new Date(e[r]);if(n&&!isNaN(n)){e[r]="/Date("+n.getTime()+")/"}}break;default:}})})}});return this._oMockdata};u.prototype._enhanceWithMetadata=function(e,r){if(r){var n=this,s=this._getRootUri(),a=e&&e.name;jQuery.each(r,function(r,o){o.__metadata=o.__metadata||{};o.__metadata.id=s+a+"("+n._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=s+a+"("+n._createKeysString(e,o)+")";jQuery.each(e.navprops,function(r,i){if(o[r]&&!t(o[r])&&!o[r]["__deferred"]){n._oMockdata[i.to.entitySet]=n._oMockdata[i.to.entitySet].concat(o[r])}o[r]={__deferred:{uri:s+a+"("+n._createKeysString(e,o)+")/"+r}}})})}};u.prototype._isRequestedKeysValid=function(e,t){if(t.length===1){var r=t[0].split("=");if(this._trim(r[0])!==e.keys[0]){t=[e.keys[0]+"="+t[0]]}}for(var n=0;n<t.length;n++){var s=this._trim(t[n].substring(0,t[n].indexOf("=")));var a=this._trim(t[n].substring(t[n].indexOf("=")+1));var o=a.charAt(0);var i=a.charAt(a.length-1);if(e.keysType[s]==="Edm.String"){if(o!=="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,s)}}else if(e.keysType[s]==="Edm.DateTime"){if(o==="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,s)}}else if(e.keysType[s]==="Edm.Guid"){if(o==="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,s)}}else if(e.keysType[s]==="Edm.Binary"){if(!new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(a)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,s)}}else{if(o==="'"&&i!=="'"||i==="'"&&o!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,s)}}var u=e.keys.join(",");if(e.keys.indexOf(s)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,u)}}};u.prototype._parseKeys=function(e,t){var r={};var n=e.split(",");var s,a,o;for(var i=0;i<n.length;i++){o=n[i].split("=");if(o.length===1&&t.keys.length===1){s=t.keys[0];a=o[0]}else{if(o.length===2){s=o[0];a=o[1]}}r[s]=a;switch(t.keysType[s]){case"Edm.String":r[s]=r[s].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[s]=parseFloat(r[s]);break;case"Edm.Guid":r[s]=r[s].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:}}return r};u.prototype._generatePropertyValue=function(e,t,r,n){var s=n;if(!s){s=Math.floor(this._getPseudoRandomNumber("String")*1e4)+101}switch(t){case"String":return e+" "+s;case"DateTime":var a=new Date;a.setFullYear(2e3+Math.floor(this._getPseudoRandomNumber("DateTime")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*1e4);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1e6)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1e9;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=this._getPseudoRandomNumber("Guid")*16|0,r=e==="x"?t:t&3|8;return r.toString(16)}.bind(this));case"Binary":var o=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),i="";for(var u=0,f=o;u<32;u++,i+=String(f>>>31),f<<=1);return i;case"DateTimeOffset":var a=new Date;a.setFullYear(2e3+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+"+0000)/";default:return this._generateDataFromEntity(r[t],s,r)}};u.prototype._isFalseyValue=function(e,t,r){switch(r){case"Edm.String":return e==="";case"Edm.Boolean":return e===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return e===0||isNaN(e);default:return false}};u.prototype._completeKey=function(e,t,r){if(r){for(var n=0;n<e.keys.length;n++){var s=e.keys[n];if(t[s]!==undefined&&t[s]!==null){if(!r[s]){switch(e.keysType[s]){case"Edm.DateTime":r[s]=this._getJsonDate(t[s]);break;case"Edm.Guid":r[s]=t[s].replace(/^guid\'|\'$/g,"");break;default:r[s]=t[s]}}}else{if(!r[s]){r[s]=this._generatePropertyValue(s,e.keysType[s].substring(e.keysType[s].lastIndexOf(".")+1))}}}}};u.prototype._generateDataFromEntity=function(e,t,r){var n={};if(!e){return n}for(var s=0;s<e.properties.length;s++){var a=e.properties[s];n[a.name]=this._generatePropertyValue(a.name,a.type,r,t)}return n};u.prototype._generateDataFromEntitySet=function(e,t,r){var n=t[e.type];var s=[];for(var a=0;a<100;a++){s.push(this._generateDataFromEntity(n,a+1,r))}return s};u.prototype._generateMockdata=function(e,t){var r=this;var n={};var s=this._getRootUri();jQuery.each(e,function(e,s){var a={};a[s.name]=s;n[e]=r._generateODataMockdataForEntitySet(a,t)[e]});jQuery.each(e,function(e,t){for(var a in t.navprops){var o=t.navprops[a];var i=o.from.propRef.length;for(var u=0;u<i;u++){for(var f=0;f<n[e].length;f++){var c=n[e][f];n[o.to.entitySet][f][o.to.propRef[u]]=c[o.from.propRef[u]]}}}jQuery.each(n[e],function(n,a){a.__metadata={uri:s+e+"("+r._createKeysString(t,a)+")",type:t.schema+"."+t.type};jQuery.each(t.navprops,function(n,o){a[n]={__deferred:{uri:s+e+"("+r._createKeysString(t,a)+")/"+n}}})})});this._oMockdata=n};u.prototype._generateODataMockdataForEntitySet=function(e,t){var r=this,n={};var s=this._findEntityTypes(t);var a=this._findComplexTypes(t);jQuery.each(e,function(e,t){n[e]=r._generateDataFromEntitySet(t,s,a)});return n};u.prototype._resolveNavigation=function(e,t,r){var n=this._mEntitySets[e];var s=n.navprops[r];if(!s){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND)}var a=[];var o=s.from.propRef.length;if(o===0){if(s.to.multiplicity==="*"){return this._oMockdata[s.to.entitySet]}else{a.push(this._oMockdata[s.to.entitySet][0]);return a}}jQuery.each(this._oMockdata[s.to.entitySet],function(e,r){var n=true;for(var i=0;i<o;i++){if(t[s.from.propRef[i]]!==r[s.to.propRef[i]]){n=false;break}}if(n){a.push(r)}});return a};u.prototype.simulate=function(r,a){var o=this;this._sMetadataString=r;if(!a||typeof a==="string"){this._sMockdataBaseUrl=a}else{this._sMockdataBaseUrl=a.sMockdataBaseUrl;this._bGenerateMissingMockData=a.bGenerateMissingMockData;this._aEntitySetsNames=a.aEntitySetsNames}var i=this._loadMetadata(this._sMetadataString);if(!i){return}if(this._sMetadata){var f=s.getServiceAnnotations(this._sMetadata);n.handleDraft(f,this)}this._resetPseudoRandomNumberGenerator();this._refreshData();var c=function(e,t){if(e.requestHeaders["x-csrf-token"]==="Fetch"||e.requestHeaders["X-CSRF-Token"]==="Fetch"){t["X-CSRF-Token"]="42424242424242424242424242424242"}};var d=function(e,t){t=decodeURIComponent(t);var r;var n=o._mEntitySets[e];var s=n.keys;var a=t.split(",");if(a.length!==s.length){o._logAndThrowMockServerCustomError(400,o._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY)}o._isRequestedKeysValid(n,a);if(a.length===1&&!a[0].split("=")[1]){a=[s[0]+"="+a[0]]}jQuery.each(o._oMockdata[e],function(e,t){for(var i=0;i<a.length;i++){var u=a[i].split("=");var f=o._trim(u[0]);if(!s||s.indexOf(f)===-1){return true}var c=o._trim(u[1]);var d=t[f];switch(n.keysType[f]){case"Edm.String":c=c.replace(/^\'|\'$/g,"");break;case"Edm.Time":case"Edm.DateTime":d=o._getDateTime(d);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!o._isValidNumber(c)){return false}c=parseFloat(c);break;case"Edm.Guid":c=c.replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":if(["true","false"].indexOf(c)===-1){o._logAndThrowMockServerCustomError(400,o._oErrorMessages.INVALID_KEY_TYPE,f)}c=c==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:}if(d!==c){return true}}r={index:e,entry:t};return false});return r};var p=function(e,t,r){var n=e.name;var s;if(r){s=e.navprops[r]}if(s){n=s.to.entitySet}return n};var l=function(e){var t=[];var r=function(e){var t=e.indexOf("'");var r=e.indexOf('"');if(t===-1&&r===-1){return null}else{if(t>-1&&r===-1){return"appost"}if(r>-1&&t===-1){return"doublequotes"}if(t>-1&&r>-1&&t<r){return"appost"}if(t>-1&&r>-1&&r<t){return"doublequotes"}}};var n=function(e,t,r,n){var s=e[r];var a=r+1;while(a<e.length&&e[a].indexOf(n)===-1){s=s+"&"+e[a];a++}s=s+"&"+e[a];t.push(s);r=a;return r};for(var s=0;s<e.length;s++){if(!r(e[s])){t.push(e[s])}if(r(e[s])==="appost"){var a=e[s].indexOf("'");if(e[s].indexOf("'",a+1)===-1){s=n(e,t,s,"'")}else{t.push(e[s])}}if(r(e[s])==="doublequotes"){var o=e[s].indexOf('"');if(e[s].indexOf('"',o+1)===-1){s=n(e,t,s,'"')}else{t.push(e[s])}}}return t};var h=function(e,t,r,n){r=r?decodeURIComponent(r):r;var s=JSON.parse(e.requestBody);if(s){var a={};if(r){a=o._parseKeys(r,o._mEntitySets[t])}o._completeKey(o._mEntitySets[t],a,s);o._enhanceWithMetadata(o._mEntitySets[t],[s]);return s}return null};var v=[];v.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/xml;charset=utf-8"};c(t,r);t.respond(200,r,o._sMetadata);e.debug("MockServer: response sent with: 200, "+o._sMetadata);return true}});v.push({method:"HEAD",path:new RegExp("(\\?.*)?$"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/json;charset=utf-8"};c(t,r);t.respond(200,r);e.debug("MockServer: response sent with: 200");return true}});v.push({method:"GET",path:new RegExp("$"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/json;charset=utf-8"};c(t,r);var n=[];jQuery.each(o._mEntitySets,function(e,t){n.push(e)});var s={EntitySets:n};t.respond(200,r,JSON.stringify({d:s}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:s}));return true}});v.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r=function(e){switch(e.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return e.statusCode+" "+e.status}};var n=function(e,t){var n;if(e.success){n=JSON.stringify(e.data)||""}else{n=e.errorResponse}t=t||"application/json";if(e.responseHeaders){return"HTTP/1.1 "+r(e)+"\r\n"+e.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+n+"\r\n"}else{return"HTTP/1.1 "+r(e)+"\r\nContent-Type: "+t+"\r\nContent-Length: "+n.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+n+"\r\n"}};var s=function(e,t,r,s,a){var o;var i=function(e,t,r){o={success:true,data:e,status:t,statusCode:r&&r.status,responseHeaders:r&&r.getAllResponseHeaders()}};var u=function(e,t,r){o={success:false,data:undefined,status:t,error:r,statusCode:e.status,errorResponse:e.responseText,responseHeaders:e&&e.getAllResponseHeaders()}};jQuery.ajax({type:r,async:false,url:e,headers:a,data:t,dataType:"json",success:i,error:u});if(o.statusCode===400||o.statusCode===404){var f=n(o);throw new Error(f)}s.push(n(o))};var a=function(e,t){var r;var s;var a=function(e,t,n){r={success:true,data:e,status:t,statusCode:n&&n.status,responseHeaders:n&&n.getAllResponseHeaders()}};var o=function(e,t,n){r={success:false,data:undefined,status:t,error:n,statusCode:e.status,errorResponse:e.responseText,responseHeaders:e&&e.getAllResponseHeaders()}};jQuery.ajax({async:false,url:e,dataType:"json",success:a,error:o});var s;if(e.indexOf("$count")!==-1){s=n(r,"text/plain")}else{s=n(r)}t.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+s.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+s)};var i=function(e){var t={};e.split("HTTP/1.1")[1].split("{")[0].split("\n").forEach(function(e){if(e.indexOf(":")!==-1){var r=e.split(":");t[r[0].trim()]=r[1].trim()}});delete t["Content-Length"];return t};var u=t.requestBody;var f=new RegExp("--batch_[a-z0-9-]*");var d=f.exec(u)[0];if(d){var p=[];var l=u.split(d);var h=t.url.split("$")[0];var v=new RegExp("PUT (.*) HTTP");var _=new RegExp("MERGE (.*) HTTP");var E=new RegExp("POST (.*) HTTP");var y=new RegExp("DELETE (.*) HTTP");var g=new RegExp("GET (.*) HTTP");for(var m=1;m<l.length-1;m++){var T=l[m];if(g.test(T)&&T.indexOf("multipart/mixed")===-1){if(v.test(T)||E.test(T)||y.test(T)){t.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");e.debug("MockServer: response sent with: 400");return true}a(h+g.exec(T)[1],p)}else{var S=jQuery.extend(true,{},o._oMockdata);var M=[];var O=T.substring(T.indexOf("boundary=")+9,T.indexOf("\r\n\r\n"));var R=T.split("--"+O);try{for(var k=1;k<R.length-1;k++){var b=R[k];var N;if(g.test(b)){o._oMockdata=S;t.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");e.debug("MockServer: response sent with: 400");return}else{var N=b.substring(b.indexOf("{"),b.lastIndexOf("}")+1),x=i(b),D,P;if(v.test(b)){P="PUT";D=v.exec(b)[1]}else if(_.test(b)){P="MERGE";D=_.exec(b)[1]}else if(E.test(b)){P="POST";D=E.exec(b)[1]}else if(y.test(b)){P="DELETE";N=undefined;D=y.exec(b)[1]}s(h+D,N,P,M,x)}}var I="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var w=0;w<M.length;w++){I+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+M[w].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+M[w]+"--ejjeeffe1"}I+="--\r\n";p.push(I)}catch(e){o._oMockdata=S;var A="\r\nContent-Type: application/http\r\n"+"Content-Length: "+e.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+e.message;p.push(A)}}}var C="--ejjeeffe0";for(var U=0;U<p.length;U++){C+=p[U]+"--ejjeeffe0"}C+="--";var x={"Content-Type":"multipart/mixed; boundary=ejjeeffe0"};c(t,x);t.respond(202,x,C);e.debug("MockServer: response sent with: 202, "+C)}else{t.respond(202)}return true}});jQuery.each(this._mEntitySets,function(r,n){v.push({method:"GET",path:new RegExp("("+r+")/\\$count/?(.*)?"),response:function(t,r,n){e.debug("MockServer: incoming request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.GET+r+":before",{oXhr:t,sUrlParams:n});o.fireEvent(u.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:n});var s={"Content-Type":"text/plain;charset=utf-8"};c(t,s);try{var a=o._oMockdata[r];if(a){var i={results:jQuery.extend(true,[],a)};if(n){var f=decodeURIComponent(n).replace("?","&").split("&");f=l(f);if(f.length>1){f=o._orderQueryOptions(f)}jQuery.each(f,function(e,t){o._applyQueryOnCollection(i,t,r,f)})}o.fireEvent(u.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:i});o.fireEvent(u.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:i});t.respond(200,s,""+i.results.length);e.debug("MockServer: response sent with: 200, "+i.results.length)}else{o._logAndThrowMockServerCustomError(404,o._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,s,JSON.stringify(r))}else{e.error("MockServer: request failed due to invalid system query options value!");t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")/?(\\?(.*))?"),response:function(t,r,n){e.debug("MockServer: incoming request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.GET+r+":before",{oXhr:t,sUrlParams:n});o.fireEvent(u.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:n});var s={"Content-Type":"application/json;charset=utf-8"};c(t,s);try{var a=o._oMockdata[r];if(a){var i={results:jQuery.extend(true,[],a)};if(n){var f=decodeURIComponent(n).replace("?","&").split("&");f=l(f);if(f.length>1){f=o._orderQueryOptions(f)}jQuery.each(f,function(e,t){o._applyQueryOnCollection(i,t,r,f)})}o.fireEvent(u.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:i});o.fireEvent(u.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:i});t.respond(200,s,JSON.stringify({d:i}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:i}))}else{o._logAndThrowMockServerCustomError(404,o._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,s,JSON.stringify(r))}else{e.debug("MockServer: response sent with: "+parseInt(r.message||r.number));t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(r,n,s,a){e.debug("MockServer: incoming request for url: "+r.url);o.fireEvent(u.HTTPMETHOD.GET+n+":before",{oXhr:r,sKeys:s,sUrlParams:a});o.fireEvent(u.HTTPMETHOD.GET+":before",{oXhr:r,sKeys:s,sUrlParams:a});var i={"Content-Type":"application/json;charset=utf-8"};try{var f=jQuery.extend(true,{},d(n,s));if(!t(f)){if(a){var c=decodeURIComponent(a).replace("?","&").split("&");c=l(c);if(c.length>1){c=o._orderQueryOptions(c)}jQuery.each(c,function(e,t){f.entry=o._applyQueryOnEntry(f.entry,t,n)})}o.fireEvent(u.HTTPMETHOD.GET+n+":after",{oXhr:r,oEntry:f.entry});o.fireEvent(u.HTTPMETHOD.GET+":after",{oXhr:r,oEntry:f.entry});r.respond(200,i,JSON.stringify({d:f.entry}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:f.entry}))}else{o._logAndThrowMockServerCustomError(404,o._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(t){if(t.error){r.respond(t.error.code,i,JSON.stringify(t))}else{e.debug("MockServer: response sent with: "+parseInt(t.message||t.number));r.respond(parseInt(t.message||t.number))}}return true}});jQuery.each(n.navprops,function(t,n){v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/("+t+")/\\$count/?(.*)?"),response:function(t,r,n,s,a){e.debug("MockServer: incoming request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.GET+r+":before",{oXhr:t,sKeys:n,sNavProp:s,sUrlParams:a});o.fireEvent(u.HTTPMETHOD.GET+":before",{oXhr:t,sKeys:n,sNavProp:s,sUrlParams:a});var i={"Content-Type":"text/plain;charset=utf-8"};c(t,i);try{var f=d(r,n);if(f){var p,h={};p=o._resolveNavigation(r,f.entry,s);var v=o._mEntitySets[r].navprops[s].to.multiplicity;if(v==="*"){h={results:jQuery.extend(true,[],p)}}else{h=jQuery.extend(true,{},p[0])}if(p&&p.length!==0){if(a){var _=decodeURIComponent(a).replace("?","&").split("&");_=l(_);if(_.length>1){_=o._orderQueryOptions(_)}if(v==="*"){jQuery.each(_,function(e,t){o._applyQueryOnCollection(h,t,o._mEntitySets[r].navprops[s].to.entitySet,_)})}else{jQuery.each(_,function(e,t){h=o._applyQueryOnEntry(h,t,o._mEntitySets[r].navprops[s].to.entitySet)})}}}o.fireEvent(u.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:h});o.fireEvent(u.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:h});h.results=h.results||[];t.respond(200,i,""+h.results.length);e.debug("MockServer: response sent with: 200, "+h.results.length)}else{o._logAndThrowMockServerCustomError(404,o._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,i,JSON.stringify(r))}else{e.debug("MockServer: response sent with: "+parseInt(r.message||r.number));t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/("+t+")/?(\\?(.*))?"),response:function(t,r,n,s,a){e.debug("MockServer: incoming request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.GET+r+":before",{oXhr:t,sKeys:n,sNavProp:s,sUrlParams:a});o.fireEvent(u.HTTPMETHOD.GET+":before",{oXhr:t,sKeys:n,sNavProp:s,sUrlParams:a});var i={"Content-Type":"application/json;charset=utf-8"};c(t,i);try{var f=d(r,n);if(f){var p,h={};p=o._resolveNavigation(r,f.entry,s,f.entry);var v=o._mEntitySets[r].navprops[s].to.multiplicity;if(v==="*"){h={results:jQuery.extend(true,[],p)}}else{h=jQuery.extend(true,{},p[0])}if(p&&p.length!==0){if(a){var _=decodeURIComponent(a).replace("?","&").split("&");_=l(_);if(_.length>1){_=o._orderQueryOptions(_)}if(v==="*"){jQuery.each(_,function(e,t){o._applyQueryOnCollection(h,t,o._mEntitySets[r].navprops[s].to.entitySet,_)})}else{jQuery.each(_,function(e,t){h=o._applyQueryOnEntry(h,t,o._mEntitySets[r].navprops[s].to.entitySet)})}}}o.fireEvent(u.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:h});o.fireEvent(u.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:h});t.respond(200,i,JSON.stringify({d:h}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:h}))}else{o._logAndThrowMockServerCustomError(404,o._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,i,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}})});v.push({method:"POST",path:new RegExp("("+r+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(t,r,s,a,i){var f=false;if(t.requestHeaders["x-http-method"]==="MERGE"){f=true}e.debug("MockServer: incoming create request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.POST+r+":before",{oXhr:t,sKeys:a,sNavName:i});o.fireEvent(u.HTTPMETHOD.POST+":before",{oXhr:t,sKeys:a,sNavName:i});var c=null;var l=null;var v=405;try{if(a&&!a.split("=")[1]){a=o._mEntitySets[r].keys[0]+"="+a}var _=p(n,decodeURIComponent(a),i);if(_){var E=h(t,_,a,i);if(E){l={"Content-Type":"application/json;charset=utf-8"};o.fireEvent(u.HTTPMETHOD.POST+r+":after",{oXhr:t,oEntity:E});o.fireEvent(u.HTTPMETHOD.POST+":after",{oXhr:t,oEntity:E});if(f){var y=d(r,a);if(y){jQuery.extend(o._oMockdata[r][y.index],E)}v=204}else{var g=o._getRootUri()+_+"("+o._createKeysString(o._mEntitySets[_],E)+")";c=JSON.stringify({d:E,uri:g});o._oMockdata[_]=o._oMockdata[_].concat([E]);v=201}}}t.respond(v,l,c);e.debug("MockServer: response sent with: "+v+", "+c)}catch(r){if(r.error){var m={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,m,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"PUT",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,s,a){e.debug("MockServer: incoming update request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.PUT+r+":before",{oXhr:t,sKeys:s,sNavName:a});o.fireEvent(u.HTTPMETHOD.PUT+":before",{oXhr:t,sKeys:s,sNavName:a});var i=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(s),a);if(l){var v=h(t,l,s,a);if(v){c={"Content-Type":"application/json;charset=utf-8"};o.fireEvent(u.HTTPMETHOD.PUT+r+":after",{oXhr:t,oEntity:v});o.fireEvent(u.HTTPMETHOD.PUT+":after",{oXhr:t,oEntity:v});var _=d(r,s);if(_){o._oMockdata[r][_.index]=v}i=204}}t.respond(i,c,f);e.debug("MockServer: response sent with: "+i+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"MERGE",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,s,a){e.debug("MockServer: incoming merge update request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.MERGE+r+":before",{oXhr:t,sKeys:s,sNavName:a});o.fireEvent(u.HTTPMETHOD.MERGE+":before",{oXhr:t,sKeys:s,sNavName:a});var i=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(s),a);if(l){var v=h(t,l,s,a);if(v){c={"Content-Type":"application/json;charset=utf-8"};o.fireEvent(u.HTTPMETHOD.MERGE+r+":after",{oXhr:t,oEntity:v});o.fireEvent(u.HTTPMETHOD.MERGE+":after",{oXhr:t,oEntity:v});var _=d(r,s);if(_){jQuery.extend(o._oMockdata[r][_.index],v)}i=204}}t.respond(i,c,f);e.debug("MockServer: response sent with: "+i+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"PATCH",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,s,a){e.debug("MockServer: incoming patch update request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.PATCH+r+":before",{oXhr:t,sKeys:s,sNavName:a});o.fireEvent(u.HTTPMETHOD.PATCH+":before",{oXhr:t,sKeys:s,sNavName:a});var i=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(s),a);if(l){var v=h(t,l,s,a);if(v){c={"Content-Type":"application/json;charset=utf-8"};o.fireEvent(u.HTTPMETHOD.PATCH+r+":after",{oXhr:t,oEntity:v});o.fireEvent(u.HTTPMETHOD.PATCH+":after",{oXhr:t,oEntity:v});var _=d(r,s);if(_){jQuery.extend(o._oMockdata[r][_.index],v)}i=204}}t.respond(i,c,f);e.debug("MockServer: response sent with: "+i+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"DELETE",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,n,s){e.debug("MockServer: incoming delete request for url: "+t.url);o.fireEvent(u.HTTPMETHOD.DELETE+r+":before",{oXhr:t});o.fireEvent(u.HTTPMETHOD.DELETE+":before",{oXhr:t});var a=204;try{var i=d(r,n);if(i){o._oMockdata[r].splice(i.index,1)}else{a=400}o.fireEvent(u.HTTPMETHOD.DELETE+r+":after",{oXhr:t});o.fireEvent(u.HTTPMETHOD.DELETE+":after",{oXhr:t});t.respond(a,null,null);e.debug("MockServer: response sent with: "+a)}catch(r){if(r.error){var f={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,f,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}})});this.setRequests(v)};u.prototype._orderQueryOptions=function(e){var t,r,n,s,a,o,i,u,f,c,d=[];var p=this;jQuery.each(e,function(d,l){var h=e.indexOf(l);switch(l.split("=")[0]){case"$top":s=h;break;case"$skip":n=h;break;case"$orderby":a=h;break;case"$expand":i=h;break;case"$filter":t=h;break;case"$select":o=h;break;case"$inlinecount":r=h;break;case"$format":u=h;break;case"search-focus":c=h;break;case"search":f=h;break;default:if(l.split("=")[0].indexOf("$")===0){p._logAndThrowMockServerCustomError(400,p._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,l.split("=")[0])}}});if(i>=0){d.push(e[i])}if(t>=0){d.push(e[t])}if(c>=0){d.push(e[c])}if(f>=0){d.push(e[f])}if(r>=0){d.push(e[r])}if(a>=0){d.push(e[a])}if(n>=0){d.push(e[n])}if(s>=0){d.push(e[s])}if(o>=0){d.push(e[o])}if(u>=0){d.push(e[u])}return d};u.prototype._removeAllRequestHandlers=function(){var e=this.getRequests();var t=e.length;for(var r=0;r<t;r++){u._removeResponse(e[r].response)}};u.prototype._removeAllFilters=function(){for(var e=0;e<this._aFilters.length;e++){u._removeFilter(this._aFilters[e])}this._aFilters=null};u.prototype._addRequestHandler=function(t,r,n){t=t?t.toUpperCase():t;if(typeof t!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string")}if(!(typeof r==="string"||r instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression")}if(typeof n!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function")}var s=this._getRootUri();s=s&&new RegExp(this._escapeStringForRegExp(s));if(r&&!(r instanceof RegExp)){r=new RegExp(this._createRegExpPattern(r))}var a=this._createRegExp(s?s.source+r.source:r.source);this._addFilter(this._createFilter(t,a));this._oServer.respondWith(t,a,n);e.debug("MockServer: adding "+t+" request handler for pattern "+a)};u.prototype._createRegExp=function(e){return new RegExp("^"+e+"$")};u.prototype._createRegExpPattern=function(e){return e.replace(/:([\w\d]+)/g,"([^/]+)")};u.prototype._escapeStringForRegExp=function(e){return e.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&")};u.prototype._trim=function(e){return e&&e.replace(/^\s+|\s+$/g,"")};u.prototype._isValidNumber=function(e){if(/^([-+]?)0*(\d+)(\.\d+|)([eE][-+]?\d+[d]?|[mldf])?$/i.test(e)){var t=parseFloat(e);return!isNaN(t)&&isFinite(t)}return false};u.prototype._getDateTime=function(e){if(!e){return}return"datetime'"+new Date(Number(e.replace("/Date(","").replace(")/",""))).toJSON().substring(0,19)+"'"};u.prototype._getJsonDate=function(e){if(!e){return}var t=function(e){if(!o.test(e)){e+="Z"}e=e.replace(i,"$1");return new Date(e).getTime()};if(e.indexOf("datetimeoffset")>-1){return"/Date("+t(e.substring("datetimeoffset'".length,e.length-1))+")/"}else{return"/Date("+t(e.substring("datetime'".length,e.length-1))+")/"}};u.prototype._addFilter=function(e){this._aFilters.push(e);u._addFilter(e)};u.prototype._createFilter=function(e,t){return function(r,n,s,a,o){return e===r&&t.test(n)}};u.prototype._logAndThrowMockServerCustomError=function(t,r,n){if(r.indexOf("##")>-1&&n){r=r.replace("##","'"+n+"'")}e.error("MockServer: "+r);throw{error:{code:t,message:{lang:"en",value:r}}}};u.prototype.destroy=function(e){r.prototype.destroy.apply(this,arguments);this.stop();var t=u._aServers;var n=t.indexOf(this);t.splice(n,1)};u._aFilters=[];u._oServer=null;u._aServers=[];u._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true}return this._oServer};u.config=function(e){var t=this._getInstance();t.autoRespond=e.autoRespond===false?false:true;t.autoRespondAfter=e.autoRespondAfter||0;t.fakeHTTPMethods=e.fakeHTTPMethods||false};u.respond=function(){this._getInstance().respond()};u.startAll=function(){for(var e=0;e<this._aServers.length;e++){this._aServers[e].start()}};u.stopAll=function(){for(var e=0;e<this._aServers.length;e++){this._aServers[e].stop()}this._getInstance().restore();this._oServer=null};u.destroyAll=function(){this.stopAll();while(this._aServers.length>0){this._aServers[0].destroy()}};u.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};u._addFilter=function(e){this._aFilters.push(e)};u._removeFilter=function(e){this._aFilters.splice(this._aFilters.indexOf(e),1)};u._removeResponse=function(e){var t=this._oServer.responses;var r=t.length;for(var n=0;n<r;n++){if(t[n].response===e){t.splice(n,1);return true}}return false};function f(e){var t;Object.assign(e,{async:false,success:function(e,r,n){t={success:true,data:e,status:r,statusCode:n&&n.status}},error:function(e,r,n){t={success:false,data:undefined,status:r,error:n,statusCode:e.status,errorResponse:e.responseText}}});jQuery.ajax(e);return t}u._syncAjax=f;window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.FakeXMLHttpRequest.addFilter(function(e,t,r,n,s){var a=u._aFilters;for(var o=0;o<a.length;o++){var i=a[o];if(i(e,t,r,n,s)){return false}}return true});var c=function(e){if(/.*\.json$/i.test(e)){return"JSON"}if(/.*\.xml$/i.test(e)){return"XML"}if(/.*metadata$/i.test(e)){return"XML"}return null};window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(e,t,r){var n=f({url:r,dataType:"text"});if(!n.success){throw new Error("Could not load file from: "+r)}var s=n.data;var a=c(r);if(this["respond"+a]){this["respond"+a](e,t,s)}else{this.respond(e,t,s)}};window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(e,t,r){t=t||{};t["Content-Type"]=t["Content-Type"]||"application/json";this.respond(e,t,typeof r==="string"?r:JSON.stringify(r))};window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(e,t,r){t=t||{};t["Content-Type"]=t["Content-Type"]||"application/xml";this.respond(e,t,r)};return u});
//# sourceMappingURL=MockServer.js.map