/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/isPlainObject","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","sap/ui/core/util/XMLPreprocessor","sap/ui/core/XMLTemplateProcessor","sap/ui/util/XMLHelper"],function(t,e,n,o,r,i,a){"use strict";function s(t){return new Promise(function(e,n){sap.ui.require([t],function(t){e(t)},function(){n(new Error("Required control '"+t+"' couldn't be created asynchronously"))})})}return{bySelectorExtensionPointEnabled:function(t,e,n){return Promise.resolve(this.bySelector(t,e,n))},bySelectorTypeIndependent:async function(t,e,n){if(t?.name){n||=this.bySelector(t.viewSelector,e);const o=await this.getExtensionPointInfo(t.name,n);return o?o.parent:undefined}const o=this.getControlIdBySelector(t,e);return this._byId(o,n)},bySelector:function(t,e,n){const o=this.getControlIdBySelector(t,e);return this._byId(o,n)},getControlIdBySelector:function(t,e){if(!t){return undefined}if(typeof t==="string"){t={id:t}}let n=t.id;if(t.idIsLocal){if(e){if(typeof e==="string"){n=`${e}---${n}`}else{n=e.createId(n)}}else{throw new Error("App Component instance needed to get a control's ID from selector")}}return n},getSelector:function(t,e,n){let o=t;if(typeof o!=="string"){o=t?this.getId(t):undefined}else if(!e){throw new Error("App Component instance needed to get a selector from string ID")}if(n&&(n.id||n.idIsLocal)){throw new Error("A selector of control with the ID '"+o+"' was requested, "+"but core properties were overwritten by the additionally passed information.")}const r=this.checkControlId(o,e);if(!r){throw new Error("Generated ID attribute found - to offer flexibility a stable control ID is needed to assign the changes to, but for this control the ID was generated by SAPUI5 "+o)}const i=Object.assign({},n,{id:"",idIsLocal:false});if(this.hasLocalIdSuffix(o,e)){const t=e.getLocalId(o);i.id=t;i.idIsLocal=true}else{i.id=o}return i},checkControlId:function(t,e){const r=t instanceof n?t.getId():t;const i=o.isGeneratedId(r);return!i||this.hasLocalIdSuffix(t,e)},hasLocalIdSuffix:function(t,e){const o=t instanceof n?t.getId():t;if(!e){return false}return!!e.getLocalId(o)},_checkAndPrefixIdsInFragment:function(t,e){const n=a.getParseError(t);if(n.errorCode!==0){return Promise.reject(new Error(t.parseError.reason))}const o=t.documentElement;let r=[];let i=[];if(o.localName==="FragmentDefinition"){r=this._getElementNodeChildren(o)}else{r=[o]}i=[].concat(r);function s(t){i.push(t)}let c=Promise.resolve();for(let t=0,e=r.length;t<e;t++){c=c.then(this._traverseXmlTree.bind(this,s,r[t]))}return c.then(function(){for(let t=0,n=i.length;t<n;t++){if(i[t].getAttribute("id")){i[t].setAttribute("id",e+"."+i[t].getAttribute("id"))}else{throw new Error("At least one control does not have a stable ID")}}return o})},_getElementNodeChildren:function(t){const e=[];const n=t.childNodes;for(let t=0,o=n.length;t<o;t++){if(n[t].nodeType===1){e.push(n[t])}}return e},_getControlMetadataInXml:async function(t){const e=this._getControlTypeInXml(t).replace(/\./g,"/");const n=sap.ui.require(e)||await s(e);if(n?.getMetadata){return n.getMetadata()}else{throw new Error("getMetadata function is not available on control type")}},getControlMetadata:function(t){},getLibraryName:async function(t){const e=await this.getControlMetadata(t);return e.getLibraryName()},_getControlTypeInXml:function(t){let e=t.namespaceURI;e=e?e+".":"";e+=t.localName;return e},_traverseXmlTree:function(t,e){async function n(e,o){let r;if(!o){r=await this._getControlMetadataInXml(e,true)}const i=r&&await r.getAllAggregations();const a=this._getElementNodeChildren(e);let s=Promise.resolve();a.forEach(function(e){const o=i&&i[e.localName];s=s.then(function(){return n.call(this,e,o).then(function(){if(!o){t(e)}})}.bind(this))}.bind(this));return s}return n.call(this,e,false)},_getSerializedValue:function(t){if(this._isSerializable(t)&&typeof t!=="string"){return JSON.stringify(t)}return t},_isSerializable:function(e){return t(e)||Array.isArray(e)||Object(e)!==e},_escapeCurlyBracketsInString:function(t){return typeof t==="string"?t.replace(/({|})/g,"\\$&"):t},_templateFragment:function(t,e){return Promise.resolve(r.process(i.loadTemplate(t,"fragment"),{name:t},e))},getPropertyBindingOrProperty:function(t,e){const n=this.getPropertyBinding(t,e);if(n){return Promise.resolve(n)}return this.getProperty(t,e)},setPropertyBindingOrProperty:function(t,e,n){const o=n&&(n.path||n.parts);const r=n&&typeof n==="string"&&n.substring(0,1)==="{"&&n.slice(-1)==="}";const i=o||r?"setPropertyBinding":"setProperty";this[i](t,e,n)},setVisible:function(t,e){},getVisible:function(t){},setStashed:function(t,e){},getStashed:function(t){},bindProperty:function(t,e,n){},unbindProperty:function(t,e){},bindAggregation:function(t,e,n){},unbindAggregation:function(t,e){},setProperty:function(t,e,n){},getProperty:function(t,e){},isPropertyInitial:function(t,e){},setPropertyBinding:function(t,e,n){},getPropertyBinding:function(t,e){},createAndAddCustomData:function(t,e,n,o){},getCustomDataInfo:function(t,e){},createControl:function(t,e,n,o,r){},applySettings:function(t,e){},_byId:function(t,e){},getId:function(t){},getParent:function(t){},getControlType:function(t){},setAssociation:function(t,e,n){},getAssociation:function(t,e){},getAllAggregations:function(t){},getAggregation:function(t,e){},insertAggregation:function(t,e,n,o,r,i){},removeAggregation:function(t,e,n){},moveAggregation:function(t,e,n,o,r,i,a,s){},replaceAllAggregation:function(t,e,n){},removeAllAggregation:function(t,e){},getBindingTemplate:function(t,e){},updateAggregation:function(t,e){},findIndexInParentAggregation:function(t){},getParentAggregationName:function(t,e){},findAggregation:function(t,e){},validateType:function(t,e,n,o,r){},instantiateFragment:function(t,e,n){},templateControlFragment:function(t,e,n){},destroy:function(t){},getChangeHandlerModulePath:function(t){return this._getFlexCustomData(t,"flexibility")},_getFlexCustomData:function(t){},getFlexDelegate:function(t){let n;const o=this._getFlexCustomData(t,"delegate");if(typeof o==="string"){try{n=JSON.parse(o);if(n.payload===undefined){n.payload={}}}catch(n){e.error("Flex Delegate for control "+this.getId(t)+" is malformed",n.message)}}return n},getExtensionPointInfo:function(t,e){}}});
//# sourceMappingURL=BaseTreeModifier.js.map