/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../Control","../Element","./WebComponentMetadata","./WebComponentRenderer","sap/base/strings/hyphenate","sap/base/strings/camelize","../library","../LabelEnablement"],function(t,e,n,r,o,i,a,s){"use strict";var p=a.TextDirection;const u=a.ValueState;const f={[u.Error]:"Negative",[u.Warning]:"Critical",[u.Success]:"Positive",[u.Information]:"Information",[u.None]:"None"};const l=Object.fromEntries(Object.entries(f).map(([t,e])=>[e,t]));var d=function(t){if(t.id&&e.getElementById(t.id)){return e.getElementById(t.id)}};var h=function(t,e,n){if(e===undefined){e=0}if(n===undefined){n=2}if(t==null){return t}if(t instanceof window.HTMLElement){var r=d(t);return r?r:t}if(e<n){if(Array.isArray(t)){return t.map(h,e+1,n)}if(typeof t==="object"){var o={};for(var i in t){if(t.hasOwnProperty(i)){o[i]=h(t[i],e+1,n)}}return o}}return t};var c=t.extend("sap.ui.core.webc.WebComponent",{metadata:{stereotype:"webcomponent",abstract:true,library:"sap.ui.core",properties:{__isBusy:{type:"boolean",visibility:"hidden",defaultValue:false,mapping:{type:"property",to:"__is-busy"}}}},constructor:function(e,n){t.apply(this,arguments);this.__busyIndicatorTimeout=null;this.__onInvalidationBound=this.__onInvalidation.bind(this);this.__handleCustomEventBound=this.__handleCustomEvent.bind(this);this.__delegates={onBeforeRendering:this.__onBeforeRenderingDelegate,onAfterRendering:this.__onAfterRenderingDelegate};this.addDelegate(this.__delegates,true,this,false)},renderer:r},n);c.prototype._setSlot=function(t,e){var n=["tooltip","customData","layoutData","dependents","dragDropConfig"];if(t&&!n.includes(e)){var r=this.getMetadata().getAggregationSlot(e);t.__slot=r}};c.prototype._unsetSlot=function(t){if(t){delete t.__slot}};c.prototype.setAggregation=function(e,n,r){var o=t.prototype.setAggregation.apply(this,arguments);this._setSlot(n,e);return o};c.prototype.insertAggregation=function(e,n,r,o){var i=t.prototype.insertAggregation.apply(this,arguments);this._setSlot(n,e);return i};c.prototype.addAggregation=function(e,n,r){var o=t.prototype.addAggregation.apply(this,arguments);this._setSlot(n,e);return o};c.prototype.removeAggregation=function(e,n,r){var o=t.prototype.removeAggregation.apply(this,arguments);this._unsetSlot(o);return o};c.prototype.removeAllAggregation=function(e,n){var r=t.prototype.removeAllAggregation.apply(this,arguments);r.forEach(function(t){this._unsetSlot(t)},this);return r};c.prototype.__onBeforeRenderingDelegate=function(){this.__detachCustomEventsListeners()};c.prototype.__onAfterRenderingDelegate=function(){this.__attachCustomEventsListeners();var t=this.getDomRef();this.__updateObjectProperties(t);window.customElements.whenDefined(t.localName).then(function(){if(typeof t.attachInvalidate==="function"){t.attachInvalidate(this.__onInvalidationBound)}if(t._individualSlot){this.__slot=t._individualSlot}}.bind(this))};c.prototype.__updateObjectProperties=function(t){var e=this.getMetadata().getPropertiesByMapping("property");for(var n in e){if(this.isPropertyInitial(n)){continue}var r=e[n];var o=r.get(this);if(r.type==="object"||typeof o==="object"){var i=r._sMapTo?r._sMapTo:n;t[i]=o}}};c.prototype.setBusy=function(t){var e=this.getBusy();this.setProperty("busy",t,true);if(e!==t){if(t){this.__busyIndicatorTimeout=setTimeout(function(){this.setProperty("__isBusy",t)}.bind(this),this.getBusyIndicatorDelay())}else{this.setProperty("__isBusy",t);clearTimeout(this.__busyIndicatorTimeout)}}return this};c.prototype.__onInvalidation=function(t){if(t.type==="property"){var e=t.name;var n=t.newValue;var r=this.getMetadata().getProperty(e);if(r){if(r._fnMappingParser){n=this[r._fnMappingParser](n)}this.setProperty(e,n,true)}}};c.prototype.__attachCustomEventsListeners=function(){var t=this.getMetadata().getAllEvents();for(var e in t){var n=o(e);this.getDomRef().addEventListener(n,this.__handleCustomEventBound)}};c.prototype.__detachCustomEventsListeners=function(){var t=this.getDomRef();if(!t){return}var e=this.getMetadata().getAllEvents();for(var n in e){if(e.hasOwnProperty(n)){var r=o(n);t.removeEventListener(r,this.__handleCustomEventBound)}}};c.prototype.__handleCustomEvent=function(t){var e=t.type;var n=i(e);var r=this.__formatEventData(t.detail);var o=this.getMetadata().getEvent(n);var a=!o.fire(this,r);if(a){t.preventDefault()}};c.prototype.__formatEventData=function(t){if(typeof t==="object"){return h(t)}return{}};c.prototype.__callPublicMethod=function(t,n){if(!this.getDomRef()){throw new Error("Method called before custom element has been created by: "+this.getId())}var r=Array.from(n).map(function(t){if(t instanceof e){return t.getDomRef()}return t});var o=this.getDomRef()[t].apply(this.getDomRef(),r);if(typeof o==="object"){o=h(o)}return o};c.prototype.__callPublicGetter=function(t){if(!this.getDomRef()){throw new Error("Getter called before custom element has been created by: "+this.getId())}var e=this.getDomRef()[t];if(typeof e==="object"){e=h(e)}return e};c.prototype.destroy=function(){var e=this.getDomRef();this.__detachCustomEventsListeners();if(e&&typeof e.detachInvalidate==="function"){e.detachInvalidate(this.__onInvalidationBound)}return t.prototype.destroy.apply(this,arguments)};c.prototype._mapEnabled=function(t){return!t};c.prototype._mapTextDirection=function(t){if(t===p.Inherit){return null}return t.toLowerCase()};c.prototype._mapValueState=function(t){return f[t]};c.prototype._parseValueState=function(t){return l[t]};c.prototype._getAriaLabelledByForRendering=function(t){var e=s.getReferencingLabels(this);if(Array.isArray(t)){t.forEach(function(t){if(e.indexOf(t)<0){e.unshift(t)}})}return e.join(" ")};return c});
//# sourceMappingURL=WebComponent.js.map