/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./WebSocket","sap/base/Log"],function(e,t){"use strict";var r=e.extend("sap.ui.core.ws.SapPcpWebSocket",{constructor:function(t,r){e.apply(this,arguments)}});r.SUPPORTED_PROTOCOLS={v10:"v10.pcp.sap.com"};r._deserializeRegexp=/((?:[^:\\]|(?:\\.))+):((?:[^:\\\n]|(?:\\.))*)/;r._SEPARATOR="\n\n";r._MESSAGE="MESSAGE";r.prototype._onopen=function(){var e=false;if(this.getProtocol()===""){e=true}else{for(var i in r.SUPPORTED_PROTOCOLS){if(r.SUPPORTED_PROTOCOLS.hasOwnProperty(i)){if(r.SUPPORTED_PROTOCOLS[i]===this.getProtocol()){e=true;break}}}}if(e){this.fireOpen()}else{t.error("Unsupported protocol '"+this.getProtocol()+"' selected by the server. "+"Connection will be closed.");this.close("Unsupported protocol selected by the server")}};r.prototype._onmessage=function(e){var i=-1,n={};if(typeof e.data==="string"){i=e.data.indexOf(r._SEPARATOR)}if(i!==-1){n.pcpFields=this._extractPcpFields(e.data.substring(0,i));n.data=e.data.substr(i+r._SEPARATOR.length)}else{t.warning("Invalid PCP message received: "+e.data);n.pcpFields={};n.data=e.data}this.fireMessage(n)};r.prototype._extractPcpFields=function(e){var t=e.split("\n"),i=[],n={};for(var o=0;o<t.length;o++){i=t[o].match(r._deserializeRegexp);if(i&&i.length===3){n[this._unescape(i[1])]=this._unescape(i[2])}}return n};r.prototype._unescape=function(e){var t=e.split("\b"),r="";for(var i=0;i<t.length;i++){t[i]=t[i].replace(/\\\\/g,"\b").replace(/\\:/g,":").replace(/\\n/g,"\n").replace(/\u0008/g,"\\")}r=t.join("\b");return r};r.prototype._serializePcpFields=function(e,t,r){var i="",n="",o="";if(t==="string"){o="text"}else if(t==="blob"||t==="arraybuffer"){o="binary"}if(e&&typeof e==="object"){for(n in e){if(e.hasOwnProperty(n)&&n.indexOf("pcp-")!==0){i+=this._escape(n)+":"+this._escape(String(e[n]))+"\n"}}}return"pcp-action:"+r+"\npcp-body-type:"+o+"\n"+i+"\n"};r.prototype._escape=function(e){return e.replace(/\\/g,"\\\\").replace(/:/g,"\\:").replace(/\n/g,"\\n")};r.prototype.send=function(t,i){var n=typeof t,o="";o=this._serializePcpFields(i,n,r._MESSAGE);e.prototype.send.call(this,o+t);return this};return r});
//# sourceMappingURL=SapPcpWebSocket.js.map