/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define("sap/ui/debug/PropertyList",["sap/ui/base/DataType","sap/ui/base/EventProvider","sap/ui/core/Element","sap/ui/core/ElementMetadata","sap/base/util/isEmptyObject","sap/base/security/encodeXML"],function(e,t,a,n,s,o){"use strict";var i=t.extend("sap.ui.debug.PropertyList",{constructor:function(e,a,n){t.apply(this,arguments);this.oWindow=a;this.oParentDomRef=n;this.oCore=e;var s=window.top.document.createElement("link");s.rel="stylesheet";s.href=window.top.sap.ui.require.toUrl("sap/ui/debug/PropertyList.css");window.top.document.head.appendChild(s);this.onchange=i.prototype.onchange.bind(this);n.addEventListener("change",this.onchange);this.onfocus=i.prototype.onfocus.bind(this);n.addEventListener("focusin",this.onfocus);this.onkeydown=i.prototype.onkeydown.bind(this);n.addEventListener("keydown",this.onkeydown)}});i.prototype.exit=function(){this.oParentDomRef.removeEventListener("change",this.onchange);this.oParentDomRef.removeEventListener("focusin",this.onfocus);this.oParentDomRef.removeEventListener("keydown",this.onkeydown)};i.prototype.update=function(e){var t=this.sControlId=e.getParameter("controlId");this.oParentDomRef.innerHTML="";var o=a.getElementById(t);if(!o){this.oParentDomRef.innerHTML="Please select a valid control";return}var i=o.getMetadata(),r=[];r.push("Type : "+i.getName()+"<br >");r.push("Id : "+o.getId()+"<br >");r.push("<div class='sapDbgSeparator'>&nbsp;</div>");r.push("<table class='sapDbgPropertyList' cellspacing='1'><tbody>");while(i instanceof n){var p=this.getPropertyLikeSettings(i);if(!s(p)){if(i!==o.getMetadata()){r.push("<tr><td class='sapDbgPLSubheader' colspan=\"2\">BaseType: ");r.push(i.getName());r.push("</td></tr>")}this.renderSettings(r,o,p)}i=i.getParent()}r.push("</tbody></table>");this.oParentDomRef.innerHTML=r.join("");this.mHelpDocs={}};i.prototype.getPropertyLikeSettings=function(t){var a={};Object.values(t.getProperties()).forEach(function(e){a[e.name]=e});Object.values(t.getAggregations()).forEach(function(t){if(t.multiple===false&&t.altTypes&&t.altTypes.length&&e.getType(t.altTypes[0])!=null){a[t.name]=t}});return a};i.prototype.renderSettings=function(t,n,s){Object.values(s).forEach(function(s){var i=s.name,r=s.get(n),p=s.multiple===false?e.getType(s.altTypes[0]):s.getType();t.push("<tr><td>");t.push(i);t.push("</td><td>");var u="";if(p.getPrimitiveType().getName()==="boolean"){t.push("<input type='checkbox' data-name='"+i+"' ");if(r==true){t.push("checked='checked'")}t.push(">")}else if(p.isEnumType()){var l=p.getEnumValues();t.push("<select data-name='"+i+"'>");for(var c in l){t.push("<option ");if(c===r){t.push(" selected ")}t.push("value='"+o(c)+"'>");t.push(o(c));t.push("</option>")}t.push("</select>")}else{var h="";if(r===null){h="class='sapDbgComplexValue'";r="(null)"}else if(r instanceof a){h="class='sapDbgComplexValue'";if(Array.isArray(r)){r=r.join(", ")}else{r=String(r)}u=' title="This aggregation currently references an Element. You can set a '+p.getName()+' value instead"'}t.push("<input type='text' "+h+" value='"+o(""+r)+"'"+u+" data-name='"+i+"'>")}t.push("</td></tr>")})};i.prototype.onkeydown=function(e){var t=e.target;if(e.keyCode==13&&t.tagName==="INPUT"&&t.type==="text"){this.applyChange(t)}};i.prototype.onchange=function(e){var t=e.target;if(t.tagName==="SELECT"||t.tagName==="INPUT"){this.applyChange(t)}};i.prototype.onfocus=function(e){var t=e.target;if(t.tagName==="INPUT"&&t.dataset.name){if(t.style.color==="#a5a5a5"){t.style.color="";t.value=""}}};i.prototype.applyChange=function(t){var n=a.getElementById(this.sControlId),s=t.dataset.name,o=n.getMetadata().getPropertyLikeSetting(s);if(o){var i=t.type==="checkbox"?String(t.checked):t.value,r=o.multiple!=null?e.getType(o.altTypes[0]):o.getType();if(r){var p=r.parseValue(i);if(r.isValid(p)&&p!=="(null)"){o.set(n,p);t.classList.remove("sapDbgComplexValue")}}}};return i});
//# sourceMappingURL=PropertyList.js.map