/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/Control","sap/ui/Device","sap/ui/thirdparty/jquery","sap/m/library","sap/m/Button","sap/m/SearchField"],function(e,t,i,jQuery,n,a,r){"use strict";var s=t.extend("sap.ui.documentation.Search",{metadata:{library:"sap.ui.documentation",properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false},suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,singularName:"suggestionItem",forwarding:{getter:"_lazyLoadSearchField",aggregation:"suggestionItems"}}},events:{toggle:{parameters:{isOpen:{type:"boolean"}}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,t){var i=t.getWidth(),n,a,r;e.openStart("div",t);e.style("width",i);e.class("sapUiDocumentationSearch");e.openEnd();if(t.getIsOpen()){r=t._lazyLoadSearchField(true);a=t._lazyLoadClosingButton(true);e.renderControl(r);e.renderControl(a)}else{n=t._lazyLoadOpeningButton(true);e.renderControl(n)}e.close("div")}}});s.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField()}};s.prototype.onsapescape=function(e){var t=jQuery(window).width(),n=t>=i.media._predefinedRangeSets[i.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];if(this.getIsOpen()&&!n){this._toggleOpen(false)}};s.prototype.getValue=function(){return this._lazyLoadSearchField().getValue()};s.prototype.setValue=function(e){this._lazyLoadSearchField().setValue(e);return this};s.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%")};s.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%")};s.prototype.suggest=function(){this._lazyLoadSearchField().suggest()};s.prototype.attachSuggest=function(){r.prototype.attachSuggest.apply(this._lazyLoadSearchField(),arguments);return this};s.prototype._resizeSearchField=function(e){return new Promise(function(t,i){var n=this.$("searchField");if(!n.length){i()}if(n.css("max-width")===e){t()}n.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){t()});n.css("max-width",e)}.bind(this))};s.prototype._toggleOpen=function(e){this.setIsOpen(e);this.fireToggle({isOpen:e})};s.prototype._lazyLoadOpeningButton=function(e){if(!this.getAggregation("_openingButton")){var t=new a(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:n.ButtonType.Default,press:function(){this._toggleOpen(true)}.bind(this)}).addStyleClass("sapUiDemokitSearchOpeningButton sapMBarChild");this.setAggregation("_openingButton",t,e)}return this.getAggregation("_openingButton")};s.prototype._lazyLoadClosingButton=function(t){if(!this.getAggregation("_closingButton")){var i=new a(this.getId()+"-closingBtn",{text:e.getLibraryResourceBundle("sap.ui.documentation").getText("APP_SEARCH_FIELD_CLOSE"),type:n.ButtonType.Default,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);this.setValue("")}.bind(this))}.bind(this)}).addStyleClass("sapMBarChild");this.setAggregation("_closingButton",i,t)}return this.getAggregation("_closingButton")};s.prototype._lazyLoadSearchField=function(t){if(!this.getAggregation("_searchField")){var i=new r(this.getId()+"-searchField",{placeholder:e.getLibraryResourceBundle("sap.ui.documentation").getText("APP_HEADER_SEARCH_FIELD_PLACEHOLDER"),showSearchButton:true,search:function(e){var t=e.getParameters();t.id=this.getId();this.fireSearch(t)}.bind(this),liveChange:function(e){var t=e.getParameters();t.id=this.getId();this.fireLiveChange(t)}.bind(this)});i.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",i,t)}return this.getAggregation("_searchField")};s.prototype._updateValue=function(e){this._lazyLoadSearchField()._updateValue(e)};return s});
//# sourceMappingURL=Search.js.map