/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/CookiesConsentManager","sap/ui/documentation/sdk/controller/util/UsageTracker","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/ui/documentation/sdk/controller/util/URLUtil","sap/base/util/Version","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/util/DocumentationRouter","sap/m/ColumnListItem"],function(jQuery,e,t,i,s,o,n,r,a,l,u,c){"use strict";return e.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css"]},init:function(){this._oErrorHandler=new s(this);this.setModel(i.createDeviceModel(),"device");this.setModel(new o,"libsData");this.setModel(new o,"versionData");this.setModel(new o({includeDeprecated:false}),"searchData");e.prototype.init.apply(this,arguments);this.loadVersionInfo();this.getRouter().initialize()},getCookiesConsentManager:function(){if(!this._oCookiesConsentManager){const e={defaultConsentDialogComponentId:"sap.ui.documentation.sdk.cookieSettingsDialog"};this._oCookiesConsentManager=n.create(this,e)}return this._oCookiesConsentManager},getUsageTracker:function(){if(!this._oUsageTracker){this._oUsageTracker=new r(this)}return this._oUsageTracker},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;this._oCookiesConsentManager?.destroy();this._oCookiesConsentManager=null;this._oUsageTracker?.destroy();this._oUsageTracker=null;e.prototype.destroy.apply(this,arguments)},getContentDensityClass:function(){if(!this._sContentDensityClass){if(!t.support.touch){this._sContentDensityClass="sapUiSizeCompact"}else{this._sContentDensityClass="sapUiSizeCozy"}}return this._sContentDensityClass},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new a(this)}return this._oConfigUtil},getConfig:function(){return this.getManifestEntry("/sap.ui5/config")||{}},loadVersionInfo:function(){if(!this._oVersionInfoPromise){this._oVersionInfoPromise=new Promise(function(e,t){jQuery.ajax({async:true,url:c.getResourceOriginPath("resources/sap-ui-version.json"),dataType:"json",success:function(t){this._bindVersionModel(t);e(t)}.bind(this),error:function(e){t(e)}})}.bind(this))}return this._oVersionInfoPromise},_bindVersionModel:function(e){var t,i,s,o,n,r=c.getResourcesVersion();this.aAllowedMembers=["public","protected"];if(!e){return}t=u(e.version);o=t.getSuffix();i=/-SNAPSHOT$/i.test(o);s=e.gav&&/openui5/i.test(e.gav);if(c.isInternal(e)){n=true;this.aAllowedMembers.push("restricted")}this.getModel("versionData").setData({enableAdvancedCookieSettings:false,versionGav:e.gav,versionName:e.name,version:[t.getMajor(),t.getMinor(),t.getPatch()].join("."),fullVersion:e.version,openUi5Version:r||e.version,isOpenUI5:s,isSnapshotVersion:i,isDevVersion:i,isBetaVersion:!s&&!i&&/-beta$/i.test(o),isURLVersioned:!!l.parseVersion(document.location.href),isInternal:!!n,isDevEnv:/testsuite/.test(e.name),libraries:e.libraries,allowedMembers:this.aAllowedMembers})}})});
//# sourceMappingURL=Component.js.map