/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/NewsInfo","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/documentation/sdk/controller/util/LocaleHelper","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/documentation/library","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/Core","sap/ui/util/openWindow","sap/ui/documentation/sdk/model/formatter","sap/m/ResponsivePopover","sap/ui/documentation/sdk/controller/util/Highlighter","sap/m/Button","sap/m/Toolbar","sap/ui/documentation/sdk/util/Resources","sap/base/util/LoaderExtensions","sap/ui/documentation/sdk/controller/util/ThemePicker"],function(e,t,i,o,jQuery,n,s,a,r,h,u,l,c,p,g,d,f,_,v,S,m,w,y,P,D,b,C,V,M){"use strict";var A=function(e){return C.getResourcesVersion()&&!self["sap-ui-documentation-config"]?window.origin+e:C.getResourceOriginPath(e)};var I="Demo Kit - � SDK",T={topic:"Documentation - "+I,api:"API Reference - "+I,controls:"Samples - "+I,demoapps:"Demo Apps - "+I,resources:"Resources - "+I,home:I};var R=f.URLHelper,N=f.SplitAppMode,E=A("/neo-app.json"),k=A("/versionoverview.json"),L="about",U="change_version",O="settings",B="cookie_preferences",K="en_US",x="privacy",H="language",F="appearance",z="sitemap";return n.extend("sap.ui.documentation.sdk.controller.App",{formatter:w,_arrToTreeConverter:function(){var e,t=this._aNeoAppVersions.slice(),i=[],o=0,n="";for(var s=0;s<t.length;s++){n=t[s].groupTitle;o=0;e=[];while(t[s]&&t[s].groupTitle&&t[s].groupTitle===n){e.push(t[s]);o++;s++}s--;i.push({groupTitle:n,version:n+" ("+o+" versions)",nodes:e,path:e[0].path})}return i},onInit:function(){n.prototype.onInit.call(this);var e=new l({bCNICPShow:window.location.href.includes("sapui5.platform.sapcloud.cn"),busy:false,delay:0,device:p,bPhoneSize:false,bDesktopSize:false,bShowVersionSwitchButton:false,bLandscape:p.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window["sap-ui-documentation-hideTopicSection"],bHideApiSection:!!window["sap-ui-documentation-hideApiSection"],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://ui5.sap.com/versionoverview.html'>https://ui5.sap.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://ui5.sap.com/1.71.46/'>https://ui5.sap.com/1.71.46/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://sdk.openui5.org/versionoverview.html'>https://sdk.openui5.org/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sdk.openui5.org/1.71.46/'>https://sdk.openui5.org/1.71.46/</a>"});var t=this;M.init(t);this.MENU_LINKS_MAP={copyright:"https://www.sap.com/corporate/en/legal/copyright.html",trademark:"https://www.sap.com/corporate/en/legal/trademark.html",disclaimer:"https://help.sap.com/viewer/disclaimer",sitemap:"sitemap"};jQuery.extend(this.MENU_LINKS_MAP,n.LEGAL_LINKS);this.getOwnerComponent().loadVersionInfo().then(function(){var e;if(this.getModel("versionData").getProperty("/isOpenUI5")){e="OPENUI5"}else{e="SAPUI5"}I=I.replace("�",e);Object.keys(T).forEach(function(t){T[t]=T[t].replace("�",e)});if(this._sKey){this.appendPageTitle(null).appendPageTitle(T[this._sKey])}}.bind(this));this.oRouter=this.getRouter();this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this.oRouter.attachEvent("_navToWithoutHash",this.onNavToWithoutHash.bind(this));this._aNeoAppVersions=[];this._oView=this.getView();this.setModel(e,"appView");this._oNewsModel=new l;this.setModel(this._oNewsModel,"news");this._oSupportedLangModel=new l;this.setModel(this._oSupportedLangModel,"supportedLanguages");this.setModel(new l,"messagesData");this._demoKitPage=this.byId("demoKitPage");this._demoKitSubHeader=this.byId("demoKitSubHeader");this._demoKitSideNavigation=this.byId("demoKitSideNavigation");this._demoKitSplitApp=this.byId("splitApp");this._demoKitSplitApp._oDetailNav.setAutoFocus(false);this._demoKitSplitApp.attachEvent("afterMasterClose",function(t){e.setProperty("/bIsShownMaster",false)},this);this._requestVersionInfo();this.initSearch();a.init();this.setSurveyModelData();this.bus=i.getInstance();this.bus.subscribe("newsChanged","onDemoKitNewsChanged",this._syncNewsModelWithNewsInfo,this);this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;this._sLocalStorageNewsName=this._oConfigUtil.LOCAL_STORAGE_NAMES["OLD_NEWS_IDS"];s.prepareNewsData(this._oConfigUtil);this._createConfigurationBasedOnURIInput();this._oCookiesConsentManager=this.getOwnerComponent().getCookiesConsentManager();this._oCookiesConsentManager.checkUserAcceptsToPersistDisplaySettings(function(e){if(e&&this._aConfiguration.length>0){this._applyCookiesConfiguration(this._aConfiguration)}else{this._applyDefaultConfiguration(this._aConfiguration)}}.bind(this));this._oCookiesConsentManager.checkUserAcceptsUsageTracking(function(e){if(e){this._getVersionName().then(function(e){this.getOwnerComponent().getUsageTracker().start(e,this._aRouterCachedEventDetails);this._aRouterCachedEventDetails=[]}.bind(this))}}.bind(this));c.register(this._demoKitPage,this.onPageResize.bind(this))},onBeforeRendering:function(){p.orientation.detachHandler(this._onOrientationChange,this)},onAfterRendering:function(){jQuery(document.body).addClass(this.getOwnerComponent().getContentDensityClass());p.orientation.attachHandler(this._onOrientationChange,this);this._syncNewsModelWithNewsInfo();this._adjustVersionSwitchButton()},onExit:function(){p.orientation.detachHandler(this._onOrientationChange,this);if(this.highlighter){this.highlighter.destroy()}this._oCookiesConsentManager=null},onRouteChange:function(e){this._cacheRouteEventDetails(e);if(!this.oRouter.getRoute(e.getParameter("name"))._oConfig.target){return}var t=p.system.phone,i=e.getParameter("name"),o=this.oRouter.getRoute(i)._oConfig.target[0]+"Tab",n=this._oView.byId(o),s=n?n.getKey():"home",a=this.getModel("appView"),r=this.getOwnerComponent().getConfigUtil().hasMasterView(i);this._setHeaderSelectedKey(s);this._setSelectedSectionTitle(s);a.setProperty("/bHasMaster",r);if(t&&r){this.getOwnerComponent().getConfigUtil().getMasterView(i).then(function(e){var t=e?.getId();a.setProperty("/sMasterViewId",t)})}this._demoKitSplitApp.hideMaster();a.setProperty("/bIsShownMaster",false);this.appendPageTitle(null).appendPageTitle(T[s])},onNavToWithoutHash:function(e){this._cacheRouteEventDetails(e)},toggleMaster:function(e){var t=this.getModel("appView"),i=t.getProperty("/sMasterViewId"),o=this._demoKitSplitApp.getMode()===N.ShowHideMode,n=this._demoKitSplitApp.getMode()===N.HideMode,s=p.system.phone,a=e.getParameter("pressed"),r;if(!s&&(o||n)){r=a?this._demoKitSplitApp.showMaster:this._demoKitSplitApp.hideMaster;r.call(this._demoKitSplitApp);return}if(s){if(a){this._demoKitSplitApp.to(i)}else{this._demoKitSplitApp.backDetail()}}},navigateToSection:function(e){var t=e.getParameter("key")||e.getParameter("item").getKey(),i=e.getSource().isA("sap.tnt.SideNavigation");if(p.system.phone&&i){this.onSideNavigationButtonPress()}if(t&&t!=="home"){this.getRouter().navTo(t,{})}else{this.getRouter().navTo("welcome",{});this._setHeaderSelectedKey("home")}},navigateToNews:function(){this.getRouter().navTo("news")},onNewsButtonPress:function(e){var t=e.getSource(),i=this.getView();if(this._oNewsModel.getProperty("/newsCount")===0){this.navigateToNews()}else if(!this._oNewsPopover){g.load({name:"sap.ui.documentation.sdk.view.NewsPopover",controller:this}).then(function(e){i.addDependent(e);this._oNewsPopover=e;this._oNewsPopover.openBy(t)}.bind(this))}else{this._oNewsPopover.openBy(t)}},handleShowAllPress:function(){this._oNewsPopover.close();this.navigateToNews()},handleDismissAllPress:function(){s.moveAllNewItemsToOld()},handleNewsItemClose:function(e){var t=e.getSource(),i=t.getCustomData()[0].getValue(),o=this._oNewsModel.getProperty("/items").find(function(e){return e.id===i});s.moveNewItemToOld(o)},handleVisitNewsLink:function(e){var t=e.getSource(),i=t.getCustomData()[0].getValue();R.redirect(i,true)},_syncNewsModelWithNewsInfo:function(){var e,t=s.getPreparationFailureMessage();if(!t){e=s.getNewNewsArray().slice();this._oNewsModel.setProperty("/items",e);this._oNewsModel.setProperty("/newsCount",e.length)}this._oNewsModel.setProperty("/newsPreparationFailureMessage",t)},onMenuButtonItemSelected:function(e){var t=e.getParameter("item").getKey(),i=this.MENU_LINKS_MAP[t];if(t===L){this.aboutDialogOpen()}else if(t===O){this.settingsDialogOpen()}else if(t===x){this.navToPrivacyStatement()}else if(t===B){this.onEditCookiePreferencesRequest()}else if(t===U){this.onChangeVersionButtonPress()}else if(M._getTheme()[t]){this._updateAppearance(t)}else if(i===z){this.onSiteMapPress()}else if(i){R.redirect(i,true)}this.sTarget=i},createSearchPopover:function(){var e=f.PlacementType,t=this.getView().byId("searchControl"),i=new y({showArrow:false,showHeader:false,contentWidth:"600px",placement:e.Vertical,horizontalScrolling:false,initialFocus:this.getView().byId("searchControl-searchField")}).addStyleClass("sapMSltPicker-CTX");i.open=function(){i.openBy(t)};this.getView().addDependent(i);return i},createSearchPicker:function(){var e=p.system.phone?this.createSearchDialog():this.createSearchPopover();this.createSearchPickerContent().then(function(t){e.addContent(t)});return e},createSearchDialog:function(){var e,t,i,n,s,a,r;var h=this.getView().byId("searchControl");function u(){var i=h.getValue();if(i!==t){h._updateValue(i);h.fireLiveChange({newValue:i})}else{h.fireLiveChange({newValue:t})}e.close();h._toggleOpen(false)}function l(e){if(typeof e.selectionStart=="number"){e.selectionStart=e.selectionEnd=e.value.length}else if(typeof e.createTextRange!="undefined"){e.focus();var t=e.createTextRange();t.collapse(false);t.select()}}i=new(sap.ui.require("sap/m/SearchField"))({liveChange:function(e){var t=e.getParameter("newValue");h._updateValue(t);h.fireLiveChange({newValue:t})},search:function(t){if(!t.getParameter("clearButtonPressed")){e.close();r=true}}});a=new D({icon:"sap-icon://decline",press:function(){u()}});n=new b({content:[i,a]});s=new D({text:o.getResourceBundleFor("sap.m").getText("MSGBOX_OK"),press:function(){u()}});e=new(sap.ui.require("sap/m/Dialog"))({stretch:true,customHeader:n,beginButton:s,beforeClose:function(){h._bSuggestionSuppressed=true},beforeOpen:function(){t=h.getValue();i._updateValue(t);r=false},afterOpen:function(){var e=i.$().find("input");e.trigger("focus");l(e.get(0))},afterClose:function(e){if(r){h.fireSearch({query:h.getValue(),clearButtonPressed:false})}h._toggleOpen(false)}});this.getView().addDependent(e);return e},openSearchPicker:function(){if(!this.oPicker){this.oPicker=this.createSearchPicker()}if(!this.oPicker.isOpen()){this.oPicker.open()}},createSearchPickerContent:function(){return g.load({name:"sap.ui.documentation.sdk.view.GlobalSearchPicker",controller:this}).then(function(e){var i=t.getElementById("shortList"),o=this,n;i.addEventDelegate({onAfterRendering:function(){var e={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};o.highlighter=new P(i.getDomRef(),e);n=o.getModel("searchData").getProperty("/query");n&&o.highlighter.highlight(n);i.removeEventDelegate(this)}});return e}.bind(this))},initSearch:function(){var e=this.getModel("searchData"),t={topics:["topic","topicId","subTopicId"],entity:["sample","controlsMaster","controls","code","entity"],apiref:["api","apiSpecialRoute","apiId"]};this.oRouter.attachRouteMatched(function(){e.setProperty("/preferencedCategory",null)});Object.keys(t).forEach(function(i){var o=t[i];o.forEach(function(t){this.oRouter.getRoute(t).attachPatternMatched(function(){e.setProperty("/preferencedCategory",i)})}.bind(this))}.bind(this))},getSearchPickerTitle:function(e){var t=S.getLibraryResourceBundle("sap.ui.documentation"),i;switch(this.getModel("searchData").getProperty("/preferencedCategory")){case"topics":i=t.getText("SEARCH_SUGGESTIONS_TITLE_DOCUMENTATION");break;case"apiref":i=t.getText("SEARCH_SUGGESTIONS_TITLE_API_REFERENCE");break;case"entity":i=t.getText("SEARCH_SUGGESTIONS_TITLE_SAMPLES");break;default:i=t.getText("SEARCH_SUGGESTIONS_TITLE_ALL")}return i},formatSuggestionTitle:function(e,t){var i=e||"";if(t){i+=": "+t}return i},onSearchResultsSummaryPress:function(e){var t=e.oSource.data("category");this.navToSearchResults(t)},onSearchPickerItemPress:function(e){var t=e.oSource.getBindingContextPath(),i=this.getModel("searchData").getProperty(t),o=this.getOwnerComponent().getModel("searchData"),n=o.getProperty("/query"),s=i.category==="Documentation",a=i.external?new URL(i.path,document.baseURI).href:i.path;if(n&&s){a+=`?q=${encodeURIComponent(n)}`}if(i.external){m(a)}else{this.getRouter().parsePath(a)}this.oPicker.close()},_updateAppearance:function(e){var t=this;M._updateAppearance(e,t)},_createConfigurationBasedOnURIInput:function(){var e=new URLSearchParams(window.location.search);this._aConfiguration=[];if(!(e.has("sap-ui-language")||e.has("sap-language"))){this._aConfiguration.push(H)}if(!(e.has("sap-ui-theme")||e.has("sap-theme"))){this._aConfiguration.push(F)}},_applyDefaultConfiguration:function(){this._aConfiguration.forEach(function(t){if(t===H){e.setLanguage(K)}else if(t===F){this._updateAppearance("auto")}},this);this._oSupportedLangModel.setProperty("/selectedLang",e.getLanguage())},_applyCookiesConfiguration:function(){var e,t,i;for(i=0;i<this._aConfiguration.length;i++){t=this._aConfiguration[i];e=this._oConfigUtil.getCookieValue(t);if(e!==""){if(t===H){this._setSelectedLanguage(e)}else if(t===F){this._updateAppearance(e)}this._aConfiguration.splice(i,1);i--}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration()}},_prepareSupportedLangModelData:function(){return e.getLanguagesDeliveredWithCore().reduce(function(e,t){var i,o=t,n=t;if(typeof t==="string"&&t.length>0){switch(t){case"sh":o="sr_Latn";break;case"no":o="nb";break;case"iw":o="he";n="he";break;case"zh_TW":n="zh_Hant";break;case"zh_CN":n="zh_Hans";break}if(!r.hasRegion(t)){t=r.appendDefaultRegion(t)}e.push(new Promise(function(e,s){V.loadResource("sap/ui/core/cldr/"+o+".json",{async:true}).then(function(o){i=o.languages[n];e({text:typeof i==="string"?i.charAt(0).toUpperCase()+i.substring(1):"Unknown",key:t})})}))}return e},[])},_setSelectedLanguage:function(t){this._oSupportedLangModel.setProperty("/selectedLang",t);e.setLanguage(t);this._oCookiesConsentManager.checkUserAcceptsToPersistDisplaySettings(function(e){if(e){this._oConfigUtil.setCookie(H,t)}}.bind(this));if(this._sKey){this._setSelectedSectionTitle(this._sKey)}},_getSelectedLanguage:function(){return this._oSupportedLangModel.getProperty("/selectedLang")},settingsDialogOpen:function(){var e;if(!this._oSettingsDialog){g.load({name:"sap.ui.documentation.sdk.view.globalSettingsDialog",controller:this}).then(function(e){this._oView.addDependent(e);this._oSettingsDialog=e;t.getElementById("LanguageSelect").setSelectedKey(this._getSelectedLanguage());this._oSettingsDialog.open()}.bind(this))}else{this._oSettingsDialog.open()}if(!this._oSupportedLangModel.getProperty("/langs")){e=this._oSupportedLangModel;e.setProperty("/selectBusy",true);Promise.all(this._prepareSupportedLangModelData()).then(function(t){e.setProperty("/selectBusy",false);e.setProperty("/langs",t)})}},handleCloseAppSettings:function(){this._oSettingsDialog.close()},handleSaveAppSettings:function(){var e=t.getElementById("LanguageSelect").getSelectedKey();this._oSettingsDialog.close();this._applyAppConfiguration(e)},_applyAppConfiguration:function(e){this._setSelectedLanguage(e)},getAboutDialog:function(){return new Promise(function(e,t){if(!this._oAboutDialog){g.load({id:"aboutDialogFragment",name:"sap.ui.documentation.sdk.view.AboutDialog",controller:this}).then(function(t){this._oAboutDialog=t;this._oView.addDependent(this._oAboutDialog);e(this._oAboutDialog)}.bind(this))}else{e(this._oAboutDialog)}}.bind(this))},aboutDialogOpen:function(){this.getAboutDialog().then(function(e){e.getContent()[0].backToTop();e.open()})},aboutDialogClose:function(e){this.getAboutDialog().then(function(e){e.close()})},onAboutVersionDetails:function(e){var t=this.getModel("appView"),i=t.getData(),o=this;d._loadAllLibInfo("","_getLibraryInfo","",function(e,n){var s={};var a=d._getLibraryInfoSingleton();for(var r=0,h=e.length;r<h;r++){e[r]=n[e[r]];e[r].libDefaultComponent=a._getDefaultComponent(e[r])}s.libs=e;i.oVersionInfo=s;t.setData(i);o.setModel(t,"appView")});var n=g.byId("aboutDialogFragment","aboutNavCon"),s=g.byId("aboutDialogFragment","aboutDetail");n.to(s)},onAboutThirdParty:function(e){var t=this.getModel("appView"),i=t.getData(),o=this;d._loadAllLibInfo("","_getThirdPartyInfo",function(e,n){if(!e){return}var s={};s.thirdparty=[];for(var a=0;a<e.length;a++){var r=n[e[a]];for(var h=0;h<r.libs.length;h++){var u=r.libs[h];u._lib=e[a];s.thirdparty.push(u)}}s.thirdparty.sort(function(e,t){var i=(e.displayName||"").toUpperCase();var o=(t.displayName||"").toUpperCase();if(i>o){return 1}else if(i<o){return-1}else{return 0}});i.oThirdPartyInfo=s;t.setData(i);o.setModel(t,"appView")});var n=g.byId("aboutDialogFragment","aboutNavCon"),s=g.byId("aboutDialogFragment","aboutThirdParty");n.to(s)},_getReleaseDialog:function(){return new Promise(function(e){if(!this._oReleaseDialog){g.load({id:"releaseDialogFragment",name:"sap.ui.documentation.sdk.view.ReleaseDialog",controller:this}).then(function(t){this._oReleaseDialog=t;this._oView.addDependent(this._oReleaseDialog);e(this._oReleaseDialog)}.bind(this))}else{e(this._oReleaseDialog)}}.bind(this))},_getNotesView:function(){var e;return new Promise(function(t){if(!this._oNotesView){e=new l;g.load({id:"notesView",name:"sap.ui.documentation.sdk.view.ReleaseNotesView",controller:this}).then(function(i){this._oNotesView=i;this._oNotesView.setModel(e);t(this._oNotesView)}.bind(this))}else{t(this._oNotesView)}}.bind(this))},onReleaseDialogOpen:function(e){var t=d._getLibraryInfoSingleton(),i=e.getSource().data("version"),o=e.getSource().data("library"),n=new l;Promise.all([this._getReleaseDialog(),this._getNotesView()]).then(function(e){var s=e[0],a=e[1],r={};t._getReleaseNotes(o,i,function(e,t){var i={};if(e&&e[t]&&e[t].notes&&e[t].notes.length>0){r=e[t]}else{i.noData=true}a.getModel().setData(r);i.library=o;n.setData(i)});s.setModel(n);s.addContent(a);s.open()})},onReleaseDialogClose:function(e){this._getReleaseDialog().then(function(e){e.close()})},onAboutNavBack:function(e){var t=g.byId("aboutDialogFragment","aboutNavCon");t.back()},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().then(function(e){e.open()})},onCloseVersionDialog:function(){this.getVersionSwitchDialog().then(function(e){e.close()})},onChangeVersionDialogSearch:function(e){var i=e.getParameter("newValue"),o=new h("version",u.Contains,i),n=t.getElementById("versionList"),s=n.getBinding("items");s.filter([o]);if(s.getChildCount()===1){s.expand(0)}else{n.collapseAll()}},onHeaderLogoPress:function(){this._demoKitPage.setSideExpanded(false);this.oRouter.navTo("welcome",{})},onSiteMapPress:function(){this.oRouter.navTo("sitemap",{})},onLatestVersionItemPress:function(){if(C.getResourcesVersion()){window.sessionStorage.removeItem("versionPrefixPath");window.location.reload()}else{window.location.href="/"}},onVersionItemPress:function(e){var i=t.getElementById("versionList").getSelectedItem(),o=i.getCustomData()[0];if(o&&o.getKey()==="path"){if(C.getHasProxy()){window.sessionStorage.setItem("versionPrefixPath",o.getValue());window.location.reload()}else{window.location.href=o.getValue()}}},getVersionSwitchDialog:function(){return new Promise(function(e){if(!this._oChangeVersionDialog){g.load({name:"sap.ui.documentation.sdk.view.ChangeVersionDialog",controller:this}).then(function(t){this._oChangeVersionDialog=t;this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);e(this._oChangeVersionDialog)}.bind(this))}else{e(this._oChangeVersionDialog)}}.bind(this))},versionSwitchCustomComparator:function(e,t){return v(e).compareTo(v(t))},_updateVersionSwitchVisibility:function(){this.getModel("appView").setProperty("/bShowVersionSwitchButton",!!this._aNeoAppVersions.length)},_buildVersionDialogModel:function(){var e=new l;e.setSizeLimit(1e3);e.setData(this._aNeoAppVersions);e.setData(this._arrToTreeConverter(this._aNeoAppVersions));return e},launchSurvey:function(e,t){var i=this.byId(!t?"surveyButton":"aboutMenuButton"),o=this.getView(),n=this.getModel("appView"),s=n.getProperty("/bShowLongSurvey");if(!s){this.shortSurveyRedirect()}else if(!this._oSurveyPopover){g.load({name:"sap.ui.documentation.sdk.view.SurveyPopover",controller:this}).then(function(e){o.addDependent(e);this._oSurveyPopover=e;if(p.system.phone){this.addSurveyPopoverCloseBtn()}this._oSurveyPopover.openBy(i)}.bind(this))}else{this._oSurveyPopover.openBy(i)}},closeSurveyPopover:function(e){this._oSurveyPopover.close()},shortSurveyRedirect:function(){var e="?Release_version="+this._getUI5Version()+"&Source="+this._getUI5Distribution()+"&Type="+this._getUI5VersionType()+"&product=UI5%20Demo%20Kit"+"&product_filter=UI5"+"&cluster=BTP"+"&page="+encodeURIComponent(document.location.href);var t="https://sapinsights.eu.qualtrics.com/jfe/form/SV_byI4QeS7Ic2Psyi"+e,i="https://sapinsights.eu.qualtrics.com/jfe/form/SV_3Epqk1MLAUQVrwy"+e,o=!this.getModel("versionData").getProperty("/isDevEnv");R.redirect(o?t:i,true)},longSurveyRedirect:function(){var e="https://sapinsights.eu.qualtrics.com/jfe/form/SV_7X5P63Zg5zXC5zE",t="?product=UI5%20Demo%20Kit"+"&product_filter=UI5"+"&cluster=BTP"+"&page="+encodeURIComponent(document.location.href),i=e+t,o=e+t+"&Q_CHL=preview&Q_SurveyVersionID=current",n=!this.getModel("versionData").getProperty("/isDevEnv");R.redirect(n?i:o,true)},setSurveyModelData:function(){var e=this.getModel("appView"),t=new Date,i=t.getFullYear(),o=[[new Date(i,1,1),new Date(i,1,21)],[new Date(i,4,1),new Date(i,4,21)],[new Date(i,7,1),new Date(i,7,21)],[new Date(i,10,1),new Date(i,10,21)]],n=false,s;o.forEach(function(e){var i=e[0],o=e[1];if(t>=i&&t<=o){n=true;s=o.toLocaleDateString();return}});e.setProperty("/bShowLongSurvey",n);if(n){e.setProperty("/sLongSurveyLastDate",s)}},addSurveyPopoverCloseBtn:async function(){var e=await this.getModel("i18n").getResourceBundle(),t=this.closeSurveyPopover.bind(this),i=new D({text:e.getText("SURVEY_POPOVER_CLOSE_BTN"),press:t});this._oSurveyPopover.setEndButton(i)},onSearch:function(e){var t=encodeURIComponent(e.getParameter("query"));if(!t){return}this.getRouter().navTo("search",{searchParam:t},false);this.oPicker.close()},navToSearchResults:function(e){var t=this.getModel("searchData").getProperty("/query"),i={searchParam:t};if(!t){return}if(e){i["?options"]={category:e}}this.getRouter().navTo("search",i,true);this.oPicker.close()},onSearchLiveChange:function(e){var t=this.getModel("searchData"),i=e.getParameter("newValue"),o=t.getProperty("/preferencedCategory"),n=t.getProperty("/includeDeprecated");if(!i&&p.system.desktop){if(this.oPicker.isOpen()){this.oPicker.close()}return}this.openSearchPicker();if(this.highlighter){this.highlighter.highlight(i)}t.setProperty("/query",i);a.search(i,{preferencedCategory:o,includeDeprecated:n}).then(function(e){t.setProperty("/matches",e.matches)})},onPageResize:function(e){var t=e.size.width,i=t>=p.media._predefinedRangeSets[p.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1],o=t<p.media._predefinedRangeSets[p.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],n=this.getModel("appView");if(o!==n.getProperty("/bPhoneSize")){n.setProperty("/bPhoneSize",o);this._demoKitPage.setSideExpanded(false)}if(i!==n.getProperty("/bDesktopSize")){n.setProperty("/bDesktopSize",i);setTimeout(function(){this._updateSearchFieldState()}.bind(this),0)}},onSideNavigationButtonPress:function(){this._demoKitPage.setSideExpanded(!this._demoKitPage.getSideExpanded())},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",p.orientation.landscape)},onToggleSearchMode:function(e){var t=e.getParameter("isOpen"),i=this.getModel("appView");i.setProperty("/bSearchMode",t);if(t){setTimeout(function(){if(p.system.desktop){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus()}else{this.openSearchPicker()}}.bind(this),0)}},_getCurrentYear:function(){return(new Date).getFullYear()},_getCurrentQuarter:function(){var e=new Date,t=e.getMonth(),i=Math.floor(t/3)+1;return i},_filterVersionsPastEOCP:function(e){var t=e.patches;return t.filter(function(e){var t=e.extended_eocp||e.eocp||"";if(!t){return true}var i=/^Q[1-4]\/\d{4}$/i.test(t);if(!i){return true}var o=Number(t.substring(1,2)),n=Number(t.substring(3));return n>this._getCurrentYear()||n===this._getCurrentYear()&&o>=this._getCurrentQuarter()}.bind(this))},_processVersionOverview:function(e){var t=e.versions,i=[];if(Array.isArray(t)){t=t.filter(function(e){return!!e.hidden}).forEach(function(e){var t=e.hidden.split(",").map(function(e){return e.trim()});i=i.concat(t)})}return i},_processNeoAppJSON:function(e){var t=this.getModel("versionData"),i=t.getProperty("/isInternal"),o=t.getProperty("/isSnapshotVersion"),n=[];if(!(e&&e.routes)){_.warning("No versions were found");return}n=e.routes;n.pop();if(!i&&!o){n=n.filter(function(e){return e.target.version.indexOf("-beta")===-1})}n=n.map(function(e){var t=v(e.target.version),i={};i.patchVersion=t.getPatch();i.groupTitle=t.getMajor()+"."+t.getMinor();i.version=t.toString();i.path=e.path;return i});return n},_requestVersionInfo:function(){Promise.all([jQuery.ajax(E),jQuery.ajax(k)]).then(function(e){var t=this._processNeoAppJSON(e[0]),i=this._processVersionOverview(e[1]),o=this._filterVersionsPastEOCP(e[1]);if(Array.isArray(t)&&t.length>0){t=t.filter(function(e){return i.indexOf(e.version)===-1});t=t.filter(function(e){return o.find(function(t){return t.version===e.version})});this._aNeoAppVersions=t;this._updateVersionSwitchVisibility();this.getModel("versionData").setProperty("/latestVersion",this._aNeoAppVersions[0].version)}else{this._aNeoAppVersions=[];_.warning("No multi-version environment detected")}}.bind(this),function(){_.warning("No neo-app.json or versionoverview.json was detected")})},_getFullVersion:function(){return this.getModel("versionData").getProperty("/fullVersion")},_getUI5Version:function(){return C.getResourcesVersion()?window.sessionStorage.getItem("versionPrefixPath"):this.getModel("versionData").getProperty("/version")},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav")},_getUI5Distribution:function(){var e=this._getUI5VersionGav(),t="SAPUI5";if(e&&/openui5/i.test(e)){t="OpenUI5"}return t},_getUI5VersionType:function(){var e=this.getModel("versionData"),t=e.getProperty("/isInternal"),i=e.getProperty("/isSnapshotVersion"),o;switch(true){case i&&t:o="InternalSnapshot";break;case t:o="Internal";break;case i:o="Snapshot";break;default:o="Release"}return o},_getCurrentPageRelativeURL:function(){var e=window.location;return e.pathname+e.hash+e.search},_getCurrentURL:function(){var e=window.location;return e.href},_setHeaderSelectedKey:function(e){this._demoKitSubHeader.setSelectedKey(e);this._demoKitSideNavigation.setSelectedKey(e);this._sKey=e},_updateSearchFieldState:function(){var e=this.getModel("appView"),t=e.getProperty("/bDesktopSize"),i=this.byId("searchControl").getAggregation("_closingButton");if(t){e.setProperty("/bSearchMode",false);i.setVisible(false)}else{i.setVisible(true)}},_setSelectedSectionTitle:async function(e){var t=this.getModel("appView"),i=await this.getModel("i18n").getResourceBundle();var o=[{key:"home",text:i.getText("APP_TABHEADER_ITEM_HOME")},{key:"topic",text:i.getText("APP_TABHEADER_ITEM_DOCUMENTATION")},{key:"api",text:i.getText("APP_TABHEADER_ITEM_API_REFERENCE")},{key:"controls",text:i.getText("APP_TABHEADER_ITEM_SAMPLES")},{key:"demoapps",text:i.getText("APP_TABHEADER_ITEM_DEMO_APPS")},{key:"resources",text:i.getText("APP_TABHEADER_ITEM_RESOURCES")}];var n=o.find(function(t){return t.key===e});t.setProperty("/selectedSectionTitle",n.text)},_adjustVersionSwitchButton:function(){var e=this.byId("versionSwitchButton");if(e){e.addEventDelegate({onAfterRendering:function(){var t=e.getDomRef(),i=t.querySelector(".sapMBtnContent");if(i){if(!i.classList.contains("sapUiDemoKitHeaderActionsVersionSwitchTextContent")){i.classList.add("sapUiDemoKitHeaderActionsVersionSwitchTextContent")}}}})}}})});
//# sourceMappingURL=App.controller.js.map