/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/library","sap/ui/core/Core","sap/ui/core/Fragment","sap/ui/core/mvc/Controller","sap/ui/core/routing/History","sap/ui/model/resource/ResourceModel","sap/ui/Device","sap/m/library","sap/ui/documentation/sdk/controller/util/APIInfo","sap/base/strings/formatMessage","sap/ui/documentation/WebPageTitleUtil"],function(e,t,n,i,o,s,r,a,u,c,g){"use strict";var h=a.SplitAppMode;var l=a.URLHelper;var p=new g;var d=[];var f=i.extend("sap.ui.documentation.sdk.controller.BaseController",{_oCore:t,formatMessage:c,appendPageTitle:function(e){if(e===null){d=[]}else{if(d.indexOf(e)>=0){return this}d.length===2?d[0]=e:d.unshift(e)}p.setTitle(d.join(" - "));return this},onInit:function(){var e=new s({bundleName:"sap.ui.documentation.messagebundle",async:true});this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this.setModel(e,"i18n");if(r.system.phone||r.system.tablet){this.getOwnerComponent().loadVersionInfo()}this._aRouterCachedEventDetails=[]},hideMasterSide:function(){var e=this.getSplitApp();e.setMode(h.HideMode)},showMasterSide:function(){var e=this.getSplitApp();e.setMode(h.ShowHideMode)},getSplitApp:function(){return this.getView().getParent().getParent()},getRouter:function(){return this.getOwnerComponent().getRouter()},getModel:function(e){return this.getView().getModel(e)},setModel:function(e,t){return this.getView().setModel(e,t)},getConfig:function(){return this.getOwnerComponent().getConfig()||{}},onNavBack:function(e){var t=o.getInstance().getPreviousHash();if(t!==undefined){if(t.indexOf("search/")===0){this.getRouter().navTo("search",{searchParam:t.split("/")[1]},false)}else{history.go(-1)}}else{var n=window.location.hash;if(n.indexOf("#/topic/")==0){this.getRouter().navTo("topic",{},true)}else if(n.indexOf("#/api/")==0){this.getRouter().navTo("api",{},true)}}},searchResultsButtonVisibilitySwitch:function(e){var t=o.getInstance().getPreviousHash();if(t&&t.indexOf("search/")===0){e.setVisible(true)}else{e.setVisible(false)}},getRootView:function(){var e=this.getOwnerComponent();return e.byId(e.getManifestEntry("/sap.ui5/rootView").id)},onDisclaimerLinkPress:function(e){var t=e.getSource?e.getSource():e.target;if(!this.oDisclaimerPopover){n.load({name:"sap.ui.documentation.sdk.view.LegalDisclaimerPopover"}).then(function(e){this.getView().addDependent(e);this.oDisclaimerPopover=e;e.openBy(t)}.bind(this));return}else if(this.oDisclaimerPopover.isOpen()){this.oDisclaimerPopover.close()}this.oDisclaimerPopover.openBy(t)},_getControlComponent:function(t,n){var i=n.libComponentInfos,o=e._getLibraryInfoSingleton();return o._getActualComponent(i,t)},_onOrientationChange:function(e){var t=this.byId("phoneImage");if(r.system.phone&&t){t.toggleStyleClass("phoneHeaderImageLandscape",e.landscape)}},_registerOrientationChange:function(){r.orientation.attachHandler(this._onOrientationChange,this)},_deregisterOrientationChange:function(){r.orientation.detachHandler(this._onOrientationChange,this)},handleLandingImageLoad:function(){this.getView().byId("landingImageHeadline").setVisible(true)},handleFooterMasterItemPress:function(e){var t=e.getParameter("item").getKey();if(t===m.COOKIE_PREFERENCES){this.onEditCookiePreferencesRequest();return}if(t===m.PRIVACY){this.navToPrivacyStatement();return}var n=f.LEGAL_LINKS[t];l.redirect(n,true)},getAPIReferenceCheckPromise:function(e){return u.getIndexJsonPromise().then(function(t){function n(t){return t.some(function(t){var i=t.name===e;if(!i&&t.nodes){return n(t.nodes)}return i})}return n(t)})},onRouteNotFound:function(e){var t=this.getModel("i18n").getProperty("NOT_FOUND_TITLE");if(this._isRouteBypassedEvent(e)){this._cacheRouteEventDetails(e)}this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);setTimeout(this.appendPageTitle.bind(this,t));return},onEditCookiePreferencesRequest:function(){var e=this.getOwnerComponent().getCookiesConsentManager(),t;e.showPreferencesDialog(this.getView());if(!e.supportsWaitForPreferencesSubmission()){return}t=this.getOwnerComponent().getUsageTracker();e.waitForPreferencesSubmission().then(function(){e.checkUserAcceptsUsageTracking(function(e){if(e){this._getVersionName().then(t.start.bind(t))}else{t.stop()}}.bind(this));e.checkUserAcceptsToPersistDisplaySettings(function(e){if(!e){this._oConfigUtil.unsetCookie(this._oConfigUtil.COOKIE_NAMES.CONFIGURATION_APPEARANCE)}}.bind(this))}.bind(this))},navToPrivacyStatement:function(){this.getRouter().navTo("PrivacyStatement")},_getVersionName:function(){var e=this.getOwnerComponent();return e.loadVersionInfo().then(function(){return e.getModel("versionData").getProperty("/versionName")})},_isRouteBypassedEvent:function(e){return typeof e?.getId==="function"&&e.getId()==="bypassed"},_cacheRouteEventDetails:function(e){var t=Object.assign({eventId:e.getId()},e.getParameters());this._aRouterCachedEventDetails.push(t)}});const m={COOKIE_PREFERENCES:"cookie_preferences",LEGAL:"legal",PRIVACY:"privacy",TERMS_OF_USE:"terms_of_use",LICENSE:"license"};f.LEGAL_LINKS={[m.LEGAL]:"https://www.sap.com/corporate/en/legal/impressum.html",[m.PRIVACY]:"https://www.sap.com/corporate/en/legal/privacy.html",[m.TERMS_OF_USE]:"https://www.sap.com/corporate/en/legal/terms-of-use.html",[m.LICENSE]:"LICENSE.txt"};return f});
//# sourceMappingURL=BaseController.js.map