/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/EventBus","sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/Sorter","sap/ui/util/Storage","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/core/Fragment","sap/base/i18n/Localization","sap/ui/core/Theming"],function(t,jQuery,e,i,s,o,n,r,a,h,l,g,u,c,d){"use strict";var _="cozy",p="compact",f="condensed";return i.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:new l(l.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{densityMode:p,themeActive:"sap_horizon",rtl:false},_oDefaultSettings:{densityMode:p,themeActive:"sap_horizon",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:""},_mGroupFunctions:{name:function(t){var e=t.getProperty("name").charAt(0);return{key:e,text:e}},namespace:true,category:true,since:true,formFactors:true},_sFilterValue:"",onInit:function(){this._oList=this.byId("exploredMasterList");var i,n,r,a=function(t){this._oView.getModel().setData({entityCount:t.entityCount,entities:t.entities});this.getModel("filter").setData(t.filter);this._toggleListItem(this._getItemToSelect(),true)}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();o.loadData().then(a);i=new s;i.setSizeLimit(1e5);this._oView.setModel(i);n=new s({listMode:e.system.phone?"None":"SingleSelectMaster",listItemType:e.system.phone?"Active":"Inactive"});n.setDefaultBindingMode("OneWay");this._oView.setModel(n,"viewModel");r=new s;r.setSizeLimit(1e5);this.setModel(r,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("codeFile").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._fnBoundScrollToSelectedListItem=this._scrollToSelectedListItem.bind(this);this._fnBoundOnLocalizationChange=this._onLocalizationChange.bind(this);this._getList().addEventDelegate({onAfterRendering:function(){setTimeout(this._fnBoundScrollToSelectedListItem,this._iDomRenderingDelay)}},this);d.attachApplied(this._fnBoundScrollToSelectedListItem);c.attachChange(this._fnBoundOnLocalizationChange);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();switch(this._oComponent.getContentDensityClass()){case"sapUiSizeCompact":this._oViewSettings.densityMode=p;break;case"sapUiSizeCondensed":this._oViewSettings.densityMode=f;break;default:this._oViewSettings.densityMode=_}this._oViewSettings.rtl=c.getRTL();this._oDefaultSettings.densityMode=this._oViewSettings.densityMode;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();this.bus=t.getInstance();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this)},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new g(this._oList.getDomRef(),{shouldBeObserved:true})}},onDemoKitThemeChanged:function(t,e,i){this._oDefaultSettings.themeActive=i.sThemeActive},_initListSettings:function(){var t=this._oStorage.get(this._sStorageKey);if(t){this._oListSettings=JSON.parse(t)}},_onGroupMatched:function(t){this._onMatched("#/group/",t)},_onEntityMatched:function(t){this._onMatched("#/entity/",t)},_onSampleMatched:function(t){this._onMatched("#/sample/",t)},_onMatched:function(t,e){var i=this._getList().getModel(),s=e.getParameter("arguments").entityId;this.showMasterSide();this._topicId=t+s;this._entityId=s;i.refresh();this._updateListSelection()},_onControlsMasterMatched:function(t){this.showMasterSide();if(!e.system.phone){this.getRouter().navTo("controls")}},_onFilterMatched:function(t){var i=t.getParameter("arguments").value,s;if(i){i=decodeURI(i);s=this.byId("searchField");s.setValue(i).fireLiveChange({newValue:i});setTimeout(function(){this.getSplitApp().showMaster()}.bind(this),0);if(e.system.phone){this.getRouter().navTo("controlsMaster",{})}}this._onControlsMatched(t)},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();if(e.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus()}.bind(this),0)}},_onLocalizationChange:function(t){this._iDomRenderingDelay=3e3;setTimeout(function(){this._iDomRenderingDelay=0}.bind(this),this._iDomRenderingDelay)},onNavToEntity:function(t){var e=t.getParameter("listItem"),i=e?e:t.getSource(),s=i.getBindingContext().getPath(),o=this.getView().getModel().getProperty(s);this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:o.id,part:"samples"})},getGroupHeader:function(t){return new n({title:t.key})},_updateListSelection:function(){var t=this._getItemToSelect();if(!t){return}this._toggleListItem(t,true);if(!this._bNavToEntityViaList){setTimeout(this._fnBoundScrollToSelectedListItem,0)}this._bNavToEntityViaList=false},_resetListSelection:function(){var t=this._getList().getSelectedItem();if(t){this._toggleListItem(t,false);setTimeout(this._scrollPageTo.bind(this,0,0),0)}},_toggleListItem:function(t,e){this._getList().setSelectedItem(t,e,false)},_scrollToSelectedListItem:function(){var t=this._getList().getSelectedItem();if(t){this._getPage().scrollToElement(t,this.LIST_SCROLL_DURATION)}},_scrollPageTo:function(t,e){this._getPage().scrollTo(t,e)},_getItemToSelect:function(){var t=this._getList(),e=t.getModel(),i,s,o,n=this._entityId,r=null;t.getItems().forEach(function(t){s=t.getBindingContext();if(s){o=s.getPath();i=e.getProperty(o);if(i.id===n){r=t;return false}}});return r},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage")}return this.oPage},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList")}return this.oList},onBeforeFirstShow:function(){this._updateView()},onExit:function(){d.detachApplied(this._fnBoundScrollToSelectedListItem);c.detachChange(this._fnBoundOnLocalizationChange);this.highlighter.destroy()},onConfirmViewSettings:function(t){var e=t.getParameter("groupItem");this._oListSettings.filter=t.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=e?e.getKey():null;this._oListSettings.groupDescending=t.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView()},getViewSettingsDialog:function(){return new Promise(function(t){if(!this._oVSDialog){u.load({id:this.getView().getId(),name:"sap.ui.documentation.sdk.view.viewSettingsDialog",controller:this}).then(function(e){this._oVSDialog=e;this.getView().addDependent(this._oVSDialog);t(this._oVSDialog)}.bind(this))}else{t(this._oVSDialog)}}.bind(this))},handleListSettings:function(){this.getViewSettingsDialog().then(function(t){t.setSelectedFilterCompoundKeys(this._oListSettings.filter);t.setSelectedGroupItem(this._oListSettings.groupProperty);t.setGroupDescending(this._oListSettings.groupDescending);t.open()}.bind(this))},handleListFilter:function(t){this._sFilterValue=t.getParameter("newValue").trim();if(this.highlighter){this.highlighter.highlight(this._sFilterValue)}this._updateView()},_updateListBinding:function(){var t,e,i=[],s=[],o=false,n=false,l=this._oView.byId("exploredMasterList"),g=l.getBinding("items"),u;if(this._oListSettings.groupProperty==="since"){u=function(t,e){const i=t.split(".").map(Number);const s=e.split(".").map(Number);for(let t=0;t<Math.max(i.length,s.length);t++){const e=i[t]||0;const o=s[t]||0;if(e<o){return-1}else if(e>o){return 1}}return 0}}o=true;i.push(new r("searchTags",a.Contains,this._sFilterValue));jQuery.each(this._oListSettings.filter,function(t,e){var s=[];jQuery.each(e,function(e,i){var o=t==="formFactors"?a.Contains:a.EQ;s.push(new r(t,o,e))});o=true;i.push(new r(s,false))});if(o&&i.length===0){g.filter(i,"Application")}else if(o&&i.length>0){t=new r(i,true);g.filter(t,"Application")}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){n=true}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){n=true}if(n){e=new h(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty],u);s.push(e);s.push(new h("name",false));g.sort(s)}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding()},_updateFilterBarDisplay:function(){var t=[];jQuery.each(this._oListSettings.filter,function(e,i){t=t.concat(Object.keys(i))});if(t.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(t.join(", "))}else{this._vsFilterBar.setVisible(false)}}})});
//# sourceMappingURL=ControlsMaster.controller.js.map