/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/MessageToast","sap/m/MessageBox","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ResourceDownloadUtil","sap/ui/documentation/sdk/model/formatter","sap/ui/documentation/sdk/model/libraryData","sap/ui/model/json/JSONModel","sap/ui/core/util/File","sap/ui/thirdparty/jszip","sap/ui/util/openWindow"],function(e,t,o,n,a,i,s,r,c,d,l){"use strict";return n.extend("sap.ui.documentation.sdk.controller.DemoApps",{formatter:i,onInit:function(){n.prototype.onInit.call(this);this.processDemoAppsData();this.getRouter().getRoute("demoapps").attachPatternMatched(this.onPatternMatched,this)},processDemoAppsData:function(){s.getDemoAppsData().then(function(e){var t=this.flattenDemoAppsCategories(e),o=[];t.demoAppsByCategory.forEach(function(e){e.rows.forEach(function(e){o.push(e)})});t.demoApps=o;var n=new r(t);this.setModel(n);this.addCategoryClassToGridItems("sapUiDemoKitDemoAppsMain")}.bind(this))},flattenDemoAppsCategories(e){e.demoAppsByCategory.forEach(function(e){e.rows=[].concat.apply([],e.rows)});return e},addCategoryClassToGridItems(e){this.byId(e).getItems().forEach(function(e){var t=e.data("demoAppsCategoryClass");e.addStyleClass(t)})},createArchive:function(e,t){c.save(e,t,"zip","application/zip")},onPatternMatched:function(){this.hideMasterSide()},onReadMoreButtonPress:function(){var e="topic/a3ab54ecf7ac493b91904beb2095d208",t=i.formatHttpHrefForNewWindow(e);l(t,"_blank")},onDownloadPress:function(t){var o=t.getSource().getParent();fetch(o.data("config")).then(function(e){return e.json()}).then(this.processFiles.bind(this,o)).catch(function(t){e.error("Error: ",t);this.handleError("An error occurred: "+t.message)}.bind(this))},processFiles:function(e,t){var o=[],n=[],a=new d,i=t.files;i.forEach(function(e){var i=this.handleFilePromise(e,a,o,t);n.push(i)}.bind(this));this.addLicenseFileToZip(n,a);this.handlePromisesCompletion(n,o,a,e)},handleFilePromise:function(e,t,o,n){var i=a.fetch(n.cwd+e);var s=new Promise(function(n){i.then(function(o){if(!e.startsWith("../")){t.file(e,o,{base64:false,binary:true})}n()}).catch(function(){o.push(e);n()})});return s},
/**
		 * Adds the license file to the zip file.
		 *
		 * @param {Array} aPromises - The array of promises.
		 * @param {object} oZipFile - The zip file.
		 */
addLicenseFileToZip:function(e,t){var o=sap.ui.require.toUrl("LICENSE.txt").replace("resources/",""),n=a.fetch(o),i=new Promise(function(e,o){n.then(function(o){t.file("LICENSE.txt",o);e()}).catch(function(){e()})});e.push(i)},handlePromisesCompletion:function(e,o,n,a){Promise.all(e).then(function(){var e;if(o.length){var i=o.reduce(function(e,t){return e+t+"\n"},"Could not locate the following download files:\n");this.handleWarning(i)}e=typeof a.getLabel==="function"?a.getLabel():a.data("label");t.show('Downloading for app "'+e+'" has been started');var s=n.generate({type:"blob"});this.createArchive(s,e)}.bind(this))},handleError:function(e){o.error(e)},handleWarning:function(e){o.warning(e)}})});
//# sourceMappingURL=DemoApps.controller.js.map