/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/core/Theming","sap/ui/documentation/sdk/controller/SampleBaseController","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/m/BusyDialog","sap/m/Text","sap/ui/core/HTML","sap/m/library","sap/base/Log","sap/ui/core/Fragment","sap/ui/documentation/sdk/util/Resources","./config/sampleForwardingConfig","sap/base/strings/capitalize","sap/base/i18n/Localization"],function(e,t,i,n,s,a,o,r,l,d,h,m,u,p,c,g,f,I,_,S){"use strict";var y=p.URLHelper;var w=["sap-ui-rtl","sap-ui-language"];return n.extend("sap.ui.documentation.sdk.controller.Sample",{onInit:function(){n.prototype.onInit.call(this);this.oRouter=this.getRouter();this._attachPaternMatched();this.oModel=new s({showNavButton:true,showNewTab:false,rtaLoaded:false,density:this.getOwnerComponent().getContentDensityClass(),rtl:S.getRTL(),theme:i.getTheme(),showWarning:false});this._sId=null;this._sEntityId=null;this.getView().setModel(this.oModel);this.bus=t.getInstance();this.setDefaultSampleTheme();this.getOwnerComponent()._sSampleIframeOrigin=f.getConfig()!=="."?f.getResourceOrigin():window.origin},_attachPaternMatched:function(){this.oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this)},_onSampleMatched:function(e){this._sId=e.getParameter("arguments").sampleId;this._sEntityId=e.getParameter("arguments").entityId;this.byId("page").setBusy(true);if(I[this._sId]){return this.oRouter.navTo("sample",{entityId:I[this._sId].entityId,sampleId:I[this._sId].sampleId},true)}this.getModel("appView").setProperty("/bHasMaster",false);l.loadData().then(this._loadSample.bind(this))},_loadSample:function(e){var t=window.location.search,i=t.includes("dk-sample-standalone"),n=this._getPage(),s=this.oModel.getData(),a=e.samples[this._sId],o;if(!a){setTimeout(function(){n.setBusy(false)},0);this.onRouteNotFound();return}this.entityId=this._sEntityId?this._sEntityId:a.entityId;this._sLib=a.library;s.sEntityId=this.entityId;if(i){this._handleRedirect()}if(a.previousSampleId||a.nextSampleId){s.previousSampleId=a.previousSampleId;s.nextSampleId=a.nextSampleId}if(a.contexts){o=a.contexts[this.entityId];if(o){s.previousSampleId=o.previousSampleId;s.nextSampleId=o.nextSampleId}else{this.onRouteNotFound();return}}s.title="Sample: "+a.name;s.showNewTab=true;s.id=a.id;s.name=a.name;s.details=a.details;s.description=a.description;s.showSettings=true;var r=this._getChangedSamplesLocalStorage();if(r&&JSON.parse(r).indexOf(a.id)>-1){s.showWarning=true}else{s.showWarning=false}this._createIframe().then(function(e){this.getOwnerComponent()._oCurrentOpenedSample=this._oHtmlControl;if(e){s.stretch=e.stretch;s.includeInDownload=e.additionalDownloadFiles;s.customIndexHTML=e.customIndexHTML;if(e.files){var t=sap.ui.require.toUrl(a.id.replace(/\./g,"/"));s.files=[];for(var i=0;i<e.files.length;i++){var o=e.files[i];s.files.push({name:o});this._updateFileContent(t,o)}}s.iframe=e.iframe||null;n.setProperty("enableScrolling",!!e.stretch,true)}this.getAPIReferenceCheckPromise(a.entityId).then(function(e){this.getView().byId("apiRefButton").setVisible(e)}.bind(this));this.oModel.setData(s);this.appendPageTitle(this.getModel().getProperty("/name"))}.bind(this)).catch(function(e){n.removeAllContent();n.addContent(new m({text:"Error while loading the sample: "+e}))}).finally(function(){setTimeout(function(){n.setBusy(false)},0)})},_handleRedirect:function(){this._initIframeURL();this._applySearchParamValueToIframeURL("sap-ui-theme",this._sDefaultSampleTheme);this.sIFrameUrl+="&dk-sample-standalone";y.redirect(this.sIFrameUrl,false)},_initIframeURL:function(){var e=f.getConfig(),t=f.getResourcesVersion(),i="";w.forEach(function(e,t){if(new URL(document.location.href).searchParams.get(e)){i+=(i===""?"?":"&")+e+"="+new URL(document.location.href).searchParams.get(e)}});i=(i===""?"?":i+"&")+"sap-ui-xx-sample-id="+this._sId+"&sap-ui-xx-sample-lib="+(this._sLib||"")+"&sap-ui-xx-sample-origin="+e+t+"&sap-ui-xx-dk-origin="+window.location.origin;this.sIFrameUrl=f.getResourceOrigin()+"/resources/sap/ui/documentation/sdk/index.html"+i},getSettingsDialog:function(){return new Promise(function(e,t){if(!this._oSettingsDialog){g.load({id:"sample",name:"sap.ui.documentation.sdk.view.appSettingsDialog",controller:this}).then(function(t){this._oSettingsDialog=t;this._oSettingsDialog.setModel(this._oMessageBundle,"i18n");e(this._oSettingsDialog)}.bind(this))}else{e(this._oSettingsDialog)}}.bind(this))},_getChangedSamplesLocalStorage:function(){return localStorage.getItem("dk_changed_samples")},_setChangedSamplesLocalStorage:function(e){localStorage.setItem("dk_changed_samples",e)},handleSettings:function(){if(!this._oMessageBundle){this._oMessageBundle=new a({bundleName:"sap.ui.documentation.messagebundle"})}this.getSettingsDialog().then(function(e){this.loadSampleSettings(this.applySampleSettings.bind(this));return e}.bind(this)).then(function(e){e.open()}).catch(function(e){c.error(e)})},applySampleSettings:function(t){if(t.data.type==="SETTINGS"){var i=e.getElementById("sample--ThemeSelect");i.setSelectedKey(t.data.data.theme);e.getElementById("sample--RTLSwitch").setState(t.data.data.RTL);e.getElementById("sample--DensityModeSwitch").setSelectedKey(this._presetDensity(t.data.data.density,true))}},loadSampleSettings:function(e){return new Promise(function(t,i){var n=this._oHtmlControl.getDomRef();n.contentWindow.postMessage({type:"SETTINGS",reason:"get"},this.getOwnerComponent()._sSampleIframeOrigin);window.addEventListener("message",s);function s(i){e(i);window.removeEventListener("message",s);t()}setTimeout(function(){i("The sample iframe is not loading settings")},3e3)}.bind(this))},handleCloseAppSettings:function(){this._oSettingsDialog.close()},handleSaveAppSettings:function(){var t=e.getElementById("sample--DensityModeSwitch").getSelectedKey(),i=e.getElementById("sample--ThemeSelect").getSelectedKey(),n=e.getElementById("sample--RTLSwitch").getState();this._oSettingsDialog.close();if(!this._oBusyDialog){this._oBusyDialog=new h;this._handleBusyDialog()}else{this._handleBusyDialog()}this._applyAppConfiguration(i,t,n);this._saveLocalSettings(i,t,n)},_saveLocalSettings:function(e,t,i){t=this._presetDensity(t);this.oModel.setData({theme:e,rtl:i,density:t},true)},_presetDensity:function(e,t){return t?e.slice(9).toLowerCase():"sapUiSize"+_(e)},_applyAppConfiguration:function(e,t,i){var n=this._oHtmlControl.getDomRef();if(this.getModel().getProperty("/iframe")){this._setStandAloneIndexIframeSetting(e,t,i)}else{t=this._presetDensity(t);n.contentWindow.postMessage({type:"SETTINGS",reason:"set",data:{density:t,RTL:i,theme:e}},this.getOwnerComponent()._sSampleIframeOrigin)}},_setStandAloneIndexIframeSetting(e,t,i){this._applySearchParamValueToIframeURL("sap-ui-theme",e);this._applySearchParamValueToIframeURL("sap-ui-density",t);this._applySearchParamValueToIframeURL("sap-ui-rtl",i);this._oHtmlControl.getDomRef().src=this.sIFrameUrl},_handleBusyDialog:function(){this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close()}.bind(this),1e3)},_updateFileContent:function(e,t,i){this.fetchSourceFile(e+"/"+t,undefined,i).then(function(e){var i=this.oModel.getProperty("/files");i.some(function(i){if(i.name===t){i.raw=e;return true}});this.oModel.setProperty("/files",i)}.bind(this))},onAPIRefPress:function(){this.oRouter.navTo("apiId",{id:this.entityId})},onNewTab:function(){if(this.oModel.getProperty("/iframe")){y.redirect(this.sIFrameUrl,true);return}this.loadSampleSettings(function(e){this._applySearchParamValueToIframeURL("sap-ui-theme",e.data.data.theme);this._applySearchParamValueToIframeURL("sap-ui-rtl",e.data.data.RTL);this._applySearchParamValueToIframeURL("sap-ui-density",e.data.data.density)}.bind(this)).then(function(){y.redirect(this.sIFrameUrl,true)}.bind(this)).catch(function(e){c.error(e)})},onPreviousSample:function(e){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/previousSampleId")})},onNextSample:function(e){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/nextSampleId")})},onInfoSample:function(e){var t=e.getSource();if(!this._oPopover){g.load({name:"sap.ui.documentation.sdk.view.samplesInfo",controller:this}).then(function(e){this.getView().addDependent(e);this._oPopover=e;this._oPopover.openBy(t)}.bind(this))}else{this._oPopover.openBy(t)}},onWarningSample:function(e){var t=e.getSource();if(!this._oWarningPopover){g.load({name:"sap.ui.documentation.sdk.view.samplesWarning",controller:this}).then(function(e){this.getView().addDependent(e);this._oWarningPopover=e;this._oWarningPopover.openBy(t)}.bind(this))}else{this._oWarningPopover.openBy(t)}},_createIframe:function(){return new Promise(function(e,t){this.fResolve=e;this.fReject=t;this._initIframeURL();if(this._oHtmlControl){this._oHtmlControl.destroy()}this._oHtmlControl=this._createHTMLControl().addEventDelegate({onBeforeRendering:function(){window.removeEventListener("message",this.onMessage.bind(this))}.bind(this)}).addEventDelegate({onAfterRendering:function(){window.addEventListener("message",this.onMessage.bind(this))}.bind(this)});this._getPage().removeAllContent();this._getPage().addContent(this._oHtmlControl)}.bind(this))},_createHTMLControl:function(){return new u({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'})},_getPage:function(){return this.byId("page")},onMessage:function(e){if(e.origin!==this.getOwnerComponent()._sSampleIframeOrigin){return}if(e.source!==this._oHtmlControl.getDomRef().contentWindow){return}if(e.data.type==="INIT"){this.fnMessageInit(e)}else if(e.data.type==="ERR"){this.fnMessageError(e)}else if(e.data.type==="LOAD"){this.fnMessageLoad(e)}else if(e.data.type==="RTA"){this._loadRTA.call(this)}},fnMessageInit:function(e){var t=this.oModel.getData();if(e.data.config?.sample?.iframe){this.sIFrameUrl=sap.ui.require.toUrl(this._sId.replace(/\./g,"/"))+"/"+e.data.config.sample.iframe;this._setStandAloneIndexIframeSetting(t.theme,t.density,t.rtl)}this._oHtmlControl.getDomRef().contentWindow.postMessage({type:"SETTINGS",reason:"set",data:{density:t.density,RTL:t.rtl,theme:t.theme}},this.getOwnerComponent()._sSampleIframeOrigin);this.fResolve(e.data.config.sample)},fnMessageLoad:function(){c.info("Sample Iframe for sample "+this._sId+" is loaded")},fnMessageError:function(e){this.fReject(e.data.data.msg)},_createComponent:function(){var e="sampleComp-"+this._sId;var t=this._sId;var i=this.getOwnerComponent();var n=o.getComponentById(e);if(n){n.destroy()}return i.runAsOwner(function(){return o.create({id:e,name:t}).then(function(e){return new r({component:e})})})},setDefaultSampleTheme:function(){var e=f.getResourcesVersion();this._sDefaultSampleTheme=e&&parseInt(e.slice(3,5))<68?"sap_belize":i.getTheme()},onNavBack:function(e){this.oRouter.navTo("entity",{id:this.entityId})},onNavToCode:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this._sId},false)},onToggleFullScreen:function(e){d.updateMode(e,this.getView(),this)},_oRTA:null,_applySearchParamValueToIframeURL:function(e,t){var i=window.URL,n;try{n=new i(this.sIFrameUrl,document.location)}catch(e){c.warning("window.URL is not supported. The search param value won't be applied.");return}this.sIFrameUrl=this.sIFrameUrl.replace(n.search,"");n.searchParams.set(e,t);this.sIFrameUrl=this.sIFrameUrl+decodeURI(n.search)},_loadRTA:function(){var e=this.oModel.getData();e.rtaLoaded=true;this.oModel.setData(e,true);this.oRouter.attachRouteMatched(function(){if(this._oRTA){this._oRTA.destroy();this._oRTA=null}},this)},onToggleAdaptationMode:function(e){if(!this._oHtmlControl||!this._oHtmlControl.getDomRef()){return false}var t=this._oHtmlControl.getDomRef();t.contentWindow.postMessage({type:"RTA",data:{msg:"Start the RTA"}},this.getOwnerComponent()._sSampleIframeOrigin)},onRouteNotFound:function(){var e=this.getModel("i18n").getProperty("NOT_FOUND_SAMPLE_TITLE");this.oRouter.myNavToWithoutHash("sap.ui.documentation.sdk.view.SampleNotFound","XML",false);setTimeout(this.appendPageTitle.bind(this,e));return}})});
//# sourceMappingURL=Sample.controller.js.map